/* File vms_init.c
**
** This initialization module runs before the C main program is invoked
**
** 13-Apr-2003	Jean-Franois Pieronne
**
****************************************************************************/
#define __NEW_STARLET 1

#include <descrip.h>
#include <lib$routines.h>
#include <starlet.h>
#include <ssdef.h>
#include <iledef.h>
#include <signal.h>		/* DECC$CRTL_INIT()      */
#include <efndef.h>
#include <dvidef.h>
#include <devdef.h>
#include <stsdef.h>

#include <unixio.h>
#include <unixlib.h>
#include <stdlib.h>
#include <string.h>

#if  __CRTL_VER < 70301000 && __CRTL_VER >= 70300000
int   decc$feature_get_index(char *name);
char* decc$feature_get_name(int index);
int   decc$feature_get_value(int index, int mode);
int   decc$feature_set_value(int index, int mode, int value);
#endif

/*
** Force a reference to LIB$INITIALIZE to ensure it
** exists in the image.
*/
#define lib$initialize LIB$INITIALIZE
int lib$initialize(void);
int (*lib_initialize_entry)() = lib$initialize;

static int set_feature_default(char *name, int value) { 
    int index = decc$feature_get_index(name); 
 
    if (index == -1 || decc$feature_set_value(index, 1, value) == -1) { 
	perror(name); 
	return -1; 
    }
    if (decc$feature_get_value(index, 1) != value) { 
	perror(name); 
	return -1; 
    }
    return 0; 
} 

/* C RTL Feature settings */

static int set_features(void* init_coroutine(), void* cli_coroutine()) { 
    int s;
    char* str;
    unsigned long devbufsiz;
    unsigned long devchar;
    int term_flag;
    long tt_page;
    int lines;
    ILE3 item_list[4];

    (void)set_feature_default("DECC$EFS_CASE_PRESERVE", TRUE); 
    (void)set_feature_default("DECC$FILENAME_UNIX_REPORT", TRUE); 
    (void)set_feature_default("DECC$FILE_SHARING", TRUE); 
    (void)set_feature_default("DECC$READDIR_DROPDOTNOTYPE", TRUE); 
    (void)set_feature_default("DECC$EFS_CASE_SPECIAL", FALSE); 
    (void)set_feature_default("DECC$EFS_CHARSET", TRUE); 
    (void)set_feature_default("DECC$FILENAME_UNIX_ONLY", FALSE); 
    (void)set_feature_default("DECC$ALLOW_REMOVE_OPEN_FILES", FALSE); 

    /* CRTL may be initialized past this point, but not before. */
    DECC$CRTL_INIT();

    return SS$_NORMAL;
} 

#pragma nostandard
#pragma extern_model save

#pragma extern_model strict_refdef

/* .psect LIB$INITIALIZE, NOPIC, USR, CON, REL, GBL, NOSHR, NOEXE, RD, */
/*                        NOWRT, LONG */
#pragma extern_model strict_refdef "LIB$INITIALIZE" con,rel,gbl,noshr, \
        noexe,nowrt,nopic,long
int (* const ini_entry)() = set_features;

#pragma extern_model restore
#pragma standard
