#	Descrip.mms for OpenVMS MMS (or MMK)
#
# The Python Imaging Library.
#
#	Build file for IMAGING 1.1 on OpenVMS/Alpha using Compaq's MMS (DECset)
#	or the free MadGoat MMK clone.
#
#	Jean-Franois Pironne (jf.pieronne@laposte.net)  14-Aug-2002
#
#
.ifdef MMS
.else
MMS = MMK
.endif

.ifdef SCNDCALL

OPTIMIZE = /Optimize
DEBUG = /NoDebug
DEFS = /Define = HAVE_JPEG
INCS = /Include = ([], LibJPEG:, LibPNG:, LibZ:)

.ifdef AXP
CNAMES = /name=(short,as_is)
.else
CNAMES = /name=(short)
.endif
FLTFMT = /float=ieee
OUTLIB = libimaging.olb
LIBSHRNAME = libimagingshr32-1_1_4.exe
LIBSHROPT = libimaging-1_1_4.opt

CFLAGS = $(CFLAGS) $(OPTIMIZE) $(DEBUG) $(DEFS)$(INCS) $(FLTFMT) $(CNAMES)/prefix=all/accept=novaxc_keywords

LINKFLAGS = $(LINKFLAGS) $(DEBUG)

OBJS=		Storage.obj Access.obj Except.obj \
		Antialias.obj \
		Bands.obj Blend.obj \
		Chops.obj Convert.obj ConvertYCbCr.obj Copy.obj Crop.obj Crc32.obj \
		Dib.obj Draw.obj \
		Effects.obj \
		File.obj Fill.obj Filter.obj \
		Geometry.obj GetBBox.obj \
		Histo.obj \
		Matrix.obj \
		Negative.obj  \
		Offset.obj \
		Pack.obj Palette.obj Paste.obj Point.obj \
                Quant.obj QuantHash.obj QuantHeap.obj \
		RankFilter.obj \
		Unpack.obj UnpackYCC.obj \
		BitDecode.obj \
		EpsEncode.obj \
		FliDecode.obj \
		GifDecode.obj GifEncode.obj \
		HexDecode.obj \
		JpegDecode.obj JpegEncode.obj \
		LzwDecode.obj \
		MspDecode.obj \
		PackDecode.obj \
		PcdDecode.obj \
		PcxDecode.obj PcxEncode.obj \
		RawDecode.obj RawEncode.obj \
		SunRleDecode.obj \
		TgaRleDecode.obj \
		XbmDecode.obj XbmEncode.obj \
		ZipDecode.obj ZipEncode.obj

.first 
        @ copy ImConfig.h_vms ImConfig.h
.ifdef AXP
        @ define libimaging_olb $(OUTLIB)
.endif

.ifdef AXP
share : $(LIBSHRNAME)
	@ Write Sys$Output "Shareable build complete..."

$(LIBSHRNAME) : $(OUTLIB) $(LIBSHROPT)
        $(LINK) $(LINKFLAGS) /share=$(LIBSHRNAME) $(LIBSHROPT)/opt
.endif

$(LIBSHROPT) : libimaging-1_1_4.opt_vms
	$ copy libimaging-1_1_4.opt_vms $(LIBSHROPT) 

lib :	$(OUTLIB)
	@ Write Sys$Output "LibImaging build complete..."

coretest.exe : coretest.obj $(OUTLIB)
	link/exe=coretest.exe coretest.obj, coretest.opt/opt

test : coretest.exe
	@ Write Sys$Output "coretest build complete..."

$(OUTLIB) : $(OBJS)
	@ Library /Create $*.olb $+

clean :
	- Purge /NoLog /NoConfirm *.mms, *.obj, *.olb

clobber :	clean
	- Delete /NoLog /NoConfirm *.obj;,*.olb;

.else   !------------------- first call ------------

say = write sys$output

? $(mmstargets) : default
        @ !

default :
        @ $(say) ""
        - delete *.obj;*
        @ if f$getsyi("arch_type") .ne. 1 then \
          param = "/macro=(scndcall=1,axp=1,ieee=1)"
        @ if f$getsyi("arch_type") .ne. 1 then \
          $(mms)/ignore=warning 'param' $(mmstargets)   ! second call on axp
        - delete *.obj;*, *.opt;*

.endif  ! scndcall

Access.obj : Access.c

Antialias.obj : Antialias.c

Bands.obj : Bands.c

BitDecode.obj : BitDecode.c

Blend.obj : Blend.c

Chops.obj : Chops.c

Convert.obj : Convert.c

ConvertYCbCr.obj : ConvertYCbCr.c

Copy.obj : Copy.c

Crc32.obj : Crc32.c

Crop.obj : Crop.c

Dib.obj : Dib.c

Draw.obj : Draw.c

Effects.obj : Effects.c

EpsEncode.obj : EpsEncode.c

Except.obj : Except.c

File.obj : File.c

Fill.obj : Fill.c

Filter.obj : Filter.c

FliDecode.obj : FliDecode.c

Geometry.obj : Geometry.c

GetBBox.obj : GetBBox.c

GifDecode.obj : GifDecode.c

GifEncode.obj : GifEncode.c

HexDecode.obj : HexDecode.c

Histo.obj : Histo.c

JpegDecode.obj : JpegDecode.c

JpegEncode.obj : JpegEncode.c

LzwDecode.obj : LzwDecode.c

Matrix.obj : Matrix.c

MspDecode.obj : MspDecode.c

Negative.obj : Negative.c

Offset.obj : Offset.c

Pack.obj : Pack.c

PackDecode.obj : PackDecode.c

Palette.obj : Palette.c

Paste.obj : Paste.c

Quant.obj : Quant.c

QuantHash.obj : QuantHash.c

QuantHeap.obj : QuantHeap.c

RankFilter.obj : RankFilter.c

PcdDecode.obj : PcdDecode.c

PcxDecode.obj : PcxDecode.c

PcxEncode.obj : PcxEncode.c

Point.obj : Point.c

RawDecode.obj : RawDecode.c

RawEncode.obj : RawEncode.c

Storage.obj : Storage.c

SunRleDecode.obj : SunRleDecode.c

TgaRleDecode.obj : TgaRleDecode.c

Unpack.obj : Unpack.c

UnpackYCC.obj : UnpackYCC.c

XbmDecode.obj : XbmDecode.c

XbmEncode.obj : XbmEncode.c

ZipDecode.obj : ZipDecode.c

ZipEncode.obj : ZipEncode.c
