$! setup lynx to run from the freeware directory, browsing the user's home directory.
$!set verify
$	path = F$ENVIRONMENT("procedure")
$	head = "''F$EXTRACT(0,F$LOCATE("]",path),path)'"
$!
$! This is either "alpha" or "vax", which corresponds to the names of the
$! directories containing the executables for those platforms:
$	arch = f$getsys("arch_name")
$!
$! Make foreign command so we can run lynx from the command-line, passing
$! unix-style options, etc:
$	lynx   :== "$''head'.''arch']lynx.exe"
$!
$! Construct a config-file pointing to the lynx.cfg and lynx_help files.
$! This assumes that the freeware cdrom is on a local drive - I don't know
$! how to construct a "file://" url for a network connection from the VMS
$! pathname.
$	my_src = "''head'.src]"
$	my_cfg = "sys$scratch:lynx_demo.cfg"
$	if f$search("''my_cfg'") .nes. "" then delete 'my_cfg;*
$
$	url == f$edit("''my_src'", "lowercase")
$	dot = f$locate(":[",url)
$	if dot .lt. f$length(url) then url = f$extract(0,dot,url) + "/" + f$extract(dot+2,f$length(url),url)
$	dot = f$locate("]",url)
$	if dot .lt. f$length(url) then url = f$extract(0,dot,url) + "/" + f$extract(dot+1,f$length(url),url)
$ loop:
$	dot = f$locate(".",url)
$	if dot .lt. f$length(url)
$	then
$		url = f$extract(0,dot,url) + "/" + f$extract(dot+1,f$length(url),url)
$		goto loop
$	endif
$
$	open/write cfg 'my_cfg
$	write cfg "include:''my_src'lynx.cfg"
$	write cfg "STARTFILE:file://localhost/~/"
$	write cfg "HELPFILE:file://localhost/''url'lynx_help/lynx_help_main.html"
$	close cfg
$
$	define lynx_cfg 'my_cfg
$!
$	lynx
$!
$! Cleanup
$	if f$search("''my_cfg'") .nes. "" then delete 'my_cfg;*
