/*
	MBU3	- write command
 COPYRIGHT NOTICE

 This software is COPYRIGHT  2004, Ian Miller. ALL RIGHTS RESERVED.
 Permission is granted for not-for-profit redistribution, provided all source
 and object code remain unchanged from the original distribution, and that all
 copyright notices remain intact.

 DISCLAIMER

 This software is provided "AS IS". The author makes no representations or
 warranties with respect to the software and specifically disclaim any implied
 warranties of merchantability or fitness for any particular purpose.

*/
#pragma module MBU3 "V01-002"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <climsgdef.h>
#include <iodef.h>
#include <rmsdef.h>
#include <errno.h>
#include <dvidef.h>

#include "mbu.h"

/* local data		*/
static FORMAT format;
static DATA_SIZE data_size;
static unsigned long maxmsg;

/* local functions	*/
static unsigned long 
ReadMsg(char *input,char *buf,unsigned long *len);
static unsigned long 
SendMsg(unsigned short chan, char *buf, unsigned long len, unsigned short wait);
static 
unsigned long 
FormatLine(char *buf,unsigned long *len, char *line, int linelen);

/*
	write_cmd	- execute write command
*/
unsigned long
write_cmd(void)
{
	extern unsigned long SYS$DASSGN();
   	static $DESCRIPTOR(eof_dsc,"EOF");
	static $DESCRIPTOR(wait_dsc,"WAIT");
	static $DESCRIPTOR(name_dsc,"NAME");
	static $DESCRIPTOR(input_dsc,"INPUT");
	unsigned long ccode, len;
	unsigned short chan, wait, eof;
	$DESCRIPTOR_D(value_dsc);
	$DESCRIPTOR_D(mbu_dsc);
	char input[256], *buf;

	/* get command values		*/
	CLI$GET_VALUE(&name_dsc,&mbu_dsc);
	data_size = get_data_size();
	format = get_format();
	input[0] = '\0';
	ccode = CLI$PRESENT(&input_dsc);
	if ((ccode & 1) != 0)
	{
		if (def_input != NULL)
			strcpy(input,def_input);
		LIB$SFREE1_DD(&value_dsc);
		ccode = CLI$GET_VALUE(&input_dsc,&value_dsc);
		if ((ccode & 1) != 0)
		{
			strncpy(input, value_dsc.dsc$a_pointer,
				value_dsc.dsc$w_length);
			input[value_dsc.dsc$w_length] = '\0';
		}
	}

	ccode = CLI$PRESENT(&wait_dsc);
	if (ccode == CLI$_LOCPRES
	||  ccode == CLI$_PRESENT
	||  ccode == CLI$_DEFAULTED)
	{
		wait = TRUE;
	}
	else
		wait = FALSE;

	ccode = CLI$PRESENT(&eof_dsc);
	if (ccode == CLI$_LOCPRES
	||  ccode == CLI$_PRESENT
	||  ccode == CLI$_DEFAULTED)
	{
		eof = TRUE;
	}
	else
		eof = FALSE;

	/*  open mailbox		*/
	ccode = OpenMbx(&mbu_dsc,&chan,&maxmsg);
	if ((ccode & 1) != 0)
	{
		if (eof)
			ccode = SendMsg(chan,NULL,0,wait);
		else
		{
			buf = malloc(maxmsg);
			/* read message contents	*/
			ccode = ReadMsg(input,buf,&len);
			/* if ok then send message	*/
			if ((ccode & 1) != 0)
				ccode = SendMsg(chan,buf,len,wait);
			free(buf);
		}
	}
	/* close mailbox		*/
	SYS$DASSGN(chan);

	/* free dynamic strings		*/
	LIB$SFREE1_DD(&value_dsc);
	LIB$SFREE1_DD(&mbu_dsc);

	if (ccode == MBU__MAXMSG)
	{
		putmsg(MBU__MAXMSG,maxmsg);
		ccode = MBU__NORMAL;
	}

	return(ccode);
}

/*
	OpenMbx		- open mailbox
*/
unsigned long
OpenMbx(struct dsc$descriptor_s *name, unsigned short *chan,
	unsigned long *maxmsg)
{
	unsigned long ccode;
	extern unsigned long SYS$ASSIGN(), LIB$GETDVI();

	/* assign channel	*/
	ccode = SYS$ASSIGN(name,chan,0,0);

	/* if ok, get maxmsg	*/
	if ((ccode & 1) != 0)
		ccode = LIB$GETDVI(&DVI$_DEVBUFSIZ,chan,0,maxmsg,0,0);

	return(ccode);
}

/*
	ReadMsg		- read message
*/
static unsigned long 
ReadMsg(char *input,char *buf,unsigned long *len)
{
	static $DESCRIPTOR(prompt_dsc,"_Message: ");
	$DESCRIPTOR_D(line_dsc);
	unsigned long ccode;
	char line[133];
	FILE *fp;

	*len = 0;

	if (*input == '\0')
	{
		/* read from SYS$INPUT	*/
		while (*len <= maxmsg)
		{
			ccode = get_input(&line_dsc,&prompt_dsc,0);
			ccode = FormatLine(buf,len,
						line_dsc.dsc$a_pointer,
						line_dsc.dsc$w_length);
			if ((ccode & 1) == 0)
				break;
		}
		LIB$SFREE1_DD(&line_dsc);
	}
	else
	{
		/* read from input file	*/
		if ((fp=fopen(input,"r")) != NULL)
		{
			while (*len <= maxmsg)	/* while not reach max size*/
			{
				/* read a line	*/
				line[0] = '\0';
				fgets(line,sizeof(line),fp);

				/* parse line contents depending on format */
				ccode = FormatLine(buf,len,line,strlen(line));
				if ((ccode & 1) == 0)
					break;	/* all done */
			}
			fclose(fp);
		}
		else
			ccode = vaxc$errno;
	}

	if (ccode == RMS$_EOF)
		ccode = MBU__NORMAL;

	return(ccode);
}

/*
	FormatLine	- format line of mesage contents
*/
static 
unsigned long 
FormatLine(char *buf,unsigned long *len, char *line, int linelen)
{
	static char *forms[] = {"%x","%d","%s"};
	static char *delim[] = {" \t\n"," \t\n","\n"};
	unsigned long ccode, inc, value;
	char *token, *out;

	if (linelen == 0)
		return(RMS$_EOF);

	ccode = MBU__NORMAL;
       	out = buf + *len;
	if (format == TEXT)
	{
		if ((*len + linelen) < maxmsg)
		{
			memcpy(out,line,linelen);
			*len += linelen;
                        out[linelen] = '\0';
		}
		else
		{
			ccode = MBU__MAXMSG;
		}
	}
	else
	{
        	token=strtok(line,delim[format]);
		while (token != NULL)
		{
			if (sscanf(token,forms[format],&value) == 1)
			{
				switch (data_size)
				{
				case BYTE:
					*out = (unsigned char)value;
					inc = sizeof(char);
					break;
				case WORD:
					*out = (short)value;
					inc = sizeof(short);
					break;
				case LONG:
					*out = (long)value;
					inc = sizeof(long);
					break;
				}
			}
			else
			{
				ccode = MBU__INVINP;
				break;
			}
			if ((*len + inc) > maxmsg)
			{
				ccode = MBU__MAXMSG;
				break;
			}
			*len += inc;
			out += inc;
			token=strtok(NULL,delim[format]);
		}
	}
	return(ccode);
}


/*
	SendMsg		- Send message
*/
static unsigned long 
SendMsg(unsigned short chan, char *buf, unsigned long len, unsigned short wait)
{
	unsigned long ccode;
	unsigned short iosb[4], func;
	extern unsigned long SYS$QIOW();

	if (buf == NULL)
		func = IO$_WRITEOF;
	else
		func = IO$_WRITEVBLK;

	if (!wait)
		func |= IO$M_NOW;

	ccode = SYS$QIOW(0,chan,func,iosb,0,0,buf,len,0,0,0,0);
	if ((ccode & 1) != 0)
		ccode = iosb[0];

	return(ccode);
}
