#pragma message disable pragma
#pragma module VMS_OPENDIR "X-1"

/*
 *************************************************************************
 *                                                                       *
 *   Copyright 2003 Hewlett-Packard Development Company, L.P.            *
 *                                                                       *
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                       *
 * Neither HP nor any of its subsidiaries shall be liable for technical  *
 * or editorial errors or omissions contained herein.  The information   *
 * in this document is provided "as is" without warranty of any kind and *
 * is subject to change without notice.  The warranties for HP products  *
 * are set forth in the express limited warranty statements accompanying *
 * such products.  Nothing herein should be construed as constituting an *
 * additional warranty.                                                  *
 *                                                                       *
 *************************************************************************
 *
 *
 * Facility:
 *
 *	MKISOFS - Make ISO File System
 *
 * Abstract:
 *
 *	MKISOFS requires that the first two readdir() calls return
 *	"." and "..".
 *
 * Author:
 *
 *	X-1	JEM019		J. Malmberg		15-Sep-2003
 *		Initial version
 *
 ************************************************************************
 */

#include "dirent.h"
#include "stdlib.h"
#include "string.h"

struct vms_dirdesc
{
   DIR *dir;
   int count;
   struct dirent dotdir;
};

struct vms_dirdesc * vms_opendir(const char * path)
{
struct vms_dirdesc * dirdesc;

    dirdesc = malloc(sizeof(struct vms_dirdesc));
    dirdesc->dir = opendir(path);
    if (dirdesc->dir != NULL)
    {
	dirdesc->count = 0;
	memset(&dirdesc->dotdir, 0, sizeof(struct dirent));
    }
    else
    {
	free(dirdesc);
	dirdesc = NULL;
    }
    return dirdesc;
}

struct dirent * vms_readdir(void * context)
{
struct vms_dirdesc * dirdesc;
struct dirent * result;

    dirdesc = (struct vms_dirdesc *)context;
    if (dirdesc->count >= 2)
    {
	result = readdir(dirdesc->dir);
    }
    else
    {
	result = &dirdesc->dotdir;

	if (dirdesc->count == 0)
	{
	    strcpy(dirdesc->dotdir.d_name,".");
	}
	else
	{
	    if (dirdesc->count == 1)
	    {
		strcpy(dirdesc->dotdir.d_name,"..");
	    }
	}
	dirdesc->count++;
    }
    return result;
}

int vms_closedir(void * context)
{
struct vms_dirdesc * dirdesc;
int status;

    dirdesc = (struct vms_dirdesc *)context;

    status = closedir(dirdesc->dir);
    free(dirdesc);

    return status;
}
