#pragma message disable pragma
#pragma module VMS_PRE_INIT_MKISOFS "X-1"

/*
 *************************************************************************
 *                                                                       *
 *   Copyright 2003 Hewlett-Packard Development Company, L.P.            *
 *                                                                       *
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                       *
 * Neither HP nor any of its subsidiaries shall be liable for technical  *
 * or editorial errors or omissions contained herein.  The information   *
 * in this document is provided "as is" without warranty of any kind and *
 * is subject to change without notice.  The warranties for HP products  *
 * are set forth in the express limited warranty statements accompanying *
 * such products.  Nothing herein should be construed as constituting an *
 * additional warranty.                                                  *
 *                                                                       *
 *************************************************************************
 *
 *
 * Facility:
 *
 *	MKISOFS - Make ISO File System
 *
 * Abstract:
 *
 *	This module sets up the OpenVMS C run time library options
 *	before the main code runs.
 *
 * Author:
 *
 *	X-1	JEM019		J. Malmberg		15-Sep-2003
 *		Initial version
 *
 ************************************************************************
 */

#include <unixio.h>
#include <unixlib.h>
#include <stdlib.h>
#include <string.h>

#include <descrip.h>
#include <ssdef.h>
#include <lnmdef.h>

/* DECC dependent attributes */
#ifdef __DECC_VER
#if __DECC_VER < 60560002
#define relative
#define not_executable
#else
#define relative ,rel
#define not_executable ,noexe
#endif
#endif


#if  __CRTL_VER < 70301000 && __CRTL_VER >= 70300000
int   decc$feature_get_index(const char *name);
char* decc$feature_get_name(int index);
int   decc$feature_get_value(int index, int mode);
int   decc$feature_set_value(int index, int mode, int value);
#endif


#pragma message disable dollarid

#pragma message disable pragma
#pragma member_alignment save
#pragma nomember_alignment longword
#pragma message save
#pragma message disable misalgndmem

struct item_list_3 {
    unsigned short buf_len;
    unsigned short item_code;
    void * buffer;
    unsigned short * ret_len;
};

#pragma message restore
#pragma member_alignment restore


int sys$crelnm
   (const unsigned long * attr,
    const struct dsc$descriptor_s * tabnam,
    const struct dsc$descriptor_s * lognam,
    const unsigned char * accmode,
    const struct item_list_3 * itmlst);

/*
 *
 * Name: sys_crelnm
 *
 *	C routine calling convention version of SYS$CRELNM for just
 *	creating logical names.
 *
 */

static int sys_crelnm
   (const char * logname,
    const char * value)
{
int ret_val;
const char * proc_table = "LNM$PROCESS_TABLE";
struct dsc$descriptor_s proc_table_dsc;
struct dsc$descriptor_s logname_dsc;
struct item_list_3 item_list[2];

    proc_table_dsc.dsc$a_pointer = (char *) proc_table;
    proc_table_dsc.dsc$w_length = strlen(proc_table);
    proc_table_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
    proc_table_dsc.dsc$b_class = DSC$K_CLASS_S;

    logname_dsc.dsc$a_pointer = (char *) logname;
    logname_dsc.dsc$w_length = strlen(logname);
    logname_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
    logname_dsc.dsc$b_class = DSC$K_CLASS_S;

    item_list[0].buf_len = strlen(value);
    item_list[0].item_code = LNM$_STRING;
    item_list[0].buffer = (char *)value;
    item_list[0].ret_len = NULL;

    item_list[1].buf_len = 0;
    item_list[1].item_code = 0;

    ret_val = sys$crelnm
		       (NULL,
			(const struct dsc$descriptor_s *)&proc_table_dsc,
			(const struct dsc$descriptor_s *)&logname_dsc,
			NULL,
			(const struct item_list_3 *) item_list);

    return ret_val;
}


/*
 *
 * Name: set_feature_default()
 *
 * Sets a C feature default value, based on the feature name.
 *
 */

#ifndef __VAX
#if __CRTL_VER >= 70300000
static int set_feature_default(const char *name, int value)
{
int status;
int index;

    index = decc$feature_get_index(name);

    status = decc$feature_set_value(index, 1, value);
    if (index == -1 || (status == -1))
    {
	perror(name);
	return -1;
    }

    status = decc$feature_get_value(index, 1);
    if (status != value)
    {
	perror(name);
	return -1;
    }

    return 0;
}
#endif
#endif


/*
 *
 * Name: set_features
 *
 * C RTL Feature setting initialization module
 *
 */

static int set_features
   (int (* init_coroutine)(int *, int *, void *),  /* Needs casts if used */
    int (* cli_routine)(void),	/* Not documented */
    void *image_info)		/* Not documented */
{
int status;
int s;
unsigned long devbufsiz;
unsigned long devchar;
int term_flag;
long tt_page;
int lines;
char* str;
struct item_list_3 item_list[4];

#ifndef __VAX
#if __CRTL_VER >= 70300000
    set_feature_default("DECC$EFS_CASE_PRESERVE", TRUE);
    set_feature_default("DECC$EFS_CASE_SPECIAL", FALSE);
    set_feature_default("DECC$EFS_FILE_TIMESTAMPS", TRUE);
    set_feature_default("DECC$FILENAME_UNIX_REPORT", TRUE);
    set_feature_default("DECC$FILENAME_UNIX_NO_VERSION", TRUE);
    set_feature_default("DECC$READDIR_DROPDOTNOTYPE", TRUE);
    set_feature_default("DECC$FILENAME_UNIX_ONLY", TRUE);
#else
    status = sys_crelnm("DECC$EFS_CASE_PRESERVE", "ENABLE");
    status = sys_crelnm("DECC$EFS_CASE_SPECIAL", "DISABLE");
    status = sys_crelnm("DECC$EFS_FILE_TIMESTAMPS", "ENABLE");
    status = sys_crelnm("DECC$READDIR_DROPDOTNOTYPE", "ENABLE");
    status = sys_crelnm("DECC$FILENAME_UNIX_ONLY", "ENABLE");
    status = sys_crelnm("DECC$FILENAME_UNIX_NO_VERSION", "ENABLE");
#endif
#else
    status = sys_crelnm("DECC$READDIR_DROPDOTNOTYPE", "ENABLE");
    status = sys_crelnm("DECC$FILENAME_UNIX_ONLY", "ENABLE");
#endif

     /* Feature default did not work? */
    status = sys_crelnm("DECC$FILENAME_UNIX_REPORT", "ENABLE");

    status = sys_crelnm("DECC$EFS_CHARSET", "ENABLE");

    return SS$_NORMAL;
}

/*
 * Name Lib$initialize psect
 *
 * This creates the psect definition to invoke a the set_features()
 * routine before the main routine is started.
 *
 */

#pragma nostandard
#pragma extern_model save
#pragma extern_model strict_refdef "LIB$INITIALIZ" nowrt
	const __align (LONGWORD) int spare[8] = {0};
/* .psect LIB$INITIALIZE, NOPIC, USR, CON, REL, GBL, NOSHR, NOEXE, RD, */
/*			  NOWRT, LONG */
#pragma extern_model strict_refdef "LIB$INITIALIZE" con, gbl,noshr, \
	nowrt,noshr relative not_executable
const long vms_cc_features = (const long)set_features;

/*
** Force a reference to LIB$INITIALIZE to ensure it
** exists in the image.
*/
int lib$initialize(void);
#pragma extern_model strict_refdef
int lib_init_ref = (int) lib$initialize;

#pragma extern_model restore
#pragma standard
