! CROSS_ALPHA.MMS
!
!   COPYRIGHT  1993, MADGOAT SOFTWARE.  ALL RIGHTS RESERVED.
!
!  MMK build rules that use alternative file types for AXP objects
!  and images, to facilitate AXP + VAX development within a single
!  project directory.
!
!  These rules can easily be modified to invoke AXP cross-development
!  tools, if you are still using them instead of native AXP development
!  tools.
!
!
EXE = .ALPHA_EXE
OLB = .ALPHA_OLB
OBJ = .ALPHA_OBJ
OPT = .ALPHA_OPT
L32 = .L32E

__ALPHA__ = __ALPHA__
__AXP__   = __AXP__

.SUFFIXES :
.SUFFIXES : $(EXE) $(OLB) $(OBJ) .TLB .HLB $(L32) .C .B32 .BLI .MAR -
    	    .M64 .MSG .CLD .R32 .REQ .TXT .HLP .MMS .DAT .OPT .SDML .COM -
    	    .C~ .BAS~ .B32~ .BLI~ .FOR~ .COB~ .COR~ .DBL~ .RPG~ .SCN~ -
    	    .PLI~ .PAS~ .MAC~ .MAR~ .M64~ .MSG~ .CLD~ .R32~ .REQ~ .TXT~ -
    	    .H~ .HLP~ .RNH~ .RNO~ .MMS~ .DAT~ .OPT~ .SDML~ .COM~

LINK = LINK
LINKFLAGS = /EXEC=$(MMS$TARGET)

LIBRARY = LIBRARY
$(OBJ)$(OLB) :
    @ IF F$SEARCH("$(MMS$TARGET)") .EQS. "" THEN $(LIBRARY)/CREATE $(MMS$TARGET)
    $(LIBRARY)/REPLACE $(MMS$TARGET) $(MMS$SOURCE)

.TXT.TLB :
    @ IF F$SEARCH("$(MMS$TARGET)") .EQS. "" THEN $(LIBRARY)/CREATE $(MMS$TARGET)
    $(LIBRARY)/REPLACE $(MMS$TARGET) $(MMS$SOURCE_NAME)/MODULE=$(MMS$TARGET_MODULE)

.HLP.HLB :
    @ IF F$SEARCH("$(MMS$TARGET)") .EQS. "" THEN $(LIBRARY)/CREATE $(MMS$TARGET)
    $(LIBRARY)/REPLACE $(MMS$TARGET) $(MMS$SOURCE)

CC = CC
CFLAGS = /OBJECT=$(MMS$TARGET_NAME)$(OBJ)
.C$(OBJ) :
    $(CC)$(CFLAGS) $(MMS$SOURCE)

BLISS = BLISS/A32
BFLAGS = /OBJECT=$(MMS$TARGET_NAME)$(OBJ)
.B32$(OBJ) :
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)

.BLI$(OBJ) :
    $(BLISS)$(BFLAGS) $(MMS$SOURCE)

MESSAGE = MESSAGE
MSGFLAGS = /OBJECT=$(MMS$TARGET_NAME)$(OBJ)
.MSG$(OBJ) : 
    $(MESSAGE)$(MSGFLAGS) $(MMS$SOURCE)

SETCMD = SET COMMAND
SETCMDFLAGS = /OBJECT=$(MMS$TARGET_NAME)$(OBJ)
.CLD$(OBJ) :
    $(SETCMD)$(SETCMDFLAGS) $(MMS$SOURCE)

MACRO = MACRO/MIGRATION
MFLAGS = /OBJECT=$(MMS$TARGET_NAME)$(OBJ)
.MAR$(OBJ) :
    $(MACRO)$(MFLAGS) $(MMS$SOURCE)

TASM = MACRO
TASMFLAGS = /OBJECT=$(MMS$TARGET_NAME)$(OBJ)
.M64$(OBJ) :
    $(TASM)$(TASMFLAGS) $(MMS$SOURCE)

.R32$(L32) :
    $(BLISS)/LIBRARY=$(MMS$TARGET_NAME)$(L32) $(MMS$SOURCE)

.REQ$(L32) :
    $(BLISS)/LIBRARY=$(MMS$TARGET_NAME)$(L32) $(MMS$SOURCE)

CMS 	    = CMS
CMSCOMMENT  = ""
CMSFLAGS    = /GENERATION=$(MMS$CMS_GEN)

.B32~.B32 :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).B32 $(CMSFLAGS) $(CMSCOMMENT)

.BAS~.BAS :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).BAS $(CMSFLAGS) $(CMSCOMMENT)

.BLI~.BLI :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).BLI $(CMSFLAGS) $(CMSCOMMENT)

.C~.C :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).C $(CMSFLAGS) $(CMSCOMMENT)

.CLD~.CLD :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).CLD $(CMSFLAGS) $(CMSCOMMENT)

.COB~.COB :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).COB $(CMSFLAGS) $(CMSCOMMENT)

.COR~.COR :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).COR $(CMSFLAGS) $(CMSCOMMENT)

.COM~.COM :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).COM $(CMSFLAGS) $(CMSCOMMENT)

.DAT~.DAT :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).DAT $(CMSFLAGS) $(CMSCOMMENT)

.DBL~.DBL :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).DBL $(CMSFLAGS) $(CMSCOMMENT)

.FOR~.FOR :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).FOR $(CMSFLAGS) $(CMSCOMMENT)

.H~.H :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).H $(CMSFLAGS) $(CMSCOMMENT)

.HLP~.HLP :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).HLP $(CMSFLAGS) $(CMSCOMMENT)

.MAC~.MAC :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).MAC $(CMSFLAGS) $(CMSCOMMENT)

.MAR~.MAR :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).MAR $(CMSFLAGS) $(CMSCOMMENT)

.M64~.M64 :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).M64 $(CMSFLAGS) $(CMSCOMMENT)

.MMS~.MMS :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).MMS $(CMSFLAGS) $(CMSCOMMENT)

.MSG~.MSG :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).MSG $(CMSFLAGS) $(CMSCOMMENT)

.OPT~.OPT :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).OPT $(CMSFLAGS) $(CMSCOMMENT)

.PAS~.PAS :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).PAS $(CMSFLAGS) $(CMSCOMMENT)

.PLI~.PLI :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).PLI $(CMSFLAGS) $(CMSCOMMENT)

.R32~.R32 :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).R32 $(CMSFLAGS) $(CMSCOMMENT)

.REQ~.REQ :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).REQ $(CMSFLAGS) $(CMSCOMMENT)

.RNH~.RNH :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).RNH $(CMSFLAGS) $(CMSCOMMENT)

.RNO~.RNO :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).RNO $(CMSFLAGS) $(CMSCOMMENT)

.SCN~.SCN :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).SCN $(CMSFLAGS) $(CMSCOMMENT)

.SDML~.SDML :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).SDML $(CMSFLAGS) $(CMSCOMMENT)

.TXT~.TXT :
	IF "$(MMS$CMS_LIBRARY)" .NES. "" THEN DEFINE/USER CMS$LIB $(MMS$CMS_LIBRARY)
	$(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).TXT $(CMSFLAGS) $(CMSCOMMENT)
