!++
!   DESCRIP.MMS
!
!   MMS (MMK) description file for building MMK.
!
!   N.B.: If you are on an AXP system and using DEC/MMS,
!   	  use the command MMS/MACRO=(__AXP__=1) to build MMK,
!   	  so you get the right linker options file.  This may
!         or may not work; some versions of MMS may not be
!   	  able to handle some of the syntax in this file.
!
!   28-SEP-1993	V1.0	Madison	    Initial commenting.
!   25-JUL-1994	V1.1	Madison	    Update for V3.2.
!   27-DEC-1998	V1.2	Madison	    Update for V3.8.
!   03-MAY-2004 V1.3    Madison     Integrate IA64 support.
!--

.IFDEF __MADGOAT_BUILD__
MG_FACILITY = MMK
.INCLUDE MG_TOOLS:HEADER.MMS
.ELSE
ETCDIR =
KITDIR =
BINDIR =
SRCDIR = SYS$DISK:[]
.ENDIF
!
! Set up some macros we'll need
!
.IFDEF __MMK_V32__

ARCH = VAX
MMKCOPT = MMK_COMPILE_RULES.OPT
OPTFILE = MMK.OPT
.IFDEF __AXP__
ARCH = AXP
MMKCOPT = MMK_COMPILE_RULES.ALPHA_OPT
OPTFILE = MMK.ALPHA_OPT
.ENDIF
.IFDEF __I64__
ARCH = I64
MMKCOPT = MMK_COMPILE_RULES.I64_OPT
OPTFILE = MMK.I64_OPT
.ENDIF

.IFDEF __MADGOAT_BUILD__
.ELSE
BINDIR = SYS$DISK:[.BIN-$(ARCH)]
.FIRST
    @ IF F$PARSE("$(BINDIR)") .EQS. "" THEN CREATE/DIR $(BINDIR)
    @ DEFINE/NOLOG BIN_DIR $(BINDIR)

{}.C{$(BINDIR)}.OBJ :
    $(CC)$(CFLAGS) $(MMS$SOURCE)
{}.MSG{$(BINDIR)}.OBJ :
    $(MESSAGE) $(MSGFLAGS) $(MMS$SOURCE)
{}.CLD{$(BINDIR)}.OBJ :
    $(SETCMD) $(SETCMDFLAGS) $(MMS$SOURCE)
{}.MAR{$(BINDIR)}.OBJ :
    $(MACRO) $(MFLAGS) $(MMS$SOURCE)
.ENDIF

MMKCLOC = $(BINDIR)

.ELSE  ! MMK pre-V3.2, or DEC/MMS

OPT = .OPT
.IFDEF __AXP__
OPT = .ALPHA_OPT
.ENDIF
.IFDEF __I64__
OPT = .I64_OPT
.ENDIF

MMKCLOC = SYS$DISK:[]
MMKCOPT = MMK_COMPILE_RULES$(OPT)
OPTFILE = MMS_MMK$(OPT)
.ENDIF

!
! Make sure we compile /NOOPT when we compile /DEBUG.
!
.IFDEF DBG
.IFDEF NOOPT
.ELSE
NOOPT = /NOOPT
.ENDIF
.ENDIF

!
! Modules for building MMK
!
OBJECTS = MMK,FILEIO,MEM,GET_RDT,SP_MGR,MISC,OBJECTS,-
    	SYMBOLS,READDESC,BUILD_TARGET,PARSE_DESCRIP,CMS_INTERFACE,-
    	PARSE_OBJECTS,PARSE_TABLES,MMK_MSG,MMK_CLD,DEFAULT_RULES
!
! Modules for building the rules compiler
!
MMKCMODS = FILEIO,MEM,MISC,OBJECTS,SYMBOLS,READDESC,PARSE_DESCRIP,-
    	   PARSE_OBJECTS,PARSE_TABLES,MMK_MSG

RULES = MMK_DEFAULT_RULES
.IFDEF __AXP__
RULES = MMK_DEFAULT_RULES_AXP
.ENDIF
.IFDEF __I64__
RULES = MMK_DEFAULT_RULES_I64
.ENDIF


CFLAGS = $(CFLAGS)$(DEFINE)
LINKFLAGS = $(LINKFLAGS)/NOTRACE


$(BINDIR)MMK.EXE : $(BINDIR)MMK.OLB($(OBJECTS)),$(OPTFILE)
    $(LIBR)/COMPRESS/OUTPUT=$(BINDIR)MMK.OLB $(BINDIR)MMK.OLB
    $(LINK)$(LINKFLAGS) $(OPTFILE)/OPT

MMK_H	    	    	    = $(SRCDIR)MMK.H, $(SRCDIR)MMK_MSG.H

$(BINDIR)MMK.OBJ,-
$(BINDIR)MEM.OBJ,-
$(BINDIR)SP_MGR.OBJ,-
$(BINDIR)FILEIO.OBJ,-
$(BINDIR)GET_RDT.OBJ	    : $(MMK_H)

$(BINDIR)SYMBOLS.OBJ,-
$(BINDIR)OBJECTS.OBJ,-
$(BINDIR)MISC.OBJ-
$(BINDIR)READDESC.OBJ,-
$(BINDIR)BUILD_TARGET.OBJ   : $(MMK_H), $(SRCDIR)GLOBALS.H

$(BINDIR)PARSE_DESCRIP.OBJ,-
$(BINDIR)PARSE_OBJECTS.OBJ  : $(MMK_H), $(SRCDIR)GLOBALS.H, $(SRCDIR)TPADEF.H

$(BINDIR)CMS_INTERFACE.OBJ  : $(MMK_H), $(SRCDIR)CMSDEF.H, $(SRCDIR)GLOBALS.H

.IFDEF __I64__
$(BINDIR)PARSE_TABLES.OBJ : $(SRCDIR)PARSE_TABLES.MAR
    $(MACRO)$(MFLAGS) SYS$LIBRARY:ARCH_DEFS.MAR+$(SRCDIR)$(MMS$SOURCE)
.ENDIF

$(BINDIR)DEFAULT_RULES.OBJ : $(MMK_H), $(SRCDIR)GLOBALS.H, $(SRCDIR)$(RULES).H

$(SRCDIR)$(RULES).H : $(SRCDIR)$(RULES).MMS, $(BINDIR)MMK_COMPILE_RULES.EXE
    MMKC := $$(MMKCLOC)MMK_COMPILE_RULES.EXE
    MMKC/OUTPUT=$(MMS$TARGET) $(MMS$SOURCE)

MMKCOBJ = $(BINDIR)MMK_COMPILE_RULES.OBJ,$(BINDIR)GENSTRUC.OBJ,$(BINDIR)MMK_COMPILE_RULES_CLD.OBJ

$(BINDIR)MMK_COMPILE_RULES.EXE : $(MMKCOBJ),$(BINDIR)MMK.OLB($(MMKCMODS)),$(MMKCOPT)
    $(LINK)$(LINKFLAGS)/nodebug/notrace $(MMKCOBJ),$(BINDIR)MMK.OLB/LIB,$(SRCDIR)$(MMKCOPT)/opt

$(BINDIR)MMK_COMPILE_RULES.OBJ	: $(MMK_H)
$(BINDIR)GENSTRUC.OBJ	       	: $(MMK_H), $(SRCDIR)GLOBALS.H

!
! The help file
!
$(KITDIR)MMK_HELP.HLP : $(SRCDIR)MMK_HELP.RNH

!
! Documentation
!
$(KITDIR)MMK_DOC.PS : $(SRCDIR)MMK_DOC.SDML,$(SRCDIR)MMK_DEFAULT_RULES.MMS,$(SRCDIR)MMK_DEFAULT_RULES_AXP.MMS
    @ IF F$TRNLNM("DECC$SHR") .NES. "" THEN DEF/USER DECC$SHR SYS$SHARE:DECC$SHR
    DOCUMENT/CONTENTS/NOPRINT/DEVICE=BLANK_PAGES/OUTPUT=$(MMS$TARGET) $(MMS$SOURCE) SOFTWARE.REFERENCE PS
$(KITDIR)MMK_DOC.TXT : $(SRCDIR)MMK_DOC.SDML,$(SRCDIR)MMK_DEFAULT_RULES.MMS,$(SRCDIR)MMK_DEFAULT_RULES_AXP.MMS
    @ IF F$TRNLNM("DECC$SHR") .NES. "" THEN DEF/USER DECC$SHR SYS$SHARE:DECC$SHR
    DOCUMENT/CONTENTS/NOPRINT/OUTPUT=$(MMS$TARGET) $(MMS$SOURCE) SOFTWARE.REFERENCE MAIL

!
! Building the kit.  Note that my foreign command symbol for ZIP is
! PKZIP, rather than just plain ZIP, because I use ZIP for something else. -mdm
!

ZIP = PKZIP

KIT : $(KITDIR)MMK.ZIP
    @ !

$(KITDIR)MMK.ZIP : DISTRIBUTION, SOURCE
    IF F$SEARCH("$(MMS$TARGET)") .NES. "" THEN DELETE $(MMS$TARGET);*
    olddef = F$ENV("DEFAULT")
    SET DEFAULT DIST_ROOT:[DIST]
    PURGE [...]*.*
    $(ZIP) -r "-V" DIST_ROOT:[000000]MMK.ZIP *.*;
    SET DEFAULT 'olddef'
    TREDEL $(KITDIR)DIST.DIR

TAPE : DISTRIBUTION, SOURCE
    ROOT = F$PARSE("$(KITDIR)DIST.DIR",,,"DEVICE","NO_CONCEAL")+F$PARSE("$(KITDIR)DIST.DIR",,,"DIRECTORY","NO_CONCEAL")-"]["-"]"+".]"
    DEFINE MMK_ROOT 'ROOT'/TRANSLATION=CONCEAL
    BACKUP/LOG=TAPE.LIS MMK_ROOT:[DIST...]*.*; $(TAPE)MMK.BCK/SAVE/INTERCHANGE
    TREDEL $(KITDIR)DIST.DIR

DISTRIBUTION : DIST_PREP, DIST_DOC, DIST_BIN
    @ !

DIST_PREP :
    IF F$SEARCH("$(KITDIR)DIST.DIR") .NES. "" THEN TREDEL $(KITDIR)DIST.DIR
    olddef = F$ENV("DEFAULT")
    IF "$(KITDIR)" .NES. "" THEN SET DEFAULT $(KITDIR)
    CREATE/DIRECTORY [.DIST]
    SET DEFAULT 'olddef
    ROOT = F$PARSE("$(KITDIR)DIST.DIR",,,"DEVICE","NO_CONCEAL")+F$PARSE("$(KITDIR)DIST.DIR",,,"DIRECTORY","NO_CONCEAL")-"]["-"]"+".]"
    DEFINE DIST_ROOT 'ROOT'/TRANSLATION=CONCEAL

DIST_DOC : AAAREADME.DOC,AAAREADME.TOO,AAAREADME.INSTALL,LINK.COM,MMK.OPT,MMK.ALPHA_OPT,-
    	   MMK_DEFAULT_RULES.MMS,MMK_DEFAULT_RULES_AXP.MMS,CROSS_ALPHA.MMS,-
           MMK.I64_OPT,MMK_DEFAULT_RULES_I64.MMS,-
    	   $(KITDIR)MMK_HELP.HLP,$(KITDIR)MMK_DOC.PS,$(KITDIR)MMK_DOC.TXT
    PURGE $(MMS$SOURCE_LIST)
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST...]/OWNER=PARENT

DIST_BIN : $(BINVAX)MMK.OLB,$(BINAXP)MMK.OLB
    PURGE $(BINVAX)MMK.OLB,$(BINAXP)MMK.OLB
    CREATE/DIRECTORY DIST_ROOT:[DIST.BIN-VAX]
    $(LIBR)/VAX/COMPRESS/OUTPUT=DIST_ROOT:[DIST.BIN-VAX]MMK.OLB $(BINVAX)MMK.OLB
    CREATE/DIRECTORY DIST_ROOT:[DIST.BIN-AXP]
    $(LIBR)/ALPHA/COMPRESS/OUTPUT=DIST_ROOT:[DIST.BIN-AXP]MMK.OLB $(BINAXP)MMK.OLB

SOURCE : MMK.C,FILEIO.C,MEM.C,GET_RDT.C,SP_MGR.C,-
    	MISC.C,OBJECTS.C,SYMBOLS.C,READDESC.C,BUILD_TARGET.C,PARSE_DESCRIP.C,-
    	PARSE_OBJECTS.C,PARSE_TABLES.MAR,MMK_MSG.MSG,MMK_CLD.CLD,-
    	MMK.H,GLOBALS.H,TPADEF.H,MMK_MSG.H,CMSDEF.H,CMS_INTERFACE.C,-
    	MHDDEF.H,CLIDEFS.H,DESCRIP.MMS,MMK.OPT,MMK.ALPHA_OPT,-
        MMK.I64_OPT,MMK_COMPILE_RULES.I64_OPT,MMK_DEFAULT_RULES_I64.MMS,-
    	MMK_COMPILE_RULES.C,GENSTRUC.C,DEFAULT_RULES.C,MMK_COMPILE_RULES.OPT,-
    	MMK_COMPILE_RULES.ALPHA_OPT,MMK_COMPILE_RULES_CLD.CLD,-
    	MMK_DEFAULT_RULES.MMS,MMK_DEFAULT_RULES_AXP.MMS,CROSS_ALPHA.MMS,-
    	MMK_HELP.RNH,MMK_DOC.SDML,MMS_MMK.OPT,MMS_MMK.ALPHA_OPT
    PURGE $(MMS$SOURCE_LIST)
    CREATE/DIRECTORY DIST_ROOT:[DIST.SOURCE]
    BACKUP $(MMS$SOURCE_LIST) DIST_ROOT:[DIST.SOURCE]/OWNER=PARENT
