	program regedit
	implicit none
c
c An SMG interfact to look at the registry
c
	include '($smgdef)'
	include 'regedit.inc'
c
	record /menu_info/ top_level
c
 	record /smg/ smg
	integer*4 ncols,nrows,ikey,istat
c
	integer*4 build_top
c
c Initialize
c
	top_level.n_items    = 0
	top_level.ptr_first  = 0
	top_level.ptr_parent = 0
c
c Initialize SMG 
c
	call smg$create_pasteboard(smg.paste_id,,smg.nrows,smg.ncols)
	call smg$create_virtual_keyboard(smg.keyb_id)
	call init_displays(smg)
c
c Build  
c
	istat = build_top(top_level)
	if(.not. istat .or. top_level.ptr_first .eq. 0) then
	  call smg$set_cursor_abs(smg.dis_id,smg.nrows,1)
	  write(*,*) 'No keys of registry-server not running'
	else
	  
c
c Display initial 
c
	  call display_from_top(top_level,smg,0,ikey)
c
c And go
c
	  call process_commands(smg,top_level)
	  call smg$set_cursor_abs(smg.dis_id,smg.nrows,1)
	  istat = 1
	endif
	call sys$exit(%val(istat))
	end

	function build_top(top_level)
	implicit none
c
	include 'regedit.inc'
	include '($regdef)'
	record /menu_info/ top_level
	logical build_top
c
	integer*4 keyid,istat
	integer*4 add_top_item
c
	keyid = reg$_hkey_local_machine
	istat = add_top_item(top_level,keyid,'hkey_local_machine')
	if(istat) then
	  keyid = reg$_hkey_users
	  istat = add_top_item(top_level,keyid,'hkey_users')
	endif	
	build_top = istat
	return
	end
	function add_top_item(top_level,keyid,name)
	implicit none
c
	include 'regedit.inc'
	include '($regdef)'
c
	record /menu_info/ top_level
	integer*4 keyid
	character*(*) name
	integer*4 add_top_item
c
	record /item/ items(3)
	record /menu_item/ menu_item
	pointer (p_menu_item,menu_item)
c
	integer*4 nit,nkar,idx,n_subkeys,k,timeout
	integer*4 functie,istat,iosb(2)
c
	integer*4 sys$registryw
	integer*4 lib$get_vm
c
	volatile keyid,n_subkeys
c
	nit = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_keyid
	items(nit).buflen = 4
	items(nit).bufadr = %loc(keyid)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_subkeysnumber
	items(nit).buflen = 4
	items(nit).bufadr = %loc(n_subkeys)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
	items(nit).bufadr = 0
	items(nit).retadr = 0
c
	timeout = 5
	functie = reg$fc_query_key
10	istat = sys$registryw(,%val(functie),,items,iosb,,,%val(timeout))
	if(istat) istat = iosb(1)
	if(istat) then
	  top_level.n_items = top_level.n_items + 1
	  istat = lib$get_vm(sizeof(menu_item),p_menu_item)
	  menu_item.keyid     =  keyid
	  menu_item.n_subkeys = n_subkeys
	  menu_item.nkar_name = len(name)
	  menu_item.name      = name
	  menu_item.ptr_deep  = 0
	  menu_item.ptr_next  = 0	  
	  menu_item.ptr_top   = %loc(top_level)
	  menu_item.level     = 1	  
	  call cvt_txt_to_uni(name,menu_item.nkar_uni,menu_item.uniname)
c
	  call get_key_info(menu_item)
c
c Now hook in
c
	  if(top_level.ptr_first .eq. 0) then
	    top_level.ptr_first = p_menu_item
	  else
	    k = p_menu_item	!asve pointer
	    p_menu_item = top_level.ptr_first
	    do while(menu_item.ptr_next .ne. 0)
	      p_menu_item = menu_item.ptr_next
	    end do
	    menu_item.ptr_next = k
	  end if	  
	endif
	add_top_item = istat
	end	  
	subroutine cvt_uni_to_txt(unicode,nk_t,text,stop,idx)
	implicit none
	character*(*) unicode
	integer*4 nk_t
	character*(*) text
	logical stop
	integer*4 idx
c
	integer k
c
	nk_t = len(unicode) / 4
	idx  = len(unicode)+1
	do k=1,nk_t
	  if(stop) then
	    if(unicode(k*4-3:k*4-3) .eq. char(0)) then
	      nk_t = k-1
	      idx = k*4+1	!return next point
	      goto 90
	    endif
	  endif
	  text(k:k) = unicode(k*4-3:k*4-3)
	end do
90	return
	end	
	subroutine cvt_txt_to_uni(text,nk_u,unicode)
	implicit none
	character*(*) text
	integer*4 nk_u
	character*(*) unicode
c
	integer k
c
	do k=1,len(text)
	  unicode(k*4-3:k*4) = text(k:k)//char(0)//char(0)//char(0)
	end do
	nk_u = 4*len(text)
	return
	end	
	subroutine display_from_top(top_level,smg,wanted_item,ypos)
	implicit none
c
	include 'regedit.inc'
c
	record /menu_info/ top_level
	record /smg/ smg
	integer*4 wanted_item
	integer*4 ypos
c
	integer row,level
c
	row   = 0
	level = 1
	smg.size_col = 0
	call smg$erase_display(smg.dis_id_idx)
	call display_tree(smg.dis_id_idx,row,level,top_level,smg.size_col,
     1           wanted_item,ypos,.false.)
	smg.size_row = row 
	return
	end
	options /recursive
	subroutine display_tree(dis_id,row,level,menu_info,max_w,
     1         wanted_item,ypos,flag)
	implicit none
c
	include '($smgdef)'
	include 'regedit.inc'
	integer*4 dis_id
	integer*4 row
	integer*4 level
	record /menu_info/ menu_info
	integer*4 max_w
	integer*4 wanted_item
	integer*4 ypos
	logical flag
c
	record /menu_item/ item
	pointer (p_item,item)
c
	character*(max_str_length) line
c
	integer*4 nk,ikar,k
c
	if(level .eq. 1) then
	  line = ' '
	else
          call smg$read_from_display(dis_id,line,,row)
	endif
	p_item = menu_info.ptr_first
	do while(p_item .ne. 0)
	  row = row + 1
	  item.row = row
	  if(%loc(item) .eq. wanted_item) ypos = item.row
c
	  item.col = level*2-1
c
          ikar = smg$m_up + smg$m_down
          do k=1,item.col-4,2
            if(line(k:k) .ne. ' ') then
              call smg$draw_char(dis_id,ikar,item.row,k)
            endif
          end do
          if(flag) then
            call smg$draw_char(dis_id,ikar,item.row,item.col-2)
          endif
cc
	  ikar = smg$m_up .or. smg$m_right
	  if(item.ptr_next .ne. 0) ikar = ikar + smg$m_down
	  call smg$draw_char(dis_id,ikar,item.row,item.col)
c
	  ikar = smg$m_left + smg$m_right
	  if(.not. item.expanded) then
	    if(item.n_subkeys .gt. 0) ikar = ikar + smg$m_up
	    if(item.valuenumber .gt. 0) ikar = ikar + smg$m_down
	  endif
	  call smg$draw_char(dis_id,ikar,item.row,item.col+1)
c
	  nk = item.nkar_name 
	  if(nk+level+2 .gt. max_w) max_w = nk+level+2
	  call smg$put_chars(dis_id,item.name(1:nk),item.row,item.col+2)
c
	  if(item.expanded) then
	    call display_tree(dis_id,row,level+1,%val(item.ptr_deep),
     1            max_w,wanted_item,ypos,item.ptr_next.ne. 0)
	  endif
	  p_item = item.ptr_next
	end do
	return
	end
	subroutine init_displays(smg)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
c
	integer*4 wid_data,wid_idx,k
	include '($smgdef)'
c
	wid_data = 42
	wid_idx = smg.ncols - wid_data - 4
c
c
c
	call smg$create_virtual_display(smg.nrows, smg.ncols,smg.dis_id)
	call smg$draw_line(smg.dis_id,1,             1,        1,smg.ncols)
	call smg$draw_line(smg.dis_id,1,     smg.ncols,smg.nrows,smg.ncols)
	call smg$draw_line(smg.dis_id,smg.nrows,     1,smg.nrows,smg.ncols)
	call smg$draw_line(smg.dis_id,1,             1,smg.nrows,        1)
	call smg$draw_line(smg.dis_id,1,     wid_idx+3,smg.nrows,wid_idx+3)
	call smg$put_chars(smg.dis_id,'File',1,2)
	call smg$put_chars(smg.dis_id,'Help',1,8)
	call smg$put_chars(smg.dis_id,'Index',1,wid_idx/2)
	call smg$put_chars(smg.dis_id,'Data' ,1,wid_idx+2+wid_data/2)
	call smg$paste_virtual_display(smg.dis_id,smg.paste_id,1,1)
c
c Create idx display, and make a view
c
	smg.max_row = 1000
	smg.max_col = max_str_length+max_deep
	call smg$create_virtual_display(smg.max_row,smg.max_col,smg.dis_id_idx)
	smg.map_row = 1
	smg.map_col = 1
	smg.view_row = smg.nrows-3
	smg.view_col = wid_idx
	call smg$create_viewport(smg.dis_id_idx,
     1              smg.map_row,             smg.map_col,
     1              smg.map_row+smg.view_row,smg.map_col+smg.view_col)
	smg.idx_box.beg_row = 2
	smg.idx_box.end_row = smg.idx_box.beg_row + smg.view_row - 1
	smg.idx_box.beg_col = 2
	smg.idx_box.end_col = smg.idx_box.beg_col + smg.view_col - 1
	call smg$paste_virtual_display(smg.dis_id_idx,smg.paste_id,
     1           smg.idx_box.beg_row,
     1           smg.idx_box.beg_col)
c
c
c
	call smg$create_virtual_display(smg.view_row,1,smg.dis_bar_ver)
	smg.bar_ver_p1 = -1
	smg.bar_ver_p1 = -1
	smg.bar_ver_box.beg_row = 2
	smg.bar_ver_box.end_row = smg.bar_ver_box.beg_row + smg.view_row - 1
	smg.bar_ver_box.beg_col = smg.view_col + 2
	smg.bar_ver_box.end_col = smg.bar_ver_box.beg_col
	call smg$paste_virtual_display(smg.dis_bar_ver,smg.paste_id,
     1          smg.bar_ver_box.beg_row,
     1          smg.bar_ver_box.beg_col)
c
c
c
	call smg$create_virtual_display(1,smg.view_col,smg.dis_bar_hor)
	smg.bar_hor_p1 = -1
	smg.bar_hor_p1 = -1
	smg.bar_hor_box.beg_row = smg.nrows-1
	smg.bar_hor_box.end_row = smg.bar_hor_box.beg_row
	smg.bar_hor_box.beg_col = 2
	smg.bar_hor_box.end_col = smg.bar_hor_box.beg_col + smg.view_col - 1
	call smg$paste_virtual_display(smg.dis_bar_hor,smg.paste_id,
     1          smg.bar_hor_box.beg_row,
     1          smg.bar_hor_box.beg_col)
c
c
c
	smg.data_row = smg.nrows-2
	smg.data_col = wid_data
	call smg$create_virtual_display(smg.data_row,smg.data_col,
     1            smg.dis_id_data)
	smg.data_box.beg_row = 2
	smg.data_box.end_row = smg.data_box.beg_row + smg.data_row - 1
	smg.data_box.beg_col = wid_idx + 4
	smg.data_box.end_col = smg.data_box.beg_col + smg.data_col - 1
	call smg$paste_virtual_display(smg.dis_id_data,smg.paste_id,
     1             smg.data_box.beg_row,
     1             smg.data_box.beg_col)
c
	return
	end
	subroutine process_commands(smg,top_level)
	implicit none
c
	include 'regedit.inc'
	include '($smgdef)'
	record /smg/ smg
	record /menu_info/ top_level
c
	record /menu_item/ menu_item
	pointer (p_item,menu_item)
	record /menu_info/ menu_info
	pointer (p_info,menu_info)
c
	integer*4 ypos,row,col,iterm,ptr,diff,k,new_map_col,bypos,drow,nk
	integer*4 save_p_item,save_ypos,istat,dis_id,width,opt_row
	character*40 search_string
	integer*4 nk_sear/0/
	integer search_names/val_yes/,search_values/val_yes/
	integer Case/val_no/,fromtop/val_no/
	logical in_box,pf1_flag
c
	logical get_search_parameters
	logical find_string
	integer*4 get_len
	logical insert_key_val
	logical insert_val_val
	logical remove_key_val
	logical remove_val_val
c
	integer*4 n_choises
	parameter (n_choises = 8)
	character*12 choises(n_choises)
	data choises/'Expand',
     1               'Expand all',
     1               'Collapse',
     1               'Remove',
     1               'Insert key',
     1               'Insert Value',
     1               'Edit',
     1               'Cancel'/
c
	integer*4 n_help
	parameter (n_help=11)
	character*(50) help_lines(n_help)
	data help_lines /
     1    'Help about REGEDIT',
     1    'Up and down Arrow keys move index window',
     1    'Right and left arrow keys collapse/expand item',
     1    'Left  mouse clicks move/expand/collapse',
     1    'Right mouse click opens option dialog',
     1    '(PF1)-Find  starts search',
     1    'Select      modifies the current key/value',
     1    'Remove      Deletes the current key/value',
     1    'Insert      inserts a new key',
     1    'PF1-Insert  inserts a new value',
     1    'F10 or ^Z   Leave regedit'/
c
	integer*4 n_fchoises
	parameter (n_fchoises = 4)
	character*9 fchoises(n_fchoises)
	data fchoises/'Exit',
     1                'Find',
     1                'Find next',
     1                'Cancel'/
c
	ypos = 1
10	pf1_flag = .false.
11	if(ypos .le. 0) ypos = 1
	if(ypos .gt. smg.size_row) ypos = smg.size_row
c
c Now make sure ypos is in the visable part of the viewport
c
	if(ypos .lt. smg.map_row) then
	  diff = smg.map_row - ypos
	  call smg$scroll_viewport(smg.dis_id_idx,smg$m_down,diff)
	  smg.map_row = smg.map_row - diff
	end if
	if(ypos .gt. (smg.map_row + smg.view_row -1)) then
	  diff = ypos - (smg.map_row + smg.view_row - 1)
	  call smg$scroll_viewport(smg.dis_id_idx,smg$m_up,diff)
	  smg.map_row = smg.map_row + diff
	endif
c
	call get_item(ypos,top_level,ptr)
	p_item = ptr
	drow = 1
	call display_item(smg.dis_id_data,smg.data_col,menu_item,drow)
c
c Now make sure item text is in the visable part of the viewport
c and try to keep the whole line in display
c
	new_map_col = smg.map_col
	if(menu_item.col-smg.map_col+menu_item.nkar_name+2.gt.smg.view_col)then
	  new_map_col = menu_item.col+menu_item.nkar_name+2 - smg.view_col 
	endif
c
c Check if starting points in on screen, if not make so,
c this will delete the last kars of the display 
c
	if(new_map_col .gt. menu_item.col) new_map_col = menu_item.col
c
	if(new_map_col .ne. smg.map_col) then
	  smg.map_col = new_map_col
          call smg$change_viewport(smg.dis_id_idx,
     1            smg.map_row,smg.map_col,
     1            smg.view_row,smg.view_col)
	end if
c
	call update_bars(smg)
c
15	call smg$set_cursor_abs(smg.dis_id_idx,ypos,menu_item.col)
	call read_key(smg,row,col,iterm,pf1_flag)
	if(iterm .eq. smg$k_trm_first_down) then
	  pf1_flag = .false.
	  if(row .eq. 1) then
	    iterm = 0
	    row   = 0
	    if(col .gt. 1 .and. col .lt. 5) then
c
c In file menu
c
	      call menu(smg,n_fchoises,fchoises,'File',.false.,1,k,2,3,
     1                  iterm,0,' ',' ')
	      iterm = 0
	      if(k .eq. 1) iterm = smg$k_trm_f10
	      if(k .eq. 2 .or. k .eq. 3) iterm = smg$k_trm_find
	      if(k .eq. 2) pf1_flag = .true.
	    elseif(col .ge. 7 .and. col .le. 11) then
	      goto 30
	    endif
	  endif
	  if(in_box(row,col,smg.idx_box)) then
	    iterm = 0
	    ypos = row + smg.map_row - 1
	    call get_item(ypos,top_level,ptr)
	    p_item = ptr
	    if(col .eq. menu_item.col+1) then
	      if(menu_item.expanded) then
	        iterm = smg$k_trm_left 
	      else
	        iterm = smg$k_trm_right
	      endif
	    endif
	  elseif(in_box(row,col,smg.bar_ver_box)) then
	    if(row .le. smg.bar_ver_p1) iterm = smg$k_trm_prev_screen
	    if(row .ge. smg.bar_ver_p2) iterm = smg$k_trm_next_screen
	  elseif(in_box(row,col,smg.bar_hor_box)) then
	    if(row .le. smg.bar_hor_p1) iterm = smg$k_trm_f11
	    if(row .ge. smg.bar_hor_p2) iterm = smg$k_trm_f12
	  endif
	  if(iterm .eq. smg$k_trm_first_down) goto 15
	  if(iterm .eq. 0) goto 10
	elseif(iterm .eq. smg$k_trm_third_down) then
	  if(in_box(row,col,smg.idx_box)) then
	    iterm = 0
	    ypos = row + smg.map_row - 1
	    call get_item(ypos,top_level,ptr)
	    p_item = ptr
c
	    if(ypos .gt. smg.map_row + smg.view_row/2) then
	      opt_row = ypos - smg.map_row - n_choises + smg.idx_box.beg_row
	    else
	      opt_row = ypos + 2 - smg.map_row + smg.idx_box.beg_row - 1
	    endif
	    width = len(choises(1))
	    nk = min(width,menu_item.nkar_name)
c
	    call menu(smg,n_choises,choises,menu_item.name(1:nk),.false.,1,k,
     1                 opt_row,menu_item.col+menu_item.nkar_name+2+
     1          smg.idx_box.beg_col-smg.map_col+1,
     1                  iterm,0,' ',' ')
	    iterm = 0
	    pf1_flag = .false.
	    if(k .eq. 1) then
	      iterm = smg$k_trm_right
	    elseif(k .eq. 2) then
	      pf1_flag = .true.
	      iterm = smg$k_trm_right
	    elseif(k .eq. 3) then
	      iterm = smg$k_trm_left
	    elseif(k .eq. 4) then
	      iterm = smg$k_trm_remove
	    elseif(k .eq. 5) then
	      iterm = smg$k_trm_insert_here
	    elseif(k .eq. 6) then
	      pf1_flag = .true.
	      iterm = smg$k_trm_insert_here
	    elseif(k .eq. 7) then
	      iterm = smg$k_trm_select
	    else
	      goto 15
	    endif
	  else
	    goto 15
	  endif
	endif
c
	if(iterm .eq. smg$k_trm_up) then
	  if(pf1_flag) then
	    ypos = ypos - 3*smg.nrows/4
	  else
	    ypos = ypos - 1
	  endif
	elseif(iterm .eq. smg$k_trm_prev_screen) then
	  if(pf1_flag) then
	    ypos = 1
	  else
	    ypos = ypos - 3*smg.nrows/4
	  endif
	elseif(iterm .eq. smg$k_trm_next_screen) then
	  if(pf1_flag) then
	    ypos = smg.size_row
	  else
	    ypos = ypos + 3*smg.nrows/4
	  endif
	elseif(iterm .eq. smg$k_trm_down) then
	  if(pf1_flag) then
	    ypos = ypos + 3*smg.nrows/4
	  else
	    ypos = ypos + 1
	  endif
	elseif(iterm .eq. smg$k_trm_f11) then
	  k = max(1,smg.map_col - 10)
	  if(k .ne. smg.map_col) then
	    smg.map_col = k
            call smg$change_viewport(smg.dis_id_idx,
     1            smg.map_row,smg.map_col,
     1            smg.view_row,smg.view_col)
	  endif
	elseif(iterm .eq. smg$k_trm_help) then
	  goto 30
	elseif(iterm .eq. smg$k_trm_f12) then
	  k = min(smg.map_col + 10,smg.size_col - smg.view_col+1)
	  k = max(1,k)
	  if(k .ne. smg.map_col) then
	   smg.map_col = k
           call smg$change_viewport(smg.dis_id_idx,
     1            smg.map_row,smg.map_col,
     1            smg.view_row,smg.view_col)
	  endif
	elseif(iterm .eq. smg$k_trm_left) then
	  if(pf1_flag) then
	  else
	    call shrink_level(smg,ypos,top_level,menu_item)
	  endif
	elseif(iterm .eq. smg$k_trm_remove) then
	  if(menu_item.is_key) then
	    istat = remove_key_val(smg,menu_item)
	  else
	    istat = remove_val_val(smg,menu_item)
	  endif
	  if(istat) then
c
c Key was removed, now get his parent and record one less subkey
c
	    save_p_item = p_item 			!save item
	    save_ypos   = ypos
c
	    p_info = menu_item.ptr_top
	    p_item = menu_info.ptr_parent
	    menu_item.n_subkeys = menu_item.n_subkeys - 1
	    ypos = menu_item.row
	    call shrink_level(smg,ypos,top_level,menu_item)
	    call expand_level(smg,ypos,top_level,menu_item,.false.)
c
	    p_item = save_p_item
	    ypos   = save_ypos
	  endif
	elseif(iterm .eq. smg$k_trm_select) then
	  if(menu_item.is_key) then
	    istat = insert_key_val(smg,menu_item,.true.)
 	  else
 	    istat = insert_val_val(smg,menu_item,.true.)
	  endif
	elseif(iterm .eq. smg$k_trm_insert_here) then
	  if(pf1_flag) then
	    istat = insert_val_val(smg,menu_item,.false.)
	  else
	    istat = insert_key_val(smg,menu_item,.false.)
	  endif
	  if(istat) then
	    menu_item.n_subkeys = menu_item.n_subkeys + 1
	    if(menu_item.expanded) then
	      call shrink_level(smg,ypos,top_level,menu_item)
	      call expand_level(smg,ypos,top_level,menu_item,.false.)
	    endif
	  endif
	elseif(iterm .eq. smg$k_trm_right) then
	  call expand_level(smg,ypos,top_level,menu_item,pf1_flag)
	elseif(iterm .eq. smg$k_trm_find) then
	  if(pf1_flag .or. nk_sear .eq. 0) then
	    if(.not. get_search_parameters(smg,nk_sear,search_string,
     1           search_names,search_values,Case,fromtop)) goto 10
	    bypos = ypos
	  endif
	  if(nk_sear .gt. 0) then
	    if(find_string(smg,bypos,search_string(1:nk_sear),
     1           search_names,search_values,Case,fromtop,top_level)) 
     1         ypos = bypos
	  endif
	elseif(iterm .eq. smg$k_trm_f10) then
	  goto 90
	else
	  goto 15	!ignore
	endif
	goto 10
30	call display_help(smg,n_help,help_lines,'Regedit')
	goto 10
90	return
	end
	function in_box(row,col,box)
	implicit none
	include 'regedit.inc'
c
	integer*4 row
	integer*4 col
	record /box/ box
	logical in_box
c
	if(row .ge. box.beg_row .and. 
     1     row .le. box.end_row .and.
     1     col .ge. box.beg_col .and.
     1     col .le. box.end_col) then
	  row = row - box.beg_row + 1
	  col = col - box.beg_col + 1
	  in_box = .true.
	else
	  in_box = .false.
	end if
	return
	end

	options /recursive
	subroutine expand_level(smg,row,top_level,menu_item,deeper)
	implicit none
c
	include 'regedit.inc'
	integer*4 row
	record /smg/ smg
	record /menu_info/ top_level
	record /menu_item/ menu_item
	logical deeper
c
	integer*4 nrows
c
	record /menu_info/ info
	pointer (p_info,info)
	record /menu_item/ item
	pointer (p_item,item)

c
	if(.not. menu_item.expanded) then
	  if(menu_item.ptr_deep .eq. 0) call insert_tree(menu_item)
	  call expand_smg(smg,menu_item,nrows)
	  call update_row_info(top_level,nrows,menu_item.row)
	endif
	if(deeper) then
	  p_info = menu_item.ptr_deep
	  if(p_info .ne. 0) then
	    p_item = info.ptr_first
	    do while(p_item .ne. 0)
	      call expand_level(smg,row,top_level,item,deeper)
	      p_item = item.ptr_next
	    end do
	  endif	  
	endif
	return
	end
	subroutine shrink_level(smg,row,top_level,menu_item)
	implicit none
c
	include '($smgdef)'
	include 'regedit.inc'
	integer*4 row
	record /smg/ smg
	record /menu_info/ top_level
	record /menu_item/ menu_item
c
	integer*4 nrows,ikar
c
	nrows = 0
	if(menu_item.expanded) then
	  ikar = smg$m_left + smg$m_right 
	  if(menu_item.n_subkeys .gt. 0) ikar = ikar + smg$m_up
	  if(menu_item.valuenumber .gt. 0) ikar = ikar + smg$m_down
c
	  call smg$draw_char(smg.dis_id_idx,ikar,menu_item.row,menu_item.col+1)
	  call shrink_smg(smg,%val(menu_item.ptr_deep),nrows,
     1             menu_item.row+1)
	  menu_item.expanded = .false.
	  call update_row_info(top_level,-nrows,menu_item.row)
	  smg.size_row = smg.size_row - nrows
	  call shrink_tree(%val(menu_item.ptr_deep))
	  menu_item.ptr_deep = 0
	endif
	return
	end
	options /recursive
	subroutine shrink_tree(menu_info)
	implicit none
c
	include 'regedit.inc'
	record /menu_info/ menu_info
c
	integer*4 k
c
	record /menu_item/ item
	pointer (p_item,item)
c
	p_item = menu_info.ptr_first
	do while(p_item .ne. 0) 
	  if(item.ptr_deep .ne. 0) call shrink_tree(%val(item.ptr_deep))
	  k = p_item
	  p_item = item.ptr_next
	  call lib$free_vm(sizeof(item),k)
	end do
	call lib$free_vm(sizeof(menu_info),%loc(menu_info))
	return
	end
	options /recursive
	subroutine shrink_smg(smg,menu_info,nrows,row)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	record /menu_info/ menu_info
	integer*4 nrows
	integer*4 row
c
	record /menu_item/ item
	pointer (p_item,item)
c
	p_item = menu_info.ptr_first
	do while(p_item .ne. 0)
	  call smg$delete_line(smg.dis_id_idx,row)
	  nrows = nrows + 1
	  if(item.expanded) call shrink_smg(smg,%val(item.ptr_deep),nrows,row)
	  p_item = item.ptr_next
	end do
	return
	end
	subroutine get_item(row,top_level,ptr)
	implicit none
c
	integer*4 row
	include 'regedit.inc'
	record /menu_info/ top_level
	integer*4 ptr
c
	integer*4 count
c
	count = row
	call search_item(count,top_level,ptr)
	return
	end
	options /recursive
	subroutine search_item(count,menu_info,ptr)
	implicit none
c
	include 'regedit.inc'
c
	integer*4 count
	record /menu_info/ menu_info
	integer*4 ptr
c
	record /menu_item/ item
	pointer (p_item,item)
c
	p_item = menu_info.ptr_first
	do while(p_item .ne. 0) 
	  count = count - 1
	  if(count .le. 0) then
	    ptr = p_item
	    goto 90
          endif
	  if(item.expanded) then
	    call search_item(count,%val(item.ptr_deep),ptr)
	    if(count .le. 0) goto 90
	  endif
	  p_item = item.ptr_next
	end do
90	return
	end
c
	subroutine insert_tree(menu_item)
	implicit none
	include 'regedit.inc'
	record /menu_item/ menu_item
c
	record /menu_info/ info
	pointer (p_info,info)
c
c Get new info block
c
	call lib$get_vm(sizeof(info),p_info)
	menu_item.ptr_deep = p_info	
	info.n_items = 0
	info.ptr_first = 0
	info.ptr_parent = %loc(menu_item)
c
	call insert_tree_key  (menu_item,info)
	call insert_tree_value(menu_item,info)
	return
	end
	subroutine insert_tree_key(menu_item,info)
	implicit none
	include 'regedit.inc'
	include '($regdef)'
	include '($regmsg)'
c
	record /menu_item/ menu_item
	record /menu_info/ info
c
	character*(max_path) path
	integer*4 nk_path,nit,keyid
	character*(max_unistr_length) subkeyname
	integer*4 nkar_subkey,subkey_idx,istat,iosb(2),functie,k
	integer*4 p_first_item,ii
c
	integer*4 sys$registryw
c
	record /item/ items(5)
	record /menu_item/ item
	pointer (p_item,item)
c
	volatile menu_item,path,nk_path,subkey_idx
	volatile subkeyname,nkar_subkey
c
	nit = 0
c
        nit = nit + 1
        items(nit).opcode = reg$_keyid
        items(nit).buflen = 4
        items(nit).bufadr = %loc(menu_item.keyid)
        items(nit).retadr = 0
c
	call make_name(menu_item,path,nk_path,.true.,.true.)
        if(nk_path .gt. 0) then
          nit = nit + 1
          items(nit).opcode = reg$_keypath
          items(nit).buflen = nk_path
          items(nit).bufadr = %loc(path)
          items(nit).retadr = 0
        end if
c
        nit = nit + 1
        items(nit).opcode = reg$_subkeyindex
        items(nit).buflen = 4
        items(nit).bufadr = %loc(subkey_idx)
        items(nit).retadr = 0
c
        nit = nit + 1
        items(nit).opcode = reg$_subkeyname
        items(nit).buflen = len(subkeyname)
        items(nit).bufadr = %loc(subkeyname)
        items(nit).retadr = %loc(nkar_subkey)
c
        nit = nit + 1
        items(nit).opcode = 0
        items(nit).buflen = 0
        items(nit).bufadr = 0
        items(nit).retadr = 0
c
        functie = reg$fc_enum_key
        subkey_idx = 0
	p_first_item = 0
10      istat = sys$registryw(,%val(functie),,items,iosb,,)
        if(istat) istat = iosb(1)
        if(istat) then
          if(istat .ne. reg$_nomoreitems) then
	    info.n_items = info.n_items + 1
	    call lib$get_vm(sizeof(item),p_item)
	    if(p_first_item .eq. 0) p_first_item = p_item
	    item.keyid = menu_item.keyid
	    item.nkar_uni = nkar_subkey
	    item.uniname  = subkeyname
	    call cvt_uni_to_txt(subkeyname(1:nkar_subkey),item.nkar_name,
     1                   item.name,.false.,ii)
	    item.ptr_deep = 0
	    item.ptr_next = 0
	    item.ptr_top  = %loc(info)
	    item.row      = 0
	    item.level    = menu_item.level+1
	    item.col      = 2*item.level-1
c
c Now hook in
c
	    if(info.ptr_first .eq. 0) then
	      info.ptr_first = p_item
	    else
	      k = p_item
	      p_item = info.ptr_first
	      do while(item.ptr_next .ne. 0) 
	        p_item = item.ptr_next
	      end do
	      item.ptr_next = k
	    endif
c
            subkey_idx = subkey_idx + 1
            goto 10
          endif
        endif
c
c Now get the #subkeys of each new key
c
	p_item = p_first_item
	do while (p_item .ne. 0) 
	  call get_key_info(item)
	  p_item = item.ptr_next
	end do
	return
	end
c
	subroutine insert_tree_value(menu_item,info)
	implicit none
	include 'regedit.inc'
	include '($regdef)'
	include '($regmsg)'
c
	record /menu_item/ menu_item
	record /menu_info/ info
c
	character*(max_path) path
	integer*4 nk_path,nit,keyid
	character*(max_unistr_length) valuename
	integer*4 nkar_value,value_idx,istat,iosb(2),functie,k
	integer*4 p_first_item,ii
c
	integer*4 sys$registryw
c
	record /item/ items(5)
	record /menu_item/ item
	pointer (p_item,item)
c
	volatile menu_item,path,nk_path,value_idx
	volatile valuename,nkar_value
c
	nit = 0
c
        nit = nit + 1
        items(nit).opcode = reg$_keyid
        items(nit).buflen = 4
        items(nit).bufadr = %loc(menu_item.keyid)
        items(nit).retadr = 0
c
	call make_name(menu_item,path,nk_path,.true.,.true.)
        if(nk_path .gt. 0) then
          nit = nit + 1
          items(nit).opcode = reg$_keypath
          items(nit).buflen = nk_path
          items(nit).bufadr = %loc(path)
          items(nit).retadr = 0
        end if
c
        nit = nit + 1
        items(nit).opcode = reg$_valueindex
        items(nit).buflen = 4
        items(nit).bufadr = %loc(value_idx)
        items(nit).retadr = 0
c
        nit = nit + 1
        items(nit).opcode = reg$_valuename
        items(nit).buflen = len(valuename)
        items(nit).bufadr = %loc(valuename)
        items(nit).retadr = %loc(nkar_value)
c
        nit = nit + 1
        items(nit).opcode = 0
        items(nit).buflen = 0
        items(nit).bufadr = 0
        items(nit).retadr = 0
c
        functie = reg$fc_enum_value
        value_idx = 0
	p_first_item = 0
10      istat = sys$registryw(,%val(functie),,items,iosb,,)
        if(istat) istat = iosb(1)
        if(istat) then
          if(istat .ne. reg$_nomoreitems) then
	    info.n_items = info.n_items + 1
	    call lib$get_vm(sizeof(item),p_item)
	    if(p_first_item .eq. 0) p_first_item = p_item
	    item.keyid    = menu_item.keyid
	    item.nkar_uni = nkar_value
	    item.uniname  = valuename
	    call cvt_uni_to_txt(valuename(1:nkar_value),item.nkar_name,
     1                   item.name,.false.,ii)
	    item.ptr_deep = 0
	    item.ptr_next = 0
	    item.ptr_top  = %loc(info)
	    item.row      = 0
	    item.level    = menu_item.level+1
	    item.col      = 2*item.level-1
c
c Now hook in
c
	    if(info.ptr_first .eq. 0) then
	      info.ptr_first = p_item
	    else
	      k = p_item
	      p_item = info.ptr_first
	      do while(item.ptr_next .ne. 0) 
	        p_item = item.ptr_next
	      end do
	      item.ptr_next = k
	    endif
c
            value_idx = value_idx + 1
            goto 10
          endif
        endif
c
c Now get the #subkeys of each new key
c
	p_item = p_first_item
	do while (p_item .ne. 0) 
	  call get_val_info(item)
	  p_item = item.ptr_next
	end do
	return
	end
c
	subroutine make_name(menu_item,path,nk_path,unicode,lasttoo)
	implicit none
c
	include 'regedit.inc'
	record /menu_item/ menu_item
	character*(*) path
	integer*4 nk_path
	logical unicode
	logical lasttoo
c
	record /menu_item/ item
	pointer (p_item,item)
	record /menu_info/ info
	pointer (p_info,info)
c
	integer*4 limit
	logical first
c
	limit = 1
	if(unicode) limit = 2
c
	first = .true.
	nk_path = 0
	p_item = %loc(menu_item)
	do while(p_item .ne. 0)
	  if(item.level .ge. limit) then
 	    if(lasttoo .or. .not. first) then
	      if(nk_path .gt. 0) then
	        if(unicode) then
	          path = item.uniname(1:item.nkar_uni)//
     1             '\'//char(0)//char(0)//char(0)//
     1             path(1:nk_path)
	          nk_path = nk_path + 4 + item.nkar_uni
	        else
	          path = item.name(1:item.nkar_name)//
     1             '\'//path(1:nk_path)
	          nk_path = nk_path + 1 + item.nkar_name
	        endif
	      else
	        if(unicode) then
	          path = item.uniname(1:item.nkar_uni)
	          nk_path = item.nkar_uni
	        else
	          path = item.name(1:item.nkar_name)
	          nk_path = item.nkar_name
	        endif
	      endif
	    endif
	    p_info = item.ptr_top
	    p_item = info.ptr_parent
	    first = .false.
	  else
	    p_item = 0
	  end if
	end do
	return
	end
	subroutine expand_smg(smg,menu_item,nrows)
	implicit none
	include 'regedit.inc'
	include '($smgdef)'
	record /smg/ smg
	record /menu_item/ menu_item
	integer*4 nrows
c
	integer ikar
	integer nk,row,k
	character*(max_str_length) line
c
	record /menu_info/ info
	pointer (p_info,info)
	record /menu_item/ item
	pointer (p_item,item)
c
	row   = menu_item.row
	ikar = smg$m_left + smg$m_right
	call smg$put_chars(smg.dis_id_idx,' ' ,menu_item.row,menu_item.col+1)
	call smg$draw_char(smg.dis_id_idx,ikar,menu_item.row,menu_item.col+1)
	call smg$read_from_display(smg.dis_id_idx,line,,menu_item.row)
	nrows = 0
	p_info = menu_item.ptr_deep
	if(p_info .ne. 0) then
	  p_item = info.ptr_first
	  do while(p_item .ne. 0) 
	    row = row + 1
	    item.row = row
	    nrows = nrows + 1
	    item.expanded = .false.
c
	    call smg$insert_line(smg.dis_id_idx,item.row,,smg$m_down)
c
c	    call smg$put_chars(smg.dis_id_idx,line(1:item.col-3),item.row,1)
	    ikar = smg$m_up + smg$m_down
	    do k=1,item.col-4,2
	      if(line(k:k) .ne. ' ') then
	        call smg$draw_char(smg.dis_id_idx,ikar,item.row,k)
	      endif
	    end do
	    if(menu_item.ptr_next .ne. 0) then
	      call smg$draw_char(smg.dis_id_idx,ikar,item.row,item.col-2)
	    endif
c
	    ikar = smg$m_up .or. smg$m_right
	    if(item.ptr_next .ne. 0) ikar = ikar + smg$m_down
	    call smg$draw_char(smg.dis_id_idx,ikar,item.row,item.col)
c
	    ikar = smg$m_left + smg$m_right
	    if(item.n_subkeys .gt. 0) ikar = ikar + smg$m_up
	    if(item.valuenumber .gt. 0) ikar = ikar + smg$m_down
	    call smg$draw_char(smg.dis_id_idx,ikar,item.row,item.col+1)
c
	    nk = item.nkar_name
	    call smg$put_chars(smg.dis_id_idx,item.name(1:nk),
     1           item.row,item.col+2)
	    if(nk+item.col+2 .gt. smg.size_col) smg.size_col = nk+item.col+2
	    item.row = - item.row	!for update_row_info
	    p_item = item.ptr_next
	  end do
	end if
	menu_item.expanded = .true.
	smg.size_row = smg.size_row + nrows
	return
	end
	options /recursive
	subroutine update_row_info(menu_info,nrows,minrow)
	implicit none
	include 'regedit.inc'
	record /menu_info/ menu_info
	integer nrows
	integer minrow
c
	record /menu_info/ info
	pointer (p_info,info)
	record /menu_item/ item
	pointer (p_item,item)
c
	p_item = menu_info.ptr_first
	do while(p_item .ne. 0)
	  if(item.row .lt. 0) then
	    item.row = - item.row
	  else
	    if(item.row .gt. minrow) item.row = item.row + nrows
	  endif
	  if(item.expanded) then
	    p_info = item.ptr_deep
	    call update_row_info(info,nrows,minrow)
	  endif
	  p_item = item.ptr_next
	end do
	return
	end
	function get_key_info(menu_item)
	implicit none
c
	include 'regedit.inc'
	include '($regdef)'
	record /menu_item/ menu_item
	logical get_key_info
c
	character*(max_path) path
	integer*4 nk_path
c
	record /item/ items(20)
c
	integer*4 functie,istat,iosb(2),nit
	integer*4 sys$registryw
c
	volatile menu_item,path,nk_path
c
	nit = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_keyid
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.keyid)
	items(nit).retadr = 0
c
	nit = nit + 1
	call make_name(menu_item,path,nk_path,.true.,.true.)
	items(nit).opcode = reg$_keypath
	items(nit).buflen = nk_path
	items(nit).bufadr = %loc(path)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_subkeysnumber
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.n_subkeys)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_CACHEACTION 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.cacheaction)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_CLASSNAME 
	items(nit).buflen = len(menu_item.classname)
	items(nit).bufadr = %loc(menu_item.classname)
	items(nit).retadr = %loc(menu_item.nk_classname)
c
	nit = nit + 1
	items(nit).opcode = REG$_KEYFLAGS 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.keyflags)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_LASTWRITE
	items(nit).buflen = 8
	items(nit).bufadr = %loc(menu_item.lastwrite)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKCOUNT 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.linkcount)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKPATH 
	items(nit).buflen = len(menu_item.linkpath)
	items(nit).bufadr = %loc(menu_item.linkpath)
	items(nit).retadr = %loc(menu_item.nk_linkpath)
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKTYPE 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.linktype)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKcount 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.linkcount)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_securityPOLICY 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.secpolicy)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_VALUENUMBER 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.valuenumber)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_VOLATILE 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.volatile)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
	items(nit).bufadr = 0
	items(nit).retadr = 0
c
	menu_item.is_key = .true.
c
	functie = reg$fc_query_key
10	istat = sys$registryw(,%val(functie),,items,iosb,,)
	if(istat) istat = iosb(1)
	get_key_info = istat
	return
	end	  
	function get_val_info(menu_item)
	implicit none
c
	include 'regedit.inc'
	include '($regdef)'
	record /menu_item/ menu_item
	logical get_val_info
c
	character*(max_path) path
	integer*4 nk_path
c
	record /item/ items(20)
c
	integer*4 functie,istat,iosb(2),nit
	integer*4 sys$registryw
c
	volatile menu_item,path,nk_path
c
	nit = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_keyid
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.keyid)
	items(nit).retadr = 0
c
	nit = nit + 1
	call make_name(menu_item,path,nk_path,.true.,.false.)
	items(nit).opcode = reg$_keypath
	items(nit).buflen = nk_path
	items(nit).bufadr = %loc(path)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_valuename
	items(nit).buflen = menu_item.nkar_uni
	items(nit).bufadr = %loc(menu_item.uniname)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_dataflags
	items(nit).buflen = 8
	items(nit).bufadr = %loc(menu_item.dataflags)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_valuedata
	items(nit).buflen = len(menu_item.valuedata)
	items(nit).bufadr = %loc(menu_item.valuedata)
	items(nit).retadr = %loc(menu_item.nk_valuedata)
c
	nit = nit + 1
	items(nit).opcode = REG$_datatype
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.datatype)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKCOUNT 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.linkcount)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKPATH 
	items(nit).buflen = len(menu_item.linkpath)
	items(nit).bufadr = %loc(menu_item.linkpath)
	items(nit).retadr = %loc(menu_item.nk_linkpath)
c
	nit = nit + 1
	items(nit).opcode = REG$_LINKTYPE 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.linktype)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = REG$_VOLATILE 
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.volatile)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
	items(nit).bufadr = 0
	items(nit).retadr = 0
c
	menu_item.is_key = .false.
c
	functie = reg$fc_query_value
10	istat = sys$registryw(,%val(functie),,items,iosb,,)
	if(istat) istat = iosb(1)
	get_val_info = istat
	return
	end	  
	options /exte
	subroutine display_item(dis_id_data,width,item,row)
	implicit none
c
c Display al info in data window
c
	include 'regedit.inc'
	include '($smgdef)'
	include '($regdef)'
	integer*4 dis_id_data
	integer*4 width
	record /menu_item/ item
	integer*4 row
c
	character*(max_path) line
	integer*4 nk,ii
c
	integer*4 indent
	parameter (indent=17)
c
	call smg$erase_display(dis_id_data,row,1)
	call make_name(item,line,nk,.false.,.true.)
c
	if(item.is_key) then
	  call smg$put_chars(dis_id_data,'Key name:',row,1)
	else
	  call smg$put_chars(dis_id_data,'Value name:',row,1)
	endif
	call put_line_ident(dis_id_data,width,line(1:nk),row,indent)
c
	if(item.is_key) then
	  call cvt_secpolicy(item.secpolicy,line,nk,0,0,0)
	  row = row + 1
	  call smg$put_chars(dis_id_data,'Security policy:',row,1)
	  call smg$put_chars(dis_id_data,line(1:nk),row,indent)
c
	endif
c
	row = row + 1
	call cvt_uni_to_txt(item.linkpath(1:item.nk_linkpath),nk,line,
     1          .false.,ii)
	call smg$put_chars(dis_id_data,'Link path:',row,1)
	call put_line_ident(dis_id_data,width,line(1:nk),row,indent)
c
	call cvt_volatile(item.volatile,line,nk,0,0,0)
	row = row + 1
	call smg$put_chars(dis_id_data,'Volatile:',row,1)
	call smg$put_chars(dis_id_data,line(1:nk),row,indent)
c
	if(item.is_key) then
	  call cvt_cacheaction(item.cacheaction,line,nk,0,0,0)
	  row = row + 1
	  call smg$put_chars(dis_id_data,'Cache action:',row,1)
	  call smg$put_chars(dis_id_data,line(1:nk),row,indent)
c
	  call cvt_uni_to_txt(item.classname(1:item.nk_classname),
     1              nk,line,.false.,ii)
	  row = row + 1
	  call smg$put_chars(dis_id_data,'Class:',row,1)
	  call put_line_ident(dis_id_data,width,line(1:nk),row,indent)
	endif
c
	line = '?'
	if(item.linktype.eq.reg$k_none) line='REG$K_NONE'
	if(item.linktype.eq.reg$k_symboliclink) line='REG$K_SYMBOLICLINK'
	row = row + 1
	call smg$put_chars(dis_id_data,'Link type:',row,1)
	call smg$put_chars(dis_id_data,line(1:20),row,indent)
c
	if(item.is_key) then
	  row = row + 1
	  call sys$asctim(nk,line,item.lastwrite,)
	  call smg$put_chars(dis_id_data,'Last written:',row,1)
	  call smg$put_chars(dis_id_data,line(1:nk),row,indent)
	endif
c
	if(.not. item.is_key) then
	  row = row + 1
	  call cvt_datatype(item.datatype,line,nk,0,0,0)
	  row = row + 1                              
	  call smg$put_chars(dis_id_data,'Data type:',row,1)
	  call smg$put_chars(dis_id_data,line(1:nk),row,indent)
c
	  call cvt_data_to_text(item.valuedata(1:item.nk_valuedata),
     1         item.datatype,nk,line)
	  row = row + 1
	  call smg$put_chars(dis_id_data,'Data value:',row,1)
	  call put_line_ident(dis_id_data,width,line(1:nk),row,indent)
	end if
	row = row + 1
	return
	end
	function cvt_datatype(datatype,line,nk,option,smg,box)
	implicit none
c
	include '($regdef)'
c
	integer*4 datatype
	character*(*) line
	integer*4 nk
	logical option
	integer smg
	integer box
	logical cvt_datatype
c
	character*40 temp
	integer*4 k
c
	integer*4 n_choises
	parameter (n_choises= 7)
c
	character*(15) choises(n_choises)
	integer*4 values(n_choises)
c
	data choises/
     1        'REG$K_BINARY',
     1        'REG$K_DWORD',
     1        'REG$K_EXPAND_SZ',
     1        'REG$K_MULTI_SZ',
     1        'REG$K_NONE',
     1        'REG$K_QWORD',
     1        'REG$K_SZ'/
	data values/
     1      reg$k_binary,
     1      reg$k_dword,
     1      reg$k_expand_sz,
     1      reg$k_multi_sz,
     1      reg$k_none,
     1      reg$k_qword,
     1      reg$k_sz/
c
	integer cvt_data
c
	cvt_datatype = cvt_data(n_choises,choises,values,datatype,line,nk,
     1        option,smg,box)
	return
	end
	function cvt_data(n_choises,choises,values,datatype,line,nk,
     1        option,smg,box)
c
	implicit none
c
	include 'regedit.inc'
c
	integer*4 n_choises
	character*(*) choises(n_choises)
	integer*4 values(n_choises)
	integer*4 datatype
	character*(*) line
	integer*4 nk
	integer*4 option
	record /smg/ smg
	record /box/ box
	logical cvt_data
c
	include '($smgdef)'

c
	character*80 temp
	integer*4 k,match,dis_id,def_ch,iterm
c
	integer*4 check_val
	integer*4 get_len
c
	cvt_data = .true.
	if(option .eq. 0) then
	  line = '?'
	  do k=1,n_choises
	    if(datatype .eq. values(k)) line = choises(k)
	  enddo
	  nk = index(line,' ')-1
	  if(line(1:1) .eq. '?') cvt_data = .true.
	elseif(option .eq. 1) then
	  match = check_val(line(1:nk),n_choises,choises)
	  if(match .ne. 0) then
	    datatype = values(match)
	  else
	    cvt_data = .false.
	  endif
	elseif(option .eq. 2) then
	  def_ch = 1
	  do k=1,n_choises
	    if(values(k) .eq. datatype) def_ch = k	    
	  end do
	  call menu(smg,n_choises,choises,choises(def_ch),.false.,def_ch,k,
     1                box.beg_row+1,box.beg_col-1,
     1                  iterm,0,' ',' ')
	  if(k .gt. 0 .and. k .le. n_choises) then
	    datatype = values(k)
	    line = choises(k)
	    nk = get_len(line)
	  else
	    cvt_data = .false.
	  endif
	  call smg$delete_virtual_display(dis_id)
	endif
	return
	end
	function cvt_volatile(volatile,line,nk,option,smg,box)
	implicit none
c
	include '($regdef)'
c
	integer*4 volatile
	character*(*) line
	integer*4 nk
	integer*4 option
	integer smg
	integer box
	logical cvt_volatile
c
	integer*4 n_choises
	parameter (n_choises= 2)
c
	character*(13) choises(n_choises)
	integer*4 values(n_choises)
c
	data choises/
     1        'REG$K_CLUSTER',
     1        'REG$K_NONE'/
	data values/
     1        reg$k_cluster,
     1        reg$k_none/
c
	integer cvt_data
c
	cvt_volatile = cvt_data(n_choises,choises,values,volatile,line,nk,
     1        option,smg,box)
	return
	end
	function cvt_yesno(yesno,line,nk,option,smg,box)
	implicit none
c
	include '($regdef)'
c
	integer*4 yesno
	character*(*) line
	integer*4 nk
	integer*4 option
	integer smg
	integer box
	logical cvt_yesno
c
	integer*4 n_choises
	parameter (n_choises= 2)
c
	character*(3) choises(n_choises)
	integer*4 values(n_choises)
c
	data choises/
     1        'YES',
     1        'NO'/
	data values/
     1        1,
     1        0/
c
	integer cvt_data
c
	cvt_yesno = cvt_data(n_choises,choises,values,yesno,line,nk,
     1        option,smg,box)
	return
	end
	function cvt_cacheaction(cacheaction,line,nk,option,smg,box)
	implicit none
c
	include '($regdef)'
c
	integer*4 cacheaction
	character*(*) line
	integer*4 nk
	integer*4 option
	integer smg
	integer box
	logical cvt_cacheaction
c
	integer*4 n_choises
	parameter (n_choises= 2)
c
	character*(17) choises(n_choises)
	integer*4 values(n_choises)
c
	data choises/
     1        'REG$K_WRITEBEHIND',
     1        'REG$K_WRITETHRU'/
	data values/
     1        reg$k_writebehind,
     1        reg$k_writethru/
c
	integer cvt_data
c
	cvt_cacheaction = cvt_data(n_choises,choises,values,
     1        cacheaction,line,nk,option,smg,box)
	return
	end
	function cvt_secpolicy(secpolicy,line,nk,option,smg,box)
	implicit none
c
	include '($regdef)'
c
	integer*4 secpolicy
	character*(*) line
	integer*4 nk
	integer*4 option
	integer smg
	integer*4 box
	logical cvt_secpolicy
c
	integer*4 n_choises
	parameter (n_choises= 2)
c
	character*(18) choises(n_choises)
	integer*4 values(n_choises)
c
	data choises/
     1        'REG$K_POLICY_NT_40',
     1        'REG$K_POLICY_OPENVMS'/
	data values/
     1        reg$k_policy_nt_40,
     1        reg$k_policy_openvms/
c
	integer cvt_data
c
	cvt_secpolicy = cvt_data(n_choises,choises,values,
     1        secpolicy,line,nk,option,smg,box)
	return
	end
c
	subroutine cvt_data_to_text(data,datatype,nk,line)
	implicit none
c
	include '($regdef)'
	character*(*) data
	integer datatype
	integer nk
	character*(*) line

c
	integer k,l,ii,bpos_d,bpos_t
	integer*8 i8
c
	if(datatype .eq. reg$k_dword) then
	  call lib$movc3(4,%ref(data),k)
	  write(line(1:10),1000) k
1000	  format('%X',z8.8)
	  nk = 10
	elseif(datatype .eq. reg$k_qword) then
	  call lib$movc3(8,%ref(data),i8)
	  write(line(1:21),1010) i8
1010	  format('%X',z16.16)
	  nk = 18
	elseif(datatype .eq. reg$k_multi_sz) then
	  bpos_d = 1
	  bpos_t = 1
10	  call cvt_uni_to_txt(data(bpos_d:),nk,line(bpos_t:),.true.,ii)
	  ii = ii+bpos_d-1
	  bpos_d = ii
	  bpos_t = bpos_t+nk
	  if(ii .lt. len(data)) goto 10
	elseif(datatype .eq. reg$k_expand_sz) then
	  call cvt_uni_to_txt(data,nk,line,.false.,ii)
	elseif(datatype .eq. reg$k_sz) then
	  call cvt_uni_to_txt(data,nk,line,.true.,ii)
	else
	  nk = 0
	  do k=1,len(data)
	    write(line(nk+1:nk+3),1020) ichar(data(k:k))
1020	    format(z3.2)
	    nk = nk + 3
	  end do
	endif
	return
	end
	function cvt_text_to_data(line,datatype,nk,data)
	implicit none
c
	include '($regdef)'
	character*(*) line
	integer datatype
	integer nk
	character*(*) data
	logical cvt_text_to_data
c
	integer k,l,ii,bpos,epos,nk1
	integer*8 i8
	integer*4 i4
c
	cvt_text_to_data = .false.
	if(datatype .eq. reg$k_dword) then
	  bpos = 1
	  if(line(1:2) .eq. '%X' .or. line(1:2) .eq. '%x') bpos = 3 
	  read(line(bpos:),2000,err=90) i4
2000	  format(bn,z16)
	  call lib$movc3(4,i4,%ref(data))
	  nk = 4
	elseif(datatype .eq. reg$k_qword) then
	  bpos = 1
	  if(line(1:2) .eq. '%X' .or. line(1:2) .eq. '%x') bpos = 3 
	  read(line(bpos:),2010,err=90) i8
2010	  format(bn,z16)
	  call lib$movc3(8,i8,%ref(data))
	  nk = 8
	elseif(datatype .eq. reg$k_multi_sz) then
	  nk = 0
	  bpos = 1
10	  epos = index(line(bpos:),',')
	  if(epos .eq. 0) then
	    epos = len(line)
	  else
	    epos = epos + bpos - 1
	  endif
	  call cvt_txt_to_uni(line(bpos:epos),nk1,data(nk+1:))
	  nk = nk + nk1
	  data(nk+1:nk+4) = char(0)//char(0)//char(0)//char(0)
	  nk = nk + 4
	  if(epos .lt. len(line)) then
	   bpos = epos + 1
	   goto 10
	  endif
	elseif(datatype .eq. reg$k_expand_sz) then
	  call cvt_txt_to_uni(line,nk,data)
	  data(nk+1:nk+4) = char(0)//char(0)//char(0)//char(0)
	elseif(datatype .eq. reg$k_sz) then
	  call cvt_txt_to_uni(line,nk,data)
	  data(nk+1:nk+4) = char(0)//char(0)//char(0)//char(0)
	else
	  bpos = 1
	  nk = 0
	  do while(bpos .lt. len(line))
41	    if(line(bpos:bpos) .eq. ' ') then
	      bpos = bpos + 1
	      if(bpos .lt. len(line)) goto 41
	    else
	      read(line(bpos:bpos+1),2020,err=90) k
2020	      format(bn,z2)
	      nk = nk + 1
	      data(nk:nk) = char(k)
	      bpos = bpos + 2
	    endif
	  enddo
	endif
	cvt_text_to_data = .true.
90	return
	end
	subroutine put_line_ident(dis_id,width,line,row,col)
	implicit none
c
	integer*4 dis_id
	integer*4 width
	character*(*) line
	integer*4 row
	integer*4 col
c
	integer*4 bpos,epos,wid
c
	wid = width - col + 1
	bpos = 1
	do while(bpos .le. len(line))
	  epos = min(len(line),bpos+wid-1)
	  call smg$put_chars(dis_id,line(bpos:epos),row,col)
	  if(epos .lt. len(line)) row = row + 1
	  bpos = epos + 1
	end do
	return
	end
	subroutine update_bars(smg)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
c
	call update_bar_ver(smg)
	call update_bar_hor(smg)
	return
	end
	subroutine update_bar_ver(smg)
	implicit none
c
	include '($smgdef)'
	include 'regedit.inc'
	record /smg/ smg
c
	integer*4 k,p1,p2,video
	character kar
c
	call get_parts(smg.map_row,smg.view_row,smg.size_row,p1,p2)
	if(p1 .ne. smg.bar_ver_p1 .or. p2 .ne. smg.bar_ver_p2) then
	  smg.bar_ver_p1 = p1
	  smg.bar_ver_p2 = p2
	  do k=1,smg.view_row
	    if(k .le. p1 .or. k .ge. p2) then
	      kar = '|'
	      video = 0
	    else
	      kar = ' '
	      video = smg$m_reverse
	    endif
	    call smg$put_chars(smg.dis_bar_ver,kar,k,1,,video)
	  end do
	end if
	return
	end
	subroutine update_bar_hor(smg)
	implicit none
c
	include '($smgdef)'
	include 'regedit.inc'
	record /smg/ smg
c
	integer*4 k,p1,p2,video
	character kar
c
	call get_parts(smg.map_col,smg.view_col,smg.size_col,p1,p2)
	if(p1 .ne. smg.bar_hor_p1 .or. p2 .ne. smg.bar_hor_p2) then
	  smg.bar_hor_p1 = p1
	  smg.bar_hor_p2 = p2
	  do k=1,smg.view_col
	    if(k .le. p1 .or. k .ge. p2) then
	      kar = '-'
	      video = 0
	    else
	      kar = ' '
	      video = smg$m_reverse
	    endif
	    call smg$put_chars(smg.dis_bar_hor,kar,1,k,,video)
	  end do
	end if
	return
	end
	subroutine get_parts(offset,size,totsize,p1,p2)
	implicit none
c
	integer*4 offset
	integer*4 size
	integer*4 totsize
	integer p1
	integer p2
c
	integer*4 cnt
c
	if(size .ge. totsize) then
	  p1 = 0
	  p2 = size+1
	else
	  p1 = size*(float(offset-1)/float(totsize))
	  if(offset .gt. 1 .and. p1 .lt. 1) p1 = 1
	  cnt = totsize - size - offset+1
	  p2 = size*(float(cnt)/float(totsize))
	  if(cnt .gt. 0 .and. p2 .eq. 0) p2 = 1
	  p2 = size+1-p2
	endif
	return
	end
	function get_search_parameters(smg,nk_sear,search_string,
     1           search_names,search_values,Case,fromtop)
	implicit none
c
	include 'regedit.inc'
	include '($smgdef)'
	include '($trmdef)'
 	record /smg/ smg
	integer*4 nk_sear
	character*(*) search_string
	logical search_names
	logical search_values
	logical case
	logical fromtop
	logical get_search_parameters
c
	record /box/ box
c
	integer*4 dis_id,ipos,iterm
	integer*4 row,col,spos
c
	integer*4 n_lines
	parameter (n_lines = 7)
	character*40 lines(n_lines),line
	integer*4 nk_lines(n_lines),nk_line,k,nk
	logical pf1_flag
	integer*4 xpos(n_lines),ypos(n_lines),nkars(n_lines)
	record /box/ boxes(n_lines)
c
	integer*4 n_help
	parameter (n_help=6)
	character*(45) help_lines(n_help)
	data help_lines /
     1    'Start search',
     1    'String : wanted string',
     1    'Search names : Search value in the keynames',
     1    'Search values : Search value in the keyvalues',
     1    'Case sensitive : Search is case sensitive',
     1    'From top : Search from the top'/
c
	integer*4 in_box
	logical cvt_yesno
c
	get_search_parameters = .false.
c
	call smg$create_virtual_display(n_lines,55,dis_id)
	call smg$label_border(dis_id,'Search for')
c
	call smg$put_chars(dis_id,'String        :',1,1)
	xpos(1) = 16
	ypos(1) =  1
	nkars(1) = 40
	call smg$put_chars(dis_id,'Search names  :',2,1)
	xpos(2) = 16                             
	ypos(2) =  2
	nkars(2) = 3
	call smg$put_chars(dis_id,'Search values :',3,1)
	xpos(3) = 16
	ypos(3) =  3
	nkars(3) = 3
	call smg$put_chars(dis_id,'Case sensitive:',4,1)
	xpos(4) = 16
	ypos(4) =  4
	nkars(4) = 3
	call smg$put_chars(dis_id,'From top      :',5,1)
	xpos(5) = 16
	ypos(5) =  5
	nkars(5) = 3
c
	lines(6) = 'OK(do)'
	nk_lines(6) = 6
	nkars(6) = 6
	ypos(6) = 6
	xpos(6) = 5
c
	lines(7) = 'Cancel(PF4)'
	nk_lines(7) = 11
	nkars(7) = 11
	ypos(7) = 6
	xpos(7) = 15
c
	lines(1) = search_string(1:nk_sear)
	nk_lines(1) = nk_sear
c
	call cvt_yesno(search_names ,lines(2),nk_lines(2),0,smg,boxes(ipos))
	call cvt_yesno(search_values,lines(3),nk_lines(3),0,smg,boxes(ipos))
	call cvt_yesno(case         ,lines(4),nk_lines(4),0,smg,boxes(ipos))
	call cvt_yesno(fromtop      ,lines(5),nk_lines(5),0,smg,boxes(ipos))
c
	do ipos=1,n_lines
	  call set_box(boxes(ipos),10,10,
     1                ypos(ipos),xpos(ipos),1,nkars(ipos))
	  call smg$put_chars(dis_id,lines(ipos)(1:nk_lines(ipos)),
     1           ypos(ipos),xpos(ipos))
	end do
c
	call smg$paste_virtual_display(dis_id,smg.paste_id,10,10)
	box.beg_row = 10
	box.end_row = 10
	box.beg_col = box.beg_row + n_lines - 1
	box.end_col = box.beg_col + 55 - 1
c
c
	ipos = 1
10	if(ipos .lt. 1) ipos = 1
	if(ipos .gt. n_lines) ipos = n_lines
c
	call smg$set_cursor_abs(dis_id,ypos(ipos),xpos(ipos))
	if(ipos .lt. 6) then

	  if(spos .eq. 0) spos = nk_lines(ipos)+1
	  call get_string(smg,dis_id,box,ypos(ipos),xpos(ipos),40,
     1          lines(ipos),nk_lines(ipos),nkars(ipos),iterm,
     1          row,col,spos,
     1          n_help,help_lines,'Search')
	  spos = 0
	else
	  call read_key(smg,row,col,iterm,pf1_flag)
	endif
c
	if(iterm .eq. smg$k_trm_first_down) then
	  do k=1,5
	    if(in_box(row,col,boxes(k))) goto 12
	  end do
	  if(in_box(row,col,boxes(6))) goto 80
	  if(in_box(row,col,boxes(7))) goto 90
	  goto 10
12	  ipos = k
	  spos = col
	elseif(iterm .eq. smg$k_trm_find .or. 
     1         iterm .eq. smg$k_trm_third_down) then
	  if(iterm .eq. smg$k_trm_third_down) then
	    do k=2,5
	      if(in_box(row,col,boxes(k))) goto 14
	    end do
	    goto 10
14	    ipos = k
	  endif
	  if(cvt_yesno(k,line,nk,2,smg,boxes(ipos))) then
	    lines(ipos) = line
	    nk_lines(ipos) = nk
	  endif
	  call smg$put_chars(dis_id,lines(ipos),ypos(ipos),xpos(ipos))
	elseif(iterm .eq. smg$k_trm_enter .or. iterm .eq. smg$k_trm_ht .or.
     1         iterm .eq. smg$k_trm_down) then
	  ipos = ipos + 1
	elseif(iterm .eq. smg$k_trm_up) then
	  ipos = ipos - 1
	elseif(iterm .eq. smg$k_trm_do .or. iterm .eq. smg$k_trm_find) then
	  goto 80
	elseif(iterm .eq. smg$k_trm_pf4) then
	  goto 90
	elseif(iterm .eq. smg$k_trm_f10 .or. iterm .eq. smg$k_trm_ctrlz) then
	  goto 90
	endif
	goto 10
80	do ipos=2,5
	  if(.not. cvt_yesno(k,lines(ipos),nk_lines(ipos),1,
     1          smg,boxes(ipos))) then
	    call message(smg,'Invalid value')
	    goto 10
	  endif
	end do
c
	call smg$put_chars(dis_id,lines(ipos)(1:nk_lines(ipos)),
     1        ipos,xpos(ipos))
	search_string = lines(1)
	nk_sear       = nk_lines(1)
c
	call cvt_yesno(search_names ,lines(2),nk_lines(2),1,smg,boxes(2))
	call cvt_yesno(search_values,lines(3),nk_lines(3),1,smg,boxes(3))
	call cvt_yesno(case         ,lines(4),nk_lines(4),1,smg,boxes(4))
	call cvt_yesno(fromtop      ,lines(5),nk_lines(5),1,smg,boxes(5))
c
	get_search_parameters = .true.
c
90	call smg$delete_virtual_display(dis_id)
	return
	end
	function check_val(val,nval,allowed)
	implicit none
	character*(*) val
	integer*4 nval
	character*(*) allowed(nval)
	integer check_val
c
	character*80 temp
	integer*4 nk,idx,k
c
	integer*4 get_len
c
	idx = 0
	call str$upcase(temp,val)
c
	nk = get_len(temp)
	if(nk .eq. 0) goto 90
c
20	idx = 0
	do k=1,nval
	  if(temp(1:nk) .eq. allowed(k)(1:nk)) then
	    if(idx .ne. 0) then
	      idx = 0		!double match
	      goto 90
	    endif
	    idx = k
	  endif
	end do
90	check_val = idx
	return
	end
	function find_string(smg,ypos,search_string,
     1           search_names,search_values,Case,fromtop,top_level)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	integer*4 ypos
	character*(*) search_string
	logical search_names
	logical search_values
	logical case
	logical fromtop
	record /menu_info/ top_level
	integer find_string
c
	integer*4 ptr,nk,dis_id,indx,nrows
	logical do_redis
c
	record /menu_item/ item
	pointer (p_item,item)
	record /menu_info/ info
	pointer (p_info,info)
c
	logical find_string_sub
c
	character*(max_str_length) line
c
	call get_item(ypos,top_level,ptr)
	p_item = ptr
c
	call smg$create_virtual_display(15,70,dis_id)
	call smg$label_border(dis_id,'Search results')
	call smg$put_chars(dis_id,'Search for     :'//search_string,1,1)
c
c
c	call yesno(search_names ,nk,line)
	call cvt_yesno(search_names ,line,nk,0,smg,0)
	call smg$put_chars(dis_id,'Search names   :'//line(1:nk),2,1)
c
c	call yesno(search_values,nk,line)         
	call cvt_yesno(search_values,line,nk,0,smg,0)
	call smg$put_chars(dis_id,'Search values  :'//line(1:nk),3,1)
c
c	call yesno(case         ,nk,line)
	call cvt_yesno(case         ,line,nk,0,smg,0)
	call smg$put_chars(dis_id,'Case sensitive :'//line(1:nk),4,1)
c
c	call yesno(fromtop      ,nk,line)
	call cvt_yesno(fromtop      ,line,nk,0,smg,0)
	call smg$put_chars(dis_id,'From top       :'//line(1:nk),5,1)
c
	call smg$paste_virtual_display(dis_id,smg.paste_id,5,5)
c
	if(case) then
	  line = search_string
	else
	  call str$upcase(line,search_string)
	endif
	nk = len(search_string)
c
	if(fromtop) then
	  indx = find_string_sub(top_level,line(1:nk),
     1           search_names,search_values,Case,dis_id,smg)
	else
	  if(item.ptr_deep .eq. 0) call insert_tree(item)
	  p_info = item.ptr_deep
	  if(p_info .ne. 0) then
	    indx = find_string_sub(info,line(1:nk),
     1           search_names,search_values,Case,dis_id,smg)
	    if(indx .lt. 0) indx = 0
	  else
	    indx = 0
	  end if
	endif
	call smg$delete_virtual_display(dis_id)
	if(indx .eq. 0 .or. indx .eq. -1) then
	  find_string = .false.
	else
	  find_string = .true.
	  p_item = indx
c
c Now check if the whole tree upto the top is expanded
c if not so make it expanded
c
	  do_redis = .false.
	  p_info = item.ptr_top
	  ypos = item.row
c
	  do while(p_info .ne. 0)
	    p_item = info.ptr_parent
	    if(p_item .ne. 0) then
	      if(.not. item.expanded) then
	        item.expanded = .true.
	        do_redis = .true.
c	        call expand_smg(smg,item,nrows)
c	        call update_row_info(top_level,nrows,item.row)
	      endif
	      p_info = item.ptr_top
	    else
	      p_info = 0
	    endif
	  end do	  
	  if(do_redis) call display_from_top(top_level,smg,indx,ypos)
	endif
	return
	end	  
	options /recursive
	function find_string_sub(menu_info,search_string,
     1           search_names,search_values,Case,dis_id,smg)
	implicit none
	include 'regedit.inc'
	record /menu_info/ menu_info
	character*(*) search_string
	logical search_names
	logical search_values
	logical case
	integer*4 dis_id
	record /smg/ smg
	integer find_string_sub
c
	record /menu_item/ item
	pointer (p_item,item)
	record /menu_info/ info
	pointer (p_info,info)
c
	integer k
c
	logical compare_item
c
	p_item = menu_info.ptr_first
	k = 0
	do while(p_item .ne. 0)
	  k = compare_item(item,search_string,search_names,
     1            search_values,case,dis_id,smg)
	  if(k .ne. 0) then
	    if(k .ne. -1) k = %loc(item)
	  else
	    if(item.ptr_deep .eq. 0) then
	      call insert_tree(item)
	    endif
	    if(item.ptr_deep .ne. 0) then
	      p_info = item.ptr_deep
	      k = find_string_sub(info,search_string,
     1           search_names,search_values,Case,dis_id,smg) 
	    endif
	  endif
	  if(k .ne. 0) then
	    p_item = 0
	  else
	    p_item = item.ptr_next
	  endif
	end do
	find_string_sub = k
	return
	end
	function compare_item(item,search,search_names,
     1            search_values,case,dis_id,smg)
	implicit none
c
	include 'regedit.inc'
	record /menu_item/ item
	character*(*) search
	logical search_names
	logical search_values
	logical*4 case
	logical compare_item
	integer*4 dis_id
	record /smg/ smg
c
	include '($smgdef)'
c
	integer*4 n_choises
	parameter (n_choises=4)
	character*11 choises(n_choises)
	data choises/'Accept(Do)',
     1               'Next(Enter)',
     1               'Cancel(PF4)',
     1               'Help(Help)'/
c
	character*(max_str_length) line
	integer*4 nk,iterm,row,col,result
	logical match_name
	logical pf1_flag
c
	integer*4 n_help
	parameter (n_help=4)
	character*(35) help_lines(n_help)
	data help_lines /
     1    'Do accepts this search',
     1    'PF4 aborts this search',
     1    'PF2/HELP displays help',
     1    'Any other key continues the search'/
c
	compare_item = 0
c
	if(search_values .or. item.is_key) then
	  if(search_names) then
	    if(match_name(case,search,item.name(1:item.nkar_name)))goto 80
	  endif
	  if(search_values .and. .not. item.is_key) then
	    call cvt_data_to_text(item.valuedata(1:item.nk_valuedata),
     1         item.datatype,nk,line)
	    if(match_name(case,search,line(1:nk))) goto 80
	  endif
	endif
	goto 90
c
80	row = 6
	call display_item(dis_id,70,item,row)
	call menu(smg,n_choises,choises,' ',.true.,
     1         2,result,row+2+5,6,
     1                  iterm,0,' ',' ')
	if(iterm .eq. smg$k_trm_first_down) then
	  if(result .eq. 1) then
	    iterm = smg$k_trm_do
	  elseif(result .eq. 2) then
	    iterm = smg$k_trm_enter
	  elseif(result .eq. 3) then
	    iterm = smg$k_trm_pf4
	  elseif(result .eq. 4) then
	    iterm = smg$k_trm_help
	  endif
	endif
	if(iterm .eq. smg$k_trm_do) then
	  compare_item = 1
	elseif(iterm .eq. smg$k_trm_pf4) then
	  compare_item = -1
	elseif(iterm .eq. smg$k_trm_help) then
	  call display_help(smg,n_help,help_lines,'Search result')
	else
	  compare_item = 0
	endif
90	return
	end
	function match_name(case,str1,str2)
	implicit none
c
	include 'regedit.inc'
c
	logical case
	character*(*) str1
	character*(*) str2
	logical match_name
c
	character*(max_str_length) line
c
	integer*4 nk
c
	character*(*) wild_kars
	parameter (wild_kars = '*%')
c
	integer*4 str$match_wild
	integer str$find_first_in_set
	match_name = .true.
c
	if(case) then
	  if(str$find_first_in_set(str1,wild_kars) .ne. 0) then
	    if(str$match_wild(str2,str1)) goto 90
	  else
	    if(index(str2,str1) .ne. 0) goto 90
	  endif
	else
	  nk = len(str2)
	  call str$upcase(line,str2(1:nk))	  
	  if(str$find_first_in_set(str1,wild_kars) .ne. 0) then
	    if(str$match_wild(line(1:nk),str1)) goto 90
	  else
	    if(index(line(1:nk),str1) .ne. 0) goto 90
	  endif
	endif
	match_name = .false.
90	return
	end
	function insert_key_val(smg,menu_item,modify)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	record /menu_item/ menu_item
	logical modify
	integer*4 insert_key_val
c
	record /item/ items(10)
c
	include '($regdef)'
	include '($trmdef)'
	include '($smgdef)'
	integer*4 dis_id,istat,ipos,iosb(2),k,nit,iterm,functie
	integer*4 nk_path
	integer*4 sys$registryw
	integer*4 in_box
c
	integer*4 nkar,volatile,nk,cacheaction,nk_new
	integer*4 row,col,spos
	character*(max_unistr_length) subkeyname,newname
	character*(max_path) path
c
	integer*4 n_lines
	parameter (n_lines=6)
	record /box/ boxes(n_lines),box
c
	character*(max_str_length) lines(n_lines),line
	integer*4 nk_lines(n_lines),nk_line,map_row,map_col
	integer*4 xpos(n_lines),ypos(n_lines),nkars(n_lines)
	logical pf1_flag
c
	integer*4 n_help
	parameter (n_help=4)
	character*(52) help_lines(n_help)
	data help_lines /
     1    'Arrows                    move between fields',
     1    'Do                        accepts these values',
     1    'FIND or right mouse click Display maneu of choises',
     1    'PF4                       cancels the insert/modify'/
c
	logical cvt_cacheaction
	logical cvt_volatile
c
	volatile menu_item,path,nk_path,nk_new,newname
	volatile volatile,cacheaction
c
	map_row = 8
	map_col = 3
	call smg$create_virtual_display(6,70,dis_id)
	if(modify) then
	  call smg$label_border(dis_id,'Modify key')
	else
	  call smg$label_border(dis_id,'Insert key')
	endif
	call smg$paste_virtual_display(dis_id,smg.paste_id,
     1               map_row,map_col)
	box.beg_row = map_row
	box.beg_col = map_col
	box.end_row = box.beg_row +  6 - 1
	box.end_col = box.beg_col + 70 - 1
c
	call smg$put_chars(dis_id,'Name:',1,1)
	call set_box(boxes(1),map_row,map_col,1,6,1,60)
	if(modify) then
	  lines(1) = menu_item.name
	  nk_lines(1) = menu_item.nkar_name
	else
	  lines(1) = ' '
	  nk_lines(1) = 0
	endif
	ypos(1) = 1
	xpos(1) = 6
	nkars(1) = 40
	call set_box(boxes(1),map_row,map_col,
     1                ypos(1),xpos(1),1,nkars(1))
c
	call smg$put_chars(dis_id,'Volatile:',2,1)
	volatile = menu_item.volatile
	call cvt_volatile(volatile,lines(2),nk_lines(2),0,smg,boxes(2))
	ypos(2) = 2
	xpos(2) = 10
	nkars(2) = 20
	call set_box(boxes(2),map_row,map_col,
     1                ypos(2),xpos(2),1,nkars(2))
c
	call smg$put_chars(dis_id,'Cacheaction:',3,1)
	cacheaction = menu_item.cacheaction 
	call cvt_cacheaction(cacheaction,lines(3),nk_lines(3),0,smg,boxes(3))
	ypos(3) = 3
	xpos(3) = 13
	nkars(3) = 20
	call set_box(boxes(3),map_row,map_col,
     1                ypos(3),xpos(3),1,nkars(3))
c
	lines(4) = 'Yes(Do)'
	nk_lines(4) = 7
	nkars(4) = 7
	ypos(4) = 6
	xpos(4) = 10
	call set_box(boxes(4),map_row,map_col,
     1                ypos(4),xpos(4),1,nkars(4))
c
	lines(5) = 'Cancel(PF4)'
	nk_lines(5) = 11
	nkars(5) = 11
	ypos(5) = 6
	xpos(5) = 24
	call set_box(boxes(5),map_row,map_col,
     1                ypos(5),xpos(5),1,nkars(5))
c
	lines(6) = 'Help'
	nk_lines(6) = 4
	nkars(6) = 4
	ypos(6) = 6
	xpos(6) = 38
	call set_box(boxes(6),map_row,map_col,
     1                ypos(6),xpos(6),1,nkars(6))
c
	do k=1,n_lines
	  call smg$put_chars(dis_id,lines(k)(1:nk_lines(k)),ypos(k),xpos(k))
	end do
c
	ipos = 1
10	if(ipos .lt. 1) ipos = 1
	if(ipos .gt. n_lines) ipos = n_lines
c
	call smg$set_cursor_abs(dis_id,ypos(ipos),xpos(ipos))
	if(ipos .gt. 3) then
	  call read_key(smg,row,col,iterm,pf1_flag) 
	else
	  if(spos .eq. 0) spos = nk_lines(ipos)+1
	  call get_string(smg,dis_id,box,ypos(ipos),xpos(ipos),60,
     1          lines(ipos),nk_lines(ipos),nkars(ipos),iterm,
     1          row,col,spos,
     1          n_help,help_lines,'Insert key')
	  spos = 0
	endif
	if(iterm .eq. smg$k_trm_third_down .or. iterm .eq. smg$k_trm_find) then
	  if(iterm .eq. smg$k_trm_third_down) then
	    do k=2,3
	      if(in_box(row,col,boxes(k))) goto 12
	    end do
	    goto 10		!ignore
12	    ipos = k
	  endif
c
	  if(ipos .eq. 2) then
	    k = volatile
	    if(cvt_volatile(k,line,nk,2,smg,boxes(ipos))) then
	      volatile = k
	      lines(ipos) = line
	      nk_lines(ipos) = nk
	    endif
	  elseif(ipos .eq. 3) then	    	    
	    k = cacheaction
	    if(cvt_cacheaction(k,line,nk,2,smg,boxes(ipos))) then
	      cacheaction = k
	      lines(ipos) = line
	      nk_lines(ipos) = nk
	    endif
	  endif
	  call smg$put_chars(dis_id,lines(ipos),ypos(ipos),xpos(ipos))
	elseif(iterm .eq. smg$k_trm_first_down) then
	  do k=1,3
	    if(in_box(row,col,boxes(k))) goto 14
	  enddo
	  if(in_box(row,col,boxes(4))) goto 50
	  if(in_box(row,col,boxes(5))) goto 40
	  if(in_box(row,col,boxes(6))) goto 30
	  goto 10		!ignore
14	  ipos = k
	  spos = col 
	elseif(iterm .eq. smg$k_trm_down .or. iterm .eq. smg$k_trm_enter .or.
     1         iterm .eq. smg$k_trm_ht) then
	  ipos = ipos + 1
	elseif(iterm .eq. smg$k_trm_pf4)then
	  goto 40
	elseif(iterm .eq. smg$k_trm_up)then
	  ipos = ipos - 1
	elseif(iterm .eq. smg$k_trm_help) then
	  goto 30
	elseif(iterm .eq. smg$k_trm_f10) then
	  goto 40
	elseif(iterm .eq. smg$k_trm_do) then
	  goto 50
	endif
	goto 10
30	call display_help(smg,n_help,help_lines,'Insert key')
	goto 10
40	istat = 0
	goto 90
c
c Validate
c
50	if(nk_lines(1) .eq. 0) then
	  call message(smg,'No name filled in')
	  ipos = 1
	  goto 10
	endif
	ipos = 0
	if(.not. cvt_volatile(volatile,lines(2),nk_lines(2),
     1           1,smg,boxes(2))) ipos = 2
	if(.not. cvt_cacheaction(cacheaction,lines(3),nk_lines(3),
     1           1,smg,boxes(3))) ipos = 3
c
	if(ipos .ne. 0) then
	  call message(smg,'Invalid value')
	  goto 10
	endif
c
	nit = 0
	nit = nit + 1
	items(nit).opcode = reg$_keyid
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.keyid)
	items(nit).retadr = 0
c
	call make_name(menu_item,path,nk,.true.,.true.)
	if(nk .gt. 0) then
	  path(nk+1:) = '\'//char(0)//char(0)//char(0)
	  nk = nk + 4
	endif
	if(modify) then
	  call cvt_txt_to_uni(menu_item.name(1:menu_item.nkar_name),
     1                       nkar,path(nk+1:))
	else
	  call cvt_txt_to_uni(lines(1)(1:nk_lines(1)),nkar,path(nk+1:))
	endif
	nk = nk + nkar
	nit = nit + 1
	items(nit).opcode = reg$_subkeyname
	items(nit).buflen = nk
	items(nit).bufadr = %loc(path)
	items(nit).retadr = 0
c
	if(modify) then
	  if(lines(1)(1:nk_lines(1)) .ne. 
     1        menu_item.name(1:menu_item.nkar_name)) then
	    nit = nit + 1
	    call cvt_txt_to_uni(lines(1)(1:nk_lines(1)),nk_new,newname)
	    items(nit).opcode = reg$_newname
	    items(nit).buflen = nk_new
	    items(nit).bufadr = %loc(newname)
	    items(nit).retadr = 0
	  endif
	endif
c
	nit = nit + 1
	items(nit).opcode = reg$_volatile
	items(nit).buflen = 4
	items(nit).bufadr = %loc(volatile)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_cacheaction
	items(nit).buflen = 4
	items(nit).bufadr = %loc(cacheaction)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
	items(nit).bufadr = 0
	items(nit).retadr = 0
c
	if(modify) then
	  functie = reg$fc_modify_key
	else
	  functie = reg$fc_create_key
	endif
c
	istat = sys$registryw(,%val(functie),,items,iosb,,)
	if(istat) istat = iosb(1)
90	insert_key_val = istat
	call smg$delete_virtual_display(dis_id)
	if(.not. istat) then
	  call signal_message(smg,istat)
	else
	  if(modify) then
	    menu_item.volatile    = volatile
	    menu_item.cacheaction = cacheaction
	    menu_item.name = lines(1)(1:nk_lines(1))
	    menu_item.nkar_name = nk_lines(1)
	    call cvt_txt_to_uni(lines(1)(1:nk_lines(1)),
     1          menu_item.nkar_uni,menu_item.uniname)
	  endif
	endif
c
	return
	end	
	function insert_val_val(smg,menu_item,modify)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	record /menu_item/ menu_item
	logical modify
	integer*4 insert_val_val
c
	record /item/ items(10)
c
	include '($regdef)'
	include '($trmdef)'
	include '($smgdef)'
	integer*4 dis_id,istat,modifiers,ipos,iosb(2),k,nit,iterm,functie
	integer*4 nk_path
	integer*4 sys$registryw
c
	integer*4 nkar,nk,datatype,nk_data
	integer*4 row,col,map_row,map_col,spos
	character*(max_unistr_length) valuename,valuedata
	character*(max_path) path
c
	logical cvt_datatype
	logical cvt_text_to_data
	integer*4 in_box
	logical pf1_flag
c
	integer*4 n_help
	parameter (n_help=4)
	character*(52) help_lines(n_help)
	data help_lines /
     1    'Arrows                    move between fields',
     1    'Do                        accepts these values',
     1    'FIND or right mouse click Display maneu of choises',
     1    'PF4                       cancels the insert/modify'/
c
	integer*4 n_lines
	parameter (n_lines=6)
	record /box/ boxes(n_lines),box
c
	volatile menu_item,path,nk_path,valuename,nk_val
	volatile datatype,nk_data,valuedata
c
	character*(max_str_length) lines(n_lines),line
	integer*4 nk_lines(n_lines),nk_line,nk_val
	integer*4 xpos(n_lines),ypos(n_lines)
	integer*4 nkars(n_lines)
c
	call smg$create_virtual_display(6,70,dis_id)
	if(modify) then
	  call smg$label_border(dis_id,'Modify value')
	else
	  call smg$label_border(dis_id,'Insert value')
	endif
	map_row = 8
	map_col = 3
	call smg$paste_virtual_display(dis_id,smg.paste_id,
     1            map_row,map_col)
	box.beg_row = map_row
	box.beg_col = map_col
	box.end_row = box.beg_row + 6 - 1
	box.end_col = box.beg_col +70 - 1
c
	
	call smg$put_chars(dis_id,'Name:',1,1)
	if(modify) then
	  lines(1) = menu_item.name
	  nk_lines(1) = menu_item.nkar_name
	else
	  lines(1) = ' '
	  nk_lines(1) = 0
	endif
	xpos(1) = 6
	ypos(1) = 1
	nkars(1) = 60
	call set_box(boxes(1),map_row,map_col,
     1          ypos(1),xpos(1),1,nkars(1))
c
	call smg$put_chars(dis_id,'Datatype:',2,1)
	if(modify) then
	  datatype = menu_item.datatype
	else
	  datatype = reg$k_dword
	endif
	call cvt_datatype(datatype,lines(2),nk_lines(2),0,smg,boxes(2))
	ypos(2) = 2
	xpos(2) = 10
	nkars(2) = 20
	call set_box(boxes(2),map_row,map_col,
     1          ypos(2),xpos(2),1,nkars(2))
c
	call smg$put_chars(dis_id,'Value:',3,1)
	if(modify) then
	  call cvt_data_to_text(menu_item.valuedata(1:menu_item.nk_valuedata),
     1           menu_item.datatype,nk_data,valuedata)
	else
	  valuedata = ' '
	  nk_data = 0
	endif
	ypos(3) = 3
	lines(3)  = valuedata(1:nk_data)
	nk_lines(3) = nk_data
	xpos(3) = 7
	nkars(3) = 20
	call set_box(boxes(3),map_row,map_col,
     1          ypos(3),xpos(3),1,nkars(3))
c
	lines(4) = 'Yes(Do)'
	nk_lines(4) = 7
	nkars(4) = 7
	ypos(4) = 6
	xpos(4) = 10
	call set_box(boxes(4),map_row,map_col,
     1                ypos(4),xpos(4),1,nkars(4))
c
	lines(5) = 'Cancel(PF4)'
	nk_lines(5) = 11
	nkars(5) = 11
	ypos(5) = 6
	xpos(5) = 20
	call set_box(boxes(5),map_row,map_col,
     1                ypos(5),xpos(5),1,nkars(5))
c
	lines(6) = 'Help'
	nk_lines(6) = 4
	nkars(6) = 4
	ypos(6) = 6
	xpos(6) = 34
	call set_box(boxes(6),map_row,map_col,
     1                ypos(6),xpos(6),1,nkars(6))
c
	do k=1,n_lines
	  call smg$put_chars(dis_id,lines(k)(1:nk_lines(k)),
     1                 ypos(k),xpos(k))
	end do
c
	ipos = 1
10	if(ipos .lt. 1) ipos = 1
	if(modify .and. ipos .lt. 2) ipos = 2
c
	if(ipos .gt. n_lines) ipos = n_lines
c
	call smg$set_cursor_abs(dis_id,ypos(ipos),xpos(ipos))
	if(ipos .gt. 3) then
	  call read_key(smg,row,col,iterm,pf1_flag)
	else
	  if(spos .eq. 0) spos = nk_lines(ipos)+1
	  call get_string(smg,dis_id,box,ypos(ipos),xpos(ipos),60,
     1          lines(ipos),nk_lines(ipos),nkars(ipos),iterm,
     1          row,col,spos,
     1          n_help,help_lines,'Insert value')
	  spos = 0
	endif
c
	if(iterm .eq. smg$k_trm_down .or. iterm .eq. smg$k_trm_enter .or.
     1     iterm .eq. smg$k_trm_ht) then
	  ipos = ipos + 1
	elseif(iterm .eq. smg$k_trm_up)then
	  ipos = ipos - 1
	elseif(iterm .eq. smg$k_trm_f10) then
	  goto 40
	elseif(iterm .eq. smg$k_trm_first_down) then
	  do k=1,3
	    if(in_box(row,col,boxes(k))) goto 12
	  end do
	  if(in_box(row,col,boxes(4))) goto 50
	  if(in_box(row,col,boxes(5))) goto 40
	  if(in_box(row,col,boxes(6))) goto 30
	  goto 10
12	  ipos = k
	  spos = col
	elseif(iterm .eq. smg$k_trm_pf4) then
	  goto 40
	elseif(iterm .eq. smg$k_trm_help) then
	  goto 30
	elseif(iterm .eq. smg$k_trm_find .or. 
     1         iterm .eq. smg$k_trm_third_down) then
	  if(iterm .eq. smg$k_trm_third_down) then
	    do k=2,2
	      if(in_box(row,col,boxes(k))) goto 14
	    end do
	    goto 10
14	    ipos = k
	  endif
	  if(ipos .eq. 2) then
	    k = datatype
	    if(cvt_datatype(datatype,lines(2),nk_lines(2),2,
     1              smg,boxes(ipos))) then
	      datatype = k
	    endif
	  endif
	  call smg$put_chars(dis_id,lines(ipos),ypos(ipos),xpos(ipos))
	elseif(iterm .eq. smg$k_trm_do) then
	  goto 50
	endif
	goto 10
30	call display_help(smg,n_help,help_lines,'Insert value')
	goto 10
40	istat = 0
	goto 90
c
c Validate
c
50	ipos = 0
	if(.not. cvt_datatype(k,lines(2),nk_lines(2),1,smg,boxes(2))) then
	  call message(smg,'Invalid datatype')
	  ipos = 2
	  goto 10
	endif
	datatype = k
	if(.not. cvt_text_to_data(lines(3)(1:nk_lines(3)),
     1       datatype,nk_data,valuedata)) then
	  call message(smg,'Invalid data for this datatype')
	  ipos = 3
	  goto 10
	endif
c
	if(nk_lines(1) .eq. 0) then
	  call message(smg,'No name filled in')
	  ipos = 1
	  goto 10
	end if
c
	if(nk_lines(3) .eq. 0) then
	  call message(smg,'No value filled in')
	  ipos = 3
	  goto 10
	end if
	nit = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_keyid
	items(nit).buflen = 4
	items(nit).bufadr = %loc(menu_item.keyid)
	items(nit).retadr = 0
c
	if(modify) then
	  call make_name(menu_item,path,nk_path,.true.,.false.)
	else
	  call make_name(menu_item,path,nk_path,.true.,.true.)
	endif
	nit = nit + 1
	items(nit).opcode = reg$_keypath
	items(nit).buflen = nk_path
	items(nit).bufadr = %loc(path)
	items(nit).retadr = 0
c
	call cvt_txt_to_uni(lines(1)(1:nk_lines(1)),nk_val,valuename)
	nit = nit + 1
	items(nit).opcode = reg$_valuename
	items(nit).buflen = nk_val
	items(nit).bufadr = %loc(valuename)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_datatype
	items(nit).buflen = 4
	items(nit).bufadr = %loc(datatype)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = reg$_valuedata
	items(nit).buflen = nk_data
	items(nit).bufadr = %loc(valuedata)
	items(nit).retadr = 0
c
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
	items(nit).bufadr = 0
	items(nit).retadr = 0
c
	functie = reg$fc_set_value
c
	istat = sys$registryw(,%val(functie),,items,iosb,,)
	if(istat) istat = iosb(1)
90	insert_val_val = istat
	if(.not. istat) then
	  call signal_message(smg,istat)
	else
	  if(modify) then
	    menu_item.datatype = datatype
	    menu_item.valuedata = valuedata
	    menu_item.nk_valuedata = nk_data
	  endif
	endif
c
	call smg$delete_virtual_display(dis_id)
	return
	end	

	function remove_key_val(smg,menu_item)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	record /menu_item/ menu_item
	integer*4 remove_key_val
c
	record /item/ items(10)
c
	include '($regdef)'
	include '($trmdef)'
	include '($smgdef)'
	integer*4 istat,iosb(2),nit,functie
	integer*4 nk_path
c
	integer*4 sys$registryw
	logical get_janee
c
	character*(max_path) path
c
	volatile menu_item,path,nk_path
	if(get_janee(smg,smg.data_box,'Delete above key ?')) then
	  nit = 0
c
	  nit = nit + 1
	  items(nit).opcode = reg$_keyid
	  items(nit).buflen = 4
	  items(nit).bufadr = %loc(menu_item.keyid)
	  items(nit).retadr = 0

	  call make_name(menu_item,path,nk_path,.true.,.false.)
c
	  if(nk_path .gt. 0) then
	    nit = nit + 1
	    items(nit).opcode = REG$_KEYPATH 
	    items(nit).buflen = nk_path
	    items(nit).bufadr = %loc(path)
	    items(nit).retadr = 0
	  endif

	  nit = nit + 1
	  items(nit).opcode = reg$_subkeyname
	  items(nit).buflen = menu_item.nkar_uni
	  items(nit).bufadr = %loc(menu_item.uniname)
	  items(nit).retadr = 0
c
	  nit = nit + 1
	  items(nit).opcode = 0
	  items(nit).buflen = 0
	  items(nit).bufadr = 0
	  items(nit).retadr = 0
c
	  functie = reg$fc_delete_key
c
	  istat = sys$registryw(,%val(functie),,items,iosb,,)
	  if(istat) istat = iosb(1)
90	  remove_key_val = istat
	  if(.not. istat) then
	    call signal_message(smg,istat)
	  endif
	else
          call message(smg,'Delete aborted')
	endif
	return
	end	
	function remove_val_val(smg,menu_item)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	record /menu_item/ menu_item
	integer*4 remove_val_val
c
	record /item/ items(10)
c
	include '($regdef)'
	include '($trmdef)'
	include '($smgdef)'
	integer*4 istat,iosb(2),nit,functie
	integer*4 nk_path
c
	integer*4 sys$registryw
	logical get_janee
c
	character*(max_path) path
c
	volatile menu_item,path,nk_path
c
	if(get_janee(smg,smg.data_box,'Delete above value ?')) then
	  nit = 0
c
	  nit = nit + 1
	  items(nit).opcode = reg$_keyid
	  items(nit).buflen = 4
	  items(nit).bufadr = %loc(menu_item.keyid)
	  items(nit).retadr = 0

	  call make_name(menu_item,path,nk_path,.true.,.false.)
c
	  if(nk_path .gt. 0) then
	    nit = nit + 1
	    items(nit).opcode = REG$_KEYPATH 
	    items(nit).buflen = nk_path
	    items(nit).bufadr = %loc(path)
	    items(nit).retadr = 0
	  endif

	  nit = nit + 1
	  items(nit).opcode = reg$_valuename
	  items(nit).buflen = menu_item.nkar_uni
	  items(nit).bufadr = %loc(menu_item.uniname)
	  items(nit).retadr = 0
c
	  nit = nit + 1
	  items(nit).opcode = 0
	  items(nit).buflen = 0
	  items(nit).bufadr = 0
	  items(nit).retadr = 0
c
	  functie = reg$fc_delete_value
c
	  istat = sys$registryw(,%val(functie),,items,iosb,,)
	  if(istat) istat = iosb(1)
	  istat = 1
90	  remove_val_val = istat
	  if(.not. istat) then
	    call signal_message(smg,istat)
	  endif
	else
          call message(smg,'Delete aborted')
	endif
	return
	end	

	subroutine set_box(box,map_row,map_col,row_beg,col_beg,n_row,n_col)
	implicit none
c
	include 'regedit.inc'
	record /box/ box
	integer*4 map_row
	integer*4 map_col
	integer*4 row_beg
	integer*4 col_beg
	integer*4 n_row
	integer*4 n_col
c
	box.beg_row = map_row+row_beg-1
	box.beg_col = map_col+col_beg-1
	box.end_row = box.beg_row + n_row-1
	box.end_col = box.beg_col + n_col-1
	return
	end
	subroutine message(smg,messag)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
c
	character*(*) messag
c
	if(messag .eq. ' ') then
	  call smg$draw_line(smg.dis_id,smg.nrows,1,smg.nrows,smg.ncols)
	else
	  call smg$put_chars(smg.dis_id,messag,smg.nrows,2)
	endif
	return
	end
	function get_janee(smg,box,string)
	implicit none
	include 'regedit.inc'
	record /smg/ smg
	record /box/ box
	character*(*) string
	logical get_janee
c
	include '($smgdef)'
	character*12 choises(2)
	data choises / 'OK(Do)','Cancel(PF4)'/
c
	integer*4 iterm,dis_id,ncols,k
c
	ncols = box.end_col - box.beg_col - 5
c
10 	call menu(smg,2,choises,string,.true.,1,k,
     1                box.end_row-3,box.beg_col+2,
     1                  iterm,0,' ',' ')
	if(iterm .eq. smg$k_trm_do) then
	  get_janee = .true.
	elseif(iterm .eq. smg$k_trm_pf4) then
	  get_janee = .false.
	elseif(iterm .eq. smg$k_trm_first_down) then
	  get_janee = k .eq. 1
	else
	  call message(smg,'Invalid response')
	  goto 10
	endif
	call smg$delete_virtual_display(dis_id)
	return
	end	
	subroutine signal_message(smg,istat)
c
	implicit none
	integer*4 smg
	integer*4 istat
c
	character*255 line
	integer*4 nk
c
	if(istat .eq. 0) then
	  call message(smg,'Insert key aborted')
	else
	  call sys$getmsg(%val(istat),nk,line,%val(1),)
	  call message(smg,line(1:nk))
	endif
	return
	end
	subroutine get_string(smg,dis_id,box,brow,bcol,width,
     1          line,nkar,max_len,iterm,row,col,spos,
     1          n_help,help_lines,topic)
c
	implicit none
	include 'regedit.inc'
	record /smg/ smg
	integer*4 dis_id
	record /box/ box
	integer brow
	integer bcol
	character*(*) line
	integer*4 nkar
	integer*4 max_len
	integer*4 width
	integer*4 iterm
	integer row
	integer col
	integer*4 spos
	integer*4 n_help
	character*(*) help_lines(n_help)
	character*(*) topic
c
	include '($smgdef)'
c
	integer*4 row1,col1,bpos,epos,istat,kpos,nline
	logical pf1_flag
c
	logical in_box
c
	record /box/ mybox
c
	kpos = spos
c
5	nline = max(1,(max_len +width-1)/width)
	mybox.beg_row = box.beg_row   + brow-1
	mybox.end_row = mybox.beg_row + nline-1
	mybox.beg_col = box.beg_col   + bcol - 1
	mybox.end_col = mybox.beg_col + width - 1
c
10	if(kpos .le. 0) kpos = 1
	if(kpos .gt. nkar) kpos = nkar+1
c
	col1 = bcol + mod(kpos-1,width)
	row1 = brow + (kpos-1)/width
	call smg$set_cursor_abs(dis_id,row1,col1)
c
	call read_key(smg,row,col,iterm,pf1_flag)
c
	if(iterm .ge. ichar(' ') .and. iterm .le. 125) then
	  line = line(1:kpos-1)//char(iterm)//line(kpos:nkar)
	  nkar = nkar + 1
	  kpos = kpos + 1
	  goto 40	  
	elseif(iterm .eq. smg$k_trm_delete) then
	  if(kpos .gt. 1) then
	    line = line(1:kpos-2)//line(kpos:nkar)
	    nkar = nkar - 1
            kpos = kpos - 1
	    goto 40	  
	  endif
	elseif(iterm .eq. smg$k_trm_up) then
	  kpos = kpos - width
	  if(kpos .le. 0) goto 90
	elseif(iterm .eq. smg$k_trm_down) then
	  kpos = kpos + width
	  if((kpos-1)/width .gt. (nkar-1)/width) goto 90
	elseif(iterm .eq. smg$k_trm_left) then
	  if(pf1_flag) then
	    kpos = 1
	  else
	    kpos = kpos - 1
	  endif
	elseif(iterm .eq. smg$k_trm_right) then
	  if(pf1_flag) then
	    kpos = nkar + 1
	  else
	    kpos = kpos + 1
	  endif
	elseif(iterm .eq. smg$k_trm_third_down) then
	  goto 90
	elseif(iterm .eq. smg$k_trm_first_down) then
	  if(in_box(row,col,mybox)) then
	    kpos = width*(row-1) + col
	  else
	    goto 90
	  endif
	elseif(iterm .eq. smg$k_trm_help) then
	  call display_help(smg,n_help,help_lines,topic)
	else
	  goto 90
	endif
	goto 10
40	bpos = 1
	row = brow
	do while(bpos .le. nkar+1)
	  epos = min(nkar+1,bpos+width-1)
	  call smg$put_chars(dis_id,line(bpos:epos),row,bcol)
	  row = row + 1
	  bpos = epos + 1
	end do
	goto 5
90	return
	end	
	function get_len(line)
	implicit none
c
	character*(*) line
	integer*4 get_len
c
	integer*4 k
c
	do k=len(line),1,-1
	  if(line(k:k) .ne. ' ') goto 90
	end do
	k = 0
90	get_len = k
	return
	end
	subroutine read_key(smg,row,col,iterm,pf1_flag)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	integer*4 row
	integer*4 col
	integer*4 iterm
	logical pf1_flag
c
	include '($smgdef)'
c
	pf1_flag = .false.
10	call smg$read_locator(smg.keyb_id,row,col,iterm)
c
c Ignore mouse release button actions, 
c else an possible message will be killed
c
	if(iterm .eq. smg$k_trm_first_up .or. 
     1     iterm .eq. smg$k_trm_second_up .or. 
     1     iterm .eq. smg$k_trm_third_up) goto 10
c
	call message(smg,' ')
	if(iterm .eq. smg$k_trm_ctrlw) then
	  call smg$repaint_screen(smg.paste_id)
	  goto 10
	elseif(iterm .eq. smg$k_trm_pf2) then
	  iterm = smg$k_trm_help
	elseif(iterm .eq. smg$k_trm_ctrlb) then
	  iterm = smg$k_trm_up
	elseif(iterm .eq. smg$k_trm_pf1) then
	  pf1_flag = .true.
	  goto 10
	elseif(iterm .eq. smg$k_trm_ctrlz) then
	  iterm = smg$k_trm_f10
	elseif(iterm .eq. smg$k_trm_ctrlm .or. 
     1         iterm .eq. smg$k_trm_cr) then
	  iterm = smg$k_trm_enter
	elseif(iterm .eq. smg$k_trm_pf3) then
	  iterm = smg$k_trm_find
	endif
	return
	end
	subroutine display_help(smg,n_help,help_lines,topic)
	implicit none
c
	include 'regedit.inc'
	record /smg/ smg
	integer*4 n_help
	character*(*) help_lines(*)
	character*(*) topic
c
	integer*4 width,k,dis_id
c
	width = len(help_lines(1))
	call smg$create_virtual_display(n_help+2,width+2,dis_id)
	call smg$label_border(dis_id,'Help about '//topic)
	do k=1,n_help
	  call smg$put_chars(dis_id,help_lines(k),k,1)
	end do
	call smg$paste_virtual_display(dis_id,smg.paste_id,4,4)
	call read_key(smg,k,k,k,k)
	call smg$delete_virtual_display(dis_id)
	return
	end	
	subroutine menu(smg,n_choises,choises,topic,horizontal,
     1         initial,result,row,col,iterm,n_help,help_lines,htopic)
	implicit none
	include 'regedit.inc'
	record /smg/ smg
	integer*4 n_choises
	character*(*) choises(n_choises)
	logical horizontal
	character*(*) topic
	integer*4 initial
	integer*4 result
	integer*4 row
	integer col
	integer*4 iterm
	integer*4 n_help
	character*(*) help_lines(*)
	character*(*) htopic
c
	integer*4 max_choises
	parameter (max_choises=20)
	integer*4 xpos(max_choises),ypos(max_choises)
	record /box/ box(max_choises)
c
	include '($smgdef)'
c
	integer*4 width,nrow,ncol,menu_type,dis_id,k,ipos
	integer*4 myrow,mycol
	logical pf1_flag
c
	logical in_box
c
	width = len(choises(1))
	if(horizontal) then
	  nrow = 1
	  ncol = (width+4)*n_choises
	  do k=1,n_choises
	    xpos(k) = (k-1)*(width+3) + 2
	    ypos(k) = 1
	  end do
	else
	  nrow = n_choises
	  ncol = width + 4
	  do k=1,n_choises
	    xpos(k) = 2
	    ypos(k) = k
	  end do
	endif
	call smg$create_virtual_display(nrow,ncol,dis_id,smg$m_border)
	if(topic .ne. ' ') call smg$label_border(dis_id,topic)
c
	do k=1,n_choises
	  call smg$put_chars(dis_id,choises(k),ypos(k),xpos(k))
	  box(k).beg_row = ypos(k)+row-1
	  box(k).end_row = box(k).beg_row
	  box(k).beg_col = xpos(k)+col-1
	  box(k).end_col = box(k).beg_col + width
	end do	  
	call smg$paste_virtual_display(dis_id,smg.paste_id,row,col)
	ipos = initial
10	if(ipos .gt. n_choises) ipos = n_choises
	if(ipos .lt. 1) ipos = 1
c
	call smg$set_cursor_abs(dis_id,ypos(ipos),xpos(ipos))
	call read_key(smg,myrow,mycol,iterm,pf1_flag)
	if(iterm .eq. smg$k_trm_first_down) then
	  do k=1,n_choises
	    if(in_box(myrow,mycol,box(k))) then
	      ipos = k
	      goto 90
	    end if
	  end do
	elseif(iterm .eq. smg$k_trm_right) then
	  ipos = ipos + 1
	elseif(iterm .eq. smg$k_trm_down) then
	  ipos = ipos + 1
	elseif(iterm .eq. smg$k_trm_left) then
	  ipos = ipos - 1
	elseif(iterm .eq. smg$k_trm_up) then
	  ipos = ipos - 1
	else
	  goto 90
	endif
	goto 10
90	call smg$delete_virtual_display(dis_id)
	result = ipos
	return
	end
