$! USE_BASE_LEVEL.COM
$!
$! Version: 1.2-8
$! Date:    11-Aug-2004
$!
$! Author: Lenny Szubowicz
$!
$! Abstract:
$!
$!	The USE_BASE_LEVEL.COM procedure defines logical names and DCL verbs
$!	that enable you to use the same build tools, macro, text, and object
$!	libraries that were used for a particular OpenVMS Alpha build.
$!
$!	This procedure is a prerequisite for the ALPHA_COMPILE.COM procedure.
$!
$! Usage:
$!
$!	@USE_BASE_LEVEL  base-level
$!
$! where "base-level" can be one of the following:
$!
$! (1)	Null.  This procedure will display information about the currently
$!	selected baselevel.
$!
$! (2)	Any string to which appending the string "_RESD$" results in a
$!	logical name that points to a baselevel result disk.  This procedure
$!	will switch the currently selected baselevel to the specified baselevel.
$!
$! (3)	Any string which by itself is a logical name or device name that
$!	points to a baselevel result disk.  This procedure will switch the
$!	currently selected baselevel to the specified baselevel.
$!
$! (4)	The string "*".  This procedure restores the default OpenVMS program
$!	development environment by deleting DCL symbols and logical names
$!	that are otherwise defined by this procedure.
$!
$!
$! 1.2-8 - J. Malmberg 	Setup for IA64 native build
$!
$!
$	SET NOON
$	SAVED_VFY = F$VERIFY()
$	ON CONTROL_Y THEN GOTO ABORT
$!
$	TMP1_FILE_NAME = "SYS$SCRATCH:T1_" + F$GETJPI("","PID") + ".TMP"
$!
$!
$!
$	IF P1 .EQS. "*"
$	THEN
$	  IF F$TRNLNM("RESD$","LNM$PROCESS") .NES. "" THEN $DEASSIGN RESD$
$	  IF F$TRNLNM("DSK$RESD$","LNM$PROCESS") .NES. "" THEN $DEASSIGN DSK$RESD$
$	  IF F$TRNLNM("SYS$LIBRARY","LNM$PROCESS") .NES. "" THEN $DEASSIGN SYS$LIBRARY
$	  IF F$TRNLNM("LNK$LIBRARY","LNM$PROCESS") .NES. "" THEN $DEASSIGN LNK$LIBRARY
$	  IF F$TYPE(LINK) .NES. "" THEN DELETE/SYMBOL/GLOBAL LINK
$	  IF F$TYPE(SDL) .NES. ""  THEN DELETE/SYMBOL/GLOBAL SDL
$	  WRITE SYS$OUTPUT "Current RESD$ is the default RESD$ (",-
		F$TRNLNM("RESD$"),")"
$	  EXIT 1
$	ENDIF
$!
$	IF P1 .NES. ""
$	THEN
$	  RESD_1 = F$ELEMENT(0,",",P1)
$	  RESD_2 = F$ELEMENT(1,",",P1)
$	  IF RESD_2 .EQS. "" .OR. RESD_2 .EQS. "," THEN RESD_2 = P2
$!
$	  RESD_1 = RESD_1 - ":"
$         IF F$TRNLNM(RESD_1+"_RESD$") .NES. "" THEN RESD_1 = RESD_1 + "_RESD$"
$	  IF .NOT. F$GETDVI(RESD_1,"EXISTS") THEN EXIT %X12
$	  IF .NOT. F$GETDVI(RESD_1,"MNT")    THEN EXIT %X12
$!
$	  IF RESD_2 .NES. ""
$	  THEN
$	    RESD_2 = RESD_2 - ":"
$           IF F$TRNLNM(RESD_2+"_RESD$") .NES. "" THEN RESD_2 = RESD_2 + "_RESD$"
$	    IF .NOT. F$GETDVI(RESD_2,"EXISTS") THEN EXIT %X12
$	    IF .NOT. F$GETDVI(RESD_2,"MNT")    THEN EXIT %X12
$	  ENDIF
$!
$	  IF RESD_2 .EQS. ""
$	  THEN
$	    DEFINE/NOLOG RESD$ 'RESD_1':
$	  ELSE
$	    DEFINE/NOLOG RESD$ 'RESD_1':,'RESD_2':
$	  ENDIF
$!
$	  DEFINE/NOLOG DSK$RESD$ RESD$:
$!
$! Determine if this is a native or a cross build.  The default is "AXP cross."
$!
$!
$ IXVMS == 0				! Assume it is never a cross-platform SDA build
$	  EVAX == 1			! Some old build procedures use this
$	  VAX  == 0
$	  IA64 == 0
$
$! Correct the assumptions
$
$	  arch_type = f$getsyi("ARCH_TYPE")
$	  if arch_type .EQ. 3
$	  then
$	    EVAX == 0
$	    IA64 == 1
$	  endif
$!
$	  AXP_NATIVE == 0
$	  AXP_CROSS  == 1
$	  IA64_NATIVE == 0
$	  IA64_CROSS == 0
$!
$	  AXP_BUILD_STRING = "AXP_CROSS"
$	  AXP_BUILD_ARCH = 1
$	  IF F$SEARCH("RESD$:[SYSBLD]BUILD.INFO") .NES. ""
$	  THEN
$	    DEFINE/USER SYS$OUTPUT NL:
$	    DEFINE/USER SYS$ERROR  NL:
$	    SEARCH/OUT=NL: RESD$:[SYSBLD]BUILD.INFO "(AXP_NATIVE)"
$	    IF $SEVERITY .EQ. 1
$	    THEN
$	      AXP_NATIVE == 1
$	      AXP_CROSS  == 0
$	      AXP_BUILD_STRING = "AXP_NATIVE"
$	      AXP_BUILD_ARCH = 2
$	      ALPHA      == 1
$	      IA64 == 0
$	    ELSE
$	      DEFINE/USER SYS$OUTPUT NL:
$	      DEFINE/USER SYS$ERROR  NL:
$	      SEARCH/OUT=NL: RESD$:[SYSBLD]BUILD.INFO "(IA64_CROSS)"
$	      IF $SEVERITY .EQ. 1
$	      THEN
$		TARGET = "IA64"
$		IF IA64 .EQ. 1
$		THEN
$		  AXP_NATIVE == 0
$		  IA64_NATIVE == 1
$		  AXP_CROSS  == 0
$		  AXP_BUILD_STRING = "IA64_NATIVE"
$		  AXP_BUILD_ARCH = 3
$		  ALPHA      == 0
$		ELSE
$		  AXP_NATIVE == 0
$		  IA64_NATIVE == 0
$		  AXP_CROSS  == 0
$		  IA64_CROSS == 1
$		  AXP_BUILD_STRING = "IA64_CROSS"
$		  AXP_BUILD_ARCH = 2
$		  ALPHA      == 0
$		  EVAX == 0
$		  IA64 == 1
$		ENDIF
$	      ENDIF
$	    ENDIF
$	    WRITE SYS$OUTPUT "Baselevel ",F$TRNLNM("RESD$")," is a ",-
			     AXP_BUILD_STRING," build."
$	  ELSE
$	    WRITE SYS$OUTPUT "%UBL-W-NOBUILDINFO, unable to locate BUILD.INFO for ",F$TRNLNM("RESD$")
$	    WRITE SYS$OUTPUT "Assuming that ",F$TRNLNM("RESD$")," is a CROSS build."
$	  ENDIF
$!
$	  IF F$TRNLNM("SRC$") .EQS. ""
$	  THEN
$           DEFINE/NOLOG SRC$   DSKD$:[.SRC]
$           DEFINE/NOLOG COM$   DSKD$:[.COM]
$           DEFINE/NOLOG LIS$   DSKD$:[.LIS]
$           DEFINE/NOLOG MAP$   DSKD$:[.LIS]
$           DEFINE/NOLOG OBJ$   DSKD$:[.OBJ]
$           DEFINE/NOLOG LIB$   DSKD$:[.OBJ]
$           DEFINE/NOLOG EXE$   DSKD$:[.OBJ]
$	  ENDIF
$!
$	  DEFINE/NOLOG RMSLIB 	DSKD$:[RMS.OBJ],RESD$:[RMS.OBJ]
$	  DEFINE/NOLOG RMSSRC	DSKD$:[RMS.SRC],RESD$:[RMS.SRC]
$	  DEFINE/NOLOG RESOBJ$	DSKD$:[SYSOBJ],RESD$:[SYSOBJ]
$	  DEFINE/NOLOG RESLDR$	DSKD$:[SYS$LDR],RESD$:[SYS$LDR]
$	  DEFINE/NOLOG SHRLIB$	DSKD$:[SHRLIB],RESD$:[SHRLIB]
$	  DEFINE/NOLOG EXSM 	DSKD$:[SYS$LDR],RESD$:[SYS$LDR],RESD$:[SYSOBJ]
$	  DEFINE/NOLOG EXECML$ 	DSKD$:[SYSLIB]LIB.MLB,RESD$:[SYSLIB]LIB.MLB,SYS$LIBRARY:LIB.MLB
$	  DEFINE/NOLOG EXECLIBH$ DSKD$:[SYSLIB]SYS$LIB_C.TLB,RESD$:[SYSLIB]SYS$LIB_C.TLB,SYS$LIBRARY:SYS$LIB_C.TLB
$	  DEFINE/NOLOG RESCOM$	RESD$:[SYSBLD.COM]
$	  DEFINE/NOLOG OPT$	COM$:
$	  DEFINE/NOLOG ALPHA$LIBRARY DSKD$:[SYSLIB],RESD$:[SYSLIB]
$	  DEFINE/NOLOG IA64$LIBRARY DSKD$:[SYSLIB],RESD$:[SYSLIB]
$	  DEFINE/NOLOG ALPHA$LOADABLE_IMAGES DSKD$:[SYS$LDR],RESD$:[SYS$LDR]
$	  DEFINE/NOLOG IA64$LOADABLE_IMAGES DSKD$:[SYS$LDR],RESD$:[SYS$LDR]
$!
$	IF AXP_BUILD_STRING .NES. "AXP_NATIVE"
$	THEN
$	  DEFINE/NOLOG CLUE$SDA     RESD$:[EVAX.XSDA]ALPHA_CLUE$SDA.EXE
$	  DEFINE/NOLOG CLUE$HELP    RESD$:[EVAX.XSDA]CLUE$HELP.HLB
$	  DEFINE/NOLOG SDA          RESD$:[EVAX.XSDA]SDA.EXE
$	  DEFINE/NOLOG SDA$SHARE    RESD$:[EVAX.XSDA]ALPHA_SDA$SHARE.EXE
$	  DEFINE/NOLOG SDARMS$SHARE RESD$:[EVAX.XSDA]ALPHA_SDARMS$SHARE.EXE
$!
$	  DEFINE/NOLOG DECDTM$SDA   RESD$:[SYSLIB]DECDTM$SDA.EXE
$	  DEFINE/NOLOG IPC$SDA      RESD$:[SYSLIB]IPC$SDA.EXE
$	  DEFINE/NOLOG PTHREAD$SDA  RESD$:[SYSLIB]PTREAD$SDA.EXE
$	ELSE
$	ENDIF
$	  DEFINE/NOLOG SDA$READ_DIR RESD_SYSROOT:[SYS$LDR],RESD_SYSROOT:[SYSLIB]
$!
$	  IF F$SEARCH("RESD$:[000000]BUILD.DIR") .NES. ""
$	  THEN
$	    DEFINE/NOLOG EVMS$BUILD_TOOLS  RESD$:[BUILD.'TARGET'_'AXP_BUILD_STRING'_TOOLS]
$	    DEFINE/NOLOG EVMS$BUILD_IMAGES RESD$:[BUILD.'TARGET'_'AXP_BUILD_STRING'_TOOLS]
$	    DEFINE/NOLOG EVMS$SYSBLDCOM    RESD$:[BUILD.SYSBLDCOM]
$	  ELSE
$	    DEFINE/NOLOG EVMS$BUILD_TOOLS  RESD$:[EVAX.TOOLS]
$	    DEFINE/NOLOG EVMS$BUILD_IMAGES RESD$:[EVAX.IMAGES]
$	    DEFINE/NOLOG EVMS$SYSBLDCOM    RESD$:[EVAX.SYSBLDCOM]
$	  ENDIF
$	  IF IA64_CROSS
$	  THEN
$	    ! The unchanged tools like SDL are still in the AXP directory
$	    DEFINE/NOLOG EVMS$BUILD_TOOLS  RESD$:[BUILD.'AXP_BUILD_STRING'_TOOLS],RESD$:[BUILD.AXP_NATIVE_TOOLS]
$	    DEFINE/NOLOG EVMS$BUILD_IMAGES RESD$:[BUILD.'AXP_BUILD_STRING'_TOOLS],RESD$:[BUILD.AXP_NATIVE_TOOLS]
$	    DEFINE/NOLOG IVMS$BUILD_TOOLS  RESD$:[BUILD.'AXP_BUILD_STRING'_TOOLS]
$	    DEFINE/NOLOG IVMS$BUILD_IMAGES RESD$:[BUILD.'AXP_BUILD_STRING'_TOOLS]
$	  ENDIF
$!
$	  IF F$TRNLNM("DBGHK$IMAGE_PATH") .EQS. ""
$	  THEN
$	    DEFINE/NOLOG DBGHK$IMAGE_PATH -
				DSKD$:[SYS$LDR],-
				DSKD$:[SYS.OBJ],-
				DSKD$:[DRIVER.OBJ],-
				DSKD$:[SCSI.OBJ],-
				DSKD$:[SHADOWING.OBJ],-
				DSKD$:[R5_DRIVER.OBJ],-
				RESD$:[SYS1.SYS$LDR],-
	                        RESD$:[SYS$LDR],RESD$:[SYSLIB],RESD$:[SYSMSG]
$	  ENDIF
$!
$	  IF F$TRNLNM("LAT$DEVICE") .NES. "" .AND. -
             F$TRNLNM("DBGHK$ADAPTOR") .EQS. ""
$	  THEN
$	    DEFINE/NOLOG DBGHK$ADAPTOR 'F$TRNLNM("LAT$DEVICE")'
$	  ENDIF
$!
$         IF F$TRNLNM("RESD$",,1) .EQS. ""
$	  THEN
$	    DEFINE/NOLOG RESD_SYSROOT -
			 DSKD$:,'F$TRNLNM("RESD$")',SYS$SYSROOT:
$	    DEFINE/NOLOG DSKD_RESD$ -
			 DSKD$:,'F$TRNLNM("RESD$")'
$	  ELSE
$	    DEFINE/NOLOG RESD_SYSROOT -
			 DSKD$:,'F$TRNLNM("RESD$",,0)','F$TRNLNM("RESD$",,1)',SYS$SYSROOT:
$	    DEFINE/NOLOG DSKD_RESD$ -
			 DSKD$:,'F$TRNLNM("RESD$",,0)','F$TRNLNM("RESD$",,1)'
$	  ENDIF
$!
$	  DEFINE/NOLOG SYS$LIBRARY RESD_SYSROOT:[SYSLIB]
$	  DEFINE/NOLOG LNK$LIBRARY DSKD_RESD$:[SYSLIB]SYSBLDLIB.OLB
$!
$	  DEFINE/NOLOG  DECW$XKEYSYMDB SYS$COMMON:[SYSLIB]DECW$XKEYSYMDB.DAT
$!
$! If the architecture of the current system is appropriate for the build,
$! then setup the build tools.
$!
$	  IF F$GETSYI("ARCH_TYPE") .EQ. AXP_BUILD_ARCH
$	  THEN
$	    DEF*INE := DEFINE/NOLOG
$!
$	    IF AXP_NATIVE
$	    THEN
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:ADA.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:ADA
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:ALPHA_ASSEMBLER.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:ALPHA_ASSEMBLER
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:ALPHA_BLISS.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:ALPHA_BLISS
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:ALPHA_CC.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:ALPHA_CC
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:ALPHA_MACRO.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:ALPHA_MACRO
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:CDU.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:CDU
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:CXX.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:CXX
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:LINK.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:LINK
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:LIBRARIAN.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:LIBRARIAN
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:MESSAGE.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:MESSAGE
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:PASCAL.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:PASCAL
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:SDL.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:SDL
$	      IF F$SEARCH("EVMS$BUILD_TOOLS:VIC.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:VIC
$	    ENDIF ! AXP_NATIVE
$!
$	    IF IA64_CROSS
$	    THEN
$		IF F$SEARCH("EVMS$BUILD_TOOLS:IA64_BLISS.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:IA64_BLISS
$		IF F$SEARCH("EVMS$BUILD_TOOLS:IA64_MACRO.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:IA64_MACRO
$		IF F$SEARCH("EVMS$BUILD_TOOLS:IA64_XCC.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:IA64_XCC
$		IF F$TRNLNM("DECC$RTLDEF") .EQS. ""
$		THEN
$		    IF F$SEARCH("DSKD_RESD$:[SYSLIB]DECC$RTLDEF.TLB") .NES. ""
$		    THEN
$			DEFINE DECC$TEXT_LIBRARY -
				DSKD_RESD$:[SYSLIB]DECC$RTLDEF.TLB
$		    ELSE
$			DEFINE DECC$TEXT_LIBRARY -
				DSKD_RESD$:[SYSLIB]DECC$RTLDEF.FOR_RELEASE
$		    ENDIF
$		ENDIF
$		IF F$SEARCH("EVMS$BUILD_TOOLS:IA64_LINK.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:IA64_LINK
$		IF F$SEARCH("EVMS$BUILD_TOOLS:LIBRARIAN.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:LIBRARIAN
$		IF F$SEARCH("EVMS$BUILD_TOOLS:MESSAGE.COM") .NES. "" THEN -
$	                @EVMS$BUILD_TOOLS:MESSAGE
$		IF F$SEARCH("EVMS$BUILD_TOOLS:SDL.COM") .NES. ""
$		THEN
$			@EVMS$BUILD_TOOLS:SDL
$		ELSE
$			DEFINE/USER EVMS$BUILD_TOOLS 'f$logical("evms$alpha_build_tools")
$			@EVMS$ALPHA_BUILD_TOOLS:SDL
$			DEASS/USER EVMS$BUILD_TOOLS
$		ENDIF
$		IAS == "$EVMS$BUILD_TOOLS:IAS.EXE"
$	    ENDIF
$
$	    IF F$SEARCH("RESD$:[SYSUPD]ANALYZE.CLD") .NES. "" THEN -
$	                SET COMMAND RESD$:[SYSUPD]ANALYZE.CLD
$!
$	    SDL   :== SDL/ALPHA/NOLIST/SYMBOLS=(VAX=0,EVAX=1,VAXPAGE=0,BIGPAGE=1)
$	    BLISS :== BLISS/A32/NOTRACE/ENV=NOFP/CHECK=(NOALIGN,ADDRESS_TAKEN)
$!
$	    SET NOON
$	    DEFINE/USER SYS$OUTPUT NL:
$	    DEFINE/USER SYS$ERROR  NL:
$	    SEARCH EVMS$SYSBLDCOM:BLDLOGNAM.COM/OUT='TMP1_FILE_NAME' -
		 "LINK/ALPHA"
$	    SEARCH_STATUS = $SEVERITY
$	    IF SEARCH_STATUS .EQ. 1
$	    THEN
$		@'TMP1_FILE_NAME'
$	        DELETE 'TMP1_FILE_NAME';*
$	    ENDIF
$         ELSE
$!
$! Otherwise, remove any logical names that may cause us to attempt to invoke images
$! that only run on another architecture.
$!
$	    IF F$TRNLNM("LBRSHR","LNM$PROCESS") .NES. "" THEN DEASSIGN LBRSHR
$	    IF F$TRNLNM("SYS$LIBRARY","LNM$PROCESS") .NES. "" THEN DEASSIGN SYS$LIBRARY
$	    IF F$TRNLNM("EVMS$BUILD_IMAGES","LNM$PROCESS") .NES. "" THEN DEASSIGN EVMS$BUILD_IMAGES
$	  ENDIF
$!
$	ENDIF
$!
$	SET NOON
$       IF F$TRNLNM("RESD$",,1) .EQS. ""
$	THEN
$	  WRITE SYS$OUTPUT "Current RESD$ is ",F$TRNLNM("RESD$")
$	ELSE
$	  WRITE SYS$OUTPUT "Current RESD$ is ",F$TRNLNM("RESD$"),",",F$TRNLNM("RESD$",,1)
$	ENDIF
$!
$	IF F$SEARCH("RESD$:[SYSBLD]BUILD.INFO") .NES. ""
$	THEN
$	  TYPE/NOPAGE RESD$:[SYSBLD]BUILD.INFO
$	ENDIF
$!
$	WRITE SYS$OUTPUT "Current LINK command definitions are:"
$	WRITE SYS$OUTPUT "  LINK         = ''LINK'"
$	WRITE SYS$OUTPUT "  BPAGE_LINK   = ''BPAGE_LINK'"
$	WRITE SYS$OUTPUT "  EXECLET_LINK = ''EXECLET_LINK'"
$	WRITE SYS$OUTPUT "  LNK$LIBRARY  = ",F$TRNLNM("LNK$LIBRARY")
$	WRITE SYS$OUTPUT ""
$	WRITE SYS$OUTPUT "Current SDA images and environment are:
$	WRITE SYS$OUTPUT "  SDA          = ",F$TRNLNM("SDA")
$	WRITE SYS$OUTPUT "  SDA$SHARE    = ",F$TRNLNM("SDA$SHARE")
$	WRITE SYS$OUTPUT "  SDA$READ_DIR = ",F$TRNLNM("SDA$READ_DIR"),",",F$TRNLNM("SDA$READ_DIR",,1)
$	WRITE SYS$OUTPUT ""
$!
$       IF F$TRNLNM("RESD$",,1) .EQS. ""
$	THEN
$	  WRITE SYS$OUTPUT "Current RESD$ is ",F$TRNLNM("RESD$")
$	ELSE
$	  WRITE SYS$OUTPUT "Current RESD$ is ",F$TRNLNM("RESD$"),",",F$TRNLNM("RESD$",,1)
$	ENDIF
$!
$	IF F$TYPE(AXP_CROSS) .NES. ""
$	THEN
$	  IF AXP_CROSS
$	  THEN
$	    AXP_BUILD_ARCH = 1
$	    AXP_BUILD_STRING = "CROSS"
$	  ELSE
$	    IF .NOT. IA64_NATIVE
$	    THEN
$	      AXP_BUILD_ARCH = 2
$	      AXP_BUILD_STRING = "NATIVE"
$	    ENDIF
$	  ENDIF
$!
$	  IF F$GETSYI("ARCH_TYPE") .NE. AXP_BUILD_ARCH
$	  THEN
$	    WRITE SYS$OUTPUT ""
$	    WRITE SYS$OUTPUT "%UBL-W-DIFFARCH, ",F$GETSYI("ARCH_NAME")," system ",-
		F$GETSYI("NODENAME")," may not be appropriate for building"
$	    WRITE SYS$OUTPUT "                 components for baselevel ",F$TRNLNM("RESD$")," which is a ",AXP_BUILD_STRING," build."
$	  ENDIF
$	ENDIF
$!
$	EXIT 1
$!
$!
$ABORT: ! 'F$VERIFY(SAVED_VFY)
$!
$	IF F$SEARCH(TMP1_FILE_NAME) .NES. "" THEN DELETE 'TMP_FILE_NAME';*
$	EXIT %X2A
