$!	INSTALL.COM
$!	V2.0			1-May-1999
$!+
$! Copy files.
$!-
$	on error then goto exit
$	on control_y then goto exit
$	set on
$	save_ver = f$verify(0)
$	copy := copy
$!
$
$	status = 1
$! The current codepage definition list:
$	CODEPAGELIST = "1125 1251 437 737 775 850 852 857 861 862 932 936 949 950"
$	UNICODELIST = "1125 1251 437 737 775 850 852 857 861 862 866 932 936 949 950 ISO8859-1 ISO8859-13 "
$	UNICODELIST = UNICODELIST + "ISO8859-15 ISO8859-2 ISO8859-5 ISO8859-7 ISO8859-8 ISO8859-9 KOI8-R KOI8-U"
$ 
$	old_def = f$env("default")
$       _prc = f$environment ("procedure")
$       _dev = f$parse(_prc,,,"device")
$       _dir = f$parse(_prc,,,"directory")
$       set default '_dev''_dir'
$       set default [-]
$!
$	vmsdir = "[.VMS]"
$	bindir = "[.BIN]"
$!
$! Samba root directory
$!
$	root = f$trnlnm("SAMBA_ROOT")
$	if root .eqs. ""
$	then
$		root = "SYS$SYSDEVICE:[SAMBA]"
$	else
$		root = root - ".]" + "]"
$	endif
$!
$	type sys$input

	The Samba files reside in a directory tree pointed to by
	a logical SAMBA_ROOT.

$ ask_root:
$	read/end=exit/error=exit -
	/prompt="Enter DEVICE:[DIRECTORY] for SAMBA_ROOT [''root']: " -
	sys$output line
$	if line .eqs. "" then line = root
$	if f$locate("[",line) .eq. f$length(line) .and. -
	   f$locate(":",line) .eq. f$length(line)
$	then
$		write sys$output -
"%SAMBA_INSTALL-E-ILLROOT, Illegal root directory specification."
$		goto ask_root
$	endif
$	root_dev = f$parse(line,root,,"DEVICE","NO_CONCEAL")
$	root_dir = f$parse(line,root,,"DIRECTORY","NO_CONCEAL")
$	if f$parse(root_dev+root_dir) .eqs. ""
$	then
$		read/end=exit/error=exit/prompt= -
"Directory ''root_dev'''root_dir' does not exist. Create it [Y]: " -
		sys$output yn
$		yn = f$edit(yn,"UPCASE,TRIM,COLLAPSE,UNCOMMENT")
$		if yn .eqs. "N"
$		then
$			write sys$output "Installation aborted."
$			goto exit
$		endif
$		create/directory 'root_dev''root_dir'
$	endif
$	write sys$output ""
$	root_dir = root_dir - "]["
$	call set_dirprot 'root_dev''root_dir' w:re
$	root_dir = root_dir - "]" + ".]"
$	define/system/exec/nolog SAMBA_ROOT 'root_dev''root_dir'/trans=concealed
$!
$!	As of Samba V2.2.8 the SECRETS.TDB file changed from SEQUENTIAL format
$!	to INDEXED (ISAM) format.  If the site is running a previous version
$!	of Samba, then they will probably need to rejoin the NT DOMAIN. 
$!	Warn the user about this possibility.
$!
$	if f$search ("SAMBA_ROOT:[PRIVATE]secrets.tdb") .nes. ""
$	then
$	   file_org = f$file_attributes ("SAMBA_ROOT:[PRIVATE]SECRETS.TDB","ORG")
$	   if file_org .eqs. "SEQ"
$	   then
$	      type sys$input

        You appear to be running a version of Samba prior to V2.2.8.  As of
        Samba V2.2.8 the format of the file SAMBA_ROOT:[PRIVATE]SECRETS.TDB
        has changed from a SEQUENTIAL organization to an INDEXED
        organization.  If part of a WINDOWS DOMAIN, you will be required to
        join the DOMAIN again before starting Samba.  The commands to do
        this are:

             $ SMBPASSWD == "$SAMBA_ROOT:[BIN]SMBPASSWD.EXE"
             $ SMBPASSWD -j domain_name

        You may need to have your OpenVMS system deleted and readded to
        the domain before completing the SMBPASSWD command.        

$		read/end=exit/error=exit/prompt= -
                "Do you wish to continue with the installation [Y]: " -
		sys$output yn
$		yn = f$edit(yn,"UPCASE,TRIM,COLLAPSE,UNCOMMENT")
$		if yn .eqs. "N"
$		then
$			write sys$output "Installation aborted."
$			goto exit
$		endif
$	   endif
$	endif
$!
$! Timezone
$!
$	if f$trnlnm("SYS$TIMEZONE_RULE") .eqs. "" .and. -
	   f$trnlnm("POSIX$DEFAULT_TZ") .eqs. "" .and. -
	   f$trnlnm("TZ") .eqs. ""
$	then
$		type sys$input

	The time zone logical SYS$TIMEZONE_RULE (or POSIX$DEFAULT_TZ)
	have not been set. One of them must be defined to reflect
	your time zone and daylight saving begin and end times.
	See file TIMEZONE_RULE.TXT for the correct format of
	this logical.

$		read/prompt="Press Enter to continue... " sys$output yn
$	endif
$!
$! Create directories
$!
$	write sys$output "Creating Directories..."
$	set noon
$	create/directory SAMBA_ROOT:[BIN]
$	create/directory SAMBA_ROOT:[LIB]
$	create/directory SAMBA_ROOT:[LIB.CODEPAGES]
$	create/directory SAMBA_ROOT:[private]
$	create/directory SAMBA_ROOT:[tmp]
$	create/directory SAMBA_ROOT:[VAR]
$	create/directory SAMBA_ROOT:[VAR.LOCKS]
$!
$! Copy files
$!
$	write sys$output "Copying files..."
$	set on
$	file := SAMBA_ROOT:[LIB]SMB.CONF
$	if f$search(file) .eqs. "" then copy/log 'vmsdir'smb.conf 'file'
$!
$	copy 'vmsdir'smbd_setup_tcpip.com	samba_root:[bin]smbd_setup_tcpip.com
$	copy 'vmsdir'swat_setup_tcpip.com	samba_root:[bin]swat_setup_tcpip.com
$	copy 'vmsdir'grant_samba_root_ident.com	samba_root:[bin]grant_samba_root_ident.com
$	copy 'vmsdir'smbd_startup.com	samba_root:[bin]
$	copy 'vmsdir'swat_startup.com	samba_root:[bin]
$	copy 'vmsdir'nmbd_startup.com	samba_root:[bin]
$	copy 'vmsdir'smbrun.com		samba_root:[bin]
$!
$	copy 'bindir'*.exe		samba_root:[bin]*.exe
$!
$! set file protections
$!
$	write sys$output "Setting file protections..."
$	call set_dirprot samba_root:[bin] w:re
$	call set_dirprot samba_root:[bin] w:re
$	call set_dirprot samba_root:[lib] w:re
$	call set_dirprot samba_root:[lib.codepages] w:re
$	call set_dirprot samba_root:[tmp] w:rw
$	call set_dirprot samba_root:[private] w:rw
$	call set_dirprot samba_root:[var] w:rw
$	call set_dirprot samba_root:[var.locks] w:rw
$ set noon
$	write sys$output "Granting identifier SAMBA_ROOT to SYSTEM"
$	@samba_root:[bin]grant_samba_root_ident.com SYSTEM
$	set file/acl=(IDENTIFIER=*,OPTIONS=DEFAULT,ACCESS=READ+WRITE+CONTROL) samba_root:[000000]var.dir
$	set file/acl=(IDENTIFIER=*,OPTIONS=DEFAULT,ACCESS=READ+WRITE+CONTROL) samba_root:[var]locks.dir
$	delete/nolog samba_root:[var.locks]*.tdb;*
$ set on
$	set file/protection=w:re samba_root:[lib]smb.conf
$	set file/protection=w:e samba_root:[bin]smbrun.com
$	set file/protection=w:e samba_root:[bin]*.exe
$!
$! Create codepages
$!
$	write sys$output "Creating codepages..."
$	@'vmsdir'installcp "''CODEPAGELIST'" "''UNICODELIST'"
$!
$! Create SWAT HTMLs
$!
$	write sys$output "Creating Swat Files..."
$ 	backup [-.swat.images] samba_root:[swat.images]/replace
$ 	backup [-.swat.help] samba_root:[swat.help]/replace
$ 	backup [-.swat.include] samba_root:[swat.include]/replace
$ 	backup [-.docs.htmldocs] samba_root:[swat.help]/replace
$ 	backup [-.docs.htmldocs.using_samba] samba_root:[swat.using_samba]/replace
$ 	backup [-.docs.htmldocs.using_samba.figs] samba_root:[swat.using_samba.figs]/replace
$ 	backup [-.docs.htmldocs.using_samba.gifs] samba_root:[swat.using_samba.gifs]/replace
$!
$! Create startup file
$!
$	file := SYS$COMMON:[SYS$STARTUP]SAMBA_STARTUP.COM
$	write sys$output "Creating startup file ''file'..."
$	create 'file'
$	open/append chan 'file'
$	write chan "$ define/system/exec/nolog SAMBA_ROOT ''root_dev'''root_dir'/trans=concealed"
$	write chan "$ define/system/exec/nolog SAMBA_TMPDIR SAMBA_ROOT:[TMP]"
$	close chan
$	append 'vmsdir'samba_startup.com 'file'
$	purge samba_root:[*...]
$!
$! Setup TCP/IP system
$!
$	write sys$output "Setting up tcpip SMBD & SWAT services..."
$	@samba_root:[bin]smbd_setup_tcpip
$	@samba_root:[bin]swat_setup_tcpip
$!
$! Initialize the STARTUP logs in SYS$MANAGER
$!
$	delete sys$manager:smbd_startup.log;*
$	delete sys$manager:swat_startup.log;*
$	create sys$manager:smbd_startup.log
$	set file/vers=10 sys$manager:smbd_startup.log
$	create sys$manager:swat_startup.log
$	set file/vers=10 sys$manager:swat_startup.log
$!
$	type sys$input

	SAMBA for VMS has been installed successfully.

	The file SYS$STARTUP:SAMBA_STARTUP.COM has been provided to
        start SAMBA for VMS.

	Include the line "@SYS$STARTUP:SAMBA_STARTUP" in the system
        startup file SYS$MANAGER:SYSTARTUP_VMS.COM after your TCPIP
        stack has been started.

	Don't forget to edit SAMBA_ROOT:[LIB]SMB.CONF.

$	goto exit
$!
$ set_dirprot:
$!
$! Input:
$!	P1	- directory spec (e.g. [mydir.subdir])
$!	P2	- protection (e.g. w:re)
$ subroutine
$	dev = f$parse(P1,,,"DEVICE","NO_CONCEAL")
$	dir = f$parse(P1,,,"DIRECTORY","NO_CONCEAL") - "]["
$	gosub make_dirfile
$	set file/protection='P2' 'dev''dirfile'
$	set file/acl/acl=(default_prot,s:rwed,o:rwed,g:rw,'P2') 'dev''dirfile'
$	exit
$!
$ make_dirfile:
$!
$! Input:
$!	dir	- directory spec (e.g. [mydir.subdir])
$! Output:
$!	dirfile - directory file spec (e.g. [mydir]subdir.dir)
$!
$	d = f$parse(dir - "]" + ".-]",,,"DIRECTORY")
$	a = d - "[" - "]"
$	b = dir - "[" - "]"
$	c = b - a - "."
$	dirfile = d + c + ".DIR"
$	return
$ endsubroutine
$!
$ exit:
$!      Let's return to the directory where we started so the user is
$!      not lost.
$!
$       set default 'old_def'
$	if f$trnlnm("chan") .nes. "" then close chan
$	exit status + (0 * 'f$verify(save_ver)')
