/*
**  FILE:   Posix.1 Header <pwd.h>
**  IDENT:  X-7
**
*/
 
# ifndef __PWD_LOADED
# define __PWD_LOADED 1

# ifdef __cplusplus
extern "C" {
# endif

# if __DECC || __DECCXX
#   pragma __nostandard
#   pragma __member_alignment __save
#   pragma __member_alignment
# elif VAXC
#   pragma nostandard
# endif

/* __DEV_T is used with older DEC-C compilers */
#if !(defined __UID_T) && !(defined __DEV_T)
#   define __UID_T 1
    typedef unsigned int uid_t;
#endif

#if !(defined __GID_T) && !(defined __DEV_T)
#   define __GID_T 1
    typedef unsigned short gid_t;    
#endif


struct passwd
{
    char *	pw_name;
    uid_t	pw_uid;
    gid_t	pw_gid;
    char *	pw_dir;
    char *	pw_shell;
/* IfN/Mey + */
    char *	pw_passwd;
    char *	pw_comment;
    char *      pw_gecos;
/* IfN/Mey - */
} ;

struct passwd * getpwuid (uid_t __uid);
struct passwd * getpwnam (const char * __name);


# if __DECC || __DECCXX
#   pragma __member_alignment __restore
#   pragma __standard
# elif VAXC
#   pragma standard
# endif

# ifdef __cplusplus
}
# endif

# endif		/* __PWD_LOADED  */

