/* 
   Unix SMB/Netbios implementation.
   Version 2.0
   Copyright (C) Andrew Tridgell 1994-1999

   This file is part of the port to OpenVMS
   VMS specific definitions, part 1
   Copyright (C) Eckart Meyer 1996-1999
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	vms.h
 *
 * Definitions
 *
 * DEC-C Compiler definitions
 */
/* #define _VMS_V6_SOURCE */
#define _POSIX_EXIT

/* #define u_int unsigned int */

/*
 * Samba definitions
 */
#define SYNC_DNS	/* async requires changes since fork/pipe is used */
#define SMBLOGFILE "/samba_root/var/log.smb"
#define LOGFILEBASE "/samba_root/var"
#define NMBLOGFILE "/samba_root/var/log.nmb"
#define CONFIGFILE "/samba_root/lib/smb.conf"
#define LMHOSTSFILE "/samba_root/lib/lmhosts"
#undef LOCKDIR
#define LOCKDIR "/samba_root/var/locks" 
/* #define WORKGROUP "LANGROUP" */
#undef GUEST_ACCOUNT
#define GUEST_ACCOUNT "TCPIP$NOBODY"
#define DRIVERFILE "/samba_root/lib/printers.def"
#define SMB_PASSWD_FILE "/samba_root/private/smbpasswd.dat"
#define PASSWD_PROGRAM "/samba_exe/passwd.exe"
/* The directory where code page definition files go */
#define CODEPAGEDIR  "/samba_root/lib/codepages"

/* The current codepage definition list. */
#define CODEPAGELIST "437 737 850 852 861 932 866 949 950 936"


/*
 * Specific includes
 */
#define _stat vms_stat
#define _fstat vms_fstat
/* #include "posixtim.h" */
/*
 * RTL routines not present or not present in all DECC/VAXC implementation.
 * We use our own routines then.
 * To prevent DECC from prefixing those routines which *are* implemented
 * meanwhile with DECC$ we give them our own prefix.
 * Especially VMS V7 has much more routines built in. For compatibility
 * reasons we'll not use them currently.
 */
#define unlink vms_delete
#define delete vms_delete
#define rename vms_rename
#define mkdir vms_mkdir
/* #define getcwd vms_getcwd */
#define fchmod vms_fchmod
#define fchown vms_fchown
#define fopen vms_fopen
 #define getpwuid vms_getpwuid
#define getpwnam vms_getpwnam
/* #define getpwent vms_getpwent */
/* struct passwd *getpwent(); */
/* #define setpwent vms_setpwent */
/* #define endpwent vms_endpwent */
/* #define getlogin vms_getlogin */
#define getuid vms_getuid
#define geteuid vms_getuid
#define getgid vms_getgid
#define getegid vms_getgid
/* VMS has no differences between "real uid" and "effective uid" */
#define seteuid vms_setuid
#define setuid vms_setuid
/* #define setgid vms_setgid */
#define setegid vms_setegid
#define opendir vms_opendir
#define closedir vms_closedir
#define readdir vms_readdir
/* #define rewinddir vms_rewinddir */
/* #define strdup vms_strdup */
/* #define getopt vms_getopt */
#define rmdir vms_rmdir
#define getgrnam vms_getgrnam
#define getgrgid vms_getgrgid
#define getgroups vms_getgroups
#define getgrent vms_getgrent
#define setgrent vms_setgrent
#define endgrent vms_endgrent
#define fstat vms_fstat
#define stat vms_stat
#define lstat vms_lstat 	
#define statfs vms_statfs
/* #define setgroups vms_setgroups */
#define initgroups vms_initgroups
/* #define waitpid vms_waitpid */
/* #define fcntl decc$fcntl */
/* #define optarg vms_optarg */
/* #define optind vms_optind */
/* #define optopt vms_optopt */
/* #define opterr vms_opterr */
/* #define select vms_select */

/*
 * For the following we must use our own implementation regardless
 * of RTL-Support, since we add some functionality.
 */
/* #define system vms_system */
#define open stm_open
#define close stm_close
#define read stm_read
#define write stm_write
#define lseek stm_lseek
/*
 * The following original samba functions are redirected to our
 * own routine
 */
#ifndef do_file_lock
#define do_file_lock vms_do_file_lock
#endif

/*
 * Since the VMS linker converts symbols to uppercase, we need
 * to redefine samba's own definitions
 */

#define OpenDir samba_opendir
#define CloseDir samba_closedir
#define TellDir samba_telldir
#define SeekDir samba_seekdir
#define ReadDirName readdirname2
/*
#define StrCpy samba_strcpy
*/
#define StrnCpy samba_strncpy
#define StrCaseCmp samba_strcasecmp
#define StrnCaseCmp samba_strncasecmp
#define StrCat samba_strcpy
/* #define Abort samba_abort */
#define Realloc samba_realloc
/* #define MemMove samba_memmove */
/* #define ChDir samba_chdir */
#define chdir vms_chdir
#define dos_ChDir samba_dos_chdir
#define dos_GetWd samba_dos_getwd
/* #define LocalTime samba_localtime */
#define GetTimeOfDay samba_gettimeofday
/* #define TimeLocal samba_timelocal */
/* #define TimeZone samba_timezone */
#define Dir samba_dir	/* only used dir [.smbd]dir.c */
/*
 * The following symbols are simply too long and distinguished only
 * in characters that will be cut.
 */
#define remove_pending_lock_requests_by_mid rmplkrq_by_mid
#define remove_pending_lock_requests_by_fid rmplkrq_by_fid
#define remove_pending_change_notify_requests_by_fid rmpchnotrq_by_fid
#define remove_pending_change_notify_requests_by_filename rmpchnotrq_by_filename

#define DEFAULT_PRINTING PRINT_VMS
#define PRINTCAP_NAME "/sys$specific/tcpip$lpd/tcpip$printcap.dat"

#include "incl.h"
