#include <stdio.h>
#include <stat.h>
#include <fab.h>
#define BOOL char
#define PRINTF_ATTRIBUTE(a1, a2)
#include <debug.h>
#define TYPE_STAT 1

globalref char exact_size;
globalref char wrkdir[1024];
globalref char do_encode;
globalref char dir_changed;

static unsigned int stat_calls;
static unsigned int stat_real;

int __UTC_vms_stat(const char *file_spec, struct stat *st_buf)
{
	char *buf;
	int status;
	time_t t;
	short ino2;
	ino_t *unix_ino;
	struct vms_ino *inofid;
	char *tmp;
	struct stat *cached_st;
	char wrkfil[2048];

	stat_calls++;

	memset (st_buf, 0, sizeof(struct stat));

	if (*file_spec == 0)
	{
		return -1;
	}

	if (strcmp(file_spec,".") == 0)
	{
		st_buf->st_size = 0;
		st_buf->st_mode = S_IFDIR;
		return 0;
	}

	if (do_encode)
		buf = vms_encode_filespec(file_spec,FALSE);
	else
		buf = file_spec;

	tmp = strchr(buf+1,'.');
	if (tmp == 0)
	   strcat (buf,".");

	if (*buf != '/')
	{
	    if (dir_changed)
	    {
		getcwd (wrkdir, 1024, 0);
		dir_changed = FALSE;
	    }
	    strcpy (wrkfil,wrkdir);
	    strcat (wrkfil,"/");
	    strcat (wrkfil,buf);
	}
	else
	{
	    strcpy (wrkfil,buf);
	}
	tmp = strstr(wrkfil,"//");
	if (tmp != NULL)
	    strcpy (tmp,tmp+1);
	tmp = strstr(wrkfil,"/./");
	if (tmp != NULL)
	    strcpy (tmp,tmp+2);
	cached_st = vms_check_cache(wrkfil,TYPE_STAT);
	if (cached_st != NULL)
	{
	    memcpy(st_buf,cached_st,sizeof(struct stat));
	    return (0);
	}

	stat_real++;
	status = stat(buf, (struct stat *)st_buf);
/*
 * If file not present try a directory which may be encoded differently
 * Confirm that this is really a directory.
 */
	if (status == -1) {
		char tmpbuf[2048];
		if (*(buf+strlen(buf)-1) == '.')
		    *(buf+strlen(buf)-1) = 0;

		strcpy(tmpbuf,file_spec);
		if (strchr(&tmpbuf[1],'.') == 0)
		{
		    strcat (tmpbuf,".dir");
	            buf = vms_encode_filespec(tmpbuf,FALSE);
		    strcat(buf,";1");

		    status = stat(buf, (struct stat *)st_buf);
		    if (status == 0  &&  !(st_buf->st_mode & S_IFDIR)) 
		    {
			status = -1;
		    }
		}
	}

/*
 * Only for "Carriage return" and no stream.
 * Assume that STM, STMLF and STMCR are the 3 last record format 
 */

	if ( /* exact_size && */ (st_buf->st_fab_rat != 0) && (st_buf->st_fab_rfm < FAB$C_STM))
	{
	    st_buf->st_size = vms_get_filesize (st_buf,file_spec);
	}

/*
 * To be compatible to UNIX, st_ino must be 1 32-bit words. VMS uses the
 * 3 16-bit words from the FID. As the goal is to uniquely identify the file by
 * st_ino, we believe that using the 1. and 3. word of the FID is sufficient,
 * since the 2. word is a sequence number only.
 */
/*
	inofid = (struct vms_ino *)(&st_buf->st_ino);
	ino2 = inofid->fid3;
	inofid->fid3 = inofid->fid2;
	inofid->fid2 = ino2;
	unix_ino = (ino_t *)(&inofid);
*/
/*
 * SAMBA
 *
 * A quick and (very) dirty hack to overcome the lack of real
 * access checking (who want's to program it?). We just tell
 * the client the file may be writable, so the client will at least
 * *try* to do it's work. Then the underlying VMS security will of course reject
 * the request if ACL's won't allow. The client will issue an error
 * message, but without it will not even try if standard access says
 * NO but ACL's say YES.
 */
	st_buf->st_mode |= S_IWOTH;    /* probably lie! */
/*
 * SAMBA
 * The meaning of creation time and modification time seems to be
 * reversed in LANmanager. Thus, samba changes the two times.
 */
/*
	if (getenv("SAMBA_SWAP_FILE_TIMES")) {
		t = st_buf->st_mtime;
		st_buf->st_mtime = st_buf->st_ctime;
		st_buf->st_ctime = t;
	}
*/
	if (status == -2) {
/*
 * SAMBA
 * samba requires that stat() returns 0 in order to display the file.
 * since we want to see them at least with size 0 we fake a stat buffer.
 */
		char *p;
		memset(st_buf,0,sizeof(struct stat));
		p = strrchr(buf,'.');
		if (p != NULL  &&  strcmp(p,".DIR") == 0) {
			st_buf->st_mode |= S_IFDIR;
		}
		else {
			st_buf->st_mode |= S_IFREG;
		}
		status = 0;
	}
	if (status == 0) st_buf->st_nlink = 1;	/* "1 hard link" */

	if (status == 0)
	{
	   vms_insert_cache(wrkfil,st_buf,TYPE_STAT,0); 
	}
	exact_size = FALSE;

	return(status);
}
