/* 
   Unix SMB/Netbios implementation.
   Version 2.0.
   Copyright (C) Andrew Tridgell 1994-1999

   This file is part of the port to OpenVMS
   General VMS support routines.
   Copyright (C) Eckart Meyer 1996-1999
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	vms_tricks.c
 *	V2.0			28-Feb-1999	IfN/Mey
 *
 *	Copyright E. Meyer <meyer@ifn.ing.tu-bs.de>
 *      With addition from J.Y. Collot
 *+
 * Samba VMS support.
 * Undocumented VMS features used by VMS_SUPPORT
 *
 * NOTE: includes.h *IS* included here.
 *-
 */

/*
 * This code deals with cache of file stat information
 * and of directory contents.
 *
 * It uses some not-so-well documented features dealing 
 * with the F11BXQP usage of locks, in order
 * to check the validity of the data kept in cache.
 *
 * The undocumented features are :
 *   1. There is a "volume lock" for each mounted disk
 *	whose resource name is F11B$v<disk-label>
 *   2. For each file opened in the system, there is a sub-lock
 *   	of the volume lock, known as "Serialization Lock",
 *	whose resource name is F11B$s<lock-basis>, the lock-basis
 *	being constructed from the FID of the file, 4 bytes containing
 *	the NUM, NMX and RVN parts of the FID
 *	When a file is changed, the 8 first bytes of value block associated with
 *	the serialization lock changes too.
 *
 *	The validity of the data in the cache is then tested
 *	by comparing current state of the 8 first bytes of this value block
 *	with its state when the data was entered into the cache.
 */

#include "includes.h"

#include <starlet.h>
#include <lib$routines.h>
#include <descrip.h>
#include <dvidef.h>
#include <quidef.h>
#include <jpidef.h>
#include <uaidef.h>
#include <ssdef.h>
#include <iodef.h>
#include <ttdef.h>
#include <descrip.h>
#include <prvdef.h>
#include <fab.h>
#include <lkidef.h>
#include <lckdef.h>
#include <time.h>

#undef strcpy
#undef strcat

globalref char exact_size;

static int invalidate_stat_cache = FALSE;

static int krnl_lkb[2];

struct stat_hash_value {
	int  lkid;
	int  dataseq[2];
	struct stat st_buf;
	char exact_size;
   } *stat_value;

static int valblk[4];

struct itemdesc {
  short int buffer_length;
  short int item_code;
  char *buffer;
  short int *ret_length;
  } getlkitem[2] = { {16, LKI$_VALBLK, valblk, 0},
		     { 0,           0,           0, 0}
		   };

struct dir_hash_value {
	int  lkid;
	int  dataseq[2];
	char *dir_buf;
   } *dir_value;

#define TYPE_STAT 1
#define TYPE_DIR 2

static struct disk_cache {
	struct disk_cache *next;
	char device[50];
	hash_table stat_table;
	hash_table dir_table;
	int lkid;
} *first_cache, *cur_cache, *new_cache;

extern int DEBUG_LEVEL;

static char label[20];
static char resname[40];

static char is_smbd = 99;

static char am_i_smbd()
{
   char imgname[512];
   int d[2] = { 512, (int) imgname};
   int code = JPI$_IMAGNAME;
   int len = 0;

   lib$getjpi (
       &code, 
       0, 
       0, 
       0, 
       d, 
       &len);
   imgname[len]=0;
   if ((strstr(imgname,"SMBD.EXE") == 0) &&
       (strstr(imgname,"NMBD.EXE") == 0))
	return FALSE;
   else
        return TRUE;
}
   
static int deq_lock()
{
    int sts;
    sts = sys$deq (
              krnl_lkb[1], 
              0, 
              0, 
              0);
    return sts;
}

static int get_volume_lock()
{
   int sts;
   int resn[2];

   resn[0] = strlen(resname);
   resn[1] = (int) resname;

   sts = sys$enqw (
            0, 
            LCK$K_NLMODE, 
            krnl_lkb, 
            LCK$M_SYSTEM + 
		LCK$M_NOQUOTA +
		LCK$M_EXPEDITE, 
            &resn, 
            0, 
            0, 
            0, 
            0, 
            0, 
            0, 
            0, 
            0);
     return sts;
}

static int get_serial_lock()
{
   int sts;
   int resn[2];

   resn[0] = 10;
   resn[1] = (int) resname;

   sts = sys$enqw (
             0, 
             LCK$K_NLMODE, 
             krnl_lkb, 
             LCK$M_SYSTEM + 
		LCK$M_NOQUOTA +
		LCK$M_EXPEDITE, 
             resn, 
             cur_cache->lkid, 
             0, 
             0, 
             0, 
             0, 
             0, 
             0, 
             0);
     return sts;
}

static int get_serial_valblk()
{
    int sts;
    int iosb[2];
    sts = sys$getlkiw (
              0, 
              &krnl_lkb[1], 
              &getlkitem, 
              iosb, 
              0, 
              0, 
              0);    
    if ((sts&1) == 1)
	sts = iosb[0];
    return sts;
}

void vms_insert_cache (char *file, void *data, char type, unsigned short ino[])
{
   char device[50];
   char *tmp;
   char found = FALSE;
   int sts;
   struct stat *stat_data;

   if (is_smbd == 99)
   {
	is_smbd = am_i_smbd();
   }
   if (!is_smbd)
	return;

   tmp = strchr (file+1,'/');
   if (tmp != NULL)
	*tmp = 0;
   strcpy (device,file+1);
   if (tmp != NULL)
	*tmp = '/';

/* search if we already know this device */

   cur_cache = first_cache;
   while (cur_cache != NULL && !found)
   {
	if (strcmp(device,cur_cache->device) == 0)
		found = TRUE;
	else
	    cur_cache = cur_cache->next;
   }

/* if not found, initialize new hash cache */
   if (!found)
   {
        int dvicode;
	int d[2];
	int dv[2];
	int volnamsize = 0;
        int i;

	new_cache = malloc (sizeof(struct disk_cache));
	new_cache->lkid = 0;
	memset (resname, 0, sizeof(resname));
	new_cache->next = NULL;
	strcpy (new_cache->device,device);
	hash_table_init(&new_cache->stat_table, 
			512, 
			(compare_function)strcmp);
	hash_table_init(&new_cache->dir_table, 
			512, 
			(compare_function)strcmp);
/*
 * Get the label of the volume, to construct
 * the resource name of the volume lock
 */
	dvicode = DVI$_VOLNAM;
	d[0] = strlen(device);
	d[1] = (int) device;
	memset(label,0,sizeof(label));
	dv[0] = 14;	
	dv[1] = (int) label;
	sts = lib$getdvi (
            &dvicode, 
            0, 
            d, 
            0, 
            dv, 
            &volnamsize);
	if ((sts&1) != 1)
	{
	    DEBUG (0,("Unable to find label for %s\n", device));
	    hash_clear (&new_cache->stat_table);
	    free(new_cache);
	    exit(sts);
	}	
	label[volnamsize] = 0;
/*
 * Get a lock on F11B$v<label>
 */
	strcpy (resname,"F11B$v");
	strcat (resname,label);
	for (i=0;i<18;i++) {
	    if (resname[i] == 0)
		resname[i] = ' ';
	}
	cur_cache = new_cache;
   	sts = sys$cmkrnl (get_volume_lock,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Lock Volume %s : %s\n",resname, strerror(EVMSERR,sts)));
	    hash_clear (&new_cache->stat_table);
	    free(new_cache);
	    exit(sts);
	}	
	cur_cache->lkid = krnl_lkb[1];

    /* Put this new cache in the list */
	if (first_cache == NULL)
	    first_cache = new_cache;
	else
	{
	    cur_cache = first_cache;
	    while (cur_cache->next != NULL)
		cur_cache = cur_cache -> next;
	    cur_cache->next = new_cache;
	}
    }

   if (type == TYPE_STAT)
   {
/*
 * Get a serialisation lock on this file
 */
	char tempo;

	memset (resname, 0, sizeof(resname));
	strcpy (resname,"F11B$s");
	stat_data = (struct stat *) data;
	memcpy (&resname[6], &stat_data->st_ino[0], 2);
	memcpy (&resname[8], &stat_data->st_ino[2], 2);
	tempo = resname[8];
	resname[8] = resname[9];
	resname[9] = tempo;
	stat_value = malloc(sizeof(struct stat_hash_value));
   	sts = sys$cmkrnl (get_serial_lock,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Stat Serialization Lock for fid %d %d %d : %s\n",
		     stat_data->st_ino[0],
		     stat_data->st_ino[1], 
		     stat_data->st_ino[2],
		     strerror(EVMSERR,sts)));
	    free (stat_value);
	    return;
	}	

	stat_value->lkid = krnl_lkb[1];
   	sts = sys$cmkrnl (get_serial_valblk,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Getting Valblk : %s\n",
		     strerror(EVMSERR,sts)));
	    free (stat_value);
	    return;
	}	
	memcpy (&stat_value->st_buf, data, sizeof(struct stat));
	memcpy (&stat_value->dataseq, valblk, 8);
	stat_value->exact_size = exact_size;
	hash_insert(&cur_cache->stat_table, stat_value, file);
   }
   else
   {
	char tempo;
	dir_value = malloc(sizeof(struct dir_hash_value));
	dir_value->dir_buf = data;
/*
 * Get a serialisation lock on this file
 */
	memset (resname, 0, sizeof(resname));
	strcpy (resname,"F11B$s");
	memcpy (&resname[6], &ino[0], 2);
	memcpy (&resname[8], &ino[2], 2);
	tempo = resname[8];
	resname[8] = resname[9];
	resname[9] = tempo;
   	sts = sys$cmkrnl (get_serial_lock,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Dir Serialization Lock for fid %d %d %d : %s\n",
		     ino[0],
		     ino[1], 
		     ino[2],
		     strerror(EVMSERR,sts)));
	    free (dir_value);
	    return;
	}	

	dir_value->lkid = krnl_lkb[1];
   	sts = sys$cmkrnl (get_serial_valblk,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Getting Valblk : %s\n",
		     strerror(EVMSERR,sts)));
	    free (dir_value);
	    return;
	}	
	memcpy (&dir_value->dataseq, valblk, 8);
	hash_insert(&cur_cache->dir_table, dir_value, file);
   }
}

void *vms_check_cache(char *file, char type)
{
   char device[50];
   char *tmp;
   char found = FALSE;
   hash_element *elem;
   int sts;

   if (is_smbd == 99)
   {
	is_smbd = am_i_smbd();
   }
   if (!is_smbd)
	return (NULL);

   tmp = strchr (file+1,'/');
   if (tmp != NULL)
   	*tmp = 0;

   strcpy (device,file+1);
   if (tmp != NULL)
   	*tmp = '/';

   cur_cache = first_cache;
   while (cur_cache != NULL && !found)
   {
	if (strcmp(device,cur_cache->device) == 0)
		found = TRUE;
	else
	    cur_cache = cur_cache->next;
   }

    if (!found)
    {
	return(NULL);
    }

    if (type == TYPE_STAT)
    {
	elem = hash_lookup(&cur_cache->stat_table, file);
	if (elem == NULL)
	{
	    return(NULL);
	}
	
	stat_value = elem->value;

	
	krnl_lkb[1] = stat_value->lkid;
   	sts = sys$cmkrnl (get_serial_valblk,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Getting Stat Valblk : %s\n",
		     strerror(EVMSERR,sts)));
	    return (NULL);
	}	

	if (memcmp(valblk,stat_value->dataseq,8) == 0)
	{
	    if (exact_size && !stat_value->exact_size)
	    {
		sys$cmkrnl (
                    deq_lock, 
                    0);
		hash_remove(&cur_cache->stat_table, elem)    ;
		return (NULL);
	    }
	    return &stat_value->st_buf;
	}
	else
	{
	    sys$cmkrnl (
                    deq_lock, 
                    0);
	    hash_remove(&cur_cache->stat_table, elem)    ;
	    return(NULL);
	}
    }
    else
    {
	elem = hash_lookup(&cur_cache->dir_table, file);
	if (elem == NULL)
	{
	    return(NULL);
	}
	dir_value = elem->value;

	krnl_lkb[1] = dir_value->lkid;
   	sts = sys$cmkrnl (get_serial_valblk,0);
	if ((sts & 1) != 1)
	{
	    DEBUG(0,("  Error Getting Dir Valblk : %s\n",
		     strerror(EVMSERR,sts)));
	    return (NULL);
	}	

	if (memcmp(valblk,dir_value->dataseq,8) == 0)
	{
	    return dir_value->dir_buf;
	}
	else
	{
	    sys$cmkrnl (
                    deq_lock, 
                    0);
	    hash_remove(&cur_cache->dir_table, elem)    ;
	    return(NULL);
	}
    }
}

void vms_invalidate_stat_cache(char *name)
{
/*
	struct stat stb;

	invalidate_stat_cache = TRUE;
	vms_stat(name, &stb);
	invalidate_stat_cache = FALSE;
*/
}
