! SDLBUILD.MMS --  MMS Descriptor file to build SDL    
!
.IFDEF DEBUG
QUAL = /DEBUG
LINKQUAL = /DEBUG
.ELSE
LINKQUAL = /NOTRACE/MAP
.ENDIF
	
SDL$PRODUCT :	SDLEXE:SDL.EXE,		SDLEXE:SDLNPARSE.EXE,	-
		SDLEXE:SDLADA.EXE,	SDLEXE:SDLBASIC.EXE,	-
		SDLEXE:SDLBLISS.EXE,	SDLEXE:SDLBLISSF.EXE,	-
		SDLEXE:SDLCC.EXE,	SDLEXE:SDLDTR.EXE,	-
		SDLEXE:SDLEPASCAL.EXE,	SDLEXE:SDLFORTRAN.EXE,	-
		SDLEXE:SDLLISP.EXE,	SDLEXE:SDLMACRO.EXE,	-
		SDLEXE:SDLPASCAL.EXE,	SDLEXE:SDLPLI.EXE

	! No action required

! Images section

SDLEXE:SDL.EXE :	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDL $(LINKQUAL)

SDLEXE:SDLNPARSE.EXE :	SDLLIB:SDLNPARSE.OLB
	@SDLCOM:SDLLINK SDLNPARSE $(LINKQUAL)

SDLEXE:SDLADA.EXE :	SDLOBJ:SDLADA.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLADA $(LINKQUAL)
	
SDLEXE:SDLBASIC.EXE :	SDLOBJ:SDLBASIC.OBJ,	SDLLIB:SDL.OLB,	-
			SDLLIB:SDLBASLIB.OLB
	@SDLCOM:SDLLINK SDLBASIC $(LINKQUAL)

SDLEXE:SDLBLISS.EXE :	SDLOBJ:SDLBLISS.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLBLISS $(LINKQUAL)

SDLEXE:SDLBLISSF.EXE :	SDLOBJ:SDLBLISSF.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLBLISSF $(LINKQUAL)

SDLEXE:SDLCC.EXE :	SDLOBJ:SDLCC.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLCC $(LINKQUAL)

SDLEXE:SDLDTR.EXE :	SDLOBJ:SDLDTR.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLDTR $(LINKQUAL)

SDLEXE:SDLEPASCAL.EXE :	SDLOBJ:SDLEPASCAL.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLEPASCAL $(LINKQUAL)

SDLEXE:SDLFORTRAN.EXE :	SDLOBJ:SDLFORTRAN.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLFORTRAN $(LINKQUAL)

SDLEXE:SDLLISP.EXE :	SDLOBJ:SDLLISP.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLLISP $(LINKQUAL)

SDLEXE:SDLMACRO.EXE :	SDLOBJ:SDLMACRO.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLMACRO $(LINKQUAL)

SDLEXE:SDLPASCAL.EXE :	SDLOBJ:SDLPASCAL.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLPASCAL $(LINKQUAL)

SDLEXE:SDLPLI.EXE :	SDLOBJ:SDLPLI.OBJ,	SDLLIB:SDL.OLB
	@SDLCOM:SDLLINK SDLPLI $(LINKQUAL)


! Object library section

SDLLIB:SDLNPARSE.OLB :	SDLLIB:SDL.OLB,	SDLOBJ:SDLMAIN2.SAV
	COPY SDLLIB:SDL.OLB SDLLIB:SDLNPARSE.OLB
	LIBR/REPLACE SDLLIB:SDLNPARSE.OLB SDLOBJ:SDLMAIN2.SAV

OBJECTS_1 =	SDLOBJ:DEB.OBJ,		SDLOBJ:PATDATA.OBJ,	-
		SDLOBJ:PATDEB.OBJ,	SDLOBJ:PATERROR.OBJ,	-
		SDLOBJ:PATLANGSP.OBJ,	SDLOBJ:PATLRTUNE.OBJ

OBJECTS_2 =	SDLOBJ:PATPARSER.OBJ,	SDLOBJ:PATTOKEN.OBJ,	-
		SDLOBJ:SDLACTION.OBJ,	SDLOBJ:SDLCVTSTR.OBJ,	-
		SDLOBJ:SDLDATA.OBJ,	SDLOBJ:LIBRECDEP.OBJ,	-
		SDLOBJ:SDLDUMP.OBJ,	SDLOBJ:SDLERRMSG.OBJ

OBJECTS_3 =	SDLOBJ:SDLGETLIN.OBJ,	SDLOBJ:SDLHASHF.OBJ,	-
		SDLOBJ:SDLHEADER.OBJ,	SDLOBJ:SDLIMGAC2.OBJ,	-
		SDLOBJ:SDLIMGACT.OBJ,	SDLOBJ:SDLINTREE.OBJ

OBJECTS_4 =	SDLOBJ:SDLLEX.OBJ,	SDLOBJ:SDLMAIN.OBJ,	-
		SDLOBJ:SDLMSG.OBJ,	SDLOBJ:SDLOUTTRE.OBJ,	-
		SDLOBJ:SDLPUTLIN.OBJ,	SDLOBJ:SDLREADFILE.OBJ

OBJECTS_5 =	SDLOBJ:SDLQUE.OBJ,	SDLOBJ:SDLTRIM.OBJ,	-
		SDLOBJ:SDLTRNVEC.OBJ,	SDLOBJ:SDLWRTLIS.OBJ

SDLLIB:SDL.OLB :	$(OBJECTS_1),	$(OBJECTS_2),	-
			$(OBJECTS_3),	$(OBJECTS_4),	-
			$(OBJECTS_5)

	LIBR /CREATE SDLLIB:SDL.OLB $(OBJECTS_1)
	LIBR SDLLIB:SDL.OLB $(OBJECTS_2)
	LIBR SDLLIB:SDL.OLB $(OBJECTS_3)
	LIBR SDLLIB:SDL.OLB $(OBJECTS_4)
	LIBR SDLLIB:SDL.OLB $(OBJECTS_5)

BASOBJ_1 =	SDLOBJ:BASADD_COMMENTS.OBJ,	-
		SDLOBJ:BASDO_BITFIELDS.OBJ,	-
		SDLOBJ:BASDO_CHILDREN.OBJ,	-
		SDLOBJ:BASDO_COM_NODE.OBJ,	-
		SDLOBJ:BASDO_CONDITIONAL.OBJ,	-
		SDLOBJ:BASDO_CONST.OBJ

BASOBJ_2 =	SDLOBJ:BASDO_ENTRY.OBJ,		-
		SDLOBJ:BASDO_GLOB_COM.OBJ,	-
		SDLOBJ:BASDO_ITEM.OBJ,		-
		SDLOBJ:BASDO_LITERAL.OBJ,	-
		SDLOBJ:BASDO_MODULE.OBJ,	-
		SDLOBJ:BASDO_PARAM.OBJ

BASOBJ_3 =	SDLOBJ:BASDO_STRUCTURE.OBJ,	-
		SDLOBJ:BASDO_TOP_LEVEL_DIM.OBJ,	-
		SDLOBJ:BASDO_UNION.OBJ,		-
		SDLOBJ:BASDO_VAR_STRING.OBJ,	-
		SDLOBJ:BASGET_TYPE.OBJ,		-
		SDLOBJ:BASOUTPUT_BUF.OBJ

BASOBJ_4 =	SDLOBJ:BASOUTPUTNODE.OBJ,	-
		SDLOBJ:BASPUT_CHAR_VAR_RECS.OBJ,-
		SDLOBJ:BASPUT_TYPES.OBJ,	-
		SDLOBJ:BASSPECIAL_CHECKS.OBJ,	-
		SDLOBJ:BASTABS.OBJ

SDLLIB:SDLBASLIB.OLB :	$(BASOBJ_1), $(BASOBJ_2), $(BASOBJ_3), $(BASOBJ_4)

	LIBR /CREATE SDLLIB:SDLBASLIB.OLB $(BASOBJ_1)
	LIBR SDLLIB:SDLBASLIB.OLB $(BASOBJ_2)
	LIBR SDLLIB:SDLBASLIB.OLB $(BASOBJ_3)
	LIBR SDLLIB:SDLBASLIB.OLB $(BASOBJ_4)

! Make SDLMAIN2.SAV

SDLOBJ:SDLMAIN2.SAV :	SDLOBJ:SDLMAIN2.PLI
	PLI $(QUAL) /OBJ=SDLOBJ:SDLMAIN2.SAV SDLOBJ:SDLMAIN2.PLI

SDLOBJ:SDLMAIN2.PLI :	SDLSRC:SDLMAIN.PLI
	EDIT/EDT/COMMAND=SDLCOM:SDLNOPARS.COM SDLSRC:SDLMAIN.PLI


! MACRO Section

SDLOBJ:SDLDATA.OBJ :	SDLSRC:SDLDATA.MAR,	SDLLIB:SDLDEF.MLB
	MACRO $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: -     
			SDLSRC:SDLDATA+SDLLIB:SDLDEF/LIB

SDLOBJ:SDLHASHF.OBJ :	SDLSRC:SDLHASHF.MAR,	SDLLIB:SDLDEF.MLB
	MACRO $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: -
			SDLSRC:SDLHASHF+SDLLIB:SDLDEF/LIB

SDLOBJ:SDLLEX.OBJ :	SDLSRC:SDLLEX.MAR,	SDLLIB:SDLDEF.MLB
	MACRO $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: -
			SDLSRC:SDLLEX+SDLLIB:SDLDEF/LIB

SDLOBJ:SDLQUE.OBJ :	SDLSRC:SDLQUE.MAR,	SDLLIB:SDLDEF.MLB
	MACRO $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: -
			SDLSRC:SDLQUE+SDLLIB:SDLDEF/LIB

SDLOBJ:SDLTRNVEC.OBJ :	SDLSRC:SDLTRNVEC.MAR,	SDLLIB:SDLDEF.MLB
	MACRO $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: -
			SDLSRC:SDLTRNVEC+SDLLIB:SDLDEF/LIB


! Parser Tables Section

! The build for SDLSEMDEF uses as input the file SDLPAT.LIS generated in
! the default directory by LALRPAT in the first stage.  To avoid changing
! BLD_SDLSEMDEF.COM or BLD_SDLSEMDEF.TPU, the file COPYRIGHT.TXT has to
! be copied into SDLLIB, where the TPU file expects it to be.
        
SDLLIB:SDLSEMDEF.SDL, SDLLIB:SDLPAT.REQ :	SDLSRC:SDLPAT.PAT, -
						SDLLIB:COPYRIGHT.TXT
	@SDLCOM:SDL_LALRPAT.COM
	@SDLCOM:BLD_SDLSEMDEF.COM
	DELETE SDLPAT.LIS;*

SDLLIB:COPYRIGHT.TXT :	SDLSRC:COPYRIGHT.TXT
	COPY SDLSRC:COPYRIGHT.TXT SDLLIB:


! BLISS Section

! Because of a source problem, BLISS modules must currently always
! be compiled /DEBUG

SDLOBJ:DEB.OBJ :	SDLSRC:DEB.BLI,		SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLSRC:VMS.REQ,		-
			SDLLIB:DEB.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:DEB.BLI

SDLOBJ:PATDATA.OBJ :	SDLSRC:PATDATA.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLLIB:SDLPAT.REQ,	-
			SDLLIB:PATDATA.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATDATA.BLI

SDLOBJ:PATDEB.OBJ :	SDLSRC:PATDEB.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLSRC:VMS.REQ,		-
			SDLLIB:PATDEB.L32,	SDLLIB:PATDATA.L32,	-
			SDLLIB:PATLANGSP.L32,	SDLLIB:PATPARSER.L32,	-
			SDLLIB:DEB.L32,		SDLLIB:PATTOKEN.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATDEB.BLI

SDLOBJ:PATERROR.OBJ :	SDLSRC:PATERROR.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLLIB:PATERROR.L32,	-
			SDLLIB:PATDATA.L32,	SDLLIB:PATLANGSP.L32,	-
			SDLLIB:PATPARSER.L32,	SDLLIB:PATTOKEN.L32,	-
			SDLLIB:DEB.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATERROR.BLI

SDLOBJ:PATLANGSP.OBJ :	SDLSRC:PATLANGSP.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLLIB:PATLANGSP.L32,	-
			SDLLIB:PATDATA.L32,	SDLLIB:DEB.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATLANGSP.BLI

SDLOBJ:PATLRTUNE.OBJ :	SDLSRC:PATLRTUNE.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLLIB:PATLRTUNE.L32,	-
			SDLLIB:PATDATA.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATLRTUNE.BLI

SDLOBJ:PATPARSER.OBJ :	SDLSRC:PATPARSER.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLLIB:PATPARSER.L32,	-
			SDLLIB:PATDATA.L32,	SDLLIB:PATLANGSP.L32,	-
			SDLLIB:PATERROR.L32,	SDLLIB:PATTOKEN.L32,	-
			SDLLIB:PATLRTUNE.L32,	SDLLIB:PATDEB.L32,	-
			SDLLIB:DEB.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATPARSER.BLI

SDLOBJ:PATTOKEN.OBJ :	SDLSRC:PATTOKEN.BLI,	SDLSRC:PATSWITCH.REQ,	-
			SDLSRC:PATPROLOG.REQ,	SDLLIB:PATTOKEN.L32,	-
			SDLLIB:PATLANGSP.L32,	SDLLIB:DEB.L32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:PATTOKEN.BLI

SDLOBJ:LIBRECDEP.OBJ :  SDLSRC:LIBRECDEP.B32
	BLISS /DEBUG /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:LIBRECDEP.B32


! BLISS Libraries Section

! The first three (PATBLSEXT, PATDATA, PATLANGSP) must be built in the
! order given, and before any of the other libraries.
! Use dependencies to force this ordering.

SDLLIB:PATBLSEXT.L32 :	SDLSRC:PATBLSEXT.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:PATBLSEXT.L32 SDLSRC:PATBLSEXT.REQ

SDLLIB:PATDATA.L32 :	SDLLIB:PATBLSEXT.L32,	-
			SDLSRC:PATDATA.REQ,	SDLSRC:PATREQPRO.REQ,	-
			SDLLIB:SDLPAT.REQ,	SDLLIB:PATBLSEXT.L32
	BLISS /DEBUG /LIBRARY=SDLLIB:PATDATA.L32 SDLSRC:PATDATA.REQ

SDLLIB:PATLANGSP.L32 :	SDLLIB:PATDATA.L32,	-
			SDLSRC:PATLANGSP.REQ,	SDLSRC:PATREQPRO.REQ,	-
			SDLLIB:SDLTOKDEF.R32
	BLISS /DEBUG /LIBRARY=SDLLIB:PATLANGSP.L32 SDLSRC:PATLANGSP.REQ

SDLLIB:DEB.L32 :	SDLLIB:PATLANGSP.L32,	-
			SDLSRC:DEB.REQ,		SDLSRC:PATREQPRO.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:DEB.L32 SDLSRC:DEB.REQ

SDLLIB:PATDEB.L32 :	SDLLIB:PATLANGSP.L32,	-
			SDLSRC:PATDEB.REQ,	SDLSRC:PATREQPRO.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:PATDEB.L32 SDLSRC:PATDEB.REQ

SDLLIB:PATERROR.L32 :	SDLLIB:PATLANGSP.L32,	-
			SDLSRC:PATERROR.REQ,	SDLSRC:PATREQPRO.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:PATERROR.L32 SDLSRC:PATERROR.REQ

SDLLIB:PATLRTUNE.L32 :	SDLLIB:PATLANGSP.L32,	-
			SDLSRC:PATLRTUNE.REQ,	SDLSRC:PATREQPRO.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:PATLRTUNE.L32 SDLSRC:PATLRTUNE.REQ

SDLLIB:PATPARSER.L32 :	SDLLIB:PATLANGSP.L32,	-
			SDLSRC:PATPARSER.REQ,	SDLSRC:PATREQPRO.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:PATPARSER.L32 SDLSRC:PATPARSER.REQ

SDLLIB:PATTOKEN.L32 :	SDLLIB:PATLANGSP.L32,	-
			SDLSRC:PATTOKEN.REQ,	SDLSRC:PATREQPRO.REQ
	BLISS /DEBUG /LIBRARY=SDLLIB:PATTOKEN.L32 SDLSRC:PATTOKEN.REQ

! PL/I Section

SDLOBJ:SDLACTION.OBJ :	SDLSRC:SDLACTION.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLSEMDEF.IN,	SDLLIB:SDLTYPDEF.IN,	-
			SDLLIB:SDLMSGDEF.IN,	SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLACTION

SDLOBJ:SDLADA.OBJ :	SDLSRC:SDLADA.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLADA

SDLOBJ:SDLBASIC.OBJ :	SDLSRC:SDLBASIC.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLBASIC

SDLOBJ:SDLBLISS.OBJ :	SDLSRC:SDLBLISS.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLBLISS

SDLOBJ:SDLBLISSF.OBJ :	SDLSRC:SDLBLISSF.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLBLISSF

SDLOBJ:SDLCC.OBJ :	SDLSRC:SDLCC.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLCC

SDLOBJ:SDLCOBOL.OBJ :	SDLSRC:SDLCOBOL.PLI
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLCOBOL

SDLOBJ:SDLCVTSTR.OBJ :	SDLSRC:SDLCVTSTR.PLI
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLCVTSTR

SDLOBJ:SDLDTR.OBJ :	SDLSRC:SDLDTR.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLDTR

SDLOBJ:SDLDUMP.OBJ :	SDLSRC:SDLDUMP.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLDUMP

SDLOBJ:SDLEPASCAL.OBJ :	SDLSRC:SDLEPASCAL.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLEPASCAL

SDLOBJ:SDLERRMSG.OBJ :	SDLSRC:SDLERRMSG.PLI,	SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLERRMSG

SDLOBJ:SDLFORTRAN.OBJ :	SDLSRC:SDLFORTRAN.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLFORTRAN

SDLOBJ:SDLFORTV3.OBJ :	SDLSRC:SDLFORTV3.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLFORTV3

SDLOBJ:SDLGETLIN.OBJ :	SDLSRC:SDLGETLIN.PLI,	SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLGETLIN

SDLOBJ:SDLHEADER.OBJ :	SDLSRC:SDLHEADER.PLI,	SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLHEADER

SDLOBJ:SDLIMGAC2.OBJ :	SDLSRC:SDLIMGAC2.PLI,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLIMGAC2

SDLOBJ:SDLIMGACT.OBJ :	SDLSRC:SDLIMGACT.PLI,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLIMGACT

SDLOBJ:SDLINTREE.OBJ :	SDLSRC:SDLINTREE.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLNODMSK.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLINTREE

SDLOBJ:SDLLISP.OBJ :	SDLSRC:SDLLISP.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLLISP

SDLOBJ:SDLMACRO.OBJ :	SDLSRC:SDLMACRO.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLMACRO

SDLOBJ:SDLMAIN.OBJ :	SDLSRC:SDLMAIN.PLI,	SDLLIB:SDLMSGDEF.IN,	-
			SDLLIB:SDLSHR.IN,	SDLLIB:FILEDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLMAIN

SDLOBJ:SDLOUTTRE.OBJ :	SDLSRC:SDLOUTTRE.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLNODMSK.IN,	-
			SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLOUTTRE

SDLOBJ:SDLPASCAL.OBJ :	SDLSRC:SDLPASCAL.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLPASCAL

SDLOBJ:SDLPLI.OBJ :	SDLSRC:SDLPLI.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLPLI

SDLOBJ:SDLPUTLIN.OBJ :	SDLSRC:SDLPUTLIN.PLI
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLPUTLIN

SDLOBJ:SDLREADFILE.OBJ : SDLSRC:SDLREADFILE.PLI, SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLNODMSK.IN,	SDLLIB:SDLSHR.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLREADFILE

SDLOBJ:SDLSDML.OBJ :	SDLSRC:SDLSDML.PLI,	SDLLIB:SDLNODEF.IN,	-
			SDLLIB:SDLTYPDEF.IN,	SDLLIB:SDLMSGDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLSDML

SDLOBJ:SDLTRIM.OBJ :	SDLSRC:SDLTRIM.PLI
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLTRIM

SDLOBJ:SDLWRTLIS.OBJ :	SDLSRC:SDLWRTLIS.PLI,	SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:SDLWRTLIS


! PL/I for BASIC Section

SDLOBJ:BASADD_COMMENTS.OBJ :		SDLSRC:BASADD_COMMENTS.PLI,	-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLSHR.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASADD_COMMENTS

SDLOBJ:BASDO_BITFIELDS.OBJ :		SDLSRC:BASDO_BITFIELDS.PLI,	-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_BITFIELDS

SDLOBJ:BASDO_CHILDREN.OBJ :		SDLSRC:BASDO_CHILDREN.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_CHILDREN

SDLOBJ:BASDO_COM_NODE.OBJ :		SDLSRC:BASDO_COM_NODE.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_COM_NODE

SDLOBJ:BASDO_CONDITIONAL.OBJ :		SDLSRC:BASDO_CONDITIONAL.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_CONDITIONAL

SDLOBJ:BASDO_CONST.OBJ :		SDLSRC:BASDO_CONST.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_CONST

SDLOBJ:BASDO_ENTRY.OBJ :		SDLSRC:BASDO_ENTRY.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_ENTRY

SDLOBJ:BASDO_GLOB_COM.OBJ :		SDLSRC:BASDO_GLOB_COM.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_GLOB_COM

SDLOBJ:BASDO_ITEM.OBJ :			SDLSRC:BASDO_ITEM.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_ITEM

SDLOBJ:BASDO_LITERAL.OBJ :		SDLSRC:BASDO_LITERAL.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_LITERAL

SDLOBJ:BASDO_MODULE.OBJ :		SDLSRC:BASDO_MODULE.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_MODULE

SDLOBJ:BASDO_PARAM.OBJ :		SDLSRC:BASDO_PARAM.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_PARAM

SDLOBJ:BASDO_STRUCTURE.OBJ :		SDLSRC:BASDO_STRUCTURE.PLI,	-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_STRUCTURE

SDLOBJ:BASDO_TOP_LEVEL_DIM.OBJ :	SDLSRC:BASDO_TOP_LEVEL_DIM.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_TOP_LEVEL_DIM

SDLOBJ:BASDO_UNION.OBJ :		SDLSRC:BASDO_UNION.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_UNION

SDLOBJ:BASDO_VAR_STRING.OBJ :		SDLSRC:BASDO_VAR_STRING.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASDO_VAR_STRING

SDLOBJ:BASGET_TYPE.OBJ :		SDLSRC:BASGET_TYPE.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASGET_TYPE

SDLOBJ:BASOUTPUTNODE.OBJ :		SDLSRC:BASOUTPUTNODE.PLI,	-
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASOUTPUTNODE

SDLOBJ:BASOUTPUT_BUF.OBJ :		SDLSRC:BASOUTPUT_BUF.PLI
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASOUTPUT_BUF

SDLOBJ:BASPUT_CHAR_VAR_RECS.OBJ :	SDLSRC:BASPUT_CHAR_VAR_RECS.PLI, -
					SDLLIB:SDLNODEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASPUT_CHAR_VAR_RECS

SDLOBJ:BASPUT_TYPES.OBJ :		SDLSRC:BASPUT_TYPES.PLI
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASPUT_TYPES

SDLOBJ:BASSPECIAL_CHECKS.OBJ :		SDLSRC:BASSPECIAL_CHECKS.PLI,	-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASSPECIAL_CHECKS

SDLOBJ:BASTABS.OBJ :			SDLSRC:BASTABS.PLI,		-
					SDLLIB:SDLNODEF.IN,		-
					SDLLIB:SDLTYPDEF.IN
	PLI $(QUAL) /LIST=SDLLIS: /OBJ=SDLOBJ: SDLSRC:BASTABS


! MACRO library section

SDLLIB:SDLDEF.MLB :	SDLLIB:SDLSEMDEF.SRC,	SDLLIB:SDLNODEF.SRC,	-
			SDLLIB:SDLTOKDEF.SRC,	SDLLIB:SDLTYPDEF.SRC,	-
			SDLLIB:STSDEF.SRC

	LIBR/CREATE/MACRO SDLLIB:SDLDEF.MLB SDLLIB:*.SRC


! Special includes section

SDLLIB:FILEDEF.IN :	SDLSRC:FILEDEF.IN
	COPY SDLSRC:FILEDEF.IN SDLLIB:FILEDEF.IN

SDLLIB:SDLMSGDEF.IN :	SDLSRC:SDLMSGDEF.IN
	COPY SDLSRC:SDLMSGDEF.IN SDLLIB:SDLMSGDEF.IN

SDLLIB:SDLNODMSK.IN :	SDLSRC:SDLNODMSK.SAV
	COPY SDLSRC:SDLNODMSK.SAV SDLLIB:SDLNODMSK.IN


! SDL Section

SDLLIB:SDLNODEF.IN, SDLLIB:SDLNODEF.SRC :	SDLSRC:SDLNODEF.SDL

	SDL /LAN=(PLI=SDLLIB:SDLNODEF.IN,-
		MAC=SDLLIB:SDLNODEF.SRC) SDLSRC:SDLNODEF

SDLLIB:SDLSEMDEF.IN, SDLLIB:SDLSEMDEF.SRC :	SDLLIB:SDLSEMDEF.SDL

	SDL /LAN=(PLI=SDLLIB:SDLSEMDEF.IN,-
		MAC=SDLLIB:SDLSEMDEF.SRC) SDLLIB:SDLSEMDEF

! See SDLFIXSDLSHR.COM for comments on fixup below
SDLLIB:SDLSHR.IN, SDLLIB:SDLSHR.SRC :	SDLSRC:SDLSHR.SDL

	SDL /LAN=(PLI=SDLLIB:SDLSHR.IN,-
		MAC=SDLLIB:SDLSHR.SRC) SDLSRC:SDLSHR
	EDIT/EDT/COMMAND=SDLCOM:SDLFIXSDLSHR.COM SDLLIB:SDLSHR.IN

SDLLIB:SDLTOKDEF.IN, SDLLIB:SDLTOKDEF.SRC, SDLLIB:SDLTOKDEF.R32 :	-
						SDLSRC:SDLTOKDEF.SDL

	SDL /LAN=(PLI=SDLLIB:SDLTOKDEF.IN, -
		  MAC=SDLLIB:SDLTOKDEF.SRC, -
		  BLISSF=SDLLIB:SDLTOKDEF.R32) SDLSRC:SDLTOKDEF

SDLLIB:SDLTYPDEF.IN, SDLLIB:SDLTYPDEF.SRC :	SDLSRC:SDLTYPDEF.SDL

	SDL /LAN=(PLI=SDLLIB:SDLTYPDEF.IN,-
		MAC=SDLLIB:SDLTYPDEF.SRC) SDLSRC:SDLTYPDEF

SDLLIB:STSDEF.IN, SDLLIB:STSDEF.SRC :		SDLSRC:STSDEF.SDL

	SDL /LAN=(PLI=SDLLIB:STSDEF.IN,-
		MAC=SDLLIB:STSDEF.SRC) SDLSRC:STSDEF

SDLLIB:SDLMSG.SDL :	SDLSRC:SDLMSG.MSG

	MESSAGE/SDL=SDLLIB:SDLMSG.SDL SDLSRC:SDLMSG.MSG

SDLLIB:SDLMSG.IN, SDLLIB:SDLMSG.SRC :		SDLLIB:SDLMSG.SDL

	SDL /LAN=(PLI=SDLLIB:SDLMSG.IN,-
		MAC=SDLLIB:SDLMSG.SRC) SDLLIB:SDLMSG
