$ SAVE_VERIFY = F$VERIFY(P3) !+ TO.COM  v5.0
$
$!   PURPOSE: TO.COM is designed for interactive use to allow 
$!            users to change defaults and refer to recent defaults 
$!            quickly and easily on Files-11 ODS-2 disks. 
$!
$!   AUTHOR:  Alan E. Feldman  betaneptune\a\yahoo.com
$!
$!   HELP:    Run  @TO.COM -HELP  to see the Quick Help screen. 
$! 
$!   PARAMETERS:
$!
$!   P1:  [disk:][directory], logical-name, or reserved keyword.
$! 
$!   P2:  1 or Y:  save old default in the recall stack (default) 
$!        0 or N:  do not save old default in the recall stack
$! 
$!   P3:  1 ==> SET VERIFY 
$!        0 ==> SET NOVERIFY (default) 
$! 
$
$    SET SYMBOL/SCOPE=(NOLOCAL,NOGLOBAL)/VERB 
$
$!!  *** User Settings ***
$    STACK_SIZE = 9	! Total number of slots in logical name recall stack.
$    TO_PROMPT = 0	! If true, set prompt string to current default. 
$    TO_BRIEF = 0	! If true, omit match value and outgoing recall stack.
$    TO_BACK = 0	! If true, use old nBACK-style logical names. 
$
$!!  *** Logical names for overriding the above default user settings ***
$    IF (F$TRNLNM("TO_PROMPT").NES."") THEN TO_PROMPT = F$TRNLNM("TO_PROMPT") 
$    IF (F$TRNLNM("TO_BRIEF").NES."") THEN TO_BRIEF = F$TRNLNM("TO_BRIEF") 
$    IF (F$TRNLNM("TO_BACK").NES."") THEN TO_BACK = F$TRNLNM("TO_BACK")	
$    DEFINE/NOLOG TO_BACK 'TO_BACK'	! For SAVE_DEFAULT.COM. 
$
$!!  *** Initialize symbols *** 
$    WSC := WRITE SYS$COMMAND 
$    WSO := WRITE SYS$OUTPUT 
$    SET_DEFAULT = ""   !! reset in defsski  !! Default after SET DEF 'P1; used to check final default 
$    INITIAL_P1 = P1 	!! reset in defsski  !! P1 as entered by the user after symbol subst.
$    P1BAD = 0 		!! reset in defsski  !! Flag: 1 ==> problem with P1 (new default is bad)
$    DEFSSKI = 0 	!! reset in defsski  !! Flag: 1 ==> user was prompted for input
$    DEF_TO_LOST = 0 	!! only here	     !! Flag: 1 ==> we will define TO_LOST in _SET_LNMS
$    LNMS_OK = 1 	!! only here         !! Flag: 0 ==> a failed run of _SET_LNMS
$    DIFF_DEFAULT_FOUND = 0 	!! only here !! Flag: 1 ==> unexpected old default found (for stack)
$    OTHER_DEFAULT_FOUND = 0 	!! only here !! Flag: 1 ==> unexpected old default found (for message)
$    PATHOLOGICAL = 0	!! only here	     !! Flag: 1 ==> Old default was pathological
$
$!!  *** Define status codes *** 
$    TO__STATUS = %X18008000 
$    TO__SUCCESS = TO__STATUS + %X0001 
$    TO__INFORMATIONAL = TO__STATUS + %X0003 
$    TO__ERROR = TO__STATUS + %X0002 
$    TO__FATAL = TO__STATUS + %X0004
$    TO__CONTROL_Y = TO__STATUS + %X000C 
$!******************************************************************** 
$!!  *** Establish handlers *** 
$    STATUS = TO__SUCCESS
$    ON CONTROL_Y THEN GOTO _CONTROL_Y 
$    SET NOON
$
$!!  *** Help Function *** 
$    IF (P1.EQS."H" .OR. P1.EQS."?"  -  
         .OR. ( (F$EXTRACT(0,1,P1).EQS."/" .OR. F$EXTRACT(0,1,P1).EQS."-")  -
               .AND. F$LOCATE(F$EXTRACT(1,99,P1),"HELP").EQ.0 ) )
$    THEN 
$        GOSUB _HELP 	
$        GOTO _EXIT5
$    ENDIF
$
$!!  *** Check for old default being unusable (or "pathological") ***
$    GOSUB _PATHOLOGICAL
$
$!!  *** Save value of HERE (TO_0) ***
$    LAST_HERE = F$TRNLNM("TO_0") 
$    LAST_HERE_RAW = F$TRNLNM("TO_RAW_0") 
$ 
$!!  *** The next block of code is here in case GOSUB _DEFINE_HERE gives an
$!       error. This way we have a last resort for these variables. ***
$    HERE = F$ENVIRONMENT("DEFAULT") 	
$    HERE_RAW = F$ENVIRONMENT("DEFAULT") 
$
$!!  *** Define HERE and if requested, init ***
$    GOSUB _DEFINE_HERE           ! Define new value of HERE (TO_0). 
$    IF (F$EDIT(P1,"UPCASE").EQS."/INIT") THEN GOTO _EXIT4  
$    IF (F$EDIT(P1,"UPCASE").EQS."-INIT") THEN GOTO _EXIT4  
$ 
$!!  *** Check for unexpected initial default *** 
$    INITIAL_DEF = HERE 
$    INITIAL_DEF_RAW = HERE_RAW 
$    IF ( (LAST_HERE .NES. "") .AND. (LAST_HERE .NES. INITIAL_DEF) -
       .AND. (LAST_HERE_RAW .NES. INITIAL_DEF_RAW) ) 
$    THEN 
$        DIFF_DEFAULT_FOUND = 1 
$        OTHER_DEFAULT_FOUND = 1 
$        IF (.NOT.PATHOLOGICAL) -
             THEN WSO "%TO-W-DEFCHGD, default was changed by another program to ",INITIAL_DEF
$    ENDIF 
$ 
$    IF  (P1.EQS."" .AND. DIFF_DEFAULT_FOUND) 
$    THEN 
$        OLDDEF = LAST_HERE          
$        OLDDEF_RAW = LAST_HERE_RAW  
$        DIFF_DEFAULT_FOUND = 0 
$        ON WARNING THEN GOTO _OLDDEF
$        GOSUB _SET_LNMS
$        WSO "%TO-I-LNMSUPD, LNM recall stack updated with current default ",INITIAL_DEF
$    ENDIF 
$ 
$_OLDDEF:
$    SET NOON
$    OLDDEF = HERE 	
$    OLDDEF_RAW = HERE_RAW 
$
$_RUN_DEFS:
$    			ON WARNING THEN GOTO _CHECK_DEFSSKI 
$
$    IF (P1.EQS."") THEN GOSUB _GET_NEW_PARAMS
$    IF (P1.EQS."") THEN GOTO _EXIT3
$
$    IF (F$LOCATE(",",P1).NE.F$LENGTH(P1)) THEN GOSUB 2STEP_P1	
$
$    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF 
$    GOSUB _PROCESS_P1 
$    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF 
$    GOSUB _CHECK_P1 
$    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF 
$    GOSUB _SET_DEF 
$    			IF (P1BAD) THEN GOTO _NO_SUCH_DEF 
$ 
$    IF (DIFF_DEFAULT_FOUND) 
$    THEN 
$        DEF_TO_LOST = 1   ! for define to_lost 'initial_def' in set_lnms 
$        OLDDEF = LAST_HERE 
$        OLDDEF_RAW = LAST_HERE_RAW 
$        DIFF_DEFAULT_FOUND = 0 
$    ENDIF 
$ 
$    ON WARNING THEN GOTO _EXIT2
$    GOSUB _SET_LNMS 
$    GOTO _EXIT2
$ 
$_CONTROL_Y: 
$    STATUS = TO__CONTROL_Y 
$    SET NOON 
$    WSO " " 
$    WSO " ***  TO.COM aborted by Control/Y  *** " 
$    WSO " " 
$    GOTO _EXIT2 
$ 
$_NO_SUCH_DEF: 
$    SET NOON
$    SET DEFAULT 'HERE 	! Fix bad SET DEF result
$    IF (DIFF_DEFAULT_FOUND) 
$    THEN 
$        OLDDEF = LAST_HERE 
$        OLDDEF_RAW = LAST_HERE_RAW 
$        DIFF_DEFAULT_FOUND = 0 
$        ON WARNING THEN GOTO _CHECK_DEFSSKI
$        GOSUB _SET_LNMS 
$        WSO "%TO-I-LNMSUPD, LNM recall stack updated with current default ",INITIAL_DEF
$    ENDIF 
$ 
$_CHECK_DEFSSKI: 
$    STATUS = $STATUS 
$    SET NOON 
$    SET DEFAULT 'HERE 	! Fix bad SET DEF result
$    IF (DEFSSKI) 
$    THEN 
$        P1 = "" 
$        INITIAL_P1 = "" 
$        P1BAD = 0 
$        STATUS = TO__SUCCESS 
$        DEFSSKI = 0 
$        SET_DEFAULT = ""	
$        GOTO _RUN_DEFS  ! Error occurred at TO prompt, so return to TO prompt. 
$    ENDIF 
$    GOTO _EXIT2         ! Error occurred at DCL prompt, so return to DCL prompt. 
$ 
$_EXIT2: 
$    SET NOON 
$    IF (.NOT.TO_BRIEF) THEN GOSUB _SHOW_DEFS 
$    WSO  " " 
$_EXIT3: 
$    SET NOON 
$    SET DEFAULT 'HERE 
$    WSO "Your default is " 
$    SHOW DEFAULT 
$    IF (.NOT.LNMS_OK) 
$    THEN 
$        WSO " " 
$        WSO "%TO-W-LNMSUPDERR, error updating LNM defaults recall stack" 
$        WSO "-TO-W-LNMSUPDERR, some entries may be incorrect" 
$        STATUS = TO__INFORMATIONAL 
$    ENDIF 
$!!  *** Next statement is for the case of ^Y between _SET_DEF and SET_LNMS, 
$!       since EXIT3 does a SET DEF 'HERE. *** 
$    NEWDEF_SET = F$ENVIRONMENT("DEFAULT").EQS.SET_DEFAULT 
$    IF (INITIAL_P1.NES."" .AND. .NOT.NEWDEF_SET) 
$    THEN 
$        WSO " " 
$        WSO "%TO-E-DEFNOTSET, new default not set" 
$        STATUS = TO__ERROR 
$    ENDIF 
$    WSO " " 
$_EXIT4:
$    IF (TO_PROMPT) THEN GOSUB _PROMPT 
$_EXIT5:
$    EXIT STATUS+0*F$VERIFY(SAVE_VERIFY).OR.%X10000000! Exiting TO.COM 
$! 
$!   *** END OF MAIN PROGRAM *** 
$ 
$!********************************************************************
$!!  *** This subroutine shows the stack, prompts for new params, and
$!   processes them into their final form for P1, P2, and P3. ***
$
$_GET_NEW_PARAMS:  ! local subroutine 
$
$!!  *** Get user input ***
$
$    N = STACK_SIZE 
$    IF (.NOT.TO_BACK)
$    THEN		!! to_'n' style
$        TO_SAVE = F$TRNLNM("TO_SAVE") 
$        TO_LOST = F$TRNLNM("TO_LOST") 
$        WSO " " 
$        IF (TO_SAVE.NES."") THEN WSO  "Enter   S   for ", " TO_SAVE = ", TO_SAVE 
$        IF (TO_LOST.NES."") THEN WSO  "Enter   L   for ", " TO_LOST = ", TO_LOST 
$    50:     IF (N.LT.1) THEN GOTO 59 	
$            TO_'N' = F$TRNLNM("TO_''N'") 
$            IF (TO_'N'.NES."") THEN WSO  "Enter   ''N'   for ", " TO_''N' = ", TO_'N' 
$            N = N - 1 
$            GOTO 50 
$    59: 
$        WSO  "Press <RET> for ", " TO_0 = ", HERE, "  ! (current default)"
$    ELSE		!! nback style
$        SAVE = F$TRNLNM("SAVE") 
$        LOST = F$TRNLNM("LOST") 
$        WSO " " 
$        IF (SAVE.NES."") THEN WSO  "Enter   S   for ", " SAVE = ", SAVE 
$        IF (LOST.NES."") THEN WSO  "Enter   L   for ", " LOST = ", LOST 
$    150:    IF (N.LT.2) THEN GOTO 159 
$            TO_'N' = F$TRNLNM("''N'BACK") 
$            IF (TO_'N'.NES."") THEN WSO  "Enter   ''N'   for ", "''N'BACK = ", TO_'N' 
$            N = N - 1 
$            GOTO 150 
$    159: 
$        LAST = F$TRNLNM("LAST") 
$        IF (LAST.NES."" .AND. STACK_SIZE.GE.1) THEN WSO  "Enter   1   for ", " LAST = ", LAST 
$        WSO  "Press <RET> for ", " HERE = ", HERE
$    ENDIF
$
$    READ SYS$COMMAND PARAMS /PROMPT="Or enter new default:   " 
$    WSC  "===============================================================================" 
$    DEFSSKI = 1 
$
$!!  *** Note: We could have used INQUIRE above but that puts stuff 
$!   in the DCL recall buffer. The "Illegal character" block below
$!   is included in case of use with a captive account. ***
$ 
$!!  *** Process user input ***
$ 
$    IF (F$LOCATE("(",PARAMS).NE.F$LENGTH(PARAMS)) 	!! Forbid lexical functions
$    THEN 
$        WSO "%TO-E-ILLCHAR, Illegal character: ( " 
$        P1BAD = 1
$        RETURN
$    ENDIF 
$
$    PARAMS := 'PARAMS'  ! Needed to perform symbol subst. for 
$!                       ! stuff like 'F.DEV]; trimming and compression is a bonus 
$ 
$    P1 = F$ELEMENT(0," ",PARAMS) 
$    INITIAL_P1 = P1 
$    P2 = F$ELEMENT(1," ",PARAMS) - " " 
$    P3 = F$ELEMENT(2," ",PARAMS) - " " 
$    JUNK = F$VERIFY(P3)
$    RETURN  ! _GET_NEW_PARAMS 
$!********************************************************************
$!   *** This routine checks its input, extracts the two default-
$!   specs from P1, runs the first one thru _PROCESS_P1, sets default
$!   to it, shows this intermediate default, then assigns the second
$!   default-spec to the symbol P1.
$ 
$2STEP_P1:  ! local subroutine 
$    IF (F$ELEMENT(2,",",P1).NES.",")	! True if more than one comma
$    THEN
$        WSO " "
$        WSO "%TO-E-TOOMNYELEM, too many elements in list; reduce to 1 or 2"
$        P1BAD = 1
$        RETURN		! 2STEP_P1 0
$    ENDIF
$    P1A = F$ELEMENT(0,",",P1) 
$    P1B = F$ELEMENT(1,",",P1)
$    P1 = P1A 
$    GOSUB _PROCESS_P1 
$    IF (P1BAD) THEN RETURN  		! 2STEP_P1 1 
$    SET DEFAULT 'P1'			! Cannot use F$PARSE because [-] would be relative 
$    WSO "Intermediate default: "	! to olddef instead of to p1a 
$    SHOW DEFAULT			! Default after one step
$    P1 = P1B 
$    RETURN  !  2STEP_P1 2
$!******************************************************************** 
$!!  PROCESS P1 converts P1 to proper disk-directory syntax. It will check 
$!   for keywords, strip a leading @, process logical names correctly, 
$!   strip filenames from P1 (checking if P1 is an existing file first), 
$!   remove superfluous 000000's, put in missing directory brackets if the 
$!   initial value of P1 not a logical name. 
$ 
$_PROCESS_P1:   ! local subroutine 
$
$    IF (F$EDIT(P1,"COLLAPSE").EQS."")	!! Blank p1 is an error.
$    THEN
$        WSO " "
$        WSO "%TO_PP1-E-MISARG, missing argument "
$        P1BAD = 1
$        RETURN
$    ENDIF
$ 
$    GOSUB _CHECK_FOR_KEYWORDS 
$    IF (P1BAD) THEN RETURN  ! _PROCESS_P1 
$ 
$    IF (F$ELEMENT(2,":",P1).NES.":")	!! True if p1 contains >= 2 colons
$    THEN
$        WSO " "
$        WSO "%TO_PP1-E-TOOMNYCOL, more than one colon "
$        P1BAD = 1
$        RETURN
$    ENDIF
$
$!!  *** If there is a trailing colon, remove it if the result 
$!       is a logical name. This allows analysis of a logical 
$!       name that is followed by a colon to proceed. *** 
$ 
$    COLON_LAST = P1 .EQS. (P1 - ":" + ":") 	!! P1 has only one colon and it is the last char. !!
$    IF (COLON_LAST .AND. P1.NES.":") 		!! Remove trailing colon if result is a logical name. !!
$    THEN 				
$        IF (F$TRNLNM(P1-":").NES."") THEN P1 = P1 - ":"
$    ENDIF 
$
$    IF (F$TRNLNM(P1).NES."") 				!! _LNM for logical names; _FIX_BRACKETS for all others
$    THEN 
$        GOSUB _LNM 
$        IF (F$TRNLNM(P1).NES."") THEN P1 = P1 + ":"	!! Works better in check_p1 (the 0:: part) !!
$    ELSE 
$        GOSUB _FIX_BRACKETS 
$    ENDIF 
$
$    RETURN  			! _PROCESS_P1
$
$!****************************************************************************
$!!  *** If P1 is a reserved value -- 1 thru STACK_SIZE, S, or L -- then P1 is 
$!       replaced by the translation of the appropriate logical name. Also, 
$!       the keywords "~" and "." are processed here. *** 
$
$_CHECK_FOR_KEYWORDS:   ! local subroutine 
$
$    IF (F$TYPE(P1).EQS."INTEGER" .AND. P1.GE.-8 .AND. P1.LE.-1) - 
         THEN P1 = "[" + F$EXTRACT(0,-P1,"--------") + "]" 
$    IF (P1.EQS."T") THEN P1 = F$ELEMENT(0,".",HERE) 
$    IF (P1.EQS."~") THEN P1 = "SYS$LOGIN:"
$    IF (P1.EQS.".") THEN P1 = "SYS$DISK:"
$
$!!  *** STACK true means user has entered a number between 1 and stack_size. ***
$    STACK = (F$TYPE(P1).EQS."INTEGER" .AND. F$EXTRACT(0,1,P1).NES."0" .AND. P1.GE.1 .AND. P1.LE.STACK_SIZE)
$    IF (TO_BACK)
$    THEN
$        IF (P1.EQS."S") THEN P1 = "SAVE" 
$        IF (P1.EQS."L") THEN P1 = "LOST" 
$        IF (STACK) THEN P1 = F$STRING(P1) + "BACK" 	! Next line contains valid keywords.
$        WORD_LIST := HERE,LAST,0BACK,1BACK,2BACK,3BACK,4BACK,5BACK,6BACK,7BACK,8BACK,9BACK,SAVE,LOST  
$    ELSE
$        IF (P1.EQS."S") THEN P1 = "TO_SAVE" 
$        IF (P1.EQS."L") THEN P1 = "TO_LOST" 
$        IF (STACK) THEN P1 = "TO_" + F$STRING(P1) 
$        WORD_LIST := TO_0,TO_1,TO_2,TO_3,TO_4,TO_5,TO_6,TO_7,TO_8,TO_9,TO_SAVE,TO_LOST ! Valid keywords. 
$    ENDIF
$    WORD_CANDIDATE = P1 
$    GOSUB _KEYWORD 	!! If word candidate is in word list, return it. Otherwise, return a null. 
$    IF (FOUND_WORD.EQS."") THEN RETURN  ! _CHECK_FOR_KEYWORDS 
$    IF (F$TRNLNM(FOUND_WORD).EQS."") 	!! Check if referenced stack slot is empty.
$    THEN 
$        WSO " " 
$        WSO "%TO-E-EMPTYSLOT, recall stack slot ",FOUND_WORD," is currently empty" 
$        P1BAD = 1 
$        RETURN
$    ENDIF 
$    RETURN  ! _CHECK_FOR_KEYWORDS 
$!********************************************************************
$!   Looks for word candidate in word list. If found, returns the
$!   candidate. If not found, returns null. 
$!   INPUT: WORD_CANDIDATE, WORD_LIST.
$!   OUTPUT: FOUND_WORD or <null> if WORD_CANDIDATE is not found in WORD_LIST.
$
$_KEYWORD:		! local subroutine 
$    FOUND_WORD = "" 
$    IF (WORD_CANDIDATE .EQS. "") THEN RETURN  ! _KEYWORD 
$    WORD_CANDIDATE = "," + F$EDIT(WORD_CANDIDATE,"UPCASE") + "," 
$    WORD_LIST = "," + F$EDIT(WORD_LIST,"UPCASE") + "," 
$    IF (F$LOCATE(WORD_CANDIDATE,WORD_LIST) .NE. F$LENGTH(WORD_LIST)) THEN - 
     FOUND_WORD = F$ELEMENT(1,",",WORD_CANDIDATE) 
$    RETURN  ! _KEYWORD 
$!********************************************************************
$!   PURPOSE: To handle logical names correctly. SET DEFAULT has 
$!   two problems with nested logical names. See ITERATIVE-LNMS.TXT 
$!   for details. This routine fixes these problems. 
$!
$!   This routine stops iterative logical name translation
$!   once it encounters a logical name that is a search list, 
$!   a logical name whose equivalence name is concealed or 
$!   terminal, or an equivalence name which is not a logical name
$!   itself.
$!
$!   If appropriate, a call is made to _STRIP which removes 
$!   the filename, type, and version, if any, from P1. 
$ 
$_LNM:   ! local subroutine 
$
$!!  !! P1 must be a logical name without a trailing colon !!
$ 
$!!  *** Check for leading @ ***
$    EQUIV0 = F$TRNLNM(P1)
$    P1_STARTS_WITH_AT = F$EXTRACT(0,1,EQUIV0).EQS."@"
$    IF (P1_STARTS_WITH_AT) 
$    THEN
$        P1 = EQUIV0 - "@"
$        GOSUB _STRIP
$        RETURN
$    ENDIF
$
$    GOSUB _NULL_SYNTAX_NODE
$    IF (P1BAD) THEN RETURN
$ 
$_ANALYZE: 
$
$!!  *** Anaylze equivalence name *** 
$    MAX_INDEX = F$TRNLNM(P1,,,,,"MAX_INDEX") 
$    CONCEALED = F$TRNLNM(P1,,,,,"CONCEALED") 
$    TERMINAL  = F$TRNLNM(P1,,,,,"TERMINAL") 
$    EQUIV     = F$TRNLNM(P1) 
$
$!!  *** True if last char is a colon and is the only colon: ***
$    COLON_LAST = EQUIV .EQS. (EQUIV - ":" + ":") 	
$
$    IF (MAX_INDEX.GE.1) 		! Search list lnm: strip it and Return.
$    THEN 
$        GOSUB _STRIP 
$        RETURN  ! _LNM  MAX_INDEX.GE.1
$    ENDIF 
$ 
$    IF (CONCEALED .OR. TERMINAL) THEN RETURN 		! Cease processing.
$ 
$    IF (COLON_LAST) THEN EQUIV = EQUIV - ":" 		! Remove trailing colon.
$ 
$    IF (F$TRNLNM(EQUIV).NES."") 		! Logical name case. 
$    THEN 
$        P1 = EQUIV 				! EQUIV is a logical name 	
$        GOTO _ANALYZE 				! Iterate
$    ENDIF 
$ 
$    IF (COLON_LAST) 		! Not a logical name, restore colon if needed.
$    THEN         		! equiv is a disk name; just add colon
$        P1 = EQUIV + ":"
$    ELSE			! equiv is a file-spec; strip
$        P1 = EQUIV 
$        GOSUB _STRIP 
$    ENDIF
$
$    RETURN  ! _LNM 
$!**************************************************************************** 
$!   PURPOSE: Strips off any file name, type, and version from P1. 
$!            This way you can, e.g., do TO SYSUAF and TO.COM will 
$!            take you to the directory in which SYSUAF resides. 
$ 
$_STRIP:   ! local subroutine   Input: P1  Output: P1 
$ 
$    STRIP_INPUT = P1 
$
$    GOSUB _NULL_SYNTAX_NODE
$    IF (P1BAD) THEN RETURN
$
$!   We cannot use PARSE_TEST = (PARSE1.EQS.PARSE2) as it does not 
$!   work for disk:[dir-spec]A, e.g. This check tells us that
$!   there is something to strip.
$ 
$    PARSE1 = F$PARSE(P1,"A.A;1",,,"SYNTAX_ONLY") 	!! OK
$    PARSE2 = F$PARSE(P1,"B.B;2",,,"SYNTAX_ONLY") 	
$    PARSE_TEST = (PARSE1 - "A.A;1" .EQS. PARSE1)  .OR.  (PARSE2 - "B.B;2" .EQS. PARSE2) 
$!!                PARSE1 does not contain A.A;1          PARSE2 does not contain B.B;2 
$ 
$    IF (.NOT.PARSE_TEST) THEN RETURN 
$ 
$!!  *** Check for a matching file *** 
$    FOUND_FILE = F$SEARCH(P1) 
$    IF (FOUND_FILE.NES."") 
$    THEN 
$        P1 = FOUND_FILE 
$        WSO "%TO_STRIP-I-FILEFND, found file ",FOUND_FILE 
$    ENDIF
$
$!!  *** Strip! *** 
$    P1 = F$PARSE(P1,,,"DEVICE") + F$PARSE(P1,,,"DIRECTORY") 	! Do not add [] because F$SEARCH wouldn't. 
$    WSO "%TO_STRIP-I-STRIPPED, extracted """,P1,""" from """,STRIP_INPUT,""""
$    RETURN  ! _STRIP 
$!!***************************************************************************
$!!  This subroutine checks for null argument, invalid syntax, and presence
$!   of a node-spec, any of which indicate an error condition.
$
$_NULL_SYNTAX_NODE:	! local subroutine
$
$!!  *** Check for null file-spec ***
$    IF (F$EDIT(P1,"COLLAPSE").EQS."")
$    THEN
$        WSO " "
$        WSO "%TO-E-NULLFS, null file-spec"
$        P1BAD = 1
$        RETURN
$    ENDIF
$
$!!  *** Check syntax *** 
$    P1_SYNTAX = F$PARSE(P1,"[]",,,"SYNTAX_ONLY") 		! Do NOT remove "[]" ! OK  DM?
$    IF (P1_SYNTAX.EQS."") 
$    THEN 
$        WSO " " 
$        WSO "%TO-E-INVSTX, invalid syntax"  ! Invalid file-spec syntax.
$        IF (F$TRNLNM(P1).NES."") THEN SHOW LOGICAL 'P1'
$        P1BAD = 1 
$        RETURN 
$    ENDIF 
$
$!!  *** Check for node-spec *** 
$    IF (F$PARSE(P1,,,"NODE").NES."") 	!! OK
$    THEN 
$        WSO " " 
$        WSO "%TO-E-NODESPEC, node-spec not allowed"
$        P1BAD = 1 
$        RETURN 
$    ENDIF 
$
$    RETURN
$!********************************************************************
$!   PURPOSE: This subroutine puts in any needed missing brackets 
$!            and also eliminates superfluous occurences of "000000.". 
$!	      It also process the keywords ".." and "\" and allows
$!	      one to use a root-spec.
$ 
$_FIX_BRACKETS:   ! local subroutine 
$! 
$    COLON_LOC = F$LOCATE(":",P1)
$    IF (COLON_LOC.EQ.F$LENGTH(P1)) THEN COLON_LOC = -1
$    DISK_SPEC = F$EXTRACT(0,COLON_LOC+1,P1) 
$ 
$    DIR_SPEC = P1 - DISK_SPEC - "><" - "][" - "]<" - ">["
$    DIR_SPEC = F$ELEMENT(0,"]",DIR_SPEC) 
$    DIR_SPEC = F$ELEMENT(0,">",DIR_SPEC) 
$ 
$    IF (F$EXTRACT(F$LENGTH(DIR_SPEC)-1,1,DIR_SPEC).EQS."[") -             !! Forgive last char = "[" 
         THEN DIR_SPEC = F$EXTRACT(0,F$LENGTH(DIR_SPEC)-1,DIR_SPEC) 
$    IF (F$EXTRACT(0,1,DIR_SPEC).EQS."[") THEN DIR_SPEC = DIR_SPEC - "["   !! Remove leading "[" 
$    IF (F$EXTRACT(0,1,DIR_SPEC).EQS."<") THEN DIR_SPEC = DIR_SPEC - "<"   !! Remove leading "<" 
$ 
$    IF (DIR_SPEC.EQS."\") THEN DIR_SPEC = "000000" 
$    IF (DIR_SPEC.EQS."..") THEN DIR_SPEC = "-" 
$ 
$    IF (F$DIRECTORY().EQS."[000000]" .AND. F$EXTRACT(0,1,DIR_SPEC).EQS.".") THEN DIR_SPEC = DIR_SPEC - "." 
$    IF (F$DIRECTORY().EQS."<000000>" .AND. F$EXTRACT(0,1,DIR_SPEC).EQS.".") THEN DIR_SPEC = DIR_SPEC - "." 
$
$    DIR_SPEC = "[" + DIR_SPEC + "]" 
$
$!!      *** Can use F$PARSE from this point on in this subroutine ***
$ 
$    DIR_SPEC = F$PARSE(DIR_SPEC,"[]",,"DIRECTORY") -
                - "][" - "><" - "]<" - ">[" 		! To allow roots in dir-spec  ! OK
$
$    IF (DIR_SPEC.EQS."")				! This block added because the parse command       
$    THEN						! might produce a null string. For example,        
$        P1BAD = 1					! when P1 is $%^ or too many levels of directories.
$        WSO " "					
$        WSO "%TO_FB-E-INVDEF, invalid default-spec" 	                                                   
$        RETURN 					! _FIX_BRACKETS bad-dir-spec
$    ENDIF
$
$    P1 = DISK_SPEC + DIR_SPEC 		! Using F$PARSE would ruin a search list of disks. 
$
$    RETURN  ! _FIX_BRACKETS end
$!********************************************************************
$_CHECK_P1:   ! local subroutine	! Input:  local symbol P1 
$					! Output: local symbol P1BAD
$! 
$    GOSUB _NULL_SYNTAX_NODE
$    IF (P1BAD) THEN RETURN
$
$!!  *** Check for improper root syntax ***
$    P1_AUX_DIR = F$PARSE(P1,"[]",,"DIRECTORY") 	
$    IF (     F$LOCATE(".]",P1_AUX_DIR).NE.F$LENGTH(P1_AUX_DIR)   -
         .OR. F$LOCATE(".>",P1_AUX_DIR).NE.F$LENGTH(P1_AUX_DIR) )
$    THEN
$        WSO " "
$        WSO "%TO-E-ROOT, rooted equivalence name must have the concealed attribute"
$        P1BAD = 1
$        RETURN
$    ENDIF
$
$!!  *** Tell user what we're checking *** 
$    WSO " "
$    PARSE1 = F$PARSE(P1,"[AAA]",,"DIRECTORY") 	
$    PARSE2 = F$PARSE(P1,"[BBB]",,"DIRECTORY") 	
$    P1_CONTAINS_DIR = (PARSE1.EQS.PARSE2) 
$    IF (P1_CONTAINS_DIR) 
$    THEN 
$        WSO "Checking ",P1
$    ELSE
$        P1_AUX_DEV = F$PARSE("0::",P1,,"DEVICE")	! Do not translate device name  ! OK
$        P1_AUX_DIR = F$PARSE(P1,"[]",,"DIRECTORY") 	! Get directory			! OK
$        WSO "Checking ",P1_AUX_DEV,P1_AUX_DIR	
$    ENDIF
$
$    P1_DEVICE = F$PARSE(P1,,,"DEVICE","NO_CONCEAL") 		
$
$    IF (P1_DEVICE.EQS."") 
$    THEN 
$        WSO " "
$        WSO "  ***  %TO-W-P1DEVNUL, device is null!!!  *** "
$        P1BAD = 1
$        RETURN
$    ENDIF 
$
$    IF (F$PARSE(P1,"[]",,"DIRECTORY").EQS."")
$    THEN 
$        WSO " " 
$        WSO "*** Inappropriate logical name ***" 
$        P1BAD = 1
$        RETURN 
$    ENDIF 
$ 
$!!  *** Does the device exist? *** 
$ 
$    EXISTS = F$GETDVI(P1_DEVICE,"EXISTS") 
$    IF (.NOT. EXISTS) 
$    THEN 
$        WSO  " " 
$        WSO  "*** Device ",P1_DEVICE," does not exist ***" 
$        P1BAD = 1
$        RETURN 
$    ENDIF 
$ 
$!!  *** Is the device file-oriented? *** 
$ 
$    FOD = F$GETDVI(P1_DEVICE,"FOD") 
$    IF (.NOT. FOD) 
$    THEN 
$        WSO  " " 
$        WSO  "*** Device ", P1_DEVICE, " is not file-oriented ***" 
$        P1BAD = 1
$        RETURN 
$    ENDIF 
$ 
$!!  *** Is the device available? *** 
$ 
$    AVL= F$GETDVI(P1_DEVICE,"AVL") 
$    IF (.NOT. AVL) 
$    THEN 
$        WSO  " " 
$        WSO  "*** Device ", P1_DEVICE, " is not available ***" 
$        P1BAD = 1
$        RETURN 
$    ENDIF 
$ 
$!!  *** Is the device mounted? *** 
$ 
$    MNT= F$GETDVI(P1_DEVICE,"MNT") 
$    IF (.NOT. MNT) 
$    THEN 
$        WSO  " " 
$        WSO  "*** Device ", P1_DEVICE, " is not mounted ***" 
$        P1BAD = 1
$        RETURN 
$    ENDIF 
$ 
$!!  *** Check for existence of default:  *** 
$ 
$    PARSE_CHECK = F$PARSE(P1,"[]") 			! Do NOT remove "[]" ! OK
$    IF (PARSE_CHECK.EQS."") 
$    THEN 
$        WSO  " " 
$        WSO  "*** Directory not found ***" 
$        P1BAD = 1
$        RETURN 
$    ENDIF 
$ 
$!!  *** Check if 1st equiv exists ***
$    IF (P1_SYNTAX.NES.PARSE_CHECK)
$    THEN
$        WSO " "
$        WSO "*** Warning: First equivalence-name default d.n.e. ***"
$    ENDIF   
$
$    RETURN  ! _CHECK_P1 
$!******************************************************************** 
$_SET_DEF:   ! local subroutine 
$    SET NOON 
$    SET DEFAULT 'P1' 
$    SET_DEF_STATUS = $STATUS 
$    SET ON 
$
$    IF (SET_DEF_STATUS) 
$    THEN 
$        SET_DEFAULT = F$ENVIRONMENT("DEFAULT") 
$    ELSE 
$        P1BAD = 1 
$    ENDIF 
$
$    RETURN  ! _SET_DEF 
$!********************************************************************
$!   PURPOSE: To define logical names for easy reference in subsequent 
$!   commands and for the logical name recall stack. 
$
$_SET_LNMS:   ! local subroutine 
$
$!!  *** Input:	current default for HERE, HERE_RAW, NEWDEF, NEWDEF_RAW
$!		DEF_TO_LOST, INITIAL_DEF, INITIAL_DEF_RAW for TO_LOST
$!		OLDDEF, OLDDEF_RAW for LAST, LAST_RAW
$!		OTHER_DEFAULT_FOUND
$!		P2
$! 
$    LNMS_OK = 0		!! Indicates we are about to update LNM's.
$    GOSUB _DEFINE_HERE 	!! Define HERE for final answer.
$ 
$    IF (OLDDEF.EQS."") THEN GOTO _SET_LNMS_EXIT  	
$
$!!  *** Check if the new default is the same as the old default *** 
$!   *** Check both regular and raw in case the new default is 
$!       actually a synonym for the old default ***
$ 
$    NEWDEF = HERE 
$    NEWDEF_RAW = HERE_RAW 
$ 
$    IF ( (NEWDEF_RAW.EQS.OLDDEF_RAW) .OR. (NEWDEF.EQS.OLDDEF) ) 
$    THEN 
$        IF (.NOT.OTHER_DEFAULT_FOUND) 
$        THEN 
$            WSO  " " 
$            WSO  "You are already there!" 
$        ENDIF 
$        GOTO _SET_LNMS_LOST
$    ENDIF 
$ 
$    IF (STACK_SIZE.LE.0) THEN GOTO _SET_LNMS_EXIT
$
$    GOSUB _GET_LNM_DATA
$    GOSUB _FIND_LOWEST_MATCH
$    IF (P2 .OR. P2.EQS."") 	! Default for P2 is TRUE
$    THEN 
$        GOSUB _STACK_UPDATE 
$    ELSE
$        WSO "%TO-I-REMOLDDEF, removing old default from stack by request (P2 was false)" 
$        IF (ACTUAL_MATCH) THEN GOSUB _STACK_SHRINK 
$    ENDIF
$
$    IF (TO_BACK) THEN GOSUB _UPDATE_BACK_LNMS	
$
$_SET_LNMS_LOST:
$    IF  ((DEF_TO_LOST) .AND. (INITIAL_DEF_RAW.NES.NEWDEF_RAW) - 
                        .AND. (INITIAL_DEF.NES.NEWDEF)     ) 
$    THEN 
$        IF (TO_BACK) THEN DEFINE/NOLOG LOST &INITIAL_DEF 
$        IF (TO_BACK) THEN WSO "%TO-I-TO_LOSTDEF, ",INITIAL_DEF," assigned to lnm LOST" 
$        IF (.NOT.TO_BACK) THEN DEFINE/NOLOG TO_LOST &INITIAL_DEF 
$        IF (.NOT.TO_BACK) THEN WSO "%TO-I-TO_LOSTDEF, ",INITIAL_DEF," assigned to lnm TO_LOST" 
$    ENDIF 
$
$_SET_LNMS_EXIT:
$    SET NOON
$    LNMS_OK = 1 		!! Indicates successful completion of subroutine set_lnms.
$    RETURN  ! _SET_LNMS 
$!****************************************************************************
$_GET_LNM_DATA:
$    TO_0 = OLDDEF 
$    TO_RAW_0 = OLDDEF_RAW 
$
$    INDEXVAR = 1 
$10:     TO_'INDEXVAR' = F$TRNLNM("TO_''INDEXVAR'") 
$        TO_RAW_'INDEXVAR' = F$TRNLNM("TO_RAW_''INDEXVAR'") 
$        INDEXVAR = INDEXVAR + 1 			! Increment loop counter
$        IF (INDEXVAR .LE. STACK_SIZE+1) THEN GOTO 10	! The +1 simplifies logic in 
$19: 							! stack shrink routine
$    RETURN
$!****************************************************************************
$!!  Results: MATCH - int - number of lowest slot that matches new default
$!            ACTUAL_MATCH - Boolean - true implies an actual match
$
$_FIND_LOWEST_MATCH: 	! local subroutine
$    INDEXVAR = 1 
$20:     IF (     (NEWDEF .EQS. TO_'INDEXVAR')  -		! We have a match 	! until
             .OR. (NEWDEF_RAW .EQS. TO_RAW_'INDEXVAR') -	! We have a match 	
             .OR. (TO_'INDEXVAR' .EQS. "") -			! null; no more defaults 
             .OR. (TO_RAW_'INDEXVAR' .EQS. "")  ) -    		! prevents incorrect RAW value. 
             THEN GOTO 29 
$        INDEXVAR = INDEXVAR + 1 				! increment loop counter
$        IF (INDEXVAR .LE. STACK_SIZE) THEN GOTO 20		! while in stack
$29: 
$    MATCH = INDEXVAR 
$    ACTUAL_MATCH = TO_'MATCH'.NES.""
$    IF (ACTUAL_MATCH .AND. .NOT.TO_BRIEF) THEN WSO "  MATCH = ",MATCH 
$    RETURN
$!****************************************************************************
$_STACK_UPDATE: 	! local subroutine
$
$    INDEXVAR = 1
$30:     IF (INDEXVAR.GT.MATCH) THEN GOTO 39 			! until we pass match
$        INDEXVARM1 = INDEXVAR - 1 
$        DEFINE/NOLOG TO_'INDEXVAR'  &TO_'INDEXVARM1' 
$        DEFINE/NOLOG TO_RAW_'INDEXVAR'  &TO_RAW_'INDEXVARM1' 
$        INDEXVAR = INDEXVAR + 1 				! increment counter
$        IF (INDEXVAR.LE.STACK_SIZE) THEN GOTO 30    		! while in stack
$39: 
$    RETURN
$!****************************************************************************
$_STACK_SHRINK: 	! local subroutine
$
$    INDEXVAR = MATCH
$40:     INDEXVARP1 = INDEXVAR + 1 
$        IF (TO_'INDEXVARP1'.EQS."") THEN GOTO 49		! until entry is null
$        DEFINE/NOLOG TO_'INDEXVAR'  &TO_'INDEXVARP1' 
$        DEFINE/NOLOG TO_RAW_'INDEXVAR'  &TO_RAW_'INDEXVARP1' 
$        INDEXVAR = INDEXVAR + 1 				! increment loop counter
$        IF (INDEXVAR.LE.STACK_SIZE) THEN GOTO 40 		! while in stack size
$49: 
$    IF (F$TRNLNM("TO_''INDEXVAR'").NES."") THEN DEASSIGN TO_'INDEXVAR' 
$    IF (F$TRNLNM("TO_RAW_''INDEXVAR'").NES."") THEN DEASSIGN TO_RAW_'INDEXVAR' 
$
$    RETURN
$!****************************************************************************
$_UPDATE_BACK_LNMS:
$
$    TO_LNM := TO_1
$    BACK_LNM := LAST
$    GOSUB UPDATE_LNM
$
$    N = 1
$210:    IF (N.GT.STACK_SIZE) THEN GOTO 219	! until we leave the stack
$        TO_LNM := TO_'N'
$        BACK_LNM := 'N'BACK
$        GOSUB UPDATE_LNM
$        IF (F$TRNLNM(TO_LNM).EQS."") THEN RETURN	! Stop *after* first null to_'n'
$        N = N + 1
$        GOTO 210
$219:
$
$    RETURN
$!****************************************************************************
$UPDATE_LNM:
$
$    IF (F$TRNLNM(TO_LNM).NES."") 
$    THEN 
$        DEFINE/NOLOG 'BACK_LNM 'F$TRNLNM(TO_LNM)
$    ELSE
$        IF (F$TRNLNM(BACK_LNM).NES."") THEN DEASSIGN 'BACK_LNM
$    ENDIF
$
$    RETURN
$!****************************************************************************
$_SHOW_DEFS:   ! local subroutine 
$
$    N = STACK_SIZE
$    IF (.NOT.TO_BACK)
$    THEN 		!! to_'n' style
$        TO_SAVE = F$TRNLNM("TO_SAVE") 
$        TO_LOST = F$TRNLNM("TO_LOST") 
$        WSO " " 
$        IF (TO_SAVE.NES."") THEN WSO  "                 TO_SAVE = ", TO_SAVE 
$        IF (TO_LOST.NES."") THEN WSO  "                 TO_LOST = ", TO_LOST 
$    90:     IF (N.LT.1) THEN GOTO 99 			    
$            TO_'N' = F$TRNLNM("TO_''N'") 	
$            IF (TO_'N'.NES."") THEN WSO  "                 TO_''N' = ", TO_'N'     
$            N = N - 1 
$            GOTO 90 
$    99: 
$        WSO  "                ", " TO_0 = ", HERE, "  ! (current default)"
$    ELSE		!! nback style
$        SAVE = F$TRNLNM("SAVE") 
$        LOST = F$TRNLNM("LOST") 
$        WSO " " 
$        IF (SAVE.NES."") THEN WSO  "                 SAVE = ", SAVE 
$        IF (LOST.NES."") THEN WSO  "                 LOST = ", LOST 
$    190:    IF (N.LT.2) THEN GOTO 199 			    
$            TO_'N' = F$TRNLNM("''N'BACK")
$            IF (TO_'N'.NES."") THEN WSO  "                ''N'BACK = ", TO_'N'     
$            N = N - 1 
$            GOTO 190 
$    199: 
$        LAST = F$TRNLNM("LAST") 			
$        IF (LAST.NES."" .AND. STACK_SIZE.GE.1) THEN WSO  "                 LAST = ", LAST 	
$        WSO  "                 HERE = ", HERE	
$    ENDIF
$
$    RETURN 
$!********************************************************************
$!!  PURPOSE: To define HERE so that it can be used as a logical 
$!            name to represent the current default.
$!            A check is made to see if SYS$DISK contains a 
$!            directory-spec. If it does, then the [dir] part of 
$!            current default is not included in the equivalence 
$!            name for HERE. Simply using F$ENVIRONMENT("DEFAULT") 
$!            for HERE will, in some cases, cause commands using 
$!            HERE to fail. For example, TO DISK:[FELDMAN] 
$!            followed by TO SYS$STARTUP would produce a 
$!            nonsensical value of SYS$STARTUP:[FELDMAN] for HERE. 
$ 
$_DEFINE_HERE:   ! local subroutine 
$ 
$    PARSE1 = F$PARSE("SYS$DISK","[AAA]",,"DIRECTORY") 	
$    PARSE2 = F$PARSE("SYS$DISK","[BBB]",,"DIRECTORY") 	
$    SYS$DISK_CONTAINS_DIR = (PARSE1 .EQS. PARSE2) 
$    IF (SYS$DISK_CONTAINS_DIR) 
$    THEN 
$        HERE = F$TRNLNM("SYS$DISK") 
$    ELSE 
$        HERE = F$ENVIRONMENT("DEFAULT") 
$    ENDIF 
$ 
$!!  *** Compute HERE_RAW *** 
$ 
$    IF (F$TRNLNM(F$TRNLNM("SYS$DISK")-":",,,,,"MAX_INDEX").GE.1) 
$    THEN 								! New default contains a search list.
$        HERE_RAW = F$ENVIRONMENT("DEFAULT")				! Just change angle to square brackets.
$        LEFT_ANG = F$LOCATE("<",HERE_RAW)
$        IF (LEFT_ANG.NE.F$LENGTH(HERE_RAW)) THEN HERE_RAW[LEFT_ANG,1] := [
$        RIGHT_ANG = F$LOCATE(">",HERE_RAW)
$        IF (RIGHT_ANG.NE.F$LENGTH(HERE_RAW)) THEN HERE_RAW[RIGHT_ANG,1] := ]
$    ELSE
$        FULLDEVNAM = F$PARSE("",,,"DEVICE") 				! Do NOT add "[]" ! OK
$        IF (FULLDEVNAM.EQS."") THEN GOTO _SKIP_FULLDEVNAM 
$        DEVICE_EXISTS = F$GETDVI(FULLDEVNAM,"EXISTS") 
$        IF (DEVICE_EXISTS) THEN FULLDEVNAM = F$GETDVI(FULLDEVNAM,"FULLDEVNAM") 
$    _SKIP_FULLDEVNAM: 
$        BARE_DIR = F$PARSE("",,,"DIRECTORY","NO_CONCEAL") - 						! OK
                    - "][" - "><" - "]<" -  ">[" - "[000000." - "<000000." - "[" - "]" - "<" - ">" 
$        HERE_RAW = FULLDEVNAM + "[" + BARE_DIR + "]" 
$    ENDIF
$
$!!  *** Assign results to logical names ***
$    SET NOCONTROL=Y
$        		   DEFINE/NOLOG TO_0 &HERE 
$        		   DEFINE/NOLOG TO_HERE &HERE 
$        IF (TO_BACK) THEN DEFINE/NOLOG HERE &HERE 
$        IF (TO_BACK) THEN DEFINE/NOLOG 0BACK &HERE
$        		   DEFINE/NOLOG TO_RAW_0 &HERE_RAW 
$    ON CONTROL_Y THEN GOTO _CONTROL_Y 
$    SET CONTROL=Y
$
$    RETURN 
$!********************************************************************
$_PATHOLOGICAL:		! local subroutine
$!!  *** Check for old default being unusable (or "pathological") ***
$    IF    (F$PARSE("",,,"DEVICE","SYNTAX_ONLY").EQS."" -
       .OR. F$PARSE("",,,"DIRECTORY","SYNTAX_ONLY").EQS."" -
       .OR. F$ELEMENT(2,":",F$ENVIRONMENT("DEFAULT")).NES.":")	!  contains more than 2 colons
$    THEN 
$        WSO "%TO-W-INVOLDDEF, old default is pathological or contains a node-spec: "
$        SHOW DEFAULT
$        WSO "%TO-I-GOHOME, setting default to SYS$LOGIN "
$        SET DEFAULT SYS$LOGIN
$        OTHER_DEFAULT_FOUND = 1 
$        PATHOLOGICAL = 1
$    ENDIF
$    RETURN
$!********************************************************************
$_PROMPT:	! local subroutine
$
$    LEN = F$LENGTH(HERE)
$
$    IF LEN.LE.31
$    THEN
$        PROMPT = HERE + ">"
$    ELSE
$        PROMPT = "~" + F$EXTRACT(LEN-30,30,HERE) + ">"
$    ENDIF
$
$    SET PROMPT=&PROMPT
$    RETURN
$!********************************************************************
$_HELP: ! local subroutine
$    TYPE SYS$INPUT 
$    DECK 
===============================================================================
Format:  $ TO [new-default] [save-old-default] [verification] 

new-default: 
     [device:][dir] - The directory brackets are optional.
    logical-name[:] - Equiv. name can be a node-less default-spec or file-spec.
             <null> - Show LNM Recall Stack and prompt for new default.
     H, -HELP, or ? - Display this help screen (only from DCL prompt).
1 thru 'STACK_SIZE' - Go that many defaults back (default is 1 thru 9). 
default-1,default-2 - Go to default-1 and from there go to default-2.
         -1 thru -8 - Go up *-1 levels      ~ - Go to SYS$LOGIN  .. = [-]
L - Go to [TO_]LOST   S - Go to [TO_]SAVE   T - Go to top level   \ = [000000]

You can use logical names from the LNM Recall Stack in other commands.
If new-default has no delimiters, it is interpreted with the following
precedence: reserved values, logical names, directory-specs. Add a
trailing colon or bracket if needed to force desired interpretation.
Add the following to your LOGIN.COM: 

    $ TO :== @disk:[dir]TO.COM
    $ TO -INIT  ! to initialize TO.COM 

save-old-default: specify N to avoid saving old default in the stack 
    verification: specify Y for DCL command verification 
$    EOD 
$    RETURN
$!#  *** END OF FILE *** 
