IDENTIFICATION DIVISION.
PROGRAM-ID. PROG3.
*
*  WRITES 200 RECORDS TO AN ISAM FILE
*
ENVIRONMENT DIVISION.
INPUT-OUTPUT SECTION.
FILE-CONTROL.

        SELECT TEST-FILE
                ASSIGN TO "SYS$SCRATCH:INT_DEMO_INDEXED.TMP"
                ORGANIZATION IS INDEXED
	        RECORD KEY IS KEY-FLD
	        ACCESS IS DYNAMIC.


DATA DIVISION.
FILE SECTION.

FD  TEST-FILE.
01  TEST-FILE-RECORD.
    05 KEY-FLD         PIC X(5).
    05 DATA-FLD        PIC X(1000).

WORKING-STORAGE SECTION.


01  WS-CNT                       PIC 999   VALUE 0.
01  WS-CNT-1                     PIC 999   VALUE 0.
01  WS-NAME.
    05 WS-KEY-1                  PIC 9(5)  VALUE 0.
    05 WS_DATA                   OCCURS 200 TIMES PIC X(5).

PROCEDURE DIVISION.

MAINLINE SECTION.
START-UP.

        PERFORM 1-LOAD-TABLE VARYING WS-CNT FROM 1 BY 1 
           UNTIL WS-CNT > 200.
	DISPLAY "Creating Indexed file...".
	OPEN OUTPUT TEST-FILE ALLOWING ALL.
	DISPLAY "Populating file...".
	PERFORM 2-WRITE-FILE VARYING WS-CNT FROM 1 BY 1
	   UNTIL WS-CNT > 200.
	CLOSE TEST-FILE.
	STOP RUN.

START-UP-EXIT.
	EXIT.

1-LOAD-TABLE.

        MOVE 'DATA' TO WS-DATA(WS-CNT).

1-EXIT.
        EXIT.

2-WRITE-FILE.
	
	
	INITIALIZE TEST-FILE-RECORD.
        ADD 1 TO WS-CNT-1.
        IF  WS-CNT-1 = 25 THEN
          MOVE 0 TO WS-CNT-1
          DISPLAY "Records written: " WS-CNT WITH CONVERSION
        END-IF.
	MOVE WS-CNT TO WS-KEY-1.
	MOVE WS-NAME TO TEST-FILE-RECORD.
	WRITE TEST-FILE-RECORD
	  INVALID KEY DISPLAY "INVALID FILE WRITE KEY:  " WS-KEY-1.

2-EXIT.
	EXIT.

