/*	IDENT	X-5
**************************************************************************
**                                                                       *
**  Copyright 2002 Compaq Information Technologies Group, L.P.          *
**                                                                       *
** Compaq and the Compaq logo are trademarks of Compaq Information       *
** Technologies Group, L.P. in the U.S. and/or other countries.          *
**                                                                       *
** Confidential computer software.                                       *
** Valid license from Compaq required for possession, use or copying.    *
** Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
** Computer Software Documentation, and Technical Data for Commercial    *
** Items are licensed to the U.S. Government under vendor's standard     *
** commercial license.                                                   *
**                                                                       *
** Compaq shall not be liable for technical or editorial errors or       *
** omissions contained herein.  The information is provided "as is"      *
** without warranty of any kind and is subject to change without notice. *
** The warranties for Compaq products are set forth in the express       *
** warranty statements accompanying such products.  Nothing herein       *
** should be construed as constituting an additional warranty.           *
**                                                                       *
**************************************************************************
**
*/
/*
** FACILITY:
**
**	[USB] Universal Serial Bus 
**
** ABSTRACT:
** 
**     	Get AG data field definitions into their own include file.  They 
** do not belong in the UCB definitions which is private.
**
** Author:
**
**	Forrest A. Kenney			Creation Date: 25-May-2002
**	Paul A. Jacobi				Creation Date: 03-May-2001
** 
** REVISION HISTORY:
**
**	X-5	FAK003		Forrest A. Kenney	03-December-2002
**		Add in support to indicate if we have a device that supports
**		output.  If yes then report the number of items their size in
**		bits.
**	X-4	FAK002		Forrest A. Kenney	25-November-2002
**		Some minor clean up.
**
**	X-3	FAK001		Forrest A. Kenney	24-November-2002
**		Update copyright notice move UCB definitions to their own 
**		include file.  Add data structure to be returned with sense
**		call with bit size and min and max values for axies and slider.
**
*/                         


/*
** Define joystick frame structure
*/
#ifndef	__AGDEF
#define __AGDEF

#define MAX_JOYSTICK_BUTTONS 13
#define JOYSTICK_BASE_FRAME_SIZE 15
#define JOYSTICK_MAX_FRAME_SIZE 21
#define JOYSTICK_INPUT_FRAME_TYPE 4
#define JOYSTICK_INPUT_FRAME_VERSION 1

#pragma __member_alignment __save
#pragma __nomember_alignment
typedef struct               
{
int size;
int type;
int version;
int vendor_id;
int product_id;
int hat;
unsigned int x;
unsigned int y;
unsigned int z;
unsigned int button_valid;
unsigned int button_state;
unsigned int slider;               
} JOYSTICK_INPUT_FRAME;

#pragma __member_alignment __restore

#define	JOYSTICK_LIMIT_DATA_SIZE 80
#define	JOYSTICK_LIMIT_DATA_TYPE 6
#define JOYSTICK_LIMIT_DATA_VERSION 2

typedef struct
{
int	size;
int	type;
int	version;
int	vendor_id;
int	product_id;
int	hat_min;
int	hat_max;
int	hat_size;
int	x_min;
int	x_max;
int	x_size;
int	y_min;
int	y_max;
int	y_size;
int	z_min;
int	z_max;
int	z_size;
int	slider_min;
int	slider_max;
int	slider_size;
/*
**
**	This section reports a minimum of data for devices that support
** output.  So far in our limited testing all output devices are  vendor 
** specific.  So for the time being we will just report the useage page 
** type and the maximum number of bytes that can be sent down the pipe.
**
**	Note that usage page values from ff00 - ffff are vendor 
** defined.  
**
*/
int	output_available;
#define	OUTPUT_AVAILABLE 1
#define OUTPUT_NOTAVAILABLE 0
int	output_max_bytes;
int	output_item_usage_page;
} JOYSTICK_LIMIT_DATA;
#endif /* __AGDEF */
