#pragma module joystick_read "X-4"
/*
**************************************************************************
**                                                                       *
**  Copyright 2002 Compaq Information Technologies Group, L.P.          *
**                                                                       *
** Compaq and the Compaq logo are trademarks of Compaq Information       *
** Technologies Group, L.P. in the U.S. and/or other countries.          *
**                                                                       *
** Confidential computer software.                                       *
** Valid license from Compaq required for possession, use or copying.    *
** Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
** Computer Software Documentation, and Technical Data for Commercial    *
** Items are licensed to the U.S. Government under vendor's standard     *
** commercial license.                                                   *
**                                                                       *
** Compaq shall not be liable for technical or editorial errors or       *
** omissions contained herein.  The information is provided "as is"      *
** without warranty of any kind and is subject to change without notice. *
** The warranties for Compaq products are set forth in the express       *
** warranty statements accompanying such products.  Nothing herein       *
** should be construed as constituting an additional warranty.           *
**                                                                       *
**************************************************************************
**
**
** FACILITY:
**
**      Consulting
**
** ABSTRACT:
** 
**      This program will watch the joystick for data transitions.  It is 
** pretty primitve.  I allows specific items to be watched.
**
**
** AUTHOR:
**
**      Forrest A. Kenney				22-April-2002
**
** REVISION HISTORY:
**
**	X-5	FAK005		Forrest A. Kenney	07-December-2002
**		Add code to trigger polling based on joystick reporting
**		new data.  Get rid of time based code.
**
**	X-4	FAK004		Forrest A. Kenney	04-December-2002
**		Add code to get output information if it is available.
**
**	X-3	FAK003		Forrest A. Kenney	25-November-2002
**		Read device limit data.
**
**	X-2	FAK002		Forrest A. Kenney	09-July-2002
**		Add product and vendor ID support.
**
**      X-1     XXXnnn		Your Name		dd-mmmmmm-yyyy
**              Describe the change.
**/


/* Include files 								*/
#include	<descrip.h>		/* String descriptors			*/
#include	<iodef.h>		/* VMS I/O function codes 		*/
#include	<signal.h>		/* C signals 				*/
#include	<ssdef.h>		/* System error codes 			*/
#include	<starlet.h>		/* System routines			*/
#include	<stdio.h>		/* Stand I/O routines 			*/
#include	<string.h>		/* String functions			*/
#include	"agdef.h"		/* Frame definitions 			*/

/* Globals									*/



unsigned short int	channel;

int			buttons = 0;
int			hat = 0;
int			slider = 0;
int			x = 0;
int			y = 0;
int			z = 0;
int			exiting = 0;

JOYSTICK_INPUT_FRAME	data;
JOYSTICK_INPUT_FRAME	old_data;
JOYSTICK_LIMIT_DATA	limits;


struct _iosb
{
short int		status;
short int		msg_len;
int			unused;
} read_iosb;



/* Prototypes									*/
void	catch_reset ();
void	read_data ();



/*
**++
**	Main - Get us started
**
** Functional description:
**
**	Simple mainline code to get us started off.  The steps we follow are
**
**		1) Assign channel
**		2) Read from device until error or ^c
**
**	For demonstration purposed the program outputs the msg and just passes 
** it along to the job controller.  This is code is for Alpha only the
** compiling and linking instructions are as follows:
**
**	cc 		foo+sys$library:sys$lib_c.tlb
**	link		foo
**
**
** Calling convention:
**
**	int	main(argc, argv)
**
** Input parameters:
**
**	argc		Count of arguments not used
**	argv		Pointer to arguments not used
**
** Output parameters:
**
**	None
**
** Return value:
**
**	Lots 
**
** Environment:
**
**	User mode
**
**--
*/
int	main(int argc, char *argv[])
{

struct  dsc$descriptor_s        devname = {0,
                                           DSC$K_DTYPE_T,
                                           DSC$K_CLASS_S,
                                           NULL};
int	status;
unsigned int	wait_time[2] = {-1*100*1000*10, -1};	/* 100 Ms  10 times a second*/


if (argc >= 2)
{

   devname.dsc$w_length = strlen(argv[1]);
   devname.dsc$a_pointer = argv[1];
   status = sys$assign(&devname, &channel, 0, 0, 0);
   if (status & SS$_NORMAL)
   {
      if (argc == 3)
      {
         if ((strstr(argv[2], "a")) || (strstr(argv[2], "A")))
         {
            buttons = 1;
            hat = 1;
            slider = 1;
            x = 1;
            y = 1;
            z = 1;
         }
         if ((strstr(argv[2], "b")) || (strstr(argv[2], "B")))
         {
            buttons = 1;
         }
         if ((strstr(argv[2], "h")) || (strstr(argv[2], "H")))
         {
            hat = 1;
         }
         if ((strstr(argv[2], "s")) || (strstr(argv[2], "S")))
         {
            slider = 1;
         }
         if ((strstr(argv[2], "x")) || (strstr(argv[2], "X")))
         {
            x = 1;
         }
         if ((strstr(argv[2], "y")) || (strstr(argv[2], "Y")))
         {
            y = 1;
         }
         if ((strstr(argv[2], "z")) || (strstr(argv[2], "Z")))
         {
            z = 1;
         }
      }
      else
      {
         buttons = 1;
         hat = 1;
         slider = 1;
         x = 1;
         y = 1;
         z = 1;
         printf("Did not specify what to watch so watching all items\n");
      }

      /*
      **
      **  Read limit data and output it
      **
      */
      status = sys$qiow(0, channel, IO$_SENSEMODE, &read_iosb, 0, 0, &limits, 
                  sizeof(JOYSTICK_LIMIT_DATA), 0, 0, 0, 0);
      if (status & SS$_NORMAL)
      {
         if (read_iosb.status & SS$_NORMAL)
         {
            printf("Data size is           %8d\n", limits.size);
            printf("Data type is           %8d\n", limits.type);
            printf("Data version is        %8d\n", limits.version);
            printf("vendor_id is           %8d\n", limits.vendor_id);
            printf("product_id is          %8d\n", limits.product_id);
            printf("hat min is             %8d\n", limits.hat_min);
            printf("hat max is             %8d\n", limits.hat_max);
            printf("hat size in bits is    %8d\n", limits.hat_size);
            printf("X min is               %8d\n", limits.x_min);
            printf("X max is               %8d\n", limits.x_max);
            printf("X size in bits is      %8d\n", limits.x_size);
            printf("Y min is               %8d\n", limits.y_min);
            printf("Y max is               %8d\n", limits.y_max);
            printf("Y size in bits is      %8d\n", limits.y_size);
            printf("Z min is               %8d\n", limits.z_min);
            printf("Z max is               %8d\n", limits.z_max);
            printf("Z size in bits is      %8d\n", limits.z_size);
            printf("slider min is          %8d\n", limits.slider_min);
            printf("slider max is          %8d\n", limits.slider_max);
            printf("slider size in bits is %8d\n", limits.slider_size);
            if (limits.output_available)
            {
               printf("Output available\n");
               printf("Max output in bytes    %08d\n", limits.output_max_bytes);
               printf("Output usage page is   %08x\n", limits.output_item_usage_page);
            }
            else
            {
               printf("Output to device not allowed\n");
            }
         }
         else
         {
            printf("Unable to read joystick limit data reason %08x\n", status);
            return(status);
         }
      }
      else
      {
         printf("Unable to read joystick limit data reason %08x\n", status);
         return(status);
      }

      /*
      **   Have the device tell us if there is new data.
      */
      status = sys$clref(59);
      status = sys$qiow(0, channel, IO$_SETMODE, &read_iosb, 0, 0, 59, 1,
                        read_data, 0, 0, 1);


      signal(SIGINT, catch_reset);
      do
      {
         /*
         **   This should probably be recoded to be a repeating Timer.
         */
//         status = sys$setimr(0, &wait_time, read_data, 0 , 0);
//
//         if (!(status & SS$_NORMAL))
//         {
//            exiting = 1;
//         }
         status = sys$waitfr(59);
         status = sys$clref(59);
//         read_data();
      } while(!exiting);
   }
   else
   {
      printf("\nAssign failed reason %08X\n", status);
   }
}
else
{
   printf("No Joystick device specified\n");
   status = SS$_NOSUCHDEV;
}

return status;

}



/*
**++
**	catch_reset - Catch CTRL-C 
**
** Functional description:
**
**	Catch the CTRL-C signal so that we can resetart the mainline and 
** undo what we have wrought.
**
** Calling convention:
**
**	void	 catch_reset()
**
** Input parameters:
**
**	None
**
** Output parameters:
**
**	None
**
** Return value:
**
**	None
**
** Environment:
**
**	User mode.
**
**--
*/
void	catch_reset()
{

exiting = 1;

}



/*
**++
**	read_data - read message from mailbox and output it
**
** Functional description:
**
**	This routine will read the joystick data and output what has changed 
** since last sample.
**
** Calling convention:
**
**	void	read_data ()
**
** Input parameters:
**
**	None
**
** Output parameters:
**
**	None
**
** Return value:
**
**	None
**
** Environment:
**
**	User mode AST.
**
**--
*/
void	read_data()
{
int	i;
int	status;

status = sys$qiow(0, channel, IO$_READVBLK, &read_iosb, 0, 0, &data, 
                  sizeof(JOYSTICK_INPUT_FRAME), 0, 0, 0, 0);
if (!(status & SS$_NORMAL))
{
   printf("Restarting read QIO failed reason %08x\n", status);
   exiting = 1;
   return;
}

if (read_iosb.status & SS$_NORMAL)
{
   if (old_data.vendor_id != data.vendor_id)
   {
      printf("Vendor ID      %08x\n", data.vendor_id);
   }

   if (old_data.product_id != data.product_id)
   {
      printf("Product ID     %08x\n", data.product_id);
   }

   if ((hat) && (old_data.hat != data.hat))
   {
      printf("Hat data is    %08x\n", data.hat);
   }

   if ((slider) && (old_data.slider != data.slider))
   {
      printf("Slider data is %08x\n", data.slider);
   }
   if ((buttons) && (old_data.button_state != data.button_state))
   {
      printf("Button data is %08x\n", data.button_state);
   }
   if ((x) && (old_data.x != data.x))
   {
      printf("X data is      %08x\n", data.x);
   }
   if ((y) && (old_data.y != data.y))
   {
      printf("Y data is      %08x\n", data.y);
   }
   if ((z) && (old_data.z != data.z))
   {
      printf("Z data is      %08x\n", data.z);
   }

   old_data = data;
}
else
{
   printf("\n Read QIO failed reason %08X program exiting\n", read_iosb.status);
   exiting = 1;
}

}
