#pragma module button_read "X-2"
/*
******************************************************************************
** 
** Copyright  Digital Equipment Corporation, 1998 All Rights Reserved.
** Unpublished rights reserved under the copyright laws of the United States.
** 
** The software contained on this media is proprietary to and embodies the
** confidential technology of Digital Equipment Corporation.  Possession, use,
** duplication or dissemination of the software and media is authorized only
** pursuant to a valid written license from Digital Equipment Corporation.
** 
** RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the U.S.
** Government is subject to restrictions as set forth in Subparagraph
** (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.
** 
******************************************************************************
**
**
** FACILITY:
**
**      Consulting
**
** ABSTRACT:
** 
**      This program will read the button presses on the Compaq standard 
** PC keyboard using the hacked up mouse driver.
**
**	Tested Keyboards Model # 	Make    	Comments
**			 SK-2855 	Silitek 	black for IPAQ
**			 SDM4540UL	Compaq 		Internet keyboard
**
**
**
** AUTHOR:
**
**      Forrest A. Kenney				22-April-2002
**
** REVISION HISTORY:
**
**	X-2	FAK001		Forrest A. Kenney	21-June-2002
**		Add support for multiple report types.  And up to 64 
** 		buttons.
**/


/* Include files 								*/
#include	<descrip.h>		/* String descriptors			*/
#include	<ints.h>
#include	<iodef.h>		/* VMS I/O function codes 		*/
#include	<signal.h>		/* C signals 				*/
#include	<ssdef.h>		/* System error codes 			*/
#include	<starlet.h>		/* System routines			*/
#include	<stdio.h>		/* Stand I/O routines 			*/


/* Globals									*/
#define		FRAME_SIZE	28

unsigned char		data[FRAME_SIZE];
unsigned short int	channel;


struct _iosb
{
short int		status;
short int		msg_len;
int			unused;
} read_iosb;

struct _trm_mask
{
short int	size;
short int	unused;
unsigned int	*mask;
} trm_mask;

unsigned int	mask[8];



/* Prototypes									*/
void	catch_reset ();
void	read_data ();



/*
**++
**	Main - Get us started
**
** Functional description:
**
**	Simple mainline code to get us started off.  The steps we follow are
**
**		1) Assign channel
**		2) Read from device until error or ^c
**
**	For demonstration purposed the program outputs the msg and just passes 
** it along to the job controller.  This is code is for Alpha only the
** compiling and linking instructions are as follows:
**
**	cc 		foo+sys$library:sys$lib_c.tlb
**	link		foo
**
**
** Calling convention:
**
**	int	main(argc, argv)
**
** Input parameters:
**
**	argc		Count of arguments not used
**	argv		Pointer to arguments not used
**
** Output parameters:
**
**	None
**
** Return value:
**
**	Lots 
**
** Environment:
**
**	User mode
**
**--
*/
int	main()
{
$DESCRIPTOR(devname,"CPQ0:");

int	status;

trm_mask.size = 256;
trm_mask.mask = &mask[0];

status = sys$assign(&devname, &channel, 0, 0, 0);
if (status & SS$_NORMAL)
{
   signal(SIGINT, catch_reset);
   status = sys$qio(0, channel, IO$_READVBLK | IO$M_NOFILTR | IO$M_NOECHO, &read_iosb, 
                    read_data, 0, &data[0], FRAME_SIZE, 0, &trm_mask, 0, 0);
   if (status & SS$_NORMAL)
   {
      sys$hiber();
   }
   else
   {
      printf("Read from device failed reason %08x\n", status);
   }
}
else
{
   printf("\nAssign failed reason %08X\n", status);
}

return status;

}



/*
**++
**	catch_reset - Catch CTRL-C 
**
** Functional description:
**
**	Catch the CTRL-C signal so that we can resetart the mainline and 
** undo what we have wrought.
**
** Calling convention:
**
**	void	 catch_reset()
**
** Input parameters:
**
**	None
**
** Output parameters:
**
**	None
**
** Return value:
**
**	None
**
** Environment:
**
**	User mode.
**
**--
*/
void	catch_reset()
{

sys$wake(0, 0);

}



/*
**++
**	read_data - read message from mailbox and output it
**
** Functional description:
**
**	This routine will read a message from our mailbox and output the 
** contents as a HEX string.  It will then queue another read to the mailbox.
**
** Calling convention:
**
**	void	read_mailbox ()
**
** Input parameters:
**
**	None
**
** Output parameters:
**
**	None
**
** Return value:
**
**	None
**
** Environment:
**
**	User mode AST.
**
**--
*/
void	read_data()
{
int	i;
int	status;
#pragma nomember_alignment
struct __frame
{
char		size;
char		type;
char		version;
unsigned int 	product_id;
unsigned int	vendor_id;
unsigned char	report_id;
uint64		valid_buttons;
uint64		buttons;
}  *frame;
#pragma member_alignment


if (read_iosb.status & SS$_NORMAL)
{
   printf("Bytes read %3.3d\n", read_iosb.msg_len);
   frame = (struct __frame *) &data[0];
   printf("Frame size         %3.3d\n", frame->size);
   printf("      type         %3.3d\n", frame->type);
   printf("      version      %3.3d\n", frame->version);
   printf("      product id   %8.8x\n", frame->product_id);
   printf("      vendor id    %8.8x\n", frame->vendor_id);
   printf("      report id    %3.3d\n", frame->report_id);
   printf("Valid buttons mask %16.16Lx\n", frame->valid_buttons);
   printf("      button  mask %16.16Lx\n", frame->buttons);
   if (frame->buttons == 0)
   {
      printf("                    All buttons up\n");
   }
   else 
   {
      if (frame->buttons & 1)
      {
         printf("                     Mail button pushed\n");
      }
      if  (frame->buttons & 2)
      {
         printf("                     Arrow button pushed\n");
      }
      if  (frame->buttons & 4)
      {
         printf("                     Q button pushed\n");
      }
      if  (frame->buttons & 8)
      {
         printf("                     Power button pushed\n");
      }
      if  (frame->buttons & 16)
      {
         printf("                     Search button pushed\n");
      }
      if  (frame->buttons & 32)
      {
         printf("                     Airplane button pushed\n");
      }
      if  (frame->buttons & 64)
      {
         printf("                     shopping cart pushed\n");
      }
   }
   status = sys$qio(0, channel, IO$_READVBLK | IO$M_NOFILTR | IO$M_NOECHO, &read_iosb, 
                    read_data, 0, &data[0], FRAME_SIZE, 0, &trm_mask, 0, 0);
   if (!(status & SS$_NORMAL))
   {
      printf("Restarting read QIO failed reason %08x waking up main\n", status);
      sys$wake(0,0);
   }
}
else
{
   printf("\n Read QIO failed reason %08X program exiting\n", read_iosb.status);
   sys$wake(0,0);
}

}
