# $Header: /usr/build/vile/vile/filters/RCS/mk-0th.awk,v 1.8 2004/03/18 00:01:17 tom Exp $
# Construct the header file "builtflt.h".
BEGIN	{
	    print "/* Generated by filters/mk-0th.awk */"
	    nAll = 0;
	    nInt = 0;
	    nExt = 0;
	    first = 1;
	}
	!/^#/ {
	    # command-line parameters aren't available until we're matching
	    if (first == 1) {
		# printf "splitting lists\n";
		numInt = split(static,listInt,/[, ]/)
		numExt = split(dynamic,listExt,/[, ]/)
		first = 0;
	    }
	    if ( NF >= 2 ) {
		for (i = 1; i <= numInt; i++) {
		    if ( $1 == listInt[i] || listInt[i] == "all" ) {
			# printf "nameInt[%d] = %s\n", nInt, $1
			nameInt[nInt++] = $1;
			nameAll[nAll++] = $1;
			break;
		    }
		}
		for (i = 1; i <= numExt; i++) {
		    if ( $1 == listExt[i] || listExt[i] == "all" ) {
			# printf "nameExt[%d] = %s\n", nExt, $1
			nameAll[nAll++] = $1;
			nameExt[nExt++] = $1;
			break;
		    }
		}
	    }
	}
END	{
	    if (nInt != 0 || nExt != 0) {
		print "#ifndef _builtflt_h"
		print "#define _builtflt_h 1"
		print ""
		print "#include <filters.h>"
		print ""
		if (nExt != 0) {
		    printf "/* loadable filters: %d */\n", nExt
		    for (i = 0; i < nExt; i++) {
			printf "FILTER_DEF define_%s = { \"%s\", 0, 0,0,0 };\n", nameExt[i], nameExt[i]
		    }
		    print ""
		}
		printf "/* built-in filters: %d */\n", nInt
		for (i = 0; i < nInt; i++) {
		    printf "extern FILTER_DEF define_%s;\n", nameInt[i]
		}
		print ""
		printf "/* built-in or loadable filters: %d */\n", nAll
		print "static FILTER_DEF *builtflt[] = {"
		for (i = 0; i < nAll; i++) {
		    printf "\t&define_%s,\n", nameAll[i]
		}
		print "\t0"
		print "};"
		print "#endif /* _builtflt_h */"
	    }
	}
