$
$!	BUILD11M.COM - 11M XPORT Build Procedure
$
$!	This VMS command procedure describes the process of building
$!	an XPORT Base Level for RSX-11M.  This procedure is meant to be
$!	a guide to building a base level and is not intended to be run.
$
$cms show reservations		! Verify stable XPORT source files.
$
$@clean11m			! Delete obsolete files from build area.
$
$xselect fetch "" all 11m	! Fetch all source files from STEP.
$
$submit xl16			! Create XPORT.L16 and XPOSYS.L16.
$
$copy sys$library:rsx11m.r16 *	! Capture RSX11M.R16
$copy sys$library:fcs11.r16 *	!	and FCS11.R16.
$
$bliss16 rsx11m/library		! Create local RSX11M.L16
$bliss16 fcs11/library		!	and FCS11.L16.
$
$stop				! Enter remaining commands interactively.
$
$log xl16			! Verify successful library pre-compilation
$
$submit xpo11m			! Compile XPORT source files (with debug
$submit xpo11nd			!	and without debug),
$submit str11m			!    XPORT String Handling source files
$submit str11nd			!	(with and without debug),
$submit test11m			!    all XPORT test programs,
$submit rno11m			!    and all RUNOFF CLI modules.
$
$submit xpo11n			! Compile non-EIS versions of the same files.
$submit str11n
$submit test11n
$submit rno11n
$
$log xpo11m			! Verify successful compilation.
$log xpo11nd
$log str11m
$log str11nd
$log test11m
$log rno11m
$log xpo11n
$log str11n
$log test11n
$log rno11n
$
$@olb11m			! Create and fill XPO11M.OLB (with debug),
$@olb11nd			!    XPO11M.OLB (without debug),
$@olb11n			!	and XPO11N.OLB (without debug and EIS).
$
$copy sys$library:eislib.olb *	! Copy BLISS-16 object libraries to local areas.
$copy sys$library:neislb.olb [.noeis]
$
$submit link11m			! Link all 11M test programs.
$submit link11nd
$submit link11n
$
$log link11m			! Verify successful linking.
$log link11nd
$log link11n
$
$@xporel:tests			! Copy test files from release area.
$
$@xtest				! Run all test programs with sample data.
$@xtesta
$@xtestb
$@xtestd
$@xtesto
$@xtestq
$@xtestr
$@xtests
$@stestf
$@stesti
$
$delete *.obj.*			! Delete all object files.
$
$connect [.noeis]		! Move to non-EIS test area.
$
$@xporel:tests			! Copy test files from release area.
$
$@xtest				! Run all test programs with sample data.
$@xtesta
$@xtestb
$@xtestd
$@xtesto
$@xtestq
$@xtestr
$@xtests
$@stestf
$@stesti
$
$delete *.obj.*			! Delete all object files.
$
$connect [-]			! Return to primary test area.
$
$submit xref11m			! Produce a global cross reference.
$
$@print11m			! Print groups of listings.
$
$!	11M XPORT Base Level Build Complete
$
