/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-05-14

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <pthread.h>

#include <starlet.h>
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

#include <ldap.h>

#include "lgildap.h"
#include "server.h"


pthread_mutex_t		putmsgmtx;


/*
	Description:

	This routine is invoked to print the message to SYS$OUTPUT.
	We prefix all messages with a timestamp.

	To prevent that two or more threads try to write output at
	the same time we use a mutex to serialize the write. 

	INPUT:		descriptor to message text
			private data

	OUTPUT:		0. this will prevent sys$putmsg to write the message it self.
*/

int putmsg(struct dsc$descriptor_s *msgdsc, int p) {
	time_t		t = time(NULL);

	printf("%24.24s: %*.*s\n", ctime(&t), msgdsc->dsc$w_length, msgdsc->dsc$w_length, msgdsc->dsc$a_pointer);
	fflush(stdout);

	return 0;
}


/*
	Description:

	This routine is invoked as the secondary last chance exception handler.
	As C RTL does not support the lib$establish in native alpha code we use
	this method instead to handle our private messages.

	We also specify a private routine that print the message.

	INPUT:		standard VMS signal and mechanism arrays.

	OUTPUT:		none 

	IMPLICIT:	do not generate any exception with the LLSRV messages from
			any AST routine.
*/

int exchndl(int unsigned sigargs[], int unsigned mchargs[]) {

	if (((union stsdef *)&sigargs[1])->sts$v_fac_no == (1378 + 2048)) {

		sigargs[0] -= 2;

		pthread_mutex_lock(&putmsgmtx);

		sys$putmsg(sigargs, &putmsg, 0, 0);

		pthread_mutex_unlock(&putmsgmtx);

		return SS$_CONTINUE;

	} 

	return SS$_RESIGNAL;
}


/*
	Description:

	This routine initaite the mutex used to protect the output to the log file as
	we don't want several threads using the sys$putmsg at the same time.

	INPUT:		none

	OUTPUT:		none
*/

int exception_init() {
	int		stat;

	pthread_mutex_init(&putmsgmtx, NULL);
 
	stat = sys$setexv(1, &exchndl, 0, 0);

	return stat;
}
