/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-05-14

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <pthread.h>

#include <starlet.h>
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

#include <lib$routines.h>
#include <libdef.h>

#include <ldap.h>

#include "lgildap.h"
#include "server.h"


int unsigned		freesessqh[4] = { 0, 0, 0, 0 };
int unsigned		icchndl;


/*
	Description:

	This routine is invoked for new ICC connections.
	It will remove a free session structure, save the pid and connection handler.
	Insert the session handlerinto the new session queue and wake up main thread.

	Should there be no free session handlers the connection is rejected.

	INPUT:		type of event
			ICC connection handler
			buffer for connect message
			length of connect message
			availability
			PID of client
			username of client

	OUTPUT:		none
*/ 

void conn_ast(int type, int unsigned conn, void *buf, int unsigned len, int avail, int pid, char *username) {
	int		stat;
	LGI_SESS_T	*sess = remove_qh(&freesessqh);

	if (sess != NULL) {

		sess->pid = pid;
		sess->conn = conn;

		if (insert_qt(&newsessqh, sess) == LIB$_ONEENTQUE) {

			pthread_cond_signal_int_np(&sesscnd);

		}

	} else { /* no free new sessions. the process is overloaded so reject the connect attempt */

		stat = sys$icc_reject(conn, 0, 0, 0);

	}
}


/*
	Description:

	This routine is invoked when an established ICC session disconnect.
	The only thing this routine does is to insert the entry into the deletion queue
	and wake up main thread.

	INPUT:		type of event
			ICC connection handler
			buffer for disconnect message
			length of disconnect message
			reason for disconnect
			session handler

	OUTPUT:		none
*/

void disc_ast(int type, int unsigned conn, void *buf, int unsigned len, int reason, LGI_SESS_T *sess) {

	if (sess != NULL && sess->flags.accepted) {

		if (insert_qt(&delsessqh, sess) == LIB$_ONEENTQUE) {

			pthread_cond_signal_int_np(&sesscnd);

		}
	}
}


/*
	Description:

	This routine is invoked when an establised ICC session receives data.
	Only a condition variable for the session is set to wake up sess ion thread.

	INPUT:		size of waiting message
			ICC connection handler
			session handler

	OUTPUT:		none
*/

void recv_ast(int unsigned msgsize, int unsigned connhndl, LGI_SESS_T *sess) {
	int		stat;

	if (sess != NULL) {

		pthread_cond_signal_int_np(&sess->cndle);

	}
}


/*
	Description:

	This routine initiate the queue of free session handlers and open an association
	for the ICC on the local node.

	INPUT:		none

	OUTPUT:		SS$_NORMAL
			The program will terminate if the icc_open_assoc fail.
*/

int icc_init() {
	int			stat;
	$DESCRIPTOR(assnamdsc, "LGI_LDAP");
	$DESCRIPTOR(logtbldsc, "ICC$REGISTRY");

	init_q(&freesessqh, sizeof(LGI_SESS_T), 1024); /* create 1024 free session handlers */

	if (!$VMS_STATUS_SUCCESS(stat = sys$icc_open_assoc(&icchndl, &assnamdsc, &assnamdsc, &logtbldsc,
							   &conn_ast, &disc_ast, &recv_ast, 2, 1))) {

		lib$stop(stat);

	}

	return stat;
}
