/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-05-14

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include	<string.h>

#include 	<starlet.h>
#include	<ssdef.h>
#include	<stsdef.h>
#include	<descrip.h>

#include	<lib$routines.h>
#include	<tpadef.h>


int		timeparsetbl;
int		timeparsekwt;


typedef	struct tpaarg_s {
	struct tpadef		tpa;
	int unsigned		*abstime;
} TPAARG_T;


/*
	Description:

	This routine is invoked for time NOW.

	INPUT:		TPA argument

	OUTPUT:		TPA argument abstime get a current time
*/

int save_now(TPAARG_T *tpa) {

	return sys$gettim(tpa->abstime);

}


/*
	Description:

	This routine is invoked for time TOMORROW.

	INPUT:		TPA argument

	OUTPUT:		TPA argument abstime get the time for tomorrow.
*/

int save_tomorrow(TPAARG_T *tpa) {
	$DESCRIPTOR(tomorrowdsc, "TOMORROW");

	return lib$convert_date_string(&tomorrowdsc, tpa->abstime, 0, 0, 0, 0);

}


/*
	Description:

	This routine is invoked to validate the hour, minute, second and fraction
	values.

	INPUT:		TPA argument

	OUTPUT:		SS$_NORMAL if the value is invalid range
			SS$_IVTIME if the value is outside the valid range
*/

int check_num_value(TPAARG_T *tpa) {

	return (tpa->tpa.tpa$l_number <= tpa->tpa.tpa$l_param ? SS$_NORMAL : SS$_IVTIME);

}


/*
	Description:

	This routine is invoked to save the delta time and and it to the
	absolute time, NOW or TOMORROW.

	INPUT:		TPA argument

	OUTPUT:		TPA argument abstime is added with the delta time.
*/

int save_delta_time(TPAARG_T *tpa) {
	int		stat;
	int unsigned	deltatime[2];
	char		dummy[1];
	$DESCRIPTOR(timdsc, dummy);

	timdsc.dsc$a_pointer = (void *)(tpa->tpa.tpa$l_tokenptr);
	timdsc.dsc$w_length = tpa->tpa.tpa$l_tokencnt;

	if ($VMS_STATUS_SUCCESS(stat = sys$bintim(&timdsc, &deltatime))) {

		stat = lib$add_times(tpa->abstime, &deltatime, tpa->abstime);

	}

	return stat;
}


/*
	Description:

	This routine parse the logical name LGI_LDAP_REMOVE_USER_RUN for valid syntax
	and calculate the next run time.

	INPUT:		run time as text string

	OUTPUT:		abstime for next run time
*/

int parse_run_time(char *runtime, int unsigned abstime[]) {
	int			stat;
	TPAARG_T		tpa;

	memset(&tpa, 0, sizeof(tpa));

	tpa.tpa.tpa$l_count = sizeof(tpa) / 4;
	tpa.tpa.tpa$l_stringptr = (int unsigned)runtime;
	tpa.tpa.tpa$l_stringcnt = strlen(runtime);
	tpa.abstime = abstime;

	return lib$table_parse(&tpa, &timeparsetbl, &timeparsekwt);
}
