
#define	MAX_THREADS	8
#define	SSL_PORT	44667

#define	LCK_SYSUAF	0
#define	LCK_MAX_INDEX	1

#define	EFN_AUDIT	1
#define	EFN_ACTRTN	2
#define	EFN_AUDEVN	3
#define	EFN_DCLCMD	4
#define	EFN_ENQ		5
#define	EFN_REMTHR	6
#define	EFN_UPDUSRPWD	7
#define	EFN_SAVPWD	8

#define	LDAP_FILTER	"(&(objectclass=posixAccount)(uid=%s))"

#define	MIN(a, b)	( a < b ? a : b)
#define	MAX(a, b)	( a > b ? a : b)

#if LDAP_API_VERSION > 2004
#define	LDAP_LOCK	pthread_mutex_lock(&ldapmtx);
#else
#define	LDAP_LOCK
#endif

#if LDAP_API_VERSION > 2004
#define	LDAP_UNLOCK	pthread_mutex_unlock(&ldapmtx);
#else
#define	LDAP_UNLOCK
#endif

/*
	Define new UAF flag PWDMIX so we can compile this on hosts with
	OpenVMS version prior to 7.3-2
*/

#ifndef	UAI$M_PWDMIX
#define	UAI$M_PWDMIX	0x2000000
#endif

/*
	Define version of OpenVMS that support PWDMIX flag.
*/

#define	PWDMIX_SUPPORT	070302


typedef struct lim_entry_s {
	int unsigned		qhdr[4]; /* queue header */
	int unsigned		iosb[4]; /* iosb for ICC receive */
	LGI_IPC_MSG		lim;
} LIM_ENTRY_T;


typedef struct data_queue_s {
	int unsigned    qh[4]; /* queue header 16 bytes */
	int             len;
	char unsigned   *data;
} DQ_T;


typedef struct lgi_sess_s {
	int unsigned		qhdr[4];    /* queue header */
	int unsigned		icciosb[6]; /* iosb for icc */
	int unsigned		conn;
	LDAP			*ldap;
	char			*dn;
	pthread_t		thr;
	pthread_cond_t		cndle;
	pthread_mutex_t		mtxle;
	pthread_cond_t		cndw;
	pthread_mutex_t		mtxw;
	int			jobtype;
	int unsigned		pid;
	char			identity[256];
	struct {
		int unsigned	accepted:1;	/* connection is accepted */
		int unsigned	running:1;	/* session is running */
		int unsigned	finish:1;	/* lock was granted -> finish the thread */
		int unsigned	identityok:1;	/* identity is ok */
		int unsigned	credentialok:1;	/* credential is ok */
		int unsigned	condok:1;       /* condition is done */
	} flags;
} LGI_SESS_T;


typedef struct prcidx_s {
	int unsigned		prcidx;
	int unsigned		pid;
	LGI_SESS_T		*sess;
} PRCIDX_T;


typedef struct exhblk_s {
	int unsigned		frwlnk;
	void			*exhadr;
	int unsigned		argcnt;
	int unsigned		*cndadr;
} EXHBLK_T;



void *ssl_thr(void *s);
int setup_SSLConnection(LGI_SESS_T *sess);

void *safe_malloc(int size);
void safe_free(void *p);
int util_init();

int ssl_init();
int exception_init();
int icc_init();
int uaf_init();

int thread_cmd_identity(LGI_SESS_T *sess, LIM_ENTRY_T *le);
int thread_cmd_authenticate(LGI_SESS_T *sess, LIM_ENTRY_T *le);
int thread_cmd_password(LGI_SESS_T *sess, LIM_ENTRY_T *le);

int verify_username(LGI_SESS_T *sess, char *identity, int create);
int synch_password(LGI_SESS_T *sess, char *credential);

void *alloc_qe(int size);
void free_qe(int size, void *qe);
int insert_qt(void *hdr, void *ent);
int insert_qh(void *hdr, void *ent);
void *remove_qt(void *qhd);
void *remove_qh(void *qhd);
void *get_free_qe(void *qhd, int size);
void init_q(void *qhd, int size, int cnt);
void create_vmzone();
int translate_unix2vms(char *unixdir, char *defdev, int defdevlen, char *devdir, int defdirlen);
LDAP *open_ldap();
int parse_run_time(char *runtime, int unsigned abstime[]);
void lock_cluster_ex(int id);
void lock_cluster_cr(int id);
void unlock_cluster(int id);
void generate_random(char unsigned *rnddata, int rndsize);
void SHA1_hash(char *data, char unsigned *md);
void b64_encode(char *out, char *in, int unsigned len);
int do_dcl_command(char *cmd);
int get_filter(char *search, int searchlen, char *uid);
void cond_wake_ast(pthread_cond_t *cndw);
int do_action(char *actrtn, int timeout, ...);

globalvalue int	LLSRV_LDAPHOSTMISS,
		LLSRV_LDAPBASEDNMISS,
		LLSRV_SRVALREADYRUN,
		LLSRV_INVPRCIDX,
		LLSRV_INVRECEIVER,
		LLSRV_INVLOGIN,
		LLSRV_LDAPINITFAIL,
		LLSRV_LDAPANONBINDFAIL,
		LLSRV_LDAPSETVERS,
		LLSRV_ENQFAIL,
		LLSRV_MBXASSFAIL,
		LLSRV_INVPARAM,
		LLSRV_GETJPIFAIL,
		LLSRV_INVCMD,
		LLSRV_INVREQ,
		LLSRV_MEMALLOCFAIL,
		LLSRV_SSLSETFD,
		LLSRV_SSLSOCKNBIO,
		LLSRV_SSLCONN,
		LLSRV_SSLSOCK,
		LLSRV_SSLTHRSTARTED,
		LLSRV_SSLCONNFAIL,
		LLSRV_SSLLOADED,
		LLSRV_SSLCTXFAIL,
		LLSRV_SSLMETHFAIL,
		LLSRV_SSLLISTSOCK,
		LLSRV_SSLLISTOPT,
		LLSRV_SSLLISTBIND,
		LLSRV_SSLLISTLIST,
		LLSRV_PRCTHRCRE,
		LLSRV_PRCTHREND,
		LLSRV_MODUSERCMDERR,
		LLSRV_ADDUSERCMDERR,
		LLSRV_ADDUSERERR,
		LLSRV_ADDUSER,
		LLSRV_UAFMODTHR,
		LLSRV_UAFREMTHR,
		LLSRV_LDAPCONNERR,
		LLSRV_LDAPCONN,
		LLSRV_LDAPUSERMISS,
		LLSRV_LDAPUSEREXIST,
		LLSRV_INVVALUE,
		LLSRV_REMTERM,
		LLSRV_INVREMTIM,
		LLSRV_REMUSRRUN,
		LLSRV_REMUSRDONE,
		LLSRV_ERRACCSYSUAF,
		LLSRV_THRSTARTED,
		LLSRV_SSLOADERR,
		LLSRV_NOSSLCONT,
		LLSRV_PWDCLEAR,
		LLSRV_NOSSL,
		LLSRV_NOSUCHUSER,
		LLSRV_INVCRED,
		LLSRV_PWDUPD,
		LLSRV_ERRENAUDIT,
		LLSRV_ERRDAUDIT,
		LLSRV_NOPWDSYNCH,
		LLSRV_PWDUPDFAIL,
		LLSRV_PWDUPDNODN,
		LLSRV_DISAUDLIST,
		LLSRV_INVFILSTR,
		LLSRV_DEFUSER,
		LLSRV_UIDTOOLONG,
		LLSRV_INTERRLCK,
		LLSRV_LDAPERR;


globalvalue int	timecld;



int unsigned		freesessqh[4];
int unsigned		newsessqh[4];
int unsigned		delsessqh[4];
int unsigned		msgsessqh[4];
int unsigned		waitsessqh[4];

pthread_mutex_t		ldapmtx;
pthread_mutex_t		sessmtx;
pthread_cond_t		sesscnd;

int			use_ssl;
int			osvers;
