/*****************************************************************************/
/*
                                W A R N I N G 

             THIS IS A QUICK-AND-DIRTY HACK OF THE ORIGINAL MKSTRIP
            made in a few minutes just to provide this functionality
                                for VMS users
*/
/*****************************************************************************/
/*
 *  mkstrip - program to make a image strip out of several gif images
 *
 *  RCS:
 *      $Revision$
 *      $Date$
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      This program keeps info about the strips in the GIF comment
 *      extension, which is used by the counter program.
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   18-Mar-96   first cut
 */


#include "combine.h"
#include "count.h"
#include "errno.h"
#include "stdlib.h"
#include "stdio.h"

void Usage _Declare ((void));
void Debug _Declare ((char *));
void MakeStripImage _Declare ((char **,int,char*));

char
    *progname;

/* just provide a stub so that the image will link (MGD) */
int CgiLibEnvironmentIsOsu () { return (0); }

#define MKSTRIP_VERSION "1.0-mgd1"
#define DEBUG   1

int main (int argc, char **argv)

{
#define MAX_FILE_NAMES 256

   int  nameCount,
        nameLength;
   char  *cptr;
   char  *nameArray [MAX_FILE_NAMES];
   char  fileName [256];
   FILE  *nameFile;

   if (argc <= 2) Usage ();

   if ((nameFile = fopen (argv[1], "r")) == NULL) exit (vaxc$errno);
   nameCount = 0;
   while (fgets (fileName, sizeof(fileName), nameFile) != NULL)
   {
      if ((cptr = strchr (fileName, '\n')) != NULL) *cptr = '\0';
      if (!fileName[0]) continue;
      nameCount++;
      if (nameCount >= MAX_FILE_NAMES) break;
      nameLength = strlen (fileName);
      nameArray[nameCount] = cptr = malloc (nameLength+1);
      strcpy (cptr, fileName);
   }
   fclose (nameFile);

   if (nameCount++ == 0) exit (0);
   nameArray[0] = argv[0];

   MakeStripImage (&nameArray, nameCount, argv[2]);
   return (0);
}

void Usage()
{
    (void) fprintf (stderr,"mkstrip Version %s\n\n", MKSTRIP_VERSION);
    (void) fprintf (stderr,
        "VMS Usage: %s <file-name-list>.TXT <output-file-name>.GIF \n\n",
        "mkstrip");
    exit(1);
}

void Debug(str)
char
    *str;
{
#ifdef DEBUG
    (void) fprintf (stderr,"%s\n",str);
#endif
    return;
}

void MakeStripImage(files,n,outFile)
char
    **files;
int
    n;
char
    *outFile;
{
    int
        i;
    
    int
        rc;

    unsigned int
        w,
        h,
        bw,
        bh;

    Image
        *base_image,
        *sub_image;

    int
        do_comment,
        count,
        segment;

    w=h=bw=bh=0;
    count=0;
    segment=0;
    do_comment=0;

    for (i=1; i < n; i++)
    {
        rc=GetGIFsize(files[i],&w,&h);
        if (rc)
        {
            (void) fprintf (stderr,
                " Unable to determine digit image size for: %s\n",files[i]);
            exit(1);
        }
        bw += w;
        if (h > bh)
            bh=h;
    }


    base_image=CreateBaseImage (bw,bh,0,0,0,DirectClass);
    /*
    ** add comment to the image. this is important. we will determine
    ** the number of digit images by reading it
    */
    base_image->comments=(char *) malloc(100*sizeof(char));
    if (base_image != (Image *) NULL)
        do_comment=1;

    if (do_comment == 1)
    {
        (void) sprintf(base_image->comments,"%d",(n-1));
    }
    if (base_image == (Image *) NULL)
    {
        (void) fprintf (stderr," Unable to create base image!\n");
        exit(1);
    }

    bw=bh=0;
    for (i=1; i < n; i++)
    {
        sub_image=ReadImage(files[i]);
        if (sub_image != (Image *) NULL)
        {
            FlattenImage(base_image,sub_image,ReplaceCompositeOp,bw,0);
            if (do_comment == 1)
                (void) sprintf(base_image->comments,
                     "%s:%d",base_image->comments,bw);
            bw += sub_image->columns;
            DestroyAnyImageStruct(&sub_image);
        }
        else
        {
            (void) fprintf (stderr,"Failed to create image strip!\n");
            exit(1);
        }
    }
    if (do_comment == 1)
       (void) sprintf(base_image->comments,
             "%s:%d",base_image->comments,bw);

    WriteGIFImage(base_image,outFile);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 