1 REM Solar System Simulator 2.0 Standard 8086. Copyright (c) 2002 Bla Valek.
2 REM e-mail: bvalek2@ttk.pte.hu
3 REM         bvalek2@gamma.ttk.pte.hu
4
5 REM This program shows a shematic real-time representation of the Solar
6 REM System. The planets, the greater moons, and every planets's and moons's
7 REM orbits are displayed. Their positions are dynamic. In the menu system you
8 REM have many ways to control your computer. The program displays the Date,
9 REM Time, Timer infos, the Julian Date, and the Moon's Phase too.
10
11 REM This program is free software; you can redistribute it and/or modify
12 REM it under the terms of the GNU General Public License as published by
13 REM the Free Software Foundation; version 2 of the License.
14
15 REM This program is distributed in the hope that it will be useful,
16 REM but WITHOUT ANY WARRANTY; without even the implied warranty of
17 REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
18 REM GNU General Public License for more details.
19
20 REM You should have received a copy of the GNU General Public License
21 REM along with this program; if not, write to the Free Software
22 REM Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
23
24 REM If you have problems with the program, it displays invalid data or
25 REM graphics, or you start SolarDyn with ERROR option, and you get a
26 REM SOLARDYN.ERR report file, then please send it, and your opinion to the
27 REM given e-mail addresses. Thanks.
28
29 REM The line numbers were added later, to support the error reporting file.
30 REM If you see something in the code that seemingly has no purpose, believe
31 REM me, it has very much.  Some of them prevents your graphical system from
32 REM breaking down or drawing garbage.  I do not know how, but it works. The
33 REM routines are optimized for 640x480 VGA color.
34
35 REM Original note to the processor detection part:
36 '*************************************************************************
37 '
38 '  PBCPU.BAS:  Determine the CPU type in PowerBASIC 3.0/3.2
39 '
40 '  Developed by       Thomas Gohel  Fido:      2:2410/301.12
41 '  Version: 1.01                InterNet:  author@pbsound.snafu.de
42 '  Stand  : 02.03.1996          Homepage:  http://www.snafu.de/~pbsound/
43 '
44 '  unter Verwendung einiger Sourcen aus dem Jahre 1994 aus der ASM86.GER
45 '
46 ' --------------------------------------------------------------------------
47
48 ' Description: The program starts at status Prozessor = 8086, and
49 ' checks whether the statusregister-bits can be set to the next
50 ' available processortype.
51 ' At the recognition of the CPUID-command, the processortype
52 ' is established from the family description.
53 ' Newer processor will support this command, as well as future
54 ' processor generations.
55
56 '     Meaning of Prozessor?:
57 '     0   = 8086/8088
58 '     1   = 80186
59 '     2   = 80286
60 '     3   = 80386
61 '     4   = 80486
62 '     5   = 80586 (Pentium)
63 '     6   = 80686 (Pentium Pro)
64 '     7   = Next CPU-Generation :-))
65 '     255 = V20/V30
66 '
67 '***************************************************************************
68 '*************************************************************************
69
70 '        The german PowerBASIC-FAQ - order: faq@pbsound.snafu.de
71 '   PowerBASIC/PBSOUND-HomePage, GERMANY: http://www.snafu.de/~pbsound/
72 '              !!!! english version: under construction !!!!
73 REM End of original note.
74 REM I made some minimal modifications on the code. I cannot program such
75 REM things in assembly, so they are not significant. I changed the output
76 REM text, in case of the processor is Pentium Pro or above, and some variable
77 REM names and label names are modified.
78
79 $COMPILE EXE
80 $CPU 8086
81 $FLOAT EMULATE
82 $LIB COM OFF, LPT OFF, IPRINT OFF, FULLFLOAT OFF, GRAPH ON
83 $OPTION CNTLBREAK OFF, GOSUB OFF, SIGNED OFF
84 $ERROR ALL OFF
85 $DIM ARRAY
86 $COM 0
87 $SOUND 0
88 $STRING 1
89 $STACK 2048
90 $OPTIMIZE SPEED
91
92 DECLARE FUNCTION cpu$ ()
93
94 SELECT CASE UCASE$(TRIM$(COMMAND$))
95 CASE "VER": PRINT "Solar System Simulator 2.0 Standard 8086": END
96 CASE "MONO": mono% = 1: COLOR 7, 0
97 CASE "ERROR": enableerr% = 1: ON ERROR GOTO handler
98 CASE "DATE": PRINT DATE$: END
99 CASE "TIME": PRINT TIME$: END
100 CASE "TIMER": PRINT TIMER: END
101 CASE "HELP", "?"
102 PRINT "command line options:"
103 PRINT "    VER  : display version"
104 PRINT "    MONO : disable color menu"
105 PRINT "    DATE : display Date"
106 PRINT "    TIME : display Time"
107 PRINT "    TIMER: display Timer"
108 PRINT "    HELP : display help": END
109 END SELECT
110
111 DIM mainmenu$(1 TO 9)
112 mainmenu$(1) = "Start Simulator"
113 mainmenu$(2) = "Select Screen Mode"
114 mainmenu$(3) = "System Information"
115 mainmenu$(4) = "Set Refresh Rate"
116 mainmenu$(5) = "Set Timezone"
117 mainmenu$(6) = "View Timezones"
118 mainmenu$(7) = "DOS Shell"
119 mainmenu$(8) = "Test Internal Speaker"
120 mainmenu$(9) = "Exit Program"
121 DIM selectmenu$(1 TO 10)
122 selectmenu$(1) = "Auto Detection"
123 selectmenu$(2) = "320x200 CGA"           '1
124 selectmenu$(3) = "640x200 CGA"           '2
125 selectmenu$(4) = "320x200 EGA"           '7
126 selectmenu$(5) = "640x200 EGA"           '8
127 selectmenu$(6) = "640x350 EGA color"     '9
128 selectmenu$(7) = "640x200 EGA mono"      '10
129 selectmenu$(8) = "640x480 VGA/MCGA mono" '11
130 selectmenu$(9) = "640x480 VGA color"     '12
131 selectmenu$(10) = "Exit to Main Menu"
132 DIM Low AS BYTE
133 DIM High AS BYTE
134 DIM rand#(0 TO 99, 1)
135
136 selectedmode$ = selectmenu$(1)
137 pointer% = 1
138 selpoint% = 1
139 freshrate# = 5
140 sys% = 0
141
142 start:
143 SCREEN 0
144 WIDTH "SCRN:", 80
145 CLS
146 IF mono% = 0 THEN COLOR 10, 0
147 LOCATE 4, 18: PRINT "S o l a r   S y s t e m   S i m u l a t o r"
148 LOCATE 5, 17: PRINT STRING$(45, 223)
149 IF mono% = 0 THEN COLOR 12, 0
150 LOCATE 6, 31: PRINT "- D y n a m i c -"
151 IF mono% = 0 THEN COLOR 11, 0
152 LOCATE 9, 23: PRINT "Copyright (c) 2002 by Bla Valek"
153 LOCATE 11, 25: PRINT "e-mail: bvalek2@ttk.pte.hu"
154 LOCATE 12, 33: PRINT "bvalek2@gamma.ttk.pte.hu"
155 LOCATE 14, 18: PRINT "CPU detection original author: Thomas Gohel"
156 LOCATE 16, 22: PRINT "Created on PowerBASIC for DOS 3.50"
157 LOCATE 18, 28: PRINT "Made in Hungary, Pcs"
158 LOCATE 20, 29: PRINT "03-19-2002   20:00"
159 IF mono% = 0 THEN COLOR 7, 0
160 IF ende% = 0 THEN
161     LOCATE 23, 27: PRINT "Reading files..."
162     IF DIR$("WINDOW.DAT") = "WINDOW.DAT" THEN
163         ON ERROR RESUME NEXT
164         OPEN "WINDOW.DAT" FOR INPUT AS #1   'previous window
165             INPUT #1, a#
166             INPUT #1, b#
167             INPUT #1, c#
168             INPUT #1, d#
169         CLOSE #1
170         pberrcode% = ERRTEST
171         IF enableerr% = 0 THEN
172             ON ERROR GOTO 0
173         ELSE
174             ON ERROR GOTO handler
175         END IF
176     ELSE
177         a# = -40000   'default window
178         b# = -30000
179         c# = 40000
180         d# = 30000
181     END IF
182     IF pberrcode% = 0 THEN
183     ELSE
184         a# = -40000   'default window
185         b# = -30000
186         c# = 40000
187         d# = 30000
188     END IF
189     pberrcode% = 0
190     IF DIR$("TIMEZONE.CFG") = "TIMEZONE.CFG" THEN
191         ON ERROR RESUME NEXT
192         OPEN "TIMEZONE.CFG" FOR INPUT AS #1   'get timezone
193             INPUT #1, hour!
194             INPUT #1, minu!
195         CLOSE #1
196         pberrcode% = ERRTEST
197         IF enableerr% = 0 THEN
198             ON ERROR GOTO 0
199         ELSE
200             ON ERROR GOTO handler
201         END IF
202     ELSE
203         hour! = 1   'default timezone (CET)
204         minu! = 0
205     END IF
206     IF pberrcode% = 0 THEN
207     ELSE
208         hour! = 1   'default timezone (CET)
209         minu! = 0
210     END IF
211     pberrcode% = 0
212     LOCATE 23, 27: PRINT "Press any key to continue"
213     IF INPUT$(1) = "" THEN
214     END IF
215 ELSE
216     IF visit% = 1 THEN
217         LOCATE 23, 27: PRINT "Writing files..."
218         OPEN "WINDOW.DAT" FOR OUTPUT AS #1   'last window
219             PRINT #1, a#
220             PRINT #1, b#
221             PRINT #1, c#
222             PRINT #1, d#
223         CLOSE #1
224     END IF
225     LOCATE 23, 27: PRINT "Press any key to exit"
226     IF INPUT$(1) = "" THEN
227     END IF
228     END   'end of program
229 END IF
230
231 supermen:
232 supermenu% = 1
233 CLS
234 IF mono% = 0 THEN
235     COLOR 11, 0
236 ELSE
237     COLOR 7, 0
238 END IF
239 LOCATE 5, 2: PRINT "Date:"
240 LOCATE 7, 2: PRINT "Time:"
241 LOCATE 9, 2: PRINT "Timer:"
242 LOCATE 11, 2: PRINT "Julian Date:"
243 LOCATE 13, 2: PRINT "Moon's Phase:"; TAB(33); "%"
244 IF mono% = 0 THEN COLOR 10, 0
245 LOCATE 19, 2: PRINT "Simulator Screen Mode:"
246 IF mono% = 0 THEN COLOR 7, 0
247 LOCATE 23, 1: PRINT "Arrows select, <ENTER> accept"
248
249 DO
250 IF mono% = 0 THEN COLOR 11, 0
251 inci$ = INKEY$
252 year# = VAL(RIGHT$(DATE$, 4))
253 month# = VAL(LEFT$(DATE$, 2))
254 day# = VAL(MID$(DATE$, 4, 2))
255 timezone# = minu! / 60 + hour!
256 UT# = (TIMER - timezone# * 3600) / 86400
257 JD# = 367 * year# - INT(7 * (year# + INT((month# + 9) / 12)) / 4) - INT(3 * (INT((year# + (month# - 9) / 7) / 100) + 1) / 4) + INT(275 * month# / 9) + day# + 1721028.5# + UT#
258 LOCATE 5, 16: PRINT DATE$;
259 LOCATE 7, 16: PRINT TIME$;
260 LOCATE 9, 15: PRINT TIMER;
261 LOCATE 11, 15: PRINT JD#;
262 LOCATE 13, 15
263 IF INT((JD# - 2452303.451388889#) / 29.53059 * 2) \ 2 = INT((JD# - 2452303.451388889#) / 29.53059 * 2) / 2 THEN
264     PRINT ABS(100 * FRAC((JD# - 2452303.451388889#) / 29.53059 * 2) - 100);
265 ELSE
266     PRINT ABS(100 * FRAC((JD# - 2452303.451388889#) / 29.53059 * 2));
267 END IF
268 IF mono% = 0 THEN COLOR 10, 0
269 LOCATE 21, 2: PRINT selectedmode$
270 SELECT CASE supermenu%
271 CASE 0: GOTO supermen
272 CASE 1: GOSUB mainmen
273 CASE 2: GOSUB simulator
274 CASE 3: GOSUB selector
275 CASE 4
276 IF sys% = 0 THEN GOSUB sissy
277 GOSUB sysinfo
278 CASE 5: GOSUB timzon
279 CASE 6: GOSUB viewtim
280 CASE 7: GOSUB dosshell
281 CASE 8: GOSUB fresh
282 END SELECT
283 LOOP
284 ende% = 1
285 GOTO start
286
287 dosshell:
288 COLOR 7, 0
289 CLS
290 PRINT "Type EXIT to return to Solar System Simulator..."
291 SHELL
292 supermenu% = 0
293 RETURN
294
295 fresh:
296 IF mono% = 0 THEN COLOR 10, 0
297 CLS
298 LOCATE 1, 26: PRINT "S e t   R e f r e s h   R a t e"
299 LOCATE 2, 25: PRINT STRING$(33, 223)
300 IF mono% = 0 THEN COLOR 14, 0
301 DO
302 LOCATE 7, 1: INPUT " Enter refresh rate in seconds(0.054 - 43200): ", freshrate#
303 IF freshrate# >= .054 AND freshrate# <= 43200 THEN EXIT LOOP
304 LOCATE 7, 44: PRINT SPACE$(30);
305 LOOP
306 supermenu% = 0
307 RETURN
308
309 eraser:
310 IF mono% = 0 THEN COLOR 7, 0
311 FOR col% = 41 TO 79
312 FOR row% = 5 TO 23
313 LOCATE row%, col%: PRINT CHR$(32);
314 NEXT row%
315 NEXT col%
316 LOCATE 1, 5: PRINT SPACE$(70)
317 LOCATE 2, 5: PRINT SPACE$(70)
318 RETURN
319
320 mainmen:
321 IF mono% = 0 THEN COLOR 10
322 LOCATE 1, 32: PRINT "M a i n   M e n u"
323 LOCATE 2, 31: PRINT STRING$(19, 223)
324 SELECT CASE inci$
325 CASE CHR$(0) + "H": pointer% = pointer% - 1
326 CASE CHR$(0) + "P": pointer% = pointer% + 1
327 CASE CHR$(0) + "K": pointer% = pointer% - 1
328 CASE CHR$(0) + "M": pointer% = pointer% + 1
329 CASE CHR$(0) + "G": pointer% = 1
330 CASE CHR$(0) + "O": pointer% = 9
331 CASE CHR$(0) + "I": pointer% = 1
332 CASE CHR$(0) + "Q": pointer% = 9
333 CASE CHR$(13)
334     SELECT CASE pointer%
335     CASE 1: supermenu% = 2
336     CASE 2: supermenu% = 3: pointer% = selpoint%: eraserer% = 1: GOTO forward
337     CASE 3: supermenu% = 4
338     CASE 4: supermenu% = 8
339     CASE 5: supermenu% = 5
340     CASE 6: supermenu% = 6
341     CASE 7: supermenu% = 7
342     CASE 8: BEEP: GOTO forward
343     CASE 9: ende% = 1: GOTO start
344     END SELECT
345     eraserer% = 1
346 CASE CHR$(27): ende% = 1: GOTO start
347 END SELECT
348 IF pointer% < 1 THEN pointer% = 9
349 IF pointer% > 9 THEN pointer% = 1
350 FOR yy% = 1 TO 9
351     co% = 0
352     IF yy% = pointer% THEN co% = 9
353     IF mono% = 0 THEN
354         COLOR 14, co%
355     ELSE
356         COLOR 7, 0
357     END IF
358     IF yy% = pointer% AND mono% = 1 THEN COLOR 0, 7
359     LOCATE 3 + 2 * yy%, 41: PRINT mainmenu$(yy%)
360 NEXT yy%
361 forward:
362 IF mono% = 1 THEN COLOR 7, 0
363 IF eraserer% = 1 THEN
364     GOSUB eraser
365     eraserer% = 0
366 END IF
367 RETURN
368
369 selector:
370 IF mono% = 0 THEN COLOR 10
371 LOCATE 1, 22: PRINT "S e l e c t   S c r e e n   M o d e"
372 LOCATE 2, 21: PRINT STRING$(37, 223)
373 SELECT CASE inci$
374 CASE CHR$(0) + "H": pointer% = pointer% - 1
375 CASE CHR$(0) + "P": pointer% = pointer% + 1
376 CASE CHR$(0) + "K": pointer% = pointer% - 1
377 CASE CHR$(0) + "M": pointer% = pointer% + 1
378 CASE CHR$(0) + "G": pointer% = 1
379 CASE CHR$(0) + "O": pointer% = 10
380 CASE CHR$(0) + "I": pointer% = 1
381 CASE CHR$(0) + "Q": pointer% = 10
382 CASE CHR$(13)
383     SELECT CASE pointer%
384     CASE 1: scrnmode% = 0
385     CASE 2: scrnmode% = 1
386     CASE 3: scrnmode% = 2
387     CASE 4: scrnmode% = 7
388     CASE 5: scrnmode% = 8
389     CASE 6: scrnmode% = 9
390     CASE 7: scrnmode% = 10
391     CASE 8: scrnmode% = 11
392     CASE 9: scrnmode% = 12
393     END SELECT
394     IF pointer% < 10 THEN selectedmode$ = selectmenu$(pointer%)
395     supermenu% = 1
396     eraserer% = 1
397     LOCATE 21, 1: PRINT SPACE$(30)
398 CASE CHR$(27)
399     supermenu% = 1
400     eraserer% = 1
401 END SELECT
402 IF pointer% < 1 THEN pointer% = 10
403 IF pointer% > 10 THEN pointer% = 1
404 FOR yy% = 1 TO 10
405     co% = 0
406     IF yy% = pointer% THEN co% = 9
407     IF mono% = 0 THEN
408         COLOR 14, co%
409     ELSE
410         COLOR 7, 0
411     END IF
412     IF yy% = pointer% AND mono% = 1 THEN COLOR 0, 7
413     LOCATE 3 + 2 * yy%, 41: PRINT selectmenu$(yy%)
414 NEXT yy%
415 IF mono% = 1 THEN COLOR 7, 0
416 IF eraserer% = 1 THEN
417     GOSUB eraser
418     selpoint% = pointer%
419     pointer% = 2
420     eraserer% = 0
421 END IF
422 RETURN
423
424 sissy:
425 sys% = 1
426 IF mono% = 0 THEN COLOR 7, 0
427 LOCATE 23, 1: PRINT "Press any key to continue    "
428 IF mono% = 0 THEN COLOR 10, 0
429 LOCATE 1, 22: PRINT "S y s t e m   I n f o r m a t i o n"
430 LOCATE 2, 21: PRINT STRING$(37, 223)
431 IF mono% = 0 THEN COLOR 14, 0
432 LOCATE 5, 41: PRINT "Videocard: ";
433 SELECT CASE pbvScrnCard
434 CASE 0: PRINT "Not found"
435 CASE ELSE
436 IF BIT(pbvScrnCard, 0) = 0 THEN
437     IF BIT(pbvScrnCard, 5) = 1 THEN
438         PRINT "VGA color"
439     ELSEIF BIT(pbvScrnCard, 3) = 1 THEN
440         PRINT "EGA color"
441     ELSEIF BIT(pbvScrnCard, 2) = 1 THEN
442         PRINT "EGA color"
443     ELSEIF BIT(pbvScrnCard, 1) = 1 THEN
444         PRINT "CGA color"
445     ELSEIF BIT(pbvScrnCard, 6) = 1 THEN
446         PRINT "Hercules color"
447     ELSE
448         PRINT "Unknown"
449     END IF
450 ELSE
451     IF BIT(pbvScrnCard, 5) = 1 THEN
452         PRINT "VGA mono"
453     ELSEIF BIT(pbvScrnCard, 3) = 1 THEN
454         PRINT "EGA mono"
455     ELSEIF BIT(pbvScrnCard, 2) = 1 THEN
456         PRINT "EGA mono"
457     ELSEIF BIT(pbvScrnCard, 1) = 1 THEN
458         PRINT "CGA mono"
459     ELSEIF BIT(pbvScrnCard, 6) = 1 THEN
460         PRINT "Hercules mono"
461     ELSE
462         PRINT "Unknown"
463     END IF
464 END IF
465 END SELECT
466 LOCATE 7, 41: PRINT "Processor: "; cpu$
467 LOCATE 9, 41: PRINT "Coprocessor: ";
468 SELECT CASE pbvNpx
469 CASE 0: PRINT "none"
470 CASE 1: PRINT "8087"
471 CASE 2: PRINT "80287"
472 CASE 3: PRINT "80387 or above"
473 CASE ELSE: PRINT "Unknown"
474 END SELECT
475 LOCATE 11, 41
476 IF BIT(pbvHost, 0) = 1 THEN
477     PRINT "CGA snowcheck required"
478 ELSE
479     PRINT "CGA snowcheck not required"
480 END IF
481 LOCATE 13, 41
482 IF BIT(pbvHost, 8) = 1 THEN
483     PRINT "Windows 3.1+ active"
484 ELSE
485     PRINT "Windows 3.1+ inactive"
486 END IF
487 LOCATE 15, 41: PRINT "Physical memory:"; ENDMEM; "bytes"
488 LOCATE 17, 41: PRINT "Free data space:"; FRE(-1); "bytes"
489 LOCATE 19, 41: PRINT "Free EMS:"; FRE(-11); "bytes"
490 LOCATE 21, 41: PRINT "Maximum XMS:";
491 DEF SEG = &H40
492 OUT &H70, &H18
493 temp% = INP(&H71)
494 OUT &H70, &H17
495 PRINT temp% * 256 + INP(&H71); "kilobytes"   'BIOS data
496 DEF SEG
497 ! MOV AX, &H3000
498 ! INT &H21
499 ! MOV Low, AL
500 ! MOV High, AH
501 LOCATE 23, 41: PRINT "DOS version number:"; STR$(Low) + "." + LTRIM$(STR$(High))
502 RETURN
503
504 sysinfo:
505 IF NOT inci$ = "" THEN
506 GOSUB eraser
507 LOCATE 23, 1: PRINT "Arrows select, <ENTER> accept"
508 supermenu% = 1
509 sys% = 0
510 END IF
511 RETURN
512
513 timzon:
514 IF mono% = 0 THEN COLOR 10, 0
515 CLS
516 LOCATE 1, 28: PRINT "S e t   T i m e z o n e"
517 LOCATE 2, 27: PRINT STRING$(25, 223)
518 IF mono% = 0 THEN COLOR 14, 0
519 LOCATE 5, 1: INPUT " Enter hour:   ", hour!
520 PRINT
521 INPUT " Enter minute: ", minu!
522 IF mono% = 0 THEN COLOR 7, 0
523 LOCATE 23, 1: PRINT "Writing TIMEZONE.CFG ... ";
524 OPEN "TIMEZONE.CFG" FOR OUTPUT AS #1
525     PRINT #1, hour!
526     PRINT #1, minu!
527 CLOSE #1
528 PRINT "Done."
529 supermenu% = 0
530 RETURN
531
532 viewtim:
533 CLS
534 IF mono% = 0 THEN COLOR 10, 0
535 LOCATE 1, 27: PRINT "V i e w   T i m e z o n e s"
536 LOCATE 2, 26: PRINT STRING$(29, 223)
537 IF mono% = 0 THEN COLOR 14, 0
538 LOCATE 4, 1
539 PRINT " London (UT):          0 h              Norfolk islands:       11 h 30 min"
540 PRINT " Budapest (CET):       1 h              Wellington:            12 h"
541 PRINT " Helsinki:             2 h              Chatham islands:       12 h 45 min"
542 PRINT " Moscow:               3 h              Aleutian islands:      13 h"
543 PRINT " Tehran:               3 h 30 min       Niue:                  13 h 30 min"
544 PRINT " Chelyabinsk:          4 h              Tahiti:                14 h"
545 PRINT " Kabul:                4 h 30 min       Marcuises islands:     14 h 30 min"
546 PRINT " Karachi:              5 h              Seward:                15 h"
547 PRINT " New Delhi:            5 h 30 min       Pitcairn islands:      15 h 30 min"
548 PRINT " Krasnoyarsk:          6 h              San Francisco (PT):    16 h"
549 PRINT " Cocos islands:        6 h 30 min       Salt Lake City (MT):   17 h"
550 PRINT " Katmandu:             6 h 45 min       Dallas (CT):           18 h"
551 PRINT " Bangkok:              7 h              New York (ET):         19 h"
552 PRINT " Beijing:              8 h              Santiago:              20 h"
553 PRINT " Tokyo:                9 h              Newfoundland:          20 h 30 min"
554 PRINT " Adelaide:             9 h 30 min       Rio de Janerio:        21 h"
555 PRINT " Sydney:              10 h              Trindade:              22 h"
556 PRINT " Lord Howe islands:   10 h 30 min       Azores:                23 h"
557 PRINT " Solomon islands:     11 h"
558 IF INPUT$(1) = "" THEN
559 END IF
560 supermenu% = 0
561 RETURN
562
563 simulator:
564 IF scrnmode% = 0 THEN
565     manual% = 0
566 SELECT CASE pbvScrnCard
567 CASE 0
568     CLS
569     IF mono% = 0 THEN COLOR 12, 0
570     LOCATE 7, 20: PRINT "Error: No videocard was detected."
571     LOCATE 10, 20: PRINT "Solutions:"
572     LOCATE 12, 20: PRINT "1: Try to select a screen mode manually."
573     LOCATE 14, 20: PRINT "2: Get a videocard."
574     IF mono% = 0 THEN COLOR 7, 0
575     LOCATE 23, 1: PRINT "Press any key to continue"
576     IF INPUT$(1) = "" THEN
577     END IF
578     GOTO susu
579 CASE ELSE
580 IF BIT(pbvScrnCard, 0) = 0 THEN
581     IF BIT(pbvScrnCard, 5) = 1 THEN
582         scrnmode% = 12
583     ELSEIF BIT(pbvScrnCard, 3) = 1 THEN
584         scrnmode% = 7
585     ELSEIF BIT(pbvScrnCard, 2) = 1 THEN
586         scrnmode% = 7
587     ELSEIF BIT(pbvScrnCard, 1) = 1 THEN
588         scrnmode% = 1
589     ELSEIF BIT(pbvScrnCard, 6) = 1 THEN
590     GOSUB herculescard
591     GOTO susu
592     ELSE
593     GOSUB unknowncard
594     GOTO susu
595     END IF
596 ELSE
597     IF BIT(pbvScrnCard, 5) = 1 THEN
598         scrnmode% = 11
599     ELSEIF BIT(pbvScrnCard, 3) = 1 THEN
600         scrnmode% = 7
601     ELSEIF BIT(pbvScrnCard, 2) = 1 THEN
602         scrnmode% = 7
603     ELSEIF BIT(pbvScrnCard, 1) = 1 THEN
604         scrnmode% = 1
605     ELSEIF BIT(pbvScrnCard, 6) = 1 THEN
606     GOSUB herculescard
607     GOTO susu
608     ELSE
609     GOSUB unknowncard
610     GOTO susu
611     END IF
612 END IF
613 END SELECT
614 ELSE
615     manual% = 1
616 END IF
617 CLS
618 ON ERROR RESUME NEXT
619     SCREEN scrnmode%
620     SCREEN 0
621     WIDTH "SCRN:", 80
622     pberrcode% = ERRTEST
623     doserrcode% = ERDEV
624     doserrstr$ = ERDEV$
625 IF enableerr% = 0 THEN
626     ON ERROR GOTO 0
627 ELSE
628     ON ERROR GOTO handler
629 END IF
630 IF pberrcode% = 0 THEN
631     GOSUB drawingpart
632 ELSE
633     IF mono% = 0 THEN COLOR 12, 0
634     LOCATE 7, 15: PRINT "ERROR: Screen mode initialization failed."
635     LOCATE 10, 15: PRINT "PB/DOS error code:"; pberrcode%
636     LOCATE 12, 15: PRINT "DOS error code:"; doserrcode%
637     LOCATE 14, 15: PRINT "DOS error string: "; doserrstr$
638     IF manual% = 1 THEN
639     LOCATE 17, 15: PRINT "Solution: try a different screen mode or"
640     LOCATE 18, 25: PRINT "try Auto Detection."
641     ELSE
642     LOCATE 17, 15: PRINT "Problem: SolarDyn was unable to determine videocard."
643     LOCATE 20, 15: PRINT "Solution: try manual selection."
644     END IF
645     IF mono% = 0 THEN COLOR 7, 0
646     LOCATE 23, 1: PRINT "Press any key to continue"
647     IF INPUT$(1) = "" THEN
648     END IF
649 END IF
650 susu:
651 supermenu% = 0
652 RETURN
653
654 unknowncard:
655 CLS
656 IF mono% = 0 THEN COLOR 12, 0
657 LOCATE 7, 15: PRINT "Error: Unknown videocard was detected."
658 LOCATE 10, 15: PRINT "Solutions:"
659 LOCATE 12, 15: PRINT "1: Try to select a screen mode manually."
660 LOCATE 14, 15: PRINT "2: Get another videocard."
661 IF mono% = 0 THEN COLOR 7, 0
662 LOCATE 23, 1: PRINT "Press any key to continue"
663 IF INPUT$(1) = "" THEN
664 END IF
665 RETURN
666
667 herculescard:
668 CLS
669 IF mono% = 0 THEN COLOR 12, 0
670 LOCATE 7, 15: PRINT "Error: Hercules videocard was detected."
671 LOCATE 10, 15: PRINT "Problem: This videocard is not supported."
672 LOCATE 13, 15: PRINT "Solutions:"
673 LOCATE 15, 15: PRINT "1: Try to select another screen mode manually."
674 LOCATE 17, 15: PRINT "2: Get another videocard."
675 IF mono% = 0 THEN COLOR 7, 0
676 LOCATE 23, 1: PRINT "Press any key to continue"
677 IF INPUT$(1) = "" THEN
678 END IF
679 RETURN
680
681 drawingpart:
682 RANDOMIZE TIMER
683 FOR n% = 0 TO 99   'random stars
684 rand#(n%, 0) = RND
685 rand#(n%, 1) = RND
686 NEXT n%
687 CLS
688 IF mono% = 0 THEN COLOR 10, 0
689 LOCATE 5, 26: PRINT "S t a r t   S i m u l a t o r"
690 LOCATE 6, 25: PRINT STRING$(31, 223)
691 IF mono% = 0 THEN COLOR 14, 0
692 LOCATE 8, 25: PRINT "Screen mode tested succesfully."
693 IF mono% = 0 THEN COLOR 11, 0
694 LOCATE 10, 29: PRINT "Keys:"
695 LOCATE 12, 24: PRINT "Arrows: move"
696 LOCATE 13, 24: PRINT "+     : enlarge"
697 LOCATE 14, 24: PRINT "-     : reduce"
698 LOCATE 15, 24: PRINT "Enter : activate/deactivate crosses"
699 LOCATE 16, 24: PRINT "Esc   : exit"
700 IF mono% = 0 THEN COLOR 10, 0
701 LOCATE 19, 1: PRINT "This is a shematic real-time representation of the Solar System. The planets,"
702 LOCATE 20, 3: PRINT "the greater moons, and every planets's and moons's orbits are displayed."
703 IF mono% = 0 THEN COLOR 7, 0
704 LOCATE 23, 24: PRINT "Press any key to begin"
705 IF INPUT$(1) = "" THEN
706 END IF
707 SCREEN scrnmode%
708 VIEW
709 t# = 1
710 WINDOW (a#, b#)-(c#, d#)
711 RANDOMIZE TIMER
712 GOSUB sunsystem
713 refresh# = TIMER
714 DO
715     IF TIMER - refresh# > freshrate# THEN
716         CLS
717         GOSUB sunsystem
718         IF TIMER < 86400 - freshrate# THEN
719             refresh# = TIMER
720         ELSE
721             refresh# = 0
722         END IF
723     END IF
724     inci$ = INKEY$
725     SELECT CASE inci$
726     CASE CHR$(27): EXIT LOOP
727     CASE "+"
728         IF c# - a# > .05 THEN
729             t# = ((c# - a#) / 9)
730             m# = ((d# - b#) / 9)
731             a# = a# + t#
732             b# = b# + m#
733             c# = c# - t#
734             d# = d# - m#
735             WINDOW (a#, b#)-(c#, d#)
736             CLS
737             GOSUB sunsystem
738         END IF
739     CASE "-"
740         IF c# - a# < 1000000 THEN
741             t# = ((c# - a#) / 6)
742             m# = ((d# - b#) / 6)
743             a# = a# - t#
744             b# = b# - m#
745             c# = c# + t#
746             d# = d# + m#
747             WINDOW (a#, b#)-(c#, d#)
748             CLS
749             GOSUB sunsystem
750         END IF
751     CASE CHR$(0) + "M"
752         IF c# < 1000000 THEN
753             t# = ((c# - a#) / 8)
754             a# = a# + t#
755             c# = c# + t#
756             WINDOW (a#, b#)-(c#, d#)
757             CLS
758             GOSUB sunsystem
759         END IF
760     CASE CHR$(0) + "K"
761         IF a# > -1000000 THEN
762             t# = ((c# - a#) / 8)
763             a# = a# - t#
764             c# = c# - t#
765             WINDOW (a#, b#)-(c#, d#)
766             CLS
767             GOSUB sunsystem
768         END IF
769     CASE CHR$(0) + "P"
770         IF b# > -800000 THEN
771             m# = ((d# - b#) / 8)
772             b# = b# - m#
773             d# = d# - m#
774             WINDOW (a#, b#)-(c#, d#)
775             CLS
776             GOSUB sunsystem
777         END IF
778     CASE CHR$(0) + "H"
779         IF d# < 800000 THEN
780             m# = ((d# - b#) / 8)
781             b# = b# + m#
782             d# = d# + m#
783             WINDOW (a#, b#)-(c#, d#)
784             CLS
785             GOSUB sunsystem
786         END IF
787     CASE CHR$(13)
788         IF c# - a# > 50 THEN
789             cross% = NOT cross%
790             CLS
791             GOSUB sunsystem
792         END IF
793     END SELECT
794     IF c# - a# < 50 THEN cross% = 0
795 LOOP
796 SCREEN 0
797 WIDTH "SCRN:", 80
798 ON ERROR RESUME NEXT   'Do not remove this handler!
799 PRINT TIMER
800 dummy% = ERRTEST
801 IF enableerr% = 0 THEN
802     ON ERROR GOTO 0
803 ELSE
804     ON ERROR GOTO handler
805 END IF
806 RETURN
807
808 sunsystem:
809 visit% = 1
810 year# = VAL(RIGHT$(DATE$, 4))
811 month# = VAL(LEFT$(DATE$, 2))
812 day# = VAL(MID$(DATE$, 4, 2))
813 timezone# = 0
814 UT# = (TIMER - timezone# * 3600) / 86400
815 JD# = 367 * year# - INT(7 * (year# + INT((month# + 9) / 12)) / 4) - INT(3 * (INT((year# + (month# - 9) / 7) / 100) + 1) / 4) + INT(275 * month# / 9) + day# + 1721028.5# + UT#
816 delta# = JD# - 2451544.45833333#
817
818 FOR n% = 0 TO 99
819     PSET (rand#(n%, 0) * (c# - a#) + a#, rand#(n%, 1) * (d# - b#) + b#)   'random stars
820 NEXT n%
821
822 IF (c# - a# * 50 > 6.9599) AND (t# > .1) THEN
823     CIRCLE (0, 0), 6.9599, 14   'Sun
824     IF (c# - a#) / 640 < 6.9599 THEN PAINT (0, 0), 14   'Sun inside
825 END IF
826
827 IF (c# - a#) * 5 > 579.09347# THEN CIRCLE (0, 0), 579.09347#, 7   'Mercury orbit
828 IF (c# - a#) * 5 > .02439 THEN
829     planetx# = 579.09347# * COS(delta# * .07142533237# + 4.40550192#)
830     planety# = 579.09347# * SIN(delta# * .07142533237# + 4.40550192#)
831     IF cross% THEN
832         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
833         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
834     END IF
835     FOR r% = 0 TO 2 * 3.141592653589793#
836         PSET (COS(r%) * .02439 + planetx#, SIN(r%) * .02439 + planety#), 6
837     NEXT r%
838     CIRCLE (planetx#, planety#), .02439, 6   'Mercury
839     IF (c# - a#) / 640 < .02439 THEN PAINT (planetx#, planety#), 6  'Mercury inside
840 END IF
841
842 IF (c# - a#) * 5 > 1082.0416# THEN CIRCLE (0, 0), 1082.0416#, 7   'Venus orbit
843 IF (c# - a#) * 5 > .06051 THEN
844     planetx# = 1082.0461# * COS(delta# * .02796247022# + 3.17300858#)
845     planety# = 1082.0461# * SIN(delta# * .02796247022# + 3.17300858#)
846     IF cross% THEN
847         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
848         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
849     END IF
850     FOR r% = 0 TO 2 * 3.141592653589793#
851         PSET (COS(r%) * .06051 + planetx#, SIN(r%) * .06051 + planety#), 6
852     NEXT r%
853     CIRCLE (planetx#, planety#), .06051, 6   'Venus
854     IF (c# - a#) / 640 < .06051 THEN PAINT (planetx#, planety#), 6   'Venus inside
855 END IF
856
857 IF (c# - a#) * 5 > 1495.979 THEN CIRCLE (0, 0), 1495.979, 7   'Earth orbit
858 IF (c# - a#) * 5 > .06378 THEN
859     planetx# = 1495.979# * COS(delta# * .0172027913# + 1.743002146#)
860     planety# = 1495.979# * SIN(delta# * .0172027913# + 1.743002146#)
861     IF cross% THEN
862         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
863         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
864     END IF
865     FOR r% = 0 TO 2 * 3.141592653589793#
866         PSET (COS(r%) * .06378 + planetx#, SIN(r%) * .06378 + planety#), 6
867     NEXT r%
868     CIRCLE (planetx#, planety#), .06378, 6  'Earth
869     IF (c# - a#) / 640 < .06378 THEN PAINT (planetx#, planety#), 6   'Earth inside
870 END IF
871
872 IF (c# - a#) * 5 > 3.844 THEN CIRCLE (planetx#, planety#), 3.844, 7   'Moon orbit
873 IF (c# - a#) * 5 > .3476 THEN
874     moonx# = 3.844 * COS(delta# * .22997152# + 3.781692157#)
875     moony# = 3.844 * SIN(delta# * .22997152# + 3.781692157#)
876     FOR r% = 0 TO 2 * 3.141592653589793#
877         PSET (COS(r%) * .03476 + moonx# + planetx#, SIN(r%) * .03476 + moony# + planety#), 6
878     NEXT r%
879     CIRCLE (moonx# + planetx#, moony# + planety#), .03476, 6   'Moon
880     IF (c# - a#) / 640 < .03476 THEN PAINT (moonx# + planetx#, moony# + planety#), 6   'Moon inside
881 END IF
882
883 IF (c# - a#) * 5 > 2279.4232# THEN CIRCLE (0, 0), 2279.4232#, 7   'Mars orbit
884 IF (c# - a#) * 5 > .03393 THEN
885     planetx# = 2279.4232# * COS(delta# * 9.146091106999999D-03 + 6.265964725#)
886     planety# = 2279.4232# * SIN(delta# * 9.146091106999999D-03 + 6.265964725#)
887     IF cross% THEN
888         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
889         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
890     END IF
891     FOR r% = 0 TO 2 * 3.141592653589793#
892         PSET (COS(r%) * .03393 + planetx#, SIN(r%) * .03393 + planety#), 6
893     NEXT r%
894     CIRCLE (planetx#, planety#), .03393, 6   'Mars
895     IF (c# - a#) / 640 < .03393 THEN PAINT (planetx#, planety#), 6   'Mars inside
896 END IF
897
898 IF (c# - a#) * 5 > .09378 THEN CIRCLE (planetx#, planety#), .09378, 7   'Phobos orbit
899 IF (c# - a#) * 5 > .23459 THEN CIRCLE (planetx#, planety#), .23459, 7   'Deimos orbit
900
901 IF (c# - a#) * 5 > 4338.3391# THEN CIRCLE (0, 0), 4338.3391#, 7   'Ceres orbit
902 FOR n% = 0 TO 1000
903     r# = RND * 2367.413416# + 3456.3295#
904     f# = RND * 2 * 3.141592653589793#
905     PSET (COS(f#) * r#, SIN(f#) * r#), 7   'asteroid belt
906 NEXT n%
907
908 IF (c# - a#) * 5 > 7783.2795# THEN CIRCLE (0, 0), 7783.2795#, 7   'Jupiter orbit
909 IF (c# - a#) * 5 > .71492 THEN
910     planetx# = 7783.2795# * COS(delta# * .00145020768# + .632681853#)
911     planety# = 7783.2795# * SIN(delta# * .00145020768# + .632681853#)
912     IF cross% THEN
913         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
914         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
915     END IF
916     FOR r% = 0 TO 2 * 3.141592653589793#
917         PSET (COS(r%) * .71492 + planetx#, SIN(r%) * .71492 + planety#), 3
918     NEXT r%
919     CIRCLE (planetx#, planety#), .71492, 3   'Jupiter
920     IF (c# - a#) / 640 < .71492 THEN PAINT (planetx#, planety#), 3   'Jupiter inside
921 END IF
922
923 REM Jupiter's moons
924 IF (c# - a#) * 5 > 1.28 THEN CIRCLE (planetx#, planety#), 1.28, 7
925 IF (c# - a#) * 5 > 1.29 THEN CIRCLE (planetx#, planety#), 1.29, 7
926 IF (c# - a#) * 5 > 1.81 THEN CIRCLE (planetx#, planety#), 1.81, 7
927 IF (c# - a#) * 5 > 2.22 THEN CIRCLE (planetx#, planety#), 2.22, 7
928
929 IF (c# - a#) * 5 > 4.42 THEN CIRCLE (planetx#, planety#), 4.42, 7   'Io orbit
930 IF (c# - a#) * 5 > .03638 THEN
931     FOR r% = 0 TO 2 * 3.141592653589793#
932         PSET (COS(r%) * .03638 + 2.95755728# + planetx#, SIN(r%) * .03638 - 3.284700129# + planety#), 6
933     NEXT r%
934     CIRCLE (2.95755728# + planetx#, -3.284700129# + planety#), .03638, 6   'Io
935     IF (c# - a#) / 640 < .03638 THEN PAINT (2.95755728# + planetx#, -3.284700129# + planety#), 6   'Io inside
936 END IF
937
938 IF (c# - a#) * 5 > 6.71 THEN CIRCLE (planetx#, planety#), 7.71, 7   'Europa orbit
939 IF (c# - a#) * 5 > .0313 THEN
940     FOR r% = 0 TO 2 * 3.141592653589793#
941         PSET (COS(r%) * .0313 + 7.615077106# + planetx#, SIN(r%) * .0313 + 1.206109725# + planety#), 6
942     NEXT r%
943     CIRCLE (7.615077106# + planetx#, 1.206109725# + planety#), .0313, 6   'Europa
944     IF (c# - a#) / 640 < .0313 THEN PAINT (7.615077106# + planetx#, 1.206109725# + planety#), 6   'Europa inside
945 END IF
946
947 IF (c# - a#) * 5 > 10.7 THEN CIRCLE (planetx#, planety#), 10.7, 7   'Ganymedes orbit
948 IF (c# - a#) * 5 > .05268 THEN
949     FOR r% = 0 TO 2 * 3.141592653589793#
950         PSET (COS(r%) * .05268 + 10.46617933# + planetx#, SIN(r%) * .05268 - 2.224655092# + planety#), 6
951     NEXT r%
952     CIRCLE (10.46617933# + planetx#, -2.224655092# + planety#), .05268, 6   'Ganymedes
953     IF (c# - a#) / 640 < .05268 THEN PAINT (10.46617933# + planetx#, -2.224655092# + planety#), 6   'Ganymedes inside
954 END IF
955
956 IF (c# - a#) * 5 > 18.83 THEN CIRCLE (planetx#, planety#), 18.83, 7   'Callisto orbit
957 IF (c# - a#) * 5 > .04806 THEN
958     FOR r% = 0 TO 2 * 3.141592653589793#
959         PSET (COS(r%) * .04806 + 18.00721855# + planetx#, SIN(r%) * .04806 + 5.5053592# + planety#), 6
960     NEXT r%
961     CIRCLE (18.00721855# + planetx#, 5.5053592# + planety#), .04806, 6   'Callisto
962     IF (c# - a#) / 640 < .04806 THEN PAINT (18.00721855# + planetx#, 5.5053592# + planety#), 6   'Callisto inside
963 END IF
964
965 IF (c# - a#) * 5 > 73.9824 THEN CIRCLE (planetx#, planety#), 73.9824, 7
966 IF (c# - a#) * 5 > 110.94 THEN CIRCLE (planetx#, planety#), 110.94, 7
967 IF (c# - a#) * 5 > 114.8 THEN CIRCLE (planetx#, planety#), 114.8, 7
968 IF (c# - a#) * 5 > 117.2 THEN CIRCLE (planetx#, planety#), 117.2, 7
969 IF (c# - a#) * 5 > 117.37 THEN CIRCLE (planetx#, planety#), 117.37, 7
970 IF (c# - a#) * 5 > 126.23 THEN CIRCLE (planetx#, planety#), 126.23, 7
971 IF (c# - a#) * 5 > 199.25 THEN CIRCLE (planetx#, planety#), 199.25, 7
972 IF (c# - a#) * 5 > 208.366 THEN CIRCLE (planetx#, planety#), 208.366, 7
973 IF (c# - a#) * 5 > 210.58 THEN CIRCLE (planetx#, planety#), 210.58, 7
974 IF (c# - a#) * 5 > 212 THEN CIRCLE (planetx#, planety#), 212, 7
975 IF (c# - a#) * 5 > 220.47 THEN CIRCLE (planetx#, planety#), 220.47, 7
976 IF (c# - a#) * 5 > 223.499 THEN CIRCLE (planetx#, planety#), 223.499, 7
977 IF (c# - a#) * 5 > 224.523 THEN CIRCLE (planetx#, planety#), 224.523, 7
978 IF (c# - a#) * 5 > 226 THEN CIRCLE (planetx#, planety#), 226, 7
979 IF (c# - a#) * 5 > 226.234 THEN CIRCLE (planetx#, planety#), 226.234, 7
980 IF (c# - a#) * 5 > 228.05 THEN CIRCLE (planetx#, planety#), 228.05, 7
981 IF (c# - a#) * 5 > 234.64 THEN CIRCLE (planetx#, planety#), 234.64, 7
982 IF (c# - a#) * 5 > 234.988 THEN CIRCLE (planetx#, planety#), 234.988, 7
983 IF (c# - a#) * 5 > 235 THEN CIRCLE (planetx#, planety#), 235, 7
984 IF (c# - a#) * 5 > 237 THEN CIRCLE (planetx#, planety#), 237, 7
985
986 IF (c# - a#) * 5 > 14269.844# THEN CIRCLE (0, 0), 14269.844#, 7   'Saturn orbit
987 IF (c# - a#) * 5 > .60268 THEN
988     planetx# = 14269.844# * COS(delta# * .0005839768926# + .797615468#)
989     planety# = 14269.844# * SIN(delta# * .0005839768926# + .797615468#)
990     IF cross% THEN
991         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
992         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
993     END IF
994     FOR r% = 0 TO 2 * 3.141592653589793#
995         PSET (COS(r%) * .60268 + planetx#, SIN(r%) * .60268 + planety#), 3
996     NEXT r%
997     CIRCLE (planetx#, planety#), .60268, 3   'Saturn
998     IF (c# - a#) / 640 < .60268 THEN PAINT (planetx#, planety#), 3   'Saturn inside
999 END IF
1000
1001 REM Saturn's moons
1002 IF (c# - a#) * 5 > 1.3358 THEN CIRCLE (planetx#, planety#), 1.3358, 7
1003 IF (c# - a#) * 5 > 1.3767 THEN CIRCLE (planetx#, planety#), 1.3767, 7
1004 IF (c# - a#) * 5 > 1.3935 THEN CIRCLE (planetx#, planety#), 1.3935, 7
1005 IF (c# - a#) * 5 > 1.417 THEN CIRCLE (planetx#, planety#), 1.417, 7
1006 IF (c# - a#) * 5 > 1.5142 THEN CIRCLE (planetx#, planety#), 1.5142, 7
1007 IF (c# - a#) * 5 > 1.5147 THEN CIRCLE (planetx#, planety#), 1.5147, 7
1008 IF (c# - a#) * 5 > 1.8552 THEN CIRCLE (planetx#, planety#), 1.8552, 7
1009 IF (c# - a#) * 5 > 2.3802 THEN CIRCLE (planetx#, planety#), 2.3802, 7
1010
1011 IF (c# - a#) * 5 > 2.9466 THEN
1012     CIRCLE (planetx#, planety#), 2.9466, 7
1013     CIRCLE (planetx#, planety#), 2.9466, 7
1014     CIRCLE (planetx#, planety#), 2.9466, 7   'Tethys orbit
1015 END IF
1016 IF (c# - a#) * 5 > .01056 THEN
1017     FOR r% = 0 TO 2 * 3.141592653589793#
1018         PSET (COS(r%) * .01056 - 1.007796554# + planetx#, SIN(r%) * .01056 + 2.768898276# + planety#), 6
1019     NEXT r%
1020     CIRCLE (-1.007796554# + planetx#, 2.768898276# + planety#), .01056, 6   'Tethys
1021     IF (c# - a#) / 640 < .01056 THEN PAINT (-1.007796554# + planetx#, 2.768898276# + planety#), 6   'Tethys inside
1022 END IF
1023
1024 IF (c# - a#) * 5 > 3.774 THEN
1025     CIRCLE (planetx#, planety#), 3.774, 7
1026     CIRCLE (planetx#, planety#), 3.774, 7   'Dione orbit
1027 END IF
1028 IF (c# - a#) * 5 > .0112 THEN
1029     FOR r% = 0 TO 2 * 3.141592653589793#
1030         PSET (COS(r%) * .0112 + 2.525298908# + planetx#, SIN(r%) * .0112 + 2.804628571# + planety#), 6
1031     NEXT r%
1032     CIRCLE (2.525298908# + planetx#, 2.804628571# + planety#), .0112, 6   'Dione
1033     IF (c# - a#) / 640 < .0112 THEN PAINT (2.525298908# + planetx#, 2.804628571# + planety#), 6   'Dione inside
1034 END IF
1035
1036 IF (c# - a#) * 5 > 5.2704 THEN CIRCLE (planetx#, planety#), 5.2704, 7   'Rhea orbit
1037 IF (c# - a#) * 5 > .01528 THEN
1038     FOR r% = 0 TO 2 * 3.141592653589793#
1039         PSET (COS(r%) * .01528 + 5.155229115# + planetx#, SIN(r%) * .01528 + 1.095777775# + planety#), 6
1040     NEXT r%
1041     CIRCLE (5.155229115# + planetx#, 1.095777775# + planety#), .01528, 6   'Rhea
1042     PAINT (5.155229115# + planetx#, 1.095777775# + planety#), 6   'Rhea inside
1043 END IF
1044
1045 IF (c# - a#) * 5 > 12.2183 THEN CIRCLE (planetx#, planety#), 12.2183, 7   'Titan orbit
1046 IF (c# - a#) * 5 > .0514 THEN
1047     FOR r% = 0 TO 2 * 3.141592653589793#
1048         PSET (COS(r%) * .0514 + 12.03267657# + planetx#, SIN(r%) * .0514 + 2.121685529# + planety#), 6
1049     NEXT r%
1050     CIRCLE (12.03267657# + planetx#, 2.121685529# + planety#), .0514, 6   'Titan
1051     IF (c# - a#) / 640 < .0514 THEN PAINT (12.03267657# + planetx#, 2.121685529# + planety#), 6   'Titan inside
1052 END IF
1053 IF (c# - a#) * 5 > 14.811 THEN
1054     CIRCLE (planetx#, planety#), 14.811, 7
1055 END IF
1056
1057 IF (c# - a#) * 5 > 35.613 THEN CIRCLE (planetx#, planety#), 35.613, 7   'Iapetus
1058 IF (c# - a#) * 5 > .01428 THEN
1059     FOR r% = 0 TO 2 * 3.141592653589793#
1060         PSET (COS(r%) * .01428 - 17.8065 + planetx#, SIN(r%) * .01428 - 30.84176271# + planety#), 6
1061     NEXT r%
1062     CIRCLE (-17.8065 + planetx#, -30.84176271# + planety#), .01428, 6   'Iapetus
1063     IF (c# - a#) / 640 < .01428 THEN PAINT (-17.8065 + planetx#, -30.84176271# + planety#), 6   'Iapetus inside
1064 END IF
1065
1066 IF (c# - a#) * 5 > 113.192 THEN CIRCLE (planetx#, planety#), 113.192, 7
1067 IF (c# - a#) * 5 > 1113.594 THEN CIRCLE (planetx#, planety#), 113.594, 7
1068 IF (c# - a#) * 5 > 129.52 THEN CIRCLE (planetx#, planety#), 129.52, 7
1069 IF (c# - a#) * 5 > 149.853 THEN CIRCLE (planetx#, planety#), 149.853, 7
1070 IF (c# - a#) * 5 > 154.722 THEN CIRCLE (planetx#, planety#), 154.722, 7
1071 IF (c# - a#) * 5 > 164.962 THEN CIRCLE (planetx#, planety#), 164.962, 7
1072 IF (c# - a#) * 5 > 178.079 THEN CIRCLE (planetx#, planety#), 178.079, 7
1073 IF (c# - a#) * 5 > 179.775 THEN CIRCLE (planetx#, planety#), 179.775, 7
1074 IF (c# - a#) * 5 > 182.017 THEN CIRCLE (planetx#, planety#), 182.017, 7
1075 IF (c# - a#) * 5 > 184.129 THEN CIRCLE (planetx#, planety#), 184.129, 7
1076 IF (c# - a#) * 5 > 191.86 THEN CIRCLE (planetx#, planety#), 191.86, 7
1077 IF (c# - a#) * 5 > 200.66 THEN CIRCLE (planetx#, planety#), 200.66, 7
1078 IF (c# - a#) * 5 > 233.062 THEN CIRCLE (planetx#, planety#), 233.062, 7
1079
1080 IF (c# - a#) * 5 > 28709.931# THEN CIRCLE (0, 0), 28709.931#, 7   'Uranus orbit
1081 IF (c# - a#) * 5 > .25559 THEN
1082     planetx# = 28709.931# * COS(delta# * .0002047707571# + 5.522512642#)
1083     planety# = 28709.931# * SIN(delta# * .0002047707571# + 5.522512642#)
1084     IF cross% THEN
1085         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
1086         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
1087     END IF
1088     FOR r% = 0 TO 2 * 3.141592653589793#
1089         PSET (COS(r%) * .25559 + planetx#, SIN(r%) * .25559 + planety#), 37
1090     NEXT r%
1091     CIRCLE (planetx#, planety#), .25559, 3   'Uranus
1092     IF (c# - a#) / 640 < .25559 THEN PAINT (planetx#, planety#), 3   'Uranus inside
1093 END IF
1094
1095 REM Uranus's moons
1096 IF (c# - a#) * 5 > .4977 THEN CIRCLE (planetx#, planety#), .4977, 7
1097 IF (c# - a#) * 5 > .5379 THEN CIRCLE (planetx#, planety#), .5379, 7
1098 IF (c# - a#) * 5 > .5917 THEN CIRCLE (planetx#, planety#), .5917, 7
1099 IF (c# - a#) * 5 > .6178 THEN CIRCLE (planetx#, planety#), .6178, 7
1100 IF (c# - a#) * 5 > .6268 THEN CIRCLE (planetx#, planety#), .6268, 7
1101 IF (c# - a#) * 5 > .6435 THEN CIRCLE (planetx#, planety#), .6435, 7
1102 IF (c# - a#) * 5 > .6609 THEN CIRCLE (planetx#, planety#), .6609, 7
1103 IF (c# - a#) * 5 > .6994 THEN CIRCLE (planetx#, planety#), .6994, 7
1104 IF (c# - a#) * 5 > .7526 THEN CIRCLE (planetx#, planety#), .7526, 7
1105 IF (c# - a#) * 5 > .7642 THEN CIRCLE (planetx#, planety#), .7642, 7
1106 IF (c# - a#) * 5 > .8601 THEN CIRCLE (planetx#, planety#), .8601, 7
1107 IF (c# - a#) * 5 > 1.2939 THEN CIRCLE (planetx#, planety#), 1.2939, 7
1108 IF (c# - a#) * 5 > 1.9102 THEN CIRCLE (planetx#, planety#), 1.9102, 7
1109 IF (c# - a#) * 5 > 2.663 THEN CIRCLE (planetx#, planety#), 2.663, 7
1110 IF (c# - a#) * 5 > 4.3591 THEN CIRCLE (planetx#, planety#), 4.3591, 7
1111 IF (c# - a#) * 5 > 5.8352 THEN CIRCLE (planetx#, planety#), 5.8352, 7
1112 IF (c# - a#) * 5 > 71.6705 THEN CIRCLE (planetx#, planety#), 71.6705, 7
1113 IF (c# - a#) * 5 > 79.505 THEN CIRCLE (planetx#, planety#), 79.505, 7
1114 IF (c# - a#) * 5 > 122.1092 THEN CIRCLE (planetx#, planety#), 122.1092, 7
1115 IF (c# - a#) * 5 > 163.597 THEN CIRCLE (planetx#, planety#), 163.597, 7
1116 IF (c# - a#) * 5 > 174.144 THEN CIRCLE (planetx#, planety#), 174.144, 7
1117
1118 IF (c# - a#) * 5 > 44947.74 THEN CIRCLE (0, 0), 44947.74, 7   'Neptune orbit
1119 IF (c# - a#) * 5 > .24764 THEN
1120     planetx# = 44947.74# * COS(delta# * .000104392204# + 5.304637373#)
1121     planety# = 44947.74# * SIN(delta# * .000104392204# + 5.304637373#)
1122     IF cross% THEN
1123         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
1124         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
1125     END IF
1126     FOR r% = 0 TO 2 * 3.141592653589793#
1127         PSET (COS(r%) * .24764 + planetx#, SIN(r%) * .24764 + planety#), 3
1128     NEXT r%
1129     CIRCLE (planetx#, planety#), .24764, 3   'Neptune
1130     IF (c# - a#) / 640 < .24764 THEN PAINT (planetx#, planety#), 3   'Neptune inside
1131 END IF
1132
1133 REM Neptune's moons
1134 IF (c# - a#) * 5 > .4823 THEN CIRCLE (planetx#, planety#), .4823, 7
1135 IF (c# - a#) * 5 > .5007 THEN CIRCLE (planetx#, planety#), .5007, 7
1136 IF (c# - a#) * 5 > .5253 THEN CIRCLE (planetx#, planety#), .5253, 7
1137 IF (c# - a#) * 5 > .6195 THEN CIRCLE (planetx#, planety#), .6195, 7
1138 IF (c# - a#) * 5 > .7355 THEN CIRCLE (planetx#, planety#), .7355, 7
1139 IF (c# - a#) * 5 > 1.1765 THEN CIRCLE (planetx#, planety#), 1.1765, 7
1140 IF (c# - a#) * 5 > 3.5476 THEN CIRCLE (planetx#, planety#), 3.5476, 7
1141 IF (c# - a#) * 5 > 55.134 THEN CIRCLE (planetx#, planety#), 55.134, 7
1142
1143 IF (c# - a#) * 5 > 59135.152# THEN CIRCLE (0, 0), 59135.152#, 7   'Pluto orbit
1144 IF (c# - a#) * 5 > .0115 THEN
1145     planetx# = 59135.152# * COS(delta# * .00006921538305# + 4.372922441#)
1146     planety# = 59135.152# * SIN(delta# * .00006921538305# + 4.372922441#)
1147     IF cross% THEN
1148         LINE (planetx# - ((c# - a#) / 32), planety#)-(planetx# + ((c# - a#) / 32), planety#)
1149         LINE (planetx#, planety# - ((d# - b#) / 24))-(planetx#, planety# + ((d# - b#) / 24))
1150     END IF
1151     FOR r% = 0 TO 2 * 3.141592653589793#
1152         PSET (COS(r%) * .0115 + planetx#, SIN(r%) * .0115 + planety#), 6
1153     NEXT r%
1154     CIRCLE (planetx#, planety#), .0115, 6   'Pluto
1155     IF (c# - a#) / 640 < .0115 THEN PAINT (planetx#, planety#), 6   'Pluto inside
1156 END IF
1157 IF (c# - a#) * 5 > .196 THEN CIRCLE (planetx#, planety#), .196, 7   'Charon orbit
1158 RETURN
1159
1160 handler:
1161 OPEN "SOLARDYN.ERR" FOR APPEND AS #2
1162 PRINT #2, DATE$; "  "; TIME$; "  "; cpu$; "  "; dos$; " "; FRE(-1); pbvNpx; pbvHost; pbvScrnCard; pbvScrnMode; scrnmode%; ERR; ERL; ERDEV; " "; ERDEV$
1163 CLOSE #2
1164 RESUME NEXT

FUNCTION cpu$
LOCAL proc?
DIM creat AS STRING * 12

! pushf
! mov     ax, &h0000
! push    ax
! popf
! pushf
! pop     ax
! and     ax, &hF000
! cmp     ax, &hF000
! jnz     Test286

! mov     ax, &hFFFF
! mov     cl, &h21
! shl     ax, cl
! jnz     Set186
! mov     proc?, &h00
! popf

! xor     ax, ax
! mov     al, &h40
! mul     al
! jz      SetNEC
! jmp     finish

Set186:
! mov     proc?, &h01
! popf
! jmp     finish

SetNEC:
! mov     proc?, &hFF
! jmp     finish

Test286:
! mov     ax, &h7000
! push    ax
! popf
! pushf
! pop     ax
! and     ax, &h7000
! jnz     Test386
! mov     proc?, &h02
! popf
! jmp     finish

Test386:
! mov     bx, sp
! and     sp, &hFFFC
! db      &h66
! pushf
! db      &h66
! pop     ax
! db      &h66
! mov     cx, ax
! db      &h66
! xor     ax, &h0000
! dw      &h0004
! db      &h66
! push    ax
! db      &h66
! popf
! db      &h66
! pushf
! db      &h66
! pop     ax
! db      &h66
! xor     ax, cx
! mov     proc?, &h03
! mov     sp, bx
! jz      finish
! and     sp, &hFFFC
! db      &h66
! push    cx
! db      &h66
! popf
! mov     sp, bx

Test486:
! mov     proc?, &h04
! db      &h66
! mov     ax, cx
! db      &h66
! xor     ax, &h0000
! dw      &h0020
! db      &h66
! push    ax
! db      &h66
! popf
! db      &h66
! pushf
! db      &h66
! pop     ax
! db      &h66
! xor     ax, cx
! je      finish

TestCPUID:
! db      &h66
! xor     ax, ax
! inc     ax
! dw      &hA20F
! and     ah, &h0F
! mov     proc?, ah
! xor     ax, ax
! dw      &hA20F
! db      &h66
! mov     creat$[00], bx
! db      &h66
! mov     creat$[04], dx
! db      &h66
! mov     creat$[08], cx

finish:
SELECT CASE creat$
CASE "GenuineIntel": made$ = "Intel "
CASE "AuthenticAMD": made$ = "AMD "
CASE "NexGenDevice": made$ = "NexGen "
CASE "UMC UMC UMC ": made$ = "Cyrix "
CASE ELSE: made$ = "Intel "
END SELECT
SELECT CASE proc?
CASE 0: cpu$ = "Intel 8086/8088"
CASE 1: cpu$ = "Intel 80186"
CASE 2: cpu$ = "Intel 80286"
CASE 3: cpu$ = "Intel 80386"
CASE 4: cpu$ = made$ + "80486"
CASE 5: cpu$ = made$ + "Pentium"
CASE 6: cpu$ = made$ + "Pentium Pro/II"
CASE 7: cpu$ = made$ + "Pentium III"
CASE 8: cpu$ = made$ + "Pentium 4"
CASE 255: cpu$ = "NEC V20/V30"
CASE ELSE: cpu$ = "Intel 80" + CHR$(proc? + 48) + "86"
END SELECT
END FUNCTION
