$! make hexcalc under OpenVMS
$!
$! You need the Xaw3d lib installed,
$! which you might get from http://zinser.no-ip.info/vms/sw/xaw.htmlx.
$!
$! In case of problems with the install you might contact me at
$! zinser@zinser.no-ip.info (preferred) or zinser@sysdev.exchange.de
$!
$! Look for the compiler used
$!
$ if f$getsyi("HW_MODEL").ge.1024
$ then
$  ccopt = "/prefix=all/ext=comm"
$  if f$trnlnm("SYS").eqs."" then define sys sys$library:
$ else
$  if f$search("SYS$SYSTEM:DECC$COMPILER.EXE").eqs.""
$   then
$    if f$trnlnm("SYS").eqs."" then define sys sys$library:
$   else
$    if f$trnlnm("SYS").eqs."" then define sys decc$library_include:
$    ccopt = "/decc/prefix=all/ext=comm"
$  endif
$ endif
$!
$ if f$search("x11:[xaw]command.h").eqs.""
$ then
$   type sys$input:
To compile Hexcalc you need a copy of the Xaw widgetset installed on your
system. This was either not done or the x11 logical is not defined
properly (at least I can't find x11:[xaw]command.h). To get Xaw check
http://zinser.no-ip.info/vms/sw/xaw.htmlx
For instructions how to setup the X11 logical for use with Xaw check
http://zinser.no-ip.info/vms/sw/notes/xaw.htmlx

Exiting now
$   exit
$ endif
$!
$!      Build the option-file
$!
$ open/write optf hexcalc.opt
$ write optf "hexcalc"
$ write optf "Identification=""Hexcalc"""
$!
$!  Find out which X-Version we're running.  This will fail for older
$!  VMS versions (i.e., v5.5-1).  Therefore, choose DECWindows XUI for
$!  default.
$!
$ On Error Then GoTo XUI
$ @sys$update:decw$get_image_version sys$share:decw$xlibshr.exe decw$version
$ if f$extract(4,3,decw$version).eqs."1.0"
$ then
$   write optf "Sys$share:DECW$DWTLIBSHR.EXE/Share"
$ endif
$ if f$extract(4,3,decw$version).eqs."1.1"
$ then
$   write optf "sys$share:decw$xtshr.exe/share"
$ endif
$ if f$extract(4,3,decw$version).ges."1.2"
$ then
$   write optf "sys$share:decw$xtlibshrr5.exe/share"
$ endif
$ GoTo MAIN
$!
$ XUI:
$!
$   write optf "Sys$share:DECW$DWTLIBSHR.EXE/Share"
$ MAIN:
$ on error then exit
$ write optf "sys$share:decw$xlibshr.exe/share"
$ write optf "xmulibshr/share"
$ write optf "xaw3dlibshr/shar"
$ close optf
$!
$! Build the thing plain
$!
$ write sys$output "Compiling Hexcalc sources ..."
$   CALL MAKE hexcalc.OBJ "CC ''CCOPT' hexcalc" -
              hexcalc.c
$   write sys$output "Linking hexcalc..."
$   call make hexcalc.exe "LINK hexcalc.opt/opt" *.obj
$ write sys$output "Hexcalc build completed"
$ exit
$!
$!
$MAKE: SUBROUTINE   !SUBROUTINE TO CHECK DEPENDENCIES
$ V = 'F$Verify(0)
$! P1 = What we are trying to make
$! P2 = Command to make it
$! P3 - P8  What it depends on
$
$ If F$Search(P1) .Eqs. "" Then Goto Makeit
$ Time = F$CvTime(F$File(P1,"RDT"))
$arg=3
$Loop:
$       Argument = P'arg
$       If Argument .Eqs. "" Then Goto Exit
$       El=0
$Loop2:
$       File = F$Element(El," ",Argument)
$       If File .Eqs. " " Then Goto Endl
$       AFile = ""
$Loop3:
$       OFile = AFile
$       AFile = F$Search(File)
$       If AFile .Eqs. "" .Or. AFile .Eqs. OFile Then Goto NextEl
$       If F$CvTime(F$File(AFile,"RDT")) .Ges. Time Then Goto Makeit
$       Goto Loop3
$NextEL:
$       El = El + 1
$       Goto Loop2
$EndL:
$ arg=arg+1
$ If arg .Le. 8 Then Goto Loop
$ Goto Exit
$
$Makeit:
$ VV=F$VERIFY(0)
$ write sys$output P2
$ 'P2
$ VV='F$Verify(VV)
$Exit:
$ If V Then Set Verify
$ENDSUBROUTINE
