# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
@EXPORT = qw(%Config);
@EXPORT_OK = qw(myconfig config_sh config_vars config_re);

my %Export_Cache = map {($_ => 1)} (@EXPORT, @EXPORT_OK);

# Define our own import method to avoid pulling in the full Exporter:
sub import {
    my $pkg = shift;
    @_ = @EXPORT unless @_;

    my @funcs = grep $_ ne '%Config', @_;
    my $export_Config = @funcs < @_ ? 1 : 0;

    my $callpkg = caller(0);
    foreach my $func (@funcs) {
	die sprintf qq{"%s" is not exported by the %s module\n},
	    $func, __PACKAGE__ unless $Export_Cache{$func};
	*{$callpkg.'::'.$func} = \&{$func};
    }

    *{"$callpkg\::Config"} = \%Config if $export_Config;
    return;
}

die "Perl lib version (v5.8.4) doesn't match executable version ($])"
    unless $^V;

$^V eq v5.8.4
    or die "Perl lib version (v5.8.4) doesn't match executable version (" .
	sprintf("v%vd",$^V) . ")";

##
## This file was produced by Configure.COM on a VMS system.
##
## Package name      : perl5
## Source directory  : THETIS$DKA100:[CRAIG.PERLBUILD584.PERL.]
## Configuration time: Sun May 23 15:53:41 UTC-5:00 2004
## Configuration by  : craig
## Target system     : VMS unknown V7.2-1 AlphaStation 250 4/266
#

our $summary : unique = <<'!END!';
Summary of my $package (revision $revision $version_patchlevel_string) configuration:
  Platform:
    osname=$osname, osvers=$osvers, archname=$archname
    uname='$myuname'
    config_args='$config_args'
    hint=$hint, useposix=$useposix, d_sigaction=$d_sigaction
    usethreads=$usethreads use5005threads=$use5005threads useithreads=$useithreads usemultiplicity=$usemultiplicity
    useperlio=$useperlio d_sfio=$d_sfio uselargefiles=$uselargefiles usesocks=$usesocks
    use64bitint=$use64bitint use64bitall=$use64bitall uselongdouble=$uselongdouble
    usemymalloc=$usemymalloc, bincompat5005=undef
  Compiler:
    cc='$cc', ccflags ='$ccflags',
    optimize='$optimize',
    cppflags='$cppflags'
    ccversion='$ccversion', gccversion='$gccversion', gccosandvers='$gccosandvers'
    intsize=$intsize, longsize=$longsize, ptrsize=$ptrsize, doublesize=$doublesize, byteorder=$byteorder
    d_longlong=$d_longlong, longlongsize=$longlongsize, d_longdbl=$d_longdbl, longdblsize=$longdblsize
    ivtype='$ivtype', ivsize=$ivsize, nvtype='$nvtype', nvsize=$nvsize, Off_t='$lseektype', lseeksize=$lseeksize
    alignbytes=$alignbytes, prototype=$prototype
  Linker and Libraries:
    ld='$ld', ldflags ='$ldflags'
    libpth=$libpth
    libs=$libs
    perllibs=$perllibs
    libc=$libc, so=$so, useshrplib=$useshrplib, libperl=$libperl
    gnulibc_version='$gnulibc_version'
  Dynamic Linking:
    dlsrc=$dlsrc, dlext=$dlext, d_dlsymun=$d_dlsymun, ccdlflags='$ccdlflags'
    cccdlflags='$cccdlflags', lddlflags='$lddlflags'

!END!
my $summary_expanded;

sub myconfig {
    return $summary_expanded if $summary_expanded;
    ($summary_expanded = $summary) =~ s{\$(\w+)}
		 { my $c = $Config{$1}; defined($c) ? $c : 'undef' }ge;
    $summary_expanded;
}

our $Config_SH : unique = <<'!END!';
archlibexp='perl_root:[lib.VMS_AXP.5_8_4]'
archname='VMS_AXP'
cc='CC/DECC'
ccflags='/Include=[]/Standard=Relaxed_ANSI/Prefix=All/Obj=.obj /NOANSI_ALIAS/float=ieee/ieee=denorm_results'
dlsrc='dl_vms.c'
dynamic_ext='attrs B Cwd Data/Dumper Devel/DProf Devel/Peek Devel/PPPort Digest/MD5 Encode Errno Fcntl File/Glob Filter/Util/Call I18N/Langinfo IO List/Util MIME/Base64 Opcode PerlIO/encoding PerlIO/scalar PerlIO/via POSIX re SDBM_File Socket Storable Sys/Hostname threads threads/shared Time/HiRes Unicode/Normalize XS/APItest XS/Typemap VMS/DCLsym VMS/Stdio'
installarchlib='perl_root:[lib.VMS_AXP.5_8_4]'
installprivlib='perl_root:[lib]'
libpth='/sys$share /sys$library'
libs=' '
osname='VMS'
osvers='V7.2-1'
prefix='perl_root'
privlibexp='perl_root:[lib]'
so='exe'
static_ext=''
CONFIG='true'
CONFIG='true'
Makefile_SH='descrip_mms.template'
Mcc='CC/DECC'
PATCHLEVEL='8'
PERL_API_SUBVERSION='0'
PERL_API_VERSION='8'
PERL_CONFIG_SH='true'
PERL_REVISION='5'
PERL_SUBVERSION='4'
PERL_VERSION='8'
SUBVERSION='4'
_a='.olb'
_exe='.exe'
_o='.obj'
alignbytes='8'
aphostname='write sys$output f$edit(f$getsyi(\"SCSNODE\"),\"TRIM,LOWERCASE\")'
ar=''
archlib='perl_root:[lib.VMS_AXP.5_8_4]'
asctime_r_proto='0'
baserev='5.0'
bin='/perl_root/000000'
binexp='perl_root:[000000]'
builddir='perl_root:[000000]'
byteorder='1234'
castflags='0'
cccdlflags=''
ccdlflags=''
ccname='DEC'
ccversion='60490005'
cf_by='craig'
cf_email='system'
cf_time='Sun May 23 15:53:41 UTC-5:00 2004'
config_args='-"des" -"Dcf_email=system"'
config_sh='[-]config.sh'
cpp_stuff='42'
cpplast=' '
cppminus=' '
cpprun='CC/DECC/noobj/comments=as_is/preprocess=sys$output sys$input'
cppstdin='CC/DECC/noobj/comments=as_is/preprocess=sys$output sys$input'
crypt_r_proto='0'
ctermid_r_proto='0'
ctime_r_proto='0'
d_Gconvert='my_gconvert(x,n,t,b)'
d_PRIEldbl='define'
d_PRIFldbl='define'
d_PRIGldbl='define'
d_PRIXU64='undef'
d_PRId64='undef'
d_PRIeldbl='define'
d_PRIfldbl='define'
d_PRIgldbl='define'
d_PRIo64='undef'
d_PRIu64='undef'
d_PRIx64='undef'
d_SCNfldbl='define'
d__fwalk='undef'
d_access='undef'
d_accessx='undef'
d_aintl='undef'
d_alarm='define'
d_archlib='define'
d_asctime_r='undef'
d_atolf='undef'
d_atoll='define'
d_attribut='undef'
d_bcmp='define'
d_bcopy='define'
d_bincompat3='undef'
d_bsdgetpgrp='undef'
d_bsdsetpgrp='undef'
d_bzero='define'
d_casti32='define'
d_castneg='define'
d_charvspr='undef'
d_chown='define'
d_chroot='undef'
d_chsize='undef'
d_class='undef'
d_cmsghdr_s='undef'
d_const='define'
d_copysignl='define'
d_crypt='define'
d_crypt_r='undef'
d_csh='undef'
d_ctermid_r='undef'
d_ctime_r='undef'
d_cuserid='define'
d_dbl_dig='define'
d_dbminitproto='undef'
d_difftime='define'
d_dirfd='undef'
d_dirnamlen='define'
d_dlerror='undef'
d_dlsymun='undef'
d_dosuid='undef'
d_drand48_r='undef'
d_drand48proto='define'
d_dup2='define'
d_eaccess='undef'
d_endgrent='define'
d_endgrent_r='undef'
d_endhent='define'
d_endhostent_r='undef'
d_endnent='define'
d_endnetent_r='undef'
d_endpent='define'
d_endprotoent_r='undef'
d_endpwent='define'
d_endpwent_r='undef'
d_endsent='define'
d_endservent_r='undef'
d_eofnblk='undef'
d_eunice='undef'
d_faststdio='define'
d_fchdir='undef'
d_fchmod='undef'
d_fchown='undef'
d_fcntl='define'
d_fcntl_can_lock='undef'
d_fd_set='define'
d_fgetpos='define'
d_finite='undef'
d_finitel='undef'
d_flexfnam='define'
d_flock='undef'
d_flockproto='undef'
d_fork='undef'
d_fp_class='undef'
d_fpathconf='define'
d_fpclass='undef'
d_fpclassify='undef'
d_fpclassl='undef'
d_fpos64_t='undef'
d_frexpl='undef'
d_fs_data_s='undef'
d_fseeko='undef'
d_fsetpos='define'
d_fstatfs='undef'
d_fstatvfs='undef'
d_fsync='undef'
d_ftello='undef'
d_getcwd='define'
d_getespwnam='undef'
d_getfsstat='undef'
d_getgrent='define'
d_getgrent_r='undef'
d_getgrgid_r='undef'
d_getgrnam_r='undef'
d_getgrps='undef'
d_gethbyaddr='define'
d_gethbyname='define'
d_gethent='define'
d_gethname='define'
d_gethostbyaddr_r='undef'
d_gethostbyname_r='undef'
d_gethostent_r='undef'
d_gethostprotos='define'
d_getitimer='define'
d_getlogin='define'
d_getlogin_r='undef'
d_getmnt='undef'
d_getmntent='undef'
d_getnbyaddr='define'
d_getnbyname='define'
d_getnent='define'
d_getnetbyaddr_r='undef'
d_getnetbyname_r='undef'
d_getnetent_r='undef'
d_getnetprotos='define'
d_getpagsz='undef'
d_getpbyname='define'
d_getpbynumber='define'
d_getpent='define'
d_getpgid='undef'
d_getpgrp2='undef'
d_getpgrp='undef'
d_getppid='define'
d_getprior='undef'
d_getprotobyname_r='undef'
d_getprotobynumber_r='undef'
d_getprotoent_r='undef'
d_getprotoprotos='define'
d_getprpwnam='undef'
d_getpwent='define'
d_getpwent_r='undef'
d_getpwnam_r='undef'
d_getpwuid_r='undef'
d_getsbyname='define'
d_getsbyport='define'
d_getsent='define'
d_getservbyname_r='undef'
d_getservbyport_r='undef'
d_getservent_r='undef'
d_getservprotos='define'
d_getspnam='undef'
d_getspnam_r='undef'
d_gettimeod='define'
d_gmtime_r='undef'
d_gnulibc='undef'
d_grpasswd='undef'
d_hasmntopt='undef'
d_htonl='define'
d_ilogbl='undef'
d_index='define'
d_inetaton='undef'
d_int64_t='define'
d_isascii='define'
d_isfinite='undef'
d_isinf='undef'
d_isnan='undef'
d_isnanl='undef'
d_killpg='undef'
d_lchown='undef'
d_ldbl_dig='define'
d_link='undef'
d_llseek='undef'
d_localtime_r='undef'
d_locconv='define'
d_lockf='undef'
d_longdbl='define'
d_longlong='define'
d_lseekproto='define'
d_lstat='undef'
d_madvise='undef'
d_mblen='define'
d_mbstowcs='define'
d_mbtowc='define'
d_memchr='define'
d_memcmp='define'
d_memcpy='define'
d_memmove='define'
d_memset='define'
d_mkdir='define'
d_mkdtemp='undef'
d_mkfifo='undef'
d_mknod='undef'
d_mkstemp='define'
d_mkstemps='undef'
d_mktime='define'
d_mmap='define'
d_modfl='undef'
d_modfl_pow32_bug='undef'
d_modflproto='undef'
d_mprotect='define'
d_msg='undef'
d_msg_ctrunc='undef'
d_msg_dontroute='undef'
d_msg_oob='undef'
d_msg_peek='undef'
d_msg_proxy='undef'
d_msghdr_s='undef'
d_msync='define'
d_munmap='define'
d_mymalloc='undef'
d_nanosleep='undef'
d_nice='define'
d_nl_langinfo='define'
d_nv_preserves_uv='define'
d_off64_t='undef'
d_old_pthread_create_joinable='undef'
d_oldarchlib='define'
d_oldpthreads='undef'
d_open3='define'
d_pathconf='define'
d_pause='define'
d_perl_otherlibdirs='undef'
d_phostname='undef'
d_pipe='define'
d_poll='undef'
d_procselfexe='undef'
d_pthread_atfork='undef'
d_pthread_attr_setscope='undef'
d_pthread_yield='undef'
d_pthreads_created_joinable='undef'
d_pwage='undef'
d_pwchange='undef'
d_pwclass='undef'
d_pwcomment='define'
d_pwexpire='undef'
d_pwgecos='define'
d_pwpasswd='define'
d_pwquota='undef'
d_qgcvt='undef'
d_quad='undef'
d_random_r='undef'
d_readdir64_r='undef'
d_readdir='define'
d_readdir_r='define'
d_readlink='undef'
d_readv='undef'
d_realpath='undef'
d_recvmsg='undef'
d_rename='define'
d_rewinddir='define'
d_rmdir='define'
d_safebcpy='undef'
d_safemcpy='define'
d_sanemcmp='define'
d_sbrkproto='define'
d_scalbnl='undef'
d_sched_yield='undef'
d_scm_rights='undef'
d_seekdir='define'
d_select='define'
d_sem='undef'
d_semctl_semid_ds='undef'
d_semctl_semun='undef'
d_sendmsg='undef'
d_setegid='undef'
d_setenv='define'
d_seteuid='undef'
d_setgrent='undef'
d_setgrent_r='undef'
d_setgrps='undef'
d_sethent='define'
d_sethostent_r='undef'
d_setitimer='define'
d_setlinebuf='undef'
d_setlocale='define'
d_setlocale_r='undef'
d_setnent='define'
d_setnetent_r='undef'
d_setpent='define'
d_setpgid='undef'
d_setpgrp2='undef'
d_setpgrp='undef'
d_setprior='undef'
d_setproctitle='undef'
d_setprotoent_r='undef'
d_setpwent='define'
d_setpwent_r='undef'
d_setregid='undef'
d_setresgid='undef'
d_setresuid='undef'
d_setreuid='undef'
d_setrgid='undef'
d_setruid='undef'
d_setsent='define'
d_setservent_r='undef'
d_setsid='undef'
d_setvbuf='define'
d_sfio='undef'
d_shm='undef'
d_shmatprototype='undef'
d_sigaction='define'
d_sigprocmask='define'
d_sigsetjmp='define'
d_sockatmark='undef'
d_sockatmarkproto='undef'
d_socket='define'
d_socklen_t='undef'
d_sockpair='undef'
d_socks5_init='undef'
d_sqrtl='define'
d_srand48_r='undef'
d_srandom_r='undef'
d_sresgproto='undef'
d_sresgproto='undef'
d_sresproto='undef'
d_sresuproto='undef'
d_statblks='undef'
d_statfs_f_flags='undef'
d_statfs_s='undef'
d_statfsflags='undef'
d_stdio_cnt_lval='define'
d_stdio_ptr_lval='define'
d_stdio_ptr_lval_nochange_cnt='define'
d_stdio_ptr_lval_sets_cnt='undef'
d_stdio_stream_array='undef'
d_stdiobase='define'
d_stdstdio='define'
d_strchr='define'
d_strcoll='define'
d_strctcpy='define'
d_strerrm='strerror((e),vaxc$errno)'
d_strerror='define'
d_strerror_r='undef'
d_strftime='define'
d_strtod='define'
d_strtol='define'
d_strtold='undef'
d_strtoll='define'
d_strtoq='define'
d_strtoul='define'
d_strtoull='define'
d_strtouq='define'
d_strxfrm='define'
d_suidsafe='undef'
d_symlink='undef'
d_syscall='undef'
d_syscallproto='undef'
d_sysconf='define'
d_syserrlst='undef'
d_system='define'
d_tcgetpgrp='undef'
d_tcsetpgrp='undef'
d_telldir='define'
d_telldirproto='define'
d_time='define'
d_times='define'
d_tm_tm_gmtoff='define'
d_tm_tm_zone='define'
d_tmpnam_r='undef'
d_truncate='define'
d_ttyname_r='undef'
d_tzname='define'
d_u32align='define'
d_ualarm='define'
d_umask='define'
d_uname='define'
d_union_semun='undef'
d_unlink_all_versions='undef'
d_unordered='undef'
d_usleep='define'
d_usleepproto='define'
d_ustat='undef'
d_vendorarch='undef'
d_vendorlib='undef'
d_vfork='define'
d_vms_case_sensitive_symbols='undef'
d_vms_do_sockets='define'
d_void_closedir='define'
d_volatile='define'
d_vprintf='define'
d_wait4='define'
d_waitpid='define'
d_wcstombs='define'
d_wctomb='define'
d_writev='undef'
db_hashtype=' '
db_prefixtype=' '
db_version_major=''
db_version_minor=''
db_version_patch=''
dbgprefix=''
defvoidused='15'
devtype='dev_t'
direntrytype='struct dirent'
dlext='exe'
dlobj='dl_vms.obj'
doublesize='8'
drand01='drand48()'
drand48_r_proto='0'
eagain=' '
ebcdic='undef'
embedmymalloc='undef'
endgrent_r_proto='0'
endhostent_r_proto='0'
endnetent_r_proto='0'
endprotoent_r_proto='0'
endpwent_r_proto='0'
endservent_r_proto='0'
eunicefix=':'
exe_ext='.exe'
extensions='attrs B Cwd Data/Dumper Devel/DProf Devel/Peek Devel/PPPort Digest/MD5 Encode Errno Fcntl File/Glob Filter/Util/Call I18N/Langinfo IO List/Util MIME/Base64 Opcode PerlIO/encoding PerlIO/scalar PerlIO/via POSIX re SDBM_File Socket Storable Sys/Hostname threads threads/shared Time/HiRes Unicode/Normalize XS/APItest XS/Typemap VMS/DCLsym VMS/Stdio'
fflushNULL='define'
fflushall='undef'
fpostype='fpos_t'
freetype='void'
full_ar=''
full_csh=' '
full_sed='_NLA0:'
gccversion=''
getgrent_r_proto='0'
getgrgid_r_proto='0'
getgrnam_r_proto='0'
gethostbyaddr_r_proto='0'
gethostbyname_r_proto='0'
gethostent_r_proto='0'
getlogin_r_proto='0'
getnetbyaddr_r_proto='0'
getnetbyname_r_proto='0'
getnetent_r_proto='0'
getprotobyname_r_proto='0'
getprotobynumber_r_proto='0'
getprotoent_r_proto='0'
getpwent_r_proto='0'
getpwnam_r_proto='0'
getpwuid_r_proto='0'
getservbyname_r_proto='0'
getservbyport_r_proto='0'
getservent_r_proto='0'
getspnam_r_proto='0'
gidformat='lu'
gidsign='1'
gidsize='4'
gidtype='gid_t'
gmtime_r_proto='0'
groupstype='Gid_t'
hint='none'
hintfile=''
i16size='2'
i16type='short'
i32size='4'
i32type='int'
i64size='undef'
i64type='long long'
i8size='1'
i8type='char'
i_arpainet='undef'
i_crypt='undef'
i_db='undef'
i_dbm='undef'
i_dirent='undef'
i_dlfcn='undef'
i_fcntl='define'
i_float='define'
i_fp='undef'
i_fp_class='undef'
i_grp='undef'
i_ieeefp='undef'
i_inttypes='define'
i_langinfo='define'
i_libutil='undef'
i_limits='define'
i_locale='define'
i_machcthr='undef'
i_machcthreads='undef'
i_math='define'
i_memory='undef'
i_mntent='undef'
i_ndbm='undef'
i_netdb='define'
i_neterrno='define'
i_netinettcp='define'
i_niin='define'
i_poll='undef'
i_prot='undef'
i_pthread='define'
i_pwd='undef'
i_rpcsvcdbm='undef'
i_sfio='undef'
i_sgtty='undef'
i_shadow='undef'
i_socks='undef'
i_stdarg='define'
i_stddef='define'
i_stdlib='define'
i_string='define'
i_sunmath='undef'
i_sysaccess='undef'
i_sysdir='undef'
i_sysfile='define'
i_sysioctl='define'
i_syslog='undef'
i_sysmman='undef'
i_sysmode='undef'
i_sysmount='undef'
i_sysndir='undef'
i_sysparam='undef'
i_sysresrc='undef'
i_syssecrt='undef'
i_sysselct='undef'
i_syssockio='undef'
i_sysstat='define'
i_sysstatfs='undef'
i_sysstatvfs='undef'
i_systime='undef'
i_systimek='undef'
i_systimes='undef'
i_systypes='define'
i_sysuio='define'
i_sysun='undef'
i_sysutsname='define'
i_sysvfs='undef'
i_syswait='undef'
i_termio='undef'
i_termios='undef'
i_time='define'
i_unistd='define'
i_ustat='undef'
i_utime='undef'
i_values='undef'
i_varargs='undef'
i_vfork='undef'
inc_version_list='0'
inc_version_list_init='0'
installbin='perl_root:[000000]'
installman1dir='perl_root:[man.man1]'
installman3dir='perl_root:[man.man3]'
installprefix='perl_root'
installprefixexp='perl_root:'
installscript='perl_root:[utils]'
installsitearch='perl_root:[lib.site_perl.VMS_AXP]'
installsitebin='perl_root:[bin.VMS_AXP]'
installsitelib='perl_root:[lib.site_perl]'
installusrbinperl='undef'
intsize='4'
ivdformat='"ld"'
ivsize='4'
ivtype='long'
known_extensions='attrs B ByteLoader Cwd Data/Dumper DB_File Devel/DProf Devel/Peek Devel/PPPort Digest/MD5 Encode Errno Fcntl File/Glob Filter/Util/Call GDBM_File I18N/Langinfo IO IPC/SysV List/Util MIME/Base64 NDBM_File ODBM_File Opcode PerlIO/encoding PerlIO/scalar PerlIO/via POSIX re SDBM_File Socket Storable Sys/Hostname Sys/Syslog Thread threads threads/shared Time/HiRes Unicode/Normalize XS/APItest XS/Typemap VMS/DCLsym VMS/Stdio'
ld='Link'
lddlflags='/Share'
ldflags='/NoTrace/NoMap'
lib_ext='.olb'
libc='(DECCRTL)'
localtime_r_proto='0'
longdblsize='16'
longlongsize='8'
longsize='4'
lseeksize='4'
lseektype='int'
mab=''
make='MMK'
malloctype='void *'
man1ext='rno'
man3ext='rno'
mmaptype='void *'
modetype='unsigned int'
multiarch='undef'
mydomain='.dciinc.org'
myhostname='unknown'
myuname='VMS unknown V7.2-1 AlphaStation 250 4/266'
need_va_copy='undef'
netdb_hlen_type='int'
netdb_host_type='char *'
netdb_name_type='char *'
netdb_net_type='long'
nv_preserves_uv_bits='32'
nveformat='"e"'
nvfformat='"f"'
nvgformat='"g"'
nvsize='8'
nvtype='double'
o_nonblock=' '
obj_ext='.obj'
old_pthread_create_joinable=' '
oldarchlib='perl_root:[lib.VMS_AXP]'
oldarchlibexp='perl_root:[lib.VMS_AXP]'
optimize='/NoList'
otherlibdirs=''
package='perl5'
pager='type/page=save=10'
patchlevel='8'
path_sep='|'
perl_root='THETIS$DKA100:[CRAIG.PERLBUILD584.PERL.]'
perl_symbol='TRUE'
perl_verb=''
perladmin='system'
perllibs=' '
perlpath='perl_root:[000000]Perl.exe'
pgflquota='400000'
pidtype='pid_t'
prefixexp='perl_root:'
privlib='perl_root:[lib]'
procselfexe=' '
prototype='define'
ptrsize='4'
quadkind='QUAD_IS_LONG'
quadtype='long'
randbits='31'
random_r_proto='0'
randseedtype='long int'
ranlib=''
rd_nodata=' '
readdir64_r_proto='0'
readdir_r_proto='REENTRANT_PROTO_I_TSR'
revision='5'
sPRIEldbl='"LE"'
sPRIFldbl='"LF"'
sPRIGldbl='"LG"'
sPRIX64='"lX"'
sPRId64=''
sPRIeldbl='"Le"'
sPRIfldbl='"Lf"'
sPRIgldbl='"Lg"'
sPRIo64=''
sPRIu64=''
sPRIx64=''
sSCNfldbl='"Lf"'
sched_yield=' '
scriptdir='perl_root:[utils]'
scriptdirexp='perl_root:[utils]'
seedfunc='srand48'
selectminbits='32'
selecttype='fd_set *'
setgrent_r_proto='0'
sethostent_r_proto='0'
setlocale_r_proto='0'
setnetent_r_proto='0'
setprotoent_r_proto='0'
setpwent_r_proto='0'
setservent_r_proto='0'
sh='MCR'
shmattype=' '
shortsize='2'
shrplib='define'
sig_name='ZERO HUP INT QUIT ILL TRAP IOT EMT FPE KILL BUS SEGV SYS PIPE ALRM TERM ABRT USR1 USR2'
sig_name_init='"ZERO","HUP","INT","QUIT","ILL","TRAP","IOT","EMT","FPE","KILL","BUS","SEGV","SYS","PIPE","ALRM","TERM","ABRT","USR1","USR2",0'
sig_num='0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 6 16 17'
sig_num_init='0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,6,16,17,0'
sig_size='19'
signal_t='void'
sitearch='perl_root:[lib.site_perl.VMS_AXP]'
sitearchexp='perl_root:[lib.site_perl.VMS_AXP]'
sitebin='perl_root:[bin.VMS_AXP]'
sitebinexp='perl_root:[bin.VMS_AXP]'
sitelib='perl_root:[lib.site_perl]'
sitelib_stem='perl_root:[lib.site_perl]'
sitelibexp='perl_root:[lib.site_perl]'
siteprefix='perl_root'
siteprefixexp='perl_root:'
sizesize='4'
sizetype='size_t'
socksizetype='unsigned int'
spitshell='write sys$output '
srand48_r_proto='0'
srandom_r_proto='0'
src='THETIS$DKA100:[CRAIG.PERLBUILD584.PERL.]'
ssizetype='int'
startperl="$ perl 'f$env(\"procedure\")' \"''p1'\" \"''p2'\" \"''p3'\" \"''p4'\" \"''p5'\" \"''p6'\" \"''p7'\" \"''p8'\"!\n$ exit++ + ++$status!=0 and $exit=$status=undef; while($#ARGV != -1 and $ARGV[$#ARGV] eq ''){pop @ARGV;}"
stdchar='char'
stdio_base='((*fp)->_base)'
stdio_bufsiz='((*fp)->_cnt + (*fp)->_ptr - (*fp)->_base)'
stdio_cnt='((*fp)->_cnt)'
stdio_ptr='((*fp)->_ptr)'
stdio_stream_array=' '
strerror_r_proto='0'
subversion='4'
timetype='time_t'
tmpnam_r_proto='0'
ttyname_r_proto='0'
u16size='2'
u16type='unsigned short'
u32size='4'
u32type='unsigned int'
u64size='undef'
u64type='unsigned long long'
u8size='1'
u8type='unsigned char'
uidformat='lu'
uidsign='1'
uidsize='4'
uidtype='uid_t'
uquadtype='unsigned long'
use5005threads='undef'
use64bitall='undef'
use64bitint='undef'
usecasesensitive='N'
usecrosscompile='undef'
usedebugging_perl='Y'
usedefaulttypes='undef'
usedl='define'
usefaststdio='define'
useieee='define'
useithreads='undef'
uselargefiles='undef'
uselongdouble='undef'
usemallocwrap='define'
usemorebits='undef'
usemultiplicity='undef'
usemymalloc='undef'
useperlio='define'
useposix='false'
usereentrant='undef'
usesecurelog='define'
usesocks='undef'
usethreads='undef'
usevendorprefix=''
usevfork='true'
usevmsdebug='undef'
uvXUformat='"lX"'
uvoformat='"lo"'
uvsize='4'
uvtype='unsigned long'
uvuformat='"lu"'
uvxformat='"lx"'
vendorarch=''
vendorarchexp=''
vendorbin=''
vendorbinexp=''
vendorlib=''
vendorlib_stem=''
vendorlibexp=''
vendorprefix=''
vendorprefixexp=''
version='5_8_4'
version_patchlevel_string='version 8 subversion 4'
vms_cc_type='decc'
vms_prefix='perl_root'
vms_ver='7.2'
voidflags='15'
!END!

# Search for it in the big string 
sub fetch_string {
    my($self, $key) = @_;

    my $quote_type = "'";
    my $marker = "$key=";

    # Check for the common case, ' delimited
    my $start = index($Config_SH, "\n$marker$quote_type");
    # If that failed, check for " delimited
    if ($start == -1) {
        $quote_type = '"';
        $start = index($Config_SH, "\n$marker$quote_type");
    }
    return undef if ( ($start == -1) &&  # in case it's first 
                      (substr($Config_SH, 0, length($marker)) ne $marker) );
    if ($start == -1) { 
        # It's the very first thing we found. Skip $start forward
        # and figure out the quote mark after the =.
        $start = length($marker) + 1;
        $quote_type = substr($Config_SH, $start - 1, 1);
    } 
    else { 
        $start += length($marker) + 2;
    }

    my $value = substr($Config_SH, $start, 
                       index($Config_SH, "$quote_type\n", $start) - $start);

    # If we had a double-quote, we'd better eval it so escape
    # sequences and such can be interpolated. Since the incoming
    # value is supposed to follow shell rules and not perl rules,
    # we escape any perl variable markers
    if ($quote_type eq '"') {
	$value =~ s/\$/\\\$/g;
	$value =~ s/\@/\\\@/g;
	eval "\$value = \"$value\"";
    }

    # So we can say "if $Config{'foo'}".
    $value = undef if $value eq 'undef';
    $self->{$key} = $value; # cache it
}

sub fetch_virtual {
    my($self, $key) = @_;

    my $value;

    if ($key =~ /^((?:cc|ld)flags|libs(?:wanted)?)_nolargefiles/) {
	# These are purely virtual, they do not exist, but need to
	# be computed on demand for largefile-incapable extensions.
	my $new_key = "${1}_uselargefiles";
	$value = $Config{$1};
	my $withlargefiles = $Config{$new_key};
	if ($new_key =~ /^(?:cc|ld)flags_/) {
	    $value =~ s/\Q$withlargefiles\E\b//;
	} elsif ($new_key =~ /^libs/) {
	    my @lflibswanted = split(' ', $Config{libswanted_uselargefiles});
	    if (@lflibswanted) {
		my %lflibswanted;
		@lflibswanted{@lflibswanted} = ();
		if ($new_key =~ /^libs_/) {
		    my @libs = grep { /^-l(.+)/ &&
                                      not exists $lflibswanted{$1} }
		                    split(' ', $Config{libs});
		    $Config{libs} = join(' ', @libs);
		} elsif ($new_key =~ /^libswanted_/) {
		    my @libswanted = grep { not exists $lflibswanted{$_} }
		                          split(' ', $Config{libswanted});
		    $Config{libswanted} = join(' ', @libswanted);
		}
	    }
	}
    }

    $self->{$key} = $value;
}

sub FETCH { 
    my($self, $key) = @_;

    # check for cached value (which may be undef so we use exists not defined)
    return $self->{$key} if exists $self->{$key};

    $self->fetch_string($key);
    return $self->{$key} if exists $self->{$key};
    $self->fetch_virtual($key);

    # Might not exist, in which undef is correct.
    return $self->{$key};
}
 
my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    substr($Config_SH, 0, index($Config_SH, '=') );
}

sub NEXTKEY {
    # Find out how the current key's quoted so we can skip to its end.
    my $quote = substr($Config_SH, index($Config_SH, "=", $prevpos)+1, 1);
    my $pos = index($Config_SH, qq($quote\n), $prevpos) + 2;
    my $len = index($Config_SH, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($Config_SH, $pos, $len) : undef;
}

sub EXISTS { 
    return 1 if exists($_[0]->{$_[1]});

    return(index($Config_SH, "\n$_[1]='") != -1 or
           substr($Config_SH, 0, length($_[1])+2) eq "$_[1]='" or
           index($Config_SH, "\n$_[1]=\"") != -1 or
           substr($Config_SH, 0, length($_[1])+2) eq "$_[1]=\"" or
           $_[1] =~ /^(?:(?:cc|ld)flags|libs(?:wanted)?)_nolargefiles$/
          );
}

sub STORE  { die "\%Config::Config is read-only\n" }
*DELETE = \&STORE;
*CLEAR  = \&STORE;


sub config_sh {
    $Config_SH
}

sub config_re {
    my $re = shift;
    return map { chomp; $_ } grep /^$re=/, split /^/, $Config_SH;
}

sub config_vars {
    foreach (@_) {
	if (/\W/) {
	    my @matches = config_re($_);
	    print map "$_\n", @matches ? @matches : "$_: not found";
	} else {
	    my $v = (exists $Config{$_}) ? $Config{$_} : 'UNKNOWN';
	    $v = 'undef' unless defined $v;
	    print "$_='$v';\n";
	}
    }
}

sub TIEHASH {
    bless $_[1], $_[0];
}

# avoid Config..Exporter..UNIVERSAL search for DESTROY then AUTOLOAD
sub DESTROY { }

my $i = 0;
foreach my $c (4,3,2) { $i |= ord($c); $i <<= 8 }
$i |= ord(1);
my $value = join('', unpack('aaaa', pack('L!', $i)));


tie %Config, 'Config', {
    'archlibexp' => 'perl_root:[lib.VMS_AXP.5_8_4]',
    'archname' => 'VMS_AXP',
    'cc' => 'CC/DECC',
    'ccflags' => '/Include=[]/Standard=Relaxed_ANSI/Prefix=All/Obj=.obj /NOANSI_ALIAS/float=ieee/ieee=denorm_results',
    'dlsrc' => 'dl_vms.c',
    'dynamic_ext' => 'attrs B Cwd Data/Dumper Devel/DProf Devel/Peek Devel/PPPort Digest/MD5 Encode Errno Fcntl File/Glob Filter/Util/Call I18N/Langinfo IO List/Util MIME/Base64 Opcode PerlIO/encoding PerlIO/scalar PerlIO/via POSIX re SDBM_File Socket Storable Sys/Hostname threads threads/shared Time/HiRes Unicode/Normalize XS/APItest XS/Typemap VMS/DCLsym VMS/Stdio',
    'installarchlib' => 'perl_root:[lib.VMS_AXP.5_8_4]',
    'installprivlib' => 'perl_root:[lib]',
    'libpth' => '/sys$share /sys$library',
    'libs' => ' ',
    'osname' => 'VMS',
    'osvers' => 'V7.2-1',
    'prefix' => 'perl_root',
    'privlibexp' => 'perl_root:[lib]',
    'so' => 'exe',
    'static_ext' => '',
    byteorder => $value,

};

1;
