/*****************************************************************************/
/*
                                CGIsym.c

Creates global symbols required by the WASD CGI interface.  Essentially this
performs exactly the same role as SET_DCL_ENV.C and CGI_SYMBOLS.C without the
CGILIB.C and SCRIPTLIB.C paraphernalia.  One execption is PATH_TRANSLATED where
OSU provides a Unix-style VMS equivalent path whereas WASD requires it in an
RMS format.  This program is not designed as a drop-in replacement for either
of the above utilities, it's scope is deliberately more limited, and is to
support the use of WASD scripts in the OSU environment.


PARAMETERS
----------
P1      HTTP method (e.g. GET, POST, etc.)
P2      path (URL-style)
P3      protocol (e.g. HTTP/1.0)


VERSION HISTORY (update 'SoftwareID' as well)
---------------
11-JAN-2001  MGD  v1.2.3, bugfix; CgiLibEnvironmentInit() should be
                          CgiLibOsuInit() to suppress OSU output headers
28-OCT-2000  MGD  v1.2.2, *no changes* for object variant of CGILIB
12-APR-2000  MGD  v1.2.1, minor changes for CGILIB 1.4
24-APR-1999  MGD  v1.1.0, use CGILIB.C
02-DEC-1998  MGD  v1.0.1, bugfix; elipsis wildcard for PATH_TRANSLATED
01-AUG-1998  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [48] = "CGISYM AXP-1.2.3";
#else
   char SoftwareID [48] = "CGISYM VAX-1.2.3";
#endif

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>

#include <descrip.h>
#include <libdef.h>
#include <libclidef.h>
#include <ssdef.h>
#include <stsdef.h>
#include <syidef.h>

#include <cgilib.h>

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define boolean int
#define true 1
#define false 0

char  Utility [] = "CGISYM";

boolean  Debug;

/* required prototypes */
char* QueryNetLink (char*, int);

/*****************************************************************************/
/*
*/

main
(
int argc,
char *argv[]
)
{
   register char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

   strcat (SoftwareID+15, " (");
   strcat (SoftwareID+15, CGILIB_SOFTWAREID);
   strcat (SoftwareID+15, ")");

   if (getenv ("CGISYM$DBUG") != NULL) Debug = true;
   CgiLibEnvironmentSetDebug (Debug);

   CgiLibOsuInit (argc, argv);

   /* now just assign a global symbol against each CGI variable in the list */
   while ((cptr = sptr = CgiLibVar("*")) != NULL)
   {
      while (*sptr && *sptr != '=') sptr++;
      if (*sptr) *sptr++ = '\0';
      AssignGlobalSymbol (cptr, sptr);
   }

   exit (SS$_NORMAL);
}  

/****************************************************************************/
/*
Assign a global symbol.  Symbol lengths are adjusted according to the maximum
allowed for the version of the operating system.
*/ 

AssignGlobalSymbol
(
char *SymbolName,
char *SymbolValue
)
{
   static int  GlobalSymbol = LIB$K_CLI_GLOBAL_SYM;
   static char  SyiVersion [16];
   static $DESCRIPTOR (SymbolNameDsc, "");
   static $DESCRIPTOR (SymbolValueDsc, "");

   static struct {
      short BufferLength;
      short ItemCode;
      void  *BufferPtr;
      void  *LengthPtr;
   }
   SyiItems [] =
   {
      { 8, SYI$_VERSION, &SyiVersion, 0 },
      { 0,0,0,0 }
   };

   int  status;

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "AssignGlobalSymbol() |%s|%s|\n",
               SymbolName, SymbolValue);

   if (!SyiVersion[0])
   {
      if (VMSnok (status =
          sys$getsyiw (0, 0, 0, &SyiItems, 0, 0, 0)))
         exit (status);
      SyiVersion[8] = '\0';
      if (Debug) fprintf (stdout, "SyiVersion |%s|\n", SyiVersion);
   }

   SymbolNameDsc.dsc$a_pointer = SymbolName;
   SymbolNameDsc.dsc$w_length = strlen(SymbolName);
   SymbolValueDsc.dsc$a_pointer = SymbolValue;
   SymbolValueDsc.dsc$w_length = strlen(SymbolValue);
   if (SymbolValueDsc.dsc$w_length > 255 && SyiVersion[1] <= '6')
      SymbolValueDsc.dsc$w_length = 255;
   else
   if (SymbolValueDsc.dsc$w_length > 1023)
      SymbolValueDsc.dsc$w_length = 1023;

   if (VMSnok (status =
       lib$set_symbol (&SymbolNameDsc, &SymbolValueDsc, &GlobalSymbol)))
      exit (status);
}

/*****************************************************************************/

