6 $	if f$type(omi$_debug) .eqs. "" then $ omi$_debug = 06 $	if .not. omi$_debug then $ omi$_verify = f$verify(0)* $	on control_y then $ goto main$_interrupt" $	on error then $ goto main$_fatal) $	on severe_error then $ goto main$_fatal  $	goto main$_start $!P $!******************************************************************************P $!*                                                                            *P $!*  FILENAME:                                                                 *P $!*  =========                                                                 *P $!*     Omi$Menu.Com       Oscar's Menu Interface                              *P $!*                                                                            *P $!* ************************************************************************** *P $!* *                                                                        * *P $!* * 1997 - 2004, Oscar van Eijk - Oveas Funtionality Provider             * *P $!* *   This tool is delivered as is, and has no warranties whatsoever.      * *P $!* *   It may be freely distributed as long as the distribution set is      * *P $!* *   complete. It is not allowed to change any of the files, without      * *P $!* *   permission of the author.                                            * *P $!* *                                                                        * *P $!* ************************************************************************** *P $!*                                                                            *P $!*  DESCRIPTION:                                                              *P $!*  ============                                                              *P $!*                                                                            *P $!*      Oscar's Menu Interface is a DCL procedure that reads menu files and   *P $!*      represents the menu structure on a ChUI based window.                 *P $!*                                                                            *P $!*      OMI does not perform any actions on its own. Additional procedures    *P $!*      are required to handle upon the users input. OMI is strictly created  *P $!*      to create a standard user interface for all kinds of actions, with a  *P $!*      clear structure, support for different security levels and password   *P $!*      protection.                                                           *P $!*                                                                            *P $!*      The additional procedures that are required for any actions are       *P $!*      referred to 'callable jobs'. A section in the help file describes     *P $!*      how several commands, defined in OMI, can be used to create such      *P $!*      procedures.                                                           *P $!*                                                                            *P $!*  FILES NEEDED:                                                             *P $!*  =============                                                             *P $!*     OMI$Config.COM        The procedure that sets up the configuration     *P $!*                           and the menu environments by reading the files   *P $!*                           and defining global symbols. On exit, this       *P $!*                           procedure also cleans up all symbols.            *P $!*     OMI$Screen.COM        All screen related material is handled by this   *P $!*                           procedure. The window and layout that's defined, *P $!*                           is based upon the settings by Omi$Config.Com.    *P $!*     OMI$Edit_Cmd.COM      This module, introduced in v1.3, handles all     *P $!*                           EDIT commands.                                   *P $!*     OMI$Calculator.COM    This module, introduced in v2.0, handles all     *P $!*                           calculations.                                    *P $!*     OMI$ToolBox.COM       A set of routines that will are called by OMI,   *P $!*                           but which are also available for OMI modules.    *P $!*                           Most OMI commands call routines from this        *P $!*                           procedure.                                       *P $!*     OMI$ToolBox.Ini       Initialisation file for the ToolBox. All         *P $!*                           that are available via the ToolBox should be     *P $!*                           added here. This file can also define additional *P $!*                           ToolBox files.                                   *P $!*     OMI$Library.OML       A standard library with some useful select lists *P $!*                           that can be included with the #INCLUDE directive.*P $!*     OMI$Menu.CFG          This is the configuration file in which  the     *P $!*                           layout can be defined, and many option of the    *P $!*                           behaviour can be changed. It should be located in*P $!*                           SYS$LOGIN of the current user. If not there,     *P $!*                           the procedure looks for the  file in OMI$.       *P $!*                           If the logical OMI$CONFIG is defined, this over- *P $!*                           writes all other files.                          *P $!*     OMI$Messages.DAT      This file contains all messages that can be      *P $!*                           signalled by OMI.                                *P $!*     <facil>$Messages.DAT  These files can be created for all facilities    *P $!*                           that have been created using OMI.                *P $!*     <file>.MNU            One or more MNU files can be created, containing *P $!*                           the menus. The procedure looks for the MNU files *P $!*                           in OMI$MENU_DIRECTORY, if set, and in OMI$       *P $!*     <file>.OMH            Each menu file can have an optional Help file,   *P $!*                           which is read by the INFO command to provide     *P $!*                           menu specific help.                              *P $!*                                                                            *P $!*  LOGICALS NEEDED:                                                          *P $!*  ================                                                          *P $!*     OMI$                  This logical points to the directory where this  *P $!*                           procedure, and its subprocedures, is located.    *P $!*                           It's also part of the search-path for the CFG    *P $!*                           file, and the MNU files. When not set, it's done *P $!*                           dynamically.                                     *P $!*     OMI$MENU_DIRECTORY    If set, this points to the default directory     *P $!*                           where all menu files are stored.                 *P $!*     OMI$CONFIG            This logical can point to the configuration file.*P $!*                           When it's not set, OMI looks for the file        *P $!*                           Omi$Menu.Cfg in SYS$LOGIN first, then in OMI$    *P $!*     OMI$STARTMENU         If defined, this is the menu file with which the *P $!*                           procedure starts.                                *P $!*                                                                            *P $!*  PARAMETERS NEEDED:                                                        *P $!*  ==================                                                        *P $!*     P1                    If this parameter is specified, it should point  *P $!*                           to the menu file to start with.                  *P $!*     P2 - P3               If specified, P2 contains the name of the menu   *P $!*                           which will be started first, and P3 selects an   *P $!*                           option in the specified menu.                    *P $!*                           If the parameters are used, P1 is required.      *P $!*                                                                            *P $!*  HISTORY:                                                                  *P $!*  ========                                                                  *P $!*     (For descriptions, refer to HISTORY.TXT)                               *P $!*     Version:  Date:       Author:                                          *P $!*     --------  -----       -------                                          *P $!*     0.0       11-03-1997  Oscar van Eijk, OVEAS                            *P $!*     1.0b1     14-03-1997  Oscar van Eijk, OVEAS                            *P $!*     1.0b2     15-04-1997  Oscar van Eijk, OVEAS                            *P $!*     1.0b3     09-05-1997  Oscar van Eijk, OVEAS                            *P $!*     1.0b4     13-05-1997  Oscar van Eijk, OVEAS                            *P $!*     1.0       30-05-1997  Oscar van Eijk, OVEAS                            *P $!*     1.1       21-06-1997  Oscar van Eijk, OVEAS                            *P $!*     1.2       10-09-1997  Oscar van Eijk, OVEAS                            *P $!*     1.3       19-11-1997  Oscar van Eijk, OVEAS                            *P $!*     1.4       19-02-1998  Oscar van Eijk, OVEAS                            *P $!*     1.41      01-05-1998  Oscar van Eijk, OVEAS                            *P $!*     2.0b1     10-11-1998  Oscar van Eijk, OVEAS                            *P $!*     2.0       22-06-1999  Oscar van Eijk, OVEAS                            *P $!*     2.1       25-08-2001  Oscar van Eijk, OVEAS                            *P $!*     2.2       29-08-2002  Oscar van Eijk, OVEAS                            *P $!*                           With thanks to Edward Vlak, EDS                  *P $!*     2.3       25-06-2004  Oscar van Eijk, OVEAS                            *P $!*                                                                            *P $!******************************************************************************  P $!****************************************************************************** $!G $!==>	These initials settings setup the menu environment by calling all & $!	proper subroutines and -procedures.0 $!	The first menu will allways be called 'menu'. $! $ main$_start: $! $	omi$option = "" % $	if f$type(omi$current_menu) .nes."" 	 $	   then 9 $		if f$edit(omi$current_menu, "upcase") .eqs. "OTF_MENU"  $		   then      $ $			'omi$current_menu'$previous = "" $			omi$otf_menu = 1- $			init_def$search_string = "otf_menu$input"  $			gosub main$default_values  $		endif# $		goto main$do_menu   ! Buggy ????  $	   else $ omi$otf_menu = 0 $	endif  $!) $	omi$_control = f$environment("control") ) $	omi$_message = f$environment("message")  $	gosub main$_parse_options ' $	if f$type(omi$validate_mode) .eqs. "" ! $	   then $ omi$validate_mode = 0  $	   else $ omi$batch_mode = 1 $	endif @ $	if f$type(omi$backgr_mode) .eqs. "" then $ omi$backgr_mode = 0> $	if f$type(omi$batch_mode) .eqs. "" then $ omi$batch_mode = 0 $	if omi$batch_mode 	 $	   then  $		ws := "!"
 $		cls := "!" 	 $	   else  $		ws := "write sys$output"  $		cls := "type/page nla0:"  $	endif  $	omi$version = "2.3" 3 $	if f$trnlnm("omi$menu_directory") .eqs. "" then - + 	   $ define /nolog omi$menu_directory omi$  $	gosub main$_initialize $	gosub main$_getstart $	if omi$backgr_mode	 $	   then  $		omi$_jumping = 1  $		options$_menuname  = "main" $		options$_jumps  = "Exit" 3 $		omi$menu_file = "Omi$:Omi$Background_Module.Mnu" - $		omi$background_module = "''omi$startmenu'" . $	   else $ omi$menu_file = "''omi$startmenu'" $	endif  $! $ main$_startmenu: $! $	omi$signal omi init  $	omi$config 'omi$menu_file  $	omi$status = $status $	omi$cmdline_clear ! $	if omi$status .eq. omi$_warning 	 $	   then  $! $	 main$_askfor_start: $!; $		read /end_of_file=main$_exit sys$command omi$startmenu - 4 		   /prompt="''screen$prompt_position'Menu file: "  $		omi$cmdline_clear $		omi$msgline_clear! $		omi$variable = "omi$startmenu"  $		omi$input_validate  $		if $status .ge. omi$_warning 
 $		   then $			omi$signal omi tranerr $			goto main$_askfor_start  $		endif% $		omi$menu_file = "''omi$startmenu'"  $		goto main$_startmenu  $	endif 7 $	if omi$status .eq. omi$_error then $ goto main$_fatal  $	omi$current_menu = "menu" " $	'omi$current_menu'$previous = ""# $	init_def$search_string = "$input"  $	omi$setting_defaults = 1 $	gosub main$default_values - $	deletee /symbol /local omi$setting_defaults  $	gosub main$check_security - $	if 'omi$current_menu'$security_level .lt. 0 	 $	   then 6 $		if 'omi$current_menu'$security_level .eq. -1 then - 		   $ omi$signal omi ivpwd  $		goto main$_interrupt  $	endif - $	if 'omi$current_menu'$security_level .eq. 0 	 $	   then  $		omi$signal omi nomnuauth  $		goto main$_interrupt  $	endif  $! $	if omi$validate_mode	 $	   then . $		if 'omi$current_menu'$security_level .lt. 3" $		   then $ omi$signal omi nopriv/ $		   else $ omi$config 'omi$menu_file validate  $		endif $		goto main$_exit $	endif  $! $	omi$msgline_clear  $! $	omi$signal omi info  $	if options$_menuname .nes. "" 	 $	   then  $		omi$_jumping = 1  $		omi$_p1 = options$_menuname $		jump$_norefresh = 1 $		gosub main$execcmd_jump $	   else $ omi$_jumping = 0 $	endif  $	options$_jumpcounter = 0 $	goto main$do_menu  $!P $!******************************************************************************  P $!****************************************************************************** $!I $!==>	We've found and initialized a menu. Display it, and start prompting , $!	the user to navigate through the options. $! $ main$do_menu:  $!E $	if f$type('omi$current_menu'$on_init) .nes. "" .and. perf$init_exit 	 $	   then ? $		omi$init_job = f$element(0, " ", 'omi$current_menu'$on_init) 6 $		_params = 'omi$current_menu'$on_init - omi$init_job6 $  !!!		omi$init_job  = f$parse(omi$init_job,".OMI", -0    !!!		   "OMI$Menu_Directory:",,"syntax_only") $  		if .not. omi$_debug then - D 		   $ set message /nofacility /noseverity /noidentification /notext  $  !!!		@'omi$init_job '_params'% $  		omi$call 'omi$init_job '_params'  $		if $status .eq. omi$_warning 
 $		   then $			perf$init_exit = 0 $			set message 'omi$_message  $			goto option$cancel_input $		endif $		set message 'omi$_message $	endif  $	omi$screen menu  $! $ main$get_option: $!7 $	'omi$current_menu'$highest_item = inputs$highest_item  $	perf$init_exit = 18 $	if (f$type('omi$current_menu'$prompt) .eqs. "" .and. -: 	   f$type(menu$prompt) .eqs. "") .or. main$protect_prompt. $	   then $ _current_prompt = questions$option	 $	   else 0 $		if f$type('omi$current_menu'$prompt) .eqs. ""* $		   then $ _current_prompt = menu$prompt8 $		   else $ _current_prompt = 'omi$current_menu'$prompt $		endif $	endif  $!$ $	omi$prompt_timeout = "/notime_out"5 $	if f$type('omi$current_menu'$auto_refresh) .nes. "" 	 $	   then - $		_timeout = 'omi$current_menu'$auto_refresh , $		if _timeout .gt. 0 .and _timeout .le. 255
 $		   then0 $			omi$prompt_timeout = "/time_out=''_timeout'"/ $			omi$prompt_timeout = omi$prompt_timeout + -  			   "/error=main$do_menu"  $		endif $	endif  $! $	if omi$_jumping 	 $	   then B $		omi$option = f$element(options$_jumpcounter,",",options$_jumps)3 $		if omi$option .eqs. "" .or. omi$option .eqs. "," 
 $		   then@ $			read /end_of_file=option$cancel_input 'omi$prompt_timeout' -> 			   /prompt="''screen$prompt_position'''_current_prompt' " - 			   sys$command omi$option. $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh $			omi$_jumping = 0< $		   else $ options$_jumpcounter = options$_jumpcounter + 1 $		endif	 $	   else ? $		read /end_of_file=option$cancel_input 'omi$prompt_timeout' - = 		   /prompt="''screen$prompt_position'''_current_prompt' " -  		   sys$command omi$option  $	endif  $	omi$variable = "omi$option"  $	omi$input_validate $	if $status .ge. omi$_warning	 $	   then  $		omi$signal omi tranerr  $		omi$cmdline_clear $		goto main$get_option  $	endif  $	omi$cmdline_clear  $	omi$msgline_clear 4 $	if omi$option .eqs. "" then $ goto main$get_option $!- $	if 'omi$current_menu'$security_level .eq. 1 	 $	   then  $		omi$signal omi notauth  $		goto main$get_option  $	endif  $!' $	if f$type(omi$option) .eqs. "INTEGER" 	 $	   then 7 $		if omi$option .eq. 0 then $ goto option$cancel_input : $		if f$type('omi$current_menu'$item'omi$option') .eqs. ""
 $		   then- $			_input = omi$option - inputs$highest_item 8 $			if f$type('omi$current_menu'$input'_input') .eqs. "" $			   then  $				omi$signal omi invopt $				goto main$get_option  $			   else  $				gosub main$askfor_input $				goto main$get_option 	 $			endif  $		endif $		goto main$option_eval $	endif  $!- $	omi$_command = f$edit(omi$option, "upcase") B $	if f$extract(0, 1, f$edit(omi$_command, "trim")) .eqs "$" then -2 	   $ omi$_command = "DCL " + (omi$_command - "$") $	gosub main$omi_command. $ !	if f$type(omi$previous_menu_file) .nes. "" $ !	   then 0 $ !		deletee/symbol/local omi$previous_menu_file $ !		goto main$_startmenu 	 $ !	endif  $	goto main$get_option $! $ option$cancel_input: $! $	gosub main$perf_onexit: $	if $status .eq. omi$_warning then $ goto main$get_option+ $	if omi$otf_menu then $ goto main$otf_exit  $!) $	if 'omi$current_menu'$previous .eqs. "" 	 $	   then @ $		if f$type(omi$option) .eqs. "INTEGER" .and. omi$option .eq. 0
 $		   then $			omi$signal omi toplevel  $			goto main$get_option $		endif $		goto main$_exit $	endif  $!0 $	omi$current_menu = 'omi$current_menu'$previous $	omi$cmdline_clear  $	omi$msgline_clear  $	goto main$do_menu  $!P $!******************************************************************************  P $!****************************************************************************** $!F $!==>	Check to see if an On_Exit job is defined for this menu. If so, @ $!	execute if (if the execute bit PERF$INIT_EXIT is set to true)C $!	and return the status. If there was an error or warning, set the ? $!	execute bit to false, to make sure the INIT procedure is not  $!	executed again. $! $ main$perf_onexit:  $! $	_status = omi$_ok E $	if f$type('omi$current_menu'$on_exit) .nes. "" .and. perf$init_exit 	 $	   then L $		if f$extract(0,1,f$edit('omi$current_menu'$on_exit,"collapse")) .eqs. ":"
 $		   thenS $			omi$_command = f$edit('omi$current_menu'$on_exit - ":", "trim,compress,upcase")  $			gosub main$omi_command $			_status = $status  $			goto main$perfd_onexit $		endif? $		omi$exit_job = f$element(0, " ", 'omi$current_menu'$on_exit) 6 $		_params = 'omi$current_menu'$on_exit - omi$exit_job6 $ !!! 		omi$exit_job  = f$parse(omi$exit_job,".OMI", -0   !!! 		   "OMI$Menu_Directory:",,"syntax_only")B $ !!!		if f$locate(".",omi$exit_job) .eq. f$length(omi$exit_job) -5   !!!		   then $ omi$exit_job = omi$exit_job + ".OMI"  $		if .not. omi$_debug then - D 		   $ set message /nofacility /noseverity /noidentification /notext $ !!!		@'omi$exit_job '_params' # $		omi$call 'omi$exit_job '_params'  $		_status = $status $		set message 'omi$_message $	endif  $! $  main$perfd_onexit:  $! $	perf$init_exit = 0 $	return _status $!P $!******************************************************************************  P $!****************************************************************************** $!G $!==>	If the current menu contains input options, this routine asks the  $!	user for input. $! $ main$askfor_input: $!7 $	if f$type('omi$current_menu'$required_order) .nes. "" 	 $	   then ! $		gosub input$validate_req_order 0 $		if $status .ne. omi$_ok then $ return $status $	endif  $! $	_all_inputs = 0 ? $	_variable = f$element(1,"#",'omi$current_menu'$input'_input')  $!< $	if f$extract(0,5,f$edit(_variable,"upcase")) .eqs. "{TAG|"	 $	   then  $		gosub main$_taglist $		return omi$_ok  $	endif  $!2 $	_sel_list = (f$extract(0,1,_variable) .eqs. "{") $! $	if _sel_list	 $	   then G $		_select_list = f$extract(0, f$locate("}", _variable) + 1, _variable) ' $		_variable = _variable - _select_list ? $		_select_list = f$edit(_select_list,"upcase") - "{SEL|" - "}" . $		if f$type('_select_list'$filename) .nes. ""
 $		   then $			_blockname = _select_list  $			gosub input$_from_file1 $			if $status .ne. omi$_ok then $ return $status  $		endif $		omi$screen select_list  $	endif  $! $ input$_prompt: $!) $	if f$type(list$_scroll) .nes. "" then - ) 	   $ deletee /symbol /local list$_scroll  $!@ $	_format = f$element(3, "#", 'omi$current_menu'$input'_input') - $	if _format .nes. "" .and. _format .nes. "#" 	 $	   then > $		if f$edit('_format'$type, "upcase") .eqs. "TEXTAREA" then - 		   $ goto input$dont_ask $	endif  $! $	if omi$_jumping 	 $	   then C $		'_variable' = f$element(options$_jumpcounter,",",options$_jumps) 5 $		if '_variable' .eqs. "" .or. '_variable' .eqs. "," 
 $		   thenx $			read /end_of_file=input$cancel_input /prompt="''screen$prompt_position'''questions$input': " sys$command '_variable'. $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh $			omi$_jumping = 0 $			omi$msgline_clear < $		   else $ options$_jumpcounter = options$_jumpcounter + 1 $		endif	 $	   else w $		read /end_of_file=input$cancel_input /prompt="''screen$prompt_position'''questions$input': " sys$command '_variable'  $		omi$msgline_clear $	endif  $! $	omi$variable = "''_variable'"  $	omi$input_validate $	if $status .ge. omi$_warning	 $	   then  $		omi$signal omi tranerr  $		omi$cmdline_clear $		goto input$_prompt  $	endif  $! $ input$dont_ask:  $!- $	if _format .nes. "" .and. _format .nes. "#" 	 $	   then  $		gosub input$_format $		_status = $status $		omi$cmdline_clear3 $		if _status .eq. omi$_error then $ return _status  $		if _status .eq. omi$_warning 
 $		   then. $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh $			omi$_jumping = 0 $			goto input$_prompt $		endifA $		if f$type('_variable') .eqs. "" then $ goto input$cancel_input  $	endif  $	if _sel_list	 $	   then = $		if f$edit(f$extract(0, 1, '_variable'),"upcase") .eqs. "N" 
 $		   then& $			deletee /symbol /local '_variable' $			list$_scroll = "NEXT"  $			omi$screen select_list $			omi$cmdline_clear  $			goto input$_prompt $		endif= $		if f$edit(f$extract(0, 1, '_variable'),"upcase") .eqs. "P" 
 $		   then& $			deletee /symbol /local '_variable' $			list$_scroll = "PREVIOUS"  $			omi$screen select_list $			omi$cmdline_clear  $			goto input$_prompt $		endif $		_selected = '_variable'' $		if f$type(_selected) .nes. "INTEGER" 
 $		   then $			omi$signal omi ivchoice  $			omi$cmdline_clear . $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh* $			if f$type('_variable') .nes. "" then - 			   $ '_variable' = "" $			omi$_jumping = 0 $			goto input$_prompt $		endif6 $		if f$type('_select_list'$value'_selected') .eqs. ""
 $		   then $			omi$signal omi ivchoice  $			omi$cmdline_clear . $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh* $			if f$type('_variable') .nes. "" then - 			   $ '_variable' = "" $			omi$_jumping = 0 $			goto input$_prompt $		endif0 $		'_variable' = '_select_list'$value'_selected', $		if f$extract(0, 1, '_variable') .eqs. "{"
 $		   then% $			_prompt = '_variable' - "{" - "}"  $! $		 sellist$get_free_input:  $! $			omi$cmdline_clear p $			read /end_of_file=input$cancel_input /prompt="''screen$prompt_position'''_prompt': " sys$command '_variable'! $			omi$variable = "''_variable'"  $			omi$input_validate  $			if $status .ge. omi$_warning $			   then  $				omi$signal omi tranerr   $				goto sellist$get_free_input	 $			endif  $		endif2 $		if f$type(scroll$previous_page) .nes. "" then -1 		   $ deletee/symbol/global scroll$previous_page . $		if f$type(scroll$this_page) .nes. "" then -- 		   $ deletee/symbol/global scroll$this_page . $		if f$type(scroll$next_page) .nes. "" then -- 		   $ deletee/symbol/global scroll$next_page 0 $		if f$type(scroll$max_on_page) .nes. "" then -/ 		   $ deletee/symbol/global scroll$max_on_page  $		omi$refresh $	endif * $	_line = inputs$first_line - 1 + '_input' $	_value = '_variable' $! $	_display_value = _value L $	if f$locate("''CR$'", _display_value) .lt. f$length(_display_value) then -I 	   $ _display_value = f$extract(0, f$locate("''CR$'", _display_value), - + 	   _display_value) + "''ESC$'(0d''ESC$'(B" : $	_blanks = inputs$max_size - f$length(_display_value) + 12 $	if f$length(_display_value) .le. inputs$max_size` $	   then $ ws f$fao("''ESC$'[''_line';''inputs$value_location'H''_display_value'!''_blanks'* ")| $	   else $ ws "''ESC$'[''_line';''inputs$value_location'H''f$extract(0,inputs$max_size,_display_value)'''ESC$'(0`''ESC$'(B" $	endif  $! $	omi$cmdline_clear  $!	omi$msgline_clear $	return omi$_ok $! $ input$validate_req_order:  $!? $	if f$locate(_input, 'omi$current_menu'$required_order) .eq. - E 	   f$length('omi$current_menu'$required_order) then $ return omi$_ok  $!= $	if f$type('omi$current_menu'$reqwork_order) .eqs. "" then - * 	   $ 'omi$current_menu'$reqwork_order = -9 	   f$edit('omi$current_menu'$required_order, "collapse")  $!P $	_remember_work_order_list = 'omi$current_menu'$reqwork_order ! Reset on Ctrl/Z $! $! Added by Edward Vlak:D $	if 'omi$current_menu'$reqwork_order .eqs. "" then $ return omi$_ok $!2 $	if 'omi$current_menu'$reqwork_order .eqs. _input	 $	   then ( $		'omi$current_menu'$reqwork_order = "" $		return omi$_ok  $	endif  $!G $	if f$element(0, ",", 'omi$current_menu'$reqwork_order) .nes. _input - ' 	   then $ goto input$invalid_req_order I $	'omi$current_menu'$reqwork_order = 'omi$current_menu'$reqwork_order - -  	   "''_input'" - ","  $	return omi$_ok $! $ input$invalid_req_order: $!
 $	_cnt = 0 $	_msg_string = "" $! $ inv_req_ord$_msg_string: $!F $	_opt_first = f$element (_cnt, ",", 'omi$current_menu'$reqwork_order)` $	if (_opt_first .eq. _input) .or. (_opt_first .eqs. ",") then $ goto inv_req_ord$end_msg_string/ $	_opt_first = _opt_first + inputs$highest_item . $	_msg_string = _msg_string + "''_opt_first'/" $	_cnt = _cnt + 1  $	goto inv_req_ord$_msg_string $! $ inv_req_ord$end_msg_string:  $!B $	_msg_string = f$extract(0, f$length(_msg_string)-1, _msg_string)$ $	omi$signal omi ivorder,_msg_string $	return $status $! $ input$cancel_input:  $!/ $	if f$type(_remember_work_order_list) .nes. "" 	 $	   then ? $		'omi$current_menu'$reqwork_order = _remember_work_order_list 4 $		deletee /symbol /global _remember_work_order_list $	endif  $! $	if _sel_list $	   then $ omi$refresh 	 $	   else  $		omi$cmdline_clear $		omi$msgline_clear $	endif  $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!E $!==>	An input is selected that requires values to be read from file. H $!	This can be a TAG or SELECT list. The 'filename' argument in the list> $!	block contains the filename that should contain the values. $! $ input$_from_file:  $!E $!*** F$Parse translates to the first level of a search list only :-(  $!M $!	_values_file = f$parse('_blockname'$filename,"Omi$Menu_Directory:",".dat") 0 $	_values_file = f$search('_blockname'$filename)! $	if _values_file .eqs. "" then - J 	   $ _values_file = f$search("Omi$Menu_Directory:"+'_blockname'$filename)! $	if _values_file .eqs. "" then - < 	   $ _values_file = f$search("Omi$:"+'_blockname'$filename) $	if _values_file .eqs. ""	 $	   then 1 $		omi$signal omi novalfile,'_blockname'$filename  $		return $status  $	endif  $!G $	open /read /share=write /error=valfile$_openerr valfile '_values_file  $	_value_cnt = 1 $! $ valfile$_get_values: $!, $	read /end_of_file=valfile$end_get_values -* 	   valfile '_blockname'$value'_value_cnt' $	_value_cnt = _value_cnt + 1  $	goto valfile$_get_values $! $ valfile$end_get_values:  $! $	close valfile  $! $ valfile$_clear_values: $!? $! Cleanup symbols in case the file got shorter since last call  $!L $	if f$type('_select_list'$value'_value_cnt') .eqs. "" then $ return omi$_ok9 $	deletee /symbol /local '_select_list'$value'_value_cnt'  $	_value_cnt = _value_cnt + 1  $	goto valfile$_clear_values $! $ valfile$_openerr:  $!$ $	if f$search(_values_file) .eqs. ""	 $	   then * $		omi$signal omi valopenerr,'_values_file $		return $status  $	endif  $!P $!******************************************************************************  P $!****************************************************************************** $!M $!==>	The 4th argument of the input item in the menu file can specify a block 2 $!	that will be called here for string formatting.
 $!	The string  $! $ input$_format: $!$ $	if f$type('_format'$type) .eqs. ""	 $	   then % $		omi$signal omi nofrmtype,'_format'  $		return omi$_error $	endif - $	on warning then $ goto input$invalid_format  $	if .not. omi$_debug then -C 	   $ set message /nofacility /noseverity /noidentification /notext 8 $	_req_format = f$edit('_format'$type,"collapse,upcase")! $	goto input$'_req_format'_format  $!P $!****************************************************************************** $! $!==>	Validate the STRING type $! $ input$string_format: $!/ $	if f$type('_variable') .nes. "STRING" .and. - . 	   f$type('_variable') .nes. "INTEGER" then - 	   $ goto input$invalid_format  $!& $	if f$type('_format'$upcase) .eqs. "" $	   then $ _upcase = "false" 	 $	   else  $		if '_format'$upcase $		   then $ _upcase = "true"  $		   else $ _upcase = "false" $		endif $	endif  $!) $	if f$type('_format'$lowercase) .eqs. ""   $	   then $ _lowercase = "false"	 $	   else  $		if '_format'$lowercase   $		   then $ _lowercase = "true"! $		   else $ _lowercase = "false"  $		endif $	endif  $!? $!	The "BLANKS" setting is pretty inconsequent; if set to TRUE,  $!	blanks will be removed...@ $!	This one will remain in here for backwards compatibility, but? $!	the keyword will be replaced (and overwritten!!) by COLLAPSE  $!& $	if f$type('_format'$blanks) .eqs. "" $	   then $ _collapse = "false" 	 $	   else  $		if '_format'$blanks $		   then $ _collapse = "true"   $		   else $ _collapse = "false" $		endif $	endif  $!= $!	COLLAPSE keyword replaces he BLANKS keyword, OvE, 20040315  $!( $	if f$type('_format'$collapse) .eqs. ""	 $	   then ? $		! Only overwrite if the obsolete keyword BLANKS was not used . $		if f$type('_format'$blanks) .eqs. "" then - 			$ _collapse = "false"	 $	   else  $		if '_format'$collapse $		   then $ _collapse = "true"   $		   else $ _collapse = "false" $		endif $	endif  $!A $	if _upcase    then $ '_variable' = f$edit('_variable',"upcase") D $	if _lowercase then $ '_variable' = f$edit('_variable',"lowercase")C $	if _collapse  then $ '_variable' = f$edit('_variable',"collapse")  $!) $	if f$type('_format'$minlength) .nes. "" 	 $	   then ? $		if f$length('_variable') .lt. f$integer('_format'$minlength) 
 $		   then $			on warning then $ continue $			set message 'omi$_message'/ $			omi$signal omi tooshort,'_format'$minlength  $			return omi$_warning  $		endif $	endif  $!) $	if f$type('_format'$maxlength) .nes. "" 	 $	   then ? $		if f$length('_variable') .gt. f$integer('_format'$maxlength) 
 $		   then $			on warning then $ continue $			set message 'omi$_message'. $			omi$signal omi toolong,'_format'$maxlength $			return omi$_warning  $		endif $	endif  $!' $	if f$type('_format'$alfanum) .nes. "" 	 $	   then  $		if '_format'$alfanum then -  < 		   $ '_format'$ivchars = "`'~^!?@#$%&* -+=(){}[]<>:;,.\|/" $	endif D $	if f$type('_format'$ivchars) .eqs. "" then $ goto input$end_format $!
 $	_char_c = 0  $! $ format$stringchars:  $!2 $	_char = f$extract(_char_c, 1, '_format'$ivchars)< $	if f$locate(_char, '_variable') .lt. f$length('_variable')	 $	   then  $		on warning then $ continue  $		set message 'omi$_message'  $		omi$signal omi ivchar,_char $		return omi$_warning $	endif  $! $	_char_c = _char_c + 1 L $	if _char_c .lt. f$length('_format'$ivchars) then $ goto format$stringchars $	goto input$end_format  $!P $!****************************************************************************** $!  $!==>	Validate the FILESPEC type $! $ input$filespec_format: $!H $	if f$type('_variable') .nes. "STRING" then $ goto input$invalid_format $!) $	if f$type('_format'$wildcards) .eqs. ""e $	   then $ _allow_wc = "false"f	 $	   else_ $		if '_format'$wildcardsf $		   then $ _allow_wc = "true"   $		   else $ _allow_wc = "false" $		endif $	endift $!= $	if .not. _allow_wc .and. (f$locate("%", '_variable') .lt. - @ 	   f$length('_variable') .or. f$locate("*", '_variable') .lt. - 	   f$length('_variable'))	 $	   then  $		on warning then $ continue  $		set message 'omi$_message'! $		omi$signal omi nowildcard $		return omi$_warning $	endif  $!5 $	'_variable' = f$edit('_variable',"upcase,collapse")  $! $	_storformsg = '_variable' 
 $	_parse = ""$' $	if f$type('_format'$fdevice) .nes. "" 	 $	   then . $		'_format'$fdevice = '_format'$fdevice - ":", $		_parse = _parse + '_format'$fdevice + ":" $	endif** $	if f$type('_format'$fdirectory) .nes. ""	 $	   then*: $		'_format'$fdirectory = '_format'$fdirectory - "[" - "]"7 $		 _parse = _parse  + "[" + '_format'$fdirectory + "]"0 $	endif % $	if f$type('_format'$ftype) .nes. "" 	 $	   then** $		'_format'$ftype = '_format'$ftype - "."* $		_parse = _parse + "." + '_format'$ftype $	endifm0 $	'_variable' = f$parse('_variable',"''_parse'") $! $	if '_variable' .eqs. ""p	 $	   then  $		on warning then $ continuee& $		omi$signal omi ivfnam,'_storformsg' $		return omi$_warning $	endif  $!( $	if f$type('_format'$required) .eqs. "" $	   then $ _existreq = "false" 	 $	   else  $		if '_format'$required $		   then $ _existreq = "true"*  $		   else $ _existreq = "false" $		endif $	endif  $! $	if _existreq	 $	   then  $		_excheck = '_variable' @ $		if f$extract(f$length(_excheck) - 1, 1, _excheck) .eqs. "]" -' 		   then $ _excheck = _excheck + "*.*"=! $		if f$search(_excheck) .eqs. "" 
 $		   then $			on warning then $ continue $			set message 'omi$_message'" $			omi$signal omi fnf,'_variable' $			return omi$_warning  $		endif $	endifp $	goto input$end_formatf $!P $!****************************************************************************** $! $!==>	Validate the INTEGER type  $! $ input$integer_format:  $!% $	if f$type('_format'$float) .eqs. ""o	 $	   thenn
 $		_float = 0s* $		_float_point = "" !Added by Edward Vlak	 $	   else  $		_float = '_format'$floatt, $		if f$type('_format'$float_point) .eqs. "", $		   then $ _float_point = main$float_point1 $		   else $ _float_point = '_format'$float_pointr $		endif $	endifu $! $	if _floata	 $	   then 8 $		_whole = f$element(0, "''_float_point'", '_variable')) $		_tmp = '_variable' - "''_float_point'" 	 $	   else  $		_whole = '_variable'  $		_tmp = '_variable'  $	endifTB $	if f$type(_tmp) .nes. "INTEGER" then $ goto input$invalid_format $!# $	if f$type('_format'$min) .nes. "" 	 $	   thenn $		if _whole .lt. '_format'$min!
 $		   then $			on warning then $ continue $			set message 'omi$_message'' $			omi$signal omi lowval,'_format'$min  $			return omi$_warning  $		endif $	endif! $!# $	if f$type('_format'$max) .nes. "" 	 $	   then  $		if _whole .gt. '_format'$maxL
 $		   then $			on warning then $ continue $			set message 'omi$_message'& $			omi$signal omi hival,'_format'$max $			return omi$_warning  $		endif $	endif  $!< $	if _float .and. f$locate(_float_point, '_variable') .eq. -  	   f$length('_variable') then -4 	   $ '_variable' = '_variable' + "''_float_point'0" $! $	goto input$end_format  $!P $!****************************************************************************** $!  $!==>	Validate the DATETIME type $! $ input$datetime_format: $!# $	omi$signal omi notyet,_req_format  $	goto input$end_format! $!P $!****************************************************************************** $!  $!==>	Validate the TEXTAREA type $! $ input$textarea_format: $! $	on warning then $ continue( $	if f$type('_format'$filename) .nes. "") $	   then $ _ta_file = '_format'$filename > $	   else $ _ta_file = "ta_''omi$current_menu'$input''_input'" $	endifr= $	_ta_file = f$parse(_ta_file, "Omi$Menu_Directory:", ".txt")  $!% $	if f$type('_format'$large) .eqs. ""  $	   then $ _ta_max_size = 255	 $	   elseM $		if '_format'$largee  $		   then $ _ta_max_size = 1024 $		   else $ _ta_max_size = 255  $		endif $	endif  $!' $	if f$type('_format'$history) .eqs. ""   $	   then $ _ta_keep_history = 0	 $	   elsea $		if '_format'$history ! $		   then $ _ta_keep_history = 1 ! $		   else $ _ta_keep_history = 0  $		endif $	endif  $!$ $	if f$type('_format'$keep) .eqs. "" $	   then $ _ta_keep_file = 0 	 $	   else  $		if '_format'$keep $		   then $ _ta_keep_file = 1 $		   else $ _ta_keep_file = 0 $		endif $	endifd $! $	if .not. _ta_keep_file	 $	   theni& $		if f$type(ta$remove_files) .eqs. ""' $		   then $ ta$remove_files = _ta_file ? $		   else $ ta$remove_files = ta$remove_files + "," + _ta_filee $		endif $		_ta_keep_history = 0  $	endif  $!* $	if f$type(omi$setting_defaults) .eqs. ""	 $	   then ) $		if f$search(_ta_file) .eqs. "" .and. -o' 		   '_variable' .nes. main$empty_value 
 $		   then% $			open /write ta_default '_ta_file'd  $			write ta_default '_variable' $			close ta_default $		endif $		assign /user TT: sys$inputc $		'main$editor' '_ta_file# $		if .not. _ta_keep_history then -uD 		   $ purgee /nolog /keep=1 /noconfirm 'f$element(0, ";", _ta_file) $		omi$refresh $		gosub textarea$_readfile  $	endif  $	goto input$end_formatl $! $ textarea$_readfile:s $!= $	if f$search(_ta_file) .eqs. "" then $ goto textarea$_nofile C $	open /read /share=write t_area '_ta_file' /error=textarea$_lockedi7 $	read /end_of_file=textarea$_nofile t_area '_variable' % $	_total_size = f$length('_variable')  $! $ textarea$_readloop:  $!: $	read /end_of_file=textarea$end_readloop t_area _nextline5 $	_total_size = _total_size + 2 + f$length(_nextline)c" $	if _total_size .ge. _ta_max_size	 $	   thenl& $		omi$signal omi tatrunc,_ta_max_size $		goto textarea$end_readloop! $	endif 5 $	'_variable' = '_variable' + F$Fao("!/") + _nextlinee $	goto textarea$_readloop  $! $ textarea$end_readloop: $! $	close t_area $	return omi$_ok $! $ textarea$_nofile:  $! $	return omi$_ok $! $ textarea$_locked:l $! $	omi$signal omi talock  $	return $status $!P $!****************************************************************************** $! $!==>	Validate the DATE type $! $ input$date_format: $!& $	if f$type('_format'$format) .eqs. ""	 $	   then  $		_dformat = "absolute" $		goto format$frm_date  $	endif  $!I $	if f$edit(f$extract(0, 1, '_format'$format), "upcase") .eqs. "A" then -  	   $ _dformat = "absolute" I $	if f$edit(f$extract(0, 1, '_format'$format), "upcase") .eqs. "C" then -* 	   $ _dformat = "comparison" I $	if f$edit(f$extract(0, 1, '_format'$format), "upcase") .eqs. "D" then -  	   $ _dformat = "delta" $! $ format$frm_date: $! $	_d_in = '_variable' 4 $	if f$locate("-",_d_in) .eq. f$length(_d_in) then -@ 	   $ _d_in = _d_in + "-" + f$cvtime("today","absolute","month")9 $	'_variable' = f$cvtime("''_d_in'","''_dformat'","date")t $	goto input$end_formatu $!P $!****************************************************************************** $! $!==>	Validate the TIME type $! $ input$time_format: $!/ $	_t_in = f$edit('_variable',"collapse,upcase")  $!- $	if f$type('_format'$trzero) .eqs. "" then -f 	   '_format'$trzero = 0, $	if f$type('_format'$hours) .eqs. "" then -& 	   '_format'$hours = main$time_format0 $	if f$type('_format'$separator) .eqs. "" then - 	   '_format'$separator = ":" - $	if f$type('_format'$upcase) .eqs. "" then -  	   '_format'$upcase = 0 $!= $	_noon =  ((f$integer(f$extract(0, 1, _t_in)) .ge. 1 .and. - 4 	   f$integer(f$extract(1, 1, _t_in)) .ge. 2) .or. -5 	   (f$integer(f$extract(0, 1, _t_in)) .eq. 2 .and. -=. 	   f$integer(f$extract(1, 1, _t_in)) .ge. 1)) $!, $	if f$locate("AM", _t_in) .lt. f$len(_t_in)	 $	   thens, $		if _noon then $ goto input$invalid_format $		_t_in = _t_in - "AM"n $	endif  $!, $	if f$locate("PM", _t_in) .lt. f$len(_t_in)	 $	   then  $		_noon = 1 $		_t_in = _t_in - "PM"h $	endif* $!. $	if f$locate(":", _t_in) .lt. f$length(_t_in)	 $	   thend# $		_hrs  = f$element(0, ":", _t_in) # $		_mins = f$element(1, ":", _t_in)e $		goto format$frm_time  $	endif  $!. $	if f$locate(".", _t_in) .lt. f$length(_t_in)	 $	   then # $		_hrs  = f$element(0, ".", _t_in) # $		_mins = f$element(1, ".", _t_in)  $		goto format$frm_timeY $	endif  $! $	goto input$invalid_format  $! $ format$frm_time: $!F $	if f$type(_hrs) .nes. "INTEGER" .or. f$type(_mins) .nes. "INTEGER" -$ 	   then $ goto input$invalid_format5 $	if _noon .and. _hrs .lt. 12 then $ _hrs = _hrs + 12  $	if _hrs .eq. 24 	 $	   thenr $		_hrs = 0  $		_noon = 0 $	endif I $	if _hrs .lt. 0 .or. _hrs .ge. 24 .or. _mins .lt. 0 .or. _mins .ge. 60 - $ 	   then $ goto input$invalid_format $! $	_addstr = "" $	if '_format'$hours .eq. 12	 $	   then  $		if _noon 
 $		   then+ $			if _hrs .gt. 12 then $ _hrs = _hrs - 12  $			_addstr = "pm" $		   else $ _addstr = "am"k $		endif@ $		if '_format'$upcase then $ _addstr = f$edit(_addstr,"upcase") $	endifV $!8 $	if _mins .lt. 10 then $ _mins = "0''f$integer(_mins)'"/ $	if _hrs .lt. 10 .and. '_format'$trzero then - " 	   $ _hrs = "0''f$integer(_hrs)'" $!B $	'_variable' = "''_hrs'"+'_format'$separator+"''_mins'''_addstr'" $	goto input$end_formatV $! $ input$end_format:  $! $	set message 'omi$_message' $	on warning then $ continue $	return omi$_ok $! $ input$invalid_format:1 $! $	on warning then $ continue $	set message 'omi$_message'" $	omi$signal omi ivfrm,_req_format $	return omi$_warning  $!P $!******************************************************************************  P $!****************************************************************************** $!G $!==>	An option has been entered and validated. This routine translates 8 $!	the option to the menu definition and acts upon that. $! $ main$option_eval:  $!6 $	_selected_item = 'omi$current_menu'$item'omi$option' $! $ eval$lookfor_substitutions:  $!@ $	if f$locate("~?",_selected_item) .lt. f$length(_selected_item)	 $	   then  $		gosub main$input_substitute= $		if $status .eq. omi$_cancelled then $ goto main$get_option " $		goto eval$lookfor_substitutions $	endif  $!D $	omi$option_type = f$edit(f$element(1,"#",_selected_item),"upcase")$ $	if omi$option_type .eqs. "SUBMENU"	 $	   then*@ $		if f$extract(0, 1, f$element(2,"#",_selected_item)) .eqs. "{"% $		   then $ gosub main$_dynamic_menuh
 $		   elseA $			'f$element(2,"#",_selected_item)'$previous = omi$current_menuT; $			omi$current_menu = "''f$element(2,"#",_selected_item)'"r $		endif $		gosub main$check_security. $		if 'omi$current_menu'$security_level .lt. 0
 $		   then7 $			if 'omi$current_menu'$security_level .eq. -1 then -  			   $ omi$signal omi ivpwd2 $			omi$current_menu = 'omi$current_menu'$previous $		endif. $		if 'omi$current_menu'$security_level .eq. 0
 $		   then $			omi$signal omi noprivy2 $			omi$current_menu = 'omi$current_menu'$previous $		endif1 $		if f$type('omi$current_menu'$counter) .nes. ""f
 $		   then. $			_menu_counter = 'omi$current_menu'$counter9 $			if f$type('omi$current_menu'$auto_increase) .eqs. "" aD $			   then $ counter$'_menu_counter' == counter$'_menu_counter' + 1 $			   else)/ $				if 'omi$current_menu'$auto_increase then -(? 				   $ counter$'_menu_counter' == counter$'_menu_counter' + 1h	 $			endif  $			init_def$search_string = -5 			   "''omi$current_menu'$input,counter$ /match=and": $			gosub main$default_values  $		endif $		goto main$do_menu $	endifi $!$ $	if omi$option_type .eqs. "COMMAND"	 $	   thenoB $		omi$_command = f$edit(f$element(2,"#",_selected_item),"upcase") $		gosub main$omi_commando- $		if f$type(omi$previous_menu_file) .nes. ""s
 $		   then/ $			deletee/symbol/local omi$previous_menu_filen $			goto main$_startmenu $		endif $		goto main$get_option_ $	endif" $!! $	if omi$option_type .eqs. "CALL"u	 $	   theno< $		omi$call_info = f$edit(f$element(2,"#",_selected_item), - 		   "trim,compress")o6 $ !!		if f$extract(0,1,omi$call_info) .eqs. "@" then -.   !!		   $ omi$call_info = omi$call_info - "@"1 $		omi$job_call  = f$element(0," ",omi$call_info) @ $		omi$call_parm = f$edit((omi$call_info - omi$job_call),"trim")6 $ !!! 		omi$job_call  = f$parse(omi$job_call,".OMI", -0   !!! 		   "OMI$Menu_Directory:",,"syntax_only")J $! The above line is outcommented; it doesn't work when there's a variable8 $! in the filename (eg. 'DIRECTORIES$OMI_JOBS'MY_MODULE) $! Below is the wordaround.n $!!!! Left in for a while..... gC $  !!!		if f$locate(".",omi$job_call) .eq. f$length(omi$job_call) -$6    !!!		   then $ omi$job_call = omi$job_call + ".OMI" $		if .not. omi$_debug then -	D 		   $ set message /nofacility /noseverity /noidentification /notext/ $  !!!		if f$search("''omi$job_call'") .eqs. ""o9 $  !!!		   then $ omi$signal omi modnotfound,omi$job_callm $  !!!		   elsee( $  !!!			@'omi$job_call' 'omi$call_parm'+ $			omi$call 'omi$job_call' 'omi$call_parm'- $  			_status = $statusv
 $  !!!		endifa $		set message 'omi$_message $		goto main$get_optioni $	endif. $! $	omi$signal omi badoptg $	goto main$get_option $!P $!******************************************************************************  P $!****************************************************************************** $!# $!==>	Handle the Dynamic Menu itemsd $! $ main$_dynamic_menu:n $!. $	_menu_list = f$element(2,"#",_selected_item) $	_dynmenu_count = 0 $! $ dynmenu$_get_options:  $!% $	_dynmenu_count = _dynmenu_count + 1sR $	_dynmenu'_dynmenu_count' = f$extract(0, f$locate("}", _menu_list)+1, _menu_list)4 $	_menu_list = _menu_list - _dynmenu'_dynmenu_count'A $	_dynmenu'_dynmenu_count' = _dynmenu'_dynmenu_count' - "{" - "}"*K $	if f$extract(0, 1, _menu_list) .eqs. "{" then $ goto dynmenu$_get_options* $	omi$screen dynamic_menu* $! $ dynmenu$_prompt: $! $	if omi$_jumpinge	 $	   theniF $		_selected_menu = f$element(options$_jumpcounter,",",options$_jumps); $		if _selected_menu .eqs. "" .or. _selected_menu .eqs. ","'
 $		   thenv $			read /end_of_file=dynmnu$cancel_input /prompt="''screen$prompt_position'''_menu_list' " sys$command _selected_menu. $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh $			omi$_jumping = 0< $		   else $ options$_jumpcounter = options$_jumpcounter + 1 $		endif~ $	   else $ read /end_of_file=dynmnu$cancel_input /prompt="''screen$prompt_position'''_menu_list' " sys$command _selected_menu $	endif ! $	omi$variable = "_selected_menu"	 $	omi$input_validate $	if $status .ge. omi$_warning	 $	   then  $		omi$signal omi tranerrt $		omi$cmdline_clear $		goto dynmenu$_prompti $	endif$2 $	if f$type(_selected_menu) .nes. "INTEGER" .or. -- 	   f$type(_dynmenu'_selected_menu') .eqs. "" 	 $	   then_ $		omi$signal omi ivchoice $		omi$cmdline_clear $		goto dynmenu$_prompty $	endifr> $	_selected_menu = f$element(1, "|", _dynmenu'_selected_menu'). $	'_selected_menu'$previous = omi$current_menu( $	omi$current_menu = "''_selected_menu'" $! $ dynmnu$cancel_input: $! $	omi$cmdline_clear$ $	return omi$_cancelledu $!P $!******************************************************************************  P $!****************************************************************************** $!E $!==>	An OMI command was found in the menu file, which requires extra	H $!	input. This was recorgnized by the string '~?' If this was immediatlyG $!	followed by '{any text}', 'any text' will be used to prompt the userfH $!	for the required input. '~?' will be substituted by the user input in $!	the command.tE $!	If '{any text}' if optionally split by a "|" ('{any text|block}'), $ $!	'block' points to a format block. $! $ main$input_substitute: $!H $	_string1 = f$extract(0, f$locate("~?",_selected_item), _selected_item), $	_selected_item = _selected_item - _string1 $!C $	if f$type(_format) .nes. "" then $ deletee /symbol /local _formatrA $	if f$locate("~?{",_selected_item) .lt. f$length(_selected_item)p	 $	   thencN $		_prompt_info = f$extract(3, f$locate("}",_selected_item)-3, _selected_item)8 $		_selected_item = _selected_item - "{''_prompt_info'}", $		_prompt = f$element(0, "|", _prompt_info)> $		if f$length(_prompt) .lt. f$length(_prompt_info) - 1 then -0 		   $ _format = f$element(1, "|", _prompt_info)3 $	   else $ _prompt = "''questions$default_input':"  $	endifa $! $ main$input_to_subst: $!= $	read /end_of_file=main$subst_cancelled sys$command _value -t3 	   /prompt="''screen$prompt_position'''_prompt' " u $	omi$msgline_clear  $	omi$variable = "_value"a $	omi$input_validate $	if $status .ge. omi$_warning	 $	   thenp $		omi$signal omi tranerrR $		omi$cmdline_clear $		goto main$input_to_subst 
 $	endif    $! $	if f$type(_format) .nes. ""_	 $	   theno $		_variable = "_value"  $		gosub input$_formatF $		if $status .eq. omi$_warning ! Ignore errors; they'll cause looping
 $		   then $			omi$cmdline_clear	 $			goto main$input_to_subst $		endif $	endif  $! $	omi$cmdline_clearb $	omi$msgline_clear	 $!5 $	_selected_item = _string1 + _value + f$extract(2, -n/ 	   f$length(_selected_item)-2, _selected_item)i $! $	return omi$_ok $! $ main$subst_cancelled:i $! $	omi$msgline_clear. $	omi$cmdline_clear  $	return omi$_cancelledo $!P $!******************************************************************************  P $!****************************************************************************** $! $!==>n $! $ main$_taglist: $!C $	_tagblock = f$extract(0, f$locate("}", _variable) + 1, _variable)t" $	_taglist = _variable - _tagblock8 $	_tagblock = f$edit(_tagblock,"upcase") - "{TAG|" - "}"8 $	if f$type ('_taglist') .eqs. "" then $ '_taglist' = ""+ $	if f$type('_tagblock'$delimiter) .eqs. "".	 $	   then. $		omi$signal omi nodelim  $		return omi$_warning $	endife# $	_tagdelim = '_tagblock'$delimiterf* $	if f$type('_tagblock'$filename) .nes. ""	 $	   then= $		_blockname = _tagblocks $		gosub input$_from_filem0 $		if $status .ne. omi$_ok then $ return $status $	endif* $! $	omi$screen taglist $! $ taglist$_prompt: $! $	if omi$_jumping*	 $	   then*@ $		_tag_sel = f$element(options$_jumpcounter,",",options$_jumps)/ $		if _tag_sel .eqs. "" .or. _tag_sel .eqs. "," 
 $		   then= $			read /end_of_file=main$end_taglist sys$command _tag_sel -  			   /prompt="''screen$promp ) t_position'Select, <Ctrl/Z> when done: " e. $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh $			omi$_jumping = 0< $		   else $ options$_jumpcounter = options$_jumpcounter + 1 $		endifE $	   else $ read /end_of_file=main$end_taglist sys$command _tag_sel -$E 		   /prompt="''screen$prompt_position'Select, <Ctrl/Z> when done: " a $	endifiF $	if f$edit(_tag_sel,"upcase") .eqs. "^Z" then $ goto main$end_taglist $	omi$cmdline_clear	 $	omi$msgline_clear	 $!2 $	if _tag_sel .eqs. "" then $ goto taglist$_prompt% $	if f$type(_tag_sel) .nes. "INTEGER"x	 $	   thena $		omi$signal omi intonlyn- $		if f$type(jump$_norefresh) .nes. "" then -$- 		   $ deletee /symbol /local jump$_norefreshe $		omi$_jumping = 0a $		goto taglist$_prompta $	endifi $	_reverse = 0 $!1 $	if f$type('_tagblock'$value'_tag_sel') .eqs. "" 	 $	   thenj $		_sel_m_1 = _tag_sel - 1) $		if _sel_m_1 .lt. 0 then $ _sel_m_1 = 0i2 $		if f$type('_tagblock'$value'_sel_m_1') .eqs. ""
 $		   then $			omi$signal omi ivsel. $			if f$type(jump$_norefresh) .nes. "" then -. 			   $ deletee /symbol /local jump$_norefresh $			omi$_jumping = 0 $			goto taglist$_prompt $		   else $ _reverse = 1* $		endif $	endif* $!! $	if _reverse then $ _tag_sel = 1* $! $ tag$_reverse:* $!+ $	_tag_value = '_tagblock'$value'_tag_sel' *H $	if f$locate("''_tagdelim'''_tag_value'''_tagdelim'",'_taglist') .lt. -B 	   f$length('_taglist') .or. (f$length('_taglist') .ne. 0 .and. -< 	   f$locate("''_tag_value'''_tagdelim'",'_taglist') .eq. 0)T $	   then $ '_taglist' = '_taglist' - ('_tagblock'$value'_tag_sel' + "''_tagdelim'")R $	   else $ '_taglist' = '_taglist' + '_tagblock'$value'_tag_sel' + "''_tagdelim'" $	endife $	omi$screen taglist '_tag_sel'f $!
 $	if _reversei	 $	   then, $		_tag_sel = _tag_sel + 15 $		if _tag_sel .le. _sel_m_1 then $ goto tag$_reverse	 $	endif! $! $	goto taglist$_prompt $! $ main$end_taglist:  $!
 $	omi$refresh  $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!E $!==>	The option was recognized as an internal OMI command, or an OMIkK $!	command has been entered as input. Validate the command, and execute it.  $! $ main$omi_command:	 $!5 $	omi$_command = f$edit(omi$_command,"trim,compress")p: $	omi$_p1 = f$edit(f$element(1, " ", omi$_command),"trim"): $	omi$_p2 = f$edit(f$element(2, " ", omi$_command),"trim"): $	omi$_p3 = f$edit(f$element(3, " ", omi$_command),"trim"): $	omi$_p4 = f$edit(f$element(4, " ", omi$_command),"trim"): $	omi$_p5 = f$edit(f$element(5, " ", omi$_command),"trim")0 $	omi$_command = f$element(0, " ", omi$_command) $	_cmd_match = 0 $	_cmd_cnt = 0 $! $ main$_validate_cmd:n $!B $	if f$element(_cmd_cnt, "#", omi$valid_commands) .eqs. "#" then -  	   $ goto main$end_validate_cmd> $	if omi$_command .eqs. f$extract(0, f$length(omi$_command), -D 	   f$element(0, ",", f$element(_cmd_cnt, "#", omi$valid_commands)))	 $	   then.P $		omi$command = f$element(0, ",", f$element(_cmd_cnt, "#", omi$valid_commands))V $		_available_in_otf = f$element(1, ",", f$element(_cmd_cnt, "#", omi$valid_commands)) $		_cmd_match = _cmd_match + 1 $	endifi $! $	_cmd_cnt = _cmd_cnt + 1r $	goto main$_validate_cmdi $! $ main$end_validate_cmd: $! $	if _cmd_match .eq. 0	 $	   then $ $		omi$signal omi ivcmd,omi$_command $		return omi$_warning $	endift $! $	if _cmd_match .ge. 2	 $	   theni$ $		omi$signal omi abcmd,omi$_command $		return omi$_warning $	endifn $!/ $	if omi$otf_menu .and. .not. _available_in_otf"	 $	   thenr $		omi$signal omi cmdnotav $		return $statusm $	endift $!" $	gosub main$execcmd_'omi$command' $	return $status $!P $!****************************************************************************** $! $ main$execcmd_back: $! $!==>	The OMI command BACK $!B $	if 'omi$current_menu'$previous .eqs. "" .and. .not. omi$otf_menu	 $	   thend $		omi$signal omi toplevel $		return $statuso $	endifc $!a $	if f$length(omi$_p1) .lt. 3 .or. omi$_p1 .nes. f$extract(0, f$length(omi$_p1), "NOEXIT_MODULE") 	 $	   then  $		gosub main$perf_onexitm: $		if $status .eq. omi$_warning then $ return omi$_warning $	endifl $!+ $	if omi$otf_menu then $ goto main$otf_exit_0 $	omi$current_menu = 'omi$current_menu'$previous $	omi$screen menu  $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_calc: $! $!==>	The OMI command CALC $!C $	@Omi$:Omi$Calculator 'omi$_p1 'omi$_p2 'omi$_p3 'omi$_p4 'omi$_p5n $	_status = $status  $	if _status .eq. omi$_okc	 $	   then	) $		omi$signal omi calcres,'omi$calculatede) $		deletee /symbol /global omi$calculatedm $	endifl $	return _status $!P $!****************************************************************************** $! $ main$execcmd_edit: $! $!==>	The OMI command EDIT $!- $	if 'omi$current_menu'$security_level .lt. 3		 $	   thenl $		omi$signal omi nopriv $		return omi$_warning $	endif_ $! $	@Omi$:Omi$Edit_Cmd $	return $status $!P $!****************************************************************************** $! $ main$execcmd_exit: $ main$execcmd_quit: $!$ $!==>	The OMI commands EXIT and QIUT $! $	gosub main$perf_onexit9 $	if $status .eq. omi$_warning then $ return omi$_warning 3 $	if f$edit(omi$current_menu,"upcase") .nes. "MENU"s	 $	   theni $		perf$init_exit = 1l $		omi$current_menu = "menu" $		gosub main$perf_onexitm $		if $status .eq. omi$_warningr
 $		   then $			omi$screen menu  $			return omi$_warningr $		endif $	endifn $	goto main$_exitf $!P $!****************************************************************************** $! $ main$execcmd_encrypt:  $! $!==>	The OMI command ENCRYPTv $!- $	if 'omi$current_menu'$security_level .lt. 3l	 $	   then$ $		omi$signal omi nopriv $		return omi$_warning $	endifn $! $	if omi$_p1 .eqs. ""l	 $	   then$C $		read /end_of_file=setcommand$_cancelled sys$command _encr_sect -l8 		   /prompt="''screen$prompt_position'_From section: "  $		omi$cmdline_clear  $	   else $ _encr_sect = omi$_p1 $	endif$% $	_encr_sect = _encr_sect - "[" - "]"  $	if omi$_p2 .eqs. ""l	 $	   then_D 		$ read /end_of_file=setcommand$_cancelled sys$command _encr_item -/ 		   /prompt="''screen$prompt_position'_Item: "d $		omi$cmdline_clear  $	   else $ _encr_item = omi$_p2 $	endife $!/ $	if f$type('_encr_sect'$'_encr_item') .eqs. "" 	 $	   then'1 $		omi$signal omi nosuchitm,_encr_item,_encr_sect_ $		return omi$_warning $	endif( $! $	if omi$_p3 .nes. ""$	 $	   then	( $		if f$type(keyring$'omi$_p3') .eqs. ""
 $		   then  $			omi$signal omi ivkey,omi$_p3 $			return omi$_warning' $		endif $	endifp $!# $	_encr = '_encr_sect'$'_encr_item'm" $	omi$encrypt "''_encr'" 'omi$_p3' $	_encr = omi$encrypted	' $	deletee /symbol /global omi$encrypted N $	omi$config 'omi$menu_file' update "''_encr_sect'" "''_encr_item'" "''_encr'"  $	if $status .eq. omi$_ok then - 	   $ omi$signal omi encrypt $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_export: $! $!==>	The OMI command EXPORT $! $	if omi$_p1 .eqs. ""e	 $	   thenrD $		read /end_of_file=export_command$_cancelled sys$command omi$_p1 -0 		   /prompt="''screen$prompt_position'_What: " = $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress,upcase")  $		omi$cmdline_clear $		goto main$execcmd_exportr $	endife $!X $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "KEY")	 $	   thenf $! $	 export_cmd$export_key:e $! $		if omi$_p2 .eqs. ""
 $		   thenE $			read /end_of_file=export_command$_cancelled sys$command omi$_p2 -r5 			   /prompt="''screen$prompt_position'_Key name: " ' $			omi$cmdline_clear_ $			goto export_cmd$export_key $		endif $!( $		if f$type(keyring$'omi$_p2') .eqs. ""
 $		   then  $			omi$signal omi ivkey,omi$_p2 $			return omi$_warninge $		endif6 $		if f$search("omi$:omi$global_keyring.dat") .eqs. ""3 $		   then $ open /write /error=export_cmd$nopriv -	+ 			omi$_keyring omi$:omi$global_keyring.dat 
 $		   elseA $			search /output=nla0: omi$:omi$global_keyring.dat "''omi$_p2'"v  $			if $status .ne. omi$_nomatch $			   then_# $				omi$signal omi glkeyex,omi$_p2c $				return $statusr	 $			endifg+ $			open /append /error=export_cmd$nopriv -g. 			   omi$_keyring omi$:omi$global_keyring.dat $		endif $!9 $		write omi$_keyring "''omi$_p2'=",keyring$'omi$_p2',"="$ $		close omi$_keyringr  $		omi$signal omi expkey,omi$_p2 $		return omi$_ok/ $	endife $b $	omi$signal omi ivopt,export! $! $ export_command$_cancelled: $! $	omi$cmdline_clearo $	return omi$_ok $! $ export_cmd$nopriv: $! $	omi$signal omi noexprv $	return $status $!P $!****************************************************************************** $! $ main$execcmd_import: $! $!==>	The OMI command IMPORT $! $	if omi$_p1 .eqs. ""d	 $	   thenrD $		read /end_of_file=import_command$_cancelled sys$command omi$_p1 -0 		   /prompt="''screen$prompt_position'_What: " = $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress,upcase")$ $		omi$cmdline_clear $		goto main$execcmd_importi $	endif  $!X $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "KEY")	 $	   thena $! $	 import_cmd$import_key:( $! $		if omi$_p2 .eqs. ""
 $		   thenE $			read /end_of_file=import_command$_cancelled sys$command omi$_p2 -+5 			   /prompt="''screen$prompt_position'_Key name: "   $			omi$cmdline_clear= $			goto import_cmd$import_key $		endif $!( $		if f$type(keyring$'omi$_p2') .nes. ""
 $		   then  $			omi$signal omi exkey,omi$_p2 $			return omi$_warningi $		endif $!6 $		if f$search("omi$:omi$global_keyring.dat") .eqs. ""
 $		   then" $			omi$signal omi glkeynf,omi$_p2 $			return omi$_warning_ $		endif $!K $		open /read /error=import_cmd$nopriv imp$_key omi$:omi$global_keyring.dat= $! $	 import_cmd$_read_global_key:_ $!B $		read /end_of_file=import_cmd$end_read_global_key imp$_key _keys8 $		if f$edit(f$element(0, "=", _keys), "upcase") .eqs. -@ 		   f$edit(omi$_p2, "upcase") then $ goto import_cmd$_key_found# $		goto import_cmd$_read_global_keyn $!" $	 import_cmd$end_read_global_key: $!! $		omi$signal omi glkeynf,omi$_p2c $		return omi$_warning $! $	 import_cmd$_key_found:  $! $		close imp$_key!" $		_key = f$element(1, "=", _keys)' $		_new_line = "  ''omi$_p2' = ''_key'"e $!( $		_config_file = f$trnlnm("Omi$Config")J $		if _config_file .eqs. "" then $ _config_file = "Sys$Login:Omi$Menu.Cfg"* $		if f$search("''_config_file'") .eqs. ""
 $		   then $			omi$signal omi nocfg $			return omi$_warningh $		endif $!2 $		search '_config_file' "[keyring]" /output=nla0: $		if $status .eq. omi$_nomatch 
 $		   then% $			open /append cfgfi '_config_file'$ $			write cfgfi "" $			write cfgfi "[keyring]"" $			write cfgfi "''_new_line'" $			close cfgfit
 $		   else# $			open /read cfgfi '_config_file't2 $			open /write cfgfo Sys$Scratch:Omi$NewCfg._Tmp$ $! $		 main$execcmd_importkey:f $!< $			read /end_of_file=main$execcmd_key_imported cfgfi _cfgin $			write cfgfo _cfgin; $			if f$locate("[keyring]", f$edit(_cfgin, "lowercase")) -*= 			   .lt. f$length(_cfgin) then $ write cfgfo "''_new_line'"* $			goto main$execcmd_importkeye $! $		 main$execcmd_key_imported: $! $			close cfgfi( $			close cfgfo.- $			deletee /nolog /noconfirm '_config_file';s; $			copy /nolog Sys$Scratch:Omi$NewCfg._Tmp$ '_config_file'f< $			deletee /nolog /noconfirm Sys$Scratch:Omi$NewCfg._Tmp$;* $		endif $		keyring$'omi$_p2' == _key  $		omi$signal omi impkey,omi$_p2 $		return omi$_oke $	endif" $	 $	omi$signal omi ivopt,importp $! $ import_command$_cancelled: $! $	omi$cmdline_clear" $	return omi$_ok $! $ import_cmd$nopriv: $! $	omi$signal omi noimprv $	return $status $!P $!****************************************************************************** $! $ main$execcmd_help: $! $!==>	The OMI command HELP $!# $	assign /user /nolog TT: sys$inputkA $	help /library=Omi$:Omi$Menu 'omi$_p1 'omi$_p2 'omi$_p3 'omi$_p4w
 $	omi$refreshL $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_increase: $! $!==>	The OMI command INCREASE $!0 $	if f$type('omi$current_menu'$counter) .eqs. ""	 $	   thene $		omi$signal omi nocntinc $		return omi$_warning $	endifo $!, $	_menu_counter = 'omi$current_menu'$counter8 $	counter$'_menu_counter' == counter$'_menu_counter' + 1J $	init_def$search_string = "''omi$current_menu'$input,counter$ /match=and" $	gosub main$default_valuese $!^ $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "REFRESH") - 	   then $ omi$refresh $! $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_info: $! $!==>	The OMI command INFO $! $ !	omi$signal omi not_yet $ !	return omi$_warning  $!- $	_hlp_file = f$parse(omi$menu_file,,,"name")t= $	_hlp_file = f$search("omi$menu_directory:''_hlp_file'.omh")o $	if _hlp_file .eqs. ""o	 $	   then' $		omi$signal omi nohlpfil $		return $statust $	endife9 $	search '_hlp_file "[''omi$current_menu']" /output=nla0:o $	if $status .eq. omi$_nomatch	 $	   theni) $		omi$signal omi nohlp,'omi$current_menur $		return $status	 $	endif  $!             e $	open /read omi$hlp '_hlp_filei $!
 $ info$_find:$ $!4 $	read /end_of_file=info$_notfound omi$hlp _mnu_info7 $	if _mnu_info .eqs. "<EOF>" then $ goto info$_notfounda1 $	if f$edit(_mnu_info, "collapse,upcase") .nes. - 3 	   "[''f$edit(omi$current_menu,"upcase")']" then -= 	   $ goto info$_findi@ $	available_lines = screen$line_command - screen$line_header - - 	   screen$window_topmargin - 2  $	rec_counter = 1  $!
 $ info$_read:x $!A $	read /end_of_file=info$end_read omi$hlp omi$record'rec_counter' , $	if omi$record'rec_counter' .eqs. "" then -@ 	   $ omi$record'rec_counter' = " " ! Workaround for a known bug< $	if f$extract(0,1,omi$record'rec_counter') .eqs. "[" then - 	   $ goto info$end_readD $	if omi$record'rec_counter' .eqs. "<EOF>" then $ goto info$end_readC $	if omi$record'rec_counter' .eqs. "<FF>" then $ goto info$_display* $! $	rec_counter = rec_counter + 1*? $	if rec_counter .gt. available_lines then $ goto info$_displaye $	goto info$_read	 $! $ info$_display: $! $	omi$record'rec_counter' = "" $	omi$display_info
 $	omi$wait7 $	if $status .eq. omi$_cancelled then $ goto info$_donel $	rec_counter = 1	 $	goto info$_reada $! $ info$_notfound:o $! $	close omi$hlp ( $	omi$signal omi nohlp,'omi$current_menu $	return $status $! $ info$end_read: $! $	omi$record'rec_counter' = "" $	omi$display_info6 $ !	if f$type(omi$record'rec_counter') .nes. "" then -6   !	   deletee /symbol /global omi$record'rec_counter' $!
 $	omi$wait $!
 $ info$_done:  $! $	close omi$hlpi
 $	omi$refreshr $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_jump: $! $!==>	The OMI command JUMP $! $	if omi$_p1 .eqs. "" 	 $	   then'8 $		read /end_of_file=jump$_ignored sys$command omi$_p1 -2 		   /prompt="''screen$prompt_position'_Submenu: " $		omi$cmdline_clear $		omi$msgline_clear $		goto main$execcmd_jumpt $	endifo6 $	assign sys$scratch:omi$jump_submenu._tmp$ sys$output $	show symbol /global *$name $	deassign sys$outputp $	if .not. omi$_debug then -C 	   $ set message /nofacility /noseverity /noidentification /notextf> $	search sys$scratch:omi$jump_submenu._tmp$ """''omi$_p1'""" -4 	   /output=sys$scratch:omi$jump_submenu_found._tmp$ $	_status = $statusc> $	delete /nolog /noconfirm sys$scratch:omi$jump_submenu._tmp$; $	if _status .eq. omi$_nomatch	 $	   thentE $		delete /nolog /noconfirm sys$scratch:omi$jump_submenu_found._tmp$;i6 $		omi$signal omi nosuchname,'f$edit(omi$_p1,"upcase") $		return omi$_warning $	endif : $	open /read jump sys$scratch:omi$jump_submenu_found._tmp$ $	read jump _mnu_namei $	close jumpD $	delete /nolog /noconfirm sys$scratch:omi$jump_submenu_found._tmp$; $!D $	if f$type (omi$current_menu) .eqs. "" then $ omi$current_menu = ""P $	'f$edit(f$element(0, "$", _mnu_name), "collapse")'$previous = omi$current_menuE $	omi$current_menu = f$edit(f$element(0, "$", _mnu_name), "collapse")e $! $	gosub main$check_security*. $	if 'omi$current_menu'$security_level .eq. -1	 $	   then* $		omi$msgline_clear $		omi$signal omi ivpwd 1 $		omi$current_menu = 'omi$current_menu'$previousl $		return omi$_warning $	endifl- $	if 'omi$current_menu'$security_level .eq. 0 	 $	   thene $		omi$msgline_clear $		omi$signal omi nopriv1 $		omi$current_menu = 'omi$current_menu'$previousa $		return omi$_warning $	endif  $!E $	if f$type('omi$current_menu'$on_init) .nes. "" .and. perf$init_exit_	 $	   then  $		perf$init_exit = 0lL $		if f$extract(0,1,f$edit('omi$current_menu'$on_init,"collapse")) .eqs. ":"
 $		   thenS $			omi$_command = f$edit('omi$current_menu'$on_init - ":", "trim,compress,upcase")  $			gosub main$omi_command $			_status = $status! $			goto main$perfd_oninit $		endif? $		omi$init_job = f$element(0, " ", 'omi$current_menu'$on_init)n6 $		_params = 'omi$current_menu'$on_init - omi$init_job6 $ !!! 		omi$init_job  = f$parse(omi$init_job,".OMI", -0   !!! 		   "OMI$Menu_Directory:",,"syntax_only")B $ !!!		if f$locate(".",omi$init_job) .eq. f$length(omi$init_job) -5   !!!		   then $ omi$init_job = omi$init_job + ".OMI"  $ !!!		@'omi$init_job '_params'i# $		omi$call 'omi$init_job '_params'u $		_status = $status $! $ main$perfd_oninit: $! $		if _status .ge. omi$_warningv
 $		   then2 $			omi$current_menu = 'omi$current_menu'$previous $			return omi$_warning_ $		endif $	endif  $!0 $	if f$type('omi$current_menu'$counter) .nes. ""	 $	   then*- $		_menu_counter = 'omi$current_menu'$counter!9 $		counter$'_menu_counter' == counter$'_menu_counter' + 1r $		init_def$search_string = -e4 		   "''omi$current_menu'$input,counter$ /match=and" $		gosub main$default_values $	endif* $! $	if f$type(omi$_p2) .nes. ""!	 $	   theni $		if omi$_p2 .eqs. "" $		   then $ omi$_jumping = 0! $		   else $ omi$_jumping = 1  $		endif $	endift8 $	if f$type(jump$_norefresh) .eqs. "" then $ omi$refresh $	return omi$_ok $! $ jump$_ignored: $! $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_reset:g $! $!==>	The OMI command RESET_ $! $	if omi$_p1 .eqs. ""i	 $	   then$B $		read /end_of_file=resetcommand$_cancelled sys$command omi$_p1 -0 		   /prompt="''screen$prompt_position'_What: " = $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress,upcase")e $		omi$cmdline_clear $		goto main$execcmd_reset $	endifr\ $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "COUNTER")	 $	   then 1 $		if f$type('omi$current_menu'$counter) .eqs. ""_# $		   then $ omi$signal omi nocounti
 $		   else. $			_menu_counter = 'omi$current_menu'$counter  $			counter$'_menu_counter' == 0 $		endif $		return omi$_oke $	endife $!a $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "AUTO_REFRESH")+	 $	   then & $		'omi$current_menu'$auto_refresh = 0 $		return omi$_okp $	endift $!Z $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "ORDER")	 $	   then$8 $		if f$type('omi$current_menu'$required_order) .eqs. ""# $		   then $ omi$signal omi noorderl1 $		   else $ 'omi$current_menu'$reqwork_order = - 8 			f$edit('omi$current_menu'$required_order, "collapse") $		endif $		return omi$_ok$ $	endifn $!^ $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "VARIABLES")S $	   then                                                                          _ $		varreset$ = 08 $		init_def$search_string =  "''omi$current_menu'$input" $		gosub main$default_values $!1 $		if f$type('omi$current_menu'$counter) .nes. ""_
 $		   then" $!			* Check for arrays (counters) $			init_def$search_string = -6  			   "''omi$current_menu'$input,counter$ /match=and" $			gosub main$default_valuess $		endif $		if varreset$ .eq. 0
 $		   then$ $			deletee /symbol /local varreset$ $			omi$signal omi novarsa $			return $status $		endif# $		deletee /symbol /local varreset$_H $		if f$extract(0, 3, f$edit(omi$_p2, "upcase")) .nes. "BAC" !Background
 $		   then $			omi$refreshl $			omi$signal omi resetvar  $		endif $		return $status  $	endifo $!; $!	**** Reset commands below are not available in OTF Menus	 $! $	if omi$otf_menu*	 $	   then* $		omi$signal omi cmdnotav $		return $status* $	endif* $!] $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "PASSWORD")t	 $	   then . $		if 'omi$current_menu'$security_level .lt. 3
 $		   then $			omi$signal omi noprivi $			return omi$_warningt $		endif2 $		if f$type('omi$current_menu'$password) .eqs. ""! $		   then $ omi$signal omi nopwd 
 $		   else4 $			omi$config 'omi$menu_file' setcmd password reset8 $			if $status .eq. omi$_ok then $ omi$signal omi rempwd $		endif $		return omi$_ok  $	endifd $!Y $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "NAME").	 $	   thenh. $		if 'omi$current_menu'$security_level .lt. 3
 $		   then $			omi$signal omi nopriva $			return omi$_warningi $		endif. $		if f$type('omi$current_menu'$name) .eqs. ""% $		   then $ omi$signal omi nomnuname*
 $		   else0 $			omi$config 'omi$menu_file' setcmd name reset9 $			if $status .eq. omi$_ok then $ omi$signal omi remnamet $		endif $		return omi$_ok" $	endif	 $! $	omi$signal omi ivopt,reset $! $ resetcommand$_cancelled: $! $	omi$cmdline_cleart $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_set:$ $! $!==>	The OMI command SET_ $! $	if omi$_p1 .eqs. ""e	 $	   then_@ $		read /end_of_file=setcommand$_cancelled sys$command omi$_p1 -0 		   /prompt="''screen$prompt_position'_What: " = $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress,upcase")) $		omi$cmdline_clear $		goto main$execcmd_set $	endifg\ $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "COUNTER")	 $	   theni $		if omi$_p2 .eqs. ""
 $		   thenA $			read /end_of_file=setcommand$_cancelled sys$command omi$_p2 -e2 			   /prompt="''screen$prompt_position'_Value: " 7 $			omi$_p2 = f$edit(omi$_p2,"uncomment,trim,compress")  $			omi$cmdline_cleare $			goto main$execcmd_seti $		endif $!1 $		if f$type('omi$current_menu'$counter) .eqs. "" # $		   then $ omi$signal omi nocountf
 $		   else. $			_menu_counter = 'omi$current_menu'$counter& $			counter$'_menu_counter' == omi$_p2 $			init_def$search_string = -5 			   "''omi$current_menu'$input,counter$ /match=and"f $			gosub main$default_values  $		endif $		return omi$_okm $	endif. $!a $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "AUTO_REFRESH")1	 $	   thenr $		if omi$_p2 .eqs. ""
 $		   thenA $			read /end_of_file=setcommand$_cancelled sys$command omi$_p2 -m2 			   /prompt="''screen$prompt_position'_Value: " 7 $			omi$_p2 = f$edit(omi$_p2,"uncomment,trim,compress")u $			omi$cmdline_clear  $			goto main$execcmd_set	 $		endif $! $		if omi$_p2 .lt. 0
 $		   then $			omi$signal omi lowval,0_ $			return $status $		endif $		if omi$_p2 .gt. 255
 $		   then $			omi$signal omi hival,255 $			return $status $		endif, $		'omi$current_menu'$auto_refresh = omi$_p2 $		return omi$_oko $	endife $!Z $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "WIDTH")	 $	   then' $		if omi$_p2 .eqs. ""
 $		   thenA $			read /end_of_file=setcommand$_cancelled sys$command omi$_p2 -w2 			   /prompt="''screen$prompt_position'_Value: " 7 $			omi$_p2 = f$edit(omi$_p2,"uncomment,trim,compress")e $			omi$cmdline_clear' $			goto main$execcmd_sete $		endif, $		if omi$_p2 .ne. 80 .and. omi$_p2 .ne. 132
 $		   then $			omi$signal omi ivswval $			omi$cmdline_clear  $			omi$_p2 = "" $			goto main$execcmd_set*
 $		   else $			screen$width == omi$_p2  $			@Omi$:Omi$Screen Setup $			omi$refreshd $			return omi$_ok $		endif $	endifo $!X $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "KEY")	 $	   thenn( $		_config_file = f$trnlnm("Omi$Config")J $		if _config_file .eqs. "" then $ _config_file = "Sys$Login:Omi$Menu.Cfg"* $		if f$search("''_config_file'") .eqs. ""
 $		   then $			omi$signal omi nocfg $			return omi$_warningn $		endif $! $	 main$execcmd_setkey_getname:s $! $		if omi$_p2 .eqs ""n
 $		   then $			omi$ask "_Key name: "d $			omi$_p2 = omi$response8 $			if $status .eq. omi$_cancelled then $ return omi$_ok( $			deletee /symbol /global omi$response $		endif $!( $		if f$type(keyring$'omi$_p2') .nes. ""
 $		   then! $			omi$signal omi exkey,'omi$_p2s $			omi$_p2 = ""$ $			goto main$execcmd_setkey_getname $		endif $!2 $		search '_config_file' "[keyring]" /output=nla0: $		if $status .eq. omi$_nomatcht
 $		   then% $			open /append cfgfi '_config_file'u $			write cfgfi "" $			write cfgfi "[keyring]"n! $			write cfgfi "  ''omi$_p2' = "= $			close cfgfiu
 $		   else# $			open /read cfgfi '_config_file'c2 $			open /write cfgfo Sys$Scratch:Omi$NewCfg._Tmp$ $! $		 main$execcmd_setkey_init:$ $!= $			read /end_of_file=main$execcmd_setkey_inited cfgfi _cfgino $			write cfgfo _cfgin; $			if f$locate("[keyring]", f$edit(_cfgin, "lowercase")) -f@ 			   .lt. f$length(_cfgin) then $ write cfgfo "  ''omi$_p2' = "! $			goto main$execcmd_setkey_init' $! $		 main$execcmd_setkey_inited:	 $! $			close cfgfi' $			close cfgfoe- $			deletee /nolog /noconfirm '_config_file';e; $			copy /nolog Sys$Scratch:Omi$NewCfg._Tmp$ '_config_file'g< $			deletee /nolog /noconfirm Sys$Scratch:Omi$NewCfg._Tmp$;* $		endif $! $	 main$execcmd_setkey:f $! $		if omi$_p3 .eqs. ""
 $		   thenA $			read /end_of_file=setcommand$_cancelled sys$command omi$_p3 -$0 			   /prompt="''screen$prompt_position'_Key: " 7 $			omi$_p3 = f$edit(omi$_p3,"uncomment,trim,compress")f $			omi$msgline_clearh $			omi$cmdline_clearl $			goto main$execcmd_setkey $		endif $! $		_validate_key = "omi$_p3" $		gosub security$key_validate4 $		if omi$_p3 .eq. 0 then $ goto main$execcmd_setkey $		_key = "  " $		_key[0,8] = %X1! $		_key[8,8] = f$integer(omi$_p3)"D $		@Omi$:Omi$Config setup "" UPDATE "keyring" "''omi$_p2'" "''_key'" $!7 $		if $status .eq. omi$_ok then $ omi$signal omi setkeye $		omi$cmdline_clear $		return omi$_oka $	endifi $!9 $!	**** Set commands below are not available in OTF Menus  $! $	if omi$otf_menu"	 $	   then  $		omi$signal omi cmdnotav $		return $status  $	endifo $!] $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "PASSWORD")I	 $	   then'. $		if 'omi$current_menu'$security_level .lt. 3
 $		   then $			omi$signal omi noprivf $			return omi$_warning  $		endif $		set terminal /noecho! $! $	  setpwd$_prompt:l $!? $		read /end_of_file=setpasswrd$_cancelled sys$command _pwd_1 -m8 		   /prompt="''screen$prompt_position'_New password: "  $		omi$cmdline_clear $		if f$length(_pwd_1) .lt. 5!
 $		   then $			omi$signal omi shortpwdo $			goto setpwd$_prompte $		endif? $		read /end_of_file=setpasswrd$_cancelled sys$command _pwd_2 - 8 		   /prompt="''screen$prompt_position'_Verification: "  $		if _pwd_1 .nes. _pwd_2a
 $		   then $			omi$signal omi pwdverfail  $			goto setpasswrd$_cancelled $		endif $! $		set terminal /echo*! $		omi$encrypt "''_pwd_1'" p$_key*  $		_new_password = omi$encrypted& $		deletee/symbol/global omi$encrypted@ $		omi$config 'omi$menu_file' setcmd password "''_new_password'"7 $		if $status .eq. omi$_ok then $ omi$signal omi setpwdi $		omi$cmdline_clear $		return omi$_okd $	endifu $!Y $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "NAME")y	 $	   then'. $		if 'omi$current_menu'$security_level .lt. 3
 $		   then $			omi$signal omi noprivd $			return omi$_warning	 $		endif $		if omi$_p2 .eqs. ""L $		   then $ read /end_of_file=setcommand$_cancelled sys$command _new_name -6 			   /prompt="''screen$prompt_position'_New name : "   $		   else $ _new_name = omi$_p2 $		endif $		omi$cmdline_clear $!K $		omi$config 'omi$menu_file' setcmd name "''f$edit(_new_name,"collapse")'"c8 $		if $status .eq. omi$_ok then $ omi$signal omi setname $		omi$cmdline_clear $		return omi$_okn $	endifp $! $	omi$signal omi ivopt,set $! $ setcommand$_cancelled: $! $	omi$cmdline_clearu $	return omi$_ok $! $ setpasswrd$_cancelled: $! $	set terminal /echo $	omi$cmdline_clearg $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_show: $! $!==>	The OMI command SHOW $! $	if omi$_p1 .eqs. "" 	 $	   theneA $		read /end_of_file=showcommand$_cancelled sys$command omi$_p1 -a0 		   /prompt="''screen$prompt_position'_What: " = $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress,upcase")$ $		omi$cmdline_clear $		goto main$execcmd_shown $	endifG $!\ $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "COUNTER")	 $	   thend1 $		if f$type('omi$current_menu'$counter) .nes. ""s
 $		   then. $			_menu_counter = 'omi$current_menu'$counter2 $			omi$signal omi counter,counter$'_menu_counter'% $		   else $ omi$signal omi nocounter! $		endif $		return omi$_ok  $	endifl $!] $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "TEXTAREA")*	 $	   then* $		gosub textarea$_find_ta0 $		if $status .ne. omi$_ok then $ return $status0 $		if _areas_found .gt. 1 .and. omi$_p2 .eqs. ""
 $		   then $			omi$signal omi nouniqta	 $			return $status $		endif) $		if omi$_p2 .eqs. "" then $ omi$_p2 = 1y $!@ $		if f$type ('omi$current_menu'$ta_list'omi$_p2'_name) .eqs. ""
 $		   then $			omi$signal omi nosuchtal $			return $status $		endif $!7 $		_textarea = 'omi$current_menu'$ta_list'omi$_p2'_namel! $		if f$type('_textarea) .eqs. "" 
 $		   then $			omi$signal omi taempty $			return $status $		endif $!P $		_window = ( f$extract(0,3,f$edit(screen$scroll_region,"upcase")) .eqs. "ENA")
 $		if _windowt+ $		   then $ omi$screen setup_scroll_region. $		   else $ cls $		endif $		ws '_textarea $		ws "" $		omi$waits
 $		if _windowl+ $		   then $ omi$screen erase_scroll_region_ $		   else $ omi$refresh $		endif $! $		return omi$_ok_ $	endifi $!\ $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "VERSION")	 $	   then % $		omi$signal omi version,omi$versionp $		return omi$_okn $	endif$ $!Y $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "NAME") 	 $	   then . $		if f$type('omi$current_menu'$name) .eqs. """ $		   then $ omi$signal omi noname
 $		   else= $			_this_mnu_name = f$edit('omi$current_menu'$name,"upcase")l& $			omi$signal omi name,_this_mnu_name $		endif $		return omi$_okt $	endif  $!` $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "VMS_MESSAGE")	 $	   then  $! $	 main$execcmd_show_vmsmsg: $! $		if omi$_p2 .eqs. ""
 $		   thenA $			read /end_of_file=setcommand$_cancelled sys$command omi$_p2 -e8 			   /prompt="''screen$prompt_position'_Status code: " 7 $			omi$_p2 = f$edit(omi$_p2,"uncomment,trim,compress")  $			omi$msgline_cleara $			omi$cmdline_clear	! $			goto main$execcmd_show_vmsmsg  $		endif $		omi$get_vmsmessage 'omi$_p2 $		_status = $statusG $		if _status .eq. omi$_warning then $ omi$signal omi novmsmsg,'omi$_p2$0 $		if _status .ne. omi$_ok then $ return _status+ $		omi$display_message "''omi$vms_message'"** $		deletee /symbol /global omi$vms_message $		return omi$_ok* $	endif* $!Z $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "ORDER")	 $	   theng8 $		if f$type('omi$current_menu'$required_order) .eqs. ""
 $		   then $			omi$signal omi noorder $			return $status $		endif> $		if f$type('omi$current_menu'$reqwork_order) .eqs. "" then -+ 		   $ 'omi$current_menu'$reqwork_order = -k: 		   f$edit('omi$current_menu'$required_order, "collapse") $		_cnt = 0  $		_msg_string = ""e $! $	 show$_order_lookup: $!G $		_opt_first = f$element (_cnt, ",", 'omi$current_menu'$reqwork_order)n9 $		if _opt_first .eqs. "," .or. _opt_first .eq. "" then - ! 		   $ goto show$end_order_lookup 0 $		_opt_first = _opt_first + inputs$highest_item/ $		_msg_string = _msg_string + "''_opt_first'/"_ $		_cnt = _cnt + 1 $		goto show$_order_lookup $! $	 show$end_order_lookup:q $!C $		_msg_string = f$extract(0, f$length(_msg_string)-1, _msg_string)d $		if _msg_string .eqs. ""' $		   then $ omi$signal omi reqselectedo0 $		   else $ omi$signal omi curorder,_msg_string $		endif $		return $status  $	endif	 $! $	omi$signal omi ivopt,show$ $! $ showcommand$_cancelled:0 $! $	omi$cmdline_clearu $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_main: $! $!==>	The OMI command MAIN $! $	gosub main$perf_onexit9 $	if $status .eq. omi$_warning then $ return omi$_warningg $	omi$current_menu = "menu"m $	omi$screen menu$ $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_refresh:g $! $!==>	The OMI command REFRESH$ $!
 $	omi$refresh" $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_cls:0 $! $!==>	The OMI command CLSa $! $	omi$clear_screen $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_spawn:s $! $!==>	The OMI command SPAWNo $!A $	if (f$type(interactive_auth$'omi$current_user') .nes. "" .or. -e8 	   f$type(interactive_auth$all_users) .nes. "") .and. -& 	   f$type(omi$option) .nes. "INTEGER"	 $	   then : $		if f$type(interactive_auth$'omi$current_user') .eqs. ""7 $		   then $ if .not. interactive_auth$all_users then -e" 			   $ goto interactive$_disallow@ $		   else $ if .not. interactive_auth$'omi$current_user' then -" 			   $ goto interactive$_disallow $		endif $	endif  $! $	cls" $	set message 'omi$_message'H $	if f$locate("ignore=dcle", omi$steering) .lt. f$length(omi$steering) -# 	   then $ on error then $ continuesH $	if f$locate("ignore=dclf", omi$steering) .lt. f$length(omi$steering) -* 	   then $ on severe_error then $ continue9 $	spawn 'omi$_p1' 'omi$_p2' 'omi$_p3' 'omi$_p4' 'omi$_p5'1H $	if f$locate("ignore=dcle", omi$steering) .lt. f$length(omi$steering) -+ 	   then $ on error then $ goto main$_fatal H $	if f$locate("ignore=dclf", omi$steering) .lt. f$length(omi$steering) -2 	   then $ on severe_error then $ goto main$_fatal $	if .not. omi$_debug then -C 	   $ set message /nofacility /noseverity /noidentification /notextp $	ws ""r5 $	read /end_of_file=spawn$_ignore sys$command dummy -m3 	   /prompt="''ESC$'[?25l''questions$wait_prompt' "  $! $ spawn$_ignore: $! $	ws "''ESC$'[?25h" 
 $	omi$refresh= $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_submit: $! $!==>	The OMI command SUBMIT $! $	if omi$_p1 .nes. "" 	 $	   thenm' $		omi$background_module = "''omi$_p1'"t $		omi$_p1 = ""m	 $	   else)G $		read /end_of_file=submit$_ignore sys$command omi$background_module -a0 		   /prompt="''screen$prompt_position'Module: " $		omi$cmdline_clear $		omi$msgline_clear $	endif  $	omi$background_mode = "batch"$  $	omi$call omi$background_module $	return $status $! $ submit$_ignore:i $! $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_all:e $! $!==>	The OMI command ALL0 $! $!	omi$cmdline_clear/ $	if f$type('omi$current_menu'$input1) .eqs. ""=	 $	   then1 $		omi$signal omi noinput" $		return omi$_okn $	endif_ $! $	_all_inputs = 1+ $	_input = 1( $	_pointer = screen$default_position - 1 $! $ main$_getall_inputs: $!( $	_line = inputs$first_line - 1 + _input? $	_variable = f$element(1,"#",'omi$current_menu'$input'_input')$< $	if f$extract(0,5,f$edit(_variable,"upcase")) .eqs. "{TAG|"	 $	   then  $		gosub main$_taglist $		_input = _input + 1> $		if f$type('omi$current_menu'$input'_input') .nes. "" then - 		   $ goto main$_getall_inputsn $		return omi$_oka $	endifnM $	ws f$fao("''ESC$'[''_line';''inputs$value_location'H!''inputs$max_size'* ")*G $	_sel_list = (f$extract(0,5,f$edit(_variable,"upcase")) .eqs. "{SEL|")  $	if _sel_list	 $	   then!G $		_select_list = f$extract(0, f$locate("}", _variable) + 1, _variable)a' $		_variable = _variable - _select_listi? $		_select_list = f$edit(_select_list,"upcase") - "{SEL|" - "}"n. $		if f$type('_select_list'$filename) .nes. ""
 $		   then $			_blockname = _select_list	 $			gosub input$_from_file1 $			if $status .ne. omi$_ok then $ return $statust $		endif $		omi$screen select_listo $	endifn $! $ allinput$_prompt:i $!K $	if f$type(list$_scroll) .nes. "" then $ deletee/symbol/local list$_scrolln $	if _sel_list	 $	   then*? $		_prompt = f$element(0, "#",'omi$current_menu'$input'_input')*n $		read /end_of_file=main$end_getall_inputs /prompt="''screen$prompt_position'''_prompt': " sys$command _value| $	   else $ read /end_of_file=main$end_getall_inputs /prompt="''ESC$'[''_line';''inputs$value_location'H" sys$command _value $	endift $! $	if _value .eqs. ""	 $	   then	" $		if f$type('_variable') .eqs. ""& $		   then $ _value = main$empty_value
 $		   elseA $			_format = f$element(3, "#",'omi$current_menu'$input'_input')  / $			if _format .nes. "" .and. _format .nes. "#"y $			   then	 $				gosub input$_format! $				if $status .eq. omi$_warningg
 $				   then   $					omi$cmdline_cleareQ $					ws f$fao("''ESC$'[''_line';''inputs$value_location'H!''inputs$max_size'* ")* $					goto allinput$_prompte
 $				endif $				omi$cmdline_clear $				_value = '_variable'I	 $			endif  $			_value = '_variable' $		endif	 $	   else  $		if _sel_list 
 $		   then9 $			if f$edit(f$extract(0, 1, _value),"upcase") .eqs. "N"E $			   thene" $				deletee /symbol /local _value $				list$_scroll = "NEXT" $				omi$screen select_lists $				omi$cmdline_clear $				goto allinput$_prompt	 $			endif	9 $			if f$edit(f$extract(0, 1, _value),"upcase") .eqs. "P"f $			   then*" $				deletee /symbol /local _value $				list$_scroll = "PREVIOUS" $				omi$screen select_listy $				omi$cmdline_clear $				goto allinput$_prompt	 $			endif_ $! $			_selected = '_value'/ $			if f$type(_selected) .nes. "INTEGER" .or. -m6 			   f$type('_select_list'$value'_selected') .eqs. "" $			   then  $				omi$signal omi ivchoice $				omi$cmdline_clearP $				ws f$fao("''ESC$'[''_line';''inputs$value_location'H!''inputs$max_size'* ") $				goto allinput$_prompt	 $			endif 3 $			if f$type(scroll$previous_page) .nes. "" then -f2 			   $ deletee/symbol/global scroll$previous_page/ $			if f$type(scroll$this_page) .nes. "" then - . 			   $ deletee/symbol/global scroll$this_page/ $			if f$type(scroll$next_page) .nes. "" then -o. 			   $ deletee/symbol/global scroll$next_page1 $			if f$type(scroll$max_on_page) .nes. "" then -m0 			   $ deletee/symbol/global scroll$max_on_page $				omi$refresh1 $			'_variable' = '_select_list'$value'_selected'y
 $		   else $			'_variable' = _valueA $			_format = f$element(3, "#",'omi$current_menu'$input'_input') 	/ $			if _format .nes. "" .and. _format .nes. "#"c $			   thenm $				gosub input$_format! $				if $status .eq. omi$_warninge
 $				   then g $					omi$cmdline_clearmQ $					ws f$fao("''ESC$'[''_line';''inputs$value_location'H!''inputs$max_size'* ")t $					goto allinput$_prompt 
 $				endif $				omi$cmdline_clear $				_value = '_variable'*	 $			endif* $		endif $	endif* $!2 $	_blanks = inputs$max_size - f$length(_value) + 1* $	if f$length(_value) .le. inputs$max_sizeX $	   then $ ws f$fao("''ESC$'[''_line';''inputs$value_location'H''_value'!''_blanks'* ")t $	   else $ ws "''ESC$'[''_line';''inputs$value_location'H''f$extract(0,inputs$max_size,_value)'''ESC$'(0`''ESC$'(B" $	endif  $	_input = _input + 1 = $	if f$type('omi$current_menu'$input'_input') .nes. "" then -p 	   $ goto main$_getall_inputs $! $ main$end_getall_inputs:K $!! $	if _sel_list then $ omi$refresho $	return omi$_ok $!P $!****************************************************************************** $!" $!==>	The OMI command (SILENT_)DCL $! $ main$execcmd_silent_dcl: $!
 $	_silent = 1l $	goto dclcommand$ $! $ main$execcmd_dcl:f $!
 $	_silent = 0k $	goto dclcommand$ $! $ dclcommand$: $!A $	if (f$type(interactive_auth$'omi$current_user') .nes. "" .or. -	8 	   f$type(interactive_auth$all_users) .nes. "") .and. -& 	   f$type(omi$option) .nes. "INTEGER"	 $	   then	: $		if f$type(interactive_auth$'omi$current_user') .eqs. ""7 $		   then $ if .not. interactive_auth$all_users then -p" 			   $ goto interactive$_disallow@ $		   else $ if .not. interactive_auth$'omi$current_user' then -" 			   $ goto interactive$_disallow $		endif $	endifc $! $	if omi$_p1 .eqs. ""y	 $	   thenm@ $		read /end_of_file=dclcommand$_cancelled sys$command omi$_p1 -C 		   /prompt="''screen$prompt_position'''questions$dcl_command': " m6 $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress")4 $		if omi$_p1 .eqs. "" then $ goto  main$execcmd_dcl4 $		omi$_p2 = f$edit(f$element(1," ",omi$_p1),"trim")4 $		omi$_p3 = f$edit(f$element(2," ",omi$_p1),"trim")4 $		omi$_p4 = f$edit(f$element(3," ",omi$_p1),"trim")4 $		omi$_p5 = f$edit(f$element(4," ",omi$_p1),"trim")4 $		omi$_p1 = f$edit(f$element(0," ",omi$_p1),"trim") $	endif	 $	if _silent	 $	   then 3 $		assign /nolog "''main$silent_output'" sys$outputd2 $		assign /nolog "''main$silent_output'" sys$error $		goto dclcommand$do_it $	endiffO $	_window = ( f$extract(0,3,f$edit(screen$scroll_region,"upcase")) .eqs. "ENA")a $	if _window* $	   then $ omi$screen setup_scroll_region $	   else $ clsp $	endif$ $! $ dclcommand$do_it:p $! $	set message 'omi$_message'H $	if f$locate("ignore=dcle", omi$steering) .lt. f$length(omi$steering) -# 	   then $ on error then $ continueyH $	if f$locate("ignore=dclf", omi$steering) .lt. f$length(omi$steering) -* 	   then $ on severe_error then $ continue3 $	'omi$_p1' 'omi$_p2' 'omi$_p3' 'omi$_p4' 'omi$_p5'm $	set onH $	if f$locate("ignore=dcle", omi$steering) .lt. f$length(omi$steering) -+ 	   then $ on error then $ goto main$_fatalgH $	if f$locate("ignore=dclf", omi$steering) .lt. f$length(omi$steering) -2 	   then $ on severe_error then $ goto main$_fatal $	if _silent	 $	   theno $		_silent_status = $status_ $		deassign sys$output $		deassign sys$errory! $		deletee /symbol /local _silent_0 $		omi$display_message f$message(_silent_status) $		goto dclcommand$_cancelledp $	endifq $! $	ws ""e< $  	read /end_of_file=dclcommand$_ignore sys$command dummy -3 	   /prompt="''ESC$'[?25l''questions$wait_prompt' "n $! $ dclcommand$_ignore:o $! $	ws "''ESC$'[?25h"$ $	if _window* $	   then $ omi$screen erase_scroll_region $	   else $ omi$refresh! $	endif  $! $ dclcommand$_cancelled: $! $	if .not. omi$_debug then -C 	   $ set message /nofacility /noseverity /noidentification /notexte $	omi$cmdline_clearf $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_delete: $! $!==>	The OMI command DELETE $! $	if omi$_p1 .eqs. """	 $	   thenaC $		read /end_of_file=deletecommand$_cancelled sys$command omi$_p1 -g0 		   /prompt="''screen$prompt_position'_What: " = $		omi$_p1 = f$edit(omi$_p1,"uncomment,trim,compress,upcase")f $		omi$cmdline_clear $		goto main$execcmd_deletee $	endifp $!] $	if f$length(omi$_p1) .ge. 3 .and. omi$_p1 .eqs. f$extract(0, f$length(omi$_p1), "TEXTAREA")f	 $	   thene. $		if 'omi$current_menu'$security_level .lt. 3
 $		   then $			omi$signal omi noprivf $			return omi$_warning) $		endif $		gosub textarea$_find_ta0 $		if $status .ne. omi$_ok then $ return $status0 $		if _areas_found .gt. 1 .and. omi$_p2 .eqs. ""
 $		   then $			omi$signal omi nouniqta  $			return $status $		endif) $		if omi$_p2 .eqs. "" then $ omi$_p2 = 1c $!@ $		if f$type ('omi$current_menu'$ta_list'omi$_p2'_name) .eqs. ""
 $		   then $			omi$signal omi nosuchtak $			return $status $		endif $!4 $		if .not. 'omi$current_menu'$ta_list'omi$_p2'_keep
 $		   then $			omi$signal omi tatemp! $			return $status $		endif $!< $		_textarea_file = 'omi$current_menu'$ta_list'omi$_p2'_file' $		if f$search(_textarea_file) .eqs. ""u
 $		   then $			omi$signal omi tafnf $			return $status $		endif $! $		if questions$confirm 
 $		   then- $			_cq = "Delete " + _textarea_file + "* ? "!- $			omi$confirm "''_cq'" 'questions$answer_no/0 $			if .not. omi$confirmed then $ return omi$_ok $		endif. $		deletee /nolog /noconfirm '_textarea_file'* $!7 $		_textarea = 'omi$current_menu'$ta_list'omi$_p2'_name*! $		if f$type('_textarea) .nes. ""s
 $		   then% $			deletee /symbol /local '_textareat $		endif $! $		return omi$_oke $	endif	 $! $	omi$signal omi ivopt,deletec $! $ deletecommand$_cancelled:o $! $	omi$cmdline_clearo $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_manage: $! $!==>	The OMI command MANAGE $! $	if omi$_p1 .eqs. "BACK"f	 $	   thenm$ $		omi$_p1 = omi$manage_started_from	 $	   elsel7 $		if f$edit(omi$menu_file,"upcase") .eqs. "OMI$MANAGE" 
 $		   then $			omi$signal omi manage* $			return omi$_ok $		endif/ $		omi$manage_started_from = "''omi$menu_file'"c $		omi$_p1 = "OMI$MANAGE"  $	endifN $	goto main$execcmd_menu $!P $!****************************************************************************** $! $ main$execcmd_menu: $! $!==>	The OMI command MENU $! $	gosub main$perf_onexit9 $	if $status .eq. omi$_warning then $ return omi$_warningu3 $	if f$edit(omi$current_menu,"upcase") .nes. "MENU"u	 $	   then= $		omi$current_menu = "menu" $		gosub main$perf_onexiti $		if $status .eq. omi$_warningn
 $		   then $			omi$screen menu  $			return omi$_warning/ $		endif $	endiff $	_ref_on_cancel = 0 $! $ newmenu$_get:f $! $	if omi$_p1 .nes. ""p	 $	   then # $		omi$new_menu_file = "''omi$_p1'"o $		omi$_p1 = ""a	 $	   elseiE $		read /end_of_file=newmenu$_ignored sys$command omi$new_menu_file -n3 		   /prompt="''screen$prompt_position'Menu file: "i $		omi$cmdline_clear $		omi$msgline_clear $	endifr  $	if omi$new_menu_file .eqs. "?"	 $	   then_ $		_ref_on_cancel = 1o? $		omi$call list_files omi$:*.mnu,omi$menu_directory:*.mnu named $		goto newmenu$_get $	endif' $!- $	omi$previous_menu_file = "''omi$menu_file'"c( $	omi$menu_file = "''omi$new_menu_file'" $! $	omi$signal omi erasmnu0 $	omi$config "''omi$previous_menu_file'" Cleanup $	omi$msgline_clearc $	omi$signal omi init" $	omi$config 'omi$menu_filee $	if $status .ge. omi$_warning	 $	   then> $		omi$signal omi restmnu*( $		omi$config "''omi$menu_file'" Cleanup $		omi$msgline_clear. $		omi$menu_file = "''omi$previous_menu_file'" $		omi$signal omi init $		omi$config 'omi$menu_file $	endifr
 $	omi$refreshi $	return omi$_ok $! $ newmenu$_ignored:m $! $	if _ref_on_canceli $	   then $ omi$refresh 	 $	   elseo $		omi$cmdline_clear $		omi$msgline_clear $	endif$ $	return omi$_ok $!P $!****************************************************************************** $! $ main$execcmd_add:$ $ main$execcmd_modify: $ main$execcmd_remove: $ main$execcmd_rename: $!+ $!==>	The OMI command ...     !Preparing...e $! $	omi$signal omi not_yet $	return omi$_ok $!P $!****************************************************************************** $!J $!==>	Display an error message if users that don't have the privileges try9 $!	to execute an interactive command (using SPAWN or DCL)t $! $ interactive$_disallow: $! $	omi$signal omi nodclprv- $	return $status $!P $!******************************************************************************  P $!****************************************************************************** $!L $!==>	The enhanced textarea support in v1.41 comes with some extra commands.F $!	This routines is created to find the textareas in the current menu, $!	and their attributes. $! $ textarea$_find_ta: $! $	_input_counter = 0 $	_areas_found   = 0 $! $ textarea$_loop_ta: $!% $	_input_counter = _input_counter + 1mE $	if f$type('omi$current_menu'$input'_input_counter') .eqs. "" then -	 	   $ goto textarea$end_loop_tafH $	_format = f$element(3, "#", 'omi$current_menu'$input'_input_counter') J $	if _format .eqs. "" .or. _format .eqs. "#" then $ goto textarea$_loop_taT $	if f$edit('_format'$type, "upcase") .nes. "TEXTAREA" then $ goto textarea$_loop_ta! $	_areas_found = _areas_found + 1t3 $	'omi$current_menu'$ta_list'_areas_found'_name = -i? 	   f$element(1, "#", 'omi$current_menu'$input'_input_counter')$ $!$ $	if f$type('_format'$keep) .eqs. ""= $	   then $ 'omi$current_menu'$ta_list'_areas_found'_keep = 0nJ $	   else $ 'omi$current_menu'$ta_list'_areas_found'_keep = '_format'$keep $	endifn $!( $	if f$type('_format'$filename) .nes. ""= $	   then $ 'omi$current_menu'$ta_list'_areas_found'_file = -n 		   '_format'$filenamee= $	   else $ 'omi$current_menu'$ta_list'_areas_found'_file = -u4 		   "ta_''omi$current_menu'$input''_input_counter'" $	endifo3 $	'omi$current_menu'$ta_list'_areas_found'_file = -eY 	   f$parse('omi$current_menu'$ta_list'_areas_found'_file, "Omi$Menu_Directory:", ".txt")_ $! $	goto textarea$_loop_ta $! $ textarea$end_loop_ta:n $! $	if _areas_found .eq. 0	 $	   then' $		omi$signal omi notextarea $		return $status  $	endifn $! $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!J $!==>	Find out is a securoty level is defined for the current menu. If so,G $!	act upon it. If there's no security, return the default value, which"6 $!	is '2', meaning read and exec access for all users.D $!	If the current user is the owner of this (sub) menu, the security4 $!	level will allways be '3' (read, exec and write). $! $ main$check_security: $!. $	if f$type('omi$current_menu'$owner) .nes. ""- $	   then $ _owner = 'omi$current_menu'$owner 	 $	   elseu! $		if f$type(menu$owner) .nes. ""	
 $		   then $			_owner = menu$owneru $		endif $	endifu $!1 $	if f$type('omi$current_menu'$password) .nes. ""o	 $	   thenm2 $		if f$type('omi$current_menu'$ip_pintr) .nes. ""
 $		   then) $			if 'omi$current_menu'$ip_pintr .eq. 3e $			   then$+ $				'omi$current_menu'$security_level = -2n $				omi$signal omi suspintr $				return omi$_warning	 $			endifs $		endif* $		if 'omi$current_menu'$password .eqs. ""
 $		   then# $			omi$encrypt "Omi$System" p$_key"0 $			'omi$current_menu'$password == omi$encrypted) $			deletee /symbol /global omi$encryptedt $		endif $		_retries = 1" $! $	   password$get_input: $!1 $		on control_y then $ goto password$cancel_input! $		set terminal /noecho*n $		read /end_of_file=password$cancel_input /prompt="''screen$prompt_position'Password: " sys$command _password $		omi$msgline_clear $		goto password$_decrypt	 $! $	   password$cancel_input:c $!) $		'omi$current_menu'$security_level = -1'+ $		on control_y then $ goto main$_interrupt= $		omi$cmdline_clear $		set terminal /echos $		return omi$_oke $! $	   password$_decrypt:r $!+ $		on control_y then $ goto main$_interruptd $		omi$cmdline_clear $		set terminal /echo) $		omi$variable = "_password"  $		omi$input_validateu $		if $status .eq. omi$_errorn
 $		   then* $			'omi$current_menu'$security_level = -1 $			return omi$_warningu $		endif* $		_encryptd = 'omi$current_menu'$password$ $		omi$decrypt "''_encryptd'" p$_key! $		_decryptd = "''omi$decrypted'" ! $		deletee/symbol/local _encryptd)& $		deletee/symbol/global omi$decrypted $		if _password .nes. _decryptd	
 $		   then* $			'omi$current_menu'$security_level = -1" $			deletee/symbol/local _decryptd $			if _retries .lt. 3 $			   thent $				_retries = _retries + 1 $				omi$signal omi ivpassw  $				goto password$get_input	 $			endif 3 $			if f$type('omi$current_menu'$ip_pintr) .eqs. ""	. $			   then $ 'omi$current_menu'$ip_pintr == 1. $			   else $ 'omi$current_menu'$ip_pintr == -& 				   'omi$current_menu'$ip_pintr + 1	 $			endifs $			return omi$_warningm $		endif! $		deletee/symbol/local _decryptd 9 $		if f$type('omi$current_menu'$ip_pintr) .nes. "" then -_: 		   $ deletee /symbol /global 'omi$current_menu'$ip_pintr $!8 $		if f$type('omi$current_menu'$password_level) .nes. ""
 $		   thenI $			'omi$current_menu'$security_level = 'omi$current_menu'$password_level) $			return omi$_ok $		endif $	endif  $! $	if f$type(_owner) .nes. ""	 $	   thenn@ $		if f$locate(omi$current_user, f$edit(_owner,"upcase")) .lt. -& 		   f$length(f$edit(_owner,"upcase"))
 $		   then) $			'omi$current_menu'$security_level = 3t $			deletee/symbol/local _ownerl $			return omi$_ok $		endif $	endif3 $!1 $	if f$type('omi$current_menu'$security) .eqs. ""		 $	   then	( $		'omi$current_menu'$security_level = 2 $		return omi$_okt $	endifu $!) $	_security = 'omi$current_menu'$securitya $!4 $	if f$type('_security'$'omi$current_user') .nes. ""L $	   then $ _authorisation = f$edit('_security'$'omi$current_user',"upcase")< $	   else $ if f$type('_security'$all_users) .nes. "" then -? 		    $ _authorisation = f$edit('_security'$all_users,"upcase")s $	endife $!$ $	if f$type(_authorisation) .eqs. ""	 $	   then	( $		'omi$current_menu'$security_level = 0 $		return omi$_oke $	endifo $!C $	if f$locate("WRITE",_authorisation) .lt. f$length(_authorisation)f	 $	   thenu& $		deletee/symbol/local _authorisation( $		'omi$current_menu'$security_level = 3 $		return omi$_okr $	endif$ $!B $	if f$locate("EXEC",_authorisation) .lt. f$length(_authorisation)	 $	   thenf& $		deletee/symbol/local _authorisation( $		'omi$current_menu'$security_level = 2 $		return omi$_ok	 $	endifn $!B $	if f$locate("READ",_authorisation) .lt. f$length(_authorisation)	 $	   then$& $		deletee/symbol/local _authorisation( $		'omi$current_menu'$security_level = 1 $		return omi$_okt $	endifr $!% $	deletee/symbol/local _authorisationi' $	'omi$current_menu'$security_level = 0  $	return omi$_ok $! $ security$key_validate: $!, $	if f$type('_validate_key') .nes. "INTEGER"	 $	   thent $		omi$signal omi ivkeyval $		'_validate_key' = ""* $		return omi$_ok* $	endif* $!= $	if '_validate_key' .lt. 1 .or. '_validate_key' .gt. 1000000o	 $	   then  $		omi$signal omi ivkeyval $		'_validate_key' = ""o $		return omi$_warning $	endifc $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!N $!==>	The main exit routines. The cleanup procedure is called with a parameterH $!	that indicates whether or not the screen should be erased. In case orF $!	errors, we don't want to, since that would also erase the messages. $! $ main$_interrupt: $! $	if f$type(_silent) .nes. "" 	 $	   thenn@ $		if _silent      ! In case the interrupt was during SILENT_DCL
 $		   then $			deassign sys$output$ $			deassign sys$error $		endif $	endifn $	omi$_cls = "NOCLS" $	gosub main$_cleanupm $	ws "%OMI-S-BYEBYE, done!"n3 $	set message 'omi$_message'      ! Just in case...	 $	if .not. omi$_debugg, $	   then $ if omi$_verify then $ set verify $	endifa $	exit %X28u $! $ main$_fatal: $! $	if f$type(_silent) .nes. "" 	 $	   then < $		if _silent      ! In case the error was during SILENT_DCL
 $		   then $			deassign sys$output  $			deassign sys$error $		endif $	endifh $	omi$_cls = "NOCLS" $	gosub main$_cleanupe $	ws "%OMI-S-BYEBYE, done!" 3 $	set message 'omi$_message'      ! Just in case...m $	if .not. omi$_debug", $	   then $ if omi$_verify then $ set verify $	endif	 $	exit %X2cc $!
 $ main$_exit:  $! $	omi$_cls = "CLS" $	gosub main$_cleanupi $	ws "%OMI-S-BYEBYE, done!"nJ $	set message 'omi$_message'      ! Workaround.... there's a bug somewhere $	if .not. omi$_debugt, $	   then $ if omi$_verify then $ set verify $	endifi7 $	if f$trnlnm("omi$menu_directory") .eqs. "OMI$" then -$ 	   deassign omi$menu_directory$ $! $ main$_final_bye: $! $	exit 1 $! $ main$otf_exit: $! $	exit 1 $!P $!******************************************************************************  P $!****************************************************************************** $!G $!==>	When this procedure initializes, following options are checked toeG $!	find the start menu. If it ain't given as a parameter, the procedureiD $!	looks for the file Omi$Menu.Mnu in the current directory. Next, aD $!	logical is checked to find a user specified default. Finally, the: $!	procedure looks for the file Omi$Menu.Mnu in Sys$Login.A $!	The order in which this takes place can be modified using the sD $!	'search_path' variable in the 'main' section of the configurationH $!	file, except for the parameter; this will allways overrule everything $!	else. $! $ main$_getstart:  $!  $	if options$_startmenu .nes. ""	 $	   then @ $		omi$startmenu = "''f$parse(options$_startmenu,,,"name")'.MNU" $		return omi$_okk $	endife $!' $	if f$trnlnm("Omi$StartMenu") .nes. ""		 $	   then_G $		omi$startmenu = "''f$parse(f$trnlnm("Omi$StartMenu"),,,"name")'.MNU"l $		return omi$_oki $	endif	 $! $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!D $!==>	Look for command line parameters. These can be regular optionsH $!	(menu name, jump options), or qualifiers, if they start with a slash.G $!	If qualifiers are used, the first parameter (menu name) is required.f $! $ main$_parse_options: $! $	omi$steering = ""	 $	param$_counter = 0 $	param$_regular = 1 $! $ params$_loop:a $!% $	param$_counter = param$_counter + 1s: $	if p'param$_counter .eqs. "" then $ goto params$end_loopK $	if f$extract(0,1,p'param$_counter) .eqs. "/" then $ goto params$_qualevaleD $	if f$locate("/", p'param$_counter) .lt. f$length(p'param$_counter)	 $	   then'8 $		_this_parameter = f$element(0, "/", p'param$_counter)7 $		_this_qualifier = p'param$_counter - _this_parameterl% $		p'param$_counter = _this_parameterr) $		deletee /symbol /local _this_parametera $	endifeG $	if param$_regular .eq. 1 then $ options$_startmenu = p'param$_counter$G $	if param$_regular .eq. 2 then $ options$_menuname  = p'param$_counter G $	if param$_regular .eq. 3 then $ options$_jumps     = p'param$_counterm% $	param$_regular = param$_regular + 1$% $	if f$type(_this_qualifier) .nes. "" 	 $	   then_% $		p'param$_counter = _this_qualifier$) $		deletee /symbol /local _this_qualifier	 $		goto params$_qualeval $	endif  $	goto params$_loop= $! $ params$_qualeval:r $! $	qual$_counter = 1m $! $ quals$_loop: $!> $	_qualifier = f$element(qual$_counter, "/", p'param$_counter)2 $	if _qualifier .eqs. "/" then $ goto params$_loop> $	qual$_name  = f$edit(f$element(0, "=", _qualifier),"upcase")> $	qual$_value = f$edit(f$element(1, "=", _qualifier),"upcase")2 $	if qual$_value .eqs. "=" then $ qual$_value = ""+ $	_value_specified = (qual$_value .nes. "")u $!+ $	if f$extract(0, 2, qual$_name) .eqs. "NO"g	 $	   thennB $		qual$_name = f$extract(2, f$length(qual$_name) - 2, qual$_name) $		_negate = 1 $	   else $ _negate = 0t $	endif) $!A $	if _negate .and. _value_specified then $ goto qual$notneg_error. $!> $	if f$length(qual$_name) .lt. 3 then $ goto qual$abkeyw_error# $	qual$_counter = qual$_counter + 1  $! $!==>	/[NO]DEBUG qualifier $!A $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "DEBUG")r	 $	   thene $		if _value_specified% $		   then $ omi$_debug = qual$_valuei* $		   else $ omi$_debug = (_negate .eq. 0) $		endif $		if omi$_debug- $		   then $ if omi$_verify then $ set verifyo $		endif $		goto quals$_loops $	endif_ $!" $!==>	/SUBMENU=menu-name qualifier $!C $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "SUBMENU")m	 $	   theni% $		if _negate then $ goto quals$_loope8 $		if qual$_value .eqs. "" then $ goto qual$valreq_error( $		options$_menuname  = "''qual$_value'" $		goto quals$_loopt $	endif/ $! $!==>	/JUMPS=jumps qualifier $!A $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "JUMPS").	 $	   thene% $		if _negate then $ goto quals$_loopi8 $		if qual$_value .eqs. "" then $ goto qual$valreq_error% $		options$_jumps  = "''qual$_value'"x $		goto quals$_loop$ $	endifM $! $!==>	/VALIDATE[=log-file] $!D $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "VALIDATE")	 $	   theno% $		if _negate then $ goto quals$_loope $		omi$validate_mode = 1 $		if qual$_value .eqs. ""# $		   then $ validate$log_file = "" 1 $		   else $ validate$log_file = "''qual$_value'"	 $		endif $		omi$progress = 0  $		goto quals$_loopi $	endif  $! $!==>	/BATCH qualifier $!A $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "BATCH").	 $	   thene
 $		if _negateo
 $		   then $			omi$batch_mode = 0 $			omi$progress = 1
 $		   else $			omi$batch_mode = 1 $			omi$progress = 0 $		endif $		goto quals$_loopa $	endifu $!* $!==>	/BACKGROUND=(BATCH|DETACH) qualifier $!F $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "BACKGROUND")	 $	   then*% $		if _negate then $ goto quals$_loop*7 $		if qual$_value .eqs. "" then $ qual$_value = "BATCH" 5 $		if f$extract(0, 3, qual$_value) .eqs. "BAT" then -e$ 		   $ omi$background_mode = "batch"5 $		if f$extract(0, 3, qual$_value) .eqs. "DET" then -p% 		   $ omi$background_mode = "detach"f1 $		if f$type(omi$background_mode) .eqs. "" then -	 		   $ goto qual$ivbgrmod_errore? $		if f$type(omi$batch_mode) .eqs. "" then $ omi$batch_mode = 1m; $		if f$type(omi$progress) .eqs. "" then $ omi$progress = 0t $		omi$backgr_mode = 1 $		goto quals$_loop) $	endifs $!) $!==>	/[NO]IGNORE=(keyword,...) qualifierm $!B $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "IGNORE")	 $	   thens $		_ignores = ""% $		if _negate then $ goto quals$_loopi8 $		if qual$_value .eqs. "" then $ goto qual$valreq_errorB $		qual$_value = f$edit(qual$_value,"collapse,upcase") - "(" - ")" $		_ign_cnt = 0  $! $	 ignore$_values: $! $		_this_ign = ""s6 $		_ignore_val = f$element(_ign_cnt, ",", qual$_value)< $		if _ignore_val .eqs. "" .or. _ignore_val .eqs. "," then - 		   $ goto ignore$got_valuese@ $		if f$length(_ignore_val) .lt. 4 then $ goto qual$abkeyw_error $! $!		==> /IGNORE=DUPLICATES $!6 $		if f$extract(0, 4, _ignore_val) .eqs. "DUPL" then - 		   $ _this_ignore = "dupl" $! $!		==> /IGNORE=DCLWARNINGS  $!6 $		if f$extract(0, 4, _ignore_val) .eqs. "DCLE" then - 		   $ _this_ignore = "dcle" $! $!		==> /IGNORE=DCLFATALS= $!6 $		if f$extract(0, 4, _ignore_val) .eqs. "DCLF" then - 		   $ _this_ignore = "dclf"9 $		if _this_ignore .eqs. "" then $ goto qual$ivkeyw_error 2 $		_ignores = "''_ignores',ignore=''_this_ignore'" $		_ign_cnt = _ign_cnt + 1 $		goto ignore$_values $! $	 ignore$got_values:r $!/ $		omi$steering = "''omi$steering',''_ignores'"! $		goto quals$_loopp $	endif  $! $!==>	/[NO]PROGRESS qualifierl $!D $	if qual$_name .eqs. f$extract(0, f$length(qual$_name), "PROGRESS")	 $	   thent
 $		if _negate	 $		   then $ omi$progress = 0p $		   else $ omi$progress = 1$ $		endif $		goto quals$_loopN $	endif	 $!B $ !     if qual$_name .eqs. f$extract(0, f$length(qual$_name), "") $ !	then $ !	     goto quals$_loop	
 $ !     endif= $! $	goto qual$ivqual_error $! $ params$end_loop: $!G $	if f$type(options$_startmenu) .eqs. "" then $ options$_startmenu = ""fG $	if f$type(options$_menuname)  .eqs. "" then $ options$_menuname  = ""pG $	if f$type(options$_jumps)     .eqs. "" then $ options$_jumps     = ""i $	return $!P $!****************************************************************************** $!I $!==>	If any errors in the parsing routine show up, they're handled here.dC $!	This is kept apart since this is the very first beginning of themE $!	initialision process, in which most of the OMI symbols are set up.g $! $ qual$abkeyw_error: $!N $	_message = "ABKEYW, ambiguous qualifier or keyword - supply more characters" $	goto qual$_error $! $ qual$ivqual_error: $!W $	_message = "IVQUAL, unrecognized qualifier - check validity, spelling, and placement"s $	goto qual$_error $! $ qual$valreq_error: $!V $	_message = "VALREQ, missing qualifier or keyword value - supply all required values" $	goto qual$_error $! $ qual$ivkeyw_error: $!H $	_message = "IVKEYW, unrecognized keyword - check validity and spelling& $	qual$_name = qual$_value ! Dirty.... $	goto qual$_error $! $ qual$notneg_error: $!T $	_message = "NOTNEG, qualifier or keyword not negatable - remove 'NO' or omit value  $	qual$_name = "NO''qual$_name'" $	goto qual$_error $! $ qual$ivbgrmod_error: $!J $	_message = "IVBGRMOD, invalid background mode - specify BATCH or DETACH" $	qual$_name = "''qual$_value'"q $	goto qual$_error $! $ qual$_error: $!& $	write sys$error "%OMI-W-''_message'"$ $	write sys$error " \''qual$_name'\" $	goto main$_final_bye $!P $!******************************************************************************  P $!****************************************************************************** $!F $!==>	Setup the environment. This is done by calling the subprocedures; $!	that will setup all global symbols, define the menus and = $!	the screen layout, and define some internally used foreignc@ $!	commands. Symbols defined in this routine can be local, since  $!	this is the master procedure. $! $ main$_initialize:* $! $	if f$trnlnm("Omi$") .eqs. ""	 $	   then! $		_thisfile_location = -!D 		   f$parse(f$environment("procedure"),,,"device","no_conceal") + -J 		   f$parse(f$environment("procedure"),,,"directory","no_conceal") - "]["- $		define /nolog Omi$ "''_thisfile_location'"* $	endif*7 $	omi$nodename = f$edit(f$getsyi("scsnode"),"collapse")r> $	omi$current_user = f$edit(f$getjpi(0,"username"),"collapse") $	omi$_ok	= %X1fff3001 $	omi$_cancelled = %X1fff30ad* $	omi$_warning   = %X1fff30af* $	omi$_error     = %X1fff30b5e $	ESC$[0,8]  = %X1b	 $	BELL$[0,8] = %X7 $	LF$[0,8]   = %Xa $	CR$[0,8]   = %Xd $	FF$[0,8]   = %Xc $	if .not. omi$_debug then -C 	   $ set message /nofacility /noseverity /noidentification /notext!9 $	search Nla0: DummyStringToSetOmi$_NoMatch /output=Nla0:e $	omi$_nomatch   = $status $	set message 'omi$_messaget $!	omi$_nomatch   = %X08d78053 $	keyring$p$_key = "W"i $	perf$init_exit = 1 $! $	@Omi$:Omi$Config Setup- $	if $status .eq. omi$_error then $ exit %X2c	 $! $	@Omi$:Omi$Screen Setup $!- $	omi$config       := "@Omi$:Omi$Config Menu"_( $	omi$screen       := "@Omi$:Omi$Screen". $	omi$clear_screen := "@Omi$:Omi$Screen clear"0 $	omi$refresh      := "@Omi$:Omi$Screen refresh"5 $	omi$display_info := "@Omi$:Omi$Screen display_info"= $! $	if omi$batch_mode 	 $	   theni   $		omi$cmdline_clear   := "!"  $		omi$msgline_clear   := "!"(+ $		omi$display_message := "write sys$error"i	 $	   else-i $		omi$cmdline_clear   := "write sys$output f$fao(""''screen$prompt_position'!''screen$line_length'* "")"	 $		omi$msgline_clear   := "write sys$error f$fao(""''ESC$'[''screen$line_message';''screen$default_position'H!''screen$line_length'* "")"=k $		omi$display_message := "write sys$error ""''ESC$'[''screen$line_message';''screen$default_position'H""+". $	endif_ $!4 $	open /read /share=read /error=main$notoolbox_ini -  	   tb$init Omi$:Omi$ToolBox.Ini $! $ main$_init_toolbox:$ $!7 $	read /end_of_file=main$end_init_toolbox tb$init _toolt3 $	_tool = f$edit(_tool,"uncomment,collapse,upcase")"2 $	if _tool .eqs. "" then $ goto main$_init_toolbox: $	if _tool .eqs. "<EOF>" then $ goto main$end_init_toolbox# $	if f$extract(0,1,_tool) .eqs. "["e	 $	   then: $		toolbox = _tool - "[" - "]", $		toolbox = f$parse(toolbox,"OMI$:",".COM") $		goto main$_init_toolbox $	endift $	if toolbox .eqs. "" 	 $	   thenr $		omi$signal omi toolerrn $		goto main$end_init_toolboxm $	endif  $	if .not. omi$_debug then -C 	   $ set message /nofacility /noseverity /noidentification /notexti- $	search 'toolbox' "''_tool'$:" /output=nla0:l $	if $status .eq. omi$_nomatch	 $	   then! $		set message 'omi$_message! $		omi$signal omi noroutine,_tool*9 $		read /end_of_file=mit$_no_routine sys$command _dummy -*A 		   /prompt="''screen$prompt_position'''questions$wait_prompt' "! $		omi$msgline_clear $		omi$cmdline_clear $		omi$signal omi checktoolbox9 $		read /end_of_file=mit$_no_routine sys$command _dummy -iA 		   /prompt="''screen$prompt_position'''questions$wait_prompt' "l $		goto mit$_no_routinen $	endifi $! $	set message 'omi$_messaget' $	omi$'_tool' := "@''toolbox' ''_tool'"n $	goto main$_init_toolboxi $! $ mit$_no_routine: $! $	ws ""e $	omi$msgline_clear" $	omi$cmdline_clear  $	goto main$_init_toolboxi $! $ main$end_init_toolbox: $! $	close tb$initn $!% $! Define the valid internal commands I $! The boolean following the command indicated wether or not this commandS $! is available in Otf- menusa $! $	omi$valid_commands = -K 	   "#ADD,0#ALL,1#BACK,1#CALC,1#CLS,1#DCL,1#DELETE,1#EDIT,1#ENCRYPT,0#" + -	C 	   "EXIT,0#EXPORT,1#HELP,1#IMPORT,1#INCREASE,1#INFO,0#JUMP,0#" + -,D 	   "MAIN,0#MANAGE,0#MENU,0#MODIFY,0#QUIT,0#REFRESH,1#RENAME,0#" + -B 	   "REMOVE,0#RESET,1#SET,1#SILENT_DCL,1#SHOW,1#SPAWN,1#SUBMIT,1#" $! $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!J $!==>	Find out if any default values where defined for input items. If so, $!	set them.C $!	This has to be done in this procedure, since the symbols have to  $!	be local. $! $ main$default_values: $!9 $	assign sys$scratch:omi$setup_defaults._tmp1$ sys$outputp $	show symbol /global *$input* $	deassign sys$output$H $	search sys$scratch:omi$setup_defaults._tmp1$ 'init_def$search_string -0 	   /output=sys$scratch:omi$setup_defaults._tmp$ $	if $status .eq. omi$_nomatch	 $	   then C $		deletee /nolog /noconfirm sys$scratch:omi$setup_defaults._tmp1$;$B $		deletee /nolog /noconfirm sys$scratch:omi$setup_defaults._tmp$; $		return omi$_oku $	endifiB $	deletee /nolog /noconfirm sys$scratch:omi$setup_defaults._tmp1$;D $	open /read omi$setup_defaults sys$scratch:omi$setup_defaults._tmp$ $! $ init$_defaults:$ $!B $	read /end_of_file=init$end_defaults omi$setup_defaults omi$valueF $	if f$element(2, "#", f$extract(0,f$length(omi$value)-1,omi$value)) -H 	   .eqs. "#" .or. f$element(2, "#", f$extract(0,f$length(omi$value)-1,- 	   omi$value)) .eqs. ""	 $	   then	! $		if f$type (varreset$) .nes. ""f
 $		   then< $			if f$extract(0, 1, f$element(1,"#",omi$value)) .eqs. "{" $			   then $ _value = "''f$extract(f$locate("}",f$element(1,"#",omi$value))+1, f$length(f$element(1,"#",omi$value)), f$element(1,"#",omi$value))'" 8 $			   else $ _value = "''f$element(1, "#", omi$value)'"	 $			endife $			_value = _value - """o $			varreset$ = varreset$ + 1 A $			set message /nofacility /noseverity /noidentification /notext	( $			if f$type ('_value') .nes. "" then -' 			   $ deletee /symbol /local '_value's $			set message 'omi$_messagem $		endif $		goto init$_defaults $	endife $!: $	if f$extract(0, 1, f$element(1,"#",omi$value)) .eqs. "{"	 $	   thenc $		_value = "''f$extract(f$locate("}",f$element(1,"#",omi$value))+1, f$length(f$element(1,"#",omi$value)), f$element(1,"#",omi$value))'"b $		_block = f$extract(1, f$locate("}", f$element(1,"#",omi$value))-1, f$element(1,"#", omi$value)), $		_block = f$edit(_block,"upcase") - "SEL|" $!! $		if f$type (varreset$) .nes. ""i
 $		   then $			varreset$ = varreset$ + 1sA $			set message /nofacility /noseverity /noidentification /notextf' $			if f$type('_value') .nes. "" then - : 			   $ deletee /symbol /local '_value'  ! RESET VARIABLES $			set message 'omi$_message_ $		endif $!( $		if f$type('_block'$filename) .nes. ""
 $		   then $			_blockname = _block( $			gosub input$_from_file $			_status = $status_+ $			if _status .ne. omi$_ok then $ omi$wait	 $		   else $ _status = omi$_ok $		endif $!E $		if f$extract(0,4,_block) .nes. "TAG|" .and. _status .eq. omi$_ok -	< 		   then $ '_value' = '_block'$'f$element(2,"#",omi$value)'	 $	   else*6 $		_default_value = f$element(2, "#", omi$value) - """ $		_variable = "_default_value"a. $		_format = f$element(3, "#",omi$value) - """ $!! $		if f$type (varreset$) .nes. ""a
 $		   then $			varreset$ = varreset$ + 1$A $			set message /nofacility /noseverity /noidentification /notexta= $			if f$type('f$element(1, "#", omi$value)') .nes. "" then -'P 			   $ deletee /symbol /local 'f$element(1, "#", omi$value)'  ! RESET VARIABLES $			set message 'omi$_message  $		endif $!I $		if _format .nes. "" .and. _format .nes. "#" .and. '_variable' .nes. ""t
 $		   then $			gosub input$_formatu  $			if $status .eq. omi$_warningE $			   then $ 'f$element(1, "#", omi$value) = "Invalid default value"*9 $			   else $ 'f$element(1, "#", omi$value) = '_variable'M	 $			endifS8 $		   else $ 'f$element(1, "#", omi$value) = '_variable' $		endif $	endifm $	goto init$_defaultsd $! $ init$end_defaults: $! $	close omi$setup_defaults> $	delete/noconfirm/nolog sys$scratch:omi$setup_defaults._tmp$; $	return omi$_ok $!P $!******************************************************************************  P $!****************************************************************************** $!J $!==>	Delete all symbols and all logicals that were set by this procedure,F $!	erase the screen (if not called from an error routine), and restore $!	all original settings.c $! $ main$_cleanup: $!( $	@Omi$:Omi$Screen Cleanup "''omi$_cls'"M $	if omi$_cls .nes. "NOCLS" then $ deletee /symbol /local omi$display_message/3 $	ws "%OMI-I-REMFILES, removing temporary files..."a $!H $	if f$trnlnm("calc$_subresults") .nes. "" then $ close calc$_subresultsC $	if f$search("sys$scratch:calc$_subresults._tmp$") .nes. "" then -nD 	   $ deletee /nolog /noconfirm sys$scratch:calc$_subresults._tmp$;*E $	if f$search("sys$scratch:omi$check_otf_menu._tmp$") .nes. "" then -_F 	   $ deletee /nolog /noconfirm sys$scratch:omi$check_otf_menu._tmp$;*A $	if f$search("sys$scratch:omi$import_key._tmp$") .nes. "" then -aB 	   $ deletee /nolog /noconfirm sys$scratch:omi$import_key._tmp$;*= $	if f$search("Sys$Scratch:Omi$NewCfg._Tmp$") .nes. "" then -n> 	   $ deletee /nolog /noconfirm Sys$Scratch:Omi$NewCfg._Tmp$;*B $	if f$type(ta$remove_files) .eqs. "" then $ goto cleanup$clearmem $	_ta_counter = 0e $! $ cleanup$delfiles:  $!9 $	_ta_file = f$element(_ta_counter, ",", ta$remove_files)lK $	if _ta_file .eqs. "" .or. _ta_file .eqs. "," then $ goto cleanup$clearmemo $	_ta_file = f$search(_ta_file)l@ $	if _ta_file .nes. "" then $ delete/nolog /noconfirm '_ta_file' $	_ta_counter = _ta_counter + 1  $	goto cleanup$delfilesi $! $ cleanup$clearmem:  $!* $	ws "%OMI-I-CLEARMEM, clearing memory..." $	@Omi$:Omi$ToolBox CleanuphP $	if f$type(omi$menu_file) .nes. "" then $ omi$config "''omi$menu_file'" Cleanup# $	@Omi$:Omi$Config Setup "" CleanuphC $	if f$type(omi$inputs) .nes. "" then $ gosub cleanup$missing_items = $	if f$type(_thisfile_location) .nes. "" then $ deassign Omi$s $! $	return omi$_ok $! $ cleanup$missing_items: $! $	if .not. omi$inputso	 $	   thenm# $		deletee/symbol/global omi$inputsg $		return omi$_okc $	endif	8 $	assign sys$scratch:omi$symbol_cleanup._tmp$ sys$output/ $	define sys$error nla0: ! Added by Edward Vlak5 $	show symbol /global *$item*! $	deassign sys$outputo $	deassign sys$errorD $	open /read omi$symbol_cleanup sys$scratch:omi$symbol_cleanup._tmp$ $! $ cleanup$_symbols:i $!E $	read /end_of_file=cleanup$end_symbols omi$symbol_cleanup omi$symboleC $	if f$locate("command#all", f$edit(omi$symbol,"lowercase")) .lt. -m7 	   f$length(omi$symbol) then $ deletee/symbol/global -*5 	   'f$element(0, "=", f$edit(omi$symbol,"collapse"))* $	goto cleanup$_symbolsl $! $ cleanup$end_symbols: $! $	close omi$symbol_cleanup> $	delete/noconfirm/nolog sys$scratch:omi$symbol_cleanup._tmp$;" $	deletee/symbol/global omi$inputs $	return omi$_ok $!P $!******************************************************************************