/* definitions for ZT<->ZTnetserver protocol */

typedef struct IOSB {
	unsigned short status;
	unsigned short count;
	unsigned long devdep;
} IOSB;


/***** ZTNS function codes *****/

#define ZTNS_F_IOREQ	1	/* ZT -> NS: iofunc + count		*/
#define ZTNS_F_IOREPLY	2	/* NS -> ZT: iosb,			*/
				/*   ZT -> NS: iosb.status only		*/
				/*		(after CMP & PUT)	*/
#define ZTNS_F_DATA	3	/* 'DMA' data (both directions): count	*/
#define ZTNS_F_R_DATA	4	/* NS -> ZT: accept <count> 'DMA' data	*/
#define ZTNS_F_W_DATA	5	/* NS -> ZT: send <count> 'DMA' data	*/
#define ZTNS_F_C_DATA	6	/* NS -> ZT: rcv.&check <count> 'DMA' data */


/***** ZTNS network messages *****/

#define ZTNS_DATALEN 1400	/* max. #bytes transferred in 1 message */
				/* ? ought to be a single Ethernet packet ? */

typedef struct ZTNS_MSG {
	int seq;		/* sequence number, starts at 1 */
	unsigned short func;	/* ZTNS_F_xxxx */
	unsigned short iofunc;	/* used by:	IOREQ, IO$_xxx + modifiers */
	int count;		/* used by:	IOREQ (signed!), 
						xxxDATA (total cnt),
						DATA (#bytes in 'data') */
	IOSB iosb;		/* used by:	IOREPLY */
	unsigned char data[ZTNS_DATALEN];	/* used with DATA only */
} ZTNS_MSG;

#define ZTNS_LEN1 (sizeof(ZTNS_MSG) - ZTNS_DATALEN)	/* short packet */

/* note: length of a DATA packet must be ZTNS_LEN1 + (count) */
