[INHERIT ('SYS$LIBRARY:STARLET', 'VCDEFS', 'TAR')]

MODULE list ;


   PROCEDURE find_device_structure (
      device_name : VARYING [n1] OF char ;
      VAR dir : [UNSAFE] integer ;          { Device is directory-structured }
      VAR sdi : [UNSAFE] integer) ;         { Device is single-dir structured }

      BEGIN
         lib_sigiferr ($GETDVIW (,, device_name, lib_item_list (
            lib_out_item (DVI$_DIR, %DESCR dir),
            lib_out_item (DVI$_SDI, %DESCR sdi)))) END ;


   [GLOBAL] PROCEDURE tar_list (
      list_filespec : VARYING [n1] OF char ;
      archive_filespec : VARYING [n2] OF char ;
      full : boolean) ;

      TYPE
         fixed_string = PACKED ARRAY [1..255] OF char ;

         fixed_string_ptr = RECORD CASE integer OF
0:(         address : unsigned) ;
1:(         pointer : ^fixed_string) END ;

      VAR
         file_spec : medium_string ;
         file_size : integer ;
         file_mtime : unsigned ;
         file_mode : file_mode_type ;
         directory : boolean ;

         files_listed, files_in_archive : integer ;
         directory_structured : integer ;
         single_directory_structured : integer ;
         more_in_archive : boolean ;

      PROCEDURE list_file_if (   { list file if it matches list_filespec }
         VAR header_record : tar_record_type ;
         full : boolean ;
         file_spec : VARYING [n1] OF char ;
         file_size : integer ;
         file_mtime : unsigned ;
         file_mode : file_mode_type ;
         directory : boolean := false) ;

         VAR
            prot_list : PACKED ARRAY [1..10] OF char ;
            out_line : medium_string ;
            uid_int, gid_int : integer ;

         BEGIN
            IF success (STR$MATCH_WILD (file_spec, list_filespec))
            THEN WITH header_record DO BEGIN
               IF full THEN BEGIN
                  prot_list := '-rwxrwxrwx' ;
                  readv (uid.value, uid_int:oct) ;
                  readv (gid.value, gid_int:oct) ;
                  FOR i := 0 TO 8 DO
                     IF NOT file_mode.mask[i] THEN prot_list[10-i] := '-' ;
		  IF file_mode.mask[10] THEN
                     prot_list[1] := 'd'   { Directory }
                  ELSE IF header_record.linkflag IN ['1', '2'] THEN
                     prot_list[1] := 'l' ;  { Link }
                  out_line := '' ;
                  lib_sigiferr (LIB$SYS_FAO ('!AS !4UL/!3UL!10UL  !AS  !AS',,
                     out_line, %STDESCR (prot_list), uid_int, gid_int,
                     file_size,
                     %STDESCR (UNIX_time_to_str (file_mtime, delta_seconds)),
                     %STDESCR (file_spec))) ;
                  writeln (out_line) END
               ELSE
                  writeln (file_size:10, space, file_spec) ;
               files_listed := files_listed + 1 END ;
            END ;

      BEGIN    { tar_list }
         full_archive_spec := parse (archive_filespec, '.DAT') ;
         find_device_structure (full_archive_spec, directory_structured,
            single_directory_structured) ;
         open_archive_input (archive_filespec,
            share := NOT (single_directory_structured)::boolean) ;
         full_archive_spec := find_file_spec (archive) ;
         files_listed := 0 ;
         files_in_archive := 0 ;
         more_in_archive := valid_header (archive^, file_spec, file_size,
            file_mtime, file_mode, directory) ;

         IF NOT (directory_structured)::boolean THEN
            full_archive_spec := substr (full_archive_spec, 1,
               index (full_archive_spec, colon)) ;

         IF NOT more_in_archive THEN
            LIB$STOP (tar__badarchive, 1, %STDESCR (full_archive_spec)) ;
         writeln (crlf, 'Listing of archive ', full_archive_spec, crlf) ;
         WHILE more_in_archive DO BEGIN
            files_in_archive := files_in_archive + 1 ;
            list_file_if (archive^, full, file_spec, file_size, file_mtime,
               file_mode, directory) ;
            scan_to_next_header (file_size) ;
            IF eof (archive) THEN
               more_in_archive := false
            ELSE BEGIN
               get (archive) ;   { we're actually just before next header }
               more_in_archive := valid_header (archive^, file_spec, file_size,
                  file_mtime, file_mode, directory) END END ;
         IF files_listed > 0 THEN writeln ;
         writeln ('Total of ', files_listed:1, ' files listed, ',
            files_in_archive:1, ' files in archive.') ;
         close (archive) ;
         END ;


   END.
