{
! VCDEFS.PAS -	VCLIB definitions needed by TAR
!
! This file contains all definitions needed by TAR when packaged for
! external distribution.  When TAR is built locally, these definitions
! come from SRC_VCLIB:VCLIB.PEN, but for the distribution package, I
! have extracted the needed definitions from the appropriate files in
! SRC_VCLIB:  Any routines defined in here but not coded in here will
! be in appropriately named MACRO source files.
!
! This file can be used to build an evironment and object file to be used
! when building TAR, or it can be %INCLUDEd by TAR.PAS, or it can be
! /INSERTed into a help library.
!
! Tim Cook, 24-FEB-1989
!--------------------------------------------------------------
!} [INHERIT ('SYS$LIBRARY:STARLET'), ENVIRONMENT ('VCDEFS')] {
!} MODULE vclib ; {
!
! From SRC_VCLIB:LIBDEF.PAS
!
1 LIBDEFPAS
2 CONST
!} CONST
      lib_k_maxbyte = %xFF ;
      lib_k_maxword = %xFFFF ;
      lib_k_maxlong = %xFFFFFFFF ;{
2 TYPE
!} TYPE
      sts_type = integer ;
      lib_lo_hi = (low, high) ;
      lib_byte_type = [BYTE] 0..lib_k_maxbyte ;
      lib_word_type = [WORD] 0..lib_k_maxword ;
      lib_signed_word_type = [WORD] -%x8000..%x7FFF ;
      lib_long_type = [LONG] unsigned ;
      lib_3byte_type = [BYTE(3)] 0..%xFFFFFF ;
      lib_quad_type = [QUAD] ARRAY [low..high] OF unsigned ;
      lib_signed_quad_type = [QUAD] RECORD CASE integer OF
0:(      lo : unsigned ;
         hi : integer) ;
1:(      value : [QUAD] PACKED SET OF 0..63) END ;
      lib_date_type = lib_signed_quad_type ;
      prv_type = [QUAD] PACKED SET OF 0..63 ;
      lib_long_set_type = [LONG] SET OF 0..31 ;
      lib_sigargs_type = RECORD
         param_count : unsigned ;
         condition : sts_type ;
         parameter : ARRAY [1..20] OF unsigned END ;
      lib_mechargs_type = RECORD
         param_count : unsigned ;
         stack_frame_address : unsigned ;
         stack_frame_depth : unsigned ;
         r0, r1 : unsigned END ;
      lib_fab_pointer = ^FAB$TYPE ;
      lib_numtim_type = RECORD
         year, month, day,
         hour, minute, second, hundredth : lib_word_type ; END ;
      lib_item_type = RECORD
         buffer_length : lib_word_type ;
         item_code : lib_word_type ;
         buffer_address : lib_long_type ;
         retlength_adress : lib_long_type END ;
      lib_extended_item_type = RECORD
         item : lib_item_type ;
         buffer : PACKED ARRAY [1..80] OF char END ;
      lib_item_list_type = ARRAY [1..85] OF lib_item_type ;

      fab_pointer = ^FAB$TYPE ;
      rab_pointer = ^RAB$TYPE ;
      nam_pointer = ^NAM$TYPE ;
      nam_rs_type = PACKED ARRAY [1..NAM$C_MAXRSS] OF char ;
      nam_rsa_type = ^nam_rs_type ;
      xab_pointer = ^XAB$TYPE ;{
2  DEC_Routines
!}
   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$cvt_from_internal_time (
      %REF operation : unsigned ;
      VAR resultant_time : unsigned ;
      %REF input_time : [UNSAFE] lib_date_type := %IMMED 0)
         : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$cvt_vectim (
      %REF input_time : [UNSAFE] lib_numtim_type ;
      VAR resultant_time : [UNSAFE] lib_date_type) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$find_file (
      %DESCR file_spec : VARYING [n1] OF char ;
      %DESCR result_spec : VARYING [n2] OF char ;
      %REF context : lib_fab_pointer := %REF 0 ;
      %DESCR default_spec : VARYING [n4] OF char := %IMMED 0 ;
      %DESCR related_spec : VARYING [n5] OF char := %IMMED 0 ;
      %REF stv_addr : sts_type := %IMMED 0 ;
      %REF user_flags : lib_long_set_type := []) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$find_file_end (
      %REF context : lib_fab_pointer := %REF 0) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$get_input (
      %DESCR get_str : VARYING [n1] OF char ;
      %DESCR prompt : VARYING [n2] OF char := %IMMED 0 ;
      VAR out_len : lib_word_type := %IMMED 0) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$getjpi (
      %REF item_code : lib_word_type ;
      VAR process_id : unsigned := %IMMED 0 ;
      %DESCR process_name : VARYING [n] OF char := %IMMED 0 ;
      VAR resultant_value : [UNSAFE] unsigned := %IMMED 0 ;
      %DESCR resultant_string : VARYING [n2] OF char := %IMMED 0 ;
      VAR resultant_length : lib_word_type := %IMMED 0) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$sub_times (
      %REF time_1, time_2 : [UNSAFE] lib_date_type ;
      VAR resultant_time : [UNSAFE] lib_date_type) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION lib$sys_fao (
      ctr_str : [CLASS_S] PACKED ARRAY [l1..u1:integer] OF char ;
      %REF out_len : lib_word_type := %IMMED 0 ;
      %DESCR out_buf : VARYING [n3] OF char ;
      %IMMED p : [LIST] unsigned) : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] PROCEDURE lib$signal (
      %IMMED condition : [UNSAFE] sts_type ;
      %IMMED parameters : [UNSAFE,LIST] unsigned) ; external ;

   [ASYNCHRONOUS,EXTERNAL] PROCEDURE lib$stop (
      %IMMED condition : [UNSAFE] sts_type ;
      %IMMED parameters : [UNSAFE,LIST] unsigned) ; external ;{
!
! From nowhere in particular
!
1 SYSDEFPAS
2 DEC_Routines
!}
   [ASYNCHRONOUS,EXTERNAL] FUNCTION SYS$SETDFPROT (
      %REF new_def_prot : lib_word_type := %IMMED 0 ;
      VAR cur_def_prot : lib_word_type := %IMMED 0) : sts_type ; external ;{
!
! From SRC_VCLIB:CLIDEF.PAS
!
1 CLIDEFPAS
2 DEC_Routines
!}
   [ASYNCHRONOUS,EXTERNAL] FUNCTION cli$present (
      %STDESCR name : [CLASS_S] PACKED ARRAY [l1..u1:integer] OF char )
         : sts_type ; external ;

   [ASYNCHRONOUS,EXTERNAL] FUNCTION cli$get_value (
      %STDESCR name : PACKED ARRAY [l1..u1 : integer] OF char ;
      %DESCR retbuf : VARYING [n2] OF char) : sts_type ; external ;{
!
! From SRC_VCLIB:STRDEF.PAS
!
1 STRDEFPAS
2 DEC_Routines
!}
   [ASYNCHRONOUS,EXTERNAL] FUNCTION str$match_wild (
      %DESCR cand_str : VARYING [n1] OF char ;
      %DESCR pattern_str : VARYING [n2] OF char) : sts_type ; external ;{
!
! Form SRC_VCLIB:PASMSG.PAS
!
1 PASMSG
!}
CONST
   %INCLUDE 'SYS$LIBRARY:PASDEF.PAS'

VAR
   PAS$_FACILITY     : [EXTERNAL,VALUE] sts_type ;{
!
! From SRC_VCLIB:LIBITMLST.DEC
!
1 LIB_ITEM_LIST
  FUNCTIONAL DESCRIPTION:
     Builds an item list in its own static storage, and returns the
     address of the item list.  This routine is designed to be called
     directly from the parameter list of system services such as $MOUNT
     $GETDVI, $GETJPI, and $GETSYI (see PASCAL DECLARATION for an example).

  CALLING SEQUENCE:    item_list_address.rr.r = (item.rr.r[,...])

  IMPLICIT INPUTS:     None.

  IMPLICIT OUTPUTS:    None.

  SIDE EFFECTS:        None.
2 Parameters
  item -- items for inclusion in the item list.  The best way to to generate
          these is with LIB_IN_ITEM and LIB_OUT_ITEM.
2 Completion_Status
  none -- does not return any status values.
2 PASCAL_Definition
!}
   [EXTERNAL] FUNCTION lib_item_list (item : [UNSAFE,LIST] lib_item_type) :
      lib_item_list_type ; external ;{
3 Calling_Example
[INHERIT ('STARLET_PEN','VCLIB_PEN')] PROGRAM dvitest (output) ;
   VAR
      logvolnam, disk_label, device : VARYING [20] OF char := '' ;
      free_blocks, disk_size, disk_owner_pid : unsigned := 0 ;
   BEGIN
      lib_sigiferr ($GETDVI (,, 'DISK$0', lib_item_list (
         lib_out_item (dvi$_maxblock,   %DESCR disk_size),
         lib_out_item (dvi$_freeblocks, %DESCR free_blocks),
         lib_out_item (dvi$_logvolnam,  %DESCR logvolnam),
         lib_out_item (dvi$_volnam,     %DESCR disk_label),
         lib_out_item (dvi$_devnam,     %DESCR device),
         lib_out_item (dvi$_pid,        %DESCR disk_owner_pid)))) ;
      writeln (logvolnam, ', ', device, ', ', disk_label, ', ',
         ', free =', free_blocks:1, ',
         used =', (disk_size - free_blocks):1) ;
      END.
1 LIB_OUT_ITEM
  FUNCTIONAL DESCRIPTION:
     Builds an item specifing data to be written, for inclusion in an
     item_list.  This routine is designed to be called from within a
     call to LIB_ITEM_LIST.

  CALLING SEQUENCE:    item.rr.r = (
                          item_code.rlu.v, data.wx.dx [, data_length.wwu.r])

  IMPLICIT INPUTS:     None.

  IMPLICIT OUTPUTS:    None.

  SIDE EFFECTS:        None.
2 Parameters                        
  item_code   -- Symbolic code for the item of data required.
  data        -- Variable into which the item is to be returned. If it
                 is of type varying string, the length is returned as well.
  data_length -- Variable in which the length of the data is to be return-
                 ed.  This is not done if data was of type varying string.
2 Completion_Status
  none -- does not return any status values.
2 PASCAL_Definition
!}
   [EXTERNAL] FUNCTION lib_out_item (
      %IMMED item_code : lib_long_type ;
      %DESCR data : [UNSAFE] lib_long_type ;
      VAR data_length : lib_word_type := %IMMED 0)
         : lib_item_type ; external ;{
1 LIB_IN_ITEM
  FUNCTIONAL DESCRIPTION:
     Builds an item specifing data to be written, for inclusion in an
     item_list.  This routine is designed to be called from within a
     call to LIB_ITEM_LIST.

  CALLING SEQUENCE:    item.rr.r = (item_code.rlu.v [, data.rx.dx])

  IMPLICIT INPUTS:     None.

  IMPLICIT OUTPUTS:    None.

  SIDE EFFECTS:        None.

  RESTRICTIONS:        The maximum data length is 80.
2 Parameters
  item_code   -- Symbolic code for operation required..
  data        -- Variable containing data to be read.
2 Completion_Status                                  
  none -- does not return any status values.
2 PASCAL_Definition
!}
   [EXTERNAL] FUNCTION lib_in_item (
      %IMMED item_code : lib_long_type ;
      %STDESCR data : [UNSAFE,READONLY] PACKED ARRAY [l1..u1:integer]
         OF char := %IMMED 0) : lib_extended_item_type ; external ;
{
! From SRC_VCLIB:LIBIFERR.DEC
!
1 LIB_RETIFERR
  FUNCTIONAL DESCRIPTION:
    Return from a routine if condition is not success.
    The condition is put in the return value of the routine (R0).

  CALLING SEQUENCE:    ret_status.wlc.r = lib_retiferr (status.rlc.v)

  IMPLICIT INPUTS:     None.

  IMPLICIT OUTPUTS:    None.

  SIDE EFFECTS:        None.
2 Parameters
  status =  longword condition code
2 Completion_Status
  ret_status  =  status (i.e. the parameter)
2 PASCAL_Definition
!}
   [EXTERNAL] FUNCTION lib_retiferr (
      %IMMED status : sts_type) : sts_type ; external ;{
1 LIB_SIGIFERR
  FUNCTIONAL DESCRIPTION:
    Signal a condition if it is not success, optionally prefixing it with
    other messages (with the normal passing of FAO arguments).

  CALLING SEQUENCE:    ret_status.wlc.r = lib_sigiferr (
                           status.rlc.v [, signal_arg, ... ])

  IMPLICIT INPUTS:     None.

  IMPLICIT OUTPUTS:    None.

  SIDE EFFECTS:        None.
2 Parameters
  status      =  longword condition code
  signal_arg  =  a list of condition codes (and FA0 arguments) to be signalled
                 ahead of the status.
2 Completion_Status
  ret_status  = status (i.e. the parameter)
2 PASCAL_Definition
!}
   [EXTERNAL] FUNCTION lib_sigiferr (
      %IMMED status : sts_type ;
      %IMMED signal_arg : [LIST,UNSAFE] sts_type) : sts_type ; external ;
{
! From SRC_VCLIB:LIBPARSE.DEC
!
1 LIB_PARSE
FUNCTIONAL DESCRIPTION
   Return an expanded file spec (or portions of it) (a run-time
   version of F$PARSE).

CALLING SEQUENCE:	ret_status.wlc.v = lib_parse (
                           file_spec.rt.dx, expanded_spec.wt.dx
                           [, default_spec.rt.dx] [, related_spec.rt.dx]
                           [, expanded_length.ww.r,] [, field.rl.r, ... ])

IMPLICIT INPUTS:	Process default device and directory.

IMPLICIT OUTPUTS:	None.

SIDE EFFECTS:		None

RESTRICTIONS:		None

2 Parameters
expanded_spec  = The expanded file_spec.
expanded_length= length of expanded file_spec
file_spec      = The file_spec to parse
default_spec   = See RMS manual.
related_spec   = See RMS manual.
field,..       = the fields to select. Select from the symbols NAM__NODE
                 NAM__DEV, NAM__DIR, NAM__NAME, NAM__TYPE, NAM__VER.
                 If no fields are specified, the entire expanded file_spec
                 is returned.  Otherwise the requested fields are appended
                 in order in expanded_spec.
2 Completion_Status
Any status returned by RMS or LIB$SCOPY_R_DX
2 PASCAL_DEFINITION
!}
   [EXTERNAL] FUNCTION lib_parse (
      %STDESCR file_spec : [CLASS_S] PACKED ARRAY [l1..u1:integer] OF char ;
      %DESCR expanded_spec : VARYING [n1] OF char ;
      %STDESCR default_spec :
         [CLASS_S] PACKED ARRAY [l2..u2:integer] OF char := %IMMED 0 ;
      %STDESCR related_spec :
         [CLASS_S] PACKED ARRAY [l3..u3:integer] OF char := %IMMED 0 ;
      VAR expanded_length : lib_word_type := %IMMED 0 ;
      field : [LIST] sts_type := %IMMED 0) : sts_type ; external ;
{
! From SRC_VCLIB:LIBFILATT.DEC
!
1 LIB_FILE_ATTRIBUTES
FUNCTIONAL DESCRIPTION
   Provides information about files from the RMS File Access Block (FAB)
   and eXtended Access Blocks (XAB).

CALLING SEQUENCE:	ret_status.wlc.v = lib_file_attributes (
                           [file_spec.rt.d], [pascal_file_var.rr.r],
                           item_list.rz.r)

IMPLICIT INPUTS:	FAB and XAB data for the file from RMS.

IMPLICIT OUTPUTS:	None.

SIDE EFFECTS:		None

RESTRICTIONS:	    i	Does not read or write any length data associated
			with each item.  This may produce unexpected
			results when an item is requested using a data
			type of the incorrect size.
		    ii	Not exhaustively tested as of FEB-1989.
2 Parameters
file_spec       The VMS filename of the file whose attributes are wanted.

pascal_file_var
                A Pascal file variable of an open file whose attributes are
                wanted.

item_list       Item list specifying which information about the file is to
                be returned.  The itmlst argument is the address of a list
                of item descriptors, each of which describes an item of
                information.  The list of item descriptors is terminated by
                a longword of 0.

If the pascal_file_var argument is specified, the routine performs a PAS$FAB
then a SYS$DISPLAY to obtain the file's FAB and XABs respectively (the file
remains open); if it is not specified, the routine performs a SYS$OPEN to
obtain the FAB and XABs (the file is closed).
2 items
!} CONST
{		FAB fields }
	rms__alq = 1 ;	    { Longword - Alocation quantity (blocks) }
	rms__bks = 2 ;	    { Byte     - Bucket size }
	rms__bls = 3 ;	    { Word     - Magnetic tape block size }
	rms__deq = 4 ;	    { Word     - Default file extension quantity }
	rms__dev = 5 ;      { Longword - Device characteristics }
	rms__fac = 6 ;	    { Byte     - File access }
	rms__fop = 7 ;	    { Longword - File-processing options }
	rms__fsz = 8 ;	    { Byte     - Fixed length control area size }
	rms__gbc = 9 ;      { Word     - Global buffer count }
	rms__ifi = 10 ;     { Word     - Internal file identifier }
	rms__mrn = 11 ;     { Longword - Maximum record number }
	rms__mrs = 12 ;     { Word     - Maximum record size }
	rms__org = 13 ;     { Byte     - File organization }
	rms__rat = 14 ;     { Byte     - Record attributes }
	rms__rfm = 15 ;	    { Byte     - Record format }
	rms__sdc = 16 ;	    { Longword - Secondary device characteristics }
	rms__shr = 17 ;     { Byte     - File sharing }
	rms__sts = 18 ;	    { Longword - Completion status code }
	rms__stv = 19 ;	    { Longword - Status value (I/O chan if succ. OPEN) }
	rms__xab = 20 ;	    { Longword - Extended attribute block address }

{		XABDAT fields }
	rms__bdt = 21 ;	    { Quadword - Backup date and time }
	rms__cdt = 22 ;	    { Quadword - Creation date and time }
	rms__edt = 23 ;	    { Quadword - Expiration date and time }
	rms__rdt = 24 ;	    { Quadword - Revision date and time }
	rms__rvn = 25 ;	    { Word     - Revision number }

{		XABFHC fields }
	rms__ebk = 26 ;	    { Longword - End-of-file block }
	rms__ffb = 27 ;	    { Word     - First free byte in the eof block }
	rms__lrl = 28 ;	    { Word     - Longest record length }
	rms__sbn = 29 ;	    { Word     - Starting logical block number }
	rms__verlimit = 30 ;{ Word     - Version limit }

{		XABPRO fields }
	rms__grp = 31 ;	    { Word     - Group number of file owner }
	rms__mbm = 32 ;	    { Word     - Member number of file owner }
	rms__mtacc = 33 ;   { Byte     - Magnetic tape accessibility }
	rms__pro = 34 ;	    { Word     - File protection }
	rms__uic = 35 ;	    { Longword - User Identification Code }

{		XABSUM fields }
	rms__noa = 36 ;	    { Byte     - Number of allocation areas defined }
	rms__nok = 37 ;	    { Byte     - Number of keys defined }
	rms__pvn = 38 ;	    { Word     - Prologue version number }

{		XABALL fields }
	rms__aid = 39 ;     { Byte     - Area identification number }
	rms__aln = 40 ;     { Byte     - Alignment boundary type }
	rms__a_alq = 41 ;   { Longword - Area allocation quantity }
	rms__aop = 42 ;     { Byte     - Allocation options }
	rms__bkz = 43 ;     { Byte     - Area bucket size }
	rms__a_deq = 44 ;   { Word     - Area default extension quantity }
	rms__loc = 45 ;     { Longword - Area position }
	rms__rfi = 46 ;     { Word     - Related file identifier }
	rms__vol = 47 ;     { Word     - Related volume number }

{		Block addresses }
	rms__fabadr = 48 ;	{ Longword - Address of FAB }
	rms__xabdatadr = 49 ;	{ Longword - Address of XABDAT }
	rms__xabfhcadr = 50 ;	{ Longword - Address of XABFHC }
	rms__xabproadr = 51 ;	{ Longword - Address of XABPRO }
	rms__xabsumadr = 52 ;	{ Longword - Address of XABSUM }
	rms__xaballadr = 53 ;   { Longword - Address of XABALL }{
2 Completion_Status
RMS$_NORMAL          Routine completed successfully.

SS$_INSFARG          Less than 3 arguments were supplied to the routine.

LIB$_INVARG          The item_code field in one of the items in the
                     item_list is not known to the routine.

LIB$_INVFILSPE       The file_spec argument specified a string longer than
                     255 characters.

STR$_ILLSTRCLA       An invalid string descriptor was used for the file_spec
                     argument (signalled).

Any status returned by $OPEN, $DISPLAY or $CLOSE (if $OPEN successful)
2 PASCAL_Definition
!}
   [EXTERNAL] FUNCTION lib_file_attributes (
      %DESCR file_spec : VARYING [n1] OF char := %IMMED 0 ;
      VAR file_var : [UNSAFE] text := %IMMED 0 ;
      %REF item_list : lib_item_list_type) : sts_type ; external ;
{
! From SRC_VCLIB:PASLIBDEF.PAS
!
1 PASLIBDEF
|****************************************************************************|
| Non-modular utility routines for use in PASCAL                             |
|                                                                            |
| AUTHOR:       Doug Miller                                                  |
| CREATED:      26-Sep-1984                                                  |
| MODIFIED:     Tim Cook, added addtim, subtim, difftim and bintim           |
|                  12-Sep-1985                                               |
|               Tim Cook, removed unneeded definitions for a TAR             |
|                  distribution, 24-FEB-1989                                 |
|****************************************************************************|
2 CLI_PRESENT
!} [GLOBAL,ASYNCHRONOUS] FUNCTION success ({
!}    status : [UNSAFE] STS$TYPE) : boolean ; forward ;{
!}
   [GLOBAL,ASYNCHRONOUS] FUNCTION cli_present (
      keyword : PACKED ARRAY [l1..u1:integer] OF char) : boolean ;
      BEGIN
         cli_present := success (CLI$PRESENT (keyword)) END ;{
2 FAILURE
   A simple routine to test the STS$V_SUCCESS bit of a STS$TYPE status.
      (used to control program flow)

!}
   [GLOBAL,ASYNCHRONOUS] FUNCTION failure (
      status : [UNSAFE] STS$TYPE) : boolean ;
      BEGIN
         failure := NOT status.STS$V_SUCCESS END ;{
2 PAS$FAB
!}
   [EXTERNAL,ASYNCHRONOUS] FUNCTION pas$fab (VAR f : [UNSAFE] text) :
      fab_pointer ; external ;{
2 PAS$RAB
!}
   [EXTERNAL,ASYNCHRONOUS] FUNCTION pas$rab (VAR f : [UNSAFE] text) :
      rab_pointer ; external ;{
2 SUCCESS
   A simple routine to test the STS$V_SUCCESS bit of a STS$TYPE status.
      (used to control program flow)

   [GLOBAL,ASYNCHRONOUS]} FUNCTION success {(
      status : [UNSAFE] STS$TYPE) : boolean } ;
      BEGIN
         success := status.STS$V_SUCCESS END ;{
!
!} END. { of MODULE vclib }
