$! Invoke WATCH utility to observer another terminal session.
$!
$!  p1-- user, process, or terminal name
$!
$!  Note:  This procedure is designed to be placed in the same directory
$!         as where the WATCH utility is placed.
$!
$!  Author:  R.L.Boyd, GE Microelectronics Ctr, 1988, rlb@rtpark.ge.com
$!
$ vfl = f$ver(0+f$trnlnm("debug$dcl"))
$ if f$mode().nes."INTERACTIVE" then $ goto EXIT
$ if p1.eqs."" then -
$	read sys$command/error=EXIT/end=EXIT -
	p1/prompt="User/Process/Terminal to watch:  "
$ user_file = "SYS$LOGIN:WATCH$USER_LIST.TMP"
$ sess_file = "SYS$LOGIN:WATCH$TERM_LIST.TMP"
$ tmp_file  = "SYS$LOGIN:WATCH$*.TMP"
$ if p1.eqs."" then $ goto EXIT
$ who_am_i = f$environment("procedure")
$ where_am_i = f$parse(who_am_i,,,"device")+f$parse(who_am_i,,,"directory")
$ watch = "$"+where_am_i+"watch "
$ req_privs = "CMKRNL"
$ save_privs = f$setprv(req_privs)
$ show user/output='USER_FILE'
$ search 'USER_FILE' 'p1'/output='SESS_FILE'
$! read the list of terminals
$ found_cnt = 0
$ open/read/error=TERM_NONE terms 'SESS_FILE'
$TERM_LOOP:
$ read/end=TERM_END/ERROR=TERM_NONE terms term_rec
$ user_name = f$edit(f$extract(1,12,term_rec),"trim,compress")
$ process_name = f$edit(f$extract(13,15,term_rec),"trim")
$ process_pid = f$edit(f$extract(30,8,term_rec),"trim")
$ virtual_terminal = f$edit(f$extract(40,13,term_rec),"trim")
$ physical_terminal = f$edit(f$extract(54,13,term_rec),"trim")
$ if physical_terminal.eqs."Disconnected" then $ goto TERM_LOOP
$! see if this is the one they wanted
$ found_cnt = 1+found_cnt
$ read sys$command/timeout=30/end=EXIT ans-
	/prompt="Watch ''user_name'(''process_name') ? [Y] "
$ if ans.eqs."" then $ ans = "Y"
$! if it is not, go back and see if there are any more 
$ if .not.ans then $ goto TERM_LOOP
$ define/user sys$input sys$command:
$ watch 'physical_terminal'
$TERM_END:
$ if found_cnt .lt.1 then - 
$ write sys$output "There are no active interactive sessions that match '",p1,"'"
$EXIT:
$! Clean up and exit
$ if f$type(save_privs).nes."" then -
$ 	if save_privs.nes."" then $ x = f$setprv(save_privs)
$ if f$trnlnm("terms","lnm$process").nes."" then $ close terms
$ if f$search(TMP_FILE+";").nes."" then $ delete 'TMP_FILE';*/nolog
$ exit !'f$ver(vfl)'
$!
$TERM_NONE:
$  Write sys$output "There are no terminals that match """,p1,""""
$  goto EXIT
$!Last Modified:   9-AUG-1988 16:40:05.31, By: RLB 
