d $!
 $!  TITLE:     ADDUSERS.COM
,$!
$!  FACILITY: TAMU Cyclotron Institute Accounting Services
$!
X$!  ABSTRACT:
$!     Supervises the process of adding one or more users to the system.
$!     Provides a convient interactive environment for adding users.
 $!
$!  ENVIRONMENT:
$!     Runs as a DCL command proceedure: designed to be called by other DCL
L$!     command proceedures.
$!
$!  AUTHOR: Ralph Weber,  CREATION DATE: 25-JAN-1980
x$!
$!  MODIFIED BY:
@$!
$!
$!+++
4$!  FUNCTIONAL DESCRIPTION:
$!	This procedure provides a convient interactive method of adding
$!	users on the Cyclotron Institute VAX system.  It prompts for
`	$!	necessary information either in and of itself or using the
	$!	prompt facilities of BASEADAC.COM which it calls.  It provides
(
$!	informative help messages in response to "?".  It does all the

$!	file opens, closes, and writes which BASEADAC.COM does not do.

$!	It causes the procedure files constructed by BASEADAC.COM to
T$!	be executed.  It has the ability to produce a current listing of
$!	authorized users sorted by UIC.  It does complete cleanup of
$!	all scratch files created by it's activities.
$!
$!
H
$!  CALLING SEQUENCE:

$!	@ADDUSERS
$!
t$!
$!  INPUT PARAMETETS:
<$!	All required information is prompted for.
$!
$!
h$!  OUTPUT PARAMETERS:	None.
$!
0$!
$!  IMPLICIT INPUTS:
$!
\$!	BASEADAC.COM	is a command procedure for constructing authorize
$!			commands to add a user and $CREATE/DIRECTORY
$$!			commands to create a base user directory.
$!
$!	CYC_PROCEDURE:PRIVILEGE is a command procedure for determining
P$!			whether or not a user has any one of a set of
$!			specified privileges.
$!
|$!
$!  IMPLICIT OUTPUTS:
D$!
$!	This procedure affects the contents of SYSUAF.DAT and the
$!	master directory file.
p$!
$!
8$!  COMPLETION STATUS:
$!	See BASEADAC.COM.
 $!
d$!
$!  SIDE EFFECTS:
,$!
$!	This procedure effects the contents of SYSUAF.DAT and the
$!	master directory file.
X$!
$!---
'$!+++
t'$!  INITALIZATION:
'$!	If runing in batch mode exit.
<($!	If caller doesn't have PHY_IO or LOG_IO privilege exit.
($!	If caller doesn't have CMKRNL privilege exit.
)$!	Open AUTH_FILE and DIR_FILE.
h)$!	Write $RUN AUTHORIZE in AUTH_FILE.
)$!---
0*$
*$IF "''F$MODE()'" .EQS. "BATCH"  THEN $EXIT %X980
*$@CYC_PROCEDURE:PRIVILEGE PHY_IO LOG_IO
\+$@CYC_PROCEDURE:PRIVILEGE CMKRNL
+$!
$,$OPEN/WRITE AUTH_FILE AUTHFILE.COM
,$OPEN/WRITE DIR_FILE  DIRFILE.COM
,$WRITE AUTH_FILE "$RUN AUTHORIZE"
:$!+++
:$!  DETERMINE USER INFORMATION:
`;$!	Prompt for user information.
;$!	If caller types ? give help.
(<$!	If caller types # proceed to perform updates.
<$!	Otherwise call BASEADAC.COM to place new user adding commands
<$!	in AUTH_FILE and DIR_FILE.
T=$!	Loop until a # is typed.
=$!---
>$ADD_USER_LOOP:
>$INQUIRE USERNAME
>$IF USERNAME .EQS. "?"  THEN $GOTO GIVE_HELP
H?$IF USERNAME .EQS. "#"  THEN $GOTO ADD_USERS
?$@BASEADAC 'USERNAME'
@$GOTO ADD_USER_LOOP
t@$!
@$!
<A$GIVE_HELP:
A$write sys$command "You can type:"
B$write sys$command "# to perform user additions, lists, and exit."
hB$write sys$command "? to recieve help."
B$write sys$command "USERNAME PASSWORD UIC ACCOUNT OWNER PRIVILEGE_CLASS DEFAULT_DEVICE."
0C$write sys$command "In the last case you may leave off from the end any"
C$write sys$command "which you wish to be prompted for.  Omitting PRIVILEGE_CLASS"
C$write sys$command "will cause USER to be used.  Omitting DEFAULT_DEVICE"
\D$write sys$command "will cause DRA0: to be used.  Putting a * in any position"
D$write sys$command "except USERNAME will cause the username to be printed"
$E$write sys$command "before a prompt for that parameter."
E$GOTO ADD_USER_LOOP
 N$!+++
N$!  PERFORM USER ADDITIONS:
N$!	Write EXIT in AUTH_FILE.
LO$!	Close AUTH_FILE and DIR_FILE.
O$!	Save current UIC and default directory.
P$!	Change to [1,4] [SYSEXE].
xP$!	Suspend DCL error handling.
P$!	Perform command procedures built above.
@Q$!	Delete command procedure files.
Q$!	Restore DCL error handling.
R$!---
lR$ADD_USERS:
R$WRITE AUTH_FILE "EXIT"
4S$CLOSE AUTH_FILE
S$CLOSE DIR_FILE
S$!
`T$CURRENT_UIC:="''F$USER()'"
T$CURRENT_DIR:="''F$DIRECTORY()'"
(U$SET UIC [1,4]
U$SET DEF [SYSEXE]
U$SET NOON
TV$!
V$@'CURRENT_DIR'AUTHFILE.COM
W$@'CURRENT_DIR'DIRFILE.COM
W$!
W$DELETE 'CURRENT_DIR'AUTHFILE.COM;0,DIRFILE.COM;0
HX$SET ON
a$!+++
b$!  MAKE UIC SORTED USER LIST AND/OR EXIT:
pb$!	If listing not desired restore UIC and default directory and exit.
b$!	Otherwise:
8c$!	Run AUTHORIZE to create listing file.
c$!	Restore UIC and default directory.
 d$!	Sort listing file by UIC placing results in user's directory.
dd$!	Print sorted listing and delete file after printed.
d$!	Delete unsorted listing file in [SYSEXE].
,e$!---
e$INQUIRE TEST "Do you wish to list the UAF?"
e$IF TEST  THEN $GOTO LIST_UAF
Xf$SET UIC 'CURRENT_UIC'
f$SET DEFAULT 'CURRENT_DIR'
 g$EXIT
g$!
g$LIST_UAF:
Lh$RUN AUTHORIZE
hLIST
iEXIT
xi$!
i$SET UIC 'CURRENT_UIC'
@j$SET DEFAULT 'CURRENT_DIR'
j$!
k$SORT/KEY=(POSITION=37,SIZE=9) [SYSEXE]SYSUAF.LIS SYSUAF.LIS
lk$!
k$PRINT/DELETE SYSUAF
4l$!
l$DELETE/LOG [SYSEXE]SYSUAF.LIS;0
l$EXIT
