$!
$!  TITLE:     Baselevel Account Adding DCL procedure
$!
$!  FACILITY: TAMU Cyclotron Institute Accounting Services
$!
$!  ABSTRACT:
$!     Builds AUTHORIZE and CREATE/DIRECTORY commands based on input parameters.
$!
$!  ENVIRONMENT:
$!     Runs as a DCL command proceedure: designed to be called by other DCL
$!     command proceedures.
$!
$!  AUTHOR: Ralph Weber,  CREATION DATE: 1-JAN-1980
$!
$!  MODIFIED BY:
$!	Ralph Weber (13-AUG-1980) Changed to prompt for default disk
$!			when none provided and to take null response to
$!			mean DRA1:.
$!
$!
$!
$!  FUNCTIONAL DESCRIPTION:
$!     Using input parameters P1-P7 this DCL command proceedure writes a command
$!     for adding a user in the file described by the logical name AUTH_FILE
$!     and a command for creating the proper user directory in the file
$!     described by the logical name DIR_FILE.  Basic responsibility for
$!     handling these files is left with the caller of this proceedure.  This
$!     includes opening, closing, and insertion or any necessary leading or
$!     trailing text (for example $RUN SYS$SYSTEM:AUTHORIZE).  This proceedure
$!     assumes responsibility for the correctness of entries it places in the
$!     files and attempts to completely validate the arguments it recieves.
$!     It also prompts for missing parameters -- except in the case of privilege
$!     class and default device, where a default value is supplied.  Descriptive
$!     text concerning options available is printed in response to "?" for any
$!     of the parameters.
$!
$!
$!  CALLING SEQUENCE:
$!
$!     @BASEADAC username password uic account owner privilege_class -
$!             default_device
$!
$!
$!     INPUT PARAMETERS:
$!
$!     username P1     is the username for the account to be added.  It will
$!                     also be used as the name of the default directory.
$!
$!     password P2     is the password for the account to be added.
$!
$!     uic P3          is the user identification code for the account to be
$!                     added.  The format may be ggg,mmm or [ggg,mmm].
$!
$!     account P4      is the account "number" for the account to be added.
$!
$!     owner P5        is the owner of the account to be added.
$!
$!     privilege_class P6
$!                     is a privilege class identifier plus (+) any extra
$!                     privileges for the account to be added.  Known privilege
$!                     classes and associated privileges are listed in the table
$!                     below.  Specific additional privileges may be granted by
$!                     appending a "+" and the desired privileges (seperated by
$!                     commas) to the privilege class code.  If no privilege
$!                     class is specified, the default privilege class, USER, is
$!                     used.
$!
$!     default_device P7
$!                     is the default disk device for the account to be added.
$!			If null, a value is prompted for.  If a null is
$!			received from the prompt DRA1: is used.  The legal
$!			choices are:
$!                             DRA0:
$!                             DRA1:
$!
$!
$!  OUTPUT PARAMETES:  None.
$!
$!
$!  IMPLICIT INPUTS:
$!
$!     SYS$COMMAND     is the logical name for the terminal initating this
$!                     proceedure.
$!
$!     AUTH_FILE       is the logical name for the file in which the AUTHORIZE
$!                     command will be written.
$!
$!     DIR_FILE        is the logical name for the file in which the
$!                     CREATE/DIRECTORY command will be written.
$!
$!
$!  IMPLICIT OUTPUTS:
$!
$!     If all processing is completed normally the following lines will be
$!     added to the file pointed to by AUTH_FILE.
$!
$!     ADD username /PASSWORD=password  -
$!         /UIC=uic /ACCOUNT=account    -
$!         /OWNER="owner"               -
$!         /DEVICE=default_device /DIRECTORY=[username]  -
$!         /PRIVILEGE=(privileges)
$!     For privilege class SYSP ADD usernameP is used instead of ADD username.
$!
$!     If all processing in completed normally and the privilege class is not
$!     SYSP the following line is added to the file pointed to by DIR_FILE.
$!
$!     $CREATE/DIRECTORY/OWNER=uic default_device:[username]
$!
$!
$!  COMPLETION STATUS:
$!
$!     SS$!NORMAL      if success.
$!     SS$!CONTROLY    if stopped by CTRL-Y (successful status code).
$!                     Note: CTRL-Y cannot interupt the process of writing to
$!                     the output files.
$!     SS$!CLIFRCEXT   if proceedure forced to exit because:
$!                     1) attempt to run proceedure from BATCH mode.
$!     ????????????    if AUTH_FILE or DIR_FILE is not valid.
$!
$!
$!  SIDE EFFECTS:
$!
$!     Data is written to one or both files pointed to by implicit inputs
$!     AUTH_FILE and DIR_FILE.  These logical names and their associated files
$!     MUST be setup before proceedure activation.
$!
$!
$!  PRIVILEGE_CLASS TABLE
$!     code            privileges
$!     USER            TMPMBX,NETMBX
$!     PROGammer       TMPMBX,NETMBX,GROUP
$!     OPERator        TMPMBX,NETMBX,OPER,VOLPRO,DIAGNOSE
$!     SYStem user     TMPMBX,NETMBX,OPER,VOLPRO,GROUP,WORLD
$!     SYSP            all privileges
$!
$!  INITALIZATION:
$!
$!     Turn off verify.
$!     If BATCH mode, then exit SS$!CLIFRCEXT.
$!     Capture CONTROL_Y.
$!
$!SET NOVERIFY
$IF "''F$MODE()'" .EQS. "BATCH"  THEN $EXIT %X980
$ON CONTROL_Y  THEN $EXIT %X611
$!  USERNAME:
$!     ? ==> give help & prompt for USERNAME.
$!     USERNAME not present ==> prompt for USERNAME.
$!     USERNAME >= 10 characters ==> give error & prompt for USERNAME.
$!     USERNAME contains a space or tab ==> give error & prompt for USERNAME.
$!
$USERNAME:='P1'
$!
$TEST_USERNAME:
$IF USERNAME .NES. "?"  THEN $GOTO T_USERNAME_NULL
$write sys$command "Enter USERNAME for new account."
$write sys$command "The name entered must consist of nine"
$write sys$command "or fewer alphanumeric characters and"
$write sys$command "must be unique for this system.  The"
$write sys$command "name entered will be used for the user's"
$write sys$command "login name and for the user's default"
$write sys$command "disk directory."
$GOTO PROMPT_USERNAME
$!
$T_USERNAME_NULL:
$IF USERNAME .EQS. ""  THEN $GOTO PROMPT_USERNAME
$!
$LENGTH='F$LENGTH(USERNAME)'
$IF LENGTH .LT. 10  THEN $GOTO T_USERNAME_SPACE
$ERROR_FLAG:="is too long"
$GOTO USERNAME_ERROR
$!
$T_USERNAME_SPACE:
$IF ('F$LOCATE("	",USERNAME) .EQ. LENGTH) .AND. -
    ('F$LOCATE(" ",USERNAME) .EQ. LENGTH)  THEN $GOTO END_USERNAME
$ERROR_FLAG:="contains invalid characters"
$!
$USERNAME_ERROR:
$write sys$command "USERNAME """,USERNAME,""" ",ERROR_FLAG,"."
$!
$PROMPT_USERNAME:
$INQUIRE USERNAME
$GOTO TEST_USERNAME
$!
$END_USERNAME:
$!  PASSWORD:
$!     ? ==> give help & prompt for PASSWORD.
$!     * ==> give USERNAME & prompt for PASSWORD.
$!     PASSWORD not present ==> prompt for PASSWORD.
$!     PASSWORD contains space or tab ==> give error & prompt for PASSWORD.
$!     If prompt for PASSWORD then hide PASSWORD.
$!
$PASSWORD:='P2'
$!
$TEST_PASSWORD:
$IF PASSWORD .NES. "?"  THEN $GOTO T_PASSWORD_STAR
$write sys$command "Enter PASSWORD for new account."
$write sys$command "PASSWORD must contain only alphanumeric characters."
$GOTO USERNAME_PROMPT_PASSWORD
$!
$T_PASSWORD_STAR:
$IF PASSWORD .NES. "*"  THEN $GOTO T_PASSWORD_NULL
$!
$USERNAME_PROMPT_PASSWORD:
$write sys$command "For ",USERNAME
$GOTO PROMPT_PASSWORD
$!
$T_PASSWORD_NULL:
$IF PASSWORD .EQS. ""  THEN $GOTO PROMPT_PASSWORD
$!
$LENGTH='F$LENGTH(PASSWORD)'
$IF ('F$LOCATE("	",PASSWORD)' .EQ. LENGTH) .AND. -
    ('F$LOCATE(" ",PASSWORD)' .EQ. LENGTH)  THEN $GOTO END_PASSWORD
$write sys$command "PASSWORD """,PASSWORD,""" contains invalid characters."
$!
$PROMPT_PASSWORD:
$INQUIRE PASSWORD
$write sys$command "AY: K"
$GOTO TEST_PASSWORD
$!
$END_PASSWORD:
$!  UIC:
$!     ? ==> give help & prompt for UIC.
$!     * ==> give USERNAME & prompt for UIC.
$!     UIC not present ==> prompt for UIC.
$!     UIC doesn't have [] ==> add [] to UIC.
$!     UIC doesn't have comma ==> give error and prompt for UIC.
$!     UIC contains 8 or 9 ==> give error and prompt for UIC.
$!             Seperate group and member parts of UIC.
$!             Group or Member not numeric ==> give error & prompt for UIC.
$!             Group outside range (10<Group<400) ==> give error &
$!                     prompt for UIC.
$!             Member outside range (-1<Member<400) ==> give error &
$!                     prompt for UIC.
$!
$UIC:='P3'
$!
$TEST_UIC:
$IF UIC .NES. "?"  THEN $GOTO T_UIC_STAR
$write sys$command "Enter UIC for new account."
$write sys$command "UIC is composed of TWO OCTAL numbers seperated by"
$write sys$command "a COMMA.  The first number is a group number valued"
$write sys$command "between 11 and 377.  The second number is a member"
$write sys$command "number valued between 0 and 377.  The UIC format"
$write sys$command "is usually [GGG,MMM] but GGG,MMM is satisfactory."
$GOTO USERNAME_PROMPT_UIC
$!
$T_UIC_STAR:
$IF UIC .NES. "*"  THEN $GOTO T_UIC_NULL
$!
$USERNAME_PROMPT_UIC:
$write sys$command "For ",USERNAME
$GOTO PROMPT_UIC
$!
$T_UIC_NULL:
$IF UIC .EQS. ""  THEN $GOTO PROMPT_UIC
$!
$IF 'F$LOCATE("[",UIC)' .EQ. 'F$LENGTH(UIC)' THEN $UIC:="[''UIC']"
$!
$LENGTH='F$LENGTH(UIC)'
$LOC_COMMA='F$LOCATE(",",UIC)'
$!
$IF LOC_COMMA .NE. LENGTH  THEN $GOTO T_UIC_OCTAL
$ERROR_FLAG:="has invalid format"
$GOTO UIC_ERROR
$!
$T_UIC_OCTAL:
$IF ('F$LOCATE("8",UIC) .EQ. LENGTH)  .AND. -
    ('F$LOCATE("9",UIC) .EQ. LENGTH)  THEN $GOTO T_UIC_NUMERIC
$ERROR_FLAG:="is not octal"
$GOTO UIC_ERROR
$!
$T_UIC_NUMERIC:
$LENGTH_GROUP=LOC_COMMA-1
$LENGTH_MEMBER=LENGTH-LOC_COMMA-2
$START_MEMBER=LOC_COMMA+1
$ON WARNING  THEN $GOTO UIC_NOT_NUMERIC
$GROUP:='F$EXTRACT(1,LENGTH_GROUP,UIC)'
$MEMBER:='F$EXTRACT(START_MEMBER,LENGTH_MEMBER,UIC)'
$IGROUP='GROUP'
$IMEMBER='MEMBER'
$ON WARNING  THEN $CONTINUE
$ON ERROR THEN $EXIT '$STATUS'
$!
$IF (IGROUP .GT. 10) .AND. (IGROUP .LT. 400) .AND. -
    (IMEMBER .GT. -1) .AND. (IMEMBER .LT. 400)  THEN $GOTO END_UIC
$ERROR_FLAG:="has an invalid value"
$GOTO UIC_ERROR
$!
$UIC_NOT_NUMERIC:
$ERROR_FLAG:="is not numeric"
$!
$UIC_ERROR:
$write sys$command "UIC ",UIC," ",ERROR_FLAG,"."
$!
$PROMPT_UIC:
$INQUIRE UIC
$GOTO TEST_UIC
$!
$END_UIC:
$!  ACCOUNT:
$!     ? ==> give help & prompt for ACCOUNT.
$!     * ==> give USERNAME & prompt for ACCOUNT.
$!     ACCOUNT not present ==> prompt for ACCOUNT.
$!     ACCOUNT >= 9 characters ==> give error & prompt for ACCOUNT.
$!     ACCOUNT contains space or tab ==> give error & prompt for ACCOUNT.
$!
$ACCOUNT:='P4'
$!
$TEST_ACCOUNT:
$IF ACCOUNT .NES. "?"  THEN $GOTO T_ACCOUNT_STAR
$write sys$command "Enter ACCOUNT to be billed for new account."
$write sys$command "The account ""number"" entered must consist of"
$write sys$command "eight or fewer alphanumeric characters or hyphens."
$GOTO USERNAME_PROMPT_ACCOUNT
$!
$T_ACCOUNT_STAR:
$IF ACCOUNT .NES. "*"  THEN $GOTO T_ACCOUNT_NULL
$!
$USERNAME_PROMPT_ACCOUNT:
$write sys$command "For ",USERNAME
$GOTO PROMPT_ACCOUNT
$!
$T_ACCOUNT_NULL:
$IF ACCOUNT .EQS. ""  THEN $GOTO PROMPT_ACCOUNT
$!
$LENGTH='F$LENGTH(ACCOUNT)'
$IF LENGTH .LT. 9  THEN $GOTO T_ACCOUNT_SPACE
$ERROR_FLAG:="is too long"
$GOTO ACCOUNT_ERROR
$!
$T_ACCOUNT_SPACE:
$IF ('F$LOCATE("	",ACCOUNT) .EQ. LENGTH) .AND. -
    ('F$LOCATE(" ",ACCOUNT) .EQ. LENGTH)  THEN $GOTO END_ACCOUNT
$ERROR_FLAG:="contains invalid characters"
$!
$ACCOUNT_ERROR:
$write sys$command "ACCOUNT """,ACCOUNT,""" ",ERROR_FLAG,"."
$!
$PROMPT_ACCOUNT:
$INQUIRE ACCOUNT
$GOTO TEST_ACCOUNT
$!
$END_ACCOUNT:
$!  OWNER:
$!     ? ==> give help & prompt for OWNER.
$!     * ==> give USERNAME & prompt for OWNER.
$!     OWNER not present ==> prompt for OWNER.
$!     OWNER >= 21 characters ==> give error & prompt for OWNER.
$!     OWNER contains " ==> give error & prompt for OWNER.
$!
$OWNER:='P5'
$!
$TEST_OWNER:
$IF OWNER .NES. "?"  THEN $GOTO T_OWNER_STAR
$write sys$command "Enter OWNER of new account."
$write sys$command "This is the whole name of the person who will"
$write sys$command "be the primary user of this account.  There is"
$write sys$command "a limit of twenty characters (including spaces)."
$write sys$command "The only illegal printing character is"
$write sys$command "the double quote mark."
$GOTO USERNAME_PROMPT_OWNER
$!
$T_OWNER_STAR:
$IF OWNER .NES. "*"  THEN $GOTO T_OWNER_NULL
$!
$USERNAME_PROMPT_OWNER:
$write sys$command "For ",USERNAME
$GOTO PROMPT_OWNER
$!
$T_OWNER_NULL:
$IF OWNER .EQS. ""  THEN $GOTO PROMPT_OWNER
$!
$LENGTH='F$LENGTH(OWNER)'
$IF LENGTH .LT. 21  THEN $GOTO T_OWNER_QUOTE
$ERROR_FLAG:="is too long"
$GOTO OWNER_ERROR
$!
$T_OWNER_QUOTE:
$IF 'F$LOCATE("""",OWNER) .EQ. LENGTH  THEN $GOTO END_OWNER
$ERROR_FLAG:="contains illegal double quote mark"
$!
$OWNER_ERROR:
$write sys$command "OWNER """,OWNER,""" ",ERROR_FLAG,"."
$!
$PROMPT_OWNER:
$INQUIRE OWNER
$GOTO TEST_OWNER
$!
$END_OWNER:
$!  PRIVILEGE_CLASS:
$!     ? ==> give help & prompt for PRIVILEGE_CLASS.
$!     * ==> give USERNAME & prompt for PRIVILEGE_CLASS.
$!     Seperate PRIVILEGE_CLASS from extra privileges (at +).
$!     PRIVILEGE_CLASS not present ==> set PRIVILEGE_CLASS to USER.
$!     Check for legal PRIVILEGE_CLASS and setup correct privileges for
$!     a given PRIVILEGE_CLASS.
$!     Append extra privileges to privileges setup by PRIVILEGE_CLASS.
$!
$PRIVILEGE_CLASS:='P6'
$!
$TEST_PRIVILEGE_CLASS:
$IF PRIVILEGE_CLASS .NES. "?"  THEN $GOTO T_PC_STAR
$WRITE SYS$COMMAND "Enter PRIVILEGE_CLASS for new account."
$WRITE SYS$COMMAND "This is a four character descriptor which determines"
$WRITE SYS$COMMAND "the privileges the user of this account will recieve."
$WRITE SYS$COMMAND "A +EXTRA_PRIVILEGES may be appended to a normal"
$WRITE SYS$COMMAND "PRIVILEGE_CLASS allowing normal privileges and"
$WRITE SYS$COMMAND "extended privileges to be granted at the same time."
$WRITE SYS$COMMAND "For example, PROG+GRPNAM,SYSNAM,WORLD.  The known           
$WRITE SYS$COMMAND "PRIVILEGE_CLASSES and associated privileges are:"
$write sys$command "USER                TMPMBX,NETMBX"
$write sys$command "PROGrammer          TMPMBX,NETMBX,GROUP"
$write sys$command "OPERator            TMPMBX,NETMBX,OPER,VOLPRO,DIAGNOSE"
$write sys$command "SYStem user         TMPBMX,NETMBX,OPER,VOLPRO,GROUP,WORLD"
$write sys$command "SYSP                all privileges"
$GOTO USERNAME_PROMPT_PC
$!
$T_PC_STAR:
$IF PRIVILEGE_CLASS .NES. "*"  THEN $GOTO T_PC_NULL
$!
$USERNAME_PROMPT_PC:
$write sys$command "For ",USERNAME
$GOTO PROMPT_PC
$!
$T_PC_NULL:
$IF PRIVILEGE_CLASS .EQS. ""  THEN $PRIVILEGE_CLASS:="USER"
$!
$LENGTH='F$LENGTH(PRIVILEGE_CLASS)'
$LOC_PLUS='F$LOCATE("+",PRIVILEGE_CLASS)'
$EXTRA_PRIVILEGES:=""
$IF LOC_PLUS .EQ. LENGTH  THEN $GOTO SET_PRIVILEGES
$START_EXTRA=LOC_PLUS+1
$LENGTH_EXTRA=LENGTH-LOC_PLUS-1
$EXTRA_PRIVILEGES:=",''F$EXTRACT(START_EXTRA,LENGTH_EXTRA,PRIVILEGE_CLASS)'"
$PRIVILEGE_CLASS:='F$EXTRACT(0,LOC_PLUS,PRIVILEGE_CLASS)'
$!
$SET_PRIVILEGES:
$PRIVILEGES:=""
$IF PRIVILEGE_CLASS .EQS. "USER" -
    THEN $PRIVILEGES:="TMPMBX,NETMBX"
$IF PRIVILEGE_CLASS .EQS. "PROG" -
    THEN $PRIVILEGES:="TMPMBX,NETMBX,GROUP"
$IF PRIVILEGE_CLASS .EQS. "OPER" -
    THEN $PRIVILEGES:="TMPMBX,NETMBX,OPER,VOLPRO,DIAGNOSE"
$IF PRIVILEGE_CLASS .EQS. "SYS"  -
    THEN $PRIVILEGES:="TMPMBX,NETMBX,OPER,VOLPRO,GROUP,WORLD"
$IF PRIVILEGE_CLASS .EQS. "SYSP" -
    THEN $PRIVILEGES:="all privileges"
$  !SYSP is handled by a seperate write to AUTH_FILE, thus we do not
$  !need to list all possible privileges here.
$!
$IF PRIVILEGES .NES. ""  THEN $GOTO ADD_EXTRAS
$write sys$command "PRIVILEGE_CLASS """,PRIVILEGE_CLASS, -
                   """ is not a legal privilege class."
$!
$PROMPT_PC:
$INQUIRE PRIVILEGE_CLASS
$GOTO TEST_PRIVILEGE_CLASS
$!
$ADD_EXTRAS:
$PRIVILEGES:="''PRIVILEGES'''EXTRA_PRIVILEGES'"
$!
$END_PRIVILEGE_CLASS:
$!  DEFAULT_DEVICE:
$!     ? ==> give help & prompt for DEFAULT_DEVICE.
$!     * ==> give USERNAME & prompt for DEFAULT_DEVICE.
$!     DEFAULT_DEVICE not present ==> prompt for DEFAULT_DEVICE then if
$!		still null use DRA1: as DEFAULT_DEVICE.
$!     DEFAULT_DEVICE not one of legal default devices ==> give error &
$!             prompt for DEFAULT_DEVICE.
$!
$!     Legal default devices are: DRA0:
$!
$DEFAULT_DEVICE:='P7'
$!
$TEST_DEFAULT_DEVICE:
$IF DEFAULT_DEVICE .NES. "?"  THEN $GOTO T_DD_STAR
$write sys$command "Enter DEFAULT DEVICE for new account."
$write sys$command "This is the disk device which will automatically"
$write sys$command "be assigned to SYS$DISK as a part of the login"
$write sys$command "proceedure.  Currently the legal default devices"
$write sys$command "are: DRA0:."
$GOTO USERNAME_PROMPT_DD
$!
$T_DD_STAR:
$IF DEFAULT_DEVICE .NES. "*"  THEN $GOTO T_DD_NULL
$!
$USERNAME_PROMPT_DD:
$write sys$command "For ",USERNAME
$GOTO PROMPT_DD
$!
$T_DD_NULL:
$IF DEFAULT_DEVICE .EQS. ""  THEN $GOTO PROMPT_DD
$!
$IF DEFAULT_DEVICE .EQS. "DRA0:"  THEN $GOTO END_DEFAULT_DEVICE
$IF DEFAULT_DEVICE .EQS. "DRA1:"  THEN $GOTO END_DEFAULT_DEVICE
$write sys$command DEFAULT_DEVICE," is not a legal default device."
$!
$PROMPT_DD:
$INQUIRE DEFAULT_DEVICE "DEFAULT_DEVICE (DRA1: default)"
$IF DEFAULT_DEVICE .EQS. ""  THEN  $DEFAULT_DEVICE:="DRA1:"
$GOTO TEST_DEFAULT_DEVICE
$!
$END_DEFAULT_DEVICE:
$!  Write to AUTH_FILE:
$!     Generally write a record of the form:
$!     ADD username(P) /PASSWORD=password -
$!         /UIC=uic /ACCOUNT=account -
$!         /OWNER="owner" -
$!         /DEVICE=default_device /DIRECTORY=[username] -
$!         /PRIVILEGE=(privileges)
$!
$!     ACTION:
$!     Stop control-Y.
$!     For SYSP write record adding usernameP giving all privileges and then
$!         exit (we don't create directories for SYSP accounts since they
$!         should have a SYS entry which will create the directory).
$!     For all other privilege classes write appropriate record and proceed
$!         to write CREATE/DIRECTORY section.
$!
$SET NOCONTROL_Y
$!
$IF PRIVILEGE_CLASS .NES. "SYSP"  THEN $GOTO NON_SYSP_ACCOUNT
$!
$WRITE AUTH_FILE "ADD ", USERNAME, "P /PASSWORD=", PASSWORD, " -"
$WRITE AUTH_FILE "    /UIC=", UIC, " /ACCOUNT=", ACCOUNT, " -"
$WRITE AUTH_FILE "    /OWNER=""", OWNER, """ -"
$WRITE AUTH_FILE "    /DEVICE=", DEFAULT_DEVICE, " /DIRECTORY=[", USERNAME,  -
       "] -"
$WRITE AUTH_FILE "    /PRIVILEGE=(ACNT,ALLSPOOL,ALTPRI,BUGCHK,CMEXEC, -"
$WRITE AUTH_FILE "     CMKRNL,DETACH,DIAGNOSE,GROUP,GRPNAM,LOG_IO, -"
$WRITE AUTH_FILE "     MOUNT,NETMBX,OPER,PHY_IO,PRMCEB,PRMGBL,PRMMBX, -"
$WRITE AUTH_FILE "     PSWAPM,SETPRV,SYSGBL,SYSNAM,TMPMBX,VOLPRO,WORLD)"
$SET CONTROL_Y
$EXIT 1
$!
$NON_SYSP_ACCOUNT:
$WRITE AUTH_FILE "ADD ", USERNAME, " /PASSWORD=", PASSWORD, " -"
$WRITE AUTH_FILE "    /UIC=", UIC, " /ACCOUNT=", ACCOUNT, " -"
$WRITE AUTH_FILE "    /OWNER=""", OWNER, """ -"
$WRITE AUTH_FILE "    /DEVICE=", DEFAULT_DEVICE, " /DIRECTORY=[", USERNAME,  -
       "] -"
$WRITE AUTH_FILE "    /PRIVILEGE=(", PRIVILEGES, ")"
$!
$!
$!  Write to DIR_FILE:
$!     Write a record of the form:
$!     $CREATE/DIRECTORY/OWNER=uic default_device:[username]
$!
$WRITE DIR_FILE "$CREATE/DIRECTORY/OWNER=", UIC, " ", DEFAULT_DEVICE, -
       "[", USERNAME, "]"
$SET CONTROL_Y
$EXIT 1
