d 	PROGRAM CHARGE
 
,!++
!
!   TITLE: CHARGE.FOR		Produces bills from PREBILL files.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Records are read from the PREBILL.MMM.YYYY file as specified by
!	the user and a billing print file, BILLS.MMM.YYYY is produced.
!	The file contains totals and charges for each message type for
x!	each member within each group, member and group charges
!	summaries, a re-printing of the group summaries together
@!	produced after all records are read, a run charges summary, and
!	a report by account which lists non-acquisition, acquisition,
!	and personnel charges incurred by each group using the account.
l!	A summary of system reboots and login failures is also printed.
!
4!   ENVIRONMENT: Runs as a user mode VMS image.  Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
`	!
	!   MODIFIED BY:
(
!	Ralph Weber (13-OCT-1980) Organize internal accumulators in

!		include file TALLYDEF.FOR.

!
T!	Ralph Weber (14-OCT-1980) Move accumulator functions to
!		ADD_AMOUNTS and RESET_TOTALS routines.  Cleanup
!		documentation.  Remove [BILLING]SAVEDEF.FOR and
!		attendant garbage.  Move all storage defination
!		statements to documentation pages.  Setup utility sort
H
!		routine.

!
!--
t!++
!
<!	Table of Contents
!
!	(Documentation and storage definations for the routines appear
h!	 on the SOS page preceeding the routine)
!
0!	Routine							SOS Page
!
!	CHARGE (Processes PREBILL files to produce BILLS print
\!		files)						   2
!
$!	BUILD_TABLES (builds tables for charging amounts, 
!		account names and numbers, and group names
!		and UIC's)					   4
P!
!	RESET_TOTALS (manipulates accumulated totals as ditcated
!		changes in various input record values, calls
|!		appropriate end of type, group, etc. print
!		summaries routines)				   6
D!	ADD_USE_TO_MEM (adds usage and charges accumulated for
!		current type to member or member-acquisition
!		accumulators)					   8
p!	ADD_AMOUNTS (adds to the useage array elements determined
!		by the message type)				  10
8!
!	PRINT_HEADINGS (prints the heading appropriate for a
 !		specified message type)				  12
d!	PRINT_AMOUNTS (prints the useage amounts determined
!		by the message type)				  14
,!	PRINT_TYPE_TOT (adds type useage and charge amounts
!		to the member totals arrays and prints the
!		total useage and charges for the message type)	  16
X!	PRINT_MEM_TOT (adds member useage amounts and charges 
!		to the group totals and prints the member useage
 !	 	and charges)					  18
!	PRINT_GRP_TOT (prepares for print the group total
!		usage-charges and writes the group record on
L!		unit 15)					  20
!	GRP_SUM_OUTPUT (actually prints group summaries)	  22
!	GROUP_SUMMARY (reads the scratch file GRPSUMRY.SCR and
x!		prints a charge summary for each group and
!		account within group)				  24
@!	PRINT_FINAL_TOT (prints a summary of useage and charges
!		for the file being processed)			  26
 !	ACCOUNTS_BILLS (sorts the GRPSUMRY.SCR file and prints
l !		totals charges by group within account)		  28
 !
4!!	PROCESS_FORS (reads and sorts the records with message
!!		type 41,42,43, or 44 to produce a summary of 
!!		work done by a systems person by the UIC of the
`"!		user the work was done for)			  30
"!
(#!	SORT_FILE (sorts a given file according to given keys)	  32
#!	PRINT_TOTALS (prints useage amounts and charges passed
#!		to it in a summary layout)			  34
T$!	GET_ACC_NAME (returns the character string account
$!		name corresponding to the account passed to it)	  36
%!	GET_GRP_NAME (returns the character string group
%!		name corresponding the the UIC passed to it)	  38
%!	LEN_STRING (a FUNCTION whose value is the actual length,
H&!		excluding trailing blanks, of the passed string)  40
&!	NEW_PAGE (skips the printout to the top of the page
'!		and sets the line counter to 0, if needed)	  42
t'!	MY_ASCTIM (converts 64-bit binary time to an ASCII 
'!		string)						  44
<(!
(!++
)!
h)!   FUNCTIONAL DESCRIPTION:
)!
0*!	The routine call BUILD_TABLES to build the tables for charge
*!	amounts, group UICs and names, and account values and names.
*!	The name of the input file to be processed (PREBILL.MMM.YYYY)
\+!	is ACCEPTed and opened to verify its existence.  The output
+!	print file, BILLS.MMM.YYYY is opened.  The input file is sorted.
$,!	The file GRPSUMRY.SCR, a scratch file to hold group records for
,!	the run is opened.
,!
P-!	The sorted input file, SORTED.SCR, is opened for processing.
-!	A record is read, the useage ammounts are added via the routine
.!	ADD_AMOUNTS, and printed via the routine PRINT_AMOUNTS.
|.!	Records with message types between 40 and 59 are processed by
.!	the routine PROCESS_FORS.  Because of the way the PREBILL file
D/!	is sorted, system-reboot and login-failure records are last.
/!	When they are reached they are specially processed.
0!
p0!	When the end of normal user records is reached, the following
0!	information summaries are output in the following order.  (When
81!	no information of a given type exists that summary is omitted.)
1!		. Reprinted copies of all group activities summaries
 2!		  (GROUP_SUMMARY)
d2!		. Summaries of system reboots and login failures for
2!		  machine type in the input file
,3!		. A summary of total usage billed for the input file
3!		  (PRINT_FINAL_TOT)
3!		. Bills by account for each account having activity
X4!		  records in the input file (ACCOUNTS_BILLS)
4!
 5!
5!   IMPLICIT INPUTS:
5!
L6!	BILLING:BILLDEF.FOR is the input parameter file containing the
6!		array used to input a record from the extended
7!		accounting file.
x7!
7!	BILLING:TALLYDEF.FOR defines the common block containing
@8!		the counters used to keep running sums of various
8!		values.
9!
l9!   IMPLICIT OUTPUTS:
9!
4:!	BILLS.MMM.YYYY is the output print file produced for the input
:!		file PREBILL.MMM.YYYY.
:!
`;!   SIDE EFFECTS:
;!	
(<!	Temporary files to store intermediate data are created, sorted,
<!	and deleted.  Their names are SORTED.SCR, GROUPCHG.SCR, and
<!	 GRPSUMRY.SCR.  If the program terminates abnormally, some or
T=!	all of these files may not be deleted.
=!
>!--
>
>
H?	INCLUDE 'BILLING:BILLDEF.FOR'
?	COMMON /CHARGE_RECORD/ BILL_RECORD
@
t@	CHARACTER*16 INPUT_FILE
@	COMMON /CHARGE_FILE/ INPUT_FILE
<A
A	INTEGER*2 ITYPE_TENS, ITYPE_UNITS
B	COMMON /CHARGE_MTYPE/ ITYPE_TENS, ITYPE_UNITS
hB
B	CHARACTER*16 PRINT_FILE
0C	LOGICAL*1 NEW_TYPE, END_INPUT, GROUPS_DONE
C
C	INTEGER*2 PREBILL_SRT_KEY(29)
\D	DATA PREBILL_SRT_KEY/ 7,	! Number of keys
D	1				! (position,size,type,a/d)
$E	1	2, 0, 15,  4,		! UIC (15,4,bin,a)
E	2	1, 0, 19, 10,		! USERNAME (19,10,char,a)
E	3	1, 0, 57,  8,		! ACCOUNT (57,8,char,a)
PF	4	1, 0,  7,  6,		! MACHINE (7,6,char,a)
F	5	1, 0,  5,  2,		! MSG. TYPE (5,2,char,a) !!!!
G	6	2, 0, 33,  4,		! TERM. TIME (29,8,bin,a)
|G	7	2, 0, 29,  4/

d !	Build tables for account & group values and names and charges.
 	CALL BUILD_TABLES
,
!	Ask for input file name and test for validity
1	CONTINUE
X	TYPE 9000,
	1'Name of file to be processed (PREBILL.MMM.YYYY or # to stop):'
 9000	FORMAT (1X,A,$)
	ACCEPT 9100,INPUT_FILE
9100	FORMAT (A)
L	IF (INPUT_FILE(1:1).EQ.'#') STOP
	OPEN (UNIT=10,NAME=INPUT_FILE,TYPE='OLD',READONLY,
	1RECORDTYPE='VARIABLE',CARRIAGECONTROL='NONE',ERR=800)
x	CLOSE (UNIT=10)

@!	Form name for output file and open it.
	PRINT_FILE = 'BILLS' // INPUT_FILE(8:16)
	OPEN ( UNIT=9, NAME=PRINT_FILE, TYPE='NEW', DISPOSE='KEEP' )
l
!	Sort input file and open sorted file.
4	CALL SORT_FILE ( INPUT_FILE, 'SORTED.SCR', PREBILL_SRT_KEY )
	OPEN ( UNIT=10, NAME='SORTED.SCR', TYPE='OLD',
	1	DISPOSE='DELETE', CARRIAGECONTROL='NONE',
`		2	RECORDTYPE='VARIABLE' )
	
(
!	Open group-account records file.

	OPEN ( UNIT=15, NAME='GRPSUMRY.SCR', TYPE='NEW',

	1	CARRIAGECONTROL='NONE', RECORDTYPE='FIXED',
T	2	RECORDSIZE=200 )

!	Clear group summary information re-printed flag.
	GROUPS_DONE = .FALSE.

H
!	Loop to process sorted extended accounting file

10	CONTINUE

t	    ! Input from sorted extended accounting file
	    READ ( 10, 9200, END=999 ) NUM_CHARS,
<	1	    ( BILL_RECORD(I), I=0,NUM_CHARS-1 )
9200  	    FORMAT (Q,<NUM_CHARS>A1)

h	    ! Process current record
11	    CONTINUE
0	    ! Break message type into tens and units parts.
	    ITYPE_TENS = BILL_W_MSGTYP / 10
	    ITYPE_UNITS = BILL_W_MSGTYP - (ITYPE_TENS * 10)
\
	    ! Check for new anything and if found print apprpriate
$	    ! things and reset appropriate totals.
	    CALL RESET_TOTALS ( NEW_TYPE )
	    IF (NEW_TYPE) THEN
P
		IF (BILL_W_MSGTYP.GT.40 .AND. BILL_W_MSGTYP.LT.60) THEN
		    !  Process records with message types 41-44 using
|		    ! special for processing technique.
		    CALL PROCESS_FORS ( END_INPUT )
D		    IF ( END_INPUT )  GO TO 999
		    GO TO 11

p		ELSEIF (BILL_W_MSGTYP.LT.0 .AND. .NOT.GROUPS_DONE)  THEN
		    ! Before printing reboot and login-failures
8		    ! summaries, produce re-print of group-account
		    ! summaries.
 		    CALL GROUP_SUMMARY
d		    GROUPS_DONE = .TRUE.

,		ENDIF

		! Print heading for newly encountered type.
X		CALL PRINT_HEADING

 	    ENDIF

	    ! Add new record to usage counters.
L	    CALL ADD_AMOUNTS

	    ! If not a login failure, print record information.
x	    IF (BILL_W_MSGTYP .NE. -1)  CALL PRINT_AMOUNTS

@	GO TO 10

 
l !	Processing after end of sorted input reached.
 
4!!	EOF while reading.
!999	CONTINUE
!	! Fix data so that RESET_TOTALS can be used to print
`"	! last type, member, and group tables.
"	BILL_W_GRP = -1
(#	BILL_W_MSGTYP = -999
#	CALL RESET_TOTALS( NEW_TYPE )
#
T$!	Close sorted input file.
$	CLOSE (UNIT=10,DISPOSE='DELETE')
%
%!	Print group summaries together if not already done so. (no login
%!	failures or boot records in input file)
H&	IF (.NOT.GROUPS_DONE) THEN
&	    CALL GROUP_SUMMARY
'	    GROUPS_DONE=.TRUE.
t'	ENDIF
'
<(!	Print total input file summary and bills by account summary.
(	CALL PRINT_FINAL_TOT
)	CALL ACCOUNTS_BILLS
h)
)!	Close printed output file (BILLS.MMM.YYYY).
0*	CLOSE (UNIT=9)
*
*!	Go ask about another input file.
\+	GO TO 1
+
$,!	Error in typed input file name: give message and retry.
,800	TYPE *,'BAD FILE NAME, TRY AGAIN'
,	GO TO 1
P-	END

d 	SUBROUTINE BUILD_TABLES
 
,!++
!
!   TITLE: BUILD_TABLES		Build tables for charges and names.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Builds tables for charges, account names, and group names from
!	input files CHARGES.DAT, ACCOUNTS.DAT, and GROUPS.DAT,
!	respectively.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!	Ralph Weber (14-OCT-1980) Cleanup documentation and storage
4!		definations.
!
!	Ralph Weber (21-OCT-1980)  Setup new charges table format
`	!		using /CHARGE_COSTS/ and /CHARGE_CQNAME/.  Alter
	!		routine accordingly.
(
!

!--

!++
T!
!   FUNCTIONAL DESCRIPTION:
!
!	This routine builds three sets of tables from the contents of
!	three input files.  The tables are: 1) Charges information
H
!	tables built from file CHARGES.DAT; 2) Account names tables

!	built from file ACCOUNTS.DAT; and 3) Group names tables built
!	from file GROUPS.DAT.
t!
!	Charges Information Tables (CHARGES.DAT)
<!
!	These tables, contained in /CHARGE_COSTS/ and /CHARGE_CQNAME/
!	list the amounts charged for each billable service.  Amounts
h!	charged for unique services, such as CPU time, are placed in
!	/CHARGE_COSTS/ variables of the form AMT_???????, where ????????
0!	is one of:
!			CONNECT	  connect time.
!			CPUTIME	  CPU time.
\!			BYTIOCNT  byte I/O's (unit record I/O's).
!			DRTIOCNT  direct I/O's (mass storage I/O's).
$!			VOLUMES   volume mounts.
!			PAGEFLTS  page faults.
!			PRTPAGCT  number of printed pages.
P!			PRTLINCT  number of printed lines.
!			PRTRDCT   number of reads during print.
!	For these charges, CHARGES.DAT, contains free-format lines each
|!	having two values, a character string equal to '????????' and
!	the value to be assigned to AMT_????????.  For example:
D!		'CPUTIME', 5.5
!	This routine uses arrays AMT_NAMES and AMT_ARRAY to look-up the
!	first value and assign the second value to the correct
p!	AMT_????????.
!
8!	Charges for systems personnel time (rendered in aid of other
!	users) are stored in array AMT_BY( UIC_GRP, UIC_MEM ) where
 !	UIC_GRP and UIC_MEM are derived from the systems person's UIC.
d!	AMT_BY is also found in /CHARGE_COSTS/.  For these charges
!	CHARGES.DAT contains format free lines each having two values,
,!	a character string of the form 'BY[ggg,mmm]' giving the systems
!	person's UIC and the amount to be charged for services rendered
!	that person.  For example:
X!		'BY[17,4]', 14.0
!	This routine interpretes the UIC and places the amount in the
 !	corresponding part of array AMT_BY.
!
!	This system provides for an across the board cost adjustment
L!	factor for data acquisition.  This factor is entered in percent
!	adjustment on a line in CHARGES.DAT having the form:
!		'%ACQ', 100.0
x!	The value is placed in ADJM_ACQ which is in /CHARGE_COSTS/.
!
@!	Across the board cost adjustment is also provided for queues
!	(currently only batch queues).  Adjustment factors are entered
 !	by CHARGES.DAT lines of the form:
l !		'%queue-name', 100.0
 !	This routine places the queue name in ADJM_NAME_QUEUE(n) which
4!!	is contained is /CHARGE_CQNAME/ and the adjustment factor in
!!	ADJM_QUEUE(n) an element of /CHARGE_COSTS/.  LAST_QUEUE located
!!	in /CHARGE_COUNTERS/ gives the maximum 'n' used in these two
`"!	arrays.
"!
(#!	Charge amounts which do not appear in CHARGES.DAT will be set
#!	to zero.  Adjustment factors which do not appear in CHARGES.DAT
#!	will be set to 100%.
T$!
$!	Account Names Tables (ACCOUNTS.DAT)
%!
%!	These tables, contained in /CHARGE_TABLES/, contain information
%!	relating VMS account numbers to text describing the account.
H&!	ACCOUNTS.DAT contains one line for each VMS account number
&!	of the form:
'!		'VMS-account', 'account-name-text'
t'!	This routine places the VMS account number in ACCOUNTS(n) and
'!	the descriptive text in ACCOUNT_NAMES(n) both located in
<(!	/CHARGE_TABLES/.  LAST_ACCOUNT located in /CHARGE_COUNTERS/
(!	gives the maximum 'n' used in these two arrays.
)!
h)!	Group Names Tables (GROUPS.DAT)
)!
0*!	These tables, contained in /CHARGE_TABLES/ and /CHARGE_ITABLES/,
*!	contain information relating UIC group numbers to text
*!	describing the group.  GROUPS.DAT contains one line for each
\+!	UIC group of the form:
+!		'group-no-octal', 'group-text-description'
$,!	This routine places the group number in IGROUP_UICS(n) which is
,!	in /CHARGE_ITABLES/ and the descriptive text in GROUP_NAMES(n)
,!	which is in /CHARGE_TABLES/.  LAST_GROUP located in
P-!	/CHARGE_COUNTERS/ gives the maximum 'n' used in these two
-!	arrays.
.!
|.!   CALLING SEQUENCE:
.!
D/!	CALL BUILD_TABLES
/!
0!   INPUT PARAMETERS: None.
p0!
0!   OUTPUT PARAMETERS: None.
81!
1!   IMPLICIT INPUTS:
 2!
d2!	ACCOUNTS.DAT	is the input data file from which information is
2!			drawn for the tables ACCOUNTS and ACCOUNT_NAMES.
,3!
3!	CHARGES.DAT	is the input data file from which information is
3!			drawn for the tables CHARGE_AMOUNTS and
X4!			CHARGE_BY.
4!
 5!	GROUPS.DAT	is the input data file from which information is
5!			drawn for the tables IGROUP_UICS and
5!			GROUP_NAMES.
L6!
6!   IMPLICIT OUTPUTS:
7!
x7!	/CHARGE_COSTS/	contains charges for billable services,
7!			AMT_???????? and adjustment factors,
@8!			ADJM_????????.
8!
9!	/CHARGE_CQNAME/	contains array of queue names corresponding
l9!			to queue adjustment factors in /CHARGE_COSTS/.
9!
4:!	/CHARGE_TABLES/	contains text string arrays for account and
:!			group information tables.
:!
`;!	/CHARGE_ITABLES/ contains UIC group number array corresponding
;!			to group-text-description array in
(<!			/CHARGE_TABLES/.
<!
<!	/CHARGE_COUNTERS/ contains limits of accounts and groups names
T=!			tables.
=!
>!   COMPLETION STATUS: Normal return.
>!
>!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
H?!
?!--
@
t@
@	CHARACTER*8  ACCOUNTS(50)
<A	CHARACTER*80 ACCOUNT_NAMES(50), GROUP_NAMES(50)
A	COMMON /CHARGE_TABLES/ ACCOUNTS, ACCOUNT_NAMES, GROUP_NAMES
B	INTEGER*2 IGROUP_UICS(50)
hB	COMMON /CHARGE_ITABLES/ IGROUP_UICS
B
0C
C	COMMON /CHARGE_COSTS/
C	1	AMT_CONNECT,  AMT_CPUTIME,  AMT_BYTIOCNT,
\D	2	AMT_DRTIOCNT, AMT_VOLUMES,  AMT_PAGEFLTS,
D	3	AMT_PRTPAGCT, AMT_PRTLINCT, AMT_PRTRDCT,
$E	4	AMT_BY( "17:"20, 0:"47),
E	5	ADJM_ACQ, ADJM_QUEUE(5)
E
PF	CHARACTER*16 ADJM_NAME_QUEUE(5)
F	COMMON /CHARGE_CQNAME/ ADJM_NAME_QUEUE
G
|G	COMMON /CHARGE_COUNTERS/ LINE_COUNT, LAST_QUEUE, LAST_ACCOUNT,
G	1	LAST_GROUP
DH
H
I	REAL*4 AMT_ARRAY(9)
pI	EQUIVALENCE (AMT_ARRAY(1), AMT_CONNECT)
I	CHARACTER*8 AMT_NAMES(9)
8J	DATA AMT_NAMES /	'CONNECT',  'CPUTIME',  'BYTIOCNT',
J	1			'DRTIOCNT', 'VOLUMES',  'PAGEFLTS',
 K	2			'PRTPAGCT', 'PRTLINCT', 'PRTRDCT' /
dK
K	CHARACTER CHR18 *18,  CHR3 *3

d !	Build Charges tables
 	LAST_QUEUE = 0
,	ADJM_ACQ = 1.0
	DO 3 I = 1, 9
	    AMT_ARRAY(I) = 0.0
X3	CONTINUE
	OPEN ( UNIT=2, NAME='CHARGES.DAT', TYPE='OLD', READONLY )
 5	CONTINUE
	READ (2,*,END=19) CHR18,AMOUNT
	IF (CHR18(1:2).EQ.'BY' .AND. CHR18(1:3).NE.'BYT') THEN
L	    ! Charges for system personnel work
	    ! Decode UIC.
	    IFIRST=INDEX(CHR18,'[')+1
x	    ILAST =INDEX(CHR18,',')-1
	    LEN=ILAST-IFIRST+1
@	    DECODE (LEN,9100,CHR18(IFIRST:ILAST),ERR=7) IGROUP
9100	    FORMAT (O<LEN>)
	    IFIRST=ILAST+2	
l	    ILAST =INDEX(CHR18,']')-1	
	    LEN=ILAST-IFIRST+1		
4	    DECODE (LEN,9100,CHR18(IFIRST:ILAST),ERR=7) IMEMBER	
	    ! Place charge amount.
	    AMT_BY( IGROUP, IMEMBER ) = AMOUNT
`		    GO TO 8
	7	    TYPE *, 'Bad BY-UIC, ', CHR18, ', ignored.'
(
8	    CONTINUE

	ELSEIF (CHR18(1:1) .EQ. '%')  THEN

	    !An adjustment factor
T	    IF (CHR18 .EQ. '%ACQ')  THEN
		!Acquisition adjustment factor
		ADJM_ACQ = AMOUNT / 100.0
	    ELSE
		!A queue adjustment
H
		LAST_QUEUE = LAST_QUEUE + 1

		IF (LAST_QUEUE .LE. 5)  THEN
		    ADJM_NAME_QUEUE( LAST_QUEUE ) = CHR18( 2: )
t		    ADJM_QUEUE( LAST_QUEUE ) = AMOUNT / 100.0
		ELSE
<		    STOP 'More than 5 queue adjustment factors.'
		ENDIF
	    ENDIF
h	ELSE
	    !Regular billable services amount, I hope.
0	    DO 11 I = 1, 9
		IF (CHR18 .EQ. AMT_NAMES(I)) THEN
		    AMT_ARRAY(I) = AMOUNT
\		    GO TO 5
		ENDIF
$11	    CONTINUE
	    !No: not a billable service.
	    TYPE *, 'Invalid charge name, ', CHR18, ' ignored.'
P	ENDIF
	GO TO 5

|19	CLOSE (UNIT=2)

D!	Account Names Table
	OPEN ( UNIT=2, NAME='ACCOUNTS.DAT', TYPE='OLD', READONLY )
	LAST_ACCOUNT=0
p	DO 55 I = 1, 50
	    READ (2,*,END=59) ACCOUNTS(I), ACCOUNT_NAMES(I)
8	    LAST_ACCOUNT = I
55	CONTINUE
 	STOP 'More than 50 entries needed in account tables'
d59	CONTINUE
	CLOSE (UNIT=2)
,
!	Group Names Table
	OPEN ( UNIT=2, NAME='GROUPS.DAT', TYPE='OLD', READONLY )
X	LAST_GROUP=0
	DO 75 I = 1, 50
 71	    READ (2,*,END=79) CHR3, GROUP_NAMES(I)
	    LAST_GROUP = I
	    LEN = LEN_STRING( CHR3 )
L	    DECODE (LEN, 9200, CHR3( :LEN ), ERR=73) IGROUP_UICS(I)
9200	    FORMAT (O3)
	    GO TO 75
x73	    TYPE *, 'Bad group ,', CHR3, ', ignored.'
	    GO TO 71
@75	CONTINUE
	STOP 'More than 50 entries needed in group tables.'
 79	CONTINUE
l 	CLOSE (UNIT=2)
 	RETURN
4!	END

d 	SUBROUTINE RESET_TOTALS( NEW_TYPE )
 
,!++
!
!   TITLE: RESET_TOTALS		Detects and acts on changes in input
X!				records.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	Detects changes in input records and when changes found
!	causes appropriate usage summaries to be printed.  Also
x!	resets some counters and sums others as appropriate for
!	new input record type.
@!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
l!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
4!   MODIFIED BY:
!	Ralph Weber (13-OCT-1980) Organize internal accumulators in
!		include file TALLYDEF.FOR.  Reset NEW_TYPE flag.
`	!
	!	Ralph Weber (15-OCT-1980) Completely rewrite routine moving
(
!		all new type detection and action code here.

!

!--
T!++
!
!   FUNCTIONAL DESCRIPTION:
!
!	This routine looks for any one of the following changes in
H
!	the input data stream (sorted PREBILL type records) and acts

!	according to the type of change found.
!
t!	* A NEW INPUT FILE
!	Zeros all charging accumulators, run, UIC, and usage-type.
<!	If new usage-type is positive, opens a new MEMACCT file.
!	If new usage-type is negative, zeros login-failures or
!	system-down-time counter, as appropriate.
h!
!	* A NEW GROUP
0!	Prints usage-type totals.
!	If current usage-type is positive:
!	Adds usage-type accumulators to member accumulators.  Prints
\!	member and group summaries.  Adds member accumulators to run
!	accumulators.  Zeros member and usage-type accumulators.
$!	In any case:
!	If new usage-type is positive, opens a new MEMACCT file.
!	If new usage-type is negative, zeros login-failures or
P!	system-down-time counter, as appropriate.
!
!	* A NEW MEMBER or A NEW ACCOUNT
|!	Prints usage-type totals.  Adds usage-type accumulators to
!	member accumulators.  Prints a member summary.  Zeros member
D!	and usage-type accumulators.
!
!	* A NEW USAGE- or MACHINE-TYPE
p!	Prints usage-type totals.  Adds usage-type accumulators to
!	member accumulators.  Zeros usage-type accumulators.
8!
!	If there has been no change in any of the items tested, NEW_TYPE
 !	is set to false and this routine is exited.  Otherwise, several
d!	internal comparison values are updated and NEW_TYPE is set to
!	true before this routine is exited.
,!
!   CALLING SEQUENCE:
!
X!	CALL RESET_TOTALS( NEW_TYPE.wbu.r )
!
 !   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS:
L!
!	NEW_TYPE.wbu.r	a return flag indicating that a new input record
!			type was encountered.
x!				.TRUE.	if new type encountered.
!				.FALSE.	if new type not encountered.
@!
!   IMPLICIT INPUTS:
 !
l !	/CHARGE_RECORD/	contains the current input record.
 !
4!!	/CHARGE_FILE/	contains the character variable INPUT_FILE
!!			which gives the name of the current input
!!			file.
`"!
"!	/CHARGE_TALLY/	contains usage and charge counters.  Counter
(#!			names are formed with two parts seperated by an
#!			underscore.  The first part indicates the range
#!			of records being tallied and is one of the
T$!			following:
$!			ITOT	usage for current type.
%!			ITUIC	usage for current UIC.
%!			KAUIC	acquisition usage for current UIC.
%!			ITRUN	usage for current input file.
H&!			KARUN	acquisition usage for current file.
&!			CHARGE	charges for current type.
'!			CRGUIC	charges for current UIC.
t'!			ACGUIC	acquisition charges for current UIC.
'!			CRGRUN	charges for current input file.
<(!			ACGRUN	acquisition charges for current file.
(!			The second part indicates the item being tallied
)!			and is one of the following:
h)!			CONNECT	  connect time.
)!			BY	  systems personal time.
0*!			CPUTIME	  CPU time.
*!			BYTIOCNT  byte I/O's (unit record I/O's).
*!			DRTIOCNT  direct I/O's (mass storage I/O's).
\+!			VOLUMES   volume mounts.
+!			PAGEFLTS  page faults.
$,!			PRTPAGCT  number of printed pages.
,!			PRTLINCT  number of printed lines.
,!			PRTRDCT   number of reads during print.
P-!			ARRAY	  an array to access all counters for a
-!				  given tally range.
.!			/CHARGE_TALLY/ includes all names resulting
|.!			from all first parts crossed with all second
.!			parts.
D/!			Also included in /CHARGE_TALLY/ are:
/!			LOGFAILS	a counter for the number of
0!					login failures.
p0!			ITOTAL_DOWN	a quadword counter for system
0!					down time.
81!			As inputs these values provide totals for
1!			various totals printing routines.
 2!
d2!	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
2!			these parameters give the starting and ending
,3!			subscripts of the access arrays in
3!			/CHARGE_TALLY/; TALLY_??? for the usage counters
3!			and CHARGE_??? for the charges counters.
X4!
4!   IMPLICIT OUTPUTS:
 5!
5!	/CHARGE_TALLY/	As outputs the values in this common block are
5!			zeroed as appropriate.  (See implicit inputs
L6!			for a description of common block contents.)
6!
7!	in /CHARGE_FOR/
x7!	/CHARGE_FOR/ is to FOR accumulators as /CHARGE_TALLY/ is to
7!	all other accumulators.  However, it only needs by non-
@8!	acquisition accumulators.
8!
9!	ITFOR_ARRAY	is the array of other charge counters for the
l9!			current FOR work.
9!
4:!	CRGFOR_ARRAY	is the array of charges for the current FOR
:!			work.
:!
`;!
;!	MEMACCT.SCR	is a scratch file which this routine opens
(<!			and attaches to logical unit 8 whenever
<!			input conditions dictate it's use.
<!
T=!   COMPLETION STATUS: Normal return.
=!
>!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
>!
>!--
H?
?	LOGICAL*1 NEW_TYPE
@
t@	INCLUDE 'BILLING:TALLYDEF.FOR'
@	COMMON /CHARGE_FOR/ ITFOR_ARRAY( TALLY_BEGIN : TALLY_END ),
<A	1	CRGFOR_ARRAY( CHARGE_END )
A
B	INCLUDE 'BILLING:BILLDEF.FOR/NOLIST'  ! Listed in main program
hB	COMMON /CHARGE_RECORD/ BILL_RECORD
B
0C	CHARACTER*16 INPUT_FILE
C	COMMON /CHARGE_FILE/ INPUT_FILE
C
\D	INTEGER*2 LAST_TYPE, LAST_GROUP, LAST_MEMBER
D	CHARACTER*6 LAST_MACHINE
$E	CHARACTER*8  LAST_ACCOUNT
E	CHARACTER*10 LAST_USERNAME
E	CHARACTER*16 LAST_FILE
PF	CHARACTER*20 LAST_OWNER
F	DATA LAST_TYPE, LAST_GROUP, LAST_MEMBER / -1, -1, -1 /
G	DATA LAST_MACHINE, LAST_ACCOUNT, LAST_USERNAME, LAST_FILE,
|G	1	LAST_OWNER / ' ', ' ', ' ', ' ', ' ' /

d !	* A NEW INPUT FILE
 	IF ( INPUT_FILE .NE. LAST_FILE )  THEN
,	    DO 5 I = TALLY_BEGIN, TALLY_END
		ITOT_ARRAY(I)  = 0
		ITUIC_ARRAY(I) = 0
X		KAUIC_ARRAY(I) = 0
		ITFOR_ARRAY(I) = 0
 		ITRUN_ARRAY(I) = 0
		KARUN_ARRAY(I) = 0
5	    CONTINUE
L	    DO 7 I = CHARGE_BEGIN, CHARGE_END
		CHARGE_ARRAY(I) = 0.0
		CRGUIC_ARRAY(I) = 0.0
x		ACGUIC_ARRAY(I) = 0.0
		CRGFOR_ARRAY(I) = 0.0
@		CRGRUN_ARRAY(I) = 0.0
		ACGRUN_ARRAY(I) = 0.0
7	    CONTINUE
l	    IF ( BILL_W_MSGTYP .GE. 0 )  THEN
		OPEN ( UNIT=8, NAME='MEMACCT.SCR', TYPE='NEW',
4	1	    CARRIAGECONTROL='NONE', RECORDTYPE='FIXED',
	2	    RECORDSIZE=200 )
	    ELSEIF ( BILL_W_MSGTYP .EQ. -1 )  THEN
`			LOGFAILS = 0
		    ELSEIF ( BILL_W_MSGTYP .EQ. -2 )  THEN
(
		ITOTAL_DOWN(1) = 0

		ITOTAL_DOWN(2) = 0

	    ENDIF
T

!	* A NEW GROUP
	ELSEIF ( BILL_W_GRP .NE. LAST_GROUP )  THEN
	    CALL PRINT_TYPE_TOT( LAST_TYPE, LAST_MACHINE )
H
	    IF ( LAST_TYPE .GE. 0 )  THEN

		CALL ADD_USE_TO_MEM( LAST_TYPE )
		CALL PRINT_MEM_TOT( LAST_GROUP, LAST_MEMBER,
t	1	    LAST_ACCOUNT, LAST_USERNAME, LAST_OWNER )
		CALL PRINT_GRP_TOT
<		CALL ADDQUAD( ITUIC_CONNECT, ITRUN_CONNECT,
	1			ITRUN_CONNECT )
		CALL ADDQUAD( ITUIC_BY, ITRUN_BY, ITRUN_BY )
h		DO 15 I = 1, TALLY_END
		    ITRUN_ARRAY(I) = ITRUN_ARRAY(I) + ITUIC_ARRAY(I)
0		    KARUN_ARRAY(I) = KARUN_ARRAY(I) + KAUIC_ARRAY(I)
15		CONTINUE
		DO 17 I = 1, CHARGE_END
\		    CRGRUN_ARRAY(I) = CRGRUN_ARRAY(I) + CRGUIC_ARRAY(I)
		    ACGRUN_ARRAY(I) = ACGRUN_ARRAY(I) + ACGUIC_ARRAY(I)
$17		CONTINUE
		DO 19 I = TALLY_BEGIN, TALLY_END
		    ITOT_ARRAY(I)  = 0
P		    ITUIC_ARRAY(I) = 0
		    KAUIC_ARRAY(I) = 0
		    ITFOR_ARRAY(I) = 0
|19		CONTINUE
		DO 21 I = CHARGE_BEGIN, CHARGE_END
D		    CHARGE_ARRAY(I) = 0.0
		    CRGUIC_ARRAY(I) = 0.0
		    CRGFOR_ARRAY(I) = 0.0
p		    ACGUIC_ARRAY(I) = 0.0
21		CONTINUE
8	    ENDIF
	    IF ( BILL_W_MSGTYP .GE. 0 )  THEN
 		OPEN ( UNIT=8, NAME='MEMACCT.SCR', TYPE='NEW',
d	1	    CARRIAGECONTROL='NONE', RECORDTYPE='FIXED',
	2	    RECORDSIZE=200 )
,	    ELSEIF ( BILL_W_MSGTYP .EQ. -1 )  THEN
		LOGFAILS = 0
	    ELSEIF ( BILL_W_MSGTYP .EQ. -2 )  THEN
X		ITOTAL_DOWN(1) = 0
		ITOTAL_DOWN(2) = 0
 	    ENDIF


L!	* A NEW MEMBER or A NEW ACCOUNT
	ELSEIF ( BILL_W_MEM .NE. LAST_MEMBER .OR.
	1	 BILL_T_ACCOUNT .NE. LAST_ACCOUNT )  THEN
x	    CALL PRINT_TYPE_TOT( LAST_TYPE, LAST_MACHINE )
	    IF ( LAST_TYPE .GE. 0 )  THEN
@		CALL ADD_USE_TO_MEM( LAST_TYPE )
		CALL PRINT_MEM_TOT( LAST_GROUP, LAST_MEMBER,
 	1	    LAST_ACCOUNT, LAST_USERNAME, LAST_OWNER )
l 		DO 35 I = TALLY_BEGIN, TALLY_END
 		    ITOT_ARRAY(I)  = 0
4!		    ITUIC_ARRAY(I) = 0
!		    KAUIC_ARRAY(I) = 0
!		    ITFOR_ARRAY(I) = 0
`"35		CONTINUE
"		DO 37 I = CHARGE_BEGIN, CHARGE_END
(#		    CHARGE_ARRAY(I) = 0.0
#		    CRGUIC_ARRAY(I) = 0.0
#		    ACGUIC_ARRAY(I) = 0.0
T$		    CRGFOR_ARRAY(I) = 0.0
$37		CONTINUE
%	    ENDIF
%	    IF ( BILL_W_MSGTYP .EQ. -1 )  THEN
%		LOGFAILS = 0
H&	    ELSEIF ( BILL_W_MSGTYP .EQ. -2 )  THEN
&		ITOTAL_DOWN(1) = 0
'		ITOTAL_DOWN(2) = 0
t'	    ENDIF
'
<(
(!	* A NEW USAGE- or MACHINE-TYPE
)	ELSEIF ( BILL_W_MSGTYP .NE. LAST_TYPE .OR.
h)	1	 BILL_T_MACHCODE .NE. LAST_MACHINE )  THEN
)	    CALL PRINT_TYPE_TOT( LAST_TYPE, LAST_MACHINE )
0*	    IF ( LAST_TYPE .GE. 0 )  THEN
*		CALL ADD_USE_TO_MEM( LAST_TYPE )
*		DO 45 I = TALLY_BEGIN, TALLY_END
\+		    ITOT_ARRAY(I)  = 0
+45		CONTINUE
$,		DO 47 I = CHARGE_BEGIN, CHARGE_END
,		    CHARGE_ARRAY(I) = 0.0
,47		CONTINUE
P-	    ENDIF
-	    IF ( BILL_W_MSGTYP .EQ. -1 )  THEN
.		LOGFAILS = 0
|.	    ELSEIF ( BILL_W_MSGTYP .EQ. -2 )  THEN
.		ITOTAL_DOWN(1) = 0
D/		ITOTAL_DOWN(2) = 0
/	    ENDIF
0
p0
0!	* NONE OF THE ABOVE
81	ELSE
1	    NEW_TYPE = .FALSE.
 2	    RETURN
d2	ENDIF
2
,3!	* ANY CHANGE IN INPUT (all of the above)
3	LAST_FILE	= INPUT_FILE
3	LAST_TYPE	= BILL_W_MSGTYP
X4	LAST_GROUP	= BILL_W_GRP
4	LAST_MEMBER	= BILL_W_MEM
 5	LAST_MACHINE	= BILL_T_MACHCODE
5	LAST_ACCOUNT	= BILL_T_ACCOUNT
5	LAST_USERNAME	= BILL_T_USERNAME
L6	LAST_OWNER	= BILL_T_OWNER
6	NEW_TYPE = .TRUE.
7	RETURN
x7
7	END

d 	SUBROUTINE ADD_USE_TO_MEM( LAST_TYPE )
 
,!++
!
!  TITLE: ADD_USE_TO_MEM	Adds usage for the current usage type
X!				to the UIC totals accumulators.
!
 !  FACILITY: BILLING SYSTEM
!
!  ABSTRACT:
L!
!	Adds usage- and charge- counters for current type to
!	corresponding accumulators for either acquisition or normal
x!	depending on whether current usage type is for acquisition
!	or not.
@!
!  ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
l!  AUTHOR: Ralph Weber		CREATION DATE: 19-OCT-1980
!
4!  MODIFIED BY:
!	Ralph Weber (25-OCT-1980) Setup to accumulate FOR usage.
!
`	!--
	!++
(
!

!  FUNCTIONAL DESCRIPTION:

!
T!	If the current usage type, as given by the argument, is
!	not for acquisition (not greater than 60), the current
!	usage- and charge-accumulators are added to the UIC
!	usage- and charge-accumulators: otherwise they are added
!	to the UIC acquisition usage- and charge-accumulators.
H
!

!  CALLING SEQUENCE:
!
t!	CALL ADD_USE_TO_MEM( LAST_TYPE.rw.r )
!
<!  INPUT PARAMETERS:
!
!	LAST_TYPE.rw.r	is the usage type number for the type of
h!			usage currently accumulated in the current
!			type accumulators.
0!
!  OUTPUT PARAMETERS: None.
!
\!  IMPLICIT INPUTS:
!
$!	from /CHARGE_TALLY/
!
!	ITOT_CONNECT	is accumulated connect time for the current
P!			type.
!
!	ITOT_BY		is the accumulated systems personnel time for
|!			the current type.
!
D!	ITOT_ARRAY	is the array of other charge counters for the
!			current type.
!
p!	CHARGE_ARRAY	is the array of charges for the current type.
!
8!  IMPLICIT OUTPUTS:
!
 !	in /CHARGE_TALLY/
d!
!	????_CONNECT	is the accumulated connect time for the current
,!			UIC.
!
!	????_BY		is the accumulated systems personnel time for
X!			the current UIC.
!
 !	????_ARRAY	is the array of other charge counters for the
!			current UIC.
!
L!	$$$$_ARRAY	is the array of charges for the current UIC.
!
!	Replace ???? by ITUIC for normal usage or by KAUIC for
x!	acquisition usage.  Replace $$$$ by CRGUIC for normal usage
!	or by ACGUIC for acquisition usage.
@!
!	in /CHARGE_FOR/
 !	/CHARGE_FOR/ is to FOR accumulators as /CHARGE_TALLY/ is to
l !	all other accumulators.  However, it only needs by non-
 !	acquisition accumulators.
4!!
!!	ITFOR_CONNECT	is the accumulated FOR connect time.
!!
`"!	ITFOR_ARRAY	is the array of other charge counters for the
"!			current FOR work.
(#!
#!	CRGFOR_ARRAY	is the array of charges for the current FOR
#!			work.
T$!
$!	FOR_FLAG	is a flag used to indicate FOR usage have been
%!			accumulated.
%!
%!  COMPLETION STATUS: Normal, hopefully.
H&!
&!  SIDE EFFECTS: See implicit outputs.
'!
t'!--
'
<(	INTEGER*2 LAST_TYPE
(
)	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
h)
)	! Usage counters for the current FOR work.
0*	COMMON / CHARGE_FOR /  ITFOR_CONNECT(2), ITFOR_XXBY(2),
*	1	ITFOR_XXX(TALLY_END)
*	DIMENSION ITFOR_ARRAY ( TALLY_BEGIN : TALLY_END )
\+	EQUIVALENCE ( ITFOR_XXX, ITFOR_ARRAY(1) )
+
$,	! Charge counters for the current FOR work.
,	COMMON / CHARGE_FOR / CRGFOR_ARRAY(CHARGE_END)
,
P-	LOGICAL*1 FOR_FLAG
-	COMMON / CHARGE_FOR / FOR_FLAG
.	DATA FOR_FLAG / .FALSE. /

d !	Non-acquisition, non-FOR
 	IF ( LAST_TYPE .LE. 39 )  THEN
,	    CALL ADDQUAD( ITOT_CONNECT, ITUIC_CONNECT, ITUIC_CONNECT )
	    CALL ADDQUAD( ITOT_BY, ITUIC_BY, ITUIC_BY )
	    DO 5 I = 1, TALLY_END
X		ITUIC_ARRAY(I) = ITUIC_ARRAY(I) + ITOT_ARRAY(I)
5	    CONTINUE
 	    DO 7 I = 1, CHARGE_END
		CRGUIC_ARRAY(I) = CRGUIC_ARRAY(I) + CHARGE_ARRAY(I)
7	    CONTINUE
L
!	Acquisition, non-FOR
	ELSEIF (LAST_TYPE .GE. 60)  THEN
x	    CALL ADDQUAD( ITOT_CONNECT, KAUIC_CONNECT, KAUIC_CONNECT )
	    CALL ADDQUAD( ITOT_BY, KAUIC_BY, KAUIC_BY )
@	    DO 15 I = 1, TALLY_END
		KAUIC_ARRAY(I) = KAUIC_ARRAY(I) + ITOT_ARRAY(I)
15	    CONTINUE
l	    DO 17 I = 1, CHARGE_END
		ACGUIC_ARRAY(I) = ACGUIC_ARRAY(I) + CHARGE_ARRAY(I)
417	    CONTINUE

!	FOR
`		ELSE
		    FOR_FLAG = .TRUE.
(
	    CALL ADDQUAD( ITOT_CONNECT, ITFOR_CONNECT, ITFOR_CONNECT )

	    DO 25 I = 1, TALLY_END

		ITFOR_ARRAY(I) = ITFOR_ARRAY(I) + ITOT_ARRAY(I)
T25	    CONTINUE
	    DO 27 I = 1, CHARGE_END
		CRGFOR_ARRAY(I) = CRGFOR_ARRAY(I) + CHARGE_ARRAY(I)
27	    CONTINUE

H
	ENDIF

	RETURN
t
	END

d 	SUBROUTINE ADD_AMOUNTS
 
,!++
!
!   TITLE: ADD_AMOUNTS		Adds appropriate useages to type totals
X!				and charges to charge accumulators.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	Updates usage- and charge-accumulators based on current input
!	record.  Charges are adjusted by percentage factors for
x!	batch queue and/or data acquisition usage, where appropriate.
!
@!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
l!
!   MODIFIED BY:
4!
!	Ralph Weber (19-OCT-1980) Add charges computation and new
!		accumulators commom /CHARGE_TALLY/.
`	!
	!--
(
!++

!

!   FUNCTIONAL DESCRIPTION:
T!
!	First the special cases of login failures and system reboots
!	are check for and delt with if they exist.  For other input
!	records, the current message type number is broken into units
!	and tens digits values to aid in message type interpretation.
H
!	A percentage adjustment factor is computed so that it is the

!	sum the percent adjustment for data acquisition and the percent
!	adjustment for whatever batch queue, if any, that was used.
t!	Then, based on the usage function (units digit) the input
!	record describes, appropriate usage counters are updated to
<!	reflect the usage the record describes and charge accumulators
!	are updated to include the adjusted charge for that usage.
!
h!   CALLING SEQUENCE:
!
0!	CALL ADD_AMOUNTS
!
!   INPUT PARAMETERS: None.
\!
!   OUTPUT PARAMETERS: None.
$!
!   IMPLICIT INPUTS:
!
P!	/CHARGE_RECORD/	contains the current input record.  Most of the
!			fields in the record are used as input by some
!			part of this routine.  See the main program
|!			for a full description of the contents of the
!			input record.
D!
!	/CHARGE_COSTS/	contains amounts charged for all billable types
!			of usage and adjustment factors for acquisition
p!			and batch-queue usage.  Charge amounts are of
!			the form AMT_?????? (where ??????? is the same
8!			as in the corresponding ITOT_).  Adjustment
!			factors are ADJM_ACQ and ADJM_QUEUE(n).
 !
d!	/CHARGE_CQNAME/	contains the queue names associated with
!			ADJM_QUEUE(n) in ADJ_NAME_QUEUE(n).
,!
!	/CHARGE_MTYPE/	contains the tens and units digits of the
!			message type in the current input record,
X!			ITYPE_TENS and ITYPE_UNITS, respectively.
!
 !   IMPLICIT OUTPUTS:
!
!	/CHARGE_TALLY/	is the common block a usage- and charge-
L!			accumulators.  This routine updates the
!			accumulators for the current type, ITOT_?????
!			and CHARGE_??????.  ?????? is any one of:
x!			CONNECT	  connect time.
!			BY	  systems personal time.
@!			CPUTIME	  CPU time.
!			BYTIOCNT  byte I/O's (unit record I/O's).
 !			DRTIOCNT  direct I/O's (mass storage I/O's).
l !			VOLUMES   volume mounts.
 !			PAGEFLTS  page faults.
4!!			PRTPAGCT  number of printed pages.
!!			PRTLINCT  number of printed lines.
!!			PRTRDCT   number of reads during print.
`"!			For login failures /CHARGE_TALLY/LOGFAILS is
"!			updated.  For system reboots /CHARGE_TALLY/
(#!			ITOTAL_DOWN is update.
#!
#!	/CHARGE_DATA_SV/ contains specially computed charge information
T$!			passed to PRINT_AMOUNTS by ADD_AMOUNTS.  This
$!			information includes, when appropriate, the
%!			queue adjustment factor, CADJ_QUEUE; the rate
%!			charged for the current systems person,
%!			SYSP_RATE; and the current systems person
H&!			charge, SYSP_CHARGE.
&!
'!   COMPLETION STATUS: Normal return.
t'!
'!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
<(!
(!--
)
h)	INCLUDE 'BILLING:BILLDEF.FOR/NOLIST' ! Listed in main program
)	COMMON /CHARGE_RECORD/ BILL_RECORD
0*	INTEGER*2 BY_UIC(2), BY_GRP, BY_MEM
*	EQUIVALENCE (BY_UIC, BILL_L_INTB_UIC)
*	EQUIVALENCE (BY_UIC(1), BY_MEM), (BY_UIC(2), BY_GRP)
\+	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST' ! Listed in RESET_TOTALS
+
$,	COMMON /CHARGE_COSTS/
,	1	AMT_CONNECT,  AMT_CPUTIME,  AMT_BYTIOCNT,
,	2	AMT_DRTIOCNT, AMT_VOLUMES,  AMT_PAGEFLTS,
P-	3	AMT_PRTPAGCT, AMT_PRTLINCT, AMT_PRTRDCT,
-	4	AMT_BY( "17:"20, 0:"47),
.	5	ADJM_ACQ, ADJM_QUEUE(5)
|.
.	CHARACTER*16 ADJM_NAME_QUEUE(5)
D/	COMMON /CHARGE_CQNAME/ ADJM_NAME_QUEUE
/
0	INTEGER*2 ITYPE_UNITS, ITYPE_TENS
p0	COMMON /CHARGE_MTYPE/ ITYPE_TENS, ITYPE_UNITS
0
81	COMMON /CHARGE_DATA_SV/ CADJ_QUEUE, SYSP_RATE, SYSP_CHARGE

d !	Login failures
 	IF (BILL_W_MSGTYP .EQ. -1) THEN
,	    LOGFAILS = LOGFAILS + 1
	    RETURN
	ENDIF
X
!	System reboots
 	IF (BILL_W_MSGTYP .EQ. -2) THEN
	    IF (BILL_Q_DOWNTIME(2) .LT. 0)
	1	CALL ADDQUAD (BILL_Q_DOWNTIME,ITOTAL_DOWN,ITOTAL_DOWN)
L	    RETURN
	ENDIF

x!	Construct adjustment factor.
	ADJUSTMENT = 1.0
@	IF (ITYPE_TENS .EQ. 6)  ADJUSTMENT = ADJM_ACQ
	IF ( ITYPE_UNITS .EQ. 2 )  THEN
	    CADJ_QUEUE = 1.0
l	    DO 5 I = 1, 5
		IF ( BILL_T_JOB_QUE .EQ. ADJM_NAME_QUEUE(I) )  THEN
4		    CADJ_QUEUE = ADJM_QUEUE(I)
		    ADJUSTMENT = 1.0 - ( (1.0 - ADJUSTMENT) +
	1			(1.0 - CADJ_QUEUE) )
`			    GO TO 6
			ENDIF
(
5	    CONTINUE

6	    CONTINUE

	ENDIF
T
!	Non-print charges.
	IF (ITYPE_UNITS .NE. 4) THEN
	    ITOT_BYTIOCNT = ITOT_BYTIOCNT + BILL_L_BIOCNT
	    CHARGE_BYTIOCNT = CHARGE_BYTIOCNT +
H
	1		(BILL_L_BIOCNT * AMT_BYTIOCNT * ADJUSTMENT)

	    ITOT_DRTIOCNT = ITOT_DRTIOCNT + BILL_L_DIOCNT
	    CHARGE_DRTIOCNT = CHARGE_DRTIOCNT +
t	1		(BILL_L_DIOCNT * AMT_DRTIOCNT * ADJUSTMENT)
	    ITOT_VOLUMES = ITOT_VOLUMES + BILL_L_VOLUMES
<	    CHARGE_VOLUMES = CHARGE_VOLUMES +
	1		(BILL_L_VOLUMES * AMT_VOLUMES * ADJUSTMENT)
	    ITOT_PAGEFLTS = ITOT_PAGEFLTS + BILL_L_PAGEFLTS
h	    CHARGE_PAGEFLTS = CHARGE_PAGEFLTS +
	1		(BILL_L_PAGEFLTS * AMT_PAGEFLTS * ADJUSTMENT)
0	    ITOT_CPUTIME = ITOT_CPUTIME + (BILL_F_CPUTIM + .005) * 100
	    CHARGE_CPUTIME = CHARGE_CPUTIME +
	1		(BILL_F_CPUTIM * AMT_CPUTIME * ADJUSTMENT)
\
	    ! Interactive jobs
$	    IF (ITYPE_UNITS .EQ. 3)  THEN
		CALL ADDQUAD( BILL_Q_CONNECT,
	1			ITOT_CONNECT, ITOT_CONNECT )
P		CALL EDIV( BILL_Q_CONNECT, 100000, MSEC)
		HOURS = MSEC / -360000.0
		CHARGE_CONNECT = CHARGE_CONNECT +
|	1			(HOURS * AMT_CONNECT * ADJUSTMENT)
		! Systems personnel interactive jobs.
D		IF (ITYPE_TENS .EQ. 2)  THEN
		    CALL ADDQUAD( BILL_Q_CONNECT, ITOT_BY, ITOT_BY )
		    SYSP_RATE = AMT_BY(BY_GRP, BY_MEM) * ADJUSTMENT
p		    SYSP_CHARGE = HOURS * SYSP_RATE
		    CHARGE_BY = CHARGE_BY + SYSP_CHARGE
8		ENDIF
	    ENDIF
 
d!	Print jobs
	ELSE
,	    ITOT_PRTPAGCT = ITOT_PRTPAGCT + BILL_L_PAGCNT
	    CHARGE_PRTPAGCT = CHARGE_PRTPAGCT +
	1		(BILL_L_PAGCNT * AMT_PRTPAGCT * ADJUSTMENT)
X	    ITOT_PRTLINCT = ITOT_PRTLINCT + BILL_L_QIOCNT
	    CHARGE_PRTLINCT = CHARGE_PRTLINCT +
 	1		(BILL_L_QIOCNT * AMT_PRTLINCT * ADJUSTMENT)
	    ITOT_PRTRDCT = ITOT_PRTRDCT + BILL_L_GETCNT
	    CHARGE_PRTRDCT = CHARGE_PRTRDCT +
L	1		(BILL_L_GETCNT * AMT_PRTRDCT * ADJUSTMENT)

	ENDIF
x
	RETURN
@	END

d 	SUBROUTINE PRINT_HEADING
 
,!++
!
!   TITLE: PRINT_HEADING	Prints heading appropriate for message
X!				type.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	Forms and prints the heading appropriate for the value of
!	BILL_W_MSGTYP.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!
4!	Ralph Weber (20-OCT-1980) Cleanup documentation.  Setup new
!			charge amounts common.
!
`	!--
	!++
(
!

!   FUNCTIONAL DESCRIPTION:

!	This routine produces two sections of heading information each
T!	based on the message type of the current input record,
!	BILL_W_MSGTYP.
!
!	The first section describes the type of work performed (batch,
!	interactive, print, acquisition, etc.); the machine on which
H
!	it was performed; the owner, username, and UIC under which the

!	work was performed; any systems personnel interaction with the
!	work performed; the account number and name to which the work
t!	is being charged.  The first section consists of from two to
!	three lines followed by a blank line.
<!
!	The second section is column headings for the columns produced
!	by the individual job entries which will follow (see
h!	PRINT_AMOUNTS).  The column headings describe the item, units
!	of the item, and amount charged for the item shown in the
0!	column which they head.
!
!   CALLING SEQUENCE:
\!
!	CALL PRINT_HEADING
$!
!   INPUT PARAMETERS: None.
!
P!   OUTPUT PARAMETERS: None.
!
!   IMPLICIT INPUTS:
|!
!	/CHARGE_RECORD/	contains the current input record.  Information
D!			describing the who, what, and where for the
!			current charge item is taken from the input
!			record and printed.  All items in this record
p!			have names of the form BILL_?_nnnnnn.  The
!			current message type, BILL_W_MSGTYP, is used
8!			to determine what headings to print.  See
!			the main program for a full description of the
 !			contents of the input record.
d!
!	/CHARGE_COSTS/	contains amounts charged for all billable types
,!			of usage and adjustment factors for acquisition
!			and batch-queue usage.  Charge amounts are of
!			the form AMT_?????? (where ??????? is one of
X!			the following).
!			CONNECT	  connect time.
 !			CPUTIME	  CPU time.
!			BYTIOCNT  byte I/O's (unit record I/O's).
!			DRTIOCNT  direct I/O's (mass storage I/O's).
L!			VOLUMES   volume mounts.
!			PAGEFLTS  page faults.
!			PRTPAGCT  number of printed pages.
x!			PRTLINCT  number of printed lines.
!			PRTRDCT   number of reads during print.
@!			Acquisition adjustment factor is ADJM_ACQ.
!
 !	/CHARGE_MTYPE/	contains the tens and units digits of the
l !			message type in the current input record,
 !			ITYPE_TENS and ITYPE_UNITS, respectively.
4!!
!!
!!   IMPLICIT OUTPUTS:
`"!
"!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
(#!			updated to reflect lines added to the print
#!			file by this routine.  It is used to keep track
#!			of the current position on a page and to make
T$!			decisions regarding when a new page should be
$!			started.
%!
%!   COMPLETION STATUS: Normal return.
%!
H&!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
&!
'!--
t'
'	INCLUDE 'BILLING:BILLDEF.FOR/NOLIST' ! Listed in main program
<(	COMMON /CHARGE_RECORD/ BILL_RECORD
(
)	COMMON /CHARGE_COSTS/
h)	1	AMT_CONNECT,  AMT_CPUTIME,  AMT_BYTIOCNT,
)	2	AMT_DRTIOCNT, AMT_VOLUMES,  AMT_PAGEFLTS,
0*	3	AMT_PRTPAGCT, AMT_PRTLINCT, AMT_PRTRDCT,
*	4	AMT_BY( "17:"20, 0:"47),
*	5	ADJM_ACQ, ADJM_QUEUE(5)
\+
+	COMMON /CHARGE_COUNTERS/ LINE_COUNT
$,
,	INTEGER*2 ITYPE_TENS, ITYPE_UNITS
,	COMMON /CHARGE_MTYPE/ ITYPE_TENS, ITYPE_UNITS
P-
-	INTEGER*4 UIC
.	INTEGER*2 UIC_W(2), UIC_GRP, UIC_MEM
|.	EQUIVALENCE (UIC,UIC_W), (UIC_W(1),UIC_MEM), (UIC_W(2),UIC_GRP)
.
D/	CHARACTER*20 OWNER
/	CHARACTER*60 FIRST_PART
0	CHARACTER*80 ACCOUNT_NAME
p0
0	CHARACTER*38 TYPE_NAMES(4)
81	DATA TYPE_NAMES /	'Non-interactive, non-batch',
1	1			'Batch',
 2	2			'Interactive',
d2	3			'Print' /

d !	No heading for login failures.
 	IF (BILL_W_MSGTYP.EQ.-1) RETURN
,
!	System reboot summary heading.
	IF (BILL_W_MSGTYP.EQ.-2) THEN
X	    CALL NEW_PAGE( 8 )
	    WRITE (9,9000)
 	1	    BILL_T_MACHCODE( 1 : LEN_STRING(BILL_T_MACHCODE) )
9000	    FORMAT (' SYSTEM REBOOT SUMMARY FOR 'A' VAX' //
	1	    8X'Crash   Time'17X'Boot Time'11X'Time System Down')
L	    LINE_COUNT=LINE_COUNT+3
	    RETURN
	ENDIF
x
!	Check for need new page.
@	CALL NEW_PAGE( 14 )

!	Form and print first line of heading.
l	FIRST_PART = TYPE_NAMES( ITYPE_UNITS )
	IF (ITYPE_TENS .EQ. 6) THEN
4	    FIRST_PART = 'Acquisition ' // FIRST_PART
	ENDIF
	IF (ITYPE_TENS .NE. 2) THEN
`		    WRITE (9,9100)
		1	    FIRST_PART( : LEN_STRING( FIRST_PART )),
(
	2	    BILL_T_MACHCODE( : LEN_STRING( BILL_T_MACHCODE )),

	3	    BILL_T_OWNER( : LEN_STRING( BILL_T_OWNER)),

	4	    BILL_T_USERNAME( : LEN_STRING( BILL_T_USERNAME)),
T	5	    BILL_W_GRP, BILL_W_MEM
9100	    FORMAT (X, A ' jobs run on ' A ' by ' A
	1	    ' (USERNAME: ' A ', UIC: [' O3 ',' O3 '])' )
	ELSE
	    WRITE (9,9200)
H
	1	    FIRST_PART( : LEN_STRING( FIRST_PART )),

	2	    BILL_T_MACHCODE( : LEN_STRING( BILL_T_MACHCODE )),
	3	    BILL_T_OWNER( : LEN_STRING( BILL_T_OWNER)),
t	4	    BILL_T_USERNAME( : LEN_STRING( BILL_T_USERNAME)),
	5	    BILL_W_GRP, BILL_W_MEM
<9200	    FORMAT (X, A ' jobs run on ' A ' for ' A
	1	    ' (USERNAME: ' A ', UIC: [' O3 ',' O3 '])',
	2	    ' By Systems Personnel' )
h	ENDIF
	LINE_COUNT=LINE_COUNT+1
0
!	If now printing a system person's record of work he/she did
!	for others, print a line indicating who work was done for.
\	IF (ITYPE_TENS .EQ. 4)  THEN
	    ! Get owner and UIC work done for.
$	    IF (ITYPE_UNITS .EQ. 1) THEN
		OWNER=BILL_T_NINT_FOR
	  	UIC=BILL_L_NINF_UIC
P	    ELSEIF (ITYPE_UNITS .EQ. 2) THEN
		OWNER=BILL_T_BCH_FOR
		UIC=BILL_L_BCHF_UIC
|	    ELSEIF (ITYPE_UNITS .EQ. 3) THEN
		OWNER=BILL_T_INT_FOR
D	 	UIC=BILL_L_INTF_UIC
	    ELSEIF (ITYPE_UNITS .EQ. 4) THEN
		OWNER=BILL_T_PRT_FOR
p		UIC=BILL_L_PRTF_UIC
	    ENDIF
8	    WRITE (9,9300) 
	1	    OWNER( : LEN_STRING( OWNER )), UIC_GRP, UIC_MEM
 9300	    FORMAT ( ' For ' A ' (UIC: [' O3 ',' O3'])' )
d	    LINE_COUNT=LINE_COUNT+1
	ENDIF
,
!	Print account billed line.
	CALL GET_ACC_NAME( BILL_T_ACCOUNT, ACCOUNT_NAME )
X	WRITE (9,9400) BILL_T_ACCOUNT( : LEN_STRING( BILL_T_ACCOUNT )),
	1	ACCOUNT_NAME
 9400	FORMAT ( ' Charged to ' A ', ' A )
	LINE_COUNT=LINE_COUNT+1

L!	If acquisition work print acquisition adjustment factor.
	IF (ITYPE_TENS .EQ. 6)  THEN
	    WRITE (9,9450) ADJM_ACQ*100.
x9450	    FORMAT ( ' Acquisition adjustment factor ' F5.1 '%' )
	    LINE_COUNT=LINE_COUNT+1
@	ENDIF

 !	Add blank line.
l 	WRITE (9,9460)
 9460	FORMAT ( ' ' )
4!	LINE_COUNT=LINE_COUNT+1
!
!!	Print column headings appropriate to item lists
`"!	which will follow.
"	IF (ITYPE_UNITS .EQ. 1)  THEN   !Non-interactive, non-batch
(#	    WRITE (9,9500)	AMT_CPUTIME,  AMT_BYTIOCNT,
#	1			AMT_DRTIOCNT, AMT_VOLUMES,
#	2			AMT_PAGEFLTS
T$9500	    FORMAT (9X'Time Run'12X'CPU Time'7X'Byte I/O'6X'Direct I/O'
$	1	    5X'Mounts'5X'Page Faults'4X'Page'3X'Working' /
%	2	    27X'($'F5.3'/Sec)  ($'F7.5' ea)  ($'F7.5' ea)  ',
%	3	    '($'F4.2' ea)  ($'F7.5' ea)   File     Set' )
%	ELSEIF (ITYPE_UNITS .EQ. 2)  THEN   !Batch
H&	    WRITE (9,9600)	AMT_CPUTIME,  AMT_BYTIOCNT,
&	1			AMT_DRTIOCNT, AMT_VOLUMES,
'	2			AMT_PAGEFLTS
t'9600	    FORMAT (2X'Run Time (Name & Queue)'5X'CPU Time'7X'Byte I/O'
'	1	    6X'Direct I/O'5X'Mounts'5X'Page Faults'4X'Page'3X
<(	2	    'Working' /
(	3	    27X'($'F5.3'/Sec)  ($'F7.5' ea)  ($'F7.5' ea)  ',
)	4	    '($'F4.2' ea)  ($'F7.5' ea)   File     Set' )
h)	ELSEIF (ITYPE_UNITS .EQ. 3)  THEN   !Interactive
)	    IF (ITYPE_TENS .NE. 2)  THEN   !"Normal" interactive
0*		WRITE (9,9700) 	AMT_CONNECT,  AMT_CPUTIME,
*	1			AMT_BYTIOCNT, AMT_DRTIOCNT,
*	2			AMT_VOLUMES,  AMT_PAGEFLTS
\+9700 		FORMAT (9X'Time Run'13X'Connect Time'5X'CPU Time'7X
+	1		'Byte I/O'6X'Direct I/O'5X'Mounts'5X
$,	2		'Page Faults'4X'Page  Working' /
,	3		29X'($'F5.2'/Hour)   ($'F5.3'/Sec)  ',
,	4		'($'F7.5' ea)  ($'F7.5' ea)  ($'F4.2' ea)  ',
P-	5		'($'F7.5' ea)   File    Set' )
-	    ELSE			 !Systems personnel interactive
.		WRITE (9,9900) 	AMT_CONNECT,  AMT_CPUTIME,
|.	1			AMT_BYTIOCNT, AMT_DRTIOCNT,
.	2			AMT_VOLUMES,  AMT_PAGEFLTS
D/9900		FORMAT (7X'Time Run'15X'Connect Time'5X'CPU Time'7X
/	1		'Byte I/O'6X'Direct I/O'5X'Mounts'5X
0	2		'Page Faults'4X'Page  Working' /
p0	3		' (charge,charge-rate & name) ($'F5.2'/Hour)',
0	4		'   ($'F5.3'/Sec)  ($'F7.5' ea)  ($'F7.5' ea)',
81	5		'  ($'F4.2' ea)  ($'F7.5' ea)   File    Set' )
1	    ENDIF
 2	ELSEIF (ITYPE_UNITS .EQ. 4)  THEN   !Print
d2	    WRITE (9,9800)  AMT_PRTPAGCT, AMT_PRTLINCT, AMT_PRTRDCT
29800	    FORMAT (' Name'11X'Queue'13X'Time Printed'12X'Pages'9X
,3	1	    'Lines'10X'Reads' /
3	2	    55X'($'F5.3' ea)  ($'F7.5' ea)  ($'F7.5' ea)' )
3	ENDIF
X4	LINE_COUNT=LINE_COUNT+2
4
 5	RETURN
5
5	END

d 	SUBROUTINE PRINT_AMOUNTS
 
,!++
!
!   TITLE: PRINT_AMOUNTS	Prints useage amounts lines.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Prints one or two lines describing usage given by current
!	input record.
!
x!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
@!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
!   MODIFIED BY:
l!	Ralph Weber (21-OCT-1980) Improve documentation and code
!		readability.  Add code for printing queue adjustment
4!		factors.
!
!--
`	!++
	!
(
!   FUNCTIONAL DESCRIPTION:

!

!	This routine prints one or two lines giving usage amounts for
T!	all billable services, other numbers of interest, and informa-
!	tion to help identify the time, etc. when the usage occured.
!	Specific charge rates and adjustment factors are also printed
!	when such information is not included in the column headings.
!	The message type of the current input record is used to
H
!	determine exactly what is printed.

!
!   CALLING SEQUENCE:
t!
!	CALL PRINT_AMOUNTS
<!
!   INPUT PARAMETERS: None.
!
h!   OUTPUT PARAMETERS: None.
!
0!   IMPLICIT INPUTS:
!
!	/CHARGE_RECORD/	contains the current input record.  Most of the
\!			fields in the record are used as input by some
!			part of this routine.  See the main program
$!			for a full description of the contents of the
!			input record.
!
P!	/CHARGE_DATA_SV/ contains specially computed charge information
!			passed to PRINT_AMOUNTS by ADD_AMOUNTS.  This
!			information includes, when appropriate, the
|!			queue adjustment factor, CADJ_QUEUE; the rate
!			charged for the current systems person,
D!			SYSP_RATE; and the current systems person
!			charge, SYSP_CHARGE.
!
p!	/CHARGE_MTYPE/	contains the tens and units digits of the
!			message type in the current input record,
8!			ITYPE_TENS and ITYPE_UNITS, respectively.
!
 !   IMPLICIT OUTPUTS:
d!
!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
,!			updated to reflect lines added to the print
!			file by this routine.  It is used to keep track
!			of the current position on a page and to make
X!			decisions regarding when a new page should be
!			started.
 !
!   COMPLETION STATUS: Normal return.
!
L!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
!
!--
x
	INCLUDE 'BILLING:BILLDEF.FOR/NOLIST' ! Listed in main program
@	COMMON /CHARGE_RECORD/ BILL_RECORD

 	COMMON /CHARGE_DATA_SV/ CADJ_QUEUE, SYSP_RATE, SYSP_CHARGE
l 
 	INTEGER*2 ITYPE_TENS, ITYPE_UNITS
4!	COMMON /CHARGE_MTYPE/ ITYPE_TENS, ITYPE_UNITS
!
!	COMMON /CHARGE_COUNTERS/ LINE_COUNT
`"
"	LOGICAL NEW_PAGE
(#
#	INTEGER*4 UP_TIME(2)
#
T$	CHARACTER*17 DELTA_TIME
$	CHARACTER*24 ABS_TIME_1, ABS_TIME_2

d !	Blank all time buffers.
 	ABS_TIME_1 = ' '
,	ABS_TIME_2 = ' '
	DELTA_TIME = ' '

X!	Convert basic (sorted) time for this input record.
	CALL MY_ASCTIM( ABS_TIME_1, BILL_Q_TERMTIME )
 
!	Check for new page needed.
!	NB. we always leave room for what this routine might
L!	print plus totals printed by PRINT_TYPE_TOT because
!	the type total lines should never be by themselves
!	at the top of a page.
x	IF ( NEW_PAGE( 8 ) )  THEN
	    WRITE (9,9900)
@9900	    FORMAT ( ' --- continuing ---' )
	    LINE_COUNT = LINE_COUNT + 1
	    CALL PRINT_HEADING
l	ENDIF

4!	Boot record
	IF (BILL_W_MSGTYP .EQ. -2) THEN
	    IF (BILL_Q_DOWNTIME(2) .LT. 0)  THEN
`			CALL SUBQUAD (BILL_Q_BOOTTIME,BILL_Q_DOWNTIME,UP_TIME)
			CALL MY_ASCTIM (ABS_TIME_2,UP_TIME)
(
		CALL MY_ASCTIM (DELTA_TIME,BILL_Q_DOWNTIME)

		WRITE (9,9000) ABS_TIME_1,ABS_TIME_2,DELTA_TIME

9000		FORMAT (X, A24, 4X, A24, 4X, A17)
T		LINE_COUNT=LINE_COUNT+1
	    ENDIF

!	Print useage amounts for non-interactive and batch job processes.
	ELSEIF (ITYPE_UNITS.EQ.1 .OR. ITYPE_UNITS.EQ.2) THEN
H

	    IF (ITYPE_UNITS.EQ.2) THEN
		!  Print job name, queue, and adjustment factor
t		! for batch jobs
		WRITE (9,9100)
<	1	     BILL_T_JOB_NAME( : LEN_STRING( BILL_T_JOB_NAME )),
	2	     BILL_T_JOB_QUE( : LEN_STRING( BILL_T_JOB_QUE )),
	3	     CADJ_QUEUE*100.0
h9100		FORMAT (X, A', 'A', 'F5.1'%' )
		LINE_COUNT=LINE_COUNT+1
0	    ENDIF
	    WRITE (9, 9200) ABS_TIME_1, BILL_F_CPUTIM, BILL_L_BIOCNT,
	1	    BILL_L_DIOCNT, BILL_L_VOLUMES, BILL_L_PAGEFLTS,
\	2	    BILL_L_PGFLPEAK, BILL_L_WSPEAK
9200	    FORMAT (X, A24, F13.2, 2I15, I10, I17, 2I8 )
$	    LINE_COUNT=LINE_COUNT+1

!	Print useage amounts for interactive processes
P	ELSEIF (ITYPE_UNITS.EQ.3) THEN
	    IF (ITYPE_TENS .EQ. 2) THEN
		! Print charge rate and charge for connect time
|		! for work done by system personnel.
		WRITE (9,9500) SYSP_CHARGE, SYSP_RATE,
D	1	    BILL_T_INT_BY( : LEN_STRING( BILL_T_INT_BY ))
9500		FORMAT ( / ' $'F6.2', $'F5.2'/Hour, 'A )
		LINE_COUNT=LINE_COUNT+2
p	    ENDIF
	    CALL MY_ASCTIM (DELTA_TIME,BILL_Q_CONNECT)
8	    WRITE (9, 9300) ABS_TIME_1, DELTA_TIME, BILL_F_CPUTIM,
	1	    BILL_L_BIOCNT, BILL_L_DIOCNT, BILL_L_VOLUMES,
 	2	    BILL_L_PAGEFLTS, BILL_L_PGFLPEAK, BILL_L_WSPEAK
d9300	    FORMAT (X, A24, 1X, A17, F13.2, 2I15, I10, I17, I8, I7)
	    LINE_COUNT=LINE_COUNT+1
,
!	Print useage amounts for print jobs.
	ELSEIF (ITYPE_UNITS.EQ.4) THEN
X	    WRITE (9, 9400) BILL_T_PRT_NAME, BILL_T_PRT_QUE,
	1	    ABS_TIME_1, BILL_L_PAGCNT, BILL_L_QIOCNT,
 	2	    BILL_L_GETCNT
9400	    FORMAT (X, A8, 2X, A16, 1X, A24, I13, 2I15)
	    LINE_COUNT=LINE_COUNT+1
L
	ENDIF

x	RETURN

@	END

d 	SUBROUTINE PRINT_TYPE_TOT( LAST_TYPE, LAST_MACHINE )
 
,!++
!
!   TITLE: PRINT_TYPE_TOT	Prints the totals for just completed
X!				message type.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!	
!	Usage and charges for that usage are printed for the message
!	type most recently completed.  Printed lines appear to be
x!	sums of columns of items printed by PRINT_AMOUNTS.
!
@!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
l!
!   MODIFIED BY:
4!	Ralph Weber (22-OCT-1980) Non-print functions removed.
!		Documentation cleaned up.
!
`	!--
	!++
(
!

!   FUNCTIONAL DESCRIPTION:

!
T!	Values from ITOT_?????? and CHARGE_?????? are printed as
!	column sums of the columns who's headings were printed by
!	PRINT_HEADINGS and who's entries were printed by
!	PRINT_AMOUNTS.  (See implicit inputs /CHARGE_TALLY/ for
!	a description of (ITOT_?????? and CHARGE_??????.)  If
H
!	charges for work done by systems personnel exist their

!	total is printed on a seperate line.
!
t!	For login failure records, a line giving the total login
!	failures is print: this is the only line printed for
<!	login failures.
!
!	For system reboots, a summary of the total down time is
h!	printed as a the sum of the down time column printed
!	by PRINT_AMOUNTS.
0!
!   CALLING SEQUENCE:
!
\!	CALL PRINT_TYPE_TOT( LAST_TYPE.rw.r, LAST_MACHINE.rt.ds )
!
$!   INPUT PARAMETERS:
!
!
P!	LAST_TYPE.rw.r	is the value of the message type last
!			processed.  It is used to determine what
!			to print.
|!
!	LAST_MACHINE.rt.ds is the node name of the machine last
D!			processed.  It is printed with the login
!			failure total.
!
p!   OUTPUT PARAMETERS: None.
!
8!   IMPLICIT INPUTS:
!
 !	/CHARGE_TALLY/	contains the usage and charges totals which
d!			this routine prints.  For regular usage, there
!			are two groups of totals, ITOT_?????? and
,!			CHARGE_?????? for usage totals and total
!			charges respectively.  ?????? is one of:
!			CONNECT	  connect time.
X!			BY	  systems personal time.
!			CPUTIME	  CPU time.
 !			BYTIOCNT  byte I/O's (unit record I/O's).
!			DRTIOCNT  direct I/O's (mass storage I/O's).
!			VOLUMES   volume mounts.
L!			PAGEFLTS  page faults.
!			PRTPAGCT  number of printed pages.
!			PRTLINCT  number of printed lines.
x!			PRTRDCT   number of reads during print.
!			Also included in /CHARGE_TALLY/ are:
@!			LOGFAILS	a counter for the number of
!					login failures.
 !			ITOTAL_DOWN	a quadword counter for system
l !					down time.
 !
4!!   IMPLICIT OUTPUTS:
!!
!!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
`"!			updated to reflect lines added to the print
"!			file by this routine.  It is used to keep track
(#!			of the current position on a page and to make
#!			decisions regarding when a new page should be
#!			started.
T$!
$!   COMPLETION STATUS: Normal return.
%!
%!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
%!
H&!--
&
'	INTEGER*2 LAST_TYPE
t'	CHARACTER*(*) LAST_MACHINE
'
<(	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
(
)	COMMON /CHARGE_COUNTERS/ LINE_COUNT
h)
)	INTEGER*2 LTYPE_TENS, LTYPE_UNITS
0*	CHARACTER*17 DELTA_TIME

d !	Break last type into tens and units parts.
 	LTYPE_TENS = LAST_TYPE / 10
,	LTYPE_UNITS = LAST_TYPE - (LTYPE_TENS * 10)

!	NB. PRINT_AMOUNTS has insured that there is enough room on
X!	the current print page for whatever this routine will print.
!	Therefore: this routine need not check that.
 
!	Login failures
	IF (LAST_TYPE .EQ. -1) THEN
L	    WRITE (9,9300) LOGFAILS,
	1	    LAST_MACHINE( : LEN_STRING( LAST_MACHINE ))
9300	    FORMAT ( /// ' There were'I10' login failures on the 'A
x	1	    ' VAX.' )
	    LINE_COUNT=LINE_COUNT+3
@
!	Downtime totals
	ELSEIF (LAST_TYPE .EQ. -2) THEN
l	    DELTA_TIME = ' '
	    CALL MY_ASCTIM( DELTA_TIME, ITOTAL_DOWN )
4	    WRITE (9,9400) DELTA_TIME
9400	    FORMAT ( 56X,17('_') / 49X,'Total:  'A )
	    LINE_COUNT=LINE_COUNT+2
`	
	!	Non-interactive and batch jobs
(
	ELSEIF (LTYPE_UNITS.EQ.1 .OR. LTYPE_UNITS.EQ.2)  THEN

	      WRITE (9,9000)	FLOAT( ITOT_CPUTIME ) / 100.0,

	1			ITOT_BYTIOCNT,   ITOT_DRTIOCNT,  
T	2			ITOT_VOLUMES,    ITOT_PAGEFLTS,  
	3			CHARGE_CPUTIME,  CHARGE_BYTIOCNT,
	4			CHARGE_DRTIOCNT, CHARGE_VOLUMES,
	5			CHARGE_PAGEFLTS
9000	    FORMAT ( '+'26X 12('_') 2(2X,13('_')) 4X,6('_') 4X,13('_') /
H
	1	    '0'11X'Total Useage:' F13.2, 2I15, I10, I17 /

	2	    12X'Total Charges:  $'F9.2'     $'F9.2'     $'F9.2
	3	    '   $'F6.2'       $'F9.2 // )
t	    LINE_COUNT=LINE_COUNT+5

<!	Interactive jobs
	ELSEIF (LTYPE_UNITS .EQ. 3)  THEN
	    DELTA_TIME = ' '
h	    CALL MY_ASCTIM( DELTA_TIME, ITOT_CONNECT )
	    WRITE (9,9100)	DELTA_TIME,
0	1			FLOAT( ITOT_CPUTIME ) / 100.0,
	2			ITOT_BYTIOCNT,   ITOT_DRTIOCNT,  
	3			ITOT_VOLUMES,    ITOT_PAGEFLTS,  
\	4			CHARGE_CONNECT,  CHARGE_CPUTIME,
	5			CHARGE_BYTIOCNT, CHARGE_DRTIOCNT,  
$	6			CHARGE_VOLUMES,  CHARGE_PAGEFLTS  
9100	    FORMAT ('+'24X 17('_') 2X,12('_') 2(2X,13('_')) 4X,6('_')
	1	    4X,13('_') /
P	2	    '0'11X 'Total Useage: 'A17, F13.2, 2I15, I10, I17 /
	3	    12X 'Total Charges:'5X'$'F10.2'    $'F9.2'    $'
	4	    F10.2'    $'F10.2'    $'F5.2'     $'F11.2 )
|	    LINE_COUNT=LINE_COUNT+3
	    IF (LTYPE_TENS .EQ. 2) THEN
D		! Interactive jobs with work by systems personnel
		WRITE (9,9700) CHARGE_BY
9700		FORMAT ( / 12X
p	1	   'Total charge for work done by systems personnel:  $'
	2	   F10.2 )
8		LINE_COUNT=LINE_COUNT+2
	    ENDIF
 	    ! Insert blank lines after totals.
d	    WRITE (9,9101)
9101	    FORMAT ('0')
,	    LINE_COUNT = LINE_COUNT + 2

!	Print jobs
X	ELSEIF (LTYPE_UNITS .EQ. 4) THEN
	    WRITE (9,9500)	ITOT_PRTPAGCT,   ITOT_PRTLINCT,
 	1			ITOT_PRTRDCT,    CHARGE_PRTPAGCT,
	2			CHARGE_PRTLINCT, CHARGE_PRTRDCT
9500	    FORMAT ( '+'52X 12('_') 2(2X,13('_')) /
L	1	    '0'11X'Total Useage:', T54, I12, 2I15 /
	2	    12X'Total Charges:'T56'$'F9.2'    $'F10.2
	3	    '    $'F10.2 // )
x	    LINE_COUNT=LINE_COUNT+5

@	ENDIF

 	RETURN
l 
 	END

d 	SUBROUTINE PRINT_MEM_TOT( LAST_GROUP, LAST_MEMBER,
 	1		LAST_ACCOUNT, LAST_USERNAME, LAST_OWNER )
,
!++
!
X!    TITLE: PRINT_MEM_TOT	Prints charges summary for member and
!				adds record to MEMACCT.SCR.
 !
!   FACILITY: BILLING SYSTEM
!
L!   ABSTRACT:	
!
!	Prints usage-charges summary for most recently processed
x!	unique member-account.  Writes record of those usages-charges
!	into MEMACCT.SCR for later processing.
@!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
l!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
4!   MODIFIED BY:
!	Ralph Weber (22-OCT-1980) Change information passing mechinism.
!		Switch to /CHARGE_TALLY/ for totals counters.  Change
`	!		to MEMACCT.SCR for scratch file.  Update documentation.
	!
(
!	Ralph Weber (25-OCT-1980) Setup to print accumulated FOR

!		usage.

!
T!--
!++
!
!   FUNCTIONAL DESCRIPTION:
!
H
!	After insuring sufficient space on the page to accomidate it,

!	this routine prints the contents of ITUIC_??????, KAUIC_??????,
!	CRGUIC_??????, ACGUIC_?????? in a member-account usage-charges
t!	summary.  Since these values are zeroed everytime a new member
!	or account is encountered, they represent the accumulated
<!	usage and charges for the last unique member-account processed.
!	The values and meanings of ?????? are described in the
!	discussion of implicit input /CHARGE_TALLY/.  If FOR usage
h!	has been accumulated, a similar summary is printed for the
!	FOR usage.  After the summaries are printed the paper output is
0!	always positioned at the top of a page.
!
!	The usage-charges information is also written into the scratch
\!	file MEMACCT.SCR.  Later, this file will be sorted by account
!	number and used to produce a charges summaries for each account
$!	billed as a result of work done by the current group.

!   CALLING SEQUENCE:
P!
!	CALL PRINT_MEM_TOT( LAST_GROUP.rw.r, LAST_MEMBER.rw.r,
!		LAST_ACCOUNT.rt.ds, LAST_USERNAME.rt.ds,
|!		LAST_OWNER.rt.ds )
!
D!   INPUT PARAMETERS:
!
!	LAST_GROUP.rw.r		is the group number of the last UIC
p!				processed.
!
8!	LAST_MEMBER.rw.r	is the member number of the last UIC
!				processed.
 !
d!	LAST_ACCOUNT.rt.ds	is the last account number processed.
!
,!	LAST_USERNAME.rt.ds	is the last USERNAME processed.
!
!	LAST_OWNER.rt.ds	is the owner of the last USERNAME
X!				processed.
!
 !   OUTPUT PARAMETERS: None.
!
!   IMPLICIT INPUTS:
L!
!	/CHARGE_TALLY/	contains the usage and charges totals arrays
!			group-account usage and charges sums.  The
x!			arrays are named as follows: ITUIC_ARRAY,
!			for non-acquisition usage; KAUIC_ARRAY, for
@!			acquisition usage; CRGUIC_ARRAY, for non-
!			acquisition charges; ACGUIC_ARRAY, for
 !			acquisition charges.
l !
 !	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
4!!			these parameters give the starting and ending
!!			subscripts of the access arrays in
!!			/CHARGE_TALLY/; TALLY_??? for the usage counters
`"!			and CHARGE_??? for the charges counters.
"!
(#!	/CHARGE_FOR/ -----------------------------------------------
#!	/CHARGE_FOR/ is to FOR accumulators as /CHARGE_TALLY/ is to
#!	all other accumulators.  However, it only needs non-
T$!	acquisition accumulators.
$!
%!	ITFOR_ARRAY	is the array of other charge counters for the
%!			current FOR work.
%!
H&!	CRGFOR_ARRAY	is the array of charges for the current FOR
&!			work.
'!
t'!	FOR_FLAG	is a flag used to indicate that FOR usage has
'!			been accumulated.
<(!
(!   IMPLICIT OUTPUTS:
)!
h)!	MEMACCT.SCR	A record containing all usage-charge information
)!			for this member-account combination is written
0*!			into this file.
*!
*!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
\+!			used to keep track of the current position on
+!			a page and to make decisions regarding when a
$,!			new page should be started.
,!
,!   COMPLETION STATUS: Normal return.
P-!
-!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
.!
|.!--
.
D/	INTEGER*2 LAST_GROUP, LAST_MEMBER
/	CHARACTER*(*) LAST_ACCOUNT, LAST_USERNAME, LAST_OWNER
0
p0	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
0
81	COMMON /CHARGE_FOR/  ITFOR_ARRAY ( TALLY_BEGIN : TALLY_END ),
1	1	CRGFOR_ARRAY(CHARGE_END)
 2
d2	LOGICAL*1 FOR_FLAG
2	COMMON / CHARGE_FOR / FOR_FLAG
,3
3	COMMON /CHARGE_COUNTERS/ LINE_COUNT
3
X4	LOGICAL NEW_PAGE
4
 5	CHARACTER*80 ACCOUNT_NAME
5
5	PARAMETER TALLY_SIZE = TALLY_END - TALLY_BEGIN + 1
L6	DIMENSION IZEROS( TALLY_SIZE )
6	DATA IZEROS / TALLY_SIZE * 0 /

d !	Position page to print member-account summary.
 	IF ( NEW_PAGE( 24 ) )  THEN
,	    WRITE (9,9000)
9000	    FORMAT ( X, 130('*') // )
	    LINE_COUNT = LINE_COUNT + 3
X	ELSE
	    WRITE (9,9001)
 9001	    FORMAT( // X, 130('*') // )
	    LINE_COUNT = LINE_COUNT + 5
	ENDIF
L
!	Print heading and member-account summary.
	CALL GET_ACC_NAME( LAST_ACCOUNT, ACCOUNT_NAME )
x	WRITE (9,9100)	LAST_OWNER( : LEN_STRING( LAST_OWNER )),
	1		LAST_USERNAME( : LEN_STRING( LAST_USERNAME )),
@	2		LAST_GROUP, LAST_MEMBER,
	3		LAST_ACCOUNT( : LEN_STRING( LAST_ACCOUNT )),
	4		ACCOUNT_NAME( : LEN_STRING( ACCOUNT_NAME ))
l9100	FORMAT (X, A ' (USERNAME: 'A', UIC: ['O3','O3'])',
	1	' Charges Summary' /
4	2	' charged to account 'A', 'A )
	LINE_COUNT = LINE_COUNT + 2
	CALL PRINT_TOTALS(	ITUIC_ARRAY,   KAUIC_ARRAY,
`		1			CRGUIC_ARRAY,  ACGUIC_ARRAY, 4  )
	
(
!	Has FOR work been done?

	IF ( FOR_FLAG )  THEN

	    FOR_FLAG = .FALSE.
T	    ! Position page to print FOR summary.
	    IF ( NEW_PAGE( 23 ) )  THEN
		WRITE (9,9002)
9002		FORMAT ( X, 130('+') // )
		LINE_COUNT = LINE_COUNT + 3
H
	    ELSE

		WRITE (9,9003)
9003		FORMAT( // X, 130('+') // )
t		LINE_COUNT = LINE_COUNT + 5
	    ENDIF
<	    ! Print heading and FOR summary.
	    WRITE (9,9200)	LAST_OWNER( : LEN_STRING( LAST_OWNER )),
	1		LAST_USERNAME( : LEN_STRING( LAST_USERNAME )),
h	2		LAST_GROUP, LAST_MEMBER
9200	    FORMAT ( ' Work done for other users by '
0	1	    A ' (USERNAME: 'A', UIC: ['O3','O3'])',
	2	    ' Charges Summary' )
	    LINE_COUNT = LINE_COUNT + 2
\	    CALL PRINT_TOTALS(	ITFOR_ARRAY,   IZEROS,
	1			CRGFOR_ARRAY,  IZEROS, 1  )
$	ENDIF

!	Force new page.
P	CALL NEW_PAGE( 999 )

!	Output a record to MEMACCT.SCR.
|	WRITE (8,8000) LAST_GROUP, LAST_ACCOUNT,
	1	( ITUIC_ARRAY(I), KAUIC_ARRAY(I), 
D	2		I = TALLY_BEGIN, TALLY_END ),
	3	( CRGUIC_ARRAY(I), ACGUIC_ARRAY(I),
	4		I = CHARGE_BEGIN, CHARGE_END )
p8000	FORMAT ( O3, A8, 47A4 )

8	RETURN

 	END

d 	SUBROUTINE PRINT_GRP_TOT
 
,!++
!
!   TITLE: PRINT_GRP_TOT	Prints summary for group by accounts.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Sorts MEMACCT.SCR by account.  Sums usages and charges in file
!	for each unique account and prints sums in summary format.
!	Outputs a record containing summed values into GRPSUMRY.SCR.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!	Ralph Weber (23-OCT-1980) Setup changed MEMACCT.SCR and
4!		GRPSUMRY.SCR record formats, /CHARGE_TALLY/, and
!		printed summary formats.  Reorder code to make it
!		more readable.  Cleanup documentation.
`	!
	!--
(
!++

!

!   FUNCTIONAL DESCRIPTION:
T!
!	After determining that MEMACCT.SCR is not empty, this routine
!	sorts that file by account number.  The sorted file is then
!	read.  So long as the account number portion of the records
!	match, the usage and charges values of the records are summed.
H
!	When a new account number is encountered, the summed values

!	are printed in group summary format and a record containing
!	the sums in written into GRPSUMRY.SCR (a file of usage and
t!	charge sums for each unique group-account combination).
!	The newly read usage and charge values are used to start a new
<!	sum.  When the end of the input file is reached, the last
!	summary is printed, a new printed page is forced, the last
!	GRPSUMRY.SCR record is output, the MEMACCT.SCR file is closed,
h!	and both the sorted and un-sorted MEMACCT.SCR files are deleted.
!
0!   CALLING SEQUENCE:
!
!	CALL PRINT_GRP_TOT
\!
!   INPUT PARAMETERS: None.
$!
!   OUTPUT PARAMETERS: None.
!
P!   IMPLICIT INPUTS:
!
!	MEMACCT.SCR	is the scratch file which contains a record for
|!			each unique member-account in a group.  The
!			file is closed and deleted everytime a new
D!			UIC group is encountered, thus limiting it's
!			contents to one group.  This routine sorts the
!			file by account and uses the sorted file as
p!			input.
!
8!	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
!			these parameters give the starting and ending
 !			subscripts of the access arrays in
d!			/CHARGE_TALLY/; TALLY_??? for the usage counters
!			and CHARGE_??? for the charges counters.  These
,!			values are used to dimension local arrays for
!			reading the usage and charge information from
!			MEMACCT.SCR and for manipulating usage and
X!			charge arrays.
!
 !   IMPLICIT OUTPUTS:
!
!	GRPSUMRY.SCR	is the scratch file into which records
L!			containing usage and charges totals for each
!			unique account-group pair are written. 
!
x!	/CHARGE_TALLY/	contains the usage and charges totals arrays
!			which this routine uses to sum group-account
@!			usage and charges.  This use erases the
!			previous contents of the arrays, but since
 !			they must be zeroed before the next group
l !			is processed, this is not a problem.  The
 !			arrays are named as follows: ITUIC_ARRAY,
4!!			for non-acquisition usage; KAUIC_ARRAY, for
!!			acquisition usage; CRGUIC_ARRAY, for non-
!!			acquisition charges; ACGUIC_ARRAY, for
`"!			acquisition charges.
"!
(#!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
#!			used to keep track of the current position on
#!			a page and to make decisions regarding when a
T$!			new page should be started.
$!
%!   COMPLETION STATUS: Normal return.
%!
%!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
H&!
&!--
'
t'	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
'
<(	COMMON /CHARGE_COUNTERS/ LINE_COUNT
(
)	CHARACTER*8 ACCOUNT, PREV_ACCOUNT
h)
)	INTEGER*2 GRP_UIC
0*
*	LOGICAL*1 FIRST_RECORD
*
\+	INTEGER*4 ITOT( TALLY_BEGIN : TALLY_END ),
+	1	 KATOT( TALLY_BEGIN : TALLY_END ),
$,	2	 IT_CONNECT(2), IT_BY(2), KA_CONNECT(2), KA_BY(2)
,	EQUIVALENCE ( ITOT( TALLY_BEGIN ), IT_CONNECT ),
,	1	  ( ITOT( TALLY_BEGIN+2 ), IT_BY ),
P-	2	 (   KATOT( TALLY_BEGIN ), KA_CONNECT ),
-	3	 ( KATOT( TALLY_BEGIN+2 ), KA_BY )
.	REAL*4 CRG( CHARGE_END ),  ACRG( CHARGE_END )
|.
.	INTEGER*2 MEMACCT_SRT_KEY(5)
D/	DATA MEMACCT_SRT_KEY/ 1,	! Number of keys
/	1				! (position,size,type,a/d)
0	1	1, 0, 4, 8 /		! ACCOUNT (4,8,char,a)

d !	Check for empty MEMACCT.SCR.
 !	If file not empty, sort it.
,	REWIND 8
	READ ( 8, 8000, END=995 ) GRP_UIC, ACCOUNT,
	1	( ITOT(I), KATOT(I), I = TALLY_BEGIN, TALLY_END ),
X	2	( CRG(I), ACRG(I), I = CHARGE_BEGIN, CHARGE_END )
8000	FORMAT ( O3, A8, 47A4 )
 	CLOSE ( UNIT=8 )
	CALL SORT_FILE( 'MEMACCT.SCR', 'MEMACCT.SCR', MEMACCT_SRT_KEY )

L!	Prepair to read sorted file.
	OPEN ( UNIT=11, NAME='MEMACCT.SCR', TYPE='OLD' )
	FIRST_RECORD = .TRUE.
x	PREV_ACCOUNT = '%%%%%%%%'

@!	Read a record from sorted file.
1	CONTINUE
	READ ( 11, 8000, END=990 ) GRP_UIC, ACCOUNT,
l	1	( ITOT(I), KATOT(I), I = TALLY_BEGIN, TALLY_END ),
	2	( CRG(I), ACRG(I), I = CHARGE_BEGIN, CHARGE_END )
4
	IF ( ACCOUNT .EQ. PREV_ACCOUNT )  THEN

`		    ! Accounts still the save - sum usages and charges.
		    CALL ADDQUAD( IT_CONNECT, ITUIC_CONNECT, ITUIC_CONNECT )
(
	    CALL ADDQUAD( KA_CONNECT, KAUIC_CONNECT, KAUIC_CONNECT )

	    CALL ADDQUAD( IT_BY, ITUIC_BY, ITUIC_BY )

	    CALL ADDQUAD( KA_BY, KAUIC_BY, KAUIC_BY )
T	    DO 11 I = 1, TALLY_END
		ITUIC_ARRAY(I) = ITUIC_ARRAY(I) + ITOT(I)
		KAUIC_ARRAY(I) = KAUIC_ARRAY(I) + KATOT(I)
11	    CONTINUE
	    DO 15 I = 1, CHARGE_END
H
		CRGUIC_ARRAY(I) = CRGUIC_ARRAY(I) + CRG(I)

		ACGUIC_ARRAY(I) = ACGUIC_ARRAY(I) + ACRG(I)
15	    CONTINUE
t
	ELSE
<
	    ! Accounts changed.

h	    ! If not first record, print summary
	    ! and write group-account record.
0	    IF ( .NOT. FIRST_RECORD )  THEN
		CALL GRP_SUM_OUTPUT( GRP_UIC, PREV_ACCOUNT )
		WRITE (15,8000) GRP_UIC, ACCOUNT,
\	1		( ITUIC_ARRAY(I), KAUIC_ARRAY(I), 
	2			I = TALLY_BEGIN, TALLY_END ),
$	3		( CRGUIC_ARRAY(I), ACGUIC_ARRAY(I),
	4			I = CHARGE_BEGIN, CHARGE_END )
	    ENDIF
P
	    ! Initialize sums to first values for new account.
	    DO 21 I = TALLY_BEGIN, TALLY_END
|		ITUIC_ARRAY(I) = ITOT(I)
		KAUIC_ARRAY(I) = KATOT(I)
D21	    CONTINUE
	    DO 25 I = CHARGE_BEGIN, CHARGE_END
		CRGUIC_ARRAY(I) = CRG(I)
p		ACGUIC_ARRAY(I) = ACRG(I)
25	    CONTINUE
8
	    ! Update flags.
 	    PREV_ACCOUNT = ACCOUNT
d	    FIRST_RECORD = .FALSE.

,	ENDIF

	GO TO 1
X
!	EOF reached on MEMACCT.SCR
 990	CONTINUE
	! Print last summary.
	CALL GRP_SUM_OUTPUT( GRP_UIC, PREV_ACCOUNT )
L	! Write last group-account usages-charges record
	! for this group.
	WRITE (15,8000) GRP_UIC, ACCOUNT,
x	1	( ITUIC_ARRAY(I), KAUIC_ARRAY(I), 
	2		I = TALLY_BEGIN, TALLY_END ),
@	3	( CRGUIC_ARRAY(I), ACGUIC_ARRAY(I),
	4		I = CHARGE_BEGIN, CHARGE_END )
 	! Force new page.
l 	CALL NEW_PAGE( 999 )
 	! Close sorted file; delete both sorted
4!	! and un-sorted MEMACCT.SCR.
!	CLOSE ( UNIT=11, DISPOSE='DELETE' )
!	OPEN ( UNIT=11, NAME='MEMACCT.SCR', TYPE='OLD' )
`"
"!	MEMACCT.SCR found to be empty.
(#995	CONTINUE
#	CLOSE ( UNIT=11, DISPOSE='DELETE' )
#
T$	RETURN
$
%	END

d 	SUBROUTINE GRP_SUM_OUTPUT( GRP_UIC, ACCOUNT )
 
,!++
!
!   TITLE: GRP_SUM_OUTPUT	Prints group summary data.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	This routine performs the actual printing of group summaries.
!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
x!
!   AUTHOR: Ralph Weber		CREATION DATE: 23-OCT-1980.
@!
!   MODIFIED BY:
!
l!--
!++
4!
!   FUNCTIONAL DESCRIPTION:
!
`	!	This routine performs paper alignment and summary printing
	!	for the group-account summaries.
(
!

!   CALLING SEQUENCE:

!
T!	CALL GRP_SUM_OUTPUT( GRP_UIC.rw.r, ACCOUNT.rt.ds )
!
!   INPUT PARAMETERS:
!	GRP_UIC.rw.r		is the UIC group number.
!
H
!	ACCOUNT.rt.ds		is the account.

!
!   OUTPUT PARAMETERS: None.
t!
!   IMPLICIT INPUTS:
<!
!	/CHARGE_TALLY/	contains the usage and charges totals arrays
!			group-account usage and charges sums.  The
h!			arrays are named as follows: ITUIC_ARRAY,
!			for non-acquisition usage; KAUIC_ARRAY, for
0!			acquisition usage; CRGUIC_ARRAY, for non-
!			acquisition charges; ACGUIC_ARRAY, for
!			acquisition charges.
\!
!	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
$!			these parameters give the starting and ending
!			subscripts of the access arrays in
!			/CHARGE_TALLY/; TALLY_??? for the usage counters
P!			and CHARGE_??? for the charges counters.
!
!   IMPLICIT OUTPUTS:
|!
!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
D!			used to keep track of the current position on
!			a page and to make decisions regarding when a
!			new page should be started.
p!
!   COMPLETION STATUS: Normal return.
8!
!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
 !
d!--

,	INTEGER*2 GRP_UIC
	CHARACTER*(*) ACCOUNT

X	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS

 	COMMON /CHARGE_COUNTERS/ LINE_COUNT

	LOGICAL NEW_PAGE
L
	CHARACTER*80 ACCOUNT_NAME, GROUP_NAME

d 	! Position paper.
 	IF (NEW_PAGE( 24 ) )  THEN
,	    WRITE (9,9000)
9000	    FORMAT ( X, 130('$') // )
	    LINE_COUNT = LINE_COUNT + 3
X	ELSE
	    WRITE (9,9005)
 9005	    FORMAT ( // X, 130('$') // )
	    LINE_COUNT = LINE_COUNT + 5
	ENDIF
L
	! Print heading.
	CALL GET_GRP_NAME( GRP_UIC, GROUP_NAME )
x	CALL GET_ACC_NAME( ACCOUNT, ACCOUNT_NAME )
	WRITE (9,9100) GROUP_NAME( : LEN_STRING( GROUP_NAME )),
@	1	GRP_UIC, ACCOUNT( : LEN_STRING( ACCOUNT )),
	3	ACCOUNT_NAME( : LEN_STRING( ACCOUNT_NAME ))
9100	FORMAT (X, A' Group Charges Summary (UIC=['O3',xxx])' /
l	1	' charged to account 'A', 'A )
	LINE_COUNT = LINE_COUNT + 2
4
	! Print summary.
	CALL PRINT_TOTALS(	ITUIC_ARRAY,	KAUIC_ARRAY,
`		1			CRGUIC_ARRAY,	ACGUIC_ARRAY, 3 )
	
(
	RETURN



	END

d 	SUBROUTINE GROUP_SUMMARY
 
,!++
!
!   TITLE: GROUP_SUMMARY	Prints all group-account summaries
X!				together after all groups processed.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	Reads GRPSUMRY.SCR and prints one charges summary for each
!	group-account record.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!	Ralph Weber (23-OCT-1980) Change to use space in /CHARGE_TALLY/
4!		to store usage-charges values.  Change to use
!		GRP_SUM_OUTPUT routine.  Cleanup documentation.
!
`	!--
	!++
(
!

!   FUNCTIONAL DESCRIPTION:

!
T!	The scratch file GRPSUMRY.SCR is rewound and then read from
!	beginning to end.  For each record in the file a group summary
!	is printed.  It is assumed that all groups have been processed
!	and that all group information from the current input file
!	has been written into GRPSUMRY.SCR.
H
!

!   CALLING SEQUENCE:
!	
t!	CALL GROUP_SUMMARY
!
<!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS: None.
h!
!   IMPLICIT INPUTS:
0!
!	GRPSUMRY.SCR	is the scratch file containing one record for
!			each unique group-account summary previously
\!			printed.  Its records contain group UIC,
!			ACCOUNT, as well as useage and charges totals
$!			arrays.
!
!   IMPLICIT OUTPUTS:
P!
!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
!			used to keep track of the current position on
|!			a page and to make decisions regarding when a
!			new page should be started.
D!
!	/CHARGE_TALLY/	contains the usage and charges totals arrays
!			which this routine uses to hold group-account
p!			usage and charges.  This use erases the
!			previous contents of the arrays, but since
8!			they must be zeroed before the next file
!			is processed, this is not a problem.  The
 !			arrays are named as follows: ITUIC_ARRAY,
d!			for non-acquisition usage; KAUIC_ARRAY, for
!			acquisition usage; CRGUIC_ARRAY, for non-
,!			acquisition charges; ACGUIC_ARRAY, for
!			acquisition charges.
!
X!   COMPLETION STATUS: Normal return.
!
 !   SIDE EFFECTS: See IMPLICIT OUTPUTS.
!
!--
L
	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS

x	COMMON /CHARGE_COUNTERS/ LINE_COUNT

@	CHARACTER*8 ACCOUNT

 	INTEGER*2 GRP_UIC

d !	Rewind GRPSUMRY.SCR.
 	REWIND 15
,
!	Read a record and print a summary.
1	CONTINUE
X	READ (15,8000,END=999) GRP_UIC, ACCOUNT,
	1	( ITUIC_ARRAY(I), KAUIC_ARRAY(I), 
 	2		I = TALLY_BEGIN, TALLY_END ),
	3	( CRGUIC_ARRAY(I), ACGUIC_ARRAY(I),
	4		I = CHARGE_BEGIN, CHARGE_END )
L8000	FORMAT ( O3, A8, 47A4 )

	CALL GRP_SUM_OUTPUT( GRP_UIC, ACCOUNT )
x
	GO TO 1
@
!	At end force new page before exit.
999	CONTINUE
l	CALL NEW_PAGE( 999 )

4	RETURN

	END

d 	SUBROUTINE PRINT_FINAL_TOT
 
,!++
!
!   TITLE: PRINT_FINAL_TOT	Prints summary for entire input file.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Calls PRINT_TOTALS to print the charge summary for the entire input
!	accounting file.
!
x!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
@!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
!   MODIFIED BY:
l!	Ralph Weber (23-OCT-1980) Setup to use /CHARGE_TALLY/.  Update
!		documentation.
4!
!--
!++
`	!
	!   FUNCTIONAL DESCRIPTION:
(
!

!	The routine prints a heading, then calls PRINT_TOTALS to print a

!	summary of the total useage and charges for the current input
T!	file.
!
!   CALLING SEQUENCE:
!
!	CALL PRINT_FINAL_TOT
H
!

!   INPUT PARAMETERS: None.
!
t!   OUTPUT PARAMETERS: None.
!
<!   IMPLICIT INPUTS:
!
!	/CHARGE_FILE/	contains the character variable INPUT_FILE
h!			which gives the name of the current input
!			file.
0!
!	/CHARGE_TALLY/	contains the usage and charges totals arrays
!			for the current input file usage and charges.
\!			The arrays are named as follows: ITRUN_ARRAY,
!			for non-acquisition usage; KARUN_ARRAY, for
$!			acquisition usage; CRGRUN_ARRAY, for non-
!			acquisition charges; ACGRUN_ARRAY, for
!			acquisition charges.
P!
!
!   IMPLICIT OUTPUTS:
|!
!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
D!			used to keep track of the current position on
!			a page and to make decisions regarding when a
!			new page should be started.
p!
!   COMPLETION STATUS: Normal return.
8!
!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
 !
d!--

,	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS

	COMMON /CHARGE_COUNTERS/ LINE_COUNT
X
	CHARACTER*16 INPUT_FILE
 	COMMON /CHARGE_FILE/ INPUT_FILE

d 	! Position paper.
 	IF (NEW_PAGE( 24 ) )  THEN
,	    WRITE (9,9000)
9000	    FORMAT ( X, 130('@') // )
	    LINE_COUNT = LINE_COUNT + 3
X	ELSE
	    WRITE (9,9005)
 9005	    FORMAT ( // X, 130('@') // )
	    LINE_COUNT = LINE_COUNT + 5
	ENDIF
L
	! Print heading.
	WRITE (9,9020) INPUT_FILE
x9020	FORMAT (' Charge Summary for Input File 'A )

@	! Print summary.
	CALL PRINT_TOTALS(	ITRUN_ARRAY,	KARUN_ARRAY,
	1			CRGRUN_ARRAY,	ACGRUN_ARRAY, 2 )
l
	RETURN
4
	END

d 	SUBROUTINE ACCOUNTS_BILLS
 
,!++
!
!   TITLE: ACCOUNTS_BILLS	Prints charge report by account number.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	A report of charges for non-acquisition, acquisition, and
!	personnel incurred by each group within each account is printed.
!
x!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
@!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
!   MODIFIED BY:
l!	Ralph Weber (24-OCT-1980) Change to GRPSUMRY.SCR format. Update
!		documentation.
4!
!--
!++
`	!
	!   FUNCTIONAL DESCRIPTION:
(
!

!	If the file GRPSUMRY.SCR is not empty, it is closed and sorted

!	by account and UIC group.  The sorted file is read and a report
T!	is produced.  The report shows three columns of charges: non-
!	acquisition, acquisition, and personnel.  A line is printed for
!	each group in an account.  A total charges line is printed at
!	the end of each account's groups.  After all records have been
!	read, the scratch file, GRPSUMRY.SCR, is deleted.
H
!

!   CALLING SEQUENCE:
!
t!	ACCOUNTS_BILLS
!
<!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS: None.
h!
!   IMPLICIT INPUTS:
0!
!	GRPSUMRY.SCR	is the scratch file containing a records for
!			each unique group-account.  It is sorted by
\!			account and group and then processed by the
!			routine.
$!
!	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
!			these parameters give the starting and ending
P!			subscripts of the access arrays in
!			/CHARGE_TALLY/; TALLY_??? for the usage counters
!			and CHARGE_??? for the charges counters.  These
|!			values are used to dimension local arrays for
!			reading the usage and charge information from
D!			MEMACCT.SCR and for manipulating usage and
!			charge arrays.
!
p!   IMPLICIT OUTPUTS:
!
8!	/CHARGE_TALLY/	contains the usage and charges totals arrays
!			which this routine uses to read group-account
 !			usage and charges.  This use erases the
d!			previous contents of the arrays, but since
!			they must be zeroed before the next file
,!			is processed, this is not a problem.  The
!			arrays are named as follows: ITUIC_??????,
!			for non-acquisition usage; KAUIC_??????, for
X!			acquisition usage; CRGUIC_??????, for non-
!			acquisition charges; ACGUIC_??????, for
 !			acquisition charges.  Where ?????? is one of:
!			BY	  systems personal time.
!			ARRAY	  an array to access all counters for a
L!				  given tally range.
!			NB. this routine is written so as to make no
!			assumptions about the location of ??????_BY
x!			in ??????_ARRAY.
!
@!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
!			used to keep track of the current position on
 !			a page and to make decisions regarding when a
l !			new page should be started.
 !
4!!   COMPLETION STATUS: Normal return.
!!
!!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
`"!
"!--
(#
#	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
#
T$	COMMON /CHARGE_COUNTERS/ LINE_COUNT
$
%	LOGICAL NEW_PAGE
%
%	CHARACTER*8 ACCOUNT, LAST_ACCOUNT
H&	CHARACTER*80 ACCOUNT_NAME, GROUP_NAME
&
'	INTEGER*2 GROUP, LAST_GROUP
t'
'	LOGICAL*1 FIRST_RECORD
<(
(	REAL*4	NON_ACQ_CHARGE, ACQ_CHARGE, PERSON_CHARGE,
)	1	NON_ACQ_TOTAL,  ACQ_TOTAL,  PERSON_TOTAL,
h)	2	GRAND_TOTAL
)
0*	INTEGER*2 GRPSMRY_SRT_KEY(9)
*	DATA GRPSMRY_SRT_KEY/ 2,	! Number of keys
*	1				! (position,size,type,a/d)
\+	1	1, 0, 4, 8,		! ACCOUNT (4,8,char,a)
+	2	1, 0, 1, 3 /		! UIC GROUP (1,3,char,a)

d !	Check for empty GRPSUMRY.SCR.
 !	If file not empty, sort it.
,	REWIND 15
	READ ( 15, 8000, END=995 ) GROUP, ACCOUNT,
	1	( ITUIC_ARRAY(I), KAUIC_ARRAY(I), 
X	2		I = TALLY_BEGIN, TALLY_END ),
	3	( CRGUIC_ARRAY(I), ACGUIC_ARRAY(I),
 	4		I = CHARGE_BEGIN, CHARGE_END )
8000	FORMAT ( O3, A8, 47A4 )
	CLOSE ( UNIT=15 )
L	CALL SORT_FILE( 'GRPSUMRY.SCR', 'GRPSUMRY.SCR',
	1		GRPSMRY_SRT_KEY )

x!	Force new page.
	CALL NEW_PAGE( 999 )
@
!	Prepair to read sorted file.
	OPEN ( UNIT=15, NAME='GRPSUMRY.SCR', TYPE='OLD' )
l	LAST_GROUP = -1
	LAST_ACCOUNT = '%%%%%%%%'
4	FIRST_RECORD = .TRUE.

!	Read a record from sorted file.
`	1	CONTINUE
		READ ( 15, 8000, END=990 ) GROUP, ACCOUNT,
(
	1	( ITUIC_ARRAY(I), KAUIC_ARRAY(I), 

	2		I = TALLY_BEGIN, TALLY_END ),

	3	( CRGUIC_ARRAY(I), ACGUIC_ARRAY(I),
T	4		I = CHARGE_BEGIN, CHARGE_END )

!	New account?
	IF (ACCOUNT .NE. LAST_ACCOUNT)  THEN
	    IF ( .NOT. FIRST_RECORD )  THEN
H
		! Print current account charges.

		CALL GET_GRP_NAME( LAST_GROUP, GROUP_NAME )
		WRITE (9,9200) GROUP_NAME, NON_ACQ_CHARGE, ACQ_CHARGE,
t	1		PERSON_CHARGE
9200		FORMAT (X, A80, 3('  $'F14.2) )
<		! Print account totals and grand total.
		GRAND_TOTAL = NON_ACQ_TOTAL + ACQ_TOTAL + PERSON_TOTAL
		WRITE (9,9400) LAST_ACCOUNT, GRAND_TOTAL,
h	1		NON_ACQ_TOTAL, ACQ_TOTAL, PERSON_TOTAL
9400		FORMAT ('+' T84,15('_') 2X,15('_') 2X,15('_') /
0	1		10X'Total Charges to Account 'A8' = $'F10.2,
	2		13X'Sub-totals ' 3('  $'F14.2) ///// )
		LINE_COUNT = LINE_COUNT + 8
\	    ENDIF
	    ! Zero totals and charge sums.
$	    NON_ACQ_TOTAL  = 0
	    ACQ_TOTAL	   = 0
	    PERSON_TOTAL   = 0
P	    NON_ACQ_CHARGE = 0
	    ACQ_CHARGE	   = 0
	    PERSON_CHARGE  = 0
|	    LAST_ACCOUNT = ACCOUNT
	    LAST_GROUP = GROUP
D	    ! Make new page, if necessary.
	    CALL NEW_PAGE( 10 )
	    ! Write new account heading.
p	    CALL GET_ACC_NAME( ACCOUNT, ACCOUNT_NAME )
	    WRITE (9,9100) ACCOUNT( : LEN_STRING( ACCOUNT )),
8	1	    ACCOUNT_NAME( : LEN_STRING( ACCOUNT_NAME )), ' '
9100	    FORMAT (10X'Charge Summary for Account 'A', 'A, A /
 	1	    ' Group Name'T84
d	2	    'Non-Acquisition      Acquisition        Personnel')
	    LINE_COUNT = LINE_COUNT + 2
,
	    ! Signal, not first record any more.
	    FIRST_RECORD = .FALSE.
X
!	New group?
 	ELSEIF (GROUP .NE. LAST_GROUP)  THEN
	    ! Make new page, if necessary.
	    IF (NEW_PAGE( 6 ) )  THEN
L		WRITE (9,9100) ACCOUNT( : LEN_STRING( ACCOUNT )),
	1		ACCOUNT_NAME( : LEN_STRING( ACCOUNT_NAME )),
	2		' - continued -'
x		LINE_COUNT = LINE_COUNT + 2
	    ENDIF
@	    ! Print account charges.
	    CALL GET_GRP_NAME( LAST_GROUP, GROUP_NAME )
 	    WRITE (9,9200) GROUP_NAME, NON_ACQ_CHARGE, ACQ_CHARGE,
l 	1	    PERSON_CHARGE
 	    LINE_COUNT = LINE_COUNT + 1
4!	    ! Zero group charge sums.
!	    NON_ACQ_CHARGE = 0
!	    ACQ_CHARGE	   = 0
`"	    PERSON_CHARGE  = 0
"	    LAST_GROUP = GROUP
(#
#	ENDIF
#
T$!	Add current charges to group sums.
$	DO 11 I = CHARGE_BEGIN, CHARGE_END
%	    NON_ACQ_CHARGE = NON_ACQ_CHARGE + CRGUIC_ARRAY(I)
%	    ACQ_CHARGE	   = ACQ_CHARGE	    + ACGUIC_ARRAY(I)
%11	CONTINUE
H&	NON_ACQ_CHARGE	= NON_ACQ_CHARGE - CRGUIC_BY
&	ACQ_CHARGE	= ACQ_CHARGE	 - ACGUIC_BY
'	PERSON_CHARGE = PERSON_CHARGE + CRGUIC_BY + ACGUIC_BY
t'	! Sum to account totals.
'	NON_ACQ_TOTAL = NON_ACQ_TOTAL + NON_ACQ_CHARGE
<(	ACQ_TOTAL     = ACQ_TOTAL     + ACQ_CHARGE
(	PERSON_TOTAL  = PERSON_TOTAL  + PERSON_CHARGE
)
h)	GO TO 1
)
0*!	EOF reached on sorted GRPSUMRY.SCR.
*990	CONTINUE
*	! Print last account charges.
\+	CALL GET_GRP_NAME( LAST_GROUP, GROUP_NAME )
+	WRITE (9,9200) GROUP_NAME, NON_ACQ_CHARGE, ACQ_CHARGE,
$,	1	PERSON_CHARGE
,	LINE_COUNT = LINE_COUNT + 1
,	! Print last account totals and grand total
P-	GRAND_TOTAL = NON_ACQ_TOTAL + ACQ_TOTAL + PERSON_TOTAL
-	WRITE (9,9400) ACCOUNT, GRAND_TOTAL,
.	1	NON_ACQ_TOTAL, ACQ_TOTAL, PERSON_TOTAL
|.	! Force new page.
.	CALL NEW_PAGE( 999 )
D/	! Close sorted file; deleted both sorted
/	! and un-sorted GRPSUMRY.SCR.
0	CLOSE ( UNIT=15, DISPOSE='DELETE' )
p0	OPEN ( UNIT=15, NAME='GRPSUMRY.SCR', TYPE='OLD' )
0
81!	GRPSUMRY.SCR found to be empty.
1995	CONTINUE
 2	CLOSE ( UNIT=15, DISPOSE='DELETE' )
d2
2	RETURN
,3
3	END

d 	SUBROUTINE PROCESS_FORS( END_INPUT )
 
,!++
!
!   TITLE: PROCESS_FORS		Processes input records for types 41,
X!				42, 43, and 44.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	All FOR records belonging to a system person having a single
!	message type are copied to a scratch file which is then sorted
x!	by the FOR UIC associated with that message type.  The sorted
!	file is then processed as if it was the input accounting file.
@!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
l!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
4!   MODIFIED BY:
!	Ralph Weber (24-OCT-1980) Setup to use file sorting subroutine.
!		Cleanup documentation.
`	!
	!--
(
!++

!

!   FUNCTIONAL DESCRIPTION:
T!
!	The routine processes accounting records having message types
!	of 41 thru 59 (45 thru 59 are currently unused) which document
!	work done by system personnel FOR another user.  This routine
!	copies the records for the current type and system person to a
H
!	scratch file, FORRECS.SCR.  This file is sorted by the UIC and

!	OWNER of the users the work was done for.  Since the location
!	the sort data varies with message type, only one message type
t!	is processed per call to this routine.  The units digit of
!	the message type determines the exact sort key used to sort the
<!	scratch file.  The sorted file is then processed as if it's
!	records had been read from the input accounting file.  The
!	routines which process input records keep track of and print
h!	FOR totals seperately so that they are not doubly counted
!	when the same work appears in a BY record for the user.
0!
!   CALLING SEQUENCE:
!
\!	CALL PROCESS_FORS( END_INPUT.wbu.r )
!
$!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS:
P!
!	END_INPUT.wbu.r		is a flag used to indicate whether or
!				or not the end of the input accounting
|!				file was reached during the processing
!				of FOR records by this routine.  It is
D!				set .TRUE. if the EOF is reached and
!				set .FALSE. if not.
!
p!   IMPLICIT INPUTS:
!
8!	/CHARGE_RECORD/	contains the current input record.  This routine
!			reads new input records and updates this area
 !			accordingly.  This area is also used to supply
d!			the normal input record processing routines
!			with input from the sort FOR records file.
,!			See the main program for a full description of
!			the contents of an input record.
!
X!   IMPLICIT OUTPUTS:
!
 !	/CHARGE_RECORD/	see implicit inputs.
!
!	/CHARGE_MTYPE/	contains the tens and units digits of the
L!			message type in the current input record,
!			ITYPE_TENS and ITYPE_UNITS, respectively.
!
x!	from /CHARGE_TALLY/
!
@!	ITOT_ARRAY	is the array of other charge counters for the
!			current type which this routine zeros for
 !			each new user served.
l !
 !	CHARGE_ARRAY	is the array of charges for the current type
4!!			which this routine zeros for each new user
!!			served.
!!
`"!	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
"!			these parameters give the starting and ending
(#!			subscripts of the access arrays in
#!			/CHARGE_TALLY/; TALLY_??? for the usage counters
#!			and CHARGE_??? for the charges counters.
T$!
$!   COMPLETION STATUS: Normal return.
%!
%!   SIDE EFFECTS:
%!
H&!	The scratch file FORRECS.SCR is created, sorted, and deleted by
&!	this routine.  If the program terminates abnormally during
'!	execution of the routine, the file(s) may remain in existance.
t'!
'!--
<(
(	LOGICAL*1 END_INPUT
)
h)	INCLUDE 'BILLING:BILLDEF.FOR/NOLIST' ! Listed in main program
)	COMMON /CHARGE_RECORD/ BILL_RECORD
0*
*	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
*
\+	INTEGER*2 ITYPE_UNITS, ITYPE_TENS
+	COMMON /CHARGE_MTYPE/ ITYPE_TENS, ITYPE_UNITS
$,
,	CHARACTER*6  LAST_MACHINE
,	CHARACTER*10 LAST_USERNAME
P-	CHARACTER*20 LAST_OWNER, FOR_OWNER
-
.	INTEGER*4 LAST_UIC, FOR_UIC
|.
.	INTEGER*2 LAST_TYPE
D/
/	LOGICAL*1 FIRST_RECORD
0
p0	BYTE SAVE_RECORD( 0 : BILL_K_LENGTH-1 )
0
81	INTEGER*2 SORT_KEYS(9,4), KEY_41(9), KEY_42(9), KEY_43(9),
1	1	KEY_44(9)
 2	EQUIVALENCE	( KEY_41(1), SORT_KEYS( 1, 1 )),
d2	1		( KEY_42(1), SORT_KEYS( 1, 2 )),
2	2		( KEY_43(1), SORT_KEYS( 1, 3 )),
,3	3		( KEY_44(1), SORT_KEYS( 1, 4 ))
3
3	DATA KEY_41 / 2,		! Number of keys
X4	1				! (position,size,type,a/d)
4	1	2, 0, 113,  4,		! UIC (113,4,bin,a)
 5	2	1, 0,  93, 20 /		! OWNER (93,20,char,a)
5
5	DATA KEY_42 / 2,		! Number of keys
L6	1				! (position,size,type,a/d)
6	1	2, 0, 137,  4,		! UIC (137,4,bin,a)
7	2	1, 0, 117, 20 /		! OWNER (117,20,char,a)
x7
7	DATA KEY_43 / 2,		! Number of keys
@8	1				! (position,size,type,a/d)
8	1	2, 0, 121,  4,		! UIC (121,4,bin,a)
9	2	1, 0, 101, 20 /		! OWNER (101,20,char,a)
l9
9	DATA KEY_44 / 2,		! Number of keys
4:	1				! (position,size,type,a/d)
:	1	2, 0, 125,  4,		! UIC (125,4,bin,a)
:	2	1, 0, 103, 20 /		! OWNER (103,20,char,a)

d !	Open scratch file to hold FOR records
 !	and setup to copy records to it.
,	OPEN ( UNIT=7, NAME='FORRECS.SCR', TYPE='NEW',
	1	RECORDTYPE='VARIABLE', RECORDSIZE=BILL_K_LENGTH,
	2	CARRIAGECONTROL='NONE' )
X	LAST_USERNAME=BILL_T_USERNAME
	LAST_UIC=BILL_L_UIC
 	LAST_TYPE=BILL_W_MSGTYP

!	Copy input accounting file records to FORRECS.SCR until
L!	a new message type, new member, or EOF occurs.
10	CONTINUE
	WRITE (7,9000) (BILL_RECORD(I), I = 0, BILL_W_MSGSIZ-1)
x9000	FORMAT ( <BILL_W_MSGSIZ>A1 )
	READ ( 10, 9100, END=19 ) NUM_CHARS,
@	1	(BILL_RECORD(I), I = 0, NUM_CHARS-1)
9100	FORMAT ( Q, <NUM_CHARS>A1 )
	IF (LAST_TYPE .EQ. BILL_W_MSGTYP .AND.
l	1   LAST_UIC .EQ. BILL_L_UIC .AND.
	2   LAST_USERNAME .EQ. BILL_T_USERNAME )  THEN
4		GO TO 10
	ELSE
		GO TO 20
`		ENDIF
	19	END_INPUT = .TRUE.
(


!	Copy complete.

!	Close scratch file and save new last input record.
T20	CONTINUE
	CLOSE ( UNIT=7 )
	DO 21 I = 0, NUM_CHARS-1
21	    SAVE_RECORD(I) = BILL_RECORD(I)
!
H
!	Sort the scratch file by FOR UIC and OWNER.

!	Use units digits of message type to determine sort keys.
	CALL SORT_FILE( 'FORRECS.SCR', 'FORRECS.SCR',
t	1	SORT_KEYS( 1, MOD( LAST_TYPE, 10 )) )

<!	Prepair to read and processes sorted file.
	OPEN ( UNIT=7, NAME='FORRECS.SCR', TYPE='OLD',
	1	RECORDTYPE='VARIABLE', CARRIAGECONTROL='NONE' )
h	LAST_UIC = -1
	FIRST_RECORD = .TRUE.
0	ITYPE_TENS = LAST_TYPE / 10
	ITYPE_UNITS = LAST_TYPE - (ITYPE_TENS * 10)

\!	Read a record and process it.
30	CONTINUE
$	READ ( 7, 9200, END=99 ) IN_CHARS,
	1	(BILL_RECORD(I), I = 0, IN_CHARS-1 )
9200	FORMAT ( Q, <IN_CHARS>A1 )
P
!	Extract FOR UIC and OWNER.
	IF (ITYPE_UNITS .EQ. 1) THEN
|	    FOR_UIC = BILL_L_NINF_UIC
	    FOR_OWNER = BILL_T_NINT_FOR
D	ELSEIF (ITYPE_UNITS .EQ. 2) THEN
	    FOR_UIC = BILL_L_BCHF_UIC
	    FOR_OWNER = BILL_T_BCH_FOR
p	ELSEIF (ITYPE_UNITS .EQ. 3) THEN
	    FOR_UIC = BILL_L_INTF_UIC
8	    FOR_OWNER = BILL_T_INT_FOR
	ELSEIF (ITYPE_UNITS .EQ. 4) THEN
 	    FOR_UIC = BILL_L_PRTF_UIC
d	    FOR_OWNER = BILL_T_PRT_FOR
	ELSE
,	    STOP 'Bad MSGTYP in PROCESS_FORS routine.'
	ENDIF

X!	Process records from sorted FORRECS.SCR.
!	For each FOR UIC, print the heading, amounts, and totals.
 	IF (FOR_UIC .NE. LAST_UIC .OR.
	1	LAST_OWNER .NE. FOR_OWNER .OR.
	2	LAST_MACHINE .NE. BILL_T_MACHCODE )  THEN
L	    IF ( .NOT. FIRST_RECORD )  THEN
		CALL PRINT_TYPE_TOT( LAST_TYPE, LAST_MACHINE )
	    ENDIF
x	    CALL PRINT_HEADING
	    LAST_UIC = FOR_UIC
@	    LAST_OWNER = FOR_OWNER
	    LAST_MACHINE =  BILL_T_MACHCODE
 	    FIRST_RECORD = .FALSE.
l 	    CALL ADD_USE_TO_MEM( LAST_TYPE )
 	    ! Zero current user counters.
4!	    DO 41 I = TALLY_BEGIN, TALLY_END
!41		ITOT_ARRAY(I) = 0
!	    DO 43 I = CHARGE_BEGIN, CHARGE_END
`"43		CHARGE_ARRAY(I) = 0.0
"	ENDIF
(#
#	! Add and print amounts.
#	CALL ADD_AMOUNTS
T$	CALL PRINT_AMOUNTS
$	GO TO 30
%
%!	EOF on scratch file reached.
%99	CONTINUE
H&!	Close sorted scratch file.
&!	Delete both sorted and un-sorted scratch files.
'	CLOSE ( UNIT=7, DISPOSE='DELETE' )
t'	OPEN ( UNIT=7, NAME='FORRECS.SCR', TYPE='OLD',
'	1	RECORDTYPE='VARIABLE', CARRIAGECONTROL='NONE' )
<(	CLOSE ( UNIT=7, DISPOSE='DELETE' )
(
)
h)!	Restore the last accounting record read.
)	DO 101 I = 0, NUM_CHARS-1
0*101	    BILL_RECORD(I) = SAVE_RECORD(I)
*
*	RETURN
\+
+	END

d 	SUBROUTINE SORT_FILE( INFILE, OUTFILE, KEYS )
 
,!++
!
!   TITLE: SORT_FILE			Sorts a file.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Sorts a file into another file according to given keys.
!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
x!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
@!
!   MODIFIED BY:
!	Ralph Weber (25-OCT-1980) Setup to sort given file into another
l!		given file using given keys.
!
4!--
!++
!
`	!   FUNCTIONAL DESCRIPTION:
	!
(
!	The VMS sort utility is called to sort INFILE outputing OUTFILE

!	using KEYS keys.

!
T!   CALLING SEQUENCE:
!
!	CALL SORT_FILE( INFILE.rt.ds, OUTFILE.rt.ds, KEYS.rw.r )
!
!   INPUT PARAMETERS:
H
!

!	INFILE.rt.ds	is the name of the file to be sorted.
!
t!	OUTFILE.rt.ds	is the name of the file into which the sorted
!			contents of INFILE will be written.  If OUTFILE
<!			equals INFILE, a new version will be created.
!
!	KEYS.rw.r	is the keys array to be supplied to the sort
h!			routines to control sorting.
!
0!   OUTPUT PARAMETERS: None.
!
!   IMPLICIT INPUTS: None.
\!
!   IMPLICIT OUTPUTS: None.
$!
!   COMPLETION STATUS:
!
P!	See completion status codes for the sort routines.
!
!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
|!
!--
D
	IMPLICIT INTEGER*4 (A-Z)

p	INTEGER*2 KEYS(1)
	CHARACTER*(*) INFILE, OUTFILE

d 	STATUS=SOR$PASS_FILES ( INFILE, OUTFILE )
 	IF (.NOT.STATUS) CALL LIB$STOP (%VAL(STATUS))
,
	STATUS=SOR$INIT_SORT ( KEYS, ,, 3, 1 )
	IF (.NOT.STATUS) CALL LIB$STOP (%VAL(STATUS))
X
	STATUS=SOR$SORT_MERGE()
 	IF (.NOT.STATUS) CALL LIB$STOP (%VAL(STATUS))

	STATUS=SOR$END_SORT()
L	IF (.NOT.STATUS) CALL LIB$STOP (%VAL(STATUS))

	RETURN
x	END

d 	SUBROUTINE PRINT_TOTALS( TOTALS, ATOTALS, CHARGES, ACHARGES,
 	1			FLAGS )
,
!++
!
X!   TITLE: PRINT_TOTALS		Prints costs, totals, and charges in
!				summary format.
 !
!   FACILITY: BILLING SYSTEM
!
L!   ABSTRACT:	
!
!	Service costs, usage totals, and billable charges as obtained
x!	from input parameters and implicit inputs are printed in a
!	format suitable for member, group, and FOR work summaries.
@!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
l!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
4!   MODIFIED BY:
!	Ralph Weber (25-OCT-1980) Setup /CHARGE_TALLY/ form arrays.
!		Cleanup documentation.
`	!
	!--
(
!++

!

!   FUNCTIONAL DESCRIPTION:
T!
!	The input parameters and service cost data (obtained from
!	/CHARGE_COSTS/) are printed in tabular format.  The table is
!	composed of six columns: 1) name of serivce, 2) amount charged
!	per service unit, 3) number of service units used by non-
H
!	acquisition jobs, 4) charge for service rendered to non-

!	acquisition jobs, 5) number of service units used by acquisition
!	jobs, 6) charge for service rendered to acquisition jobs.
t!	Column headings and totals for the charges columns are also
!	printed.
<!
!	The FLAGS argument is used to control some aspects of printing
!	the table.  Zero always means print a complete table.
h!	Currently, the only value explicitly supported is one, which
!	means print all but work done by systems personnel.  Currently,
0!	all other values also mean print complete summary.
!
!   CALLING SEQUENCE:
\!
!	CALL PRINT_TOTALS( TOTALS.rl.ra, ATOTALS.rl.ra, CHARGES.rf.ra,
$!			ACHARGES.rf.ra, FLAGS.rl.r )
!
!   INPUT PARAMETERS:
P!
!	TOTALS.rl.ra	is the array of non-acquisition usage amounts.
!
|!	ATOTALS.rl.ra	is the array of acquisition usage amounts.
!
D!	CHARGES.rf.ra	is the array of non-acquisition charges.
!
!	ACHARGES.rf.ra	is the array of acquisition charges.
p!
!	FLAGS.rl.r	is set of flags controlling what parts of the
8!			summary are printed.
!
 !   OUTPUT PARAMETERS: None.
d!
!   IMPLICIT INPUTS:
,!
!	/CHARGE_COSTS/	contains amounts charged for all billable types
!			of usage and adjustment factors for acquisition
X!			and batch-queue usage.  Charge amounts are of
!			the form AMT_?????? (where ??????? is one of:
 !			CONNECT	  connect time.
!			BY	  systems personal time.
!			CPUTIME	  CPU time.
L!			BYTIOCNT  byte I/O's (unit record I/O's).
!			DRTIOCNT  direct I/O's (mass storage I/O's).
!			VOLUMES   volume mounts.
x!			PAGEFLTS  page faults.
!			PRTPAGCT  number of printed pages.
@!			PRTLINCT  number of printed lines.
!			PRTRDCT   number of reads during print.
 !
l !	TALLY_BEGIN, TALLY_END, CHARGE_BEGIN, CHARGE_END
 !			these parameters give the starting and ending
4!!			subscripts of the access arrays in
!!			/CHARGE_TALLY/; TALLY_??? for the usage counters
!!			and CHARGE_??? for the charges counters.
`"!
"!	This routine makes assumptions about the location of values
(#!	contained in the input arrays.  If the ordering of values
#!	in /CHARGE_TALLY/ is changed, the parameter statements below
#!	must also be changed.
T$!
$!   IMPLICIT OUTPUTS:
%!
%!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
%!			used to keep track of the current position on
H&!			a page and to make decisions regarding when a
&!			new page should be started.
'!
t'!   COMPLETION STATUS: Normal return.
'!
<(!   SIDE EFFECTS:
(!
)!	This routine prints 15 or 16 lines without regard for whether
h)!	the fit on the current page or not.  The caller of this
)!	routine is required to insure that it's output will fit on
0*!	a page.
*!
*!--
\+
+	INCLUDE 'BILLING:TALLYDEF.FOR/NOLIST'  ! Listed in RESET_TOTALS
$,
,	INTEGER*4 TOTALS( TALLY_BEGIN : TALLY_END ),
,	1	 ATOTALS( TALLY_BEGIN : TALLY_END )
P-
-	PARAMETER TOT_CONNECT	= -3
.	PARAMETER TOT_BY	= -1
|.	PARAMETER TOT_CPUTIME	=  1
.	PARAMETER TOT_BYTIOCNT	=  2
D/	PARAMETER TOT_DRTIOCNT	=  3
/	PARAMETER TOT_VOLUMES	=  4
0	PARAMETER TOT_PAGEFLTS	=  5
p0	PARAMETER TOT_PRTPAGCT	=  6
0	PARAMETER TOT_PRTLINCT	=  7
81	PARAMETER TOT_PRTRDCT	=  8
1
 2	REAL*4 CHARGES( CHARGE_END ), ACHARGES( CHARGE_END )
d2
2	PARAMETER CRG_CPUTIME	=  1
,3	PARAMETER CRG_BYTIOCNT	=  2
3	PARAMETER CRG_DRTIOCNT	=  3
3	PARAMETER CRG_VOLUMES	=  4
X4	PARAMETER CRG_PAGEFLTS	=  5
4	PARAMETER CRG_PRTPAGCT	=  6
 5	PARAMETER CRG_PRTLINCT	=  7
5	PARAMETER CRG_PRTRDCT	=  8
5	PARAMETER CRG_CONNECT	=  9
L6	PARAMETER CRG_BY	= 10
6
7	INTEGER*4 FLAGS
x7
7	COMMON /CHARGE_COSTS/
@8	1	AMT_CONNECT,  AMT_CPUTIME,  AMT_BYTIOCNT,
8	2	AMT_DRTIOCNT, AMT_VOLUMES,  AMT_PAGEFLTS,
9	3	AMT_PRTPAGCT, AMT_PRTLINCT, AMT_PRTRDCT,
l9	4	AMT_BY( "17:"20, 0:"47),
9	5	ADJM_ACQ, ADJM_QUEUE(5)
4:
:	COMMON /CHARGE_COUNTERS/ LINE_COUNT
:
`;	REAL*4 T1, T2
;
(<	CHARACTER*17 DELTA_TIME_1, DELTA_TIME_2

d !	Write summary heading.
 	WRITE (9,9000)
,9000	FORMAT ( / ' Chargeable Item'5X'Basic Charge'13X'Units '12X
	1	'Adjusted'9X'ACQ Units '9X'Adjusted' /
	2	23X'Per Unit' 34X'Charge' 28X'ACQ Charge' / )
X
!	Print totals and charges for each type of charge.
 
	WRITE (9,9100) AMT_CPUTIME,
	1	FLOAT( TOTALS(TOT_CPUTIME))/100.0, CHARGES(CRG_CPUTIME),
L	2	FLOAT(ATOTALS(TOT_CPUTIME))/100.0, ACHARGES(CRG_CPUTIME)
9100	FORMAT (' CPU Time'12X'$'F6.3'   / Sec'F17.2' Sec    $'F11.2,
	1	4X,F13.2' Sec    $'F11.2)
x
	WRITE (9,9200) ' Byte I/O     ', AMT_BYTIOCNT,
@	1	 TOTALS( TOT_BYTIOCNT ),  CHARGES( CRG_BYTIOCNT ),
	2	ATOTALS( TOT_BYTIOCNT ), ACHARGES( CRG_BYTIOCNT )
9200	FORMAT ( A, 7X'$'F8.5' / ea' I18,8X'$'F11.2, I17,8X'$'F11.2 )
l
	WRITE (9,9200) ' Direct I/O   ', AMT_DRTIOCNT,
4	1	 TOTALS( TOT_DRTIOCNT ),  CHARGES( CRG_DRTIOCNT ),
	2	ATOTALS( TOT_DRTIOCNT ), ACHARGES( CRG_DRTIOCNT )

`		WRITE (9,9200) ' Mounts       ', AMT_VOLUMES,
		1	 TOTALS( TOT_VOLUMES ),  CHARGES( CRG_VOLUMES ),
(
	2	ATOTALS( TOT_VOLUMES ), ACHARGES( CRG_VOLUMES )



	WRITE (9,9200) ' Page Faults  ', AMT_PAGEFLTS,
T	1	 TOTALS( TOT_PAGEFLTS ),  CHARGES( CRG_PAGEFLTS ),
	2	ATOTALS( TOT_PAGEFLTS ), ACHARGES( CRG_PAGEFLTS )

	WRITE (9,9200) ' Pages Printed', AMT_PRTPAGCT,
	1	 TOTALS( TOT_PRTPAGCT ),  CHARGES( CRG_PRTPAGCT ),
H
	2	ATOTALS( TOT_PRTPAGCT ), ACHARGES( CRG_PRTPAGCT )

	WRITE (9,9200) ' Lines Printed', AMT_PRTLINCT,
t	1	 TOTALS( TOT_PRTLINCT ),  CHARGES( CRG_PRTLINCT ),
	2	ATOTALS( TOT_PRTLINCT ), ACHARGES( CRG_PRTLINCT )
<
	WRITE (9,9200) ' Print Reads  ', AMT_PRTRDCT,
	1	 TOTALS( TOT_PRTRDCT ),  CHARGES( CRG_PRTRDCT ),
h	2	ATOTALS( TOT_PRTRDCT ), ACHARGES( CRG_PRTRDCT )

0!	Convert connect times to ASCII
!	and print connect times and charges.
	DELTA_TIME_1 = ' '
\	DELTA_TIME_2 = ' '
	CALL MY_ASCTIM( DELTA_TIME_1,  TOTALS( TOT_CONNECT ) )
$	CALL MY_ASCTIM( DELTA_TIME_2, ATOTALS( TOT_CONNECT ) )
	WRITE (9,9300) AMT_CONNECT,
	1	DELTA_TIME_1,  CHARGES( CRG_CONNECT ),
P	2	DELTA_TIME_2, ACHARGES( CRG_CONNECT )
9300	FORMAT (' Connect Time'8X'$'F5.2'    / Hour' A17, 7X'$'F11.2,
	1	1X, A17, 7X'$'F11.2 )
|
!	If FLAGS not one, setup and print
D!	work done by systems personnel data.
	IF (FLAGS .NE. 1)  THEN
	    CALL MY_ASCTIM( DELTA_TIME_1, TOTALS( TOT_BY ) )
p	    WRITE (9,9400) DELTA_TIME_1, CHARGES( CRG_BY )
9400	    FORMAT (' Work Done by Systems Personnel'6X,A17,7X'$'F11.2)
8	    LINE_COUNT = LINE_COUNT + 1
	ENDIF
 
d!	Compute and print total charges for this call.
	T1=0
,	T2=0
	DO 20 I = 1, CHARGE_END
	    T1 = T1 + CHARGES(I)
X	    T2 = T2 + ACHARGES(I)
20	CONTINUE
 	WRITE (9,9500) T1, T2
9500	FORMAT ( '+' 60X,12('_') 25X,12('_') /
	1	'0'7X'Total Charges:'T62'$'F11.2, 25X'$'F11.2 )
L
	LINE_COUNT = LINE_COUNT + 15

x	RETURN

@	END

d 	SUBROUTINE GET_ACC_NAME( ACCOUNT, ACCOUNT_NAME )
 
,!++
!
!   TITLE: GET_ACC_NAME		Returns name string for given ACCOUNT
X!				value.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	Searches ACCOUNTS table for ACCOUNT, then sets ACCOUNT_NAME to
!	corresponding entry in ACCOUNT_NAMES.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!	Ralph Weber (25-OCT-1980) Cleanup documentation.
4!
!--
!++
`	!
	!   FUNCTIONAL DESCRIPTION:
(
!

!	This routine searches the ACCOUNTS table for the value of the

!	input parameter, ACCOUNT.  If it is found, the output parameter,
T!	ACCOUNT_NAME is set equal to the character string found in the
!	corresponding position of the table, ACCOUNT_NAMES.  If it is
!	not found, the output parameter is set to blank.
!
!   CALLING SEQUENCE:
H
!

!	CALL GET_ACC_NAME( ACCOUNT.rt.ds, ACCOUNT_NAME.wt.ds )
!
t!   INPUT PARAMETERS:
!
<!	ACCOUNT.rt.ds	is the account number the corresponding name
!			for which will be returned.
!
h!   OUTPUT PARAMETERS:
!
0!	ACCOUNT_NAME.wt.ds is the returned account name string.
!
!   IMPLICIT INPUTS:
\!
!	ACCOUNTS	is contained in /CHARGE_TABLES/ and is an array
$!			of all valid Cyclotron Institute account
!			numbers.
!
P!	ACCOUNT_NAMES	is contained in /CHARGE_TABLES/ and is an array
!			of account name strings corresponding to the
!			account numbers in ACCOUNTS.
|!
!	LAST_ACCOUNT	is contained in /CHARGE_COUNTERS/ and it's
D!			value is the maximum number of entries in
!			ACCOUNTS and ACCOUNT_NAMES.
!
p!   IMPLICIT OUTPUTS: None.
!
8!   COMPLETION STATUS: Normal return.
!
 !   SIDE EFFECTS: None.
d!
!--
,
	CHARACTER*(*) ACCOUNT, ACCOUNT_NAME

X	CHARACTER*8  ACCOUNTS(50)
	CHARACTER*80 ACCOUNT_NAMES(50)
 	COMMON /CHARGE_TABLES/ ACCOUNTS, ACCOUNT_NAMES

	COMMON /CHARGE_COUNTERS/ K, KK, LAST_ACCOUNT

d !	Search ACCOUNTS table for ACCOUNT. 
 	DO 10 I = 1, LAST_ACCOUNT
,	IF (ACCOUNT .EQ. ACCOUNTS(I)) THEN
	    ACCOUNT_NAME = ACCOUNT_NAMES(I) ! Found it.
	    RETURN
X	ENDIF
10	CONTINUE
 	ACCOUNT_NAME = ' ' ! Did not find it.
	RETURN
	END

d 	SUBROUTINE GET_GRP_NAME( GRP_UIC, GROUP_NAME )
 
,!++
!
!   TITLE: GET_GRP_NAME		Returns name string for given group UIC.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	Uses given group portion of UIC to search IGROUP_UICS table,
!	then sets GROUP_NAME to the corresponding entry in the
!	GROUP_NAMES table.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!	Ralph Weber (25-OCT-1980) Cleanup documentation.
4!
!--
!++
`	!
	!   FUNCTIONAL DESCRIPTION:
(
!

!	The routine uses the input parameter, GRP_UIC, which is the

!	group portion of the UIC, to search the IGROUP_UICS table.
T!	When a match is found, the output parameter, GROUP_NAME, is set
!	equal to the string in the GROUP_NAMES table corresponding to
!	the UIC's location in the IGROUP_UICS table.  If no match is
!	found a string of blanks is returned.
!
H
!   CALLING SEQUENCE:

!
!	CALL GET_GRP_NAME( GRP_UIC.rw.r, GROUP_NAME.wt.ds )
t!
!   INPUT PARAMETERS:
<!
!	GRP_UIC.rw.r	is the group portion of a UIC for which a name
!			string will be returned.
h!
!   OUTPUT PARAMETERS:
0!
!	GROUP_NAME.wt.ds is the returned group name string.
!
\!   IMPLICIT INPUTS:
!
$!	IGROUP_UICS	is contained in /CHARGE_ITABLES/ and is an
!			of all valid Cyclotron Institute group numbers.
!
P!	GROUP_NAMES	is contained in /CHARGE_TABLES/ and is an array
!			of group name strings corresponding to the
!			group numbers in IGROUP_UICS.
|!
!	LAST_GROUP	is contained in /CHARGE_COUNTERS/ and it's
D!			value is the maximum number of entries in
!			IGROUP_UICS and GROUP_NAMES.
!
p!   IMPLICIT OUTPUTS: None.
!
8!   COMPLETION STATUS: Normal return.
!
 !   SIDE EFFECTS: None.
d!
!--
,
	INTEGER*2 GRP_UIC
	CHARACTER*(*) GROUP_NAME
X
	CHARACTER*8  C(50)
 	CHARACTER*80 CC(50), GROUP_NAMES(50)
	COMMON /CHARGE_TABLES/ C, CC, GROUP_NAMES
	INTEGER*2 IGROUP_UICS(50)
L	COMMON /CHARGE_ITABLES/ IGROUP_UICS

	COMMON /CHARGE_COUNTERS/ K, KK, KKK, LAST_GROUP

d !	Search UIC table for GRP_UIC.
 	DO 10 I = 1, LAST_GROUP
,	    IF (GRP_UIC .EQ. IGROUP_UICS(I)) THEN
		GROUP_NAME = GROUP_NAMES(I) ! Found it.
		RETURN
X	    ENDIF
10	CONTINUE
 	GROUP_NAME = ' ' ! Did not find it.
	RETURN
	END

d 	INTEGER*4 FUNCTION LEN_STRING( STRING )
 
,!++
!
!   TITLE: LEN_STRING		Returns length of input string from
X!				first character to first trailing blank.
!
 !   FACILITY: BILLING SYSTEM
!
!   ABSTRACT:	
L!
!	The length of the input string, less its trailing blanks, is
!	determined and returned in LEN_STRING.
x!
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
@!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
!
l!   MODIFIED BY:
!	Ralph Weber (25-OCT-1980) Cleanup documentation.
4!
!--
!++
`	!
	!   FUNCTIONAL DESCRIPTION:
(
!

!	The length of the input string is determined using LEN.  The

!	input string is then examined starting with it's last character
T!	and proceeding to the first.  When a non-blank character is
!	reached, LEN_STRING is set to its position.  If the string
!	contains all blanks, then LEN_STRING is set to 1.
!
!   CALLING SEQUENCE:
H
!

!	LENGTH = LEN_STRING( STRING.rt.ds )
!
t!   INPUT PARAMETERS:
!
<!	STRING.rt.ds	is the string whose length minus trailing
!			blanks is to be found.
!
h!   OUTPUT PARAMETERS:
!
0!	LEN_STRING.wl.v	is the length (trailing blanks not included) of
!			STRING.
!
\!   IMPLICIT INPUTS: None.
!
$!   IMPLICIT OUTPUTS: None.
!
!   COMPLETION STATUS: Normal return.
P!
!   SIDE EFFECTS: None.
!
|!--

D	CHARACTER *(*) STRING

d !	Determine length of input string.
 	LENGTH = LEN(STRING)
,
!	Starting at the end, find the first non-blank character.
	DO 10 I = LENGTH, 1, -1
X	IF (STRING(I:I) .NE. ' ') THEN
		LEN_STRING = I ! Found it.
 		RETURN
	ENDIF
10	CONTINUE
L	LEN_STRING = 1	! String is all blanks.
	RETURN
	END

d 	LOGICAL FUNCTION NEW_PAGE( LINES_MUST_HAVE )
 
,!++
!
!   TITLE: NEW_PAGE		If needed, skips to new print page.
X!
!   FACILITY: BILLING SYSTEM
 !
!   ABSTRACT:	
!
L!	If there are fewer than LINES_MUST_HAVE remaining on the
!	current page, this routine causes a skip to new page, zeros
!	the line count, and sets NEW_PAGE to .TRUE.  Otherwise,
x!	NEW_PAGE is set to .FALSE.
!
@!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-JUN-1980.
l!
!   MODIFIED BY:
4!	Ralph Weber (25-OCT-1980) Changed to NEW_PAGE and lines left
!		check added.  Setup for future use of system lines
!		per page utility.  Documentation updated.
`	!
	!--
(
!++

!

!   FUNCTIONAL DESCRIPTION:
T!
!	Upon first entry, this routine determines the number of lines
!	on a page.
!
!	On the first and every other entry, LINES_MUST_HAVE is compared
H
!	with the number of lines remaining on the current page.  If

!	LINES_MUST_HAVE lines remain, NEW_PAGE is set to .FALSE. and
!	the routine is exited.  If not, a new page will be started
t!	providing the printed output is not already at the top of
!	a page.  The new page is started by writing a page eject line
<!	to the print file: LINE_COUNT is zeroed at this time.  If the
!	paper is at the top of a page upon exit, NEW_PAGE is set to
!	.TRUE.
h!
!   CALLING SEQUENCE:
0!
!	MADE_NEW_PAGE.wlu.v = NEW_PAGE( LINES_MUST_HAVE.rl.r )
!
\!   INPUT PARAMETERS:
!
$!	LINES_MUST_HAVE.rl.r	is the number of lines which must
!				remain on the current page.
!
P!   OUTPUT PARAMETERS:
!
!	MADE_NEW_PAGE.rlu.v	is set .TRUE. if a new page was
|!				required and .FALSE. if not.
!
D!   IMPLICIT INPUTS:
!	
!	LINE_COUNT	located in /CHARGE_COUNTERS/, this value is
p!			updated to reflect lines added to the print
!			file by this routine.  It is used to keep track
8!			of the current position on a page and to make
!			decisions regarding when a new page should be
 !			started.
d!
!   IMPLICIT OUTPUTS: See IMPLICIT INPUTS.
,!
!   COMPLETION STATUS: Normal return.
!
X!   SIDE EFFECTS: See IMPLICIT INPUTS.
!
 !--

	COMMON /CHARGE_COUNTERS/ LINE_COUNT
L
	LOGICAL*1 FIRST_ENTRY
	DATA FIRST_ENTRY / .TRUE. /

d !	If first entry, get lines per page.
 	IF (FIRST_ENTRY)  THEN
,	    LINES_PER_PAGE = 63
	    FIRST_ENTRY = .FALSE.
	ENDIF
X
!	Check lines remaining on this page.
 	IF ( (LINE_COUNT + LINES_MUST_HAVE) .GT. LINES_PER_PAGE )  THEN

	    ! Must have new page, if not already at page top.
L	    IF (LINE_COUNT .NE. 0)  THEN
		WRITE (9,9000)
9000		FORMAT ( '1' )
x		LINE_COUNT = 0
	    ENDIF
@
	ENDIF

l	NEW_PAGE = LINE_COUNT .EQ. 0

4	RETURN
	END

d 	SUBROUTINE  MY_ASCTIM (TIMEBUFFER,INTIME)
 
,!++
!
!   TITLE: MY_ASCTIM		Converts 64-bit binary time to ASCII
X!				string.
!
 !   FACILITY: BILLING SYSTEM 
!
!   ABSTRACT: 
L!
!	This routine converts a quadword time to a character string
!	containing days/date and time.
x!
!   ENVIRONMENT: Runs in any mode. Not AST re-entrant.
@!
!   AUTHOR: Ralph Weber		CREATION DATE: DEC-1980
!
l!   MODIFIED BY: Kathy Rodriguez on 29-MAY-1980.
!
4!	1) Changed name from MY$ASCTIM to MY_ASCTIM.
!
!	Ralph Weber (21-OCT-1980) setup checking for zero valued
`	!		input quadword time and return of '00:00' if found.
	!
(
!--

!++

!
T!   FUNCTIONAL DESCRIPTION:
!
!	This routine converts a 64-bit (quadword) time  to either days
!	and time (for delta or negative time) or to date and time (for
!	absolute or positive time) in a character string of length 11,
H
!	17, or 24.  The length is determined by the length of the

!	TIMEBUFFER parameter.  If the input quadword is zero, '00:00'
!	is returned in the right most character positions of TIMBUFFER.
t!
!   CALLING SEQUENCE:
<!
!	CALL MY_ASCTIM ( TIMEBUFFER.wt.ds, INTIME.rq.r )
!
h!   INPUT PARAMETERS:
!
0!	INTIME.rq.r	is the quadword (INTEGER*4 INTIME(2)) which
!			contains the delta (negative) or absolute
!			(positive) time to be converted.
\!
!   OUTPUT PARAMETERS:
$!
!	TIMEBUFFER.wt.ds is the character string which contains the
!			converted time.  It may be 11, 17, or 24
P!			characters in length, as determined by the
!			calling program.  It's contents will be 1) days
!			and time when INTIME is a delta time, 2) date
|!			and time when INTIME is an absolute time,
!			and 3) date when INTIME is an absolute time and
D!			the length of TIMEBUFFER is 11, 4) '00:00' in
!			right most positions whenever INTIME is zero.
!   IMPLICIT INPUTS:
p!
!	The length of TIMEBUFFER is passed to the routine and governs
8!	the contents of the output string, TIMEBUFFER.
!
 !   IMPLICIT OUTPUTS: None.
d!
!   COMPLETION STATUS:
,!
!	If an error occurs in the conversion, the output string,
!	TIMEBUFFER, will contain asterisks.
X!
!   SIDE EFFECTS: None.
 !
!--

L	IMPLICIT INTEGER*4 (A-Z)
	CHARACTER*(*) TIMEBUFFER
	INTEGER*4 INTIME(2)

d 	IF (INTIME(1) .NE. 0 .OR. INTIME(2) .NE. 0)  THEN
 	    STATUS=SYS$ASCTIM(,TIMEBUFFER,INTIME,%VAL(0))
,	    IF (.NOT.STATUS)  TIMEBUFFER = '************************'
	ELSE
	    TIMEBUFFER = ' '
X	    TIMEBUFFER( LEN(TIMEBUFFER)-5: ) = '00:00 '
	ENDIF
 	RETURN
	END
