d !++
 !
,!   TITLE: PREBILL.FOR		Creates monthly billing files for each month.
!
!   FACILITY:  BILLING SYSTEM
X!
!   ABSTRACT:	
 !	This program creates and/or adds to billing files which contain
!	records comprised of information from the ACCOUNTNG.DAT and
!	SYSUAF.DAT files, along with some information entered on
L!	the terminal.  These output files will later be used to produce
!	billing reports.
!
x!   ENVIRONMENT:  Requires system UIC or equivalent.   Not AST re-entrant.
!
@!   AUTHOR:  Kathy Rodriguez	CREATION DATE: 29-MAY-1980
!
!   MODIFIED BY:
l!
!--
4!++
!
!   FUNCTIONAL DESCRIPTION:
`	!
	!	The program processes ACCOUNTNG.DAT files as specified by the user 
(
!	to produce PREBILL.MMM.YYYY files.  There is one output file created 

!	or appended to for each month (MMM) and each year (YYYY).

!	The output files are comprised of information from the SYSUAF.DAT
T!	file and the ACCOUNTNG.DAT file in addition to some information
!	entered on the terminal.
!		The SYSUAF.DAT file is used to create tables for the
!	USERNAME, OWNER, and UIC.  ACCOUNTS.DAT is used to create a table of
!	valid account numbers.  These tables are used to verify information
H
!	found in ACCOUNTNG.DAT.  When the information is not found or is invalid,

!	then quieries are made of the user to supply this information.
!
t!   IMPLICIT INPUTS: 
!
!	UAFDEF.FOR, ACCDEF.FOR, and BILLDEF.FOR are the necessary parameter
!	files.
!
!	The file [BILLING]NODES.DAT contains the names of the
<!	possible nodes used by the billing system.
n!
!	The file [BILLING]ACCOUNTS.DAT contains the valid accounts.
!
h!   IMPLICIT OUTPUTS:
!
!	PREBILL.MMM;NNNN, the file containing the billing records, is created
0!	or appended to if the file is in existence.
!		MMM is the month and YYYY is the year.
!
!   SIDE EFFECTS:
!
$!	See IMPLICIT OUTPUTS.
!
!--
P!++
!
!	TABLE OF CONTENTS
|!
!	Routine							SOS page
D!
!	Main (Processes accounting files)			2
!	GET_FILE_INFO (accepts INPUT_FILE and MACHCODE)		3
p!	BUILD_TABLES (Builds USERNAME, OWNER, UIC, and 
!		ACCOUNT tables)					4
8!	ACCUMULATE_DATA (Calls routines which get and move
!		data for each record type to the output buffer)	5
 !	CHECK_USER_INFO (Gets and moves USERNAME,UIC,ACCOUNT,
d!		and OWNER for all types of records)		6
!	LOGIN_FAILURE (Moves data for login failure type)	7
,!	PRINT_TYPE (Moves data for print records)		8
!	BAT_OR_PROC_TYPE (Moves data for BATCH or interactive
!		and non-interactive record types)		9
X!	CHANGE_INFO (Changes data for a work-done-by-a-system-
!		person record)					10
 !	BUILD_BOOT (Moves data for a boot record)		11
!	ZERO_BUFFER (Zeroes the output buffer, BILL_RECORD)	12
!	OUT_DEVICE (Opens and assigns output files and unit
L!		numbers)					13
!	CLOSE_FILES (Closes all output files which were opened)	14
!	MY_ASCTIM (Converts a quadword time to a character
x!		string)						15
!
@!

d !++
 !
,!   TITLE: Main routine		Controls the processing of ACCOUNTNG.DAT files.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	The main routine calls the subroutines necessary to process accounting
!	files produced by the VAX 11/780.
L!
!   ENVIRONMENT: Requires a system UIC or equivalent.  Not AST re-entrant.
!
x!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
!
@!   MODIFIED BY:
!
!--
l!++
!
4!   FUNCTIONAL DESCRIPTION:
!
!	The main routine calls GET_FILE_INFO, which asks for and opens the
`	!	input accounting file.  Then BUILD_TABLES is called to build the
	!	tables which will be needed to verify some of the input data and
(
!	provide additional information needed for the output record.  Several

!	steps are taken for each record read from the input file.  First,

!	the output buffer, BILL_RECORD, is zeroed, except for bytes 1-9.
T!	Second, ACCUMULATE_DATA is called to move all the data from the 
!	input buffer, ACC_RECORD, from the tables, and from any necessary
!	inquiries of the user, to the output buffer.  BAD_RECORD is a flag
5!	which indicates that a record is bad.  Such flagged records are ignored.
N!	The output record is then written on the output file refered to by the 
!	FUNCTION, OUT_DEVICE.  The output file is opened by the function if 
!	it has not already been opened.
a
!
!	If the processing of the input record caused the flag to be set which
t!	signal the end of a boot, then BUILD_BOOT is called to re-build the
!	output buffer for a boot-type record.  If the flag indicating
<!	that a system user performed the task which produced the input
!	accounting record (Pnn or Nnn in last 3 characters of USERNAME),
!	then CHANGE_INFO is called to change only those fields affecting
h!	this special type of record.  In either case, another output record 
!	is written on the output device.
0!
!	Afer all records for the input file have been processed, then the
!	user may enter another file to be processed.  If the user enters
\!	# to indicate that there are no more files to process, then
!	CLOSE_FILES is called to close all output files which were opened
$!	during the execution of the program.
!
!
P!   IMPLICIT INPUTS: See documentation at the beginning of this file.
!
!   IMPLICIT OUTPUTS:
|!
!	The routine creates or appends to files named PREBILL.MMM.YYYY.
!	The number of bad records skipped is displayed at the end of the
+!	processing of an input file.
D!
!   SIDE EFFECTS:
!	See IMPLICIT OUTPUTS.
>!
p!
!--
8!
!	PREBILL.FOR main routine
 !
d	PARAMETER VERSION = 1.0
	LOGICAL*1  FIRST_FILE,ACQUISITION,BAD_RECORD,
,	1BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON
	INTEGER*4  OUT_DEVICE,UICS(1024),TERMTIME(2),DOWN_TIME(2),
	1UP_TIME(2),BOOT_TIME(2),LAST_LOGOUT(2)
X	CHARACTER INPUT_FILE*19, OWNERS(1024)*20, USERNAMES(1024)*12,
	1ACCOUNTS(100)*8,SAVE_USERNAME(100)*10,SAVE_ACCOUNT(100)*8
 !
!	COMMON blocks
!	
L	COMMON/PREBILL_T_TABLES/ OWNERS,USERNAMES,ACCOUNTS,SAVE_USERNAME,
	1SAVE_ACCOUNT
	COMMON/PREBILL_L_TABLES/ UICS,LAST_ENTRY,LAST_ACCOUNT,LAST_SAVE
x	COMMON/PREBILL_FLAGS/ BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,
	1ACQUISITION,BAD_RECORD
@	COMMON/PREBILL_OPEN/ NUM_OPEN
	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME,ACC_RECORD
 	COMMON/PREBILL_BOOT/ DOWN_TIME,UP_TIME,BOOT_TIME,LAST_LOGOUT
l 	DATA NUM_OPEN/0/
 	INCLUDE 'CYC$LIBRARY:ACCDEF.FOR/NOLIST'
4!	INCLUDE '[BILLING]BILLDEF.FOR'
!!
!!
`"	FIRST_FILE=.TRUE.
"1	CONTINUE		!File processing loop
(#	BOOT_SEQ=.FALSE.	!Set logical flags to .FALSE.
#	BEGIN_BOOT = .FALSE.
#	SYSTEM_PERSON = .FALSE.
T$	END_BOOT = .FALSE.
$	ACQUISITION = .FALSE.
%	BAD_RECORD = .FALSE.
%	BILL_F_VERSION = VERSION	!Move version to output buffer
%	CALL GET_FILE_INFO (INPUT_FILE,BILL_T_MACHCODE)	!Enter file info
H&	IF (INPUT_FILE(1:1).EQ.'#') GO TO 99999		!End of processing
z&	NUM_BAD_REC=0		!Set bad record counter to zero.
&	IF (FIRST_FILE) THEN	!Build tables for USERNAMES,UICS,OWNERS
'	    CALL BUILD_TABLES
t'	    FIRST_FILE=.FALSE.
'	ENDIF
<(2	CONTINUE		!Read loop
(	CALL ZERO_BUFFER	!Zero buffer, except for VERSION & MACHCODE
)	READ (3,9100,END=9999) ACC_RECORD	!Read input file record
h)9100	FORMAT (164A1)
)	CALL ACCUMULATE_DATA		!Gather data for output record
0*	IF (BAD_RECORD) THEN		!Skip if a bad record
*	    BAD_RECORD = .FALSE.
*	    NUM_BAD_REC=NUM_BAD_REC+1	!Add 1 to number of bad records
*	    GO TO 2
\+	ENDIF
+	IF (BEGIN_BOOT) THEN		!Do not write a record for the
$,	    BEGIN_BOOT=.FALSE.		!beginning of a boot sequence.
,	    GO TO 2			!Set flags and read another record
,	ENDIF
P-!
-!	Write output record.  Device is opened if it is closed.
.	WRITE (OUT_DEVICE(TERMTIME),9200) (BILL_RECORD(J),J=0,
|.	1BILL_W_MSGSIZ-1)
.9200	FORMAT (<BILL_W_MSGSIZ>A1)
D/	IF (BOOT_SEQ.AND.END_BOOT) THEN		!Build and write boot record
/	    CALL BUILD_BOOT
0	    END_BOOT=.FALSE.			!Reset flags
p0	    BOOT_SEQ=.FALSE.
0	    WRITE (OUT_DEVICE(TERMTIME),9200) (BILL_RECORD(J),J=0,
81	1   BILL_W_MSGSIZ-1)
1	ENDIF
 2	IF (SYSTEM_PERSON) THEN			!Create and write record
d2	    CALL CHANGE_INFO			!for system person who has
2	    SYSTEM_PERSON=.FALSE.		!used FOR.
,3	    WRITE (OUT_DEVICE(TERMTIME),9200) (BILL_RECORD(J),J=0,
3	1   BILL_W_MSGSIZ-1)
3	ENDIF
X4	GO TO 2		!Go to read another ACC record
49999	CONTINUE	!End of input file
 5	IF (BOOT_SEQ) THEN	!If in the middle of a boot seq, output
5	    UP_TIME(1) = TERMTIME (1)	!a boot record.
5	    UP_TIME(2) = TERMTIME (2)
L6	    CALL BUILD_BOOT
6	    WRITE (OUT_DEVICE(TERMTIME),9200) (BILL_RECORD(J),J=0,
7	1   BILL_W_MSGSIZ-1)
x7	ENDIF
7	CLOSE (UNIT=3)
8	TYPE *,'There were ',NUM_BAD_REC,' bad records skipped during ',
'8	1' this run.'
@8	GO TO 1		!Ask if there is another file to be processed
899999	CONTINUE	!No more files- end of run
9	CALL CLOSE_FILES
l9	STOP
9	END

d !++
 !
,!   TITLE: GET_FILE_INFO	Inquires for input file name and machine code.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	The routine opens the file as specified by the user and checks for
!	the validity of the machine code as specified by the user.
L!
!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
x!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
!
@!   MODIFIED BY:
!
!--
l!++
!
4!   FUNCTIONAL DESCRIPTION:
!
!	The routine first prompts the user for an INPUT_FILE to be opened.
.	!	The routine opens the file defined by INPUT_FILE.
`	!	If the file does not exist, the routine issues an error message and
	!	prompts again.  Then the MACHINE_CODE is requested.  The file
(
!	[BILLING]NODES.DAT is searched to check the validity of the code.

!	An error message is issued and the prompt is repeated if the code

!	is invalid.
T!
!   CALLING SEQUENCE:
!
!	CALL GET_FILE_INFO (INPUT_FILE,MACHINE_CODE)
!
H
!   INPUT PARAMETERS: None.

!
!   OUTPUT PARAMETERS:
t!
!	INPUT_FILE	is the name of the accounting file to be processed.
<!
!	MACHINE_CODE	is the node name of the computer the accounting file
!			came from.  MACHINE_CODE is moved to BILL_T_MACHCODE
6!			in the output buffer, BILL_RECORD.
h!
!   IMPLICIT INPUTS:
0!
!	[BILLING]NODES.DAT is the file used to test the validity of the
!		MACHINE_CODE as specified by the user.
\!
!   IMPLICIT OUTPUTS: None.
$!
!   COMPLETION STATUS: Normal return.
!
P!   SIDE EFFECTS: None.
!
!--
|	SUBROUTINE GET_FILE_INFO (INPUT_FILE,MACHINE_CODE)
	CHARACTER INPUT_FILE*20,MACHINE_CODE*6,NODE_NAME*6
D!
!	Ask for input file name. (must have file type)
1	TYPE 9000,'Name of file to be processed (# to exit):'
p	ACCEPT 9100,INPUT_FILE
9000	FORMAT (1X,A,$)
8	IF (INPUT_FILE(1:1).EQ.'#')  RETURN	!If #, then RETURN
	IF (INDEX(INPUT_FILE,'.').EQ.0)  THEN	!Check for the presence
 	    TYPE *,'**ERROR - FILE NAME MUST HAVE A FILE TYPE' !of type
d	    GO TO 1
	ENDIF
,!
!	Open input file.
	OPEN (UNIT=3,NAME=INPUT_FILE,TYPE='OLD',ERR=800) 
X!
!	Open nodes file
 	OPEN (UNIT=4,NAME='DRA0:[BILLING]NODES.DAT',TYPE='OLD',READONLY)
2	TYPE 9000,'Machine code (node name):'
	ACCEPT 9100,MACHINE_CODE
L3	READ (4,9100,END=801) NODE_NAME	!Read node name file
9100	FORMAT (A)
	IF (MACHINE_CODE.EQ.NODE_NAME) THEN	!Check validity of node name
x	    CLOSE (UNIT=4)
	    RETURN
@	ENDIF
	GO TO 3
 801	TYPE *,'**ERROR - MACHINE CODE INVALID - RE-ENTER CODE'
l 	REWIND 4
 	GO TO 2
4!800	TYPE *,'**ERROR WHILE OPENING INPUT FILE - RE-ENTER'
!	GO TO 1
!	END

d !++
 !
,!   TITLE: BUILD_TABLES		Builds tables for USERNAME, UIC, OWNER, etc.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	The routine reads the SYSUAF.DAT file to build tables for USERNAME,
!	UIC, and OWNER.  The file [BILLING]ACCOUNT.DAT is read to build the
L!	ACCOUNTS table.
!
!   ENVIRONMENT: Requires a system UIC or equivalent.  Not AST re-entrant.
x!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
@!
!   MODIFIED BY:
!
l!--
!++
4!
!   FUNCTIONAL DESCRIPTION:
!
`	!	This routine reads the SYSUAF.DAT file and builds the tables USERNAMES,
	!	UICS, and OWNERS.  The file [BILLING]ACCOUNT.DAT is read to build
(
!	the table ACCOUNTS.  As the SYSUAF.DAT file is read, when the USERNAME

!	is SYSTEM, the SAVE_ACCOUNT and SAVE_USERNAME tables are started

!	by assigning the SYSTEM account to the first three slots in the 
T!	SAVE_ACCOUNT table and assiging the names 'SYSTEM', 'FIELD', and
!	'SYSTEST' to the corresponding slots in SAVE_USERNAME.  These last
!	tables will be checked if an invalid ACCOUNT is encountered in the
!	input file.
!
H
!   CALLING SEQUENCE:

!
!	CALL BUILD_TABLES
t!
!   INPUT PARAMETERS: None.
<!
!   OUTPUT PARAMETERS: None.
!
h!   IMPLICIT INPUTS:
!
0!	[SYSEXE]SYSUAF.DAT is the file which is read to build the USERNAMES,
!		UICS, and OWNERS tables.
!
\!	[BILLING]ACCOUNT.DAT is the file which is read to build the ACCOUNTS
!		table.
$!
!   IMPLICIT OUTPUTS:
!
P!	PREBILL_T_TABLE is the named COMMON which contains the tables:
!
!		OWNERS - which contains the OWNER names for the accounts
!
!		USERNAMES - which contains the USERNAMEs.
J!
|!		ACCOUNTS - which contains the valid account values.
!
!		SAVE_USERNAME - which contains the USERNAMES added to the
D!			program and the SYSTEM names.
v!
!		SAVE_ACCOUNT - 	which contains the ACCOUNTs for the USERNAMEs
!			added to the program and the SYSTEM accounts.
p!
!	PREBILL_L_TABLE is the named COMMON which contains:
!
8!		UICS - which contains the UICs for the users on the system.
!
 !		LAST_ENTRY - which is the number of entries in the
d!			USERNAMES, UICS, or OWNERS tables.
!
!		LAST_ACCOUNT - which is the number of entries in the ACCOUNTS
,!			table.
^!
!		LAST_SAVE - which is the number of entries in the SAVE_ACCOUNT
!			and SAVE_USERNAME tables.
X!
!   COMPLETION STATUS: Normal return.
 !
!   SIDE EFFECTS:
!
L!	See IMPLICIT OUTPUTS.
!
!--
x	SUBROUTINE BUILD_TABLES
	CHARACTER  OWNERS(1024)*20,USERNAMES(1024)*12,
@	1ACCOUNTS(100)*8,SAVE_USERNAME(100)*10,SAVE_ACCOUNT(100)*8
	INTEGER*4 UICS(1024)
 !
l !	COMMON blocks
 !
4!	COMMON/PREBILL_T_TABLES/ OWNERS,USERNAMES,ACCOUNTS,SAVE_USERNAME,
!	1SAVE_ACCOUNT
!	COMMON/PREBILL_L_TABLES/ UICS,LAST_ENTRY,LAST_ACCOUNT,LAST_SAVE
`"	INCLUDE 'CYC$LIBRARY:UAFDEF.FOR/NOLIST'
"!
(#!
#	LAST_ENTRY=0
#	OPEN (UNIT=2,NAME='DRA0:[SYSEXE]SYSUAF.DAT',TYPE='OLD',
T$	1READONLY,CARRIAGECONTROL='NONE')
$1	CONTINUE		!Read UAF loop
%	READ (2,9000,END=999) UAF_RECORD
%9000	FORMAT (<UAF$K_LENGTH>A1)
%	LAST_ENTRY=LAST_ENTRY+1	!Increment and test for max entries
H&	IF (LAST_ENTRY.GT.1024) STOP ' More than 1024 entries in UAF'
&	IF (UAF_T_OWNER(1:3).EQ.'***') THEN	!Get rid of stars 
'	    OWNERS(LAST_ENTRY)=UAF_T_OWNER(5:20)
t'	ELSE
'	    OWNERS(LAST_ENTRY) = UAF_T_OWNER	!Add record data to tables
<(	ENDIF
(	USERNAMES(LAST_ENTRY) = UAF_T_USERNAME
)	UICS(LAST_ENTRY) = UAF_L_UIC
h)	IF (UAF_T_USERNAME.EQ.'SYSTEM      ') THEN	!Save account for
)	    DO 3 I=1,3					!SYSTEM,FIELD,and
0*		SAVE_ACCOUNT(I) = UAF_T_ACCOUNT		!SYSTEST.
*3	    CONTINUE
*	    SAVE_USERNAME(1) = 'SYSTEM'
\+	    SAVE_USERNAME(2) = 'FIELD'
+	    SAVE_USERNAME(3) = 'SYSTEST'
$,	    LAST_SAVE = 3
,	ENDIF
,	GO TO 1		!Go read another UAF record
P-999	CLOSE (UNIT=2)		!End of UAF 
-	OPEN (UNIT=2,NAME='DRA0:[BILLING]ACCOUNTS.DAT',
.	1TYPE='OLD',READONLY)
|.	LAST_ACCOUNT=1
.2	IF (LAST_ACCOUNT.GT.100) 
D/	1STOP 'No more room in ACCOUNTS array'
/	READ (2,*,END=9999) ACCOUNTS(LAST_ACCOUNT)
0	LAST_ACCOUNT=LAST_ACCOUNT+1
p0	GO TO 2
09999	LAST_ACCOUNT=LAST_ACCOUNT-1
81	CLOSE (UNIT=2)
1	RETURN
 2	END

d !++
 !
,!   TITLE: ACCUMULATE_DATA	Get and move data for all message types.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	Subroutines are called to move the data appropriate for each message
!	type from the input buffer, ACC_RECORD, to the output buffer,
L!	BILL_RECORD.  TERMTIME is set equal to the termination time of the 
~!	input record.  TERMTIME is later used to determine the output file 
!	the record is to be written on.  Flags are set to indicate that a 
 !	system person did the work or that a boot sequence is beginning,
x!	in process, or ending.
!
@!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
l!
!   MODIFIED BY:
4!
!--
!++
`	!
	!   FUNCTIONAL DESCRIPTION:
	!
	!	This routine calls the routines necessary to get the data needed for
	!	each message type and move it into the output buffer, BILL_RECORD.
	!	TERMTIME is a quadword variable containing the time value associated
	!	with the current record being processed.  It will be used by the
	!	main routine to determine which output file the record will be 
	!	written into.  
	!
	!	The first task the routine performs is to take care of login failure
	!	and the beginning of a boot sequence via the routine LOGIN_FAILURE
	!	and an internal routine.  Next, CHECK_USER_INFO is called
	!	to verify some of the input data and get additional information
	!	for the output record.  If the current record is bad, the routine
	!	RETURNs to the main routine.  Next, the message type value of a
	!	print type record is set to 4.  The message type is incremented if
	!	the accounting record indicated that a system person did the work
	!	or that data acquisition was responsible for the record.  Finally,
	!	the routine PRINT_TYPE or BAT_OR_PROC_TYP is called, depending on
	!	the value of MSGTYP.  The flag END_BOOT is set if the current record
	!	indicated that a boot sequence has ended.  LAST_LOGOUT is set
	!	equal to the termination time to be saved for a future end-of-boot
	!	record.
(
!

!   CALLING SEQUENCE:

!
T!	CALL ACCUMULATE_DATA
!
!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS: None.
H
!

!   IMPLICIT INPUTS:
!
t!	PREBILL_FLAGS is the named COMMON which contains the following flags
!			used as input.
<!		BOOT_SEQ is the flag which indicates that a boot sequence
!			is in progress.
!
h!		SYSTEM_PERSON is the flag which indicates that a system person
!			performed the work.  If it is set to .TRUE., the 
!			MSGTYP is incremented by 40.
!
!		ACQUISITION is the flag which indicates that the record was
\!			created during acquisition.  If it is set to .TRUE.,
!			the MSGTYP is incremented by 20.
$!
!		BAD_RECORD is the flag indicating that an accounting record
!			is bad, probably due to a blank USERNAME.
!
P!	NUM_SYS_PER is the variable contained in the named COMMON, 
!		PREBILL_SYSPER, which is used by CHECK_USER_INFO to note
!		the position in the tables for the system person who did
|!		work for another user.
!
D!	ACC_RECORD is the input buffer containing the accounting record to
!		be processed.  ACC_RECORD is contained in the named COMMON,
!		PREBILL_RECORD.
p!
!	PREBILL_T_TABLES is the named COMMON which contains character tables
8!		such as USERNAME, OWNER, ACCOUNTS, etc., which are passed
!		on to subroutines which use them to verify data or acquire
 !		data.
d!
!	PREBILL_L_TABLES is the named COMMON which contains integer tables
,!		table, UIC, and INTEGER variables, LAST_ENTRY, LAST_ACCOUNT,
!		and LAST_SAVE, which point to the last entries in various
!		tables.
X!
!	PREBILL_BOOT is the named COMMON which contains quadword variables
 !		which contain times for boot sequences.
!
!		UP_TIME is the time the boot sequence ends.
L!
!		DOWN_TIME is the time the boot sequence begins.
!
x!		BOOT_TIME is the time the boot sequence begins also.
!
@!		LAST_LOGOUT is the termtime of the last record processed.
!			UP_TIME is set equal to this value when the end of
 !				the boot sequence is reached.
l !
 !
4!!   IMPLICIT OUTPUTS:
6!!
8!!	PREBILL_RECORD is the named COMMON which contains these two entities
:!!		which are affected by this routine.
<!!
>!!		BILL_RECORD is the output buffer to which all data fields
@!!			are moved.
B!!
D!!		TERMTIME is the quadword which contains the time the input
F!!			accounting record was terminated.
H!!
J!!	PREBILL_FLAGS is the named COMMON which contains flags to indicate
L!!		various things.
N!!		
P!!		BEGIN_BOOT is set to indicate that a boot sequence is starting
R!!			with the current record.
T!
V!!		END_BOOT is set to indicate that the current accounting 
X!!			record signaled the end of a boot sequence.
Z!!
\!!		BOOT_SEQ is set if a boot sequence is commencing also.
^!!
`!!	PREBILL_BOOT is a named COMMON. See IMPLICIT INPUTS for description
b!!		of contents.
d!!
"!   COMPLETION STATUS: Normal return.
(#!
#!   SIDE EFFECTS:
#!
T$!	See IMPLICIT OUTPUTS.
$!
%!--
%	SUBROUTINE ACCUMULATE_DATA
%	CHARACTER*17 ELAPSED_TIM_BUF,ACCOUNTS(100)*8,SAVE_USERNAME(100)*10,
H&	1SAVE_ACCOUNT(100)*8
&	LOGICAL*1 BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,ACQUISITION,
'	1BAD_RECORD
t'	INTEGER*4 TERMTIME(2),ELAPSED_TIME(2),LAST_LOGOUT(2),
'	1DOWN_TIME(2),BOOT_TIME(2),UP_TIME(2)
<(	CHARACTER  OWNERS(1024)*20,USERNAMES(1024)*12
(	INTEGER*4 UICS(1024)
)!
h)!	COMMON blocks
)!
0*	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME,ACC_RECORD
*	COMMON/PREBILL_FLAGS/ BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,
*	1ACQUISITION,BAD_RECORD
\+	COMMON/PREBILL_T_TABLES/ OWNERS,USERNAMES,ACCOUNTS,SAVE_USERNAME,
+	1SAVE_ACCOUNT
$,	COMMON/PREBILL_L_TABLES/ UICS,LAST_ENTRY,LAST_ACCOUNT,LAST_SAVE
,	COMMON/PREBILL_BOOT/ DOWN_TIME,UP_TIME,BOOT_TIME,LAST_LOGOUT
,	COMMON/PREBILL_SYSPER/NUM_SYS_PER
P-	INCLUDE 'CYC$LIBRARY:ACCDEF.FOR/NOLIST'
-	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
.!
|.!	Take care of login failure first
.	IF (ACC_W_MSGTYP.EQ.4) THEN
D/	    CALL LOGIN_FAILURE
/	    GO TO 20
0	ENDIF
p0!
0!	Determine if it is the beginning of a boot sequence
81	IF (ACC_W_MSGTYP.EQ.1.AND.ACC_T_USERNAME.EQ.'SYSTEM      ') THEN
1	    CALL SUBQUAD (ACC_Q_LOGIN,ACC_Q_TERMTIME,ELAPSED_TIME)
 2	    CALL MY_ASCTIM (ELAPSED_TIM_BUF,ELAPSED_TIME)
d2	    IF (ELAPSED_TIM_BUF(1:3).NE. '   ') THEN	
2	        IF (BOOT_SEQ) THEN !If already in a boot sequence, ignore record
,3		    BEGIN_BOOT = .TRUE.
3		    RETURN
3	        ELSE
X4  		    BOOT_SEQ = .TRUE.
4		    BEGIN_BOOT = .TRUE.
 5		    DO 1 I=1,2
5			DOWN_TIME(I) = LAST_LOGOUT(I)
5			BOOT_TIME (I) = ACC_Q_TERMTIME(I)
L6			IF (DOWN_TIME(I).EQ.0)
6	1		    DOWN_TIME(I)=BOOT_TIME(I)
71		    CONTINUE
x7		    RETURN
7		ENDIF
@8	    ENDIF
8	ENDIF
9!
l9!	Not a boot sequence - continue
910	CONTINUE
4:	CALL CHECK_USER_INFO	!Get username, etc
:	IF (BAD_RECORD) RETURN 	!Skip if a bad record
:	IF (ACC_W_MSGTYP.EQ.16) ACC_W_MSGTYP=4 !Reset print type to 4
`;!
;!	Compute message type
(<	IF (ACQUISITION) THEN
<	    ACQUISITION = .FALSE.	!Reset flag
<	    BILL_W_MSGTYP = ACC_W_MSGTYP + 60
T=	ELSE IF (SYSTEM_PERSON) THEN
=	         BILL_W_MSGTYP = ACC_W_MSGTYP + 20
>	ELSE
>	     BILL_W_MSGTYP = ACC_W_MSGTYP
>	ENDIF
H?	IF (ACC_W_MSGTYP.EQ.4) THEN
?	    CALL PRINT_TYPE		!Transfer print info
@	ELSE
t@	    CALL BAT_OR_PROC_TYP	!Transfer data for other types
@	ENDIF
<A!
A!	Test for end of boot sequence
B20	IF (BILL_W_GRP.GT.'10'O .AND. BOOT_SEQ) THEN
hB	    END_BOOT=.TRUE.
B	    UP_TIME(1) = LAST_LOGOUT(1)
0C	    UP_TIME(2) = LAST_LOGOUT(2)
C	ENDIF
C	DO 30 I=1,2
\D	    LAST_LOGOUT(I)=ACC_Q_TERMTIME(I)
D	    TERMTIME(I) = ACC_Q_TERMTIME(I)
$E30	CONTINUE
E	RETURN
E	END

d !++
 !
,!   TITLE: CHECK_USER_INFO		Gets correct user information.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
!
!	The routine examines the input data, verifies it, asks for corrections
!	if necessary, and locates additional information to go along with
!	the input data, such as UIC and OWNER.
 !
!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
L!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
!
!   MODIFIED BY:
x!
!--
@!++
!
!   FUNCTIONAL DESCRIPTION:

!
!	This routine checks the incoming data, adds to it and sets any
!	necessary flags.  
!
!	The first 10 characters of the USERNAME is used to verify itself.
!	If the last two characters of ACC_T_USERNAME are non-blank, then
!	the last character of USERNAME is set to a blank.
!
!	The USERNAMES table is searched for USERNAME.  If USERNAME is not
!	in the table, then prompts are made for the UIC, OWNER, and ACCOUNT
!	of the user.  The responses are checked for syntax and then put into
 !	the tables.  LAST_ENTRY is incremented by one.  The USERNAME, UIC,
"!	and OWNER are moved to the output buffer.  
$!
&!	The ACCOUNTS and the SAVE_ACCOUNT tables are searched for ACCOUNT.  
'!	If ACCOUNT is not in the table, a prompt is made for a valid account.  
(!	The response is also verified and added to the SAVE_ACCOUNT table.
*!	The corresponding USERNAME is put into the SAVE_USERNAME table.
,!	LAST_SAVE is incremented by one.  The ACCOUNT is then moved into
.!	the output buffer.  
0!
2!	If characters 10 thru 12 of the USERNAME is ACQ, then the ACQUISITION
4!	flag is set.
6!
8!	If the 10th character is an N or P and the 11th and 12th form a 
:!	two-digit number, then the accounting record is one for work done
<!	by a system person.  The SYSTEM_PERSON flag is set and the UIC
>!	for the system person is formed from the last two characters in the
@!	USERNAME.  The UICS table is searched until the system person UIC
B!	is found.  The pointer, NUM_SYS_PER, is set equal to the entry number
D!	of the UIC in the table.
l!
!   CALLING SEQUENCE:
!
!	CALL CHECK_USER_INFO
4!
!   INPUT PARAMETERS: None.
!
`	!   OUTPUT PARAMETERS: None.
	!
(
!   IMPLICIT INPUTS:
*
!
,
!	ACC_RECORD is the accounting record input buffer contained in the
.
!		named COMMON, PREBILL_RECORD.  It contains the USERNAME,UIC
0
!		and ACCOUNT needed by this routine.
2
!
4
!	PREBILL_L_TABLES is the named COMMON which contains the UICS table
6
!		used to supply the UIC for the input record and the table
8
!		pointers:
:
!	
<
!		LAST_ENTRY - points to the last entry made in USERNAMES,UICS,
>
!			and OWNERS tables.
@
!
B
!		LAST_ACCOUNT - points to the last entry made in the ACCOUNTS
D
!			table.
F
!
H
!		LAST_SAVE - points to the last entry made in the SAVE_ACCOUNT
J
!			and SAVE_USERNAME tables.
L
!
N
!	PREBILL_T_TABLES is the named COMMON which contains the character tables:
P
!
R
!		USERNAMES - used to verify the input USERNAME.
T
!
V
!		OWNERS - used to get OWNER name of input record.
X
!
Z
!		ACCOUNTS - used to verify ACCOUNT of input record.
\
!
^
!		SAVE_USERNAME - also used to verify ACCOUNT.  If the ACCOUNT
`
!			is not found in ACCOUNTS, then the SAVE_USERNAME
b
!			table is searched.  If the USERNAME is found, then
d
!			the valid ACCOUNT for the record is the corresponding
f
!			entry in SAVE_ACCOUNT.
h
!
j
!		SAVE_ACCOUNT - used to get a valid account for a USERNAME
l
!			found in SAVE_USERNAME.

!

!   IMPLICIT OUTPUTS:

!

!	BILL_RECORD is the output record buffer contained in the named COMMON,

!		PREBILL_RECORD.  It is the buffer to which the USERNAME, UIC,

!		OWNER,  and ACCOUNT are moved.

!

!	PREBILL_L_TABLES is the named COMMON which contains the UICS table,

!		which can be added to, and the pointers, which can be incremented.
 !		See IMPLICIT INPUTS for detailed descriptions.
!
!	PREBILL_T_TABLES is the named COMMON which contains the tables; 
!		USERNAMES, OWNERS, SAVE_USERNAME, and SAVE_ACCOUNT, which can 
!		be added to.
	!
!	PREBILL_FLAGS is the named COMMON which contains the flags:

!
!		BAD_RECORD, which is set when the USERNAME is blank.
!
!		ACQUISITION, which is set when the last three characters
!			of ACC_T_USERNAME are 'ACQ'.
!
!		SYSTEM_PERSON, which is set when the last three characters
!			of ACC_T_USERNAME are 'Nnn' or 'Pnn', where nn is
!			a 2-digit integer.  The flag indicates that a system
!			person did the work which produced the input record.
T!
!   COMPLETION STATUS: Normal return.
!
!   SIDE EFFECTS:
!
!	See IMPLICIT OUTPUTS.
!
H
!--

	SUBROUTINE CHECK_USER_INFO
	CHARACTER INPUT_FILE*19, OWNERS(1024)*20, USERNAMES(1024)*12,
t	1ACCOUNT*8,USERNAME*10,UIC_STRING*20,OWNER*20,
	2BLANK*8,ACCOUNTS(100)*8,SAVE_USERNAME(100)*10,SAVE_ACCOUNT(100)*8
<	INTEGER*4 UICS(1024),TERMTIME(2),SYS_PER_UIC
	INTEGER*2 UIC_ARRAY(2)
	LOGICAL*1 BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,ACQUISITION,
h	1BAD_RECORD
!
0!	COMMON blocks
!
	COMMON/PREBILL_T_TABLES/ OWNERS,USERNAMES,ACCOUNTS,SAVE_USERNAME,
\	1SAVE_ACCOUNT
	COMMON/PREBILL_L_TABLES/ UICS,LAST_ENTRY,LAST_ACCOUNT,LAST_SAVE
$	COMMON/PREBILL_FLAGS/ BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,
	1ACQUISITION,BAD_RECORD
	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME,ACC_RECORD
P	COMMON/PREBILL_SYSPER/NUM_SYS_PER
	INCLUDE 'CYC$LIBRARY:ACCDEF.FOR/NOLIST'
	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
|	DATA BLANK /'        '/
	EQUIVALENCE (SYS_PER_UIC,UIC_ARRAY)
D!
!
	USERNAME = ACC_T_USERNAME (1:10)
p	IF (ACC_T_USERNAME(11:12).NE.'  ') USERNAME (10:10) = ' '
!
8!	Check table for USERNAME
	IF (USERNAME.EQ.'          ') THEN	!If no username,it is a 
 	    BAD_RECORD = .TRUE.			!bad record.
d	    RETURN
	ENDIF
,	DO 1 I=1,LAST_ENTRY
	    IF (USERNAME.EQ.USERNAMES(I)) THEN	!Search table for name
		BILL_T_OWNER = OWNERS(I)
X		BILL_L_UIC = UICS(I)
		BILL_T_USERNAME = USERNAME
 		GO TO 20
	    ENDIF
1	CONTINUE
L9200	FORMAT (1X,A,A,A,$)
9100	FORMAT (A)
3	TYPE 9200,'UIC for -',USERNAME,'- [xxx,xxx]:'
x	ACCEPT 9100,UIC_STRING
	BEGIN_NUM = INDEX (UIC_STRING,'[')+1
@	END_NUM = INDEX (UIC_STRING,',')-1
	LEN = END_NUM - BEGIN_NUM +1
 	IF (LEN.LE.0.OR.LEN.GT.3) GO TO 5
l 	DECODE (LEN,9300,UIC_STRING,ERR=5) BILL_W_GRP
 9300	FORMAT (O<LEN>)
4!	BEGIN_NUM = END_NUM + 2
!	END_NUM = INDEX (UIC_STRING,']')-1
!	IF (END_NUM.LE.0) END_NUM = INDEX(UIC_STRING,' ')-1
`"	IF (END_NUM.LE.0) END_NUM=20
"	LEN = END_NUM - BEGIN_NUM + 1
(#	IF (LEN.LE.0.OR.LEN.GT.3) GO TO 5
#	DECODE (LEN,9300,UIC_STRING(BEGIN_NUM:END_NUM),ERR=5) BILL_W_MEM
#	GO TO 10
T$5	TYPE *,'**ERROR - Syntax error in UIC, please re-enter'
$  	GO TO 3
%10	TYPE 9200,'OWNER for -',USERNAME,'- (up to 20 characters):'
%	ACCEPT 9100,OWNER
%	IF (OWNER.EQ.BLANK) THEN
H&	    TYPE *,'**ERROR - OWNER is blank'
&	    GO TO 10
'	ENDIF
t'	LAST_ENTRY = LAST_ENTRY+1	!Add info to tables
'	IF (LAST_ENTRY.GT.1024) STOP 'More than 1024 entries in table'
<(	UICS(LAST_ENTRY) = BILL_L_UIC
(	USERNAMES(LAST_ENTRY) = USERNAME
)	OWNERS(LAST_ENTRY)= OWNER
h)	BILL_T_OWNER = OWNER	!Move info into output buffer
r)
|) 
)	BILL_T_USERNAME = USERNAME
*20	CONTINUE	!Good USERNAME - Check for no ACCOUNT
*	DO 25 J=1,LAST_ACCOUNT
\+	IF (ACC_T_ACCOUNT.EQ.ACCOUNTS(J)) THEN	!Check validity of account
+	    BILL_T_ACCOUNT = ACC_T_ACCOUNT
$,	    GO TO 30
,	ENDIF
,25	CONTINUE
P-	DO 26 J=1,LAST_SAVE
-	    IF (USERNAME.EQ.SAVE_USERNAME(J)) THEN	!Check saved names
.		BILL_T_ACCOUNT = SAVE_ACCOUNT(J)
|.		GO TO 30
.	    ENDIF
D/26	CONTINUE
/22	TYPE 9200,'ACCOUNT for -',USERNAME,'- (up to 8 characters):'
0	ACCEPT 9100,ACCOUNT
 2	DO 28 J=1,LAST_ACCOUNT		!Check for validity of account
d2	    IF (ACCOUNT.EQ.ACCOUNTS(J)) THEN
2		BILL_T_ACCOUNT = ACCOUNT
,3		LAST_SAVE = LAST_SAVE + 1	!Try to add to save table
3		IF (LAST_SAVE.GT.100) THEN	!Issue a warning if full
3		    TYPE *,'**WARNING - SAVE TABLES ARE FULL'
X4		    LAST_SAVE = LAST_SAVE -1
4		ELSE
 5		    SAVE_USERNAME(LAST_SAVE) = USERNAME
5		    SAVE_ACCOUNT(LAST_SAVE) = ACCOUNT
5		ENDIF
L6	    	GO TO 30
6	    ENDIF
728	CONTINUE
x7	GO TO 22
7
7
730	CONTINUE
@8	IF (ACC_T_USERNAME(11:12).NE.'  ') THEN	!Set flags where needed
8	    IF (ACC_T_USERNAME(10:12).EQ.'ACQ') THEN
9		ACQUISITION = .TRUE.
l9	    ELSE IF (ACC_T_USERNAME(10:10).EQ.'P'.OR.
9	1	     ACC_T_USERNAME(10:10).EQ.'N') THEN
4:		     DECODE (2,9400,ACC_T_USERNAME(11:12),ERR=40) 
:	1		UIC_ARRAY(1)
:9400		     FORMAT (O2)
:	 	     SYSTEM_PERSON = .TRUE.
;		     IF (ACC_T_USERNAME(10:10).EQ.'P') THEN
(<			UIC_ARRAY(2) = '17'O
<		     ELSE
<			UIC_ARRAY(2) = '20'O
T=		     ENDIF
=		     DO 35 I=1,LAST_ENTRY
>			IF (UICS(I).EQ.SYS_PER_UIC) GO TO 36
>35		     CONTINUE
>		     STOP 'System person UIC not found in UIC file'
H?36		     NUM_SYS_PER = I
?	    ENDIF
@	ENDIF
t@40	RETURN
@	END

d !++
 !
,!   TITLE: LOGIN_FAILURE	Moves information for login failure record to buffer.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	Data for login failures is moved to the output file.
!
L!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
x!
!   MODIFIED BY:
@!
!--
!++
l!
!   FUNCTIONAL DESCRIPTION:
4!
!	The routine moves data for MSGTYP = -1 (login failures) to output
!	buffer.  The only field of the ACC_RECORD used is the termination
`	!	time, ACC_Q_TERMTIME.
	!
(
!   CALLING SEQUENCE:

!

!	CALL LOGIN_FAILURE
T!
!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS: None.
!
H
!   IMPLICIT INPUTS:

!
!	ACC_RECORD	is the input buffer, contained in the named COMMON,
t!		PREBILL_RECORD.  It contains the termination time
!		moved to the output buffer.
<!
!   IMPLICIT OUTPUTS:
!
h!	PREBILL_RECORD	is the named COMMON which contains :
!		BILL_RECORD	the output buffer to which information is
0!				moved.

!
\!   COMPLETION STATUS: Normal return.
!
$!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
!
!--
P	SUBROUTINE LOGIN_FAILURE
	INTEGER*4 TERMTIME(2)
!
|!	COMMON blocks
!
D	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME,ACC_RECORD
	INCLUDE 'CYC$LIBRARY:ACCDEF.FOR/NOLIST'
	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
p!
!
8	BILL_W_MSGTYP=-1		!Move data to output buffer
	BILL_W_MSGSIZ=36
 	BILL_W_MEM = '401'O
d	BILL_W_GRP = '401'O
	BILL_T_USERNAME = 'LOGFAIL'
,	BILL_Q_TERMTIME(1) = ACC_Q_TERMTIME (1)
	BILL_Q_TERMTIME(2) = ACC_Q_TERMTIME (2)
	RETURN
X	END

d !++
 !
,!   TITLE: PRINT_TYPE		Moves information for print type record to buffer.
!
!   FACILITY: BILLING SYSTEM 
X!
!   ABSTRACT:	
 !
!	Data fields from the accounting record are moved to the output buffer
!	as needed for a print record.
L!
!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
x!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
!
@!   MODIFIED BY:
!
!--
l!++
!
4!   FUNCTIONAL DESCRIPTION:
!
!	The routine moves the print record information to the output buffer.
`	!	BILL_RECORD, from the input record, ACC_RECORD.  If the record to
	!	be output is for a system user who did work for another user, then
(
!	two additional fields, BILL_T_PRT_BY and BILL_L_PRTB_UIC, are moved

!	to the output buffer.

!	The MACRO routine SUBQUAD is used to subtract two quadwords to compute

!	delay time.

!
T!   CALLING SEQUENCE:
!
!	CALL PRINT_TYPE
!
!   INPUT PARAMETERS: None.
H
!

!   OUTPUT PARAMETERS: None.
!
t!   IMPLICIT INPUTS:
!
<!	ACC_RECORD	is the input buffer, contained in the named COMMON, 
!		 	PREBILL_RECORD.  It contains data fields to be moved 
!			to the output buffer for the print type record.
h!
!	OWNERS		is the table of OWNER names from which the OWNER 
0!			name of the system user is taken.  OWNERS is contained
!			in the named COMMON, PREBILL_T_TABLES.
!
\!	UICS		is the table of UICs from which the UIC for the 
!			system user is taken.  UICS is contained in the 
$!			named COMMON, PREBILL_L_TABLES.
!
!	SYSTEM_PERSON	is the logical flag which indicates that the record
!			to be output next is a record for a system user to
!			indicate what work he did for another user.
P!
!   IMPLICIT OUTPUTS:
!
|!	BILL_RECORD	is the output buffer which contains the print type
!			information to be output.  It is contained in the
D!			named COMMON, PREBILL_RECORD.
!
!   COMPLETION STATUS:
p!
!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
8!
!--
 	SUBROUTINE PRINT_TYPE
d	INTEGER*4 TERMTIME(2),UICS(1024)
	LOGICAL*1 BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON
,	CHARACTER  OWNERS(1024)*20
!
!	COMMON blocks
X!
	COMMON/PREBILL_FLAGS/ BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON
	COMMON/PREBILL_T_TABLES/ OWNERS
	COMMON/PREBILL_L_TABLES/ UICS
L	COMMON/PREBILL_SYSPER/NUM_SYS_PER
	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME,ACC_RECORD
	INCLUDE 'CYC$LIBRARY:ACCDEF.FOR/NOLIST'
x	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
!
@!
	BILL_L_PAGCNT = ACC_L_PAGCNT
 	BILL_L_QIOCNT = ACC_L_QIOCNT
l 	BILL_L_GETCNT = ACC_L_GETCNT
 	BILL_T_PRT_QUE = ACC_T_PRT_QUE(2:ICHAR(ACC_T_PRT_QUE(1:1))+1)
4!	CALL SUBQUAD (ACC_Q_QUETIME,ACC_Q_TERMTIME,BILL_Q_DELAYTIM)
!	BILL_Q_TERMTIME(1) = TERMTIME(1)
!	BILL_Q_TERMTIME(2) = TERMTIME(2)
`"	BILL_T_PRT_NAME = ACC_T_PRT_NAME
"	IF (SYSTEM_PERSON) THEN
(#	    BILL_W_MSGSIZ = 128
#	    BILL_T_PRT_BY = OWNERS(NUM_SYS_PER)
#	    BILL_L_PRTB_UIC = UICS(NUM_SYS_PER)
T$	ELSE
$	    BILL_W_MSGSIZ=104
%	ENDIF
%	RETURN
%	END

d !++
 !
,!   TITLE: BAT_OR_PROC_TYP	Moves information for batch or process types.
!
!   FACILITY: BILLING SYSTEM 
X!
!   ABSTRACT:	
 !
!	The routine moves information to the output buffer, BILL_RECORD, 
!	based on the message type and whether a system user did the operation.
L!
!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
x!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
!
@!   MODIFIED BY:
!
!--
l!++
!
4!   FUNCTIONAL DESCRIPTION:
!
!	This routine moves information to the output buffer, BILL_RECORD,
`	!	for Non-INTeractive process, BatCH, and INTeractive process accounting
	!	records (MSGTYP equals 1,2,and 3, respectively).  The type of record
(
!	record governs the information moved to the output buffer.  If a

!	system user performed the operation which created the accounting

!	record, additional information (system OWNER and system UIC) is moved
T!	to the output buffer.
!
!   CALLING SEQUENCE:
!
!	CALL BAT_OR_PROC_TYP
H
!

!   INPUT PARAMETERS: None.
!
t!   OUTPUT PARAMETERS: None.
!
<!   IMPLICIT INPUTS:
!
0!	OWNERS is the table contained in the named COMMON, PREBILL_T_TABLES,
2!		from which the system user OWNER name is taken.
4!
!	UICS is the table contained in the named COMMON, PREBILL_L_TABLES,
!		from which the system user UIC is taken.
!
\!	PREBILL_FLAGS is the named COMMON which contain logical variables
!		which function as flags, one of which is SYSTEM_PERSON.
$!		If SYSTEM_PERSON is set to .TRUE., then the OWNER and UIC
!		for the system user doing the work is added to the output
!		buffer.
P!
!	PREBILL_SYSPER is the named COMMON which contains the variable,
!		NUM_SYS_PER, whose value points to the location in the tables 
!			where the information for the system user is found.
D!
!	PREBILL_RECORD is the named COMMON which contains the buffer for the
!		input record, ACC_RECORD.  Most of the information moved
p!		to the output buffer, BILL_RECORD, comes from this buffer.
!
8!   IMPLICIT OUTPUTS:
!
 !	PREBILL_RECORD is the named COMMON which contains the buffer for
d!		the output record, BILL_RECORD.  Information is moved to
!		this buffer for output.  
!
X!   COMPLETION STATUS: Normal return.
!
 !   SIDE EFFECTS: See IMPLICIT OUTPUTS.
!
!--
L	SUBROUTINE BAT_OR_PROC_TYP
	INTEGER*4 TERMTIME(2),UICS(1024)
	LOGICAL*1 BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,ACQUISITION
x	CHARACTER  OWNERS(1024)*20
!
@!	COMMON blocks
!
 	COMMON/PREBILL_T_TABLES/ OWNERS
l 	COMMON/PREBILL_L_TABLES/ UICS
 	COMMON/PREBILL_SYSPER/NUM_SYS_PER
4!	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME,ACC_RECORD
!	COMMON/PREBILL_FLAGS/ BEGIN_BOOT,END_BOOT,BOOT_SEQ,SYSTEM_PERSON,
!	1ACQUISITION
`"	INCLUDE 'CYC$LIBRARY:ACCDEF.FOR/NOLIST'
"	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
(#!
#!	Move data into record
#	BILL_F_CPUTIM = FLOAT(ACC_L_CPUTIM)/100.
T$	BILL_L_PAGEFLTS = ACC_L_PAGEFLTS
$	BILL_L_PGFLPEAK = ACC_L_PGFLPEAK
%	BILL_L_WSPEAK = ACC_L_WSPEAK
%	BILL_L_BIOCNT = ACC_L_BIOCNT
%	BILL_L_DIOCNT = ACC_L_DIOCNT
H&	BILL_L_VOLUMES = ACC_L_VOLUMES
t'	BILL_Q_TERMTIME(1) = ACC_Q_TERMTIME(1)
'	BILL_Q_TERMTIME(2) = ACC_Q_TERMTIME(2)
<(	IF (ACC_W_MSGTYP.EQ.3) THEN	!Compute time for interactive  job
(	    CALL SUBQUAD (ACC_Q_LOGIN,ACC_Q_TERMTIME,BILL_Q_CONNECT)
)	    IF (SYSTEM_PERSON) THEN
h)		BILL_W_MSGSIZ = 124
)		BILL_T_INT_BY = OWNERS (NUM_SYS_PER)
0*		BILL_L_INTB_UIC = UICS(NUM_SYS_PER)
*	    ELSE
*		BILL_W_MSGSIZ = 100
\+	    ENDIF
+	ELSE IF (ACC_W_MSGTYP.EQ.2) THEN
$,		BILL_T_JOB_QUE=ACC_T_JOB_QUE(2:ICHAR(ACC_T_JOB_QUE(1:1))+1)
,	    IF (SYSTEM_PERSON) THEN
,		BILL_W_MSGSIZ = 140
P-		BILL_T_BCH_BY = OWNERS (NUM_SYS_PER)
-		BILL_L_BCHB_UIC = UICS(NUM_SYS_PER)
.	    ELSE
|.		BILL_W_MSGSIZ = 116
.	    ENDIF
D/	    BILL_T_JOB_NAME = ACC_T_JOB_NAME
/	ELSE IF (SYSTEM_PERSON) THEN
p0	    BILL_W_MSGSIZ = 116
0	    BILL_T_NINT_BY = OWNERS(NUM_SYS_PER)
81	    BILL_L_NINB_UIC = UICS(NUM_SYS_PER)
1	ELSE
 2	    BILL_W_MSGSIZ = 92
2	ENDIF
,3	RETURN
3	END

d !++
 !
,!   TITLE: CHANGE_INFO		Changes info in BILL_RECORD to system user. 
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	Portions of the output buffer, BILL_RECORD are changed so the record
!	contains information referring to the system user who did work for
L!	another account.
!
!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
x!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
@!
!   MODIFIED BY:
!
l!--
!++
4!
!   FUNCTIONAL DESCRIPTION:
!
`	!	This routine changes the UIC, USERNAME, OWNER, ACCOUNT, MSGTYP, and
	!	the FOR information (OWNER and UIC) for the specific message type
(
!	in BILL_RECORD.  In this way, a record is created which shows the

!	work done by a system user for another user.  The message type is

!	always 21, 24, 23, or 24.
T!
!   CALLING SEQUENCE:
!
!	CALL CHANGE_INFO
!
H
!   INPUT PARAMETERS: None.

!
!   OUTPUT PARAMETERS: None.
t!
!   IMPLICIT INPUTS:
<!
!	PREBILL_T_TABLES is the named COMMON which contains the character
!		tables USERNAMES and OWNERS from which the USERNAME and
h!		OWNER for the system user are taken.
!
0!	PREBILL_L_TABLES is the named COMMON which contains the UICS table
!		from which the UIC for the system user is taken.
!
\!	PREBILL_SYSPER	is the named COMMON which contains the variable,
^!
!		NUM_SYS_PER, which is the variable whose value points to
$!			the location in the tables where the information
!			for the system user is located.
!
P!	PREBILL_RECORD	is the named COMMON which contains the output buffer,
R!
!		BILL_RECORD, which contains the OWNER and UIC of the user
!			for which the work was done.
|!
!   IMPLICIT OUTPUTS:
D!
!	PREBILL_RECORD	is the named COMMON which contains the output buffer,
!
!		BILL_RECORD, which will contain the changed information to
p!			be output to the proper unit.  The items in BILL_RECORD
!			which are changed are:
!
8!			BILL_T_OWNER	the OWNER name for the system user
:!
!			BILL_T_USERNAME the USERNAME for the system user
!
 !			BILL_L_UIC	the UIC for the system user
!
d!			BILL_T_ACCOUNT	the ACCOUNT for the system user
f!
!			BILL_W_MSGTYP	the message type (21,24,23,or 24)
!
,!			BILL_T_XXXX_FOR which is the OWNER name for the 
!				user the work was done for. XXXX is NINT for
!				MSGTYP = 1, BCH  for MSGTYP = 2, INT for
X!				MSGTYP = 3, and PRT for MSGTYP = 4.
Z!
!			BILL_L_XXXX_UIC which is the UIC for the user the 
 !				work was done for.  XXXX is NINF for MSGTYP = 1,
!				BCHF for MSGTYP = 2, INTF for MSGTYP = 3,
!				and PRTF for MSGTYP = 4.
L!
!   COMPLETION STATUS: Normal return.
!
x!   SIDE EFFECTS: See IMPLICIT OUTPUTS.
!
@!--
	SUBROUTINE CHANGE_INFO
 	CHARACTER INPUT_FILE*19, OWNERS(1024)*20, USERNAMES(1024)*12
l 	INTEGER*4 UICS(1024)
 !
4!!	COMMON block
!!
!	COMMON/PREBILL_RECORD/ BILL_RECORD
`"	COMMON/PREBILL_SYSPER/NUM_SYS_PER
"	COMMON/PREBILL_T_TABLES/ OWNERS,USERNAMES
(#	COMMON/PREBILL_L_TABLES/ UICS
#	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
#!
T$!
$	IF (BILL_W_MSGTYP.EQ.21) THEN
%	    BILL_T_NINT_FOR = BILL_T_OWNER
%	    BILL_L_NINF_UIC = BILL_L_UIC
%	ELSE IF (BILL_W_MSGTYP.EQ.22) THEN
H&	    BILL_T_BCH_FOR = BILL_T_OWNER
&	    BILL_L_BCHF_UIC = BILL_L_UIC
'	ELSE IF (BILL_W_MSGTYP.EQ.23) THEN
t'	    BILL_T_INT_FOR = BILL_T_OWNER
'	    BILL_L_INTF_UIC = BILL_L_UIC
<(	ELSE IF (BILL_W_MSGTYP.EQ.24) THEN
(	    BILL_T_PRT_FOR = BILL_T_OWNER
)	    BILL_L_PRTF_UIC = BILL_L_UIC
h)	ENDIF
)	BILL_T_OWNER = OWNERS(NUM_SYS_PER)
0*	BILL_T_USERNAME = USERNAMES(NUM_SYS_PER)
*	BILL_L_UIC = UICS(NUM_SYS_PER)
*	BILL_T_ACCOUNT = '21235COM'
\+	BILL_W_MSGTYP = BILL_W_MSGTYP + 20
+	RETURN
$,	END

d !++
 !
,!   TITLE: BUILD_BOOT		Builds the boot record.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	The record with message type equal to -2 (for a boot) is built.
!
L!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez	CREATION DATE: 29-MAY-1980.
x!
!   MODIFIED BY:
@!
!--
!++
l!
!   FUNCTIONAL DESCRIPTION:
4!
!	This routine moves the information for a boot record to the output
!	buffer, BILL_RECORD, which is in the named COMMON, PREBILL_RECORD.
`	!	The message type is set to -2.  The message size is 44.  The UIC
	!	is [400,400].  The USERNAME is SYSBOOT.  SUBQUAD is a MACRO routine
(
!	called to computed DOWNTIME by subtracting the two quadwords, 

!	DOWN_TIME and UP_TIME.

!
T!   CALLING SEQUENCE:
!
!	CALL BUILD_BOOT
!
!   INPUT PARAMETERS: None.
H
!

!   OUTPUT PARAMETERS: None.
!
t!   IMPLICIT INPUTS:
!
<!	PREBILL_BOOT	is the named COMMON which contains the quadwords
!			for use in computing downtime.
!
h!		UP_TIME		is the quadword which is the time the system
!				came back up.
0!		DOWN_TIME	is the quadword which is the time the system
!				went down.
!		BOOT_TIME	is the quadword which is the time the boot
\!				began (same as DOWN_TIME).
!
$!   IMPLICIT OUTPUTS:
!
!	PREBILL_RECORD	is the named COMMON which contains the buffer to be
P!			filled and the termination time quadword.
!		BILL_RECORD	is the BYTE array to which values are moved.
!		TERMTIME	is the quadword which will designate which
|!				output file the output buffer, BILL_RECORD
!				will be written on.
D!
!   COMPLETION STATUS: Normal return.
!
p!   SIDE EFFECTS:  See IMPLICIT OUTPUTS.
!
8!--
	SUBROUTINE BUILD_BOOT
 	INTEGER*4 DOWN_TIME(2),UP_TIME(2),BOOT_TIME(2),TERMTIME(2)
d!
!	COMMON blocks
,!
	COMMON/PREBILL_RECORD/ BILL_RECORD,TERMTIME
	COMMON/PREBILL_BOOT/DOWN_TIME,UP_TIME,BOOT_TIME
X	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
!
 !	Move information for boot record
	BILL_W_MSGTYP = -2
	BILL_W_MSGSIZ = 44
L	BILL_W_MEM = '400'O
	BILL_W_GRP = '400'O
	BILL_T_USERNAME ='SYSBOOT'
x	CALL SUBQUAD (DOWN_TIME,UP_TIME,BILL_Q_DOWNTIME)
	DO 1 I=1,2
@	    BILL_Q_BOOTTIME(I) = BOOT_TIME(I)
	    TERMTIME(I) = BOOT_TIME (I)
 1	CONTINUE
l 	RETURN
 	END

d !++
 !
,!   TITLE: ZERO_BUFFER		Zeroes the BILL_RECORD output buffer.
!
!   FACILITY:  BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	Bytes 10 thru 139 of BILL_RECORD are set to zero.
!
L!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez		CREATION DATE: 29-MAY-1980.
x!
!   MODIFIED BY:
@!
!--
!++
l!
!   FUNCTIONAL DESCRIPTION:
4!
!	This routine sets bytes 10 thru 139 of the BYTE array, BILL_RECORD
!	to zero.  Bytes 1 thru 9 contain VERSION and MACHINE_CODE.
`	!
	!   CALLING SEQUENCE:
(
!

!	CALL ZERO_BUFFER

!
T!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS: None.
!
!   IMPLICIT INPUTS:
H
!

!	BILL_RECORD 	is contained in the named COMMON, PREBILL_RECORD.
!			It is the array to be zeroed.
t!
!   IMPLICIT OUTPUTS:
<!
!	BILL_RECORD 	is the BYTE array which is found in the named COMMON,
!			PREBILL_RECORD.  It is the array which is zeroed.
h!
!   COMPLETION STATUS: Normal return.
0!
!   SIDE EFFECTS:
!
\!	BILL_RECORD is zeroed from bytes 10 thru BILL_K_LENGTH-1.
!
$!--
	SUBROUTINE ZERO_BUFFER
	BYTE ZERO
P	DATA ZERO/'00'O/
!
!	COMMON blocks
|!
	COMMON/PREBILL_RECORD/BILL_RECORD
	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
D!
!
	DO 1 I=10,BILL_K_LENGTH-1
p	BILL_RECORD(I)=ZERO
1	CONTINUE
8	RETURN
	END

d !++
 !
,!   TITLE: FUNCTION OUT_DEVICE		Opens output file based on quadword time.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	The function determines the name of the output file and opens it
!	if it is not already open.
L!
!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
x!   AUTHOR: Kathy Rodriguez		CREATION DATE: 29-MAY-1980.
!
@!   MODIFIED BY:
!
!--
l!++
!
4!   FUNCTIONAL DESCRIPTION:
!
!	This function uses a 64-bit time value to determine the name of
`	!	the file to be used and opens it if it has not already been opened.
	!	The routine, MY_ASCTIM is called to convert the time value to an
(
!	ASCII string.  The month and year are extracted to from the name of

!	the file to be used.  The file name created is of the form :

!		
T!		PREBILL.MMM.YYYY
!
!	MMM is the 3-character month and YYYY is the year.
!	The array OPEN_FILES is searched to find if the file is already open.
!	If the file is open, the unit number corresponding to the file is
H
!	set equal to OUT_DEVICE.  If it is not open, NUM_OPEN is incremented

!	by one and NUM_OPEN+10 is the unit number assigned to OUT_DEVICE.
!	The file name is also saved in the array OPEN_FILES.
t!
!	The file is opened with the following statement:
<!
!	OPEN (UNIT=OUT_DEVICE,NAME=file-name,TYPE='UNKNOWN',ACCESS='APPEND',
!	1CARRIAGECONTROL='NONE',RECORDTYPE='VARIABLE',RECORDSIZE=BILL_K_LENGTH)
h!
!	NOTE: If the file exists, it is opened to be appended to.
0!
!   CALLING SEQUENCE:
!
\!		iunit = OUT_DEVICE (TERMTIME)
!
$!	or	WRITE (OUT_DEVICE(TERMTIME),...
!
!   INPUT PARAMETERS:
P!
!	TERMTIME 	an INTEGER*4 array of dimension 2 which contains
!			the quadword time value used to determine the file
|!			name of the file to be opened.
!
D!   OUTPUT PARAMETERS:
!
!	OUT_DEVICE	is the INTEGER*4 function variable which is the unit
p!			number of the file to be opened.
!
8!   IMPLICIT INPUTS:
!
 !	NUM_OPEN	is contained in the named COMMON, PREBILL_OPEN.
!			It's value is equal to the number of opened output
!			files.
!
,!   IMPLICIT OUTPUTS:
!
!	NUM_OPEN	is incremented by one if the file was not already
X!			open.
!
 !   COMPLETION STATUS:
!
!	The program will be terminated if the attempt is made to open
L!	more than 17 files at a time.
!
!   SIDE EFFECTS:
x!
!	See IMPLICIT OUTPUTS.
@!
!--
 	INTEGER*4 FUNCTION OUT_DEVICE(TERMTIME)
l 	CHARACTER*19 OUT_FILE,OPEN_FILES(17),OUT_TIME_BUF*24
 	INTEGER*4 TERMTIME(2)
4!!
!!	COMMON blocks
!!
`"	COMMON/PREBILL_OPEN/ NUM_OPEN
e"	COMMON/PREBILL_RECORD/BILL_RECORD
j"	INCLUDE '[BILLING]BILLDEF.FOR/NOLIST'
"!
(#!	Determine the name of the output file from TERMTIME.
#!	Determine if the file is open. Open it if it is not open.
#	CALL MY_ASCTIM (OUT_TIME_BUF,TERMTIME)
T$	OUT_FILE='PREBILL.'//OUT_TIME_BUF(4:6)//';'//OUT_TIME_BUF(8:11)
$	IF (NUM_OPEN.NE.0) THEN		!Check table for the file
%	    DO 25 I=1,NUM_OPEN
%		IF (OPEN_FILES(I).EQ.OUT_FILE) THEN
%		    OUT_DEVICE =10+I !File already open, set unit number
H&		    RETURN
&		ENDIF
'25	    CONTINUE
t'	ENDIF
'	NUM_OPEN=NUM_OPEN+1	!File not open.  Open and add to table.
<(	IF (NUM_OPEN.GT.17) STOP 'More than 17 output files open'
(	OPEN_FILES(NUM_OPEN) = OUT_FILE
)	OUT_DEVICE=NUM_OPEN+10
h)	OPEN (UNIT=OUT_DEVICE,NAME=OUT_FILE,TYPE='UNKNOWN',ACCESS='APPEND',
)	1CARRIAGECONTROL='NONE',RECORDTYPE='VARIABLE',
)	2RECORDSIZE=BILL_K_LENGTH)
0*	RETURN
*	END

d !++
 !
,!   TITLE: CLOSE_FILES			Closes any opened output files.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
 !
!	Files numbered from 10 to NUM_OPEN+10 are closed.
!
L!   ENVIRONMENT: Runs in any access mode.  Not AST re-entrant.
!
!   AUTHOR: Kathy Rodriguez		CREATION DATE: 29-MAY-1980.
x!
!   MODIFIED BY:
@!
!--
!++
l!
!   FUNCTIONAL DESCRIPTION:
4!
!	This routine closes files which are numbered from 10 to NUM_OPEN+10.
!	If NUM_OPEN equals zero, the routine does nothing.  The value of
`	!	NUM_OPEN is passed thru the named COMMON, PREBILL_OPEN.
	!
(
!   CALLING SEQUENCE:

!

!	CALL CLOSE_FILES
T!
!   INPUT PARAMETERS: None.
!
!   OUTPUT PARAMETERS: None.
!
H
!   IMPLICIT INPUTS:

!
!	NUM_OPEN	is found in the named COMMON, PREBILL_OPEN.
t!			It contains the number of output files which have been
!			opened.
<!
!   IMPLICIT OUTPUTS: None.
!
h!   COMPLETION STATUS:
!
0!	Should always have an normal return status, even if an unopened
!	is closed.
!
\!   SIDE EFFECTS:  Files are closed.
!
$!--
	SUBROUTINE CLOSE_FILES
!
P!	COMMON blocks
!
	COMMON /PREBILL_OPEN/ NUM_OPEN
|!
!
D	IF (NUM_OPEN.EQ.0) RETURN	!Do nothing if no files are open
	DO 10 I=1,NUM_OPEN		!Close file loop
	    CLOSE (UNIT=I+10,ERR=10)
p10	CONTINUE
	RETURN
8	END

d !++
 !
,!   TITLE: MY_ASCTIM		Converts 64-bit binary time to ASCII string.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT: 
 !
!	This routine converts a quadword time to a character string containing
!	days/date and time.
L!
!   ENVIRONMENT: Runs in any mode. Not AST re-entrant.
!
x!   AUTHOR: Ralph Weber		CREATION DATE: DEC-1980
!
@!   MODIFIED BY: Kathy Rodriguez on 29-MAY-1980.
!
!	1) Changed name from MY$ASCTIM to MY_ASCTIM.
l!
!--
4!++
!
!   FUNCTIONAL DESCRIPTION:
`	!
	!	This routine converts a 64-bit (quadword) time  to either days and
(
!	time (for delta or negative time) or to date and time (for absolute

!	or positive time) in a character string of length 11, 17, or 24.

!	The length is determined by the length of the TIMEBUFFER parameter.
T!
!   CALLING SEQUENCE:
!
!	CALL MY_ASCTIM (TIMEBUFFER,INTIME)
!
H
!   INPUT PARAMETERS:

!
!	INTIME		is the quadword (INTEGER*4 INTIME(2)) which
t!			contains the delta (negative) or absolute (positive)
!			time to be converted.
<!
!   OUTPUT PARAMETERS:
!
h!	TIMEBUFFER	is the character string which contains the converted
!			time.  It may be 11, 17, or 24 characters in length,
0!			as determined by the calling program.  It's contents
!			will be 1) days and time when INTIME is a delta time,
!			2) date and time when INTIME is an absolute time,
\!			and 3) date when INTIME is an absolute time and the
!			length of TIMEBUFFER is 11.
$!   IMPLICIT INPUTS:
!
!	The length of TIMEBUFFER is passed to the routine and governs the
P!	contents of the output string, TIMEBUFFER.
!
!   IMPLICIT OUTPUTS: None.
|!
!   COMPLETION STATUS:
D!
!	If an error occurs in the conversion, the output string, TIMEBUFFER,
!	will contain asterisks.
p!
!   SIDE EFFECTS: None.
8!
!--
 	SUBROUTINE  MY_ASCTIM (TIMEBUFFER,INTIME)
d	IMPLICIT INTEGER*4 (A-Z)
	CHARACTER*(*) TIMEBUFFER
,	INTEGER*4 INTIME(2)
	STATUS=SYS$ASCTIM(,TIMEBUFFER,INTIME,%VAL(0))
	IF (.NOT.STATUS)  TIMEBUFFER = '************************'
X	RETURN
	END
