d !++
 !
,!   TITLE: PRINTBILL.FOR	Prints the ACCOUNT.MMM.YYYY file.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT:	
!
!	The routine prints prebilling accounting files produced by PREBILL.
 !
!   ENVIRONMENT: Runs in any access mode. Not AST re-entrant.
!
L!   AUTHOR: Kathy Rodriguez		CREATION DATE: 5-JUNE-1980.
!
!   MODIFIED BY:
x!
!--
@!++
!
!   FUNCTIONAL DESCRIPTION:

!
!	This routine prints the files produced by the pre-billing program,
!	PREBILL.  The value of BILL_W_MSGTYP determines the format of the
!	outputted lines.  The output is written on the file called PRINTBILL.LIS.
l!
!   INPUT PARAMETERS: None.
!
`	!   OUTPUT PARAMETERS: None.
	!
(
!   IMPLICIT INPUTS:
*
!
,
!	BILLDEF.FOR is the parameter file for the input records.

!

!   IMPLICIT OUTPUTS:

!

!	PRINTBILL.LIS is the output file.
T!
!   COMPLETION STATUS: Normal.
!
!   SIDE EFFECTS:
!
!	See IMPLICIT OUTPUTS.
!
H
!--

d 	PROGRAM PRINT_BILLING
 	INTEGER*2 UIC(2)
,	INTEGER*4 LUIC
	CHARACTER*24 BUFFER,INPUT_FILE*25
	INCLUDE '[BILLING]BILLDEF.FOR'
X	EQUIVALENCE (LUIC,UIC(1))
	OPEN (UNIT=10,NAME='PRINTBILL.LIS',TYPE='NEW')
 1	TYPE 9000,'Name of file to be printed (# to stop):'
9000	FORMAT (1X,A,$)
	ACCEPT 9100,INPUT_FILE
L9100	FORMAT (A)
	IF (INPUT_FILE(1:1).EQ.'#') STOP
	OPEN (UNIT=2,NAME=INPUT_FILE,TYPE='OLD',READONLY,
x	1RECORDTYPE='VARIABLE',CARRIAGECONTROL='NONE',ERR=800)
	WRITE (10,9050) INPUT_FILE
@9050	FORMAT ('1FILE BEING PROCESSED IS 'A)
	LINE=1
2	READ (2,9150,END=999) NUM_CHARS,(BILL_RECORD(I),I=0,NUM_CHARS-1)
l9150	FORMAT (Q,135A1)
	IF (LINE.GE.50) THEN
4	    LINE=1
	    WRITE (10,9950)
9950	    FORMAT ('1')
`		ENDIF
		CALL MY_ASCTIM(BUFFER,BILL_Q_TERMTIME)
(
	WRITE (10,9200) BILL_F_VERSION,BILL_W_MSGTYP,BILL_T_MACHCODE,

	1BILL_W_MSGSIZ,BILL_W_GRP,BILL_W_MEM,BILL_T_USERNAME,BUFFER

9200	FORMAT (' VERSION ='F4.0,'     MESSAGE TYPE = 'I3,
T	1'    MACHINE CODE = 'A/' MESSAGE SIZE = 'I3,'    UIC = [',O3,
	2',',O3,']       USERNAME = 'A,'     TERMINATION TIME = 'A)
	LINE=LINE+2
	IF (BILL_W_MSGTYP.EQ.-1) THEN
	    LINE=LINE+3
H
	    IF (LINE.LT.50) 	 WRITE (10,9900)

	    GO TO 2
	ENDIF
t	IF (BILL_W_MSGTYP.EQ.-2) THEN
	    CALL MY_ASCTIM(BUFFER(1:16),BILL_Q_DOWNTIME)
<	    WRITE (10,9300) BUFFER(1:16)
9300	    FORMAT (' DOWN TIME = 'A)
	    LINE=LINE+4
h	    IF (LINE.LT.50) WRITE (10,9900)
	    GO TO 2
0	ENDIF
	ITYPE=MOD(BILL_W_MSGTYP,10)
\	WRITE (10,9400) BILL_T_OWNER,BILL_T_ACCOUNT
9400	FORMAT (' OWNER = 'A,'    ACCOUNT = 'A)
$	LINE=LINE+1
	IF (ITYPE.EQ.4) THEN
	    CALL MY_ASCTIM(BUFFER(1:16),BILL_Q_DELAYTIM)
P	    WRITE (10,9500) BILL_L_PAGCNT,BILL_L_QIOCNT,
	1   BILL_L_GETCNT,BILL_T_PRT_QUE,BILL_T_PRT_NAME,BUFFER(1:16)
9500	    FORMAT (' PAGE COUNT  = 'I5,'    QUEUED I/O COUNT ='I10,
|	1   '   GET COUNT = 'I10/' PRINT QUEUE = 'A,'     JOB NAME = 'A/
	2   ' DELAY TIME = 'A)
D	    LINE=LINE+3
	    IF (BILL_W_MSGTYP.EQ.24) 	THEN
		LUIC = BILL_L_PRTB_UIC
p		WRITE (10,9901) BILL_T_PRT_BY,UIC(2),UIC(1)
	    ENDIF
8	    IF (BILL_W_MSGTYP.EQ.44) THEN 
		LUIC = BILL_L_PRTF_UIC
 		WRITE (10,9902) BILL_T_PRT_FOR,UIC(2),UIC(1)
d	    ENDIF
9901	    FORMAT (' DONE BY 'A,'      UIC = ['O3','O3']')
,9902	    FORMAT (' DONE FOR 'A,'     UIC = ['O3','O3']')
	ELSE
	    WRITE (10,9600) BILL_F_CPUTIM,BILL_L_PAGEFLTS,
X	1   BILL_L_PGFLPEAK,BILL_L_WSPEAK,BILL_L_BIOCNT,BILL_L_DIOCNT,
	2   BILL_L_VOLUMES
 9600	    FORMAT (' CPU TIME = 'F10.2,'       PAGE FAULTS = 'I10/
	1   ' PAGE FAULT PEAK = 'I10, '       WORKING SET PEAK = 'I10/
	2   ' BUFFERED I/O COUNT = 'I10,'      DIRECT I/O COUNT = 'I10/
L	3   ' VOLUMES = 'I10)
	    LINE=LINE+4
	    IF (ITYPE.EQ.2) THEN
x		WRITE (10,9700) BILL_T_JOB_QUE,BILL_T_JOB_NAME
9700		FORMAT (' JOB QUEUE = 'A,'    JOB NAME = 'A)
@		LINE=LINE+2
		IF (BILL_W_MSGTYP .EQ. 22) THEN 
 		    LUIC = BILL_L_BCHB_UIC
l 		    WRITE (10,9901) BILL_W_BCH_BY,UIC(2),UIC(1)
 		ENDIF
4!		IF (BILL_W_MSGTYP.EQ.42)  THEN 
!		    LUIC = BILL_L_BCHF_UIC
!		    WRITE (10,9902) BILL_W_BCH_FOR,UIC(2),UIC(1)
`"		ENDIF
"	    ELSE IF (ITYPE.EQ.3) THEN
(#		     CALL MY_ASCTIM(BUFFER(1:16),BILL_Q_CONNECT)
#		     WRITE (10,9800) BUFFER(1:16)
#9800		     FORMAT ('  CONNECT TIME = 'A)
T$		     LINE=LINE+1
$		     IF (BILL_W_MSGTYP.EQ.23)THEN 
%			LUIC = BILL_L_INTB_UIC
%			WRITE (10,9901) BILL_T_INT_BY,UIC(2),UIC(1)
%		     ENDIF
H&		     IF (BILL_W_MSGTYP.EQ.43)THEN 
&			LUIC = BILL_L_INTF_UIC
'			WRITE (10,9902) BILL_T_INT_FOR,UIC(2),UIC(1)
t'		     ENDIF
'		    ELSE IF (ITYPE.EQ.1) THEN
<(	    			 IF (BILL_W_MSGTYP.EQ.21) THEN
(				    LUIC = BILL_L_NINB_UIC
)				    WRITE (10,9901) BILL_T_NINT_BY,UIC(2),
h)	1				UIC(1)
)				 ENDIF
0*				 IF (BILL_W_MSGTYP.EQ.41) THEN
*				    LUIC = BILL_L_NINF_UIC
*	                   	    WRITE (10,9902) BILL_T_NINT_FOR,UIC(2),
\+	1				UIC(1)
+				 ENDIF
$,				 LINE=LINE+1
,		ENDIF
,	ENDIF
P-	LINE=LINE+3
-	IF (LINE.LT.50) WRITE (10,9900)
.9900	FORMAT (//)
|.	GO TO 2
.800	TYPE *,'BAD FILE NAME, TRY AGAIN'
D/	GO TO 1
/999	CLOSE (UNIT=2)
0	GO TO 1
p0	END

d !++
 !
,!   TITLE: MY_ASCTIM		Converts 64-bit binary time to ASCII string.
!
!   FACILITY: BILLING SYSTEM
X!
!   ABSTRACT: 
 !
!	This routine converts a quadword time to a character string containing
!	days/date and time.
L!
!   ENVIRONMENT: Runs in any mode. Not AST re-entrant.
!
x!   AUTHOR: Ralph Weber		CREATION DATE: DEC-1980
!
@!   MODIFIED BY: Kathy Rodriguez on 29-MAY-1980.
!
!	1) Changed name from MY$ASCTIM to MY_ASCTIM.
l!
!--
4!++
!
!   FUNCTIONAL DESCRIPTION:
`	!
	!	This routine converts a 64-bit (quadword) time  to either days and
(
!	time (for delta or negative time) or to date and time (for absolute

!	or positive time) in a character string of length 11, 17, or 24.

!	The length is determined by the length of the TIMEBUFFER parameter.
T!
!   CALLING SEQUENCE:
!
!	CALL MY_ASCTIM (TIMEBUFFER,INTIME)
!
H
!   INPUT PARAMETERS:

!
!	INTIME		is the quadword (INTEGER*4 INTIME(2)) which
t!			contains the delta (negative) or absolute (positive)
!			time to be converted.
<!
!   OUTPUT PARAMETERS:
!
h!	TIMEBUFFER	is the character string which contains the converted
!			time.  It may be 11, 17, or 24 characters in length,
0!			as determined by the calling program.  It's contents
!			will be 1) days and time when INTIME is a delta time,
!			2) date and time when INTIME is an absolute time,
\!			and 3) date when INTIME is an absolute time and the
!			length of TIMEBUFFER is 11.
$!   IMPLICIT INPUTS:
!
!	The length of TIMEBUFFER is passed to the routine and governs the
P!	contents of the output string, TIMEBUFFER.
!
!   IMPLICIT OUTPUTS: None.
|!
!   COMPLETION STATUS:
D!
!	If an error occurs in the conversion, the output string, TIMEBUFFER,
!	will contain asterisks.
p!
!   SIDE EFFECTS: None.
8!
!--
 	SUBROUTINE  MY_ASCTIM (TIMEBUFFER,INTIME)
d	IMPLICIT INTEGER*4 (A-Z)
	CHARACTER*(*) TIMEBUFFER
,	INTEGER*4 INTIME(2)
	STATUS=SYS$ASCTIM(,TIMEBUFFER,INTIME,%VAL(0))
	IF (.NOT.STATUS)  TIMEBUFFER = '************************'
X	RETURN
	END
