d 	SUBROUTINE NAMELIST(PROMPT,NAMES,DESC_ARRAY,NUMBER,INPUT,IECHO,
 	1    IPROMPT)
,C
C	MODULE NAME:	NAMELIST
C	CREATED BY:	Derek Rowell
XC	DATE:		Nov 27 1978
C	VERSION:	0.1
 C
C	FUNCTION:	This is the top-level routine in the namelist
C			package. It is called directly by user programs
LC			to set values into, or print the value of
C			entities in the namelist. NAMELIST parses
C			the input stream from device FOR$ACCEPT
xC			and executes the commands implied by the
C			string delimiters.
@C
C	ARGUMENTS:	PROMPT [CHARACTER*(*)] A text string to be
C			   printed on the terminal to prompt input.
lC			   a "  :" is appended to the supplied text.
C			NAMES(number) [CHARACTER*15] An array of the
4C			   names of entities in the namelist. The
C			   user must initialize this array before
C			   issuing a call to NAMELIST. (This might
`	C			   be done with a DATA statement or a call
	C			   to NML$NAMESET.)
(
C			DESC_ARRAY(number) [INTEGER*4] An array of

C			   pointers to the descriptor-block for the

C			   entities in the namelist. The pointer
TC			   in a given posistion must correspond to the
C			   the variable named in the equivalent element
C			   of array NAMES. DESC_ARRAY is normally
C			   initialized by a user call to NML$DES_STUF.
C			NUMBER [INTEGER*4] The number of entities in
H
C			   the namelist.

C
C
tC
	CHARACTER PROMPT*(*),NAMES(NUMBER)*15,DELIM*1,STRING*80,CHAR*1
<	CHARACTER ERR_MESSAGE*80,FULL_NAME*20
	CHARACTER*15 VAR_NAME
	INTEGER*4 DESC_BLOCK(26),SUBSCR(7),DESC_ARRAY(NUMBER)
h	INTEGER*4 OFFSET,ICOMMA,ISTOP,LPAREN,RPAREN
	INTEGER*4 DTYPE
0	INTEGER LOWER_BOUNDS(7),UPPER_BOUNDS(7)
	COMPLEX COMPLEX_VALUE
	REAL*8 REAL_VALUE,VALUE,NML$REAL8_VAL
\	LOGICAL FIRST,LOG_VAL,EQUAL,VALID_NAME,DONE
	BYTE BYTE_VAL
$C
	COMMON /NML$/ IN_DEV,IOUT_DEV,IPROMPT_DEV
C
PC
	PARAMETER LOG_1=2,
	1	  LOG_2=3,
|	2	  LOG_4=4,
	3	  BYTE_1=6,
D	4	  INTEGER_2=7,
	5	  INTEGER_4=8,
	6	  REAL_4=10,
p	7	  REAL_8=11,
	8	  COMPLEX_8=12,
8	9	  CHARACTER=14,
	1	  ILLEGAL=0
 C
dC
	PARAMETER NML$SUCCESS=1
,C
	PARAMETER NML$INTERACTIVE=1
C
X	EQUIVALENCE (BYTE_VALUE,COMPLEX_VALUE,VALUE,REAL_VALUE
	1   ,INTEGER_VALUE,LOGICAL_VALUE)
 	EQUIVALENCE	(DESC_BLOCK(2),DTYPE),
	1		(DESC_BLOCK(4),NDIMS),
	2		(DESC_BLOCK(13),LOWER_BOUNDS(1)),
L	3		(DESC_BLOCK(20),UPPER_BOUNDS(1))
C
C
x	IN_DEV=INPUT
	IOUT_DEV=IECHO
	IPROMPT_DEV=IPROMPT
@C
C FORCE A READ ON FIRST CALL TO NML$GETSTR
 5	FIRST=.TRUE.
l 	DONE=.FALSE.
 	EQUAL=.FALSE.
4!	VALID_NAME=.FALSE.
!	DESC_BLOCK(2)=ILLEGAL
!C
`"C
"C
(#100	CALL NML$GET_STR(STRING,NCHAR,DELIM,FIRST,PROMPT)
#	FIRST=.FALSE.
#C 
T$C TEST FOR '&' AND REPLACE WITH A ','
$	IF (DELIM .EQ. '&') THEN
%	  DELIM=','
%	  DONE=.TRUE.
%	ENDIF
H&C
&C TEST FOR A VARIABLE NAME BY THE "=" DELIMITER
'C
t'	IF (DELIM .EQ. '=') THEN
'	EQUAL=.TRUE.
<(C
(C TEST FOR A ZERO LENGTH STRING (FOR =? COMMAND)
)	  IF (NCHAR .EQ. 0) GO TO 100
h)C
)C LOOK FOR SUBSCRIPTS
0*	  NSUBS=0
*	  DO 15 I=1,7
*15	  SUBSCR(I)=0
\+C
+	  LPAREN=INDEX(STRING,'(')
$,	  RPAREN=INDEX(STRING,')')
,	  IF (LPAREN .NE. 0) THEN
,	    IPOS=LPAREN+1
P-10	    ICOM=INDEX(STRING(IPOS:),',')
-	    ISTOP=ICOM+IPOS-1
.	    IF (ICOM .EQ. 0) ISTOP=RPAREN
|.	    NSUBS=NSUBS+1
.	    SUBSCR(NSUBS)=NML$INT4_VAL(STRING(IPOS:ISTOP-1),
D/	1	ISTOP-IPOS,IERR)
/		IF(IERR .NE.NML$SUCCESS)THEN
0		  ERR_MESSAGE='INVALID SUBSCRIPTS'
p0		  GO TO 1000
0		ENDIF
81C
1	    IPOS=ISTOP+1
 2	    IF (ICOM .NE. 0) GO TO 10
d2C
2	    VAR_NAME=STRING(:LPAREN-1)
,3	  ELSE
3	    VAR_NAME=STRING(:NCHAR)
3	  ENDIF
X4	  FULL_NAME=STRING(:NCHAR)
4C
 5C SEARCH NAME TABLE FOT VARIABLE NAME
5C
5	  DO 20 I=1,NUMBER
L6	    IF(VAR_NAME .EQ. NAMES(I)) GO TO 30
620	  CONTINUE
7C NAME NOT FOUND
x7	  ERR_MESSAGE= 'VARIABLE NAME  '//STRING(:NCHAR)//' NOT FOUND'
7	  GO TO 1000
@8C
8C FETCH DESCRIPTOR BLOCK FOR THIS VARIABLE
9C
l930	  CALL NML$GET_DESC(%VAL(DESC_ARRAY(I)),DESC_BLOCK,IERR)
9	  IF (IERR .NE. NML$SUCCESS) THEN
4:	    ERR_MESSAGE='SYSTEM ERROR IN DESCRIPTOR BLOCK'
:	    GO TO 1000
:	  ENDIF
`;C
;C CHECK FOR SUBSCRIPTS OUT OF RANGE
(<	  IF(NSUBS .NE. 0) THEN
<	    IF(NSUBS .NE. NDIMS) THEN
<	      ERR_MESSAGE='INCORRECT NUMBER OF SUBSCRIPTS IN '
T=	1	//STRING(:NCHAR)
=	      GO TO 1000
>	    ENDIF
>	  DO 35 K=1,NDIMS
>	  IF((SUBSCR(K) .GT. UPPER_BOUNDS(K)) .OR.
H?	1     (SUBSCR(K) .LT. LOWER_BOUNDS(K))) THEN
?	    ERR_MESSAGE='SUBSCRIPT OUT OF RANGE IN '
@	1     //STRING(:NCHAR)
t@	    GO TO 1000
@	  ENDIF
<A35	  CONTINUE
A	  ENDIF
BC
hBC
B	  VALID_NAME=.TRUE.
0C	  OFFSET=0
CC
CC
\DC
DC TEST DELIMITER FOR A PRINTING REQUEST ('?')
$E	ELSE IF (DELIM .EQ. '?') THEN
EC
EC TEST FOR THE "=?" SEQUENCE
PF	  IF (EQUAL .AND. VALID_NAME) THEN
F	    CALL NML$PRINT_VAR(FULL_NAME,DESC_BLOCK,NSUBS,SUBSCR,IERR)
G	  ELSE IF(EQUAL) THEN
|G	    CALL NML$PRINT_ALL(NAMES,DESC_ARRAY,NUMBER)
G	  ELSE
DH	    CALL NML$PRINT_NAMES(NAMES,NUMBER,DESC_ARRAY)
H	  ENDIF
IC
pIC
IC
8JC TEST FOR A DATA ITEM BY A "," DELIMITER
J	ELSE IF (DELIM .EQ. ',') THEN
 K	  VALID_NAME=.FALSE.
dK	  EQUAL=.FALSE.
K	  IF(NCHAR .EQ. 0) GO TO 70
,LC FETCH DATA TYPE FROM CURRENT DESCRIPTOR BLOCK
LC TEST FOR A REPEAT CONSTANT BY SEARCHING FOR A (*)
LC BEFORE A TEXT STRING IN QUOTES.
XM	  IREPEAT=1
M	    ISTAR=INDEX(STRING,'*')
 N	    IQUOTE=INDEX(STRING,'''')
N	    IF ((ISTAR .NE. 0) .AND.
N	1	((IQUOTE .EQ. 0) .OR. (ISTAR .LT. IQUOTE))) THEN
LO	    IREPEAT=NML$INT4_VAL(STRING(:ISTAR-1),ISTAR-1,IERR)
O	    IF(IERR .NE. NML$SUCCESS) THEN
P	      ERR_MESSAGE='INVALID REPEAT CONSTANT IN : '//STRING(:NCHAR)
xP	      GO TO 1000
P	    ENDIF
@Q	    STRING=STRING(ISTAR+1:)
Q	    NCHAR=NCHAR-ISTAR
R	  ENDIF
lRC
RC
4SC TEST FOR DATA TYPES AND ENTER
S	IF(DTYPE .EQ. ILLEGAL) THEN
S	  ERR_MESSAGE='INVALID INPUT :NO ''='' GIVEN'
`T	  GO TO 1000
T	ENDIF
(UC
UC
UC
TVC TEST FOR LOGICAL DATA TYPES
V	  IF ((DTYPE .EQ. LOG_1) .OR. (DTYPE .EQ. LOG_2) .OR.
W	1	(DTYPE .EQ. LOG_4)) THEN
W	    IF((STRING(1:1) .EQ. 'T') .OR. 
W	1	(STRING(1:2) .EQ. '.T')) THEN
HX	      LOGICAL_VALUE= .TRUE.
X	    ELSE IF ((STRING(1:1) .EQ. 'F') .OR.
Y	1	(STRING(1:2) .EQ. '.F')) THEN
tY	      LOGICAL_VALUE=.FALSE.
Y	    ELSE
<Z	      ERR_MESSAGE='INVALID LOGICAL VALUE :'//STRING(:NCHAR)
Z	      GO TO 1000
[	    ENDIF
h[C
[C
0\C TEST FOR A BYTE VALUE
\	  ELSE IF (DTYPE .EQ. BYTE_1) THEN
\	    BYTE_VALUE=NML$INT4_VAL(STRING,NCHAR,IERR)
\]	    IF(IERR .NE. NML$SUCCESS) THEN
]	      ERR_MESSAGE='INVALID BYTE VALUE :  '// STRING(:NCHAR)
$^	      GO TO 1000
^	    ENDIF
^C
P_C
_C TEST FOR AN INTEGER VALUE
`	  ELSE IF ((DTYPE .EQ. INTEGER_2) .OR.
|`	1	(DTYPE .EQ. INTEGER_4)) THEN
`	    INTEGER_VALUE=NML$INT4_VAL(STRING,NCHAR,IERR)
Da	    IF(IERR .NE. NML$SUCCESS) THEN
a	      ERR_MESSAGE='INVALID INTEGER VALUE : '//STRING(:NCHAR)
b	      GO TO 1000
pb	    ENDIF
bC
8cC
cC TEST FOR A REAL VALUE
 d	  ELSE IF ((DTYPE .EQ. REAL_4) .OR.
dd	1	(DTYPE .EQ. REAL_8)) THEN
d	    REAL_VALUE=NML$REAL8_VAL(STRING,NCHAR,IERR)
,e	    IF (IERR .NE. NML$SUCCESS) THEN
e	      ERR_MESSAGE='INVALID REAL VALUE : '//STRING(:NCHAR)
e	      GO TO 1000
Xf	    ENDIF
fC
 gC
gC TEST FOR A COMPLEX VALUE
g	  ELSE IF (DTYPE .EQ. COMPLEX_8) THEN
Lh	    LPAREN=INDEX(STRING,'(')
h	    ICOMMA=INDEX(STRING,',')
i	    RPAREN=INDEX(STRING,')')
xi	    IF ((LPAREN .EQ. 0) .OR. (RPAREN .EQ. 0) .OR.
i	1	(ICOMMA .EQ. 0)) THEN
@j	      ERR_MESSAGE='INVALID SYNTAX FOR A COMPLEX NUMBER : '
j	1	//STRING(:NCHAR)
k	      GO TO 1000
lk	    ENDIF
kC
4l	    REAL_PART=NML$REAL8_VAL(STRING(LPAREN+1:ICOMMA-1),
l	1	ICOMMA-LPAREN-1,IERR)
l	    IF (IERR .NE. NML$SUCCESS) THEN
`m	      ERR_MESSAGE='INVALID NUMBER IN : '//STRING(:NCHAR)
m	      GO TO 1000
(n	    ENDIF
nC
n	    AIMAG_PART=NML$REAL8_VAL(STRING(ICOMMA+1:RPAREN-1),
To	1	RPAREN-ICOMMA-1,IERR)
o	    IF (IERR .NE. NML$SUCCESS) THEN
p	      ERR_MESSAGE='INVALID NUMBER IN : '//STRING(:NCHAR)
p	      GO TO 1000
p	    ENDIF
HqC
q	    COMPLEX_VALUE=CMPLX(REAL_PART,AIMAG_PART)
r	  ENDIF
trC
rC CHARACTER DATA MUST BE TREATED SEPARATELY BECAUSE OF THE
<sC PROBLEM OF SETTING UP A BUFFER OF UNKNOWN LENGTH. BY
sC TRANSFERRING A BYTE AT A TIME AN ENTRY MAY BE MADE INTO
tC A LONG CHARACTER VARIABLE WITHOUT STORING A LONG BUFFER
htC IN NAMELIST.
tC
0u	  IF(DTYPE .EQ. CHARACTER) THEN
u	    IF((STRING(1:1) .NE. '''') .OR.
u	1      (STRING(NCHAR:NCHAR) .NE. '''')) THEN
\v	      ERR_MESSAGE='INVALID CHARACTER VALUE: '
v	1	//STRING(NCHAR:NCHAR)
$w	      GO TO 1000
w	    ENDIF
wC
Px	    STRING=STRING(2:NCHAR-1)
x	    NCHAR=NCHAR-2
yC
|yC STORE CHARACTER DATA
y	    DO 50 J=1,IREPEAT
Dz	    DO 55 K=1,DESC_BLOCK(3)
z	      CHAR=' '
{	      IF (K .LE. NCHAR) CHAR=STRING(K:K)
p{	      CALL NML$PUT_VALUE(DESC_BLOCK,SUBSCR,NSUBS,
{	1	OFFSET+(K-1),%REF(CHAR),IERR)
8|	      IF(IERR .NE. NML$SUCCESS) THEN
|		ERR_MESSAGE='INVALID ARRAY SPECIFICATION-'
 }	1	  //' STORAGE EXCEEDED OR SUBSCRIPT MISMATCH'
d}		GO TO 1000
}	      ENDIF
,~55	    CONTINUE
~50	    OFFSET=OFFSET+DESC_BLOCK(3)
~C
XC
C STORE NUMERIC AND LOGICAL TYPES
 	  ELSE
	    DO 60 I=1,IREPEAT
	      CALL NML$PUT_VALUE(DESC_BLOCK,SUBSCR,NSUBS,
L	1 	OFFSET,VALUE,IERR)
	      IF(IERR .NE. NML$SUCCESS) THEN
		ERR_MESSAGE='INVALID ARRAY SPECIFICATION-'
x	1	  //' STORAGE EXCEEDED OR SUBSCRIPT MISMATCH'
܂	      GO TO 1000
@	    ENDIF
60	    OFFSET=OFFSET+1
	  ENDIF
lC
ЄC
4	ENDIF
C
C TEST FOR COMPLETION
`70	IF ( DONE) THEN
Ć	  RETURN
(	ELSE
	  GO TO 100
	ENDIF
TC
C
C ERROR HANDLER. IF IN INTERACTIVE MODE ERRORS ARE NON-FATAL
C AND A BRANCH TO THE ENTRY POINT IS TAKEN. IN BATCH MODE
C ERRORS ARE FATAL.
H1000	IF(IOUT_DEV .NE. 0) WRITE(IOUT_DEV,1010) ERR_MESSAGE
	IF (IPROMPT_DEV .NE. 0) THEN
	   WRITE(IPROMPT_DEV,1010) ERR_MESSAGE
t	   GO TO 5
؋	ELSE
<	   STOP 'FATAL NAMELIST ERROR'
	ENDIF
1010	FORMAT(' NAMELIST ERROR:  ',A)
h	END
̍
0	INTEGER*4 FUNCTION NML$INT4_VAL(STRING,NCHAR,IERR)
C
C	MODULE NAME:	NML$INT4_VAL
\C	CREATED BY:	Derek Rowell
C	DATE:		Nov 27 1978
$C	VERSION:	0.1
C
C	FUNCTION:	Converts a numeric text string to an
PC			integer format.
C
C	ARGUMENTS:	STRING [CHARACTER*(*)] A numeric string
|C			   specifying an integer value, for
C			   example '-1234'.
DC			NCHAR [INTEGER*4] The number of characters
C			   in the input string.
C			IERR [INTEGER*4] Error status on string.
pC			   IERR=1 for successful conversion
ԔC			   IERR=0 for an error detected on conversion.
8C
C
 C
d	CHARACTER*(*) STRING
Ȗ	PARAMETER NML$SUCCESS=1,
,	1	  NML$ERROR=0
C
	DECODE(NCHAR,100,STRING,ERR=200) NML$INT4_VAL
X100	FORMAT(I<NCHAR>)
	IERR=NML$SUCCESS
 	RETURN
C
200	IERR=NML$ERROR
L	RETURN
	END

x
ܛ	REAL*8 FUNCTION NML$REAL8_VAL(STRING,NCHAR,IERR)
@C
C	MODULE NAME:	NML$REAL8_VAL
C	CREATED BY:	Derek Rowell
lC	DATE:		Nov 27 1978
НC	VERSION:	0.1
4C
C	FUNCTION:	Converts a numeric text string to a double
C			precision real number.
`C
ğC	ARGUMENTS:	STRING [CHARACTER*(*)] A numeric string
(C			   containing a real number, for example
C			   '234.567' or '-234.E07'.
C			NCHAR [INTEGER*4] The number of characters
TC			   in STRING.
C			IERR [INTEGER*4] Error status upon conversion.
C			   IERR=1 indicates successful conversion.
C			   IERR=0 indicates eroor upon conversion.
C
HC
C
	CHARACTER*(*) STRING
t	PARAMETER NML$SUCCESS=1,
ؤ	1	  NML$ERROR=0
<C
	DECODE(NCHAR,100,STRING,ERR=200) NML$REAL8_VAL
100	FORMAT(D<NCHAR>.0)
h	IERR=NML$SUCCESS
̦	RETURN
0C
200	IERR=NML$ERROR
	RETURN
\	END

$
	INTEGER*4 FUNCTION NML$OP_MODE(IERR)
C
PC	MODULE NAME:	NML$OP_MODE
C	CREATED BY:	Derek Rowell
C	DATE:		Nov 28 1978
|C	VERSION:	0.1
C
DC	ARGUMENTS:	IERR [INTEGER*4] Status condition returned
C			  after call to system services to translate
C			  logical device names.
pC			    IERR=1 indicates success.
ԭC			    IERR=0 indicates error in translation.
8C
C
 C
d	CHARACTER*64 IN_DEVICE, OUT_DEVICE
ȯC
,	PARAMETER NML$INTERACTIVE=1,
	1	  NML$BATCH=0,
	2	  NML$SUCCESS=1,
X	3	  NML$FAILURE=0,
	4	  SS$_NORMAL=1
 C
C
C
L	IERR=NML$SUCCESS
	NML$OP_MODE=NML$INTERACTIVE
C
xC TRANSLATE LOGICAL NAMES FOR SYS$INPUT AND SYS$OUTPUT.
ܴ	ISTAT=SYS$TRNLOG('SYS$INPUT',,IN_DEVICE,,,)
@	IF (ISTAT .NE. SS$_NORMAL) IERR=NML$FAILURE
C
	ISTAT=SYS$TRNLOG('SYS$OUTPUT',,OUT_DEVICE,,,)
l	IF (STAT .NE. SS$_NORMAL) IERR=NML$FAILURE
жC
4C COMPARE TRANSLATED NAMES TO DECICED IF IN BATCH MODE
	IF (IN_DEVICE .NE. OUT_DEVICE) NML$OP_MODE=NML$BATCH
C
`	RETURN
ĸ	END
(


T	SUBROUTINE NML$PRINT_NAMES(NAMES,NUMBER,DESC_POINT)
C
C	MODULE NAME:	NML$PRINT_NAMES
C	CREATED BY:	Derek Rowell
C	DATE:		Nov 27 1978
HC	VERSION:	0.1
C
C	FUNCTION:	Prints a list of all variable names in the
tC			namelist upon receipt of a '?' command.
ؽC
<C	ARGUMENTS:	NAMES(number) [CHARACTER*(*)] Array of
C			   variable names in the namelist.
C			NUMBER [INTEGER*4] Number of names entered 
hC			   the array NAMES.
̿C			DESC_POINT(number) [INTEGER*4] Array of
0C			   pointers to the descriptor blocks
C			   for the corresponding entries in NAMES.
C     
\C
C
$	CHARACTER*15 NAMES(NUMBER),TYPE(14)*10
	CHARACTER STRING*80,OUT_STRING*80,SUB_STRING*20
	CHARACTER*80 NML$PACK
P	INTEGER*4 DESC_POINT(NUMBER),DESC_BLOCK(26)
	INTEGER*4 LOWER_BOUND(7),UPPER_BOUND(7)
	INTEGER*4 CLASS,DTYPE,BLENGTH,NDIMS
|C
	EQUIVALENCE (CLASS,DESC_BLOCK(1)),
D	1	    (DTYPE,DESC_BLOCK(2)),
	2	    (BLENGTH,DESC_BLOCK(3)),
	3	    (NDIMS,DESC_BLOCK(4)),
p	4	    (LOWER_BOUND(1),DESC_BLOCK(13)),
	5	    (UPPER_BOUND(1),DESC_BLOCK(20))
8C
	DATA TYPE/'BIT*','LOGICAL*','LOGICAL*','LOGICAL*',
 	1  'LOGICAL*','BYTE*','INTEGER*','INTEGER*','INTEGER*',
d	2  'REAL*','REAL*','COMPLEX*','COMPLEX*','CHARACTER*'/
C
,C
C
	TYPE 100,
X100	FORMAT('0','CURRENT NAMELIST VARIABLES :')
C
 	DO 10 I=1,NUMBER

C FETCH THE DESCRIPTOR BLOCK FOR THIS VARIABLE
L	CALL NML$GET_DESC(%VAL(DESC_POINT(I)),DESC_BLOCK,IERR)
C
	STRING=NAMES(I)
xC IF IT IS AN ARRAY ADD THE DIMENSION ATTRIBUTES
	IF(CLASS .EQ. 4) THEN
@	   STRING=NML$PACK(STRING//'(',81,NCHAR)
	   DO 20 J=1,NDIMS
	      IF (LOWER_BOUND(J) .NE. 1) THEN
l		 ENCODE(20,200,SUB_STRING) LOWER_BOUND(J)
		 STRING=NML$PACK(STRING//SUB_STRING//':',101,NCHAR)
4	      ENDIF
	      ENCODE(20,200,SUB_STRING)UPPER_BOUND(J)
	      STRING=NML$PACK(STRING//SUB_STRING//',',101,NCHAR)
`20	   CONTINUE
	   STRING(NCHAR:NCHAR)=')'
(	ENDIF
C PACK STRING AND SAVE
	OUT_STRING=NML$PACK(STRING,80,NCHAR)
TC
C FORMULATE TYPE AND LENGTH ATTRIBUTES
	ENCODE(20,200,SUB_STRING)BLENGTH
	STRING='['//TYPE(DTYPE)//SUB_STRING//']'
	OUT_STRING(25:)=NML$PACK(STRING,80,NCHAR)
HC
C
	TYPE 300, OUT_STRING
t300	FORMAT(1X,A<25+NCHAR>)
C
<10	CONTINUE
C
	TYPE 400,
h400	FORMAT('0')
	RETURN
0200	FORMAT(I20)
	END

\
	CHARACTER*(*) FUNCTION NML$PACK(STRING,LENGTH,NCHAR)
$C
C	MODULE NAME:	NML$PACK
C	CREATED BY:	Derek Rowell
PC	DATE:		Nov 27 1978
C	VERSION:	0.1
C
|C	FUNCTION:	Left justifies and elimiates blanks from
C			a character string.
DC
C	ARGUMENTS:	STRING [CHARACTER*(*)] Input string to be
C			   justified and packed.
pC			LENGTH [INTEGER*4] Length of string (from
C			   left margin) to be packed. Need not be
8C			   equal to the declared length of the string.
C			NCHAR [INTEGER*4] Number of characters packed,
 C			   i.e. the length of the non-blank string.
dC
C
,	CHARACTER*(*) STRING
	NML$PACK=' '
	NCHAR=0
XC
	DO 10 I=1,LENGTH
 	IF(STRING(I:I) .EQ. ' ') GO TO 10
	NCHAR=NCHAR+1
	NML$PACK(NCHAR:NCHAR)=STRING(I:I)
L10	CONTINUE
C
	RETURN
x	END

@

	SUBROUTINE NML$PRINT_ALL(NAMES,DESC_POINTER,NUMBER)
lC
C	MODULE NAME:	NML$PRINT_ALL
4C	CREATED BY:	Derek Rowell
C	DATE:		Nov 27 1978
C	VERSION:	0.1
`C
C	FUNCTION:	Prints the names and values of all entities
(C			in the namelist on receipt of an [delim]=?
C			command.
C
TC	ARGUMENTS:	NAMES(number)[CHARACTER*(*)] Array of names 
C			   of entities in the namelist.
C			DESC_POINTER(number) Array of pointers to
C			   the descriptor blocks of corresponding
C			   entries in NAMES
HC			NUMBER [INTEGER*4] Number of enrtries in
C			   the namelist.
C
tC
	INTEGER*4 DESC_POINTER(NUMBER),DESC_BLOCK(26),SUBSCR(7)
<	CHARACTER*(*) NAMES(NUMBER)
C
	DATA SUBSCR/7*0/
hC
	DO 10 I=1,NUMBER
0	CALL NML$GET_DESC(%VAL(DESC_POINTER(I)),DESC_BLOCK,IERR)
10	CALL NML$PRINT_VAR(NAMES(I),DESC_BLOCK,0,SUBSCR)
C
\	RETURN
	END
$


