d 	SUBROUTINE NML$GET_VALUE(DESC,SUBSCR,JSUBS,OFFSET,VALUE,IERR)
 C++
,C
C	MODULE NAME: NML$GET_VALUE
C
XC	IDENT: 0.1
C
 C	FUNCTION:
C
C		THIS ROUTINE STORES A DATA ELEMENT IN A VARIABLE SPECIFIED
LC		BY THE INPUT DESCRIPTOR BLOCK.  ARRAY OFFSETS ARE CALCULATED
C		FROM INFORMATION IN THE DESCRIPTOR BLOCK, AT THE SUBSCRIPT
C		SPECIFIED IN SUBSCR.
xC
C	AUTHOR: DOUGLASS J. WILSON
@C
C	DATE: 13-NOV-78
C
lC	MODIFIED BY:
C
4C	CALLING SEQUENCE:
C		CALL NML$GET_VALUE(DESC_BLOCK,SUBSCR,JSUBS,OFFSET,DC_VALUE
C				  ,CHAR_VALUE,LOG_VALUE)
`	C
	C
(
C	ARGUEMENTS:

C

C		DESC_BLOCK	-[INTEGER*4]
TC				-12 ELEMENT ARRAY CONTAINING THE DESCRIPTOR
C				 BLOCK FOR A VARIABLE.  FOR SPEC. SEE NML$GET_DECS
C
C		SUBSCR		-[INTEGER*4]
C				-7 ELEMENT ARRAY CONTAINING THE CURRENT SUB-
H
C				 SCRIPT SPECIFICATION FOR THIS STORE.  LEFT

C				 MOST SUBSCRIPT IS IN ELEMENT 1.
C
tC		JSUBS		-[INTEGER*4]
C				-CONTAINS THE NUMBER OF ELEMENTS PRESENT IN
<C				 THE SUBSCRIPT ARRAY.
C
C		OFFSET		-[INTEGER*4]
hC				-CONTAINS AN OFFSET IN STORAGE CELLS (IE. REAL*8)
C				 FROM THE CURRENT POSITION, AT WHICH THE VALUE
0C				 IS TO BE STORED.
C
C		VALUE		-[COMPLEX*8]
\C				-VALUE TO BE STORED (NUMERIC)
C
$C
C		IERR		-[INTEGER*4]
C				-ERROR CODE RETURNED
PC
C
C	CALLED SUBROUTINES: NML$MOVE_BYTES
|C
C
DC--
C
C	TYPE DECLARATIONS
pC
	INTEGER*4 DESC_BLOCK(26),SUBSCR(7),OFFSET,CLASS,DTYPE,BLENGTH,NDIMS
8	INTEGER*4 DESC(26),DIMS(7),ZPOINTER
	INTEGER*4 UPPER_BOUNDS(7),LOWER_BOUNDS(7)
 	BYTE VALUE(8)
dC
	EQUIVALENCE (DESC_BLOCK(1),CLASS),
,	1	    (DESC_BLOCK(2),DTYPE),
	2	    (DESC_BLOCK(3),BLENGTH),
	3	    (DESC_BLOCK(4),NDIMS),
X	4	    (DESC_BLOCK(5),DIMS(1)),
	5	    (DESC_BLOCK(12),ZPOINTER),
 	6	    (DESC_BLOCK(13),LOWER_BOUNDS(1)),
	7	    (DESC_BLOCK(20),UPPER_BOUNDS(1))
C
L	INTEGER*4 LENGTH_TABLE(15)
	DATA LENGTH_TABLE/ 	0,0,		!UNKNOWN TYPES
	1			1,2,4,8,	!LOGICALS
x	2			1,2,4,0,	!INTEGERS
	3			4,8,		!REALS
@	4			8,0,		!COMPLEX
	5			1	/	!CHARACTERS
 C
l C	MOVE DESCRIPTOR BLOCK FOR EQIVALENCE KLUDGE
 C
4!	DO 1 I=1,26
!1	DESC_BLOCK(I)=DESC(I)
!C
`"C	CALCULATE OFFSET INTO STORAGE CELLS FROM SUBSCR
"C
(#	IF (JSUBS .EQ. NDIMS) THEN
#		IF (JSUBS .GT. 0) THEN
#			NEW_OFF = SUBSCR(1)-LOWER_BOUNDS(1)
T$			IF (JSUBS .GT. 1) THEN
$				DO 10 I=2,JSUBS
%				MULT=1
%				DO 11 J=1,I-1
%11				MULT=MULT*DIMS(J)
H&10				NEW_OFF=NEW_OFF+MULT*(SUBSCR(I)-LOWER_BOUNDS(I))
&			ENDIF
'		ELSE
t'			NEW_OFF=0
'		ENDIF
<(	ELSE IF(JSUBS .NE. 0) THEN
(		IERR=2
)		RETURN
h)	ELSE
)		NEW_OFF=0
0*	ENDIF
*C
*C	MULTIPLY BY BYTE SIZE AND APPROPRIATE OFFSET
\+C
+	NEW_OFF = NEW_OFF * BLENGTH + ZPOINTER
$,	NEW_OFF = NEW_OFF + OFFSET * LENGTH_TABLE(DTYPE+1)
,C
,C
P-C
-	IF (LENGTH_TABLE(DTYPE+1) .EQ. 0) THEN
.		IERR=3				!UNKNOWN DATA TYPE
|.		RETURN
.	ENDIF
D/C
/	CALL NML$MOVE_BYTES(%VAL(NEW_OFF),VALUE,LENGTH_TABLE(DTYPE+1))
0	RETURN
p0C
0	END
81
1
 2
d2
2	SUBROUTINE NML$MOVE_BYTES(SOURCE,DESTINATION,LEN)
,3C
3C	MODULE NAME: NML$MOVE_BYTES
3C	CREATED BY:	Derek Rowell
X4C	DATE:		Nov 28 1978
4C	VERSION:	0.1
 5C
5C	FUNCTION:	Moves a block of memory without normalization
5C			This routine is used for storing and
L6C			retrieving variables of uknown type as a
6C			contiguous block of bytes.
7C
x7C	ARGUMENTS:	SOURCE(len) [BYTE] Address of block of core
7C			  to be moved.
@8C			DESTINATION(len) [BYTE] Address of block of
8C			  core to receive data.
9C			LEN [INTEGER*4] Length of block in bytes.
l9C
9C
4:C
:C
:	BYTE SOURCE(LEN),DESTINATION(LEN)
`;C
;	DO 10 I=1,LEN
(<10	DESTINATION(I)=SOURCE(I)
<C
<	RETURN
T=	END
=
>
>
>	SUBROUTINE NML$PRINT_VAR(NAME,DESC_BLOCK,NSUBS,SUBSCR,IERR)
H?C
?C	MODULE NAME:	NML$PRINT_VAR
@C	CREATED BY:	Derek Rowell
t@C	DATE:		Nov 28 1978
@C	VERSION		0.1
<AC
AC	FUNCTION:	Print the value of a variable specified by
BC			the current descriptor block. If no
hBC			no explicit subscript is specified for
BC			an array the whole array is printed.
0CC
CC	ARGUMENTS:	NAME [CHARACTER*(*)] The name, including
CC			  subscripts of the entity to be printed.
\DC			DESC_BLOCK(26) [INTEGER*4] The descriptor
DC			  block for the current entity.
$EC			NSUBS [INTEGER*4] The number of subscripts
EC			  specified by the user for the entity.
EC			SUBSCR(7) [INTEGER*4] The array of subscripts
PFC			  specified for the array.
FC			IERR [INTEGER*4] Error status returned.
GC			    IERR=1 indiactes success.
|GC			    IERR=0 indicates failure.
GC
DHC
HC
IC
pI	CHARACTER*(*) NAME
I	CHARACTER*30 NML$PACK,STRING
8J	REAL*8 VALUE
J	INTEGER*4 DESC_BLOCK(26),SUBSCR(7)
 KC
2K	COMMON /NML$/ IN_DEV,IOUT_DEV,IPROMPT_DEV
dK	PARAMETER CHARACTER=14,
K	1	  COMPLEX=12
,L	1	
LC
LC COMPUTE NUMBER OF ELEMENTS TO PRINT
XM	NUMBER=1
M	IF((NSUBS .EQ. 0) .AND. (DESC_BLOCK(1) .EQ. 4)) THEN
 N	   DO 10 I=1,DESC_BLOCK(4)
N10	   NUMBER=NUMBER*DESC_BLOCK(I+4)
N	ENDIF
LOC
O	STRING=NML$PACK(NAME//'=',LEN(NAME)+1,NCHAR)
P	WRITE(IPROMPT_DEV,90)
xP90	FORMAT('0')
P	WRITE(IPROMPT_DEV,100) STRING(:NCHAR)
@Q100	FORMAT('+',A$)
QC ADVANCE A LINE IF THERE ARE TOO MANY ITEMS FOR A SINGLE LINE
R	IF((( DESC_BLOCK(2) .GE. COMPLEX) .AND.
lR	1   (NUMBER .GT. 1)) .OR.
R	2   ((DESC_BLOCK(2) .LT. COMPLEX) .AND.
4S	3   (NUMBER .GT. 3))) WRITE(IPROMPT_DEV,150)
S150	FORMAT()
SC
`TC
TC
(UC
UC PRINT NUMERIC AND LOGICAL DATA
U	NPR=1
TVC
V	IF(DESC_BLOCK(2) .NE. CHARACTER) THEN
W	   DO 20 I=1,NUMBER
W	   CALL NML$GET_VALUE(DESC_BLOCK,SUBSCR,NSUBS,(I-1),VALUE,IERR)
W20	   CALL NML$PRINT(VALUE,DESC_BLOCK,NPR)
HX	   WRITE(IPROMPT_DEV,200)
X200	   FORMAT('+')
YC
tYC
Y	ELSE
<ZC PRINT CHARACTER DATA
Z	   DO 30 I=1,NUMBER
[	   DO 40 J=1,DESC_BLOCK(3)
h[	   CALL NML$GET_VALUE(DESC_BLOCK,SUBSCR,NSUBS,(I-1)*DESC_BLOCK(3)
[	1	+(J-1),VALUE,IERR)
0\40	   CALL NML$PRINT(VALUE,DESC_BLOCK,NPR)
\30	   CONTINUE
\300	   FORMAT(' '$)
\]C
]	ENDIF
$^	RETURN
^	END
^
P_	SUBROUTINE NML$PRINT(IN_VAL,DESC_BLOCK,N)
_C
`C	MODULE NAME:	NML$PRINT
|`C	CREATED BY:	Derek Rowell
`C	DATE:		Nov 29 1978
DaC	VERSION:	0.1
aC
bC	FUNCTION:	Print a NAMELIST entity, with format
pbC			dictated by the type.
bC
8cC	ARGUMENTS:	IN_VAL(8) [BYTE] Value to be printed.
cC			  (The byte size used is determined from
 dC			  the current descriptor block.)
ddC			DESC_BLOCK(26) [INTEGER*4] Descriptor block
dC			  for the current entity.
,eC			N [INTEGER*4] Counter for the number of
eC			  items printed.Is used for line formatting.
eC
XfC
fC
 gC
g	BYTE IN_VAL(8),VALUE(8)
g	INTEGER*4 DESC_BLOCK(26)
LhC
~h	COMMON /NML$/ IN_DEV,IOUT_DEV,IPROMPT_DEV
hC DATA TYPES SUPPORTED
i	COMPLEX CMPLEX
xi	REAL*8 RL8
i	REAL*4 RL4
@j	INTEGER*4 INT4
j	INTEGER*2 INT2
k	LOGICAL*4 LOG4
lk	LOGICAL*2 LOG2
k	LOGICAL*1 LOG1
4l	BYTE CHAR
lC
lC DESCRIPTOR BLOCK TYPE SPECIFICATIONS
`m	PARAMETER	LOGICAL1=2,
m	1		LOGICAL2=3,
(n	2		LOGICAL4=4,
n	3		INTEGER2=7,
n	4		INTEGER4=8,
To	5		REAL4=10,
o	6		REAL8=11,
p	7		COMPLEX=12,
p	8		CHARACTER=14
pC
HqC EQUIVALENCE DATA TYPES FOR PICK-UP.
q	EQUIVALENCE (VALUE(1),CMPLEX,RL8,RL4,INT4,INT2,
r	1	LOG4,LOG2,LOG1,CHAR)
trC
rC
<sC MOVE INPUT BYTES TO ENABLE EQUIVALENCE OF VALUES
s	DO 10 I=1,8
t10	VALUE(I)=IN_VAL(I)
htC
tC TEST FOR LOGICAL VALUES
0u	IF((DESC_BLOCK(2) .EQ. LOGICAL4) .OR.
u	1  (DESC_BLOCK(2) .EQ. LOGICAL2) .OR.
u	2  (DESC_BLOCK(2) .EQ. LOGICAL1)) THEN
\v		WRITE(IPROMPT_DEV,100) LOG1
v100		FORMAT('+',L15$)
$w		IF (MOD(N,5) .EQ. 0) WRITE(IPROMPT_DEV,1000)
wC
wC TEST FOR INTEGER VALUES
Px	ELSE IF((DESC_BLOCK(2) .EQ. INTEGER2) .OR.
x	1	(DESC_BLOCK(2) .EQ. INTEGER4)) THEN
y	    IF(DESC_BLOCK(2) .EQ. INTEGER)INT4=INT4
|y	    WRITE(IPROMPT_DEV,200)INT4
y200	    FORMAT('+',I15$)
Dz	    IF(MOD(N,5) .EQ. 0) WRITE(IPROMPT_DEV,1000)
zC
{C TEST FOR REAL VALUES
p{	ELSE IF((DESC_BLOCK(2) .EQ. REAL8) .OR.
{	1	(DESC_BLOCK(2) .EQ. REAL4)) THEN
8|	    IF(DESC_BLOCK(2) .EQ. REAL4)RL8=RL4
|	    WRITE(IPROMPT_DEV,300)RL8
 }300	    FORMAT('+',1PG15.7$)
d}	    IF(MOD(N,5) .EQ. 0) WRITE(IPROMPT_DEV,1000)
}C
,~C TEST FOR COMPLEX VALUE
~	ELSE IF((DESC_BLOCK(2) .EQ. COMPLEX)) THEN
~	    WRITE(IPROMPT_DEV,400)CMPLEX
X400	    FORMAT('+','(',1PG15.7,',',1PG15.7,')'$)
	    IF(MOD(N,2) .EQ. 0) WRITE(IPROMPT_DEV,1000)
 C
C TEST FOR CHARACTER DATA
	ELSE IF(DESC_BLOCK(2) .EQ. CHARACTER) THEN
L	    WRITE(IPROMPT_DEV,500)CHAR
500	    FORMAT('+',A1$)
	    IF(MOD(N,DESC_BLOCK(3)) .EQ. 0) WRITE(IPROMPT_DEV,1000)
xC
܂	ELSE
@	    WRITE(IPROMPT_DEV,*) 'INVALID DATA TYPE'
	ENDIF
C
l	N=N+1
Є	RETURN
41000	FORMAT(' '$)
C
	END
