d 	PROGRAM SWAP_FILE_SIZE
 
,!  This program calculates an exactly correct swap file size given
!  the values of the following:
!	MAXPROCESSCNT (system parameter - SYSGEN)
X!	PROCSECTCNT (system parameter - SYSGEN)
!	WSMAX (system parameter - SYSGEN)
 !	VIRTUALPAGECNT (system parameter - SYSGEN)
!	WSL$C_LENGTH (from $WSLDEF, 4 in V1.6)
!	PHD$C_LENGTH (from $PHDDEF, '118'X in V1.6)
L!	SEC$C_LENGTH (from $SECDEF, '20'X in V1.6)
!  All required values are prompted for.  This program represents
!  my way of remembering the way VMS calculates the number of pages
x!  in a process header (in module SYSBOOT) and the size of a slot in
!  the swap file (in module SYSINIT).
@!		Ralph O. Weber 9-JUN-1980

	IMPLICIT INTEGER*4 (A-Z)
l
1	FORMAT ('$'A)
42	FORMAT (I)
3	FORMAT (Z)

`		TYPE 1, 'MAXPROCESSCNT (in decimal):'
		ACCEPT 2, SGN$GW_MAXPRCCT
(


	TYPE 1, 'PROCSECTCNT (in decimal):'

	ACCEPT 2, SGN$GW_MAXPSTCT
T
	TYPE 1, 'WSMAX (in decimal):'
	ACCEPT 2, SGN$GL_MAXWSCNT

	TYPE 1, 'VIRTUALPAGECNT (in decimal):'
H
	ACCEPT 2, SGN$GL_MAXVPGCT

	TYPE 1, 'WSL$C_LENGTH (in hexadecimal):'
t	ACCEPT 3, WSL$C_LENGTH

<	TYPE 1, 'PHD$C_LENGTH (in hexadecimal):'
	ACCEPT 3, PHD$C_LENGTH

h	TYPE 1, 'SEC$C_LENGTH (in hexadecimal):'
	ACCEPT 3, SEC$C_LENGTH
0

	SGN$GL_PTPAGCNT = (SGN$GL_MAXVPGCT*4 + 511) / 512
\
	FIXED_PHD_BYTES = PHD$C_LENGTH + 511
$	WSL_BYTES = SGN$GL_MAXWSCNT * WSL$C_LENGTH
	PRC_SECT_BYTES = SGN$GW_MAXPSTCT * SEC$C_LENGTH
	BASIC_PHD_PAGES = (FIXED_PHD_BYTES + WSL_BYTES + PRC_SECT_BYTES)
P	1		  / 512
	BASIC_PHD_BYTES = (BASIC_PHD_PAGES * 512) + 511

|	PHD_PGS_ARY_BTS = (BASIC_PHD_PAGES + SGN$GL_PTPAGCNT) * 8

D	NONPT_PHD_BYTES = BASIC_PHD_BYTES
10	NONPT_PHD_BYTES = NONPT_PHD_BYTES + PHD_PGS_ARY_BTS
	    PHD_PGS_ARY_BTS = (PHD_PGS_ARY_BTS/512) * 8
p	    IF (PHD_PGS_ARY_BTS.NE.0)  GO TO 10

8	SGN$GL_PHDPAGCT = NONPT_PHD_BYTES / 512

 	SFT$W_SLOTSZ = SGN$GL_MAXWSCNT + SGN$GL_PHDPAGCT
d
	SWAP_FILE_SZ = (SGN$GW_MAXPRCCT - 2) * SFT$W_SLOTSZ
,			!!!!!!!!!!!!!!!!!!!
	!NB. I can use MAXPROCESSCNT-2 because two processes, NULL and
	!    SWAPPER, are mystically created by INIT without aid of
X	!    SYS$CREPRC.  SYS$CREPRC maintains the swap slot counters
	!    and it is unaware of NULL and SWAPPER.  NULL and SWAPPER
 	!    also cannot be swapped under any circumstances.
	!    MAXPROCESSCNT, on the other hand, controls the number of
	!    PCB slots and NULL and SWAPPER do require PCB slots.
L
	TYPE *, 'Swap file size must be at least', SWAP_FILE_SZ,
	1	'blocks.'
x
	STOP
@	END
