$ !************************************************************************
$ !		 PROPERTY OF APPLICON INCORPORATED
$ !                   MODULE HEADER  (DCL Command Procedure)
$ !
$ ! This computer program is the property of Applicon Incorporated, and
$ ! its total or partial disclosure to others, reproduction or transfer
$ ! is prohibited.  This licensed material may not be used except in strict
$ ! compliance with Applicon Incorporated license terms.
$ !
$ !1. Module name:	FORMAT.COM
$ !
$ !2. Function:		ACCEPTS AS A PARAMETER AT INVOKATION A FILE
$ !			SPECIFICATION FOR USE BY FORMATTING PROGRAM
$ !                     FORMAT.EXE.  AUTOMATICALLY ACCEPTS FILES WITHOUT
$ !                     EXTENSIONS AS .PLI FILES.
$ !3. Keywords:	
$ !
$ !4. Facility Name:	
$ !
$ !5. Specification
$ !	5.1 Calling Sequence:	@DBA1:[TOOLS]FORMAT {DISK:}{[DIRECTORY]}FILE-NAME{.EXT}
$ !
$ !	5.2 Input Data:		PL/1 SOURCE PROGRAM PASSED AS PARAMETER
$ !	
$ !	5.3 Output Data:	FORMATTED PLI SOURCE PROGRAM WITH FILE EXTENSION
$ !                             OF .PLI, WITH VERSION NUMBER 1 HIGHER THAN ANY
$ !                             IDENTICALLY NAMED FILE. OUTPUT FILE WILL BE PLACED
$ !                             INTO THE DEFAULT DIRECTORY THEN IN EXISTANCE.
$ !		
$ !	5.4 Side Effects:	OUTPUT FILE IS EDITABLE AND COMPILABLE
$ !
$ !     5.5 Environment:        RUNS UNDER VMS, INVOKES FORMAT.COM
$ !
$ !	5.6 Error Conditions:   PASSING A NONEXISTANT FILE SPECIFICATION CAUSES
$ !                             PROGRAM ABORT.
$ !
$ !6. Module Design:
$ !	6.1 Elements and Submodules: NONE
$ !
$ !	6.2 Data Structures:	     NONE
$ !
$ !7. Construction:	NO COMPILATION NESSECARY
$ !
$ !8. Author and initial date: HOWARD S. CLAYMAN
$ !                            SEPTEMBER, 1980
$ !
$ !9. Revision History:
$ !
$ !       COPYRIGHT 1980 BY APPLICON INCORPORATED, ALL RIGHTS RESERVED
$ !************************************************************************
$ !
$ NAME_SPEC := 'P1
$ DIR_SPEC := ""
$ !
$ !	USE LEXICAL FUNCTIONS TO EXTRACT DISK & DIRECTORY SPECIFICATION, IF USED
$ !     DISK AND DIRECTORY WILL BE "DIR_SPEC", FILE NAME WILL BE "NAME_SPEC".
$ !
$ IF 'F$LENGTH(NAME_SPEC)' .EQ. 'F$LOCATE("]",NAME_SPEC)' THEN GOTO EVALUATE_NAME
$ END_DIR_SPEC = 'F$LOCATE("]",NAME_SPEC) + 1
$ DIR_SPEC := "''F$EXTRACT(0,END_DIR_SPEC,NAME_SPEC)'"
$ NAMELENGTH = 'F$LENGTH(NAME_SPEC)' - 'F$LOCATE("]",NAME_SPEC)'
$ NAME_SPEC := "''F$EXTRACT(END_DIR_SPEC,NAMELENGTH,NAME_SPEC)'"
$ GOTO EVALUATE_NAME
$ !
$ !	CHECK TO SEE IF A FILE EXTENSION WAS EMPLOYED IN THE INPUT NAME_SPEC.
$ !
$ EVALUATE_NAME:
$ IF 'F$LENGTH(NAME_SPEC)' .EQ. 'F$LOCATE(".",NAME_SPEC)' THEN GOTO DEFAULT
$ !
$ !	IF A FILE EXTENSION WAS SPECIFIED, LEXICALS SEPARATE EXTENSION FROM
$ !     FILENAME SO THAT THE PROPER OUTPUT FILE EXTENSION CAN BE APPENDED.
$ !
$ STRINGLENGTH = 'F$LOCATE(".",NAME_SPEC)
$ FILE_NAME := "''F$EXTRACT(0,STRINGLENGTH,NAME_SPEC)'"
$ OUTFILE_SPEC := 'FILE_NAME'.PLI
$ GOTO INVOKE
$ !
$ ! 	IF NO FILE EXTENSION WAS USED, APPEND .LIS TO INPUT NAME_SPEC,
$ !     .FLS AS THE OUTPUT FILE EXTENSION.
$ !
$ DEFAULT:
$ OUTFILE_SPEC := 'NAME_SPEC'.PLI
$ NAME_SPEC := 'NAME_SPEC'.PLI
$ !
$ ! 	ASSIGN THE CONTATENATION OF "DIR_SPEC" AND "NAME_SPEC" TO THE LOGICAL
$ !     NAME "FILESPEC", WHICH IS ACCESSED BY THE FORMATTING PROGRAM FROM THE
$ !     PROCESS LOGICAL NAME TABLE.
$ !
$ INVOKE:
$ DEFINE FILESPEC 'DIR_SPEC''NAME_SPEC'
$ DEFINE OUTFILESPEC 'OUTFILE_SPEC'
$ RUN DBA1:[TOOLS]FORMAT
$ DEASSIGN FILESPEC
$ DEASSIGN OUTFILESPEC
