	integer function delelog (lognam)

C
C  Delete a supervisor state logical name from the process logical name
C  table using CLI call-back.  Similar to DCL DEASSIGN command.
C

	implicit integer (a-z)

	external cli$k_cliserv
	parameter cli$k_delelog = 7

	integer lblk(5)
	byte bblk(20)
	equivalence (lblk(1),bblk(1))

	character*(*) lognam

C
C  Setup arguments for CLI call
C
	lblk(1) = 0
	bblk(1) = %loc(cli$k_cliserv)
	bblk(2) = cli$k_delelog
	call str$trim(lognam,lognam,lblk(2))   ! get length of lognam
	lblk(3) = %loc(lognam)
	lblk(4) = 0
	lblk(5) = 0

	delelog = sys$cli(lblk)
	return
	end


	integer function crealog (lognam, eqlnam)

C
C  Create a supervisor state logical name in the process logical name
C  table using CLI call-back.  Similar to DCL ASSIGN command.
C

	implicit integer (a-z)

	parameter cli$k_crealog = 6
	external cli$k_cliserv
	
	integer lblk(5)
	byte bblk(20)
	equivalence (lblk(1),bblk(1))

	character*(*) lognam, eqlnam

	lblk(1) = 0
	bblk(1) = %loc(cli$k_cliserv)
	bblk(2) = cli$k_crealog
	call str$trim(lognam,lognam,lblk(2))	! get length of lognam
	lblk(3) = %loc(lognam)
	call str$trim(eqlnam,eqlnam,lblk(4))	! get length of eqlnam
	lblk(5) = %loc(eqlnam)

	crealog = sys$cli(lblk)
	return
	end



	program logname

C
C  Test CREALOG and DELELOG
C
	implicit integer (a-z)

	character*63 lognam, eqlnam, type
	external ss$_normal
	integer msgvec(2), retcode
	equivalence (msgvec(2),retcode)

	msgvec(1) = 1
	do while (.true.)

10	  continue
	  type 90000
90000	  format('$Create or Delete? ')
	  read(5,90100,end=999)type
90100	  format(a)
	  call str$upcase(type,type)
	  if (type(1:1) .ne. 'C' .and. type(1:1) .ne. 'D') go to 10

	  type 90001
90001	  format('$Enter logical name: ')
	  read(5,90100,end=999)lognam
	  call str$upcase(lognam,lognam)

	  if (type(1:1) .eq. 'C') then
	    type 90002
90002	    format('$Enter equivalence name: ')
	    read(5,90100,end=999)eqlnam
	    call str$upcase(eqlnam,eqlnam)
	    retcode = crealog(lognam,eqlnam)
	  
	  else 
	    retcode = delelog(lognam)

	  endif

	  if (retcode .ne. %loc(ss$_normal)) call sys$putmsg(msgvec,,)
        end do

999	continue
	end
