C******************************************************************************
	SUBROUTINE AK$COST(COST,PRT_FLAG)
C******************************************************************************
C AKCOST.FOR
C
C  written by:  K. Trumbley
C  date:        May 1984
C
C  Routine to calculate cost of current user in RECORD common area
C	
C  Modified by : M. Serrer	Sept 86
C		- changed connect time rate and cpu time rate variables
C		 to the right variables.
C
C----------------------------------------------------------------------------

	INCLUDE 'AK.INC/NOLIST'
	REAL*4 COST

C----------------------------------------------------------------------------
C_Cost calculation

	IF (PRT_FLAG.EQ.0) THEN
	  COST=0.0
	  COST=FLOAT(AK$P_CON_TIM)/3600. * P_CNT_TIM_RATE + COST
	  COST=FLOAT(AK$N_CON_TIM)/3600. * N_CNT_TIM_RATE + COST
	  COST=FLOAT(AK$P_INT_TIM)/3600. * P_CPU_TIM_RATE + COST
	  COST=FLOAT(AK$N_INT_TIM)/3600. * N_CPU_TIM_RATE + COST
	  COST=FLOAT(AK$P_BAT_TIM)/3600. * P_BAT_TIM_RATE + COST
	  COST=FLOAT(AK$N_BAT_TIM)/3600. * N_BAT_TIM_RATE + COST
	  COST=FLOAT(AK$PRT_PAG)  	 * PRT_PAG_RATE + COST
	  COST=FLOAT(AK$PRT_JOB)  	 * PRT_JOB_RATE + COST
	  COST=FLOAT(AK$VOL_MNT)  	 * VOL_MNT_RATE + COST
	  COST=FLOAT(AK$BUF_IO)/1000.    * BUF_IO_RATE + COST
	  COST=FLOAT(AK$DIR_IO)/1000.    * DIR_IO_RATE + COST
	  COST=FLOAT(AK$PAG_FLT)/1000.   * PAG_FLT_RATE + COST
	  COST=FLOAT(AK$DSK_BLK)/1000.   * DSK_BLK_RATE + COST
	  RETURN
	END IF

C
C  PRT_FLAG is set so print the RATE table
C
	WRITE(OUT_DEV,900) HEADER_STR
 900	FORMAT(//' 	BREAKDOWN OF VAX ACCOUNTING CHARGES'/,
     &	         ' 	-----------------------------------'//,
     &	         '      ',A80,/)
	WRITE(OUT_DEV,1000)	P_CNT_TIM_RATE
 1000	FORMAT(' Prime connect time rate    ($ per hour) : ',F9.2)
	WRITE(OUT_DEV,1010)	N_CNT_TIM_RATE
 1010	FORMAT(' Nonprime connect time rate ($ per hour) : ',F9.2)
	WRITE(OUT_DEV,1020)	P_CPU_TIM_RATE
 1020	FORMAT(' Prime CPU time rate        ($ per hour) : ',F9.2)
	WRITE(OUT_DEV,1030)	N_CPU_TIM_RATE
 1030	FORMAT(' Nonprime CPU time rate     ($ per hour) : ',F9.2)
	WRITE(OUT_DEV,1040)	P_BAT_TIM_RATE
 1040	FORMAT(' Prime BATCH time rate      ($ per hour) : ',F9.2)
	WRITE(OUT_DEV,1050)	N_BAT_TIM_RATE
 1050	FORMAT(' Nonprime BATCH time rate   ($ per hour) : ',F9.2)
	WRITE(OUT_DEV,1060)	PRT_PAG_RATE
 1060	FORMAT(' Printed pages rate         ($ per page) : ',F9.2)
	WRITE(OUT_DEV,1070)	PRT_JOB_RATE
 1070	FORMAT(' Print job adjustment rate   ($ per job) : ',F9.2)
	WRITE(OUT_DEV,1080)	VOL_MNT_RATE
 1080	FORMAT(' Volume mount rate         ($ per mount) : ',F9.2)
	WRITE(OUT_DEV,1090)	BUF_IO_RATE
 1090	FORMAT(' Buffered I/O rate        ($ per K blks) : ',F9.2)
	WRITE(OUT_DEV,1100)	DIR_IO_RATE
 1100	FORMAT(' Direct I/O rate          ($ per K blks) : ',F9.2)
	WRITE(OUT_DEV,1110)	PAG_FLT_RATE
 1110	FORMAT(' Page fault rate          ($ per K flts) : ',F9.2)
	WRITE(OUT_DEV,1120)	DSK_BLK_RATE
 1120	FORMAT(' Disk block storage rate  ($ per K blks) : ',F9.2)
	RETURN
	END
