$!*****************************************************************************
$! AKCOUNT.COM
$!
$!	  Command procedure to submit AKCOUNT'ing
$!
$!	Written by : M. Serrer   DME/NRC  Systems Lab.
$!	           : K. Trumbley DME/NRC  Systems Lab.
$!	Date       : Aug 1984
$!
$!	Modified   : M. Serrer and K. Trumbley,  Feb 1985
$!	for VMS V4.x
$!
$!*****************************************************************************
$!
$!
$	SET NOVERIFY
$	SET DEFAULT SYS$ACCOUNT:
$	C_MODE:='F$MODE()
$	IF C_MODE .EQS. "BATCH" THEN GOTO DO_NORMAL
$	IF P1.NES."" THEN GOTO DO_NORMAL
$	TYPE SYS$INPUT:

   The AKCOUNT software is normally run as a BATCH job but can be run as
an interactive job. The caution which should be exercised concerns the file
SYS$MANAGER:ACCOUNTING.DAT.  The first action of AKCOUNT is to close the
current accounting file and start a new one which may not be what you want
to do interactively. If you answer the following question with a YES, the
AKCOUNT software will be run completely. If you answer NO, AKCOUNT will be
executed with the RESTART parameter characteristics which will submit the
job at its next scheduled time.

$	INQUIRE ANS "Do you really want to run AKCOUNT completely, [YES/NO]"
$	IF ANS.EQS."YES" THEN GOTO DO_NORMAL
$	P1:="RESTART"
$DO_NORMAL:
$	IF P1.EQS."RESTART" THEN GOTO SUBMIT
$	IF P1.EQS."OLD" THEN GOTO OLD_FILE
$	P1:="NORMAL"
$!
$	RENAME SYS$MANAGER:ACCOUNTNG.DAT SYS$ACCOUNT:ACCOUNTNG.OLD
$	SET ACCOUNT/NEW_FILE
$	SET PROT=W:D SYS$ACCOUNT:ACCOUNTNG.OLD;*
$	PURGE/KEEP=3 SYS$ACCOUNT:ACCOUNTNG.OLD
$	SET PROT=(S:RWE,O:RWE,G:RWE,W) SYS$ACCOUNT:ACCOUNTNG.OLD;*
$!
$OLD_FILE:
$SUBMIT:
$!
$!
$! Call AKRUN.COM to do all necessary accounting
$!
$	@SYS$ACCOUNT:AKRUN.COM 'P1'
$!
$! Resubmit AKCOUNT
$!
$	SET NOVERIFY
$	DATE:='F$TIME()'
$	OFFSET=F$LOCATE("-",DATE)
$	YEAR=F$INTEGER('F$EXTRACT(OFFSET+5,4,DATE)')
$	YEAR=YEAR-1
$	TMP_YR:='F$STRING(YEAR)'
$	TMP:='F$EXTRACT(2,2,TMP_YR)'
$	AKCOUNT_FILE="AKCOUNT.Y"+TMP
$!
$	IF AK_FISCAL.EQS."NO" THEN GOTO SKIP
$	OPEN/READ/ERROR=CREATE_FILE DUMMY 'AKCOUNT_FILE'
$	CLOSE DUMMY
$	GOTO SKIP
$CREATE_FILE:
$	RENAME AKCOUNT.TOT 'AKCOUNT_FILE'
$SKIP:
$	SUBMIT/AFTER='AK_DATE' SYS$ACCOUNT:AKCOUNT.COM
$!
$END:
$	SET NOVERIFY
$	EXIT
