C******************************************************************************
	SUBROUTINE DO_PRCDEL
C------------------------------------------------------------------------------
C AKPACKET.FOR
C
C  written by:  M. Serrer
C  date:        March 1984
C
	INCLUDE 'AK.INC/NOLIST'
	INCLUDE 'MK.INC/NOLIST'
	INTEGER*4 CON_TIM
	REAL*4 PRIME_PCT
C
C------------------------------------------------------------------------------
C
	PRCDEL_COUNT=PRCDEL_COUNT+1
C
C_If deleted process was INTERACTIVE then this is LOGOUT record
C
	IF (MK$SUB_TYP.EQ.ACR$K_INTERACTIVE) THEN
	  AK$LOG_CNT=AK$LOG_CNT + 1
	END IF
C
C_Find the CONNECT time and the percentage of time that the process
C_was alive during Prime Time,  PRIME_PCT is a value between (0 - 1) 
C
	CALL AK$PCT_TIM(MK$STA_TIM,MK$SYS_TIM,CON_TIM,PRIME_PCT)
C
C_Increment CONNECT time
C
	AK$P_CON_TIM=AK$P_CON_TIM + CON_TIM*PRIME_PCT
	AK$N_CON_TIM=AK$N_CON_TIM + CON_TIM*(1-PRIME_PCT)
C
C_Increment INTERACTIVE or BATCH CPU time
C_Divide by 100 converts time to seconds
C
	IF (MK$SUB_TYP.EQ.ACR$K_BATCH) THEN
	  AK$P_BAT_TIM=AK$P_BAT_TIM + (MK$CPU_TIM/100)*PRIME_PCT
	  AK$N_BAT_TIM=AK$N_BAT_TIM + (MK$CPU_TIM/100)*(1-PRIME_PCT)
	ELSE
	  AK$P_INT_TIM=AK$P_INT_TIM + (MK$CPU_TIM/100)*PRIME_PCT
	  AK$N_INT_TIM=AK$N_INT_TIM + (MK$CPU_TIM/100)*(1-PRIME_PCT)
	END IF
C
C_Increment STUFF
C
	AK$PAG_FLT=AK$PAG_FLT + MK$PAG_FLT
	AK$VOL_MNT=AK$VOL_MNT + MK$VOL_MNT
	AK$DIR_IO=AK$DIR_IO + MK$DIR_IO
	AK$BUF_IO=AK$BUF_IO + MK$BUF_IO
C
	RETURN

C******************************************************************************
	ENTRY DO_IMGDEL
C------------------------------------------------------------------------------
	IMGDEL_COUNT=IMGDEL_COUNT+1
	RETURN
C
C******************************************************************************
	ENTRY DO_SYSINIT
C------------------------------------------------------------------------------
	SYSINIT_COUNT=SYSINIT_COUNT+1
	RETURN
C
C------------------------------------------------------------------------------
	ENTRY DO_LOGFAIL
C------------------------------------------------------------------------------
	AK$LOG_FAL=AK$LOG_FAL+1
	LOGFAIL_COUNT=LOGFAIL_COUNT+1
	RETURN
C
C------------------------------------------------------------------------------
	ENTRY DO_PRINT
C------------------------------------------------------------------------------
	AK$PRT_JOB=AK$PRT_JOB+1
	AK$PRT_PAG=AK$PRT_PAG + MK$PAG_CNT
	PRINT_COUNT=PRINT_COUNT+1
	RETURN
C
C------------------------------------------------------------------------------
	ENTRY DO_USER
C------------------------------------------------------------------------------
	USER_COUNT=USER_COUNT+1
	RETURN
C
C------------------------------------------------------------------------------
	ENTRY DO_TOTALS
C------------------------------------------------------------------------------
C
	TYPE*,' '
	TYPE 200,ACR$K_PRCDEL,PRCDEL_COUNT
 200	FORMAT(' Process deletes',T30,'(type :',I3,')  =',I7)
	TYPE 210,ACR$K_IMGDEL,IMGDEL_COUNT
 210	FORMAT(' Image deletes',T30,'(type :',I3,')  =',I7)
	TYPE 220,ACR$K_SYSINIT,SYSINIT_COUNT
 220	FORMAT(' System initializations',T30,'(type :',I3,')  =',I7)
	TYPE 230,ACR$K_LOGFAIL,LOGFAIL_COUNT
 230	FORMAT(' Login failures',T30,'(type :',I3,')  =',I7)
	TYPE 240,ACR$K_PRINT,PRINT_COUNT
 240	FORMAT(' Print jobs',T30,'(type :',I3,')  =',I7)
	TYPE 250,ACR$K_USER,USER_COUNT
 250	FORMAT(' User written records',T30,'(type :',I3,')  =',I7)
	TYPE*,' '
C
	RETURN
	END
